/*-
 * Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_trans.c,v 1.207 2025/12/21 19:13:55 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   5
#define RECOBE_COMPAT    6
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/param.h>
#if defined(__FreeBSD_cc_version) && __FreeBSD_cc_version > 599999 /* I do not know exact version */
#include <arpa/inet.h>
#endif
#include <sys/wait.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <poll.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

#define L0 0 /* \0           */
#define Ll 1 /*   */
#define Lb 2 /*        */
#define Ls 3 /*    */
#define Ld 4 /* #            */
#define Lo 5 /*     */
#define Lx 6

#define Ci  0x200000 /*     */
#define Co  0x008000 /*        */
#define Cl  0x004000 /*                 */
#define Cn  0x002000 /*                      */
#define Cf  0x001000 /*               */
#define Cx  0x000400 /*                    */
#define C_state 0xFF /*           */

enum states
{ bg /*                                           */
, bs /*                                                 */
, nq /*     ?                       */
, tc /*                           */
, tb /*        */
, xx
};

static const size_t msz[]           = { 1024, 512, 512};
static const char  *clasnames[]     = { "L0", "Ll", "Lb", "Ls", "Ld", "Lo", "Lx"};
static const char   statenames[][3] = { "bg", "bs", "nq", "tc", "tb", "xx"};

static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "- ", "- ", "Ci", "- ", "- ", "- ", "- ", "- "
, "Co", "Cl", "Cn", "Cf", "- ", "Cx", "- ", "- "
};

static const u_char class[256] =
{ L0, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lb, Ll, Ll,  Lo, Ll, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lb, Lo, Lo, Ld,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Lo,  Lo, Lo, Lo, Ls
, Lo, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Ls,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Ls,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
};

static const babolo_lexor modsel =
/* 0(FF) -                0
 * 1(FE) -                 1
 * 2(FD) -             2
 * 3(FC) -      3
 * 4(FB) -         4
 */
{ (const u_char*)class, NULL, Bpars_AABS, 0x07, 0x07, 1
, { /*00*/ 1, L0,0xFE, Ls,0x03, 0xFF
  , /*03*/ 2, L0,0xFD, Ls,0x03, Lb,0xFB, 0xFC
} };

static u_int32_t automa[xx][Lx] =
/* \0 L0  \n Ll  \b Lb  Ls   # Ld   * Lo   *    @          */
{{ Cx|xx,    bg,    bs,       bs,    nq,    bs }/* bg @                   */
,{ Cx|xx,    bg,    bs,       bs,    bs,    bs }/* bs @                   */
,{ Cx|xx,    bg,    bs, Co|Cl|tc,    bs,    bs }/* nq @ 1           */
,{ Cx|xx, Cn|bs, Cf|tb,    Cl|tc, Cn|bs, Cx|xx }/* tc              */
,{ Cx|xx, Cn|bs,    tb,    Ci|bs, Cn|bs, Cn|bs }/* tb          */
};

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_style(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    size_t            candidate = 0;
    int               lfcount;
    u_int32_t         control;
    mular_descriptor *stlist;
    size_t            offset;
    enum states       state;
    size_t            found     = 0;
    int               cmp       = 0;
    pgoblin_rst      *rst;
    pgoblin_rio      *rin;
    pgoblin_rio      *rct;
    int               ex        = EX_OK;
    int               rs        = 0;
    size_t            d         = 0;
    int               i;
    char             *q;
    u_char            p;
    u_char            s;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+style %08X %c%c%c..%c"
              , exenv->options->flags
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    if  (!rn[PGO_CSTY]) {
        ifBLIN_QX0("Try to change style 0");
        ERROUT(EX_DATAERR, EINVAL);
    }
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!rct->text) {
        ifBLIN_QX2("No pgoblin style name");
        goto out;
    }
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    if  (!rin->text) {
        ifBLIN_QX2("No pgoblin style text");
        goto out;
    }
    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    q = rin->text;
    stlist = rin->stymd;
    if  (!!stlist) {
        for (size_t j = 0; j < MULAR_NEXT(stlist); ++j) {
            offset = *(size_t*)mular_getix(stlist, j);
            cmp = strcmp(&q[offset], (const char *)rct->text);
            ifBLIN_QX3("%s %d %s", &q[offset], cmp, (char*)rct->text);
            if  (!cmp) {
                for (found = offset + 1 + strlen(&q[offset]); Lb == class[q[found] & 0xFF]; ++found) {}
                break;
        }   }
    } else {
        MARK_IO_TEXT_GO(rin);;
        ;;  rin->stymd = mular_create(MULAR_ZERO, 3, sizeof(size_t), msz);
        ;;  MARK_IO_MIFE_GO(rin);;
        ;;  ;;  rin->freemife = 0; /* XXXX */
        ;;  ;;  rin->freetext = 0;
        ;;  MARK_IO_MIFE_WENT(rin);;
        MARK_IO_TEXT_WENT(rin);;
        stlist = rin->stymd;
        if  (!stlist) {
            ifBLIN_QX0("No mem");
            ERROUT(EX_OSERR, ENOMEM);
        }
        blin_stateheader(BLIN_5STO24G, pn);
        lfcount = 1;
        for (state = bg, offset = 0, control = 0; state < xx; offset++, state = control & C_state) {
            if  ((!!rin->binparm || !!rin->length) && (offset >= rin->length)) {
                p = L0;
                s = 0;
            } else {
                s = (u_char)q[offset];
                p = class[s];
                if  (s == '\n') lfcount++;
            }
            control = automa[state][p];
            blin_statebody( BLIN_5STO24G
                          , pn
                          , statenames
                          , clasnames[p]
                          , q
                          , offset
                          , control
                          , state
                          , (u_int32_t)found
                          , (u_char)rs
                          );
            if  ((control & Ci) && !found && !cmp) found = offset;
            if  (control & Co) {
                cmp = 0;
                d = 0;
                candidate = offset;
                q[offset - 1] = '\0';
            }
            if  (control & Cl) {
                cmp |= (((char*)rct->text)[d++] - q[offset]);
            }
            if  (control & Cn) {
                candidate = 0;
            }
            if  (control & Cf) {
                q[offset] = '\0';
                if  ((!rct->binparm && !rct->length) || (d < rct->length)) {
                    cmp |= ((u_char*)rct->text)[d++];
                }
                if  (!!candidate) {
                    size_t *ix;
                    ix = mular_add(stlist);
                    if  (!ix) {
                        ifBLIN_QW0("mular_add");
                        ex = EX_OSERR;
                        goto out;
                    }
                    *ix = candidate;
                }
                candidate = 0;
            }
            if  ((control & Cx) && !found) {
                ifBLIN_QX0("Erroneous style %"BLIN_D, found);
                ERROUT(EX_DATAERR, EINVAL);
    }   }   }
    if  (!!found) {
        for (rs = 0, offset = found; Ls == class[q[offset] & 0xFF]; ++offset) ++rs;
        if  (0 > (i = pgoblin_load(exenv, 5, &q[found], rs))) {
            ifBLIN_QX0("Invalid style interpretor name=%.*s~", rs, &q[found]);
            ERROUT(EX_DATAERR, EINVAL);
        } else {
            MARK_R_STYLE_GO(rst);;
            ;;  rst->flags = (exenv->options->flags & BLIN_MASK) | (u_int8_t)i;
            MARK_R_STYLE_WENT(rst);;
            if  ((ex = pgoblin_st_parser(rst, &q[found + (size_t)rs]))) {
                ifBLIN_QX0("style parser fail");
            }
            if  (exenv->options->flags & PGOBLIN_VERIFY) {
                pgoblin_rio   *rou;
                FILE          *ouf;

                GET_RIO(rou, exenv->options, rn[PGO_COUT]);
                if  (!(ouf = pgoblin_io_funopen(rou))) {
                    ifBLIN_QW0("funopen on %d", rn[PGO_COUT]);
                    ex = EX_IOERR;
                    goto out;
                }
                pgoblin_st_dump(rst, ouf);
            }
            goto out;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_exec(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    char        **argv = NULL;
    pgoblin_rio  *rct;
    pgoblin_rjb  *rjb;
    int           ex   = EX_OK;
    int           i;
    ssize_t       g    = 0;
    int           c;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+exec %c%c%c.%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    if  (exenv->options->flags & PGOBLIN_FORK_WAIT) {
        ifBLIN_QX2("sleep %us in fork", exenv->options->flags & PGOBLIN_FORK_WAIT);
        sleep(exenv->options->flags & PGOBLIN_FORK_WAIT);
    }
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    g = (ssize_t)pgoblin_db_resinfo(rct, PGOBLIN_Nfields);
    if  ((0 > g) || (0 > rct->cortege)) {
        ERROUT(EX_PROTOCOL, EDOOFUS);
    }
    if  (!!g && !(argv = malloc(((size_t)g + 1) * sizeof(char**)))) {
        ERROUT(EX_OSERR, ENOMEM);
    }
    for (i = 0, c = 0; c < g; c++) {
        if  (!(pgoblin_db_valinfo(rct, PGOBLIN_IsNull, rct->cortege, c))) {
            argv[i++] = pgoblin_db_getvalue(rct, rct->cortege, c);
    }   }
    if  (!!i) {
        int eex;
        argv[i] = NULL;
        eex = pgoblin_jb_jxec(exenv, rn, argv);
        if  (eex) {
            ifBLIN_QO0 {
                int z;

                ifBLIN_QX0("Exec error on %d", rn[PGO_CJOB]);
                for (z = 0; argv[z]; z++) ifBLIN_QX0("[%d]=%s~", z, argv[z]);
            }
            if  (eex < 0) {
                if  (eex  < ex) ex = eex;
            } else if (ex >= 0) {
                if  (eex > ex) ex = eex;
    }   }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_fork(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rjb   *rjb;
    int            ex       = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+fork %c%c%c.%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    /* if  (R_JOB) XXXX?? */
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    ex = pgoblin.jobtable[rjb->flags & PGOBLIN_DB_TYPE]->jork(exenv, rn);
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_wait(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rjb *rjb;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+wait ....%c.", pgoblin_regn[rn[PGO_CJOB]]);
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    /* if  (R_JOB) XXXX?? */
    ex = pgoblin_jb_jait(exenv, rjb);
    MARK_R_JOB_GO(rjb);;
    ;;  rjb->dead = (u_int32_t)MULAR_NEXT(rjb->pids);
    MARK_R_JOB_WENT(rjb);;
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_call(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_UNAVAILABLE;

    ifBLIN_QX3( "+call ......");
    ifBLIN_QX3("- %d", ex);
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_eval(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int64_t        cortfrom = -1;
    pgoblin_tuple *command;
    pgoblin_exenv *nexenv;
    int64_t        corto    = 0;
    pgoblin_rio   *rct;
    pgoblin_rio   *rin;
    int            ex       = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+eval .%c%c...", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CIN]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    nexenv = rct->oxenv;
    if  (!nexenv) {
        if  (!(nexenv = calloc(1, sizeof(pgoblin_exenv)))) {
            ifBLIN_QW0("no mem for nexenv");
            ex = EX_OSERR;
            goto out;
        }
        nexenv->options = exenv->options;
        nexenv->flags = exenv->flags & BLIN_MASK;
        nexenv->stat = exenv;
        ex = pgoblin_parser( exenv->options
                           , rct->freetext ? rct->text : NULL
                           , rct->text
                           , (ssize_t)rct->length
                           , &nexenv->pgm
                           , 0
                           , NULL
                           );
        if  (!!ex) {
            ifBLIN_QW0("Parser failed in #eval");
            goto out;
        }
        if  (!rn[PGO_CCTL]) {
            MARK_IO_TEXT_GO(rct);;
            ;;  rct->text = NULL;
            ;;  rct->oxenv = NULL;
            ;;  rct->length = 0;
            MARK_IO_TEXT_WENT(rct);;
        } else {
            MARK_IO_TEXT_GO(rct);;
            ;;  rct->oxenv = nexenv;
            MARK_IO_TEXT_WENT(rct);;
        }
        if  (!!rct->freetext) nexenv->pgm->flags |= PGOBLIN_FREETEXT;
        if  (nexenv->options->flags & PGOBLIN_VERIFY) pgoblin_Vdump(nexenv->options, nexenv->pgm);
    }
    nexenv->dyna = exenv;
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    if  (!!rn[PGO_CIN] && (0 > rin->cortege)) {
        cortfrom = 0;
        corto = pgoblin_db_resinfo(rin, PGOBLIN_Ntuples);
    }
    for (int64_t i = cortfrom; i < corto; i++) {
        MARK_IO_TEXT_GO(rin);;
        ;;  if  (0 <= cortfrom) rin->cortege = (ssize_t)i;
        MARK_IO_TEXT_WENT(rin);;
        if  ((ex = pgoblin_execute(nexenv->options, nexenv->pgm, nexenv->dyna, nexenv->stat, 0))) {
            if  (!(command = mular_getix(nexenv->pgm->code, nexenv->ppoint))) {
                ifBLIN_QW0("mular_getix %u", nexenv->ppoint);
                ex = EX_SOFTWARE;
                goto out;
            }
            ifBLIN_QX0( "cmd[%u]=%03X(%s %c%c%c%c%c%c) %08X Executor failed in #eval"
                      , nexenv->ppoint
                      , command->cmd
                      , pgoblin.a[command->cmd & PGOBLIN_COMMAND].str
                      , pgoblin_regn[rn[0]]
                      , pgoblin_regn[rn[1]]
                      , pgoblin_regn[rn[2]]
                      , pgoblin_regn[rn[3]]
                      , pgoblin_regn[rn[4]]
                      , pgoblin_regn[rn[5]]
                      , pgoblin.a[command->cmd & PGOBLIN_COMMAND].flags
                      );
    }   }
    MARK_IO_TEXT_GO(rin);;
    ;;  if  (0 <= cortfrom) rin->cortege = -1;
    MARK_IO_TEXT_WENT(rin);;
    if  (!rn[PGO_CCTL]) pgoblin_dexenv(&nexenv);
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_begin(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rdb  *rdb;
    pgoblin_rio  *rct = NULL;
    pgoblin_nr    nct = 0;
    int           ex  = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (!rn[PGO_CCTL]) {
        nct = PGOBLIN_REGSIZE - 1;
        if  (!(rct = pgoblin_pushio(exenv, nct))) {
            ifBLIN_QW0("No CTL reg -");
            ex = -EX_CANTCREAT;
            goto out;
        }
        if  (!rdb->intran) {
            MARK_IO_TEXT_GO(rct);;
            ;; rct->text = "BEGIN;";
            MARK_IO_TEXT_WENT(rct);;
        }
    } else {
        nct = rn[PGO_CCTL];
        GET_RIO(rct, exenv->options, nct);
    }
    ifBLIN_QX3( "+begin %c%c.%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[nct]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    MARK_R_CONN_GO(rdb);;
    ;; rdb->intran++;
    MARK_R_CONN_WENT(rdb);;
    if  (!!rct->text) {
        MARK_R_CONN_GO(rdb);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        ;;  rdb->flags |= PGOBLIN_CR_OK;
        MARK_R_CONN_WENT(rdb);;
        ex = pgoblin_db_query(exenv, (pgoblin_nr[]){rn[PGO_COUT], nct, 0, rn[PGO_CCON], 0, 0});
        if  (!!ex) {
            ifBLIN_QW0("query=%s~", rct->text);
    }   }
out:
    if  (nct == (PGOBLIN_REGSIZE - 1)) pgoblin_popio(exenv->options, nct);
    MARK_R_CONN_GO(rdb);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_WENT(rdb);;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_end(pgoblin_exenv *exenv, pgoblin_nr *rn) {                 /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rdb  *rdb;
    pgoblin_rio  *rct = NULL;
    pgoblin_nr    nct = 0;
    int           ex  = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (!rdb->intran) {
        ifBLIN_QX0("Non transaction end");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!rn[PGO_CCTL]) {
        nct = PGOBLIN_REGSIZE - 1;
        if  (!(rct = pgoblin_pushio(exenv, nct))) {
           ifBLIN_QW0("No CTL reg -");
           ex = -EX_CANTCREAT;
           goto out;
        }
        if  (1 == rdb->intran) {
            MARK_IO_TEXT_GO(rct);;
            ;; rct->text = "END;";
            MARK_IO_TEXT_WENT(rct);;
        }
    } else {
        nct = rn[PGO_CCTL];
        GET_RIO(rct, exenv->options, nct);
    }
    MARK_R_CONN_GO(rdb);;
    ;; rdb->intran--;
    MARK_R_CONN_WENT(rdb);;
    ifBLIN_QX3( "+end %c%c.%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[nct]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    if  (!!rct->text) {
        MARK_R_CONN_GO(rdb);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        ;;  rdb->flags |= PGOBLIN_CR_OK;
        MARK_R_CONN_WENT(rdb);;
        ex = pgoblin_db_query(exenv, (pgoblin_nr[]){rn[PGO_COUT], nct, 0, rn[PGO_CCON], 0, 0});
        if  (!!ex) {
            ifBLIN_QW0("query=%s~", rct->text);
    }   }
out:
    if  (nct == (PGOBLIN_REGSIZE - 1)) pgoblin_popio(exenv->options, nct);
    MARK_R_CONN_GO(rdb);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_WENT(rdb);;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_rollbk(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rdb  *rdb;
    pgoblin_rio  *rct = NULL;
    pgoblin_nr    nct = 0;
    int           ex  = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (!rdb->intran) {
        ifBLIN_QX0("Non transaction end");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!rn[PGO_CCTL]) {
        nct = PGOBLIN_REGSIZE - 1;
        if  (!(rct = pgoblin_pushio(exenv, nct))) {
           ifBLIN_QW0("No CTL reg -");
           ex = -EX_CANTCREAT;
           goto out;
        }
        MARK_IO_TEXT_GO(rct);;
        ;; rct->text = "ROLLBACK;";
        MARK_IO_TEXT_WENT(rct);;
    } else {
        nct = rn[PGO_CCTL];
        GET_RIO(rct, exenv->options, nct);
    }
    MARK_R_CONN_GO(rdb);;
    ;; rdb->intran--;
    MARK_R_CONN_WENT(rdb);;
    ifBLIN_QX3( "+rollback %c%c.%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[nct]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    if  (!!rct->text) {
        MARK_R_CONN_GO(rdb);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        ;;  rdb->flags |= PGOBLIN_CR_OK;
        MARK_R_CONN_WENT(rdb);;
        ex = pgoblin_db_query(exenv, (pgoblin_nr[]){rn[PGO_COUT], nct, 0, rn[PGO_CCON], 0, 0});
        if  (!!ex) {
            ifBLIN_QW0("query=%s~", rct->text);
    }   }
    exenv->flags |= PGOBLIN_ROLLBACK;
out:
    if  (nct == (PGOBLIN_REGSIZE - 1)) pgoblin_popio(exenv->options, nct);
    MARK_R_CONN_GO(rdb);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_WENT(rdb);;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_listen(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int64_t             timeout;
    char               *notify;
    pgoblin_longnotify *lnote;
    int64_t             itime;
    pgoblin_rdb        *rdb;
    pgoblin_rio        *rct;
    int64_t             now;
    pgoblin_rio        *rou;
    pgoblin_rio        *rin;
    int                 ex = EX_OK;
    pgoblin_dbases     *db;
    struct timeval      t;
    int                 e;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+listen %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    if  (!rin->text || (rin->length < sizeof(int64_t))) {
        ifBLIN_QX1(" IN[%d]: no timeout", rn[PGO_CIN]);
    } else {
        /* Should be 64 bit time wait to in usec from 1970-01-01 00:00:00 UTC          *
         * (date_part('epoch', t) * 1000000)::int8                                     *
         * , where t - time wait to                                                    *
         *******************************************************************************/
        itime = (int64_t)recobe_loadM(rin->text, "76543210");
        GET_CON(rdb, exenv->options, rn[PGO_CCON]);
        db = DBASE(rdb->flags);
        for (; !ex;) {
            if  (gettimeofday(&t, NULL)) {
        ;       ifBLIN_QW0("gettimeofday:");
        ;       ex = EX_OSERR;
        ;       break;
        ;   }
        ;   now = (int64_t)1000000LL * t.tv_sec + t.tv_usec;
        ;   timeout = (itime - now + 999) / 1000;
        ;   if  ((timeout) <= 0) {
        ;       ifBLIN_QX0("tarry notime");
        ;       break;
        ;   } else if (timeout > exenv->options->maxtmout) {
        ;       timeout = exenv->options->maxtmout;
        ;   } else if (timeout > 0x000000007FFFFFFFLL) {
        ;       timeout = 0x7FFFFFFF;
        ;   }
        ;   ifBLIN_QX3("LISTEN=%s~ for %d ms", (char*)rct->text, (int)timeout);
        ;   e = pgoblin_db_tarry(rdb, (int)timeout);
        ;   if  (0 > e) {
        ;       ifBLIN_QW0("tarry error");
        ;       ex = e;
        ;       break;
        ;   } else if (!e) {
        ;       if  (!db->erconn) {
        ;           ifBLIN_QX1("tarry timeout");
        ;       } else {
        ;           ifBLIN_QX1("tarry timeout: %s", pgoblin_db_erconn(rdb));
        ;       }
        ;       break;
        ;   }
        ;   if  (PGOBLIN_LONGNOTIFY & db->flags) {
        ;       for (e = 0; !!(lnote = pgoblin_db_notifies(rdb));) {
        ;           ifBLIN_QX3( "Received NOTIFY=%s~ mess=%s~ other=%s from %d"
                              , lnote->tail
                              , &lnote->tail[lnote->majorlen]
                              , &lnote->tail[lnote->majorlen + lnote->minorlen]
                              , lnote->ident
                              );
        ;           if  (!rct->text) {
        ;               e = 1;
        ;           } else {
        ;               e = !strcmp(lnote->tail, rct->text);
        ;           }
        ;           if  (!!e) break;
        ;       }
        ;       if  ((!lnote) && (!!errno)) {
        ;           ifBLIN_QW1("notifies %d", e);
        ;       } else if ((!!lnote) && !!rn[PGO_COUT]) {
                    const char   *tail[3];
                    char          pid[8];

        ;           GET_RIO(rou, exenv->options, rn[PGO_COUT]);
        ;           tail[0] = lnote->tail;
        ;           tail[1] = &lnote->tail[lnote->majorlen];
        ;           if  (8 < snprintf(pid, 8, "%d", lnote->ident)) {
        ;               ifBLIN_QX1("Short space for notify ident");
        ;           }
        ;           tail[2] = pid;
        ;           MARK_IO_PQ_GO(rou);;
        ;           ;;  if  (!!(ex = pgoblin_db0_create(exenv, rou, 3, tail, NULL))) {
        ;           ;;      ifBLIN_QW0("pgoblin_db0_create");
        ;           ;;      goto out;
        ;           ;;  }
        ;           ;;  rou->parmask |= PGOBLIN_PQRESULT;
        ;           MARK_IO_PQ_WENT(rou);;
        ;       }
        ;       if  (!!lnote) pgoblin_db_denote(rdb, (void**)&lnote);
        ;   } else {
        ;       for (e = 0; !!(notify = pgoblin_db_notifies(rdb));) {
        ;           ifBLIN_QX3("Received NOTIFY=%s~", notify);
        ;           if  (!rct->text) {
        ;               e = 1;
        ;           } else {
        ;               e = !strcmp(notify, rct->text);
        ;           }
        ;           pgoblin_db_denote(rdb, (void**)&notify);
        ;   }   }
            if  (e) break;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_connect(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    u_int32_t    nwflags = PGOBLIN_PARMIN;
    pgoblin_rdb *rdb;
    pgoblin_rio *rct;
    int          ex      = EX_OK;
    int          i;
    char        *q;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+connect .%c.%c..", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CCON]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!(q = rct->text)) {
        ifBLIN_QX1("Empty DB #1");
        goto out;
    }
    switch(babolo_goword(&modsel, (const char **)&q)) {
    case 0 : ifBLIN_QX0("Illegal DB");
           ; ERROUT(EX_DATAERR, EINVAL);
    case 1 : ifBLIN_QX1("Empty DB #2");
           ; goto out;
    case 3 : ifBLIN_QX1("Illegal DB separator");
           ; *--q = '\0';
           ; BLIN_FALLTHROUGH;
    case 2 : q = NULL;
           ; break;
    case 4 : *--q = '\0';
           ; q++;
           ; break;
    default: ifBLIN_QX0("Internal error");
           ; ERROUT(EX_SOFTWARE, EINVAL);
    }
    ifBLIN_QX3("db=%s%s%s~", (char*)rct->text, q ? "~\nparm=" : "", q ? q : "");
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (0 > (i = pgoblin_load(exenv, 3, rct->text, -1))) {
        ifBLIN_QX0("Invalid DBMS name %s", (char*)rct->text);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!!q && !!rct->freetext) {
        if  (!(q = strdup(q))) {
            ifBLIN_QX0("pgoblin_connect: no mem");
            ERROUT(EX_OSERR, ENOMEM);
        }
        nwflags |= PGOBLIN_PARMFREE;
    }
    MARK_R_CONN_GO(rdb);;
    ;;  rdb->flags = (exenv->options->flags & BLIN_MASK) | nwflags | (u_int8_t)i;
    ;;  rdb->dbname = q;
    MARK_R_CONN_WENT(rdb);;
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_job(pgoblin_exenv *exenv, pgoblin_nr *rn) {                 /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    u_int32_t    nwflags = 0;
    u_int32_t    svflags;
    babolo_opts *bos     = NULL;
    pgoblin_rjb *rjb;
    pgoblin_rio *rct;
    int          ex      = EX_OK;
    babolo_parm *bp;
    u_int32_t    u       = 0;
    int          c;
    const char  *p;
    char        *q;
    int          i;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+job .%c..%c.", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CJOB]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!(q = rct->text)) {
        ifBLIN_QX1("Empty JOB #1");
        goto out;
    }
    switch(babolo_goword(&modsel, (const char **)&q)) {
    case 0 : ifBLIN_QX0("Illegal JOB");
           ; ERROUT(EX_DATAERR, EINVAL);
    case 1 : ifBLIN_QX1("Empty JOB #2");
           ; goto out;
    case 3 : ifBLIN_QX1("Illegal JOB separator");
           ; *--q = '\0';
           ; BLIN_FALLTHROUGH;
    case 2 : q = NULL;
           ; break;
    case 4 : *--q = '\0';
           ; q++;
           ; break;
    default: ifBLIN_QX0("Internal error");
           ; ERROUT(EX_SOFTWARE, EINVAL);
    }
    ifBLIN_QX3("job=%s%s%s~", (char*)rct->text, q ? "~\nparm=" : "", q ? q : "");
    if  (0 > (i = pgoblin_load(exenv, 4, rct->text, -1))) {
        ifBLIN_QX0("Invalid job module name %s", rct->text);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!!q) {
        ifBLIN_QX4("opt=%s~", q);
        if  (!(bp = babolo_getparm(Bpars_NOEN | Bpars_NOAL, &q, "", 0))) {
            ifBLIN_QW0("babolo_getparm");
            ex = EX_SOFTWARE;
            goto out;
        }
        if  (!(bos = babolo_openopts(exenv->options->flags & BLIN_MASK, 0))) {
            ifBLIN_QW0("babolo_openopts");
            ex = EX_SOFTWARE;
            goto out;
        }
        if  (babolo_setopts(bos, 0, bp->argc, bp->argv, "zZ")) {
            ifBLIN_QW0("babolo_setopts");
            ex = EX_SOFTWARE;
            goto out;
        }
        while (0 < (c = babolo_getopts(bos))) {
            switch (c) {
            case 'z': nwflags |= (nwflags & PGOBLIN_ERROR_SENSOR) << 1;
                    ; nwflags |= PGOBLIN_ERROR_SENSOR;
                    ; break;
            case 'Z': nwflags &= ~(PGOBLIN_ERROR_SENSIB | PGOBLIN_ERROR_SENSOR);
                    ; break;
            default : ifBLIN_QX0("Illegal job flag");
        }   }
        ifBLIN_QX3("nwflags=%08X", nwflags);
        if  ((p = babolo_getargs(bos)) && *p) {
            errno = 0;
            u = (u_int32_t)strtoul(p, NULL, 0);
            if  (errno) {
                ifBLIN_QW0("No num =%s~", p);
                u = 0;
    }   }   }
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    if  ((rjb->flags & PGOBLIN_JOB_TYPE) == i) {
        svflags = rjb->flags & ~(BLIN_MASK | PGOBLIN_ERROR_SENSIB | PGOBLIN_ERROR_SENSOR);
        MARK_R_JOB_GO(rjb);;
        ;;  rjb->flags = (exenv->options->flags & BLIN_MASK) | svflags | nwflags;
        ;;  rjb->concur = u;
        MARK_R_JOB_WENT(rjb);;
    } else {
        ex = JOBE(rjb->flags)->jose(exenv, rn);
        MARK_R_JOB_GO(rjb);;
        ;;  mular_destroy(rjb->pids);
        ;;  rjb->pids = NULL;
        ;;  rjb->host = NULL;
        ;;  rjb->concur = u;
        ;;  rjb->dead = 0;
        ;;  rjb->flags = (exenv->options->flags & BLIN_MASK) | nwflags | (u_int8_t)i;
        MARK_R_JOB_WENT(rjb);;
        ifBLIN_QW0("Close JOB in #job");
    }
    pgoblin_jb_jpen(exenv, rn, bos);
    if  (bos) babolo_closeopts(bos);
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_out(pgoblin_exenv *exenv, pgoblin_nr *rn) {                 /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rio *rct;
    pgoblin_rio *rou;
    int          ex    = EX_OK;
    int          i;
    char        *q;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+ %c%c%c.%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!(q = rct->text)) {
        ifBLIN_QX1("Empty OUT #1");
        goto out;
    }
    switch(babolo_goword(&modsel, (const char **)&q)) {
    case 0 : ifBLIN_QX0("Illegal OUT");
           ; ERROUT(EX_DATAERR, EINVAL);
    case 1 : ifBLIN_QX1("Empty OUT #2");
           ; goto out;
    case 3 : ifBLIN_QX1("Illegal OUT separator");
           ; *--q = '\0';
           ; BLIN_FALLTHROUGH;
    case 2 : q = NULL;
           ; break;
    case 4 : *--q = '\0';
           ; q++;
           ; break;
    default: ifBLIN_QX0("Internal error");
           ; ERROUT(EX_SOFTWARE, EINVAL);
    }
    ifBLIN_QX3("out=%s%s%s~", (char*)rct->text, q ? "~ parm=" : "", q ? q : "");
    if  (0 > (i = pgoblin_load(exenv, 1, rct->text, -1))) {
        ifBLIN_QX0("Invalid io module name %s", rct->text);
        ERROUT(EX_DATAERR, EINVAL);
    }
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    MARK_R_CONN_GO(rou);;
    ;;  rou->flags = (exenv->options->flags & BLIN_MASK) | (u_int8_t)i;
    ;;  rou->path = q;
    ;;  ex = pgoblin_io_oprep(exenv, rn);
    MARK_R_CONN_WENT(rou);;
    if  (!!ex) ifBLIN_QX0("pgoblin_io_oprep");
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
