/*-
 * Copyright (C)2002..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_select.c,v 1.137 2024/07/14 00:00:02 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

const char *
/**********************************************************************
 **                                                                  **/
pgoblin_decond(BLIN_flag cond) {                                    /**
 **                                                                  **
 **********************************************************************/
    static const char *ret[] = {"OK", "TUPL", "OUT", "IN", "SSEL", "BSEL", "BTUPL", "unkn"};
    u_int i;

    i = cond & PGOBLIN_CR_MASK;
    if  (i > PGOBLIN_CR_MAX) i = PGOBLIN_CR_MAX;
    return(ret[i >> PGOBLIN_CR_SHIFT]);
}

static int
/**********************************************************************
 **                                                                  **/
presel(pgoblin_exenv *exenv, pgoblin_nr *rn, BLIN_flag cond) {      /**
 **                                                                  **
 **********************************************************************/
    pgoblin_rdb  *rdb  = NULL;
    pgoblin_rio  *rou  = NULL;
    pgoblin_rio  *rct;
    ssize_t       row;
    ssize_t       col;
    pgoblin_rio  *rin;
    pgoblin_rio  *rio  = NULL;
    int           ex   = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if (rct->text) ifBLIN_QX3(" =%s", (char*)rct->text);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (!(rio = pgoblin_pushio(exenv, PGOBLIN_REGSIZE - 1))) {
       ifBLIN_QW0("No IO reg -");
       ex = -EX_CANTCREAT;
       goto out;
    }
    MARK_R_CONN_GO(rdb);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    ;;  rdb->flags |= cond;
    MARK_R_CONN_WENT(rdb);;
    if  ((rct->parmask & PGOBLIN_PQRESULT) && !!rct->pq) {
        ssize_t ctupc; /*   CTL  ctupc */

        ctupc = (ssize_t)pgoblin_db_resinfo(rct, PGOBLIN_Ntuples);
        ifBLIN_QX5("CTLNtuples=%zd", ctupc);
        for (ssize_t ctupn = 0; ctupn < ctupc; ++ctupn) {
            MARK_IO_TEXT_GO(rct);;
        ;   ;;  if  (!!rct->text && !!rct->freetext) {
        ;   ;;      free(rct->text);
        ;   ;;      rct->text = NULL;
        ;   ;;  }
        ;   ;;  ex = (int)pgoblin_st0_tbl(exenv, rn[PGO_CCTL], ctupn, -3);
        ;   ;;  if  (0 > ex) {
        ;   ;;      ifBLIN_QW0("No STYLE 0");
        ;   ;;      goto out;
        ;   ;;  }
        ;   ;;  rct->freetext = 1;
        ;   MARK_IO_TEXT_WENT(rct);;
        ;   ex = 0;
        ;   if  (  !!rn[PGO_CIN]
                && !!rin->pq
                && !!(col = (ssize_t)pgoblin_db_resinfo(rct, PGOBLIN_Nfields))
                ) {
        ;       /*   IN */
        ;       ifBLIN_QX5( "INfields=%"BLIN_O"d INtuples=%"BLIN_O"d"
                          , pgoblin_db_resinfo(rin, PGOBLIN_Nfields)
                          , pgoblin_db_resinfo(rin, PGOBLIN_Ntuples)
                          );
        ;       if  (!(row = (ssize_t)pgoblin_db_resinfo(rin, PGOBLIN_Ntuples))) {
        ;           MARK_IO_PQ_GO(rou);;
        ;           ;;  rou->pq = pgoblin_db00(exenv);
        ;           ;;  rou->parmask |= PGOBLIN_PQRESULT;
        ;           ;;  rou->freepqre = 1;
        ;           ;;  rou->cortege = -1;
        ;           MARK_IO_PQ_WENT(rou);;
        ;           goto out;
        ;       }
        ;       ifBLIN_QX4("%zd rows x %zd cols", row, col);
        ;       if  (DBASE(rdb->flags)->flags & PGOBLIN_DB_PREPARE) {
        ;           ex = pgoblin_db_prepare(exenv, rn);
        ;           if  (!!ex) {
        ;               ifBLIN_QX0( "%s: prepare=%s"
                                  , pgoblin_decond(cond)
                                  , pgoblin_db_erinfo(rou)
                                  );
        ;               MARK_IO_PQ_GO(rou);;
        ;               ;;  pgoblin_db_clear(rou);
        ;               MARK_IO_PQ_WENT(rou);;
        ;               ERROUT(EX_SOFTWARE, EDOOFUS);
        ;           }
        ;           MARK_IO_PQ_GO(rou);;
        ;           ;;  ex = pgoblin_db_prexec(exenv, rn);
        ;           MARK_IO_PQ_WENT(rou);;
        ;       } else {
        ;           MARK_IO_PQ_GO(rou);;
        ;           ;;  ex = pgoblin_db_execute(exenv, rn);
        ;           MARK_IO_PQ_WENT(rou);;
        ;       }
        ;       if  (!!ex) {
        ;           ifBLIN_QX0( "%s: execute Q=%s"
                              , pgoblin_decond(cond)
                              , pgoblin_db_erinfo(rou)
                              );
        ;           MARK_IO_PQ_GO(rou);;
        ;           ;;  pgoblin_db_clear(rou);
        ;           MARK_IO_PQ_WENT(rou);;
        ;           ERROUT(EX_SOFTWARE, EDOOFUS);
        ;       }
        ;       ifBLIN_QX6("ctupn %"BLIN_D" to ctupc %"BLIN_D, ctupn, ctupc);
        ;       if  (  (ctupn + 1 < ctupc)
                    || ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT])
                    ) {
        ;           MARK_IO_PQ_GO(rou);;
        ;           pgoblin_db_clear(rou);
        ;           MARK_IO_PQ_WENT(rou);;
        ;       } else {
        ;           MARK_IO_PQ_GO(rou);;
        ;           ;;  if  (rou->pq) {
        ;           ;;      rou->parmask |= PGOBLIN_PQRESULT;
        ;           ;;      rou->freepqre = 1;
        ;           ;;  }
        ;           ;;  rou->cortege = -1;
        ;           MARK_IO_PQ_WENT(rou);;
        ;       }
        ;   } else {
        ;       if  ((ex = pgoblin_db_query(exenv, rn))) {
        ;           ifBLIN_QX0( "%s: query=%s"
                              , pgoblin_decond(cond)
                              , pgoblin_db_erinfo(rou)
                              );
        ;           MARK_IO_PQ_GO(rou);;
        ;           ;;  pgoblin_db_clear(rou);
        ;           MARK_IO_PQ_WENT(rou);;
        ;           ERROUT(EX_SOFTWARE, EDOOFUS);
        ;       }
        ;       if  (  (ctupn + 1 < ctupc)
                    || ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT])
                    ) {
        ;           MARK_IO_PQ_GO(rou);;
        ;           ;;  pgoblin_db_clear(rou);
        ;           MARK_IO_PQ_WENT(rou);;
        ;       } else {
        ;           MARK_IO_PQ_GO(rou);;
        ;           ;;  if  (rou->pq) {
        ;           ;;      rou->parmask |= PGOBLIN_PQRESULT;
        ;           ;;      rou->freepqre = 1;
        ;           ;;  }
        ;           ;;  rou->cortege = -1;
                    MARK_IO_PQ_WENT(rou);;
        }   }   }
    } else if (!rct->text) {
        ifBLIN_QX1("pgoblin_select: No query");
    } else if (!rn[PGO_CIN] || !rin->pq) {
        /*   */
        ifBLIN_QX5("0 0");
        if  (!!(ex = pgoblin_db_query(exenv, rn))) {
            ifBLIN_QX0("ex %d %s: query=%s", ex, pgoblin_decond(cond), pgoblin_db_erinfo(rou));
            MARK_IO_PQ_GO(rou);;
            ;;  pgoblin_db_clear(rou);
            MARK_IO_PQ_WENT(rou);;
            ERROUT(EX_SOFTWARE, EDOOFUS);
        }
        if  ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT]) {
            MARK_IO_PQ_GO(rou);;
            ;;  pgoblin_db_clear(rou);
            MARK_IO_PQ_WENT(rou);;
        } else {
            MARK_IO_PQ_GO(rou);;
            ;;  if  (rou->pq) {
            ;;      rou->parmask |= PGOBLIN_PQRESULT;
            ;;      rou->freepqre = 1;
            ;;  }
            ;;  rou->cortege = -1;
            MARK_IO_PQ_WENT(rou);;
        }
    } else if ((rdb->flags & PGOBLIN_DB_TYPE) == pgoblin_load(exenv, 3, "0", -1)) {
        /*   DB 0 */
        if (rct->text) ifBLIN_QX5(" =%s", (char*)rct->text);
        MARK_IO_PQ_GO(rou);;
        ;;  ex = pgoblin_db_execute(exenv, rn);
        MARK_IO_PQ_WENT(rou);;
        if  (!!ex) {
            ifBLIN_QX0( "%d:%s: execute 0=%s"
                      , ex
                      , pgoblin_decond(cond)
                      , pgoblin_db_erinfo(rou)
                      );
            MARK_IO_PQ_GO(rou);;
            ;;  pgoblin_db_clear(rou);
            MARK_IO_PQ_WENT(rou);;
            ERROUT(EX_SOFTWARE, EDOOFUS);
        }
        if  ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT]) {
            MARK_IO_PQ_GO(rou);;
            ;;  pgoblin_db_clear(rou);
            MARK_IO_PQ_WENT(rou);;
        } else {
            MARK_IO_PQ_GO(rou);;
            ;;  if  (rou->pq) {
            ;;      rou->parmask |= PGOBLIN_PQRESULT;
            ;;      rou->freepqre = 1;
            ;;  }
            ;;  rou->cortege = -1;
            MARK_IO_PQ_WENT(rou);;
        }
    } else {
        ifBLIN_QX5( "INfields=%"BLIN_O"d INtuples=%"BLIN_O"d"
                  , pgoblin_db_resinfo(rin, PGOBLIN_Nfields)
                  , pgoblin_db_resinfo(rin, PGOBLIN_Ntuples)
                  );
        if  (!(row = (ssize_t)pgoblin_db_resinfo(rin, PGOBLIN_Ntuples))) {
            MARK_IO_PQ_GO(rou);;
            ;;  rou->pq = pgoblin_db00(exenv);
            ;;  rou->parmask |= PGOBLIN_PQRESULT;
            ;;  rou->freepqre = 1;
            ;;  rou->cortege = -1;
            MARK_IO_PQ_WENT(rou);;
            goto out;
        }
        ifBLIN_QX4("%zd rows", row);
        if  (DBASE(rdb->flags)->flags & PGOBLIN_DB_PREPARE) {
            if  ((ex = pgoblin_db_prepare(exenv, rn))) {
                ifBLIN_QX0( "%s: prepare=%s"
                          , pgoblin_decond(cond)
                          , pgoblin_db_erinfo(rio)
                          );
                MARK_IO_PQ_GO(rou);;
                ;;  pgoblin_db_clear(rou);
                MARK_IO_PQ_WENT(rou);;
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            MARK_IO_PQ_GO(rou);;
            ;;  ex = pgoblin_db_prexec(exenv, rn);
            MARK_IO_PQ_WENT(rou);;
            if  (!!ex) {
                ifBLIN_QX0( "%s: execute Q=%s"
                          , pgoblin_decond(cond)
                          , pgoblin_db_erinfo(rou)
                          );
                MARK_IO_PQ_GO(rou);;
                ;;  pgoblin_db_clear(rou);
                MARK_IO_PQ_WENT(rou);;
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            if  ((PGOBLIN_CR_OK != cond) || !!rn[PGO_COUT]) {
                MARK_IO_PQ_GO(rou);;
                ;;  if  (rou->pq) {
                ;;      rou->parmask |= PGOBLIN_PQRESULT;
                ;;      rou->freepqre = 1;
                ;;  }
                ;;  rou->cortege = -1;
                MARK_IO_PQ_WENT(rou);;
            }
        } else {
            MARK_IO_PQ_GO(rou);;
            ;;  ex = pgoblin_db_execute(exenv, rn);
            MARK_IO_PQ_WENT(rou);;
            if  (!!ex) {
                ifBLIN_QX0( "%s: execute Q=%s"
                          , pgoblin_decond(cond)
                          , pgoblin_db_erinfo(rou)
                          );
                MARK_IO_PQ_GO(rou);;
                ;;  pgoblin_db_clear(rou);
                MARK_IO_PQ_WENT(rou);;
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            if  ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT]) {
                MARK_IO_PQ_GO(rou);;
                ;;  pgoblin_db_clear(rou);
                MARK_IO_PQ_WENT(rou);;
            } else {
                MARK_IO_PQ_GO(rou);;
                ;;  if  (rou->pq) {
                ;;      rou->parmask |= PGOBLIN_PQRESULT;
                ;;      rou->freepqre = 1;
                ;;  }
                ;;  rou->cortege = -1;
                MARK_IO_PQ_WENT(rou);;
    }   }   }
out:
    if  (!!rio) {
        MARK_IO_PQ_GO(rio);;
        ;;  pgoblin_popio(exenv->options, PGOBLIN_REGSIZE - 1);
        MARK_IO_PQ_WENT(rio);;
    }
    if  (!!rdb) {
        MARK_R_CONN_GO(rdb);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        MARK_R_CONN_WENT(rdb);;
    }
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_perform(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+perform %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    ex = presel(exenv, rn, PGOBLIN_CR_OK);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_select(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+select %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    ex = presel(exenv, rn, PGOBLIN_CR_TUPL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_binpre(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+binpresel %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    ex = presel(exenv, rn, PGOBLIN_CR_BTUPL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_display(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rst *rst;
    ssize_t      ex = EX_SOFTWARE;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+display %c.%c..%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    ex = pgoblin_st_table(exenv, rn, 0, -2);
    if  (ex < 0) ifBLIN_QX0("pgoblin_display: write error");
out:
    ifBLIN_QX3("- %"BLIN_D, ex);
    return((ex < 0) ? (int)ex : 0);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
sel(pgoblin_exenv *exenv, pgoblin_nr *rn, BLIN_flag cond) {         /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_nr   rrnn[pgoblin.symparam];
    int          err;
    pgoblin_rdb *rdb  = NULL;
    pgoblin_rst *rst;
    pgoblin_rio *rou;
    pgoblin_rio *rct;
    int          ex   = 0;
    ssize_t      e    = 0;
    ssize_t      k;
    size_t       i;
#   define       aim  (INT_MAX / 2)
#   define       aid                                                                                  \
    ((PGOBLIN_BUFMULT * PGOBLIN_BUFSIZE > (aim / 4)) ? (aim / 4) : (PGOBLIN_BUFMULT * PGOBLIN_BUFSIZE))

    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    bcopy(rn, rrnn, sizeof(rrnn));
    rrnn[PGO_CIN] = rn[PGO_COUT];
    if  (!rct->text) {
        ifBLIN_QX0("pgoblin_strsel: No query");
        ERROUT(EX_DATAERR, EINVAL);
    }
    MARK_IO_PQ_GO(rou);;
    ;;  rou->cortege = -1;
    MARK_IO_PQ_WENT(rou);;
    MARK_R_CONN_GO(rdb);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    ;;  rdb->flags |= cond;
    MARK_R_CONN_WENT(rdb);;
    if  ((ex = pgoblin_db_query(exenv, rn))) goto out;
    for (k = 0, i = 1; ; ) {
        ssize_t typn;

        MARK_IO_PQ_GO(rou);;
        ;;  if  ((ex = pgoblin_db_getstream(exenv, rn, (int)i))) goto out;
        MARK_IO_PQ_WENT(rou);;
        typn = (ssize_t)pgoblin_db_resinfo(rou, PGOBLIN_Ntuples);
        e = pgoblin_st_table(exenv, rrnn, k, typn ? -1 : -2);
        if  ((e < 0) || (typn <= 0)) break;
        k += typn;
        ifBLIN_QX3("e=%zd=>%zd aim=%d i %zu => ", typn, e, aim, i);
        if  (e < (aim * 2)) {
            if  (i < (aid / 2)) i = i * 2; else i = aid;
        } else if (e < aim) {
            if  (i < (aid / aim * (size_t)e)) i = i / (size_t)e * aim; else i = aid;
        } else if ((e / 2) > aim) {
            i = i / 4;
        } else if (e > aim) {
            i = i / (size_t)e * aim;
        }
        ifBLIN_QX3("%zu", i);
    }
    pgoblin_db_clear(rou);
    if  (e < 0) ifBLIN_QX0("pgoblin_strsel: write error");
out:
    err = errno;
    /* XXXX END      ? */
    if  (!!rdb) {
        ex = pgoblin_db_endstream(exenv, rn);
        MARK_R_CONN_GO(rdb);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        MARK_R_CONN_WENT(rdb);;
    }
    ifBLIN_QX3( "- %s %"BLIN_D
              , (cond == PGOBLIN_CR_SSEL)
              ? "pgoblin_strsel"
              : (cond == PGOBLIN_CR_BSEL) ? "pgoblin_binsel" : "pgoblin_???sel"
              , (e < 0) ? e : ex
              );
    if  (!errno) errno = err;
    return((e < 0) ? (int)e : ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_strsel(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;

    ifBLIN_QX3( "+strselect %c%c.%c.%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CCON]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    ex = sel(exenv, rn, PGOBLIN_CR_SSEL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_binsel(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;

    ifBLIN_QX3( "+binselect %c%c.%c.%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CCON]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    ex = sel(exenv, rn, PGOBLIN_CR_BSEL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
}
