/*-
 * Copyright (C)2004..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2004..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_file.c,v 1.142 2025/02/06 23:46:46 babolo Exp $"

#define BLIN_COMPAT        4
#define Bpars_COMPAT       4
#define MULAR_COMPAT       0
#define MIFE_COMPAT        5
#define PGOBLIN_COMPAT     5
#define PGOBLIN_INTERNAL

#include <sys/param.h>
#include <sys/types.h>
#include <sys/event.h>
#include <sys/user.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <errno.h>
#include <stdio.h>
#include <fts.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

#ifndef BLIN_4STA24E
# define BLIN_4STA24E ((blin_statectl){{4, 0, 8, 24, '\n', 5, 1, 0, 0}})
#endif

static const char statenames[][3] =
{ "bg", "cp", "be", "cq", "qq", "xx"};

enum states
{ bg /*                                      */
, cp /*                  */
, be /*                        */
, cq /*                    */
, qq /*                         */
, xx
};

static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "- ", "Ct", "Cd", "Cb", "Cp", "Cn", "- ", "Cq"
, "- ", "- ", "- ", "- ", "Cx", "- ", "- ", "- "
};

#define Ct  0x400000 /* \t                                 */
#define Cd  0x200000 /*            */
#define Cb  0x100000 /*             */
#define Cp  0x080000 /*      */
#define Cn  0x040000 /*                     */
#define Cq  0x010000 /*   ++                */
#define Cx  0x000800 /*                           */
#define C_state 0xFF /*                  */

static const char clasnames[][3] =
{ "L0", "Ll", "Lb", "Ls", "Lq", "Lc", "Lo", "Lx"};

#define L0 0 /* \0                                         */
#define Ll 1 /*                                 */
#define Lb 2 /*                                      */
#define Ls 3 /*                                */
#define Lq 4 /* "                                          */
#define Lc 5 /* ,                                          */
#define Lo 6 /*                                   */
#define Lx 7

static const char clasi[257] =
{ L0
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lb, Ll, Ls,  Lo, Ls, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lb, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
};

static u_int32_t automa[xx][Lx] =
/*    \0 L0     \n Ll  \b Lb x Ls         " Lq      ; Lc         * Lo  *    */
{{       xx, Cn|Cb|bg,    bg,  bg,          cq, Ct|Cb|bg,       Cp|cp}/* bg */
,{ Cn|Cb|xx, Cn|Cb|bg, Cq|be,  cp,          cp, Ct|Cb|bg,       Cp|cp}/* cp */
,{ Cn|Cb|xx, Cn|Cb|bg,    be,  be, Cd|Cb|Cp|cp, Ct|Cb|bg, Cd|Cb|Cp|cp}/* be */
,{    Cx|xx,    Cp|cq, Cp|cq,  cq,          qq,    Cp|cq,       Cp|cq}/* cq */
,{ Cn|Cb|xx, Cn|Cb|bg,    be,  qq,       Cp|cq, Ct|Cb|bg,          cp}/* qq */
};

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getcsv(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    u_int32_t    control;
    char         class[257];
    enum states  state;
    char        *cont;
    int          coln;
    int          max = 0;
    pgoblin_rio *rou;
    pgoblin_rio *rct;
    pgoblin_rio *rin;
    int          ex  = EX_OK;
    FILE        *fi  = NULL;
    int          rs;
    ssize_t      l;
    u_char       p;
    int          s;
    u_char      *t;
    u_char       c;
    u_char       q;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getcsv %c%c%c..."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              );
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    c = ';';
    q = '\"';
    if  (!!(t = rct->text) && !!t[0]) {
        c = t[0];
        q = t[1];
        errno = 0;
        if  (!!q && !!t[2]) max = (int)strtoul((char*)&(t[2]), NULL, 0);
        if  (errno) {
            ifBLIN_QW0("strtol=%s~", (char *)rct->text);
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  (max < 0) {
            ifBLIN_QX0("strtol %d<0", max);
            ERROUT(EX_DATAERR, EINVAL);
    }   }
    bcopy(clasi, class, 257);
    class[c + 1] = Lc;
    class[q + 1] = Lq;
    if  (!(fi = pgoblin_io_funopen(rou))) {
        ifBLIN_QW0("funopen #0 on %d", rn[PGO_COUT]);
        ex = EX_IOERR;
        goto out;
    }
    blin_stateheader(BLIN_4STA24E, pn);
    for ( state = bg, control = 0, coln = 0, rs = 0, l = 0
        ; state < xx
        ; state = control & C_state
        ) {
        if  ((l = pgoblin_io_read(rin, 1, mife_offset(rin->mife) + l)) < 0) {
            ifBLIN_QW0("pgoblin_io_read");
            ex = EX_IOERR;
            break;
        }
        if  (!(cont = mife_pointer(rin->mife))) {
            ifBLIN_QW0("mife_pointer");
            ex = EX_IOERR;
            break;
        }
        if  (!!l) {
            l = 1;
            s = *cont & 0xFF;
        } else {
            s = -1;
        }
        p = (u_char)(class[s + 1]);
        control = automa[state][p];
        blin_statebody( BLIN_4STA24E
                      , pn
                      , statenames
                      , clasnames[(u_char)p]
                      , cont
                      , BLIN_I(cont)
                      , control
                      , state
                      , (u_int32_t)rs
                      , (u_char)coln
                      );
        if  (control & Ct) {
            if  ((++coln < max || !max) && (0 > fputc('\t', fi))) {
                ifBLIN_QW0("fputc");
                ex = EX_IOERR;
                goto out;
        }   }
        if  (control & Cd) {
            for (;rs && (coln <= max || !max); rs--) {
                if  (0 > fputc(' ', fi)) {
                    ifBLIN_QW0("fputc");
                    ex = EX_IOERR;
                    goto out;
        }   }   }
        if  (control & Cb) rs = 0;
        if  (control & Cp) {
            if  (coln <= max || !max) {
                switch (s) {
                case '\\':
                    if  (0 > fprintf(fi, "\\\\")) {
                        ifBLIN_QW0("fprintf");
                        ex = EX_IOERR;
                        goto out;
                    }
                    break;
                case '\0':
                    if  (0 > fprintf(fi, "\\0")) {
                        ifBLIN_QW0("fprintf");
                        ex = EX_IOERR;
                        goto out;
                    }
                    break;
                case '\t':
                    if  (0 > fprintf(fi, "\\t")) {
                        ifBLIN_QW0("fprintf");
                        ex = EX_IOERR;
                        goto out;
                    }
                    break;
                case '\n':
                    if  (0 > fprintf(fi, "\\n")) {
                        ifBLIN_QW0("fprintf");
                        ex = EX_IOERR;
                        goto out;
                    }
                    break;
                default  :
                    if  (0 > fputc(s, fi)) {
                        ifBLIN_QW0("fputc");
                        ex = EX_IOERR;
                        goto out;
        }   }   }   }
        if  (control & Cn) {
            for (;++coln < max;) {
                if  (0 > fprintf(fi, "\t\\N")) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
            }   }
            if  (0 > fprintf(fi, "\n")) {
                ifBLIN_QW0("fprintf");
                ex = EX_IOERR;
                goto out;
            }
            coln = 0;
        }
        if  (control & Cq) rs++;
        if  (control & Cx) {
            ifBLIN_QX0("syntax");
            errno = EINVAL;
            ex = EX_DATAERR;
    }   }
    if  ((~exenv->options->flags & PGOBLIN_COPEND_NOGEN) && (0 > fprintf(fi, "\\.\n"))) {
        ifBLIN_QW0("fprintf fun");
        ex = EX_IOERR;
        goto out;
    }
out:
    if  (0 > pgoblin_io_funclose(rou)) {
        ifBLIN_QW0("io_funclose on %d", rn[PGO_COUT]);
        ex = EX_IOERR;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_echo(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rio *rct;
    pgoblin_rio *rou;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+ %c%c...%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  (!rct->text) {
        MARK_IO_TEXT_GO(rou);;
        ;;  rou->text = NULL;
        ;;  rou->length = 0;
        ;;  rou->parmask &= ~PGOBLIN_TEXTPARM;
        ;;  rou->binparm = 0;
        ;;  rou->freetext = 0;
        MARK_IO_TEXT_WENT(rou);;
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    if  (rn[PGO_CSTY]) {
        char *tmpo;

        tmpo = pgoblin_st_get(exenv, rn);
        if  (tmpo) {
            MARK_IO_TEXT_GO(rou);;
            ;;  rou->text = tmpo;
            ;;  rou->length = strlen(rou->text);
            ;;  rou->parmask |= PGOBLIN_TEXTPARM;
            ;;  rou->binparm = 0;
            ;;  rou->freetext = 1;
            MARK_IO_TEXT_WENT(rou);;
        } else {
            MARK_IO_TEXT_GO(rou);;
            ;;  rou->text = NULL;
            ;;  rou->length = 0;
            ;;  rou->parmask &= ~PGOBLIN_TEXTPARM;
            ;;  rou->binparm = 0;
            ;;  rou->freetext = 0;
            MARK_IO_TEXT_WENT(rou);;
            ifBLIN_QX1( "No const STY %c CTL %c=%s~"
                      , pgoblin_regn[rn[PGO_CSTY]]
                      , pgoblin_regn[rn[PGO_CCTL]]
                      , rct->text
                      );
        }
    } else if (rn[PGO_COUT] != rn[PGO_CCTL]) {
        if  (!rct->freetext) {
            MARK_IO_TEXT_GO(rou);;
            ;;  rou->text = rct->text;
            ;;  rou->length = rct->length;
            ;;  rou->binparm = rct->binparm;
            ;;  rou->parmask |= PGOBLIN_TEXTPARM;
            ;;  rou->freetext = 0;
            MARK_IO_TEXT_WENT(rou);;
        } else {
            MARK_IO_TEXT_GO(rou);;
            ;;  if  (!(rou->text = malloc(rct->length + 1))) {
            ;;      ifBLIN_QX0("No mem #echo #2");
            ;;      ERROUT(EX_OSERR, ENOMEM);
            ;;  } else {
            ;;      rou->length = rct->length;
            ;;      bcopy(rct->text, rou->text, rct->length);
            ;;      ((u_char*)rou->text)[rou->length] = '\0'
            ;;      rou->binparm = 0;
            ;;      rou->parmask |= PGOBLIN_TEXTPARM;
            ;;      rou->freetext = 1;
            ;;  }
            MARK_IO_TEXT_WENT(rou);;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
pgoblin_filecat(pgoblin_exenv *exenv, pgoblin_nr *rn, uint over) {  /**
 **                                                                  **
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rst *rst;
    pgoblin_rio *rct;
    pgoblin_rio *rou;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+cat %c%c...%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (rn[PGO_CSTY]) {
        if  (!rct->text) {
            ifBLIN_QX0("No rct->text");
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  (!!rct->binparm) {
            ifBLIN_QX0("BINPARM rct->text");
            ERROUT(EX_DATAERR, EINVAL);
        }
        MARK_IO_PATH_GO(rou);;
        ;;  rou->path = pgoblin_st_get(exenv, rn);
        ;;  if  (rou->path) {
        ;;      rou->fileover = over;
        ;;      rou->parmask |= PGOBLIN_PATHPARM;
        ;;      rou->freepath = 1;
        ;;  } else {
        ;;      rou->parmask &= ~PGOBLIN_PATHPARM;
        ;;      rou->fileover = over;
        ;;      rou->freepath = 0;
        ;;      ifBLIN_QX0("No rou->path");
        ;;      ERROUT(EX_DATAERR, EINVAL);
        ;;  }
        MARK_IO_PATH_WENT(rou);;
    } else if (!rct->text) {
        MARK_IO_PATH_GO(rou);;
        ;;  rou->path = rct->text;
        ;;  rou->parmask &= ~PGOBLIN_PATHPARM;
        ;;  rou->fileover = over;
        ;;  rou->freepath = 0;
        MARK_IO_PATH_WENT(rou);;
    } else if (!!rct->freetext) {
        MARK_IO_PATH_GO(rou);;
        ;;  if  (!(rou->path = strdup(rct->text))) {
        ;;      ifBLIN_QX0("No mem #file");
        ;;      ERROUT(EX_OSERR, ENOMEM);
        ;;  } else {
        ;;      rou->fileover = over;
        ;;      rou->parmask |= PGOBLIN_PATHPARM;
        ;;      rou->freepath = 1;
        ;;  }
        MARK_IO_PATH_WENT(rou);;
    } else {
        MARK_IO_PATH_GO(rou);;
        ;;  rou->path = rct->text;
        ;;  rou->fileover = over;
        ;;  rou->parmask |= PGOBLIN_PATHPARM;
        ;;  rou->freepath = 0;
        MARK_IO_PATH_WENT(rou);;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_file(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    return(pgoblin_filecat(exenv, rn, 1));
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_cat(pgoblin_exenv *exenv, pgoblin_nr *rn) {                 /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    return(pgoblin_filecat(exenv, rn, 0));
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getdir(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    u_int32_t    mode;
    ssize_t      ncol;
    pgoblin_rjb *rjb;
    pgoblin_dir *dir;
    ssize_t      max;
    pgoblin_rio *rou = NULL;
    pgoblin_rio *rct;
    pgoblin_rio *rin;
    int          ex  = EX_OK;
    FILE        *fi  = NULL;
    ssize_t      i   = 0;
    char const  *s;
    char        *q;
    ssize_t      k;
    ssize_t      m;
    ssize_t      j;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getdir %c%c%c.%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    if  (!rct->text) {
        ifBLIN_QX0("No CTL Pt");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!rin->pq) {
        ifBLIN_QX0("No IN Pq");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!(fi = pgoblin_io_funopen(rou))) {
        ifBLIN_QW0("funopen #1 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
        goto out;
    }
    mode = (u_int32_t)strtoul(rct->text, &q, 0);
    max = (ssize_t)pgoblin_db_resinfo(rin, PGOBLIN_Ntuples);
    ncol = (ssize_t)pgoblin_db_resinfo(rin, PGOBLIN_Nfields);
    for (i = 0; i < max; ++i)  {
        ifBLIN_QX3(" %zd @ %zd : %zd", i, max, ncol);
        switch (ncol) {
        case 0 : ifBLIN_QX1("Null name in getdir %d", rn[PGO_CCTL]);
               ; goto out;
        case 1 : q = pgoblin_db_getvalue(rin, i, 0);
               ; ifBLIN_QX3("1Dir=%s~", q);
               ; break;
        default: for (j = 0, k = 0; j < ncol; j++) {
               ;     if  (!pgoblin_db_valinfo(rin, PGOBLIN_IsNull, i, j)) {
               ;         k += pgoblin_db_valinfo(rin, PGOBLIN_Length, i, j);
               ; }   }
               ; if  (!k) {
               ;     ifBLIN_QX1("Empty name in getdir %d", rn[PGO_CCTL]);
               ;     goto out;
               ; }
               ; if  (!(q = malloc((size_t)k + 1))) {
               ;     ifBLIN_QW0("No mem %zd", k + 1);
               ;     ex = EX_OSERR;
               ;     goto out;
               ; }
               ; for (j = 0, k = 0; j < ncol; j++) {
               ;     if  (!pgoblin_db_valinfo(rin, PGOBLIN_IsNull, i, j)) {
               ;         m = pgoblin_db_valinfo(rin, PGOBLIN_Length, i, j);
               ;         bcopy(pgoblin_db_getvalue(rin, i, j), &(q[k]), (size_t)m);
               ;         k += m;
               ;         q[k] = '\0';
               ; }   }
               ; ifBLIN_QX3("NDir=%s~", q);
        }
        for (dir = NULL; (dir = JOBE(rjb->flags)->jdir(exenv, dir, q));) {
            if  (q && (ncol > 1)) free(q);
            if  (!(q = malloc(strlen(dir->ent) * 2 + 2))) {
                ifBLIN_QW0("");
                ex = EX_OSERR;
                goto out;
            }
            if  (0 > (m = pgoblin_onecopy(q, dir->ent, -1, 0))) {
                ifBLIN_QW0("pgoblin_onecopy");
                ex = EX_SOFTWARE;
                goto out;
            }
            q[--m] = '\0';
            s = "";
            if  (mode & 0x01) {
                if  (0 > fprintf(fi, "%d", dir->i)) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                }
                s = "\t";
            }
            if  (mode & 0x02) {
                if  (0 > fprintf(fi, "%s%s", s, q)) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                }
                s = "\t";
            }
            if  (mode & 0x04) {
                if  (dir->sb) {
                    ex = fprintf(fi, "%s%lld", s, (long long)dir->sb->st_size);
                } else {
                    ex = fprintf(fi, "%s\\N", s);
                }
                if  (0 > ex) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                } else {
                    ex = EX_OK;
                }
                s = "\t";
            }
            if  (mode & 0x08) {
                if  (dir->sb) {
                    ex = fprintf(fi, "%s%u", s, dir->sb->st_mode);
                } else {
                    ex = fprintf(fi, "%s\\N", s);
                }
                if  (0 > ex) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                } else {
                    ex = EX_OK;
                }
                s = "\t";
            }
            if  (mode & 0x10) {
                if  (dir->sb) {
                    ex = fprintf(fi, "%s%u", s, dir->sb->st_uid);
                } else {
                    ex = fprintf(fi, "%s\\N", s);
                }
                if  (0 > ex) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                } else {
                    ex = EX_OK;
                }
                s = "\t";
            }
            if  (mode & 0x20) {
                if  (dir->sb) {
                    ex = fprintf(fi, "%s%u", s, dir->sb->st_gid);
                } else {
                    ex = fprintf(fi, "%s\\N", s);
                }
                if  (0 > ex) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                } else {
                    ex = EX_OK;
                }
                s = "\t";
            }
            if  (0 > fprintf(fi, "\n")) {
                ifBLIN_QW0("fprintf");
                ex = EX_IOERR;
                goto out;
            }
            free(q);
	    q = NULL;
    }	}
    if  ((~exenv->options->flags & PGOBLIN_COPEND_NOGEN) && (0 > fprintf(fi, "\\.\n"))) {
        ifBLIN_QW0("fprintf fun");
        free(q);
        ex = EX_IOERR;
        goto out;
    }
out:
    if  (0 > pgoblin_io_funclose(rou)) {
        ifBLIN_QW0("io_funclose on %d", rn[PGO_COUT]);
        ex = EX_IOERR;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getopt(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    BLIN_flag    flopt = 0;
    babolo_opts *bos   = NULL;
    pgoblin_rjb *rjb;
    pgoblin_rio *rou   = NULL;
    pgoblin_rio *rct;
    FILE        *fi    = NULL;
    int          ex    = EX_OK;
    char       **av    = NULL;
    u_int64_t    ai    = 0;
    const char  *o;
    const char  *q;
    char         z;
    int          s;
    int          c;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+ %c%c..%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX0("No CTL Pt");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!(fi = pgoblin_io_funopen(rou))) {
        ifBLIN_QW0("funopen on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
        goto out;
    }
    switch(*q) {
    case '0':
        break;
    case '1':
        flopt = Bpars_NONU;
        break;
    default:
        ifBLIN_QX0("Ill flag %c(%02X)", *q, *q & 0x00FF);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (' ' != q[1]) {
        ifBLIN_QX0( "No space in CTL=%.*s~"
                  , (int)(!!rct->binparm ? rct->length : strlen(q))
                  , q
                  );
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!!exenv->options->deargs) {
        ai = MULAR_NEXT(exenv->options->deargs);
        if  (!(av = calloc((unsigned int)ai + 1, sizeof(char *)))) {
            ifBLIN_QW0("no RAM");
            ex = EX_OSERR;
            goto out;
        }
        for (u_int64_t i = 0; i < ai; ++i) {
            if  (!(av[i] = *(char**)(mular_getix(exenv->options->deargs, (size_t)i)))) {
                ifBLIN_QW0("mular_getix %"BLIN_O"u", i);
                ex = EX_OSERR;
                goto out;
            }
            ifBLIN_QX5("[%"BLIN_O"u]=%s~", i, av[i]);
        }
        if  (!(bos = babolo_openopts(Bpars_SYME | Bpars_ESYM | Bpars_EPRM, 'Z'))) {
            ifBLIN_QW0("babolo_openopts");
            ex = EX_SOFTWARE;
            goto out;
        }
        if  (babolo_setopts(bos, flopt, (int)ai, av, &q[2])) {
            ifBLIN_QW0("babolo_setopts");
            ex = EX_SOFTWARE;
            goto out;
        } else if (babolo_chopts(bos, flopt, &q[2])) {
            ifBLIN_QW0("babolo_chopts");
            ex = EX_SOFTWARE;
            goto out;
        }
        for (int i = 0; !!(c = babolo_getopts(bos)); ++i) {
            if  (0 > c) {
                ifBLIN_QW0( "babolo_getopts -%c(%02X)"
                          , bos->c
                          , bos->c & 0x00FF
                          );
                ex = EX_USAGE;
                goto out;
            }
            if  (0 > fprintf(fi, "%d\t", i)) {
                ifBLIN_QW0("fprintf");
                ex = EX_IOERR;
                goto out;
            }
            switch((s = pgoblin_onecsym((char)c))) {
            case -1:
                errno = EINVAL;
                ex = EX_USAGE;
                goto out;
            case 0:
                if  (0 > fprintf(fi, "%c", c)) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                }
                break;
            default:
                if  (0 > fprintf(fi, "\\%c", s)) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
            }   }
            switch(bos->next->opts[c]) {
            case 0:
                if  (0 > fprintf(fi, "\t\\N\n")) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                }
                break;
            case 1:
                if  (0 > fprintf(fi, "\t{}\n")) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                }
                break;
            default:
                if  (0 > fprintf(fi, "\t")) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
                }
                z = '{';
                for (int j = 1, l = 0, m = bos->next->opts[c]; j < m; ++j) {
                    if  (!!l) {
                        if  (0 > fprintf(fi, "%cNULL", z)) {
                            ifBLIN_QW0("fprintf");
                            ex = EX_IOERR;
                            goto out;
                        }
                    } else if (!(o = babolo_getoptsarg(bos))) {
                        ifBLIN_QW1("No -%c[%d] arg", c, j - 1);
                        if  (0 > fprintf(fi, "%cNULL", z)) {
                            ifBLIN_QW0("fprintf");
                            ex = EX_IOERR;
                            goto out;
                        }
                        l++;
                    } else {
                        if  (0 > fprintf(fi, "%c\"", z)) {
                            ifBLIN_QW0("fprintf");
                            ex = EX_IOERR;
                            goto out;
                        }
                        for (int k = 0; !!o[k]; ++k) {
                            switch((s = pgoblin_onecsym(o[k]))) {
                            case -1:
                                errno = EINVAL;
                                ex = EX_USAGE;
                                goto out;
                            case 0:
                                if  (0 > fprintf(fi, "%c", o[k])) {
                                    ifBLIN_QW0("fprintf");
                                    ex = EX_IOERR;
                                    goto out;
                                }
                                break;
                            case '\\':
                                if  (0 > fprintf(fi, "\\\\\\\\")) {
                                    ifBLIN_QW0("fprintf");
                                    ex = EX_IOERR;
                                    goto out;
                                }
                                break;
                            default:
                                if  (0 > fprintf(fi, "\\\\%c", s)) {
                                    ifBLIN_QW0("fprintf");
                                    ex = EX_IOERR;
                                    goto out;
                        }   }   }
                        if  (0 > fprintf(fi, "\"")) {
                            ifBLIN_QW0("fprintf");
                            ex = EX_IOERR;
                            goto out;
                    }   }
                    z = ',';
                }
                if  (0 > fprintf(fi, "}\n")) {
                    ifBLIN_QW0("fprintf");
                    ex = EX_IOERR;
                    goto out;
    }   }   }   }
    if  ((~exenv->options->flags & PGOBLIN_COPEND_NOGEN) && (0 > fprintf(fi, "\\.\n"))) {
        ifBLIN_QW0("fprintf fun");
        ex = EX_IOERR;
        goto out;
    }
out:
    free(av);
    if  (bos) babolo_closeopts(bos);
    if  (0 > pgoblin_io_funclose(rou)) {
        ifBLIN_QW0("io_funclose on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
