/*-
 * Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_ctl.c,v 1.2 2025/01/19 20:59:14 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     4
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   5
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_close(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rdb   *rdb;

    ifBLIN_QX3( "+eval %c.%c%c.%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    if  (rn[PGO_CCON]) {
        GET_CON(rdb, exenv->options, rn[PGO_CCON]);
        MARK_R_CONN_GO(rdb);;
        ;;  rdb->flags &= ~PGOBLIN_CLOSECONN;
        MARK_R_CONN_WENT(rdb);;
    }
out:
    ifBLIN_QX3("- %d", EX_OK);
    return(EX_OK);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_clear(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    ifBLIN_QX3( "+eval %c...%c%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CJOB]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    ifBLIN_QX3("- %d", EX_OK);
    return(EX_OK);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_untrap(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    ifBLIN_QX3("+untrap ......");
    exenv->flags &= ~PGOBLIN_TRAPDEF;
    ifBLIN_QX3("- %d", EX_OK);
    return(EX_OK);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_trap(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    ifBLIN_QX3("+trap ......");
    exenv->ctrap = exenv->ppoint + 1;
    exenv->flags |= PGOBLIN_TRAPDEF;
    exenv->lexlevel++;
    ifBLIN_QX3("- %d", EX_OK);
    return(EX_OK);
}

__attribute__((__noreturn__)) static void
/**********************************************************************
 **                                                                  **/
exitfin(pgoblin_exenv *exenv, pgoblin_nr *rn, int ex) {             /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rdb *rdb0;
    pgoblin_rdb *rdb;
    pgoblin_nr   g;
    pgoblin_nr   f;
    pgoblin_nr   t;

    GET_CON(rdb0, exenv->options, 0);
    f = 0;
    t = pgoblin.regsize;
    if  (rn[PGO_CCON]) {
        f = rn[PGO_CCON];
        t = f + 1;
    }
    for (g = f; g < t; g++) {
        rdb = pgoblin_mecon(exenv->options, g);
        if  (!!rdb) {
            if  (!rn[PGO_CCON] || (g == rn[PGO_CCON])) {
                MARK_R_CONN_GO(rdb);;
                ;;  if  (rdb->flags & PGOBLIN_CLOSECONN) pgoblin_db_finish(rdb);
                ;;  rdb->conn = NULL;
                ;;  if  (rdb->flags & PGOBLIN_PARMFREE) free(rdb->dbname);
                ;;  rdb->dbname = NULL;
                ;;  rdb->flags = rdb0->flags & PGOBLIN_DB_TYPE;
                ;;  rdb->host = NULL;
                ;;  rdb->port = NULL;
                ;;  rdb->username = NULL;
                ;;  rdb->intran = 0;
                MARK_R_CONN_WENT(rdb);;
            } else {
                MARK_R_CONN_GO(rdb);;
                ;;  rdb->flags &= ~PGOBLIN_CLOSECONN;
                MARK_R_CONN_WENT(rdb);;
    }   }   }
out:
    ifBLIN_QX3("pgoblin exit %d", ex);
    exit(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_return(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    int ex = EX_OK;

    ifBLIN_QX3("+return ...%c..", pgoblin_regn[rn[PGO_CCON]]);
    if  (exenv->flags & PGOBLIN_FORKED) exitfin(exenv, rn, ex);
    exenv->flags |= PGOBLIN_END;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_exit(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rct;
    int          ex = EX_OK;

    ifBLIN_QX3("+exit .%c.%c..", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CCON]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (rct->text) {
        ex = (int)strtol(rct->text, NULL, 0);
    }
    exitfin(exenv, rn, ex);
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pusho(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rio *rct;
    int          ex = EX_OK;
    pgoblin_nr   i  ;
    char        *q  ;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+pusho .%c...%c", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CSTY]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    if  (rn[PGO_CSTY]) q = pgoblin_st_get(exenv, rn);
    for (; PGOBLIN_REGSIZE > (i = (pgoblin_nr)pgoblin_ctonr(*q)); q++) {
        if  (!!i && !pgoblin_pushio(exenv, i)) {
            ifBLIN_QX0("pgoblin_pushio %u", i);
            ex = (ENOMEM == errno) ? EX_OSERR : EX_USAGE;
            goto out;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushc(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rio *rct;
    int          ex = EX_OK;
    pgoblin_nr   i  ;
    char        *q  ;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+pushc .%c...%c", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CSTY]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    if  (rn[PGO_CSTY]) q = pgoblin_st_get(exenv, rn);
    for (; PGOBLIN_REGSIZE > (i = (pgoblin_nr)pgoblin_ctonr(*q)); q++) {
        if  (!!i && !pgoblin_pushcon(exenv, i)) {
            ifBLIN_QX0("pgoblin_pushcon %u", i);
            ex = (ENOMEM == errno) ? EX_OSERR : EX_USAGE;
            goto out;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushj(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rio *rct;
    int          ex = EX_OK;
    pgoblin_nr   i  ;
    char        *q  ;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+pushj .%c...%c", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CSTY]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    if  (rn[PGO_CSTY]) q = pgoblin_st_get(exenv, rn);
    for (; PGOBLIN_REGSIZE > (i = (pgoblin_nr)pgoblin_ctonr(*q)); q++) {
        if  (!!i && !pgoblin_pushjob(exenv, i)) {
            ifBLIN_QX0("pgoblin_pushjob %u", i);
            ex = (ENOMEM == errno) ? EX_OSERR : EX_USAGE;
            goto out;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushs(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rio *rct;
    int          ex = EX_OK;
    pgoblin_nr   i  ;
    char        *q  ;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+pushs .%c...%c", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CSTY]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    if  (rn[PGO_CSTY]) q = pgoblin_st_get(exenv, rn);
    for (; PGOBLIN_REGSIZE > (i = (pgoblin_nr)pgoblin_ctonr(*q)); q++) {
        if  (!!i && !pgoblin_pushsty(exenv, i)) {
            ifBLIN_QX0("pgoblin_pushsty %u", i);
            ex = (ENOMEM == errno) ? EX_OSERR : EX_USAGE;
            goto out;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popo(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rio *rct;
    int          ex = EX_OK;
    pgoblin_nr   i  ;
    int          f  = 0;
    char        *q  = NULL;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+popo .%c...%c", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CSTY]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    if  (rn[PGO_CSTY]) q = pgoblin_st_get(exenv, rn);
    f++;
    if  (!(q = strdup(q))) {
        ifBLIN_QX0("no mem");
        ERROUT(EX_OSERR, ENOMEM);
    }
    for (; PGOBLIN_REGSIZE > (i = (pgoblin_nr)pgoblin_ctonr(*q)); q++) {
        if  (!!i && !!(ex = pgoblin_popio(exenv->options, i))) {
            ifBLIN_QX0("pgoblin_popio %u", i);
            goto out;
    }   }
out:
    if  (!!f) free(q);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popc(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rio *rct;
    int          ex = EX_OK;
    pgoblin_nr   i  ;
    int          f  = 0;
    char        *q  = NULL;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+popc .%c...%c", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CSTY]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    if  (rn[PGO_CSTY]) q = pgoblin_st_get(exenv, rn);
    f++;
    if  (!(q = strdup(q))) {
        ifBLIN_QX0("no mem");
        ERROUT(EX_OSERR, ENOMEM);
    }
    for (; PGOBLIN_REGSIZE > (i = (pgoblin_nr)pgoblin_ctonr(*q)); q++) {
        if  (!!i && !!(ex = pgoblin_popcon(exenv->options, i))) {
            ifBLIN_QX0("pgoblin_popcon %u", i);
            goto out;
    }   }
out:
    if  (!!f) free(q);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popj(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rio *rct;
    int          ex = EX_OK;
    pgoblin_nr   i  ;
    int          f  = 0;
    char        *q  = NULL;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+popj .%c...%c", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CSTY]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    if  (rn[PGO_CSTY]) q = pgoblin_st_get(exenv, rn);
    f++;
    if  (!(q = strdup(q))) {
        ifBLIN_QX0("no mem");
        ERROUT(EX_OSERR, ENOMEM);
    }
    for (; PGOBLIN_REGSIZE > (i = (pgoblin_nr)pgoblin_ctonr(*q)); q++) {
        if  (!!i && !!(ex = pgoblin_popjob(exenv->options, i))) {
            ifBLIN_QX0("pgoblin_popjob %u", i);
            goto out;
    }   }
out:
    if  (!!f) free(q);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pops(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rio *rct;
    int          ex = EX_OK;
    pgoblin_nr   i  ;
    int          f  = 0;
    char        *q  = NULL;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+pops .%c...%c", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CSTY]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    if  (rn[PGO_CSTY]) q = pgoblin_st_get(exenv, rn);
    f++;
    if  (!(q = strdup(q))) {
        ifBLIN_QX0("no mem");
        ERROUT(EX_OSERR, ENOMEM);
    }
    for (; PGOBLIN_REGSIZE > (i = (pgoblin_nr)pgoblin_ctonr(*q)); q++) {
        if  (!!i && !!(ex = pgoblin_popsty(exenv->options, i))) {
            ifBLIN_QX0("pgoblin_popsty %u", i);
            goto out;
    }   }
out:
    if  (!!f) free(q);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
