/*-
 * Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: pgoblin.c,v 1.146 2022/01/22 23:31:11 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

static const char *const prms[256] =
{                  "",                   "Pf",                   "Pt",                   "Pt Pf"
,                "Pm",                "Pm Pf",                "Pm Pt",                "Pm Pt Pf"
,             "Pq"   ,                "Pq Pf",                "Pq Pt",                "Pq Pt Pf"
,             "Pq Pm",             "Pq Pm Pf",             "Pq Pm Pt",             "Pq Pm Pt Pf"
, "Po"               ,                "Po Pf",                "Po Pt",                "Po Pt Pf"
, "Po Pm"            ,             "Po Pm Pf",             "Po Pm Pt",             "Po Pm Pt Pf"
, "Po Pq"            ,             "Po Pq Pf",             "Po Pq Pt",             "Po Pq Pt Pf"
, "Po Pq Pm"         ,          "Po Pq Pm Pf",          "Po Pq Pm Pt",          "Po Pq Pm Pt Pf"
,          "Pc"      ,                "Pc Pf",                "Pc Pt",                "Pc Pt Pf"
,          "Pc Pm"   ,             "Pc Pm Pf",             "Pc Pm Pt",             "Pc Pm Pt Pf"
,          "Pc Pq"   ,             "Pc Pq Pf",             "Pc Pq Pt",             "Pc Pq Pt Pf"
,          "Pc Pq Pm",          "Pc Pq Pm Pf",          "Pc Pq Pm Pt",          "Pc Pq Pm Pt Pf"
, "Po Pc"            ,             "Po Pc Pf",             "Po Pc Pt",             "Po Pc Pt Pf"
, "Po Pc Pm"         ,          "Po Pc Pm Pf",          "Po Pc Pm Pt",          "Po Pc Pm Pt Pf"
, "Po Pc Pq"         ,          "Po Pc Pq Pf",          "Po Pc Pq Pt",          "Po Pc Pq Pt Pf"
, "Po Pc Pq Pm"      ,       "Po Pc Pq Pm Pf",       "Po Pc Pq Pm Pt",       "Po Pc Pq Pm Pt Pf"
,       "Pj"         ,                "Pj Pf",                "Pj Pt",                "Pj Pt Pf"
,       "Pj Pm"      ,             "Pj Pm Pf",             "Pj Pm Pt",             "Pj Pm Pt Pf"
,       "Pj Pq"      ,             "Pj Pq Pf",             "Pj Pq Pt",             "Pj Pq Pt Pf"
,       "Pj Pq Pm"   ,          "Pj Pq Pm Pf",          "Pj Pq Pm Pt",          "Pj Pq Pm Pt Pf"
, "Po Pj"            ,             "Po Pj Pf",             "Po Pj Pt",             "Po Pj Pt Pf"
, "Po Pj Pm"         ,          "Po Pj Pm Pf",          "Po Pj Pm Pt",          "Po Pj Pm Pt Pf"
, "Po Pj Pq"         ,          "Po Pj Pq Pf",          "Po Pj Pq Pt",          "Po Pj Pq Pt Pf"
, "Po Pj Pq Pm"      ,       "Po Pj Pq Pm Pf",       "Po Pj Pq Pm Pt",       "Po Pj Pq Pm Pt Pf"
,       "Pj Pc"      ,             "Pj Pc Pf",             "Pj Pc Pt",             "Pj Pc Pt Pf"
,       "Pj Pc Pm"   ,          "Pj Pc Pm Pf",          "Pj Pc Pm Pt",          "Pj Pc Pm Pt Pf"
,       "Pj Pc Pq"   ,          "Pj Pc Pq Pf",          "Pj Pc Pq Pt",          "Pj Pc Pq Pt Pf"
,       "Pj Pc Pq Pm",       "Pj Pc Pq Pm Pf",       "Pj Pc Pq Pm Pt",       "Pj Pc Pq Pm Pt Pf"
, "Po Pj Pc"         ,          "Po Pj Pc Pf",             "Po Pj Pt",          "Po Pj Pc Pt Pf"
, "Po Pj Pc Pm"      ,       "Po Pj Pc Pm Pf",       "Po Pj Pc Pm Pt",       "Po Pj Pc Pm Pt Pf"
, "Po Pj Pc Pq"      ,       "Po Pj Pc Pq Pf",       "Po Pj Pc Pq Pt",       "Po Pj Pc Pq Pt Pf"
, "Po Pj Pc Pq Pm"   ,    "Po Pj Pc Pq Pm Pf",    "Po Pj Pc Pq Pm Pt",    "Po Pj Pc Pq Pm Pt Pf"
,    "Ps"            ,                "Ps Pf",                "Ps Pt",                "Ps Pt Pf"
,    "Ps Pm"         ,             "Ps Pm Pf",             "Ps Pm Pt",             "Ps Pm Pt Pf"
,    "Ps Pq"         ,             "Ps Pq Pf",             "Ps Pq Pt",             "Ps Pq Pt Pf"
,    "Ps Pq Pm"      ,          "Ps Pq Pm Pf",          "Ps Pq Pm Pt",          "Ps Pq Pm Pt Pf"
, "Po Ps"            ,             "Po Ps Pf",             "Po Ps Pt",             "Po Ps Pt Pf"
, "Po Ps Pm"         ,          "Po Ps Pm Pf",          "Po Ps Pm Pt",          "Po Ps Pm Pt Pf"
, "Po Ps Pq"         ,          "Po Ps Pq Pf",          "Po Ps Pq Pt",          "Po Ps Pq Pt Pf"
, "Po Ps Pq Pm"      ,       "Po Ps Pq Pm Pf",       "Po Ps Pq Pm Pt",       "Po Ps Pq Pm Pt Pf"
,    "Ps Pc"         ,             "Ps Pc Pf",             "Ps Pc Pt",             "Ps Pc Pt Pf"
,    "Ps Pc Pm"      ,          "Ps Pc Pm Pf",          "Ps Pc Pm Pt",          "Ps Pc Pm Pt Pf"
,    "Ps Pc Pq"      ,          "Ps Pc Pq Pf",          "Ps Pc Pq Pt",          "Ps Pc Pq Pt Pf"
,    "Ps Pc Pq Pm"   ,       "Ps Pc Pq Pm Pf",       "Ps Pc Pq Pm Pt",       "Ps Pc Pq Pm Pt Pf"
, "Po Ps Pc"         ,          "Po Ps Pc Pf",             "Po Ps Pt",          "Po Ps Pc Pt Pf"
, "Po Ps Pc Pm"      ,       "Po Ps Pc Pm Pf",       "Po Ps Pc Pm Pt",       "Po Ps Pc Pm Pt Pf"
, "Po Ps Pc Pq"      ,       "Po Ps Pc Pq Pf",       "Po Ps Pc Pq Pt",       "Po Ps Pc Pq Pt Pf"
, "Po Ps Pc Pq Pm"   ,    "Po Ps Pc Pq Pm Pf",    "Po Ps Pc Pq Pm Pt",    "Po Ps Pc Pq Pm Pt Pf"
,    "Ps Pj"         ,             "Ps Pj Pf",             "Ps Pj Pt",             "Ps Pj Pt Pf"
,    "Ps Pj Pm"      ,          "Ps Pj Pm Pf",          "Ps Pj Pm Pt",          "Ps Pj Pm Pt Pf"
,    "Ps Pj Pq"      ,          "Ps Pj Pq Pf",          "Ps Pj Pq Pt",          "Ps Pj Pq Pt Pf"
,    "Ps Pj Pq Pm"   ,       "Ps Pj Pq Pm Pf",       "Ps Pj Pq Pm Pt",       "Ps Pj Pq Pm Pt Pf"
, "Po Ps Pj"         ,          "Po Ps Pj Pf",          "Po Ps Pj Pt",          "Po Ps Pj Pt Pf"
, "Po Ps Pj Pm"      ,       "Po Ps Pj Pm Pf",       "Po Ps Pj Pm Pt",       "Po Ps Pj Pm Pt Pf"
, "Po Ps Pj Pq"      ,       "Po Ps Pj Pq Pf",       "Po Ps Pj Pq Pt",       "Po Ps Pj Pq Pt Pf"
, "Po Ps Pj Pq Pm"   ,    "Po Ps Pj Pq Pm Pf",    "Po Ps Pj Pq Pm Pt",    "Po Ps Pj Pq Pm Pt Pf"
,    "Ps Pj Pc"      ,          "Ps Pj Pc Pf",          "Ps Pj Pc Pt",          "Ps Pj Pc Pt Pf"
,    "Ps Pj Pc Pm"   ,       "Ps Pj Pc Pm Pf",       "Ps Pj Pc Pm Pt",       "Ps Pj Pc Pm Pt Pf"
,    "Ps Pj Pc Pq"   ,       "Ps Pj Pc Pq Pf",       "Ps Pj Pc Pq Pt",       "Ps Pj Pc Pq Pt Pf"
,    "Ps Pj Pc Pq Pm",    "Ps Pj Pc Pq Pm Pf",    "Ps Pj Pc Pq Pm Pt",    "Ps Pj Pc Pq Pm Pt Pf"
, "Po Ps Pj Pc"      ,       "Po Ps Pj Pc Pf",          "Po Ps Pj Pt",       "Po Ps Pj Pc Pt Pf"
, "Po Ps Pj Pc Pm"   ,    "Po Ps Pj Pc Pm Pf",    "Po Ps Pj Pc Pm Pt",    "Po Ps Pj Pc Pm Pt Pf"
, "Po Ps Pj Pc Pq"   ,    "Po Ps Pj Pc Pq Pf",    "Po Ps Pj Pc Pq Pt",    "Po Ps Pj Pc Pq Pt Pf"
, "Po Ps Pj Pc Pq Pm", "Po Ps Pj Pc Pq Pm Pf", "Po Ps Pj Pc Pq Pm Pt", "Po Ps Pj Pc Pq Pm Pt Pf"
};

static const u_char flms[256] =
{  4, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
};

static int
/**********************************************************************
 **                                                                  **/
cmp(const void *a, const void *b) {                                 /**
 **                                                                  **
 **********************************************************************/
    return(strcmp(pgoblin.a[*(int*)a].str, pgoblin.a[*(int*)b].str));
}

static void
/**********************************************************************
 **                                                                  **/
regtran() {                                                         /**
 **                                                                  **
 **********************************************************************/
    u_int32_t f;
    int       k;

    for (int i = 0; i < pgoblin.max; ++i) {
        f = pgoblin.a[i].flags;
        if  ((f & PGOBLIN_ILLEGAL) != PGOBLIN_ILLEGAL) {
            printf("%03X", i);
            for (int j = 0; j < pgoblin.symparam; ++j) {
                k = pgoblin_breg(i, j);
                switch(k) {
                case -2: printf("\t#");     break;
                case -1: printf("\t.");     break;
                default: printf("\t%d", k); break;
            }   }
            printf("\t%s\n", pgoblin.a[i].str);
}   }   }

static int
/**********************************************************************
 **                                                                  **/
htman(u_int32_t flags) {                                            /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (flags & BLIN_MASK)
    u_int32_t   tag[pgoblin.symparam];
    const char *pt[pgoblin.symparam];
    u_int8_t    p[pgoblin.binparam];
    int         ex = EX_OK;
    char        cf[8];
    int        *sqn;
    int         i;
    int         j;
    int         k;
    int         m;
    u_int       u;

    if  (!(sqn = malloc(sizeof(int) * pgoblin.max))) {
        ifBLIN_QX0("malloc");
        errno = ENOMEM;
        ex = EX_UNAVAILABLE;
        goto out;
    }
    for (u = 1, j = 0; u < pgoblin.max; ++u) {
        if  (pgoblin.a[u].str) sqn[j++] = u;
    }
    if  (heapsort(sqn, j, sizeof(int), cmp) < 0) {
        ifBLIN_QW0("heapsort");
        ex = EX_SOFTWARE;
        goto out;
    }
    for (i = 0; i < j; i++) {
        u_int32_t f;
        u_int8_t h;
        char c;
        int b;

        f = pgoblin.a[sqn[i]].flags;
        if  ((f & PGOBLIN_ILLEGAL) == PGOBLIN_ILLEGAL) {
            tag[0] = 8;
            f &= ~PGOBLIN_ILLEGAL;
        } else {
            for (k = 0; k < pgoblin.binparam; k++) p[k] = 0;
            for (k = 0; k < pgoblin.symparam; k++) {
                tag[k] = 0;
                if  (0 <= (b = pgoblin_breg(sqn[i], k))) {
                    h = pgoblin.a[sqn[i]].ch[b];
                    tag[k] |= flms[h & 0xFF];
                    pt[k] = prms[h & 0xFF];
//printf("%d s%d b%d t%c %02X\n", tag[k], k, b, (!p[b]) ? '~' : ('0' + ~p[b]), h);
                    if  (h & ~(PGOBLIN_OUTSET | pgoblin.p[k].val)) tag[k] |= 1;
                    if  (!(h & pgoblin.p[k].val) != !*(pt[k])) tag[k] |= 1;
                    f &= ~pgoblin.p[k].sym;
                    if  (p[b]) {
                        tag[~p[b]] |= 2;
                        tag[k] |= 2;
                    }
                    p[b] = ~k;
                } else {
                    pt[k] = "";
                }
                if  (pgoblin.p[k].bin < 0) f &= ~(pgoblin.p[k].mask << ~pgoblin.p[k].bin);
        }   }
        k = 0;
        c = ' ';
        if  (f & PGOBLIN_IGNORE) {
            cf[k++] = 'i';
            for (m = 0; m < pgoblin.binparam; m++) if (p[m]) c = '!';
            for (m = 0; m < pgoblin.symparam; m++) if (*(pt[m])) c = '!';
            f &= ~PGOBLIN_IGNORE;
        }
        if  (f & PGOBLIN_NOLITER) {
            cf[k++] = 'l';
            if (p[1]) c = '!';
            if (tag[1] || *(pt[1])) c = '!';
            f &= ~PGOBLIN_NOLITER;
        }
        if  (f & PGOBLIN_LEXLVUP) cf[k++] = 'u';
        if  (f & PGOBLIN_LEXLDOWN) cf[k++] = 'd';
        if  (f & PGOBLIN_FORKED) cf[k++] = 'f';
        f &= ~(PGOBLIN_LEXLVUP | PGOBLIN_LEXLDOWN | PGOBLIN_FORKED);
        if  (f) c = '!';
        for (m = 0; m < pgoblin.symparam; m++) if (tag[m] & ~8) c = '!';
        if  (c == '!') cf[k++] = '!';
        cf[k++] = '\0';
        ifBLIN_QO1 printf( "%08X%c\t", f, c);
        if  (tag[0] & 8) {
            printf( "%s\t%s\t%d\t\t0\t\t0\t\t0\t\t0\t\t0\t\n"
                  , cf, pgoblin.a[sqn[i]].str, tag[0]
                  );
        } else {
            printf( "%s\t%s\t%d\t%s\t%d\t%s\t%d\t%s\t%d\t%s\t%d\t%s\t%d\t%s\n"
                  , cf, pgoblin.a[sqn[i]].str
                  , tag[0], pt[0]
                  , tag[1], pt[1]
                  , tag[2], pt[2]
                  , tag[3], pt[3]
                  , tag[4], pt[4]
                  , tag[5], pt[5]
                  );
    }   }
out:;
    return(0);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
keycodes(pgoblin_exenv *exenv) {                                    /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
#   define PROGSIZE   3
#   define RESCLASSES 4
#   define IOREGFOR   1
    pgoblin_tuple    *command;
    static const char KeyCodes[] = {'U', 'C', 'T', 'R'};
    size_t            sz[]       = {512, 512, 512};
    int               ex         = EX_OK;
    pgoblin_rio      *rio;
    char              c;
    char             *m;
    char             *s;
    int               i;
    int               j;
    int               k;

    if  (!(exenv->pgm = calloc(1, sizeof(pgoblin_prog)))) {
        ifBLIN_QW0("Calloc failed for exenv->pgm");
        ex = EX_OSERR;
        goto out;
    }
    strncpy(exenv->pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_LEN);
    /* exenv->pgm->debug = NULL; */
    exenv->pgm->code = mular_create( MULAR_HEXU | MULAR_STRI | MULAR_UPPE | MULAR_OBJ
                                   , 3
                                   , sizeof(pgoblin_tuple)
                                   , sz
                                   );
    if  (!exenv->pgm->code) {
        ifBLIN_QW0("mular_create failed for exenv->pgm->code");
        ex = EX_OSERR;
        goto out;
    }
    exenv->options->flags &= ~PGOBLIN_CLEAR_ONEXIT;
    if  (!(command = mular_add(exenv->pgm->code))) {
        ifBLIN_QW0("No room for programm");
        ex = EX_SOFTWARE;
        goto out;
    } else {
        command->cmd = PGOBLIN_select | IOREGFOR << pgoblin.binparams[0];
        command->lit = "SELECT word, catcode, catdesc FROM pg_get_keywords();";
        if  (exenv->options->flags & PGOBLIN_VERIFY) pgoblin_Vdump(exenv->options, exenv->pgm);
        if  ((ex = pgoblin_execute(exenv->options, exenv->pgm, NULL, NULL, 0))) {
            ifBLIN_QW0("Execute failed");
        }
        if  (!(rio = pgoblin_upio(exenv->options, IOREGFOR))) {
            ifBLIN_QW0("No IO reg %u", IOREGFOR);
            ex = EX_OSERR;
            goto out;
        }
        for (i = 0; i < pgoblin_db_resinfo(exenv, IOREGFOR, PGOBLIN_Ntuples); i++) {
            m = pgoblin_db_getvalue(exenv, IOREGFOR, i, 2);
            c = *(pgoblin_db_getvalue(exenv, IOREGFOR, i, 1));
            s = pgoblin_db_getvalue(exenv, IOREGFOR, i, 0);
            j = babolo_testword(pgoblin.sqlkeywords, s);
            ifBLIN_QX6("%3d %c %s %s\n", j, c, s, m);
            if  (!j) {
                ifBLIN_QX0( "Unknown keyword \'%s\' with type \'%c\', comment is \'%s\'", s, c, m);
            } else {
                for (k = 0; k < RESCLASSES; k++) if  (KeyCodes[k] == c) break;
                if  (k >= RESCLASSES) {
                    ifBLIN_QX0("Unknown keyword type \'%c\' for \'%s\', comment is \'%s\'", c, s, m);
                    ex = EX_SOFTWARE;
                } else if (k > (j - 1)) {
                    ifBLIN_QX0( "We know of type \'%c\' for keyword \'%s\', "
                                "but DBMS knows stronger type \'%c\'"
                              , KeyCodes[(j - 1)], s, c
                              );
                    ex = EX_SOFTWARE;
                } else if (k != (j - 1)) {
                    ifBLIN_QX0( "Our type \'%c\' for keyword \'%s\' mismatch with DBMS type \'%c\'"
                              , KeyCodes[(j - 1)], s, c
                              );
    }   }   }   }
out:;
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
setdb(pgoblin_main *options, int defdb) {                           /**
 **                                                                  **
 **********************************************************************/
    pgoblin_rdb *con;
    int          ex = EX_OK;

#   define blin_internal_flags (options->flags & BLIN_MASK)
    if  ((0 > defdb) && (0 > (defdb = pgoblin_load(options, 3, "0", -1)))) {
        ifBLIN_QX0("Can't load DB 0");
        ex = EX_NOINPUT;
        goto out;
    }
    for (int r = 0; r < (!!(options->flags & PGOBLIN_DEFAULDB) ? pgoblin.regsize : 1); ++r) {
        if  (!(con = pgoblin_upcon(options, r))) {
            ifBLIN_QW0("No CONN reg %u", r);
            ex = EX_SOFTWARE;
            goto out;
        }
        MARK_R_CONN_GO(r);;
        ;;  con->flags |= (options->flags & BLIN_MASK) | defdb;
        MARK_R_CONN_WENT(r);;
    }
out:
    return(ex);
#   undef blin_internal_flags
}

static void 
/**********************************************************************
 **                                                                  **/
tinr(u_int64_t *demask, const char *Tflag) {                        /**
 **                                                                  **
 **********************************************************************/
    int i;

    for (i = 1; !!Tflag[i]; ++i) {
        if  (pgoblin_ctonr(Tflag[i]) >= 0) {
            *demask |= 1 << pgoblin_ctonr(Tflag[i]);
}   }   }

static void
/**********************************************************************
 **                                                                  **/
usagee(int ex) {                                                    /**
 **                                                                  **
 **********************************************************************/
    fprintf( stderr
           , "pgoblin @BABOLO V.M " VERS "  " DATE " http://www.babolo.ru/\n"
             "    -=0             blin_ctl(BLIN_CTL_DUMP)\n"
             "    -=1             babolo_optest()\n"
             "    -=2             babolo_optext()\n"
             "    -=3             babolo_dumpopts()\n"
             "    -=B num or name prints binparams os cmd by num or name\n"
             "    -=C             create base table for command databook\n"
             "    -=K             compare keycodes (use -B before)\n"
             "    -=R             table of regs for commands\n"
             "    -=T             BLIN trace\n"
             "    -=X             trace output (use -f before)\n"
#if 0
             "    -=f             demask set of Pf\n"
             "    -=t             demask set of Pt\n"
             "    -=m             demask set of Pm\n"
             "    -=q             demask set of Pq\n"
             "    -=o             demask set of Po\n"
             "    -=c             demask set of Pc\n"
             "    -=j             demask set of Pj\n"
             "    -=s             demask set of Ps\n"
#endif
           )
    ;
    exit(ex);
}

static void
/**********************************************************************
 **                                                                  **/
usage(int ex) {                                                     /**
 **                                                                  **
 **********************************************************************/
    fprintf( stderr
           , "pgoblin @BABOLO V.M " VERS "  " DATE " http://www.babolo.ru/\n"
             "Usage:\n"
             "pgoblin [-aAbNOqvV][ -B DBMS][ -d DB][ -h Host][ -p Port][ -U User][ -f File] args\n"
             "    -B DBMS      default DBMS\n"
             "    -d DB        DB name\n"
             "    -E -opt ENV  get optarg for -opt from environment\n"
             "    -f File      execute pgoblin program from File\n"
             "    -h Host      backend server\n"
             "    -p Port      backend server\n"
             "    -q           quiet\n"
             "    -z ArgString break ArgString to opts\n"
             "    -Z ArgString break ArgString to opts with env vars subst\n"
             "    -t num       max time wait in #listen (sec)\n"
             "    -U Username  for connect to DB\n"
             "    -v           verbose\n"
             "____-X File      trace to File\n"
             "    -c Command   COPY out\n"
             "    -C Command   COPY in\n"
             "    -D Command   perform query without result\n"
             "    -e Program   execute pgoblin program from optarg\n"
             "    -s Command   perform query with text result\n"
             "____-S Command   perform query with binary result\n"
             "    -a           transit out \\. from COPY\n"
             "    -A           add \\. to COPY if not prezent\n"
             "    -b           do not create \\. on some get*** commands\n"
             "    -F           float time format in CON 0 PostgreSQL\n"
             "    -I           integer time format in CON 0 PostgreSQL\n"
             "    -= mode      internal diagnostic, list at -?=\n"
             "    -?           this text\n"
             "    -?=          list of -= modes\n"
           )
    ;
#if 0
    for (int i = 0; DBASE(i); i++) {
        char *q = index(DBASE(i)->name, '\0');
        fprintf(stderr, "  %s %s %s\n", DBASE(i)->id, DBASE(i)->name, ++q);
    }
    for (int i = 0; JOBE(i); i++) {
        char *q = index(JOBE(i)->name, '\0');
        fprintf(stderr, "  %s %s %s\n", JOBE(i)->id, JOBE(i)->name, ++q);
    }
    for (int i = 0; STYLS(i); i++) {
        char *q = index(STYLS(i)->name, '\0');
        fprintf(stderr, "  %s %s %s\n", STYLS(i)->id, STYLS(i)->name, ++q);
    }
#endif
    exit(ex);
}

static int
/***************************************************************************************
 **                                                                                   **/
cmdin(pgoblin_main *options, pgoblin_prog *pgm, pgoblin_cmd cmd, babolo_opts *bos) { /**
 **                                                                                   **
 ***************************************************************************************/
#   define blin_internal_flags (options->flags)
    pgoblin_tuple *command;
    int            ex = EX_OK;

    if  (!(command = mular_add(pgm->code))) {
        ifBLIN_QW0("No room for programm");
        ex = EX_SOFTWARE;
    } else {
        command->linum = 0;
        command->cmd = cmd;
        if  (!(command->lit = strdup(babolo_getoptsarg(bos)))) {
            ifBLIN_QW0("babolo_getoptsarg -%c", bos->c);
            ex = EX_USAGE;
        }
        ifBLIN_QX5("%d=%s%s", cmd, !command->lit ? "" : command->lit, !command->lit ? "" : "~");
    }
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
main(int argc, char *argv[], char **envp) {                         /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_main    *options;
    char           **dublo;
    pgoblin_exenv   *exenv   = NULL;
    char            *finam   = NULL;
    int              soptr   = 0;
    ssize_t          txlen;
    u_int            spmax;
    int              defdb   = -1;
    const char      *Tflag   = NULL;
    u_char          *text;
    pgoblin_rst     *rst0;
    pgoblin_rio     *rin0;
    pgoblin_rdb     *rdb0;
    pgoblin_rjb     *rjb0;
    int              ldn     = -1;
    u_int32_t        tmp;
    size_t           sz[]    = {512, 512, 512};
    int              ex      = EX_OK;
    mife_descriptor *in      = NULL;
    const char      *o;
    int              c;
    /* ,     flar   '1'.
     * ,        ,
     * . htman(),  flar   .
     */
    const char *flar = "aAbB:c:C:d:D:e:f:Fh:IL:Np:P:qs:S:t:U:vVw:X:=:?:";

    if  (!(options = pgoblin_init( BLIN_BIT0 | PGOBLIN_ERROR_SENSOR | PGOBLIN_CLEAR_ONEXIT
                                 , fileno(stdout)
        ) )                      ) {
        ifBLIN_QW0("pgoblin_init");
        ex = EX_OSERR;
        goto out;
    }
#   define blin_internal_flags (options->flags)
    spmax = (argc + 16);
    if  (!(exenv = calloc(1, sizeof(pgoblin_exenv)))) {
        ifBLIN_QW0("no mem for exenv");
        ex = EX_OSERR;
        goto out;
    }
    exenv->options = options;
    exenv->flags = options->flags & BLIN_MASK;
    if  (!(exenv->pgm = calloc(1, sizeof(pgoblin_prog)))) {
        ifBLIN_QW0("Calloc failed #3");
        ex = EX_OSERR;
        goto out;
    }
    /* exenv->pgm->debug = NULL; */
    options->argv = argv;
    options->envp = envp;
    strncpy(exenv->pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_LEN);
    exenv->pgm->code = mular_create( MULAR_HEXU | MULAR_STRI | MULAR_UPPE | MULAR_OBJ
                                   , 3
                                   , sizeof(pgoblin_tuple)
                                   , sz
                                   );
    if  (!exenv->pgm->code) {
        ifBLIN_QW0("mular_create failed for exenv->pgm->code");
        ex = EX_OSERR;
        goto out;
    }
    if  (!(options->bos = babolo_openopts(Bpars_NONU | Bpars_SYME, 'Z'))) {
        ifBLIN_QW0("babolo_openopts");
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (babolo_setopts(options->bos, Bpars_NONU, argc, argv, flar)) {
        ifBLIN_QW0("babolo_setopts");
        ex = EX_SOFTWARE;
        goto out;
    }
    while (!!(c = babolo_getopts(options->bos))) {
        ifBLIN_QX4("%c(%02X)", c, c);
        switch (c) {
        case 'a': options->flags |= PGOBLIN_COPEND_PASS;
//    COPY ( \.)    #copyout.
                ; break;
        case 'A': options->flags |= PGOBLIN_COPEND_APND;
//    COPY ( \.)    #copyout,    .
                ; break;
        case 'b': options->flags |= PGOBLIN_COPEND_NOGEN;
//     COPY ( \.)  #get***.
//     #get*** ,   getCGIparm.
                ; break;
        case 'B': if  (!(o = babolo_getoptsarg(options->bos))) {
// Ar 
//    .
                ;     ifBLIN_QW0("No -%c arg", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  (defdb >= 0) ifBLIN_QX1("Dublicate DBMS definition %s", o);
                ; if  (0 > (defdb = pgoblin_load(options, 3, o, -1))) ifBLIN_QX1("Illegal DBMS %s", o);
                ; break;
        case 'c': if  (cmdin(options, exenv->pgm, PGOBLIN_copyout, options->bos)) {
// Ar 
//  #copyout      .
                ;     ifBLIN_QW0("-%c cmdin", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'C': if  (cmdin(options, exenv->pgm, PGOBLIN_copyin, options->bos)) {
// Ar 
//  #copyin      .
                ;     ifBLIN_QW0("-%c cmdin", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'd': if  (!(rdb0 = pgoblin_upcon(options, 0))) {
// Ar 
//   
                ;     ifBLIN_QW0("No CONN reg 0 @opt");
                ;     ex = EX_SOFTWARE;
                ;     goto out;
                ; }
                ; MARK_R_CONN_GO(0);;
                ; ;;  rdb0->dbname = babolo_getoptsarg(options->bos);
                ; MARK_R_CONN_WENT(0);;
                ; if  (!rdb0->dbname) {
                ;     ifBLIN_QW0("No -%c arg", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'D': if  (cmdin(options, exenv->pgm, PGOBLIN_perform, options->bos)) {
// Ar 
//  #perform      .
                ;     ifBLIN_QW0("-%c cmdin", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'e': if  (!(o = babolo_getoptsarg(options->bos))) {
// Ar 
//    .
                ;     ifBLIN_QW0("No -%c arg", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  ((ex = pgoblin_parser(options, (u_char*)o, strlen(o), &exenv->pgm, 0, NULL))) {
                ;     ifBLIN_QW0("Syntax?");
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'f': if  (!(o = babolo_getoptsarg(options->bos))) {
// Ar 
//  .     .
                ;     ifBLIN_QW0("No -%c arg", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  (!!finam) ifBLIN_QX1("Dublicate input file definition %s", o);
                ; if  (!(finam = strdup(o))) ifBLIN_QW0("strdup");
                ; break;
        case 'F': if  (!(rdb0 = pgoblin_upcon(options, 0))) {
//    CON 0 .
                ;     ifBLIN_QW0("No CONN reg 0 @opt");
                ;     ex = EX_SOFTWARE;
                ;     goto out;
                ; }
                ; if  (rdb0->flags & PGOBLIN_INT64TIME) {
                ;     MARK_R_CONN_GO(0);;
                ;     ;;  rdb0->flags |= PGOBLIN_NEEDINTIME;
                ;     ;;  rdb0->flags &= ~PGOBLIN_INT64TIME;
                ;     MARK_R_CONN_WENT(0);;
                ; } else {
                ;     MARK_R_CONN_GO(0);;
                ;     ;;  rdb0->flags |= PGOBLIN_FLOATTIME;
                ;     MARK_R_CONN_WENT(0);;
                ; }
                ; break;
        case 'h': if  (!(rdb0 = pgoblin_upcon(options, 0))) {
// Ar 
//    CON 0.
                ;     ifBLIN_QW0("No CONN reg 0 @opt");
                ;     ex = EX_SOFTWARE;
                ;     goto out;
                ; }
                ; MARK_R_CONN_GO(0);;
                ; ;;  rdb0->host = babolo_getoptsarg(options->bos);
                ; MARK_R_CONN_WENT(0);;
                ; if  (!rdb0->host) {
                ;     ifBLIN_QW0("No -%c arg", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'I': if  (!(rdb0 = pgoblin_upcon(options, 0))) {
//    CON 0 .
                ;     ifBLIN_QW0("No CONN reg 0 @opt");
                ;     ex = EX_SOFTWARE;
                ;     goto out;
                ; }
                ; if  (rdb0->flags & PGOBLIN_FLOATTIME) {
                ;     MARK_R_CONN_GO(0);;
                ;     ;;  rdb0->flags |= PGOBLIN_NEEDINTIME;
                ;     ;;  rdb0->flags &= ~PGOBLIN_FLOATTIME;
                ;     MARK_R_CONN_WENT(0);;
                ; } else {
                ;     MARK_R_CONN_GO(0);;
                ;     ;;  rdb0->flags |= PGOBLIN_INT64TIME;
                ;     MARK_R_CONN_WENT(0);;
                ; }
                ; break;
        case 'L': if  (!(o = babolo_getoptsarg(options->bos))) {
// Ar    
//      ,    .
//    16 .
                ;     ifBLIN_QW0("No -%c arg", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  (PGOBLIN_SOSIZE > soptr) {
                ;     options->libexec[soptr++] = o;
                ; } else {
                ;     ifBLIN_QW0("No more 16 -L");
                ; }
                ; break;
        case 'N': options->flags |= PGOBLIN_DEFAULDB;
//  ,   ,     CONN
                ; break;
        case 'p': if  (!(rdb0 = pgoblin_upcon(options, 0))) {
//    CON 0.
                ;     ifBLIN_QW0("No CONN reg 0 @opt");
                ;     ex = EX_SOFTWARE;
                ;     goto out;
                ; }
                ; MARK_R_CONN_GO(0);;
                ; ;;  rdb0->port = babolo_getoptsarg(options->bos);
                ; MARK_R_CONN_WENT(0);;
                ; if  (!rdb0->port) {
                ;     ifBLIN_QW0("No -%c arg", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'P': if  (!(rdb0 = pgoblin_upcon(options, 0))) {
// Ar 
//      
                ;     ifBLIN_QW0("No CONN reg 0 @opt");
                ;     ex = EX_SOFTWARE;
                ;     goto out;
                ; }
                ; MARK_R_CONN_GO(0);;
                ; ;;  rdb0->password = babolo_getoptsarg(options->bos);
                ; MARK_R_CONN_WENT(0);;
                ; if  (!rdb0->password) {
                ;     ifBLIN_QW0("No -%c arg", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'q': BLIN_QUIET(options->flags);
//   .
                ; exenv->flags &= ~BLIN_MASK;
                ; break;
        case 's': if  (cmdin(options, exenv->pgm, PGOBLIN_strselect, options->bos)) {
// Ar 
//  #strselect      .
                ;     ifBLIN_QW0("-%c cmdin", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'S': if  (cmdin(options, exenv->pgm, PGOBLIN_binselect, options->bos)) {
// Ar 
//  #binselect      .
                ;     ifBLIN_QW0("-%c cmdin", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 't': errno = 0;
// Ar 
//       #listen.   1 .
                ; options->maxtmout = babolo_getoptunum(options->bos, 0) * 1000;
                ; if  (errno) {
                ;     ifBLIN_QW0("-%c babolo_getoptunum", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'U': if  (!(rdb0 = pgoblin_upcon(options, 0))) {
// Ar 
//    
                ;     ifBLIN_QW0("No CONN reg 0 @opt");
                ;     ex = EX_SOFTWARE;
                ;     goto out;
                ; }
                ; MARK_R_CONN_GO(0);;
                ; ;;  rdb0->username = babolo_getoptsarg(options->bos);
                ; MARK_R_CONN_WENT(0);;
                ; if  (!rdb0->username) {
                ;     ifBLIN_QW0("No -%c arg", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'v': BLIN_VERBOSE(options->flags);
//   .
//  :
//u
// 0 -      
// 1 -      stderr
// 2 -  stderr    ,   
//  3 -  
//u
//      1.
                ; exenv->flags = (BLIN_MASK & options->flags) | (~BLIN_MASK & exenv->flags);
                ; break;
        case 'V': if  (options->flags & PGOBLIN_VERIFY) {
//      .
//     .
                ;     pgoblin_VVdump();
                ; } else {
                ;     options->flags |= PGOBLIN_VERIFY;
                ; }
                ; break;
        case 'w': errno = 0;
// Ar 
//         ,   255,   255.
//   .      ,  .
                ; tmp = babolo_getoptunum(options->bos, 0);
                ; if  (errno) {
                ;     ifBLIN_QW0("-%c babolo_getoptunum", options->bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; options->maxtmout = tmp;
                ; options->flags |= ((tmp > 255) ? 255 : tmp);
                ; break;
        case 'X': {   if  (!(options->ftrace = babolo_getoptsarg(options->bos))) {
// Ar 
//        .
//     pgoblin   
//     .
                ;         ifBLIN_QW0("No -%c arg", options->bos->c);
                ;         ex = EX_USAGE;
                ;         goto out;
                ;     }
                ;     options->xtrace = open( options->ftrace
                                            , O_WRONLY | O_APPEND | O_CREAT | O_TRUNC | O_EXLOCK
                                            , 0666
                                            );
                ;     if  (0 > options->xtrace) {
                ;         ifBLIN_QW0("open(%s, WRONLY|APPEND|CREAT|TRUNC|EXLOCK)", options->ftrace);
                ;         ex = EX_IOERR;
                ;         goto out;
                ;     } else {
                ;         close(options->xtrace);
                ; }   }
                ; break;
        case '=': if  (!(Tflag = babolo_getoptsarg(options->bos))) usage(EX_USAGE);
// Ar 
//  ,    ,
//      .
                ; switch(Tflag[0]) {
                  case '0': blin_ctl(BLIN_CTL_DUMP);           exit(EX_OK);
                  case '1': babolo_optest(flar);               exit(EX_OK);
                  case '2': babolo_optext(options->bos);       exit(EX_OK);
                  case '3': babolo_dumpopts(options->bos);     exit(EX_OK);
                  case 'B':
                ;     ++Tflag;
                ;     if  ((*Tflag >= '0') && (*Tflag <= '9')) {
                ;         ldn = strtol(Tflag, NULL, 0);
                ;     } else if (0 > (ldn = babolo_testword(pgoblin.cmds, Tflag))) {
                ;         printf("Ill cmd %s\n", Tflag);
                ;         exit(EX_USAGE);
                ;     }
                ;     printf("(%03X)#%s ", ldn, pgoblin.a[ldn].str);
                ;     for (int symreg = 0; symreg < pgoblin.symparam; symreg++) {
                          int binreg = pgoblin_breg(ldn, symreg);

                ;         printf("%c", (0 > binreg) ? '.' : ('0' + binreg));
                ;     }
                ;     printf("\n");
                ;     exit(EX_OK);
                  case 'C': ex = htman(options->flags);        exit(ex);
                  case 'K':
                ;     if  (!!setdb(options, defdb)) goto out;
                ;     ex = keycodes(exenv);
                ;     exit(ex);
                  case 'R': regtran();                         exit(EX_OK);
                  case 'T': blin_ctl(BLIN_CTL_TCFN, ++Tflag);  break;
                  case 'X':
                ;     if  (!finam) {
                ;         ifBLIN_QX0("Trace file not defined for read");
                ;         exit(EX_USAGE);
                ;     }
                ;     exit(pgoblin_traceat(options, finam, Tflag));
                  case 'f': tinr(&options->demaskf, Tflag);    break;
                  case 't': tinr(&options->demaskt, Tflag);    break;
                  case 'm': tinr(&options->demaskm, Tflag);    break;
                  case 'q': tinr(&options->demaskq, Tflag);    break;
                  case 'o': tinr(&options->demasko, Tflag);    break;
                  case 'c': tinr(&options->demaskc, Tflag);    break;
                  case 'j': tinr(&options->demaskj, Tflag);    break;
                  case 's': tinr(&options->demasks, Tflag);    break;
                  default:                                     break;
                ; }
                ; break;
        case '?': if  (!(o = babolo_getoptsarg(options->bos))) usage(EX_OK);
//  .
                ; switch(*o) {
                  case '=': usagee(EX_OK);
                  default : usage(EX_USAGE);
                ; }
        default : ifBLIN_QX0("Illegal flag -%c", options->bos->c);
                ; usage(EX_USAGE);
    }   }
    if  (!(rin0 = pgoblin_upio(options, 0))) {
        ifBLIN_QW0("No IO reg 0 @start");
        ex = EX_SOFTWARE;
        goto out;
    }
    MARK_IO_MIFE_GO(0);;
    ;;  MARK_IO_OUT_GO(0);;
    ;;  ;;  rin0->flags |= options->flags & BLIN_MASK;
    ;;  MARK_IO_OUT_WENT(0);;
    MARK_IO_MIFE_WENT(0);;
    if  (!!setdb(options, defdb)) goto out;
    if  (0 > (ldn = pgoblin_load(options, 4, "local", -1))) {
        ifBLIN_QW0("Can't load JOB local");
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (!(rjb0 = pgoblin_upjob(options, 0))) {
        ifBLIN_QW0("No JOB reg 0 @start");
        ex = EX_SOFTWARE;
        goto out;
    }
    MARK_R_JOB_GO(0);;
    ;;  rjb0->flags |= (options->flags & BLIN_MASK) | ldn;
    MARK_R_JOB_WENT(0);;
    if  (0 > (ldn = pgoblin_load(options, 5, "0", -1))) {
        ifBLIN_QW0("Can't load STYLE 0");
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (!(rst0 = pgoblin_upsty(options, 0))) {
        ifBLIN_QW0("No STYLE reg 0 @start");
        ex = EX_SOFTWARE;
        goto out;
    }
    MARK_R_STYLE_GO(0);;
    ;;  rst0->flags |= (options->flags & BLIN_MASK) | ldn;
    MARK_R_STYLE_WENT(0);;
    if  (options->flags & PGOBLIN_VERIFY) pgoblin_verify(options);
    while ((o = babolo_getargs(options->bos))) {
        ifBLIN_QX4("deargs=%s~", o);
        if  (!options->deargs) {
            options->deargs = mular_create( MULAR_CHAR | MULAR_STRI | MULAR_PFRE | MULAR_UPPE
                                          , 3
                                          , sizeof(char*)
                                          , sz
                                          );
            if  (!options->deargs) {
                ifBLIN_QW0("mular_create");
                ex = EX_SOFTWARE;
                goto out;
        }   }
        if  (!(dublo = mular_add(options->deargs))) {
            ifBLIN_QW0("mular_add");
            ex = EX_SOFTWARE;
            goto out;
        }
        if  (!(*dublo = strdup(o))) {
            ifBLIN_QW0("strdup");
            ex = EX_OSERR;
            goto out;
    }   }
    if  (!finam && !!options->deargs) finam = *(char**)mular_getix(options->deargs, 0);
    ifBLIN_QX4("%p finam %"BLIN_X"=%s", MULAR_NEXT(exenv->pgm->code), finam, !finam ? "" : finam);
    if  (!MULAR_NEXT(exenv->pgm->code)) {
        if  (!(in = mife_init(PGOBLIN_MIFEFLAGS))) {
            ifBLIN_QW0("mife_init programm");
            ex = EX_IOERR;
            goto out;
        } else if (!!finam) {
            if  (0 > mife_ctlfile(in, finam)) {
                ifBLIN_QW0("mife_ctlfile programm");
                ex = EX_IOERR;
                goto out;
            }
        } else if (0 > mife_ctlfdsc(in, fileno(stdin))) {
            ifBLIN_QW0("mife_ctlfdsc programm");
            ex = EX_IOERR;
            goto out;
        }
        if  (0 > (txlen = mife_read(in, (ssize_t)0, (off_t)0))) {
            ifBLIN_QW0("mife_read programm");
            ex = EX_IOERR;
        } else if (!(text = mife_pointer(in))) {
            ifBLIN_QW0("Program get failed");
            ex = EX_IOERR;
        } else if (pgoblin_parser(options, text, txlen, &exenv->pgm, 0, finam)) {
            ifBLIN_QX0("Parser failed");
            ex = EX_DATAERR;
    }   }
    if  (!ex) {
        if  (!(rin0 = pgoblin_upio(options, 0))) {
            ifBLIN_QW0("No IO reg 0 @start");
            ex = EX_SOFTWARE;
            goto out;
        }
        MARK_IO_MIFE_GO(0);;
        ;;  if  (!(rin0->mife = mife_init(PGOBLIN_MIFEFLAGS))) {
        ;;      ifBLIN_QW0("mife_init IO[0]");
        ;;      ex = EX_IOERR;
        ;;      goto out;
        ;;  } else if (0 > mife_ctlfdsc(rin0->mife, fileno(stdin))) {
        ;;      ifBLIN_QW0("mife_ctlfdsc IO[0]");
        ;;      ex = EX_IOERR;
        ;;      goto out;
        ;;  } else {
        ;;      rin0->pid = 0;
        ;;      rin0->flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
        ;;  }
        MARK_IO_MIFE_WENT(0);;
        if  (options->flags & PGOBLIN_VERIFY) pgoblin_Vdump(exenv->options, exenv->pgm);
        if  (SIG_ERR == signal(SIGPIPE, SIG_IGN)) {
            ifBLIN_QW0("signal SIGPIPE");
        }
        if  ((ex = pgoblin_execute(exenv->options, exenv->pgm, NULL, NULL, 0))) {
            ifBLIN_QX0("Execute failed");
    }   }
out:
    if  (in) mife_fini(in);
    if  (!!exenv) {
        if  (!!exenv->pgm) {
            if  (!!exenv->pgm->code) {
                mular_destroy(exenv->pgm->code);
                exenv->pgm->code = NULL;
            }
            free(exenv->pgm);
            exenv->pgm = NULL;
        }
        free(exenv);
        exenv = NULL;
    }
    if  (!!options) {
        if  (!!options->bos) babolo_closeopts(options->bos);
        options->bos = NULL;
        free(options);
        options = NULL;
    }
    return(ex);
#   undef blin_internal_flags
}
