/*-
 * Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: ini.c,v 1.14 2022/01/09 15:27:41 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    4
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <dlfcn.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

BLIN_flag pgoblin_default;
static size_t u12[] = {341, 512, 512};

static struct {
    char *nm;
    void *mod;
} mods[PGOBLIN_SYMREGS][3] =
{ { {     NULL, NULL}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {     NULL, NULL}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {     NULL, NULL}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"0"      , &pgoblin_db_0}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"local"  , &pgoblin_job_local}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"0"      , &pgoblin_style_0}
  , {     NULL, NULL}
  , {     NULL, NULL}
} };

static void *
/**************************************************************************
 **************************************************************************
 **                                                                      **/
dload(pgoblin_main *options, int domain, int rs, const char *nm)      { /**
 **                                                                      **
 **************************************************************************
 **************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    char *libname = NULL;
    void *module  = NULL;
    void *handle  = NULL;

    for (int i = 0; !!options->libexec[i] && (PGOBLIN_SOSIZE > i); ++i) {
        asprintf(&libname, "%s/libpgoblin%d%.*s.so", options->libexec[i], domain, rs, nm);
        if  (!libname) {
            ifBLIN_QW0("No mem");
            goto out;
        }
        if  (!(handle = dlopen(libname, /* RTLD_NOW | */ RTLD_LAZY | RTLD_LOCAL))) {
            ifBLIN_QX1("[%d]dlopen %s: %s", i, libname, dlerror());
        }
        free(libname);
        libname = NULL;
        if  (!!handle) break;
    }
    if  (!handle) {
        asprintf(&libname, PGOBLIN_LIBDIR"/pgoblin%u/libpgoblin%d%.*s.so", VMAJOR, domain, rs, nm);
        if  (!libname) {
            ifBLIN_QW0("No mem");
            goto out;
        }
        if  (!(handle = dlopen(libname, /* RTLD_NOW | */ RTLD_LAZY | RTLD_LOCAL))) {
            ifBLIN_QX0("dlopen %s: %s", libname, dlerror());
            goto out;
    }   }
    if  ((!!handle) && !(module = dlsym(handle, "pgoblin_module"))) {
        ifBLIN_QX0("dlsym pgoblin_module: %s", dlerror());
        goto out;
    }
out:
    if  (libname) free(libname);
    return(module);
#   undef blin_internal_flags
}

int
/**************************************************************************
 **************************************************************************
 **                                                                      **/
pgoblin_load(pgoblin_main *options, int mode, const char *nm, int rs) { /**
 **                                                                      **
 **************************************************************************
 **************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int           loaded = -1;
    int           slot;
    int           wrt;
    int           ex;

    if  (0 > rs) rs = strlen(nm);
    ifBLIN_QX4("Load %d [%d]=%.*s", mode, rs, rs, nm);
    switch(mode) {
    case 3:
        for (slot = PGOBLIN_MODSHIFT; (slot < pgoblin.dbtablesz) && !!DBASE(slot); ++slot) {
            if  (!strncmp(DBASE(slot)->name, nm, rs) && !DBASE(slot)->name[rs]) {
                loaded = slot;
                goto out;
        }   }
        if  (slot >= pgoblin.dbtablesz) {
            ifBLIN_QX0("No free slots for DB %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == slot) {
            DBASE(slot) = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(options, slot, DBASE(slot)->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  (!!(ex = DBASE(slot)->init(options, slot))) {
                ifBLIN_QW0("DB %s init failed", DBASE(slot)->name);
                DBASE(slot) = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            ++slot;
        }
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        for (int k = 1; !!mods[mode][k].nm; ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                DBASE(slot) = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(options, slot, DBASE(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  (!!(ex = DBASE(slot)->init(options, slot))) {
                    ifBLIN_QW0("DB %s init failed", DBASE(slot)->name);
                    DBASE(slot) = NULL;
                } else {
                    loaded = slot;
        }   }   }
        if  (0 > loaded) {
            if  (!!(DBASE(slot) = dload(options, 3, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(options, slot, DBASE(slot)->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = DBASE(slot)->init(options, slot))) {
                    ifBLIN_QW0("DB %s init failed", DBASE(slot)->name);
                    DBASE(slot) = NULL;
                } else {
                    loaded = slot;
        }   }   }
        break;
    case 4:
        for (slot = PGOBLIN_MODSHIFT; (slot < pgoblin.jobtabsiz) && !!pgoblin.jobtable[slot]; ++slot) {
            if  (!strncmp(pgoblin.jobtable[slot]->name, nm, rs) && !pgoblin.jobtable[slot]->name[rs]) {
                loaded = slot;
                goto out;
        }   }
        if  (slot >= pgoblin.jobtabsiz) {
            ifBLIN_QX0("No free slots for JOB %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == slot) {
            pgoblin_rjb  *rjb;
            pgoblin_jobl *j;

            pgoblin.jobtable[slot] = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(options, slot, pgoblin.jobtable[slot]->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  ((ex = pgoblin.jobtable[slot]->init(options, slot))) {
                ifBLIN_QW0("JOB %s init failed", pgoblin.jobtable[slot]->name);
                pgoblin.jobtable[slot] = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            if  (!(rjb = pgoblin_upjob(options, 0))) {
                ifBLIN_QX0("No JOB reg 0");
                loaded = -1;
                goto out;
            }
            MARK_R_JOB_GO(0);;
            ;;  rjb->pids = mular_create(MULAR_ZERO, 3, sizeof(pgoblin_jobl), u12);
            ;;  j = mular_add(rjb->pids);
            ;;  j->cmdn = -1;
            ;;  j->pid = getppid();
            ;;  j->status = PGOBLIN_NOSTATUS;
            ;;  j = mular_add(rjb->pids);
            ;;  j->cmdn = -1;
            ;;  j->pid = getpid();
            ;;  j->status = PGOBLIN_NOSTATUS;
            MARK_R_JOB_WENT(0);;
            ++slot;
        }
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        for (int k = 1; !!mods[mode][k].nm; ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                pgoblin.jobtable[slot] = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(options, slot, pgoblin.jobtable[slot]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.jobtable[slot]->init(options, slot))) {
                    ifBLIN_QW0("JOB %s init failed", pgoblin.jobtable[slot]->name);
                    pgoblin.jobtable[slot] = NULL;
                } else {
                    loaded = slot;
        }   }   }
        if  (0 > loaded) {
            if  (!!(pgoblin.jobtable[slot] = dload(options, 4, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(options, slot, pgoblin.jobtable[slot]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.jobtable[slot]->init(options, slot))) {
                    ifBLIN_QW0("DB %s init failed", pgoblin.jobtable[slot]->name);
                    pgoblin.jobtable[slot] = NULL;
                } else {
                    loaded = slot;
        }   }   }
        break;
    case 5:
        for ( slot = PGOBLIN_MODSHIFT
            ; (slot < pgoblin.styletbsz) && !!pgoblin.styletable[slot]
            ; ++slot
            ) {
            if  (  !strncmp(pgoblin.styletable[slot]->name, nm, rs)
                && !pgoblin.styletable[slot]->name[rs]
                ) {
                loaded = slot;
                goto out;
        }   }
        if  (slot >= pgoblin.styletbsz) {
            ifBLIN_QX0("No free slots for DB %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == slot) {
            pgoblin.styletable[slot] = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(options, slot, pgoblin.styletable[slot]->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  ((ex = pgoblin.styletable[slot]->init(options, slot))) {
                ifBLIN_QW0("STYLE %s init failed", pgoblin.styletable[PGOBLIN_MODSHIFT]->name);
                pgoblin.styletable[PGOBLIN_MODSHIFT] = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            ++slot;
        }
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        for (int k = 1; !!mods[mode][k].nm; ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                pgoblin.styletable[slot] = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(options, slot, pgoblin.styletable[slot]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.styletable[slot]->init(options, slot))) {
                    ifBLIN_QW0("STYLE %s init failed", pgoblin.styletable[slot]->name);
                    pgoblin.styletable[slot] = NULL;
                } else {
                    loaded = slot;
        }   }   }
        if  (0 > loaded) {
            if  (!!(pgoblin.styletable[slot] = dload(options, 5, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(options, slot, pgoblin.styletable[slot]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.styletable[slot]->init(options, slot))) {
                    ifBLIN_QW0("DB %s init failed", pgoblin.styletable[slot]->name);
                    pgoblin.styletable[slot] = NULL;
                } else {
                    loaded = slot;
        }   }   }
        break;
    default:;
    }
out:;
    return(loaded);
#   undef blin_internal_flags
}
 
pgoblin_main *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_init(BLIN_flag flags, int outfd) {                          /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (flags & BLIN_MASK)
    pgoblin_main *options = NULL;
    pgoblin_rio  *rio;

    blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FSET, flags);
    ifBLIN_QX2("+ flags=%08X", flags);
    if  (!(options = calloc(1, sizeof(pgoblin_main)))) {
        ifBLIN_QX0("no mem for options");
        errno = ENOMEM;
        goto out;
    }
    pgoblin_options = options;
    options->xtrace = -1;
    options->flags = flags;
    pgoblin_default = flags;
    strncpy(options->vers, VERS, 4);
    options->maxtmout = 3600000;
    strncpy((char*)options->delim, "#", 3);
    if  (!(rio = pgoblin_upio(options, 0))) {
        ifBLIN_QW0("No IO reg 0");
        free(options);
        options = NULL;
        goto out;
    }
    MARK_IO_OUT_GO(0);;
    ;;  rio->onu = outfd;
    ;;  rio->wri = (int(*)(int, const void *, size_t))mife_writ;
    ;;  rio->flags |= PGOBLIN_OUTSET;
    MARK_IO_OUT_WENT(0);;
out:;
    ifBLIN_QX2("- %s", options ? "OK" : "FAIL");
    return(options);
#   undef blin_internal_flags
}

void
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_fini(pgoblin_main *options) {                               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int i;

    i = pgoblin.dbtablesz;
    if  (i < pgoblin.jobtabsiz) i = pgoblin.jobtabsiz;
    if  (i < pgoblin.styletbsz) i = pgoblin.styletbsz;
    for (; 0 <= i; --i) {
        if  ((i < pgoblin.styletbsz) && !!pgoblin.styletable[i]) {
            pgoblin.styletable[i]->fini(options);
        }
        if  ((i < pgoblin.dbtablesz) && !!DBASE(i)) {
            DBASE(i)->fini(options);
        }
        if  ((i < pgoblin.jobtabsiz) && !!pgoblin.jobtable[i]) {
            pgoblin.jobtable[i]->fini(options);
    }   }
    free(options);
#   undef blin_internal_flags
}
