/*-
 * Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_trans.c,v 1.151 2022/03/27 16:29:48 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   4
#define RECOBE_COMPAT    4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/param.h>
#if defined(__FreeBSD_cc_version) && __FreeBSD_cc_version > 599999 /* I do not know exact version */
#include <arpa/inet.h>
#endif
#include <sys/wait.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <poll.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getjob(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 ** pgoblin_getjob()   2  ,                **
 **     ,                          **
 **     .                              **
 **  pgoblin_syntax                          **
 **   - Ij  ch[2].                              **
 **   - ,                        **
 ** (  )                    **
 **   ,   .                  **
 **   R_JOBIN,   R_JOB                       **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    int           status;
    pgoblin_rio  *rou;
    pgoblin_rjb  *rjb;
    int           exx = EX_OK;
    int           ex  = EX_OK;
    FILE         *fi;
    pgoblin_jobl *j;
    size_t        i;

    ifBLIN_QX3("+getjob %c...%c.", pgoblin_regn[rn[PGO_COUT]], pgoblin_regn[rn[PGO_CJOB]]);
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    if  (rjb->pids) {
        GET_RIO(rou, exenv->options, rn[PGO_COUT]);
        if  (!(fi = funopen( (void*)(size_t)(rou->onu)
                           , NULL
                           , (int (*)(void*, const char*, int))mife_writ
                           , NULL
                           , NULL
            ) )            ) {
            ifBLIN_QW0("funopen on %d", rn[PGO_CJOB]);
            ex = EX_OSERR;
        } else {
            for (i = 0; i <  MULAR_NEXT(rjb->pids); i++) {
                j = mular_getix(rjb->pids, i);
                if  (j->pid <= 0) {
                    ifBLIN_QX0("No pid in %"BLIN_D, j->cmdn);
                    errno = EINVAL;
                    ex = EX_SOFTWARE;
                } else if ((j->cmdn >= 0) && (j->status == PGOBLIN_NOSTATUS)) {
                    if  (!(ex = waitpid(j->pid, &status, WNOHANG))) {
                    } else if (ex == j->pid) {
                        j->status = status;
                        rjb->dead++;
                        ifBLIN_QU3( rjb->flags
                                  , "pgoblin_getjob st=%08X fl=%08X ex=%d exx=%d IFEX=%d EXST=%d"
                                  , status
                                  , rjb->flags
                                  , ex
                                  , exx
                                  , WIFEXITED(status), WEXITSTATUS(status)
                                  );
                        if  (  (rjb->flags & PGOBLIN_ERROR_SENSOR)
                            && WIFEXITED(status)
                            && WEXITSTATUS(status)
                            ) exx = WEXITSTATUS(status);
                        if  ((rjb->flags & PGOBLIN_ERROR_SENSIB) && exx) break;
                        ex = EX_OK;
                    } else if (ex > 0) {
                        ifBLIN_QW0("Pid %d<>%d in %d", ex, j->pid, (int)j->cmdn);
                        ERROUT(EX_OSERR, ENOATTR);
                    } else if (errno == ECHILD || errno == EDEADLK || errno == EAGAIN) {
                        ex = EX_OK;
                    } else {
                        ifBLIN_QW0("Pid %d in %d", j->pid, (int)j->cmdn);
                        ex = EX_OSERR;
                        goto out;
                }   }
                fprintf(fi, "%d	%d	%d	%d\n", (int)i, (int)j->cmdn, j->pid, j->status);
            }
            fprintf(fi, "\\.\n");
            if  (fclose(fi) < 0) {
                ifBLIN_QW0("fclose on %d", rn[PGO_CJOB]);
                ex = EX_OSERR;
    }   }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex ? ex : exx);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_exec(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    char        **argv = NULL;
    pgoblin_rio  *rct;
    pgoblin_rjb  *rjb;
    int           ex   = EX_OK;
    int           jn;
    int           i;
    int           g    = 0;
    int           c;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+exec %c%c%c.%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    jn = rjb->flags & PGOBLIN_JOB_TYPE;
    g = pgoblin_db_resinfo(exenv, rn[PGO_CCTL], PGOBLIN_Nfields);
    i = 0;
    if  (0 > rct->cortege) {
        ERROUT(EX_PROTOCOL, EDOOFUS);
    }
    if  (g && !(argv = malloc((g + 1) * sizeof(char**)))) {
        ERROUT(EX_OSERR, ENOMEM);
    }
    for (c = 0; c < g; c++) {
        if  (!(pgoblin_db_valinfo(exenv, rn[PGO_CCTL], PGOBLIN_IsNull, rct->cortege, c))) {
            argv[i++] = pgoblin_db_getvalue(exenv, rn[PGO_CCTL], rct->cortege, c);
    }   }
    if  (i) {
        int eex;
        argv[i] = NULL;
        eex = pgoblin.jobtable[jn]->jxec(exenv, rn, argv);
        if  (eex) {
            ifBLIN_QO0 {
                int z;

                ifBLIN_QX0("Exec error on %d", rn[PGO_CJOB]);
                for (z = 0; argv[z]; z++) ifBLIN_QX0("[%d]=%s~", z, argv[z]);
            }
            if  (eex < 0) {
                if  (eex  < ex) ex = eex;
            } else if (ex >= 0) {
                if  (eex > ex) ex = eex;
    }   }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_fork(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rjb *rjb;
    int          ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+fork %c.%c.%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    /* if  (R_JOB) XXXX?? */
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    ex = pgoblin.jobtable[rjb->flags & PGOBLIN_DB_TYPE]->jork(exenv, rn);
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_wait(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rjb *j;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+wait ....%c.", pgoblin_regn[rn[PGO_CJOB]]);
    GET_JOB(j, exenv->options, rn[PGO_CJOB]);
    /* if  (R_JOB) XXXX?? */
    ex = pgoblin.jobtable[j->flags & PGOBLIN_JOB_TYPE]->jait(exenv, rn);
    MARK_R_JOB_GO(rn[PGO_CJOB]);;
    ;;  j->dead = MULAR_NEXT(j->pids);
    MARK_R_JOB_WENT(rn[PGO_CJOB]);;
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_untrap(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    ifBLIN_QX3("+untrap ......");
    exenv->flags &= ~PGOBLIN_TRAPDEF;
    ifBLIN_QX3("- %d", EX_OK);
    return(EX_OK);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_trap(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    ifBLIN_QX3("+trap ......");
    exenv->ctrap = exenv->ppoint + 1,
    exenv->flags |= PGOBLIN_TRAPDEF,
    exenv->lexlevel++;
    ifBLIN_QX3("- %d", EX_OK);
    return(EX_OK);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_call(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_UNAVAILABLE;

    ifBLIN_QX3( "+call ......");
    ifBLIN_QX3("- %d", ex);
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_eval(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_tuple *command;
    pgoblin_exenv *nexenv;
    pgoblin_rio   *rct;
    int            ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+eval .%c....", pgoblin_regn[rn[PGO_CCTL]]);
    if  (!(nexenv = calloc(1, sizeof(pgoblin_exenv)))) {
        ifBLIN_QW0("no mem for nexenv");
        ex = EX_OSERR;
        goto out;
    }
    nexenv->options = exenv->options;
    nexenv->flags = exenv->flags & BLIN_MASK;
    nexenv->stat = exenv;
    nexenv->dyna = exenv;
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  ((ex = pgoblin_parser(exenv->options, rct->text, rct->length, &nexenv->pgm, 0, NULL))) {
        ifBLIN_QW0("Parser failed in #eval");
    } else {
        nexenv->pgm->flags |= rct->flags & PGOBLIN_FREETEXT;
        if  (nexenv->options->flags & PGOBLIN_VERIFY) pgoblin_Vdump(nexenv->options, nexenv->pgm);
        if  ((ex = pgoblin_execute(nexenv->options, nexenv->pgm, nexenv->dyna, nexenv->stat, 0))) {
            if  (!(command = mular_getix(nexenv->pgm->code, nexenv->ppoint))) {
                ifBLIN_QW0("mular_getix %d", nexenv->ppoint);
                ex = EX_SOFTWARE;
                goto out;
            }
            ifBLIN_QX0( "cmd[%d]=%03X(%s %c%c%c%c%c%c) %08X Executor failed in #eval"
                      , nexenv->ppoint, command->cmd
                      , pgoblin.a[command->cmd & PGOBLIN_COMMAND].str
                      , pgoblin_regn[rn[0]], pgoblin_regn[rn[1]], pgoblin_regn[rn[2]]
                      , pgoblin_regn[rn[3]], pgoblin_regn[rn[4]], pgoblin_regn[rn[5]]
                      , pgoblin.a[command->cmd & PGOBLIN_COMMAND].flags
                      );
    }   }
out:
    if  (nexenv) {
        if  (nexenv->pgm) {
            if  (!!nexenv->pgm->code) mular_destroy(nexenv->pgm->code);
            free(nexenv->pgm);
        }
        free(nexenv);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_close(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rdb   *rdb;

    ifBLIN_QX3( "+eval %c.%c%c.%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    if  (rn[PGO_CCON]) {
        GET_CON(rdb, exenv->options, rn[PGO_CCON]);
        MARK_R_CONN_GO(rn[PGO_CCON]);;
        ;;  rdb->flags &= ~PGOBLIN_CLOSECONN;
        MARK_R_CONN_WENT(rn[PGO_CCON]);;
    }
out:
    ifBLIN_QX3("- %d", EX_OK);
    return(EX_OK);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_clear(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    ifBLIN_QX3( "+eval %c...%c%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CJOB]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    ifBLIN_QX3("- %d", EX_OK);
    return(EX_OK);
}

static void
/**********************************************************************
 **                                                                  **/
exitfin(pgoblin_exenv *exenv, pgoblin_nr *rn, int ex) {             /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rdb *rdb0;
    pgoblin_rdb *rdb;
    int          g;
    int          f;
    int          t;

    GET_CON(rdb0, exenv->options, 0);
    f = 0, t = pgoblin.regsize;
    if  (rn[PGO_CCON]) {
        f = rn[PGO_CCON];
        t = f + 1;
    }
    for (g = f; g < t; g++) {
        rdb = pgoblin_mecon(exenv->options, g);
        if  (!!rdb) {
            if  (!rn[PGO_CCON] || (g == rn[PGO_CCON])) {
                MARK_R_CONN_GO(g);;
                ;;  if  (rdb->flags & PGOBLIN_CLOSECONN) pgoblin_db_finish(exenv, rn[PGO_CCON]);
                ;;  rdb->conn = NULL;
                ;;  if  (rdb->flags & PGOBLIN_PARMDBFREE) free((char*)rdb->dbname);
                ;;  rdb->dbname = NULL;
                ;;  rdb->flags = rdb0->flags & PGOBLIN_DB_TYPE;
                ;;  rdb->host = NULL;
                ;;  rdb->port = NULL;
                ;;  rdb->username = NULL;
                ;;  rdb->intran = 0;
                MARK_R_CONN_WENT(g);;
            } else {
                MARK_R_CONN_GO(g);;
                ;;  rdb->flags &= ~PGOBLIN_CLOSECONN;
                MARK_R_CONN_WENT(g);;
    }   }   }
out:
    ifBLIN_QX3("pgoblin exit %d", ex);
    exit(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_return(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    int ex = EX_OK;

    ifBLIN_QX3("+return ...%c..", pgoblin_regn[rn[PGO_CCON]]);
    if  (exenv->flags & PGOBLIN_FORKED) exitfin(exenv, rn, ex);
    exenv->flags |= PGOBLIN_END;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_exit(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rct;
    int          ex = EX_OK;

    ifBLIN_QX3("+exit .%c.%c..", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CCON]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (rct->text) {
        ex = strtol(rct->text, NULL, 0);
    }
    exitfin(exenv, rn, ex);
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_begin(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rdb  *rdb;
    pgoblin_rio  *rct = NULL;
    pgoblin_rio  *rou = NULL;
    pgoblin_nr    nou = 0;
    pgoblin_nr    nct = 0;
    int           ex  = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (!rn[PGO_COUT]) {
        nou = PGOBLIN_REGSIZE - 1;
        if  (!(rou = pgoblin_pushio(exenv->options, nou))) {
           ifBLIN_QW0("No IO reg -");
           ex = -EX_CANTCREAT;
           goto out;
        }
    } else {
        nou = rn[PGO_COUT];
        GET_RIO(rou, exenv->options, nou);
    }
    if  (!rn[PGO_CCTL]) {
        nct = PGOBLIN_REGSIZE - 1;
        if  (nou == (PGOBLIN_REGSIZE - 1)) {
            rct = rou;
        } else if (!(rct = pgoblin_pushio(exenv->options, nou))) {
            ifBLIN_QW0("No CTL reg -");
            ex = -EX_CANTCREAT;
            goto out;
        }
        if  (!(rdb->intran++)) rct->text = "BEGIN;";
    } else {
        nct = rn[PGO_CCTL];
        GET_RIO(rct, exenv->options, nct);
    }
    ifBLIN_QX3( "+begin %%.%c.."
              , pgoblin_regn[nou]
              , pgoblin_regn[nct]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    if  (!!rct->text) {
        MARK_R_CONN_GO(rn[PGO_CCON]);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        ;;  rdb->flags |= PGOBLIN_CR_OK;
        MARK_R_CONN_WENT(rn[PGO_CCON]);;
        if  (!!(ex = pgoblin_db_query(exenv, rn[PGO_CCON], nou, nct))) {
            ifBLIN_QW0("query=%s~", rct->text);
    }   }
out:
    if  (!!rou) {
        MARK_IO_PQ_GO(nou);;
        ;;  pgoblin_db_clear(exenv, nou);
        MARK_IO_PQ_WENT(nou);;
    }
    if  (nou == (PGOBLIN_REGSIZE - 1)) {
        MARK_IO_PQ_GO(PGOBLIN_REGSIZE - 1);;
        ;;  pgoblin_popio(exenv->options, PGOBLIN_REGSIZE - 1);
        MARK_IO_PQ_WENT(PGOBLIN_REGSIZE - 1);;
    } else if (nct == (PGOBLIN_REGSIZE - 1)) {
        MARK_IO_TEXT_GO(PGOBLIN_REGSIZE - 1);;
        ;;  pgoblin_popio(exenv->options, PGOBLIN_REGSIZE - 1);
        MARK_IO_TEXT_WENT(PGOBLIN_REGSIZE - 1);;
    }
    MARK_R_CONN_GO(rn[PGO_CCON]);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_WENT(rn[PGO_CCON]);;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_end(pgoblin_exenv *exenv, pgoblin_nr *rn) {                 /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rdb  *rdb;
    pgoblin_rio  *rct = NULL;
    pgoblin_rio  *rou = NULL;
    pgoblin_nr    nou = 0;
    pgoblin_nr    nct = 0;
    int           ex  = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (!rdb->intran) {
        ifBLIN_QX0("Non transaction end");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!rn[PGO_COUT]) {
        nou = PGOBLIN_REGSIZE - 1;
        if  (!(rou = pgoblin_pushio(exenv->options, nou))) {
            ifBLIN_QW0("No IO reg -");
            ex = -EX_CANTCREAT;
            goto out;
        }
    } else {
        nou = rn[PGO_COUT];
        GET_RIO(rou, exenv->options, nou);
    }
    if  (!rn[PGO_CCTL]) {
        nct = PGOBLIN_REGSIZE - 1;
        if  (nou == (PGOBLIN_REGSIZE - 1)) {
            rct = rou;
        } else if (!(rct = pgoblin_pushio(exenv->options, nou))) {
           ifBLIN_QW0("No CTL reg -");
           ex = -EX_CANTCREAT;
           goto out;
        }
        if  (!(--rdb->intran)) rct->text = "END;";
    } else {
        nct = rn[PGO_CCTL];
        GET_RIO(rct, exenv->options, nct);
    }
    ifBLIN_QX3( "+end %c%c.%c.."
              , pgoblin_regn[nou]
              , pgoblin_regn[nct]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    if  (!!rct->text) {
        MARK_R_CONN_GO(rn[PGO_CCON]);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        ;;  rdb->flags |= PGOBLIN_CR_OK;
        MARK_R_CONN_WENT(rn[PGO_CCON]);;
        if  (!!(ex = pgoblin_db_query(exenv, rn[PGO_CCON], nou, nct))) {
            ifBLIN_QW0("query=%s~", rct->text);
    }   }
out:
    if  (!!rou) {
        MARK_IO_PQ_GO(nou);;
        ;;  pgoblin_db_clear(exenv, nou);
        MARK_IO_PQ_WENT(nou);;
    }
    if  (nou == (PGOBLIN_REGSIZE - 1)) {
        MARK_IO_PQ_GO(PGOBLIN_REGSIZE - 1);;
        ;;  pgoblin_popio(exenv->options, PGOBLIN_REGSIZE - 1);
        MARK_IO_PQ_WENT(PGOBLIN_REGSIZE - 1);;
    } else if (nct == (PGOBLIN_REGSIZE - 1)) {
        MARK_IO_TEXT_GO(PGOBLIN_REGSIZE - 1);;
        ;;  pgoblin_popio(exenv->options, PGOBLIN_REGSIZE - 1);
        MARK_IO_TEXT_WENT(PGOBLIN_REGSIZE - 1);;
    }
    MARK_R_CONN_GO(rn[PGO_CCON]);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_WENT(rn[PGO_CCON]);;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_rollbk(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rdb  *rdb;
    pgoblin_rio  *rct = NULL;
    pgoblin_rio  *rou = NULL;
    pgoblin_nr    nou = 0;
    pgoblin_nr    nct = 0;
    int           ex  = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (!rn[PGO_COUT]) {
        nou = PGOBLIN_REGSIZE - 1;
        if  (!(rou = pgoblin_pushio(exenv->options, nou))) {
            ifBLIN_QW0("No OUT reg -");
            ex = -EX_CANTCREAT;
            goto out;
        }
    } else {
        nou = rn[PGO_COUT];
        GET_RIO(rou, exenv->options, nou);
    }
    if  (!rn[PGO_CCTL]) {
        nct = PGOBLIN_REGSIZE - 1;
        if  (nou == (PGOBLIN_REGSIZE - 1)) {
            rct = rou;
        } else if (!(rct = pgoblin_pushio(exenv->options, nou))) {
           ifBLIN_QW0("No CTL reg -");
           ex = -EX_CANTCREAT;
           goto out;
        }
        rct->text = "ROLLBACK;";
    } else {
        nct = rn[PGO_CCTL];
        GET_RIO(rct, exenv->options, nct);
    }
    ifBLIN_QX3( "+rollback %c%c.%c.."
              , pgoblin_regn[nou]
              , pgoblin_regn[nct]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    if  (!!rct->text) {
        MARK_R_CONN_GO(rn[PGO_CCON]);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        ;;  rdb->flags |= PGOBLIN_CR_OK;
        MARK_R_CONN_WENT(rn[PGO_CCON]);;
        if  (!!(ex = pgoblin_db_query(exenv, rn[PGO_CCON], nou, nct))) {
            ifBLIN_QW0("query=%s~", rct->text);
    }   }
    exenv->flags |= PGOBLIN_ROLLBACK;
out:
    if  (!!rou) {
        MARK_IO_PQ_GO(nou);;
        ;;  pgoblin_db_clear(exenv, nou);
        MARK_IO_PQ_WENT(nou);;
    }
    if  (nou == (PGOBLIN_REGSIZE - 1)) {
        MARK_IO_PQ_GO(PGOBLIN_REGSIZE - 1);;
        ;;  pgoblin_popio(exenv->options, PGOBLIN_REGSIZE - 1);
        MARK_IO_PQ_WENT(PGOBLIN_REGSIZE - 1);;
    } else if (nct == (PGOBLIN_REGSIZE - 1)) {
        MARK_IO_TEXT_GO(PGOBLIN_REGSIZE - 1);;
        ;;  pgoblin_popio(exenv->options, PGOBLIN_REGSIZE - 1);
        MARK_IO_TEXT_WENT(PGOBLIN_REGSIZE - 1);;
    }
    MARK_R_CONN_GO(rn[PGO_CCON]);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_WENT(rn[PGO_CCON]);;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_listen(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int64_t             timeout;
    char               *notify;
    pgoblin_longnotify *lnote;
    int64_t             itime;
    pgoblin_rdb        *rdb;
    pgoblin_rio        *rct;
    int64_t             now;
    pgoblin_rio        *rou;
    pgoblin_rio        *rin;
    int                 ex = EX_OK;
    pgoblin_dbases     *db;
    struct timeval      t;
    int                 e;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+listen %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    if  (!rin->text || (rin->length < sizeof(int64_t))) {
        ifBLIN_QX1(" IN[%d]: no timeout", rn[PGO_CIN]);
    } else {
        /* Should be 64 bit time wait to in usec from 1970-01-01 00:00:00 UTC          *
         * (date_part('epoch', t) * 1000000)::int8                                     *
         * , where t - time wait to                                                    *
         *******************************************************************************/
        itime = recobe_loadM(rin->text, "76543210");
        GET_CON(rdb, exenv->options, rn[PGO_CCON]);
        db = DBASE(rdb->flags);
        for (; !ex;) {
            if  (gettimeofday(&t, NULL)) {
        ;       ifBLIN_QW0("gettimeofday:");
        ;       ex = EX_OSERR;
        ;       break;
        ;   }
        ;   now = (int64_t)1000000LL * t.tv_sec + t.tv_usec;
        ;   timeout = (itime - now + 999) / 1000;
        ;   if  ((timeout) <= 0) {
        ;       ifBLIN_QX0("tarry notime");
        ;       break;
        ;   } else if (timeout > exenv->options->maxtmout) {
        ;       timeout = exenv->options->maxtmout;
        ;   } else if (timeout > 0x000000007FFFFFFFLL) {
        ;       timeout = 0x7FFFFFFF;
        ;   }
        ;   ifBLIN_QX3("LISTEN=%s~ for %d ms", (char*)rct->text, (int)timeout);
        ;   e = db->tarry(exenv, rn[PGO_CCON], (int)timeout);
        ;   if  (0 > e) {
        ;       ifBLIN_QW0("tarry error");
        ;       ex = e;
        ;       break;
        ;   } else if (!e) {
        ;       if  (!db->erconn) {
        ;           ifBLIN_QX1("tarry timeout");
        ;       } else {
        ;           ifBLIN_QX1("tarry timeout: %s", db->erconn(exenv, rn[PGO_CCON]));
        ;       }
        ;       break;
        ;   }
        ;   if  (PGOBLIN_LONGNOTIFY & db->flags) {
        ;       for (e = 0; !!(lnote = db->notifies(exenv, rn[PGO_CCON]));) {
        ;           ifBLIN_QX3( "Received NOTIFY=%s~ mess=%s~ other=%s from %d"
                              , lnote->tail
                              , &lnote->tail[lnote->majorlen]
                              , &lnote->tail[lnote->majorlen + lnote->minorlen]
                              , lnote->ident
                              );
        ;           if  (!rct->text) {
        ;               e = 1;
        ;           } else {
        ;               e = !strcmp(lnote->tail, rct->text);
        ;           }
        ;           if  (!!e) break;
        ;       }
        ;       if  ((!lnote) && (!!errno)) {
        ;           ifBLIN_QW1("notifies %d", e);
        ;       } else if ((!!lnote) && !!rn[PGO_COUT]) {
                    const char   *tail[3];
                    char          pid[8];

        ;           GET_RIO(rou, exenv->options, rn[PGO_COUT]);
        ;           tail[0] = lnote->tail;
        ;           tail[1] = &lnote->tail[lnote->majorlen];
        ;           if  (8 < snprintf(pid, 8, "%d", lnote->ident)) {
        ;               ifBLIN_QX1("Short space for notify ident");
        ;           }
        ;           tail[2] = pid;
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           ;;  if  (!!(ex = pgoblin_db0_create(exenv, rn[PGO_COUT], 3, tail, NULL))) {
        ;           ;;      ifBLIN_QW0("pgoblin_db0_create");
        ;           ;;      goto out;
        ;           ;;  }
        ;           ;;  rou->flags |= PGOBLIN_PQRESULT;
        ;           MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        ;       }
        ;       if  (!!lnote) pgoblin_db_denote(exenv, rn[PGO_CCON], (void**)&lnote);
        ;   } else {
        ;       for (e = 0; !!(notify = db->notifies(exenv, rn[PGO_CCON]));) {
        ;           ifBLIN_QX3("Received NOTIFY=%s~", notify);
        ;           if  (!rct->text) {
        ;               e = 1;
        ;           } else {
        ;               e = !strcmp(notify, rct->text);
        ;           }
        ;           pgoblin_db_denote(exenv, rn[PGO_CCON], (void**)&notify);
        ;   }   }
            if  (e) break;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#define L0 0 /* \0           */
#define Ll 1 /*   */
#define Lb 2 /*        */
#define Ls 3 /*    */
#define Ld 4 /* #            */
#define Lo 5 /*     */
#define Lx 6

static const size_t msz[] = {1024, 512, 512};
static const char *clasnames[] = { "L0", "Ll", "Lb", "Ls", "Ld", "Lo", "Lx"};

static const u_char class[256] =
{ L0, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lb, Ll, Ll,  Lo, Ll, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lb, Lo, Lo, Ld,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Lo,  Lo, Lo, Lo, Ls
, Lo, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Ls,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Ls,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
};

static const char statenames[][3] =
{ "bg", "bs", "nq", "tc", "tb", "xx"};

enum states
{ bg /*                                           */
, bs /*                                                 */
, nq /*     ?                       */
, tc /*                           */
, tb /*        */
, xx
};
static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "- ", "- ", "Ci", "- ", "- ", "- ", "- ", "- "
, "Co", "Cl", "Cn", "Cf", "- ", "Cx", "- ", "- "
};

#define Ci  0x200000 /*     */
#define Co  0x008000 /*        */
#define Cl  0x004000 /*                 */
#define Cn  0x002000 /*                      */
#define Cf  0x001000 /*               */
#define Cx  0x000400 /*                    */
#define C_state 0xFF /*           */

static u_int32_t automa[xx][Lx] =
/* \0 L0  \n Ll  \b Lb  Ls   # Ld   * Lo   *    @          */
{{ Cx|xx,    bg,    bs,       bs,    nq,    bs }/* bg @                   */
,{ Cx|xx,    bg,    bs,       bs,    bs,    bs }/* bs @                   */
,{ Cx|xx,    bg,    bs, Co|Cl|tc,    bs,    bs }/* nq @ 1           */
,{ Cx|xx, Cn|bs, Cf|tb,    Cl|tc, Cn|bs, Cx|xx }/* tc              */
,{ Cx|xx, Cn|bs,    tb,    Ci|bs, Cn|bs, Cn|bs }/* tb          */
};

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_style(pgoblin_exenv *exenv, pgoblin_nr *rn) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    size_t       candidate = 0;
    int          lfcount;
    u_int32_t    control;
    size_t       offset;
    enum states  state;
    size_t       found     = 0;
    int          cmp       = 0;
    pgoblin_rst *rst;
    pgoblin_rio *rin;
    pgoblin_rio *rct;
    int          ex        = EX_OK;
    int          rs        = 0;
    size_t       d         = 0;
    int          i;
    char        *q;
    u_char       p;
    u_char       s;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+style .%c%c..%c"
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    if  (!rn[PGO_CSTY]) {
        ifBLIN_QX0("Try to change style 0");
        ERROUT(EX_DATAERR, EINVAL);
    }
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!rct->text) {
        ifBLIN_QX0("No pgoblin style name");
        ERROUT(EX_DATAERR, EINVAL);
    }
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    if  (!rin->text) {
        ifBLIN_QX0("No pgoblin style text");
        ERROUT(EX_DATAERR, EINVAL);
    }
    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    q = rin->text;
    if  (!!rin->stymd) {
        for (i = 0; i < (int)MULAR_NEXT(rin->stymd); ++i) {
            offset = *(size_t*)mular_getix(rin->stymd, i);
            cmp = strcmp(&q[offset], (char*)rct->text);
            ifBLIN_QX3("%s %d %s", &q[offset], cmp, (char*)rct->text);
            if  (!cmp) {
                for (found = offset + 1 + strlen(&q[offset]); Lb == class[q[found] & 0xFF]; ++found) {}
                break;
        }   }
    } else {
        MARK_IO_TEXT_GO(rn[PGO_CIN]);;
        ;;  rin->stymd = mular_create(MULAR_ZERO, 3, sizeof(size_t), msz);
        ;;  MARK_IO_MIFE_GO(rn[PGO_CIN]);;
        ;;  ;;  rin->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_FREEMIFE); /* XXXX */
        ;;  MARK_IO_MIFE_WENT(rn[PGO_CIN]);;
        MARK_IO_TEXT_WENT(rn[PGO_CIN]);;
        if  (!rin->stymd) {
            ifBLIN_QX0("No mem");
            ERROUT(EX_OSERR, ENOMEM);
        }
        blin_stateheader(BLIN_5STO24G, pn);
        lfcount = 1;
        for (state = bg, offset = 0, control = 0; state < xx; offset++, state = control & C_state) {
            if  (((rin->flags & PGOBLIN_BINPARM) || rin->length) && (offset >= rin->length)) {
                p = L0;
                s = 0;
            } else {
                s = q[offset];
                p = class[s];
                if  (s == '\n') lfcount++;
            }
            control = automa[state][p];
            blin_statebody( BLIN_5STO24G
                          , pn
                          , statenames
                          , clasnames[p]
                          , q
                          , offset
                          , control
                          , state
                          , found
                          , rs
                          );
            if  ((control & Ci) && !found && !cmp) found = offset;
            if  (control & Co) {
                cmp = 0, d = 0;
                candidate = offset;
                q[offset - 1] = '\0';
            }
            if  (control & Cl) {
                cmp |= (((char*)rct->text)[d++] - q[offset]);
            }
            if  (control & Cn) {
                candidate = 0;
            }
            if  (control & Cf) {
                q[offset] = '\0';
                if  ((!(rct->flags & PGOBLIN_BINPARM) && !rct->length) || (d < rct->length)) {
                    cmp |= ((u_char*)rct->text)[d++];
                }
                if  (!!candidate) {
                    size_t *ix;
                    ix = mular_add(rin->stymd);
                    if  (!ix) {
                        ifBLIN_QW0("mular_add");
                        ex = EX_OSERR;
                        goto out;
                    }
                    *ix = candidate;
                }
                candidate = 0;
            }
            if  ((control & Cx) && !found) {
                ifBLIN_QX0("Erroneous style %"BLIN_D, found);
                ERROUT(EX_DATAERR, EINVAL);
    }   }   }
    if  (!!found) {
        for (rs = 0, offset = found; Ls == class[q[offset] & 0xFF]; ++offset) ++rs;
        if  (0 > (i = pgoblin_load(exenv->options, 5, &q[found], rs))) {
            ifBLIN_QX0("Invalid style interpretor name=%.*s~", rs, &q[found]);
            ERROUT(EX_DATAERR, EINVAL);
        } else {
            MARK_R_STYLE_GO(rn[PGO_CSTY]);;
            ;;  rst->path = NULL;
            ;;  rst->flags = (exenv->options->flags & BLIN_MASK) | i;
            MARK_R_STYLE_WENT(rn[PGO_CSTY]);;
            if  ((ex = STYLS(rst->flags)->parser(exenv, rn[PGO_CSTY], &q[found + rs]))) {
                ifBLIN_QX0("style parser fail");
            }
            if  (exenv->options->flags & PGOBLIN_VERIFY) {
                STYLS(rst->flags)->dump(exenv, rn[PGO_CSTY]);
            }
            goto out;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static const babolo_lexor modsel =
/* 0(FF) - 
 * 1(FE) - 
 * 2(FD) -  
 * 3(FC) -    
 * 4(FB) -   
 */
{ (u_char*)class, NULL, Bpars_AABS, 0x07, 0x07, 1
, { /*00*/ 1, L0,0xFE, Ls,0x03, 0xFF
  , /*03*/ 2, L0,0xFD, Ls,0x03, Lb,0xFB, 0xFC
} };

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_connect(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    u_int32_t    nwflags = PGOBLIN_PARMIN;
    pgoblin_rdb *rdb;
    pgoblin_rio *rct;
    int          ex      = EX_OK;
    int          i;
    char        *q;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+connect .%c.%c..", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CCON]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!(q = rct->text)) {
        ifBLIN_QX1("Empty DB #1");
        goto out;
    }
    switch(babolo_goword(&modsel, (const char**)&q)) {
    case 0 : ifBLIN_QX0("Illegal DB");
           ; ERROUT(EX_DATAERR, EINVAL);
    case 1 : ifBLIN_QX1("Empty DB #2");
           ; goto out;
    case 3 : ifBLIN_QX1("Illegal DB separator");
           ; *--q = '\0';
           ; /* FALLTHRU */
    case 2 : q = NULL;
           ; break;
    case 4 : *--q = '\0';
           ; q++;
           ; break;
    default: ifBLIN_QX0("Internal error");
           ; ERROUT(EX_SOFTWARE, EINVAL);
    }
    ifBLIN_QX3("db=%s%s%s~", (char*)rct->text, q ? "~\nparm=" : "", q ? q : "");
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (0 > (i = pgoblin_load(exenv->options, 3, rct->text, -1))) {
        ifBLIN_QX0("Invalid DBMS name %s", (char*)rct->text);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!!q && (rct->flags & PGOBLIN_FREETEXT)) {
        if  (!(q = strdup(q))) {
            ifBLIN_QX0("pgoblin_connect: no mem");
            ERROUT(EX_OSERR, ENOMEM);
        }
        nwflags |= PGOBLIN_PARMDBFREE;
    }
    MARK_R_CONN_GO(rn[PGO_CCON]);;
    ;;  rdb->flags = (exenv->options->flags & BLIN_MASK) | nwflags | i;
    ;;  rdb->dbname = q;
    MARK_R_CONN_WENT(rn[PGO_CCON]);;
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_job(pgoblin_exenv *exenv, pgoblin_nr *rn) {                 /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    u_int32_t    nwflags = 0;
    u_int32_t    svflags;
    babolo_opts *bos     = NULL;
    pgoblin_rjb *rjb;
    char        *jbn;
    pgoblin_rio *rct;
    int          ex      = EX_OK;
    babolo_parm *bp;
    u_int32_t    u       = 0;
    int          c;
    const char  *p;
    char        *q;
    int          i;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+job .%c..%c.", pgoblin_regn[rn[PGO_CCTL]], pgoblin_regn[rn[PGO_CJOB]]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!(q = jbn = rct->text)) {
        ifBLIN_QX1("Empty JOB #1");
        goto out;
    }
    switch(babolo_goword(&modsel, (const char**)&q)) {
    case 0 : ifBLIN_QX0("Illegal JOB");
           ; ERROUT(EX_DATAERR, EINVAL);
    case 1 : ifBLIN_QX1("Empty JOB #2");
           ; goto out;
    case 3 : ifBLIN_QX1("Illegal JOB separator");
           ; *--q = '\0';
           ; /* FALLTHRU */
    case 2 : q = NULL;
           ; break;
    case 4 : *--q = '\0';
           ; q++;
           ; break;
    default: ifBLIN_QX0("Internal error");
           ; ERROUT(EX_SOFTWARE, EINVAL);
    }
    if  (0 > (i = pgoblin_load(exenv->options, 4, jbn, -1))) {
        ifBLIN_QX0("Invalid job module name %s", jbn);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!!q) {
        ifBLIN_QX4("opt=%s~", q);
        if  (!(bp = babolo_getparm(Bpars_NOEN | Bpars_NOAL, &q, "", 0))) {
            ifBLIN_QW0("babolo_getparm");
            ex = EX_SOFTWARE;
            goto out;
        }
        if  (!(bos = babolo_openopts(exenv->options->flags & BLIN_MASK, 0))) {
            ifBLIN_QW0("babolo_openopts");
            ex = EX_SOFTWARE;
            goto out;
        }
        if  (babolo_setopts(bos, 0, bp->argc, bp->argv, "zZ")) {
            ifBLIN_QW0("babolo_setopts");
            ex = EX_SOFTWARE;
            goto out;
        }
        while (0 < (c = babolo_getopts(bos))) {
            switch (c) {
            case 'z': nwflags |= (nwflags & PGOBLIN_ERROR_SENSOR) << 1;
                    ; nwflags |= PGOBLIN_ERROR_SENSOR;
                    ; break;
            case 'Z': nwflags &= ~(PGOBLIN_ERROR_SENSIB | PGOBLIN_ERROR_SENSOR);
                    ; break;
            default : ifBLIN_QX0("Illegal job flag");
        }   }
        ifBLIN_QX3("nwflags=%08X", nwflags);
        if  ((p = babolo_getargs(bos)) && *p) {
            errno = 0;
            u = strtoul(p, NULL, 0);
            if  (errno) {
                ifBLIN_QW0("No num =%s~", p);
                u = 0;
    }   }   }
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    if  ((rjb->flags & PGOBLIN_JOB_TYPE) == i) {
        svflags = rjb->flags & ~(BLIN_MASK | PGOBLIN_ERROR_SENSIB | PGOBLIN_ERROR_SENSOR);
        MARK_R_JOB_GO(rn[PGO_CJOB]);;
        ;;  rjb->flags = (exenv->options->flags & BLIN_MASK) | svflags | nwflags;
        ;;  rjb->concur = u;
        MARK_R_JOB_WENT(rn[PGO_CJOB]);;
    } else {
        ex = pgoblin.jobtable[rjb->flags & PGOBLIN_JOB_TYPE]->jose(exenv, rn);
        MARK_R_JOB_GO(rn[PGO_CJOB]);;
        ;;  mular_destroy(rjb->pids);
        ;;  rjb->pids = NULL;
        ;;  rjb->host = NULL;
        ;;  rjb->concur = u;
        ;;  rjb->dead = 0;
        ;;  rjb->flags = (exenv->options->flags & BLIN_MASK) | nwflags | i;
        MARK_R_JOB_WENT(rn[PGO_CJOB]);;
        ifBLIN_QW0("Close JOB in #job");
    }
    pgoblin.jobtable[rjb->flags & PGOBLIN_JOB_TYPE]->jpen(exenv, rn, bos);
    if  (bos) babolo_closeopts(bos);
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
