/*-
 * Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_select.c,v 1.113 2022/05/01 20:40:19 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

const char *
/**********************************************************************
 **                                                                  **/
pgoblin_decond(BLIN_flag cond) {                                    /**
 **                                                                  **
 **********************************************************************/
    static const char *ret[] = {"OK", "TUPL", "OUT", "IN", "SSEL", "BSEL", "BTUPL", "unkn"};
    int         i;

    i = cond & PGOBLIN_CR_MASK;
    if  (i > PGOBLIN_CR_MAX) i = PGOBLIN_CR_MAX;
    return(ret[i >> PGOBLIN_CR_SHIFT]);
}

static int
/**********************************************************************
 **                                                                  **/
presel(pgoblin_exenv *exenv, pgoblin_nr *rn, BLIN_flag cond) {      /**
 **                                                                  **
 **********************************************************************/
    pgoblin_rdb  *rdb = NULL;
    pgoblin_rio  *rou  = NULL;
    pgoblin_rio  *rct;
    int           row;
    int           col;
    pgoblin_rio  *rin;
    pgoblin_rio  *rio;
    int           ex   = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    if  (!(rio = pgoblin_pushio(exenv->options, PGOBLIN_REGSIZE - 1))) {
       ifBLIN_QW0("No IO reg -");
       ex = -EX_CANTCREAT;
       goto out;
    }
    if (rct->text) ifBLIN_QX3(" =%s", (char*)rct->text);
    MARK_R_CONN_GO(rn[PGO_CCON]);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    ;;  rdb->flags |= cond;
    MARK_R_CONN_WENT(rn[PGO_CCON]);;
    if  ((rct->flags & PGOBLIN_PQRESULT) && !!rct->pq) {
        ssize_t ctupc; /*   CTL  ctupc */

        ctupc = pgoblin_db_resinfo(exenv, rn[PGO_CCTL], PGOBLIN_Ntuples);
        ifBLIN_QX5("CTLNtuples=%d", ctupc);
        for (ssize_t ctupn = 0; ctupn < ctupc; ++ctupn) {
            MARK_IO_TEXT_GO(rn[PGO_CCTL]);;
        ;   ;;  if  (!!rct->text && (rct->flags & PGOBLIN_FREETEXT)) {
        ;   ;;      free(rct->text);
        ;   ;;      rct->text = NULL;
        ;   ;;  }
        ;   ;;  ex = pgoblin_style_0.table(exenv, 0, rn[PGO_CCTL], rn[PGO_CCTL], ctupn, -3);
        ;   ;;  if  (0 > ex) {
        ;   ;;      ifBLIN_QW0("No STYLE 0");
        ;   ;;      goto out;
        ;   ;;  }
        ;   ;;  rct->flags |= PGOBLIN_FREETEXT;
        ;   MARK_IO_TEXT_WENT(rn[PGO_CCTL]);;
        ;   ex = 0;
        ;   if  (  !!rn[PGO_CIN]
                && !!rin->pq
                && !!(col = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Nfields))
                ) {
        ;       /*   IN */
        ;       ifBLIN_QX5( "INfields=%d INtuples=%d"
                          , pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Nfields)
                          , pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Ntuples)
                          );
        ;       if  (!(row = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Ntuples))) {
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           ;;  rou->pq = pgoblin_db00(exenv->options->flags);
        ;           ;;  rou->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
        ;           ;;  rou->cortege = -1;
        ;           MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        ;           goto out;
        ;       }
        ;       ifBLIN_QX4("%d rows x %d cols", row, col);
        ;       if  (DBASE(rdb->flags)->flags & PGOBLIN_DB_PREPARE) {
        ;           ex = pgoblin_db_prepare(exenv, rn[PGO_CCON], PGOBLIN_REGSIZE - 1, rn[PGO_CCTL]);
        ;           if  (!!ex) {
        ;               ifBLIN_QX0( "%s: prepare=%s"
                                  , pgoblin_decond(cond)
                                  , pgoblin_db_erinfo(exenv, rn[PGO_COUT])
                                  );
        ;               MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;               ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
        ;               MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        ;               ERROUT(EX_SOFTWARE, EDOOFUS);
        ;           }
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           ;;  ex = pgoblin_db_prexec( exenv
                 /* ;; */                     , rn[PGO_CCON]
                 /* ;; */                     , rn[PGO_COUT]
                 /* ;; */                     , PGOBLIN_REGSIZE - 1
                 /* ;; */                     , rn[PGO_CIN]
                 /* ;; */                     );
        ;       } else {
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           ;;  ex = pgoblin_db_execute( exenv
                 /* ;; */                      , rn[PGO_CCON]
                 /* ;; */                      , rn[PGO_COUT]
                 /* ;; */                      , rn[PGO_CCTL]
                 /* ;; */                      , rn[PGO_CIN]
                 /* ;; */                      );
        ;       }
        ;       MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        ;       if  (!!ex) {
        ;           ifBLIN_QX0( "%s: execute Q=%s"
                              , pgoblin_decond(cond)
                              , pgoblin_db_erinfo(exenv, rn[PGO_COUT])
                              );
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
        ;           MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        ;           ERROUT(EX_SOFTWARE, EDOOFUS);
        ;       }
        ;       ifBLIN_QX6("ctupn %"BLIN_D" to ctupc %"BLIN_D, ctupn, ctupc);
        ;       if  (  (ctupn + 1 < ctupc)
                    || ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT])
                    ) {
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           pgoblin_db_clear(exenv, rn[PGO_COUT]);
        ;           MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        ;       } else {
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           ;;  if  (rou->pq) rou->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
        ;           ;;  rou->cortege = -1;
        ;           MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        ;       }
        ;   } else {
        ;       if  ((ex = pgoblin_db_query(exenv, rn[PGO_CCON], rn[PGO_COUT], rn[PGO_CCTL]))) {
        ;           ifBLIN_QX0( "%s: query=%s"
                              , pgoblin_decond(cond)
                              , pgoblin_db_erinfo(exenv, rn[PGO_COUT])
                              );
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
        ;           MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        ;           ERROUT(EX_SOFTWARE, EDOOFUS);
        ;       }
        ;       if  (  (ctupn + 1 < ctupc)
                    || ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT])
                    ) {
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
        ;           MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        ;       } else {
        ;           MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;           ;;  if  (rou->pq) rou->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
        ;           ;;  rou->cortege = -1;
                    MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        }   }   }
    } else if (!rct->text) {
        ifBLIN_QX1("pgoblin_select: No query");
    } else if (!rn[PGO_CIN] || !rin->pq) {
        /*   */
        ifBLIN_QX5("0 0");
        if  (!!(ex = pgoblin_db_query(exenv, rn[PGO_CCON], rn[PGO_COUT], rn[PGO_CCTL]))) {
            ifBLIN_QX0("%s: query=%s", pgoblin_decond(cond), pgoblin_db_erinfo(exenv, rn[PGO_COUT]));
            MARK_IO_PQ_GO(rn[PGO_COUT]);;
            ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
            MARK_IO_PQ_WENT(rn[PGO_COUT]);;
            ERROUT(EX_SOFTWARE, EDOOFUS);
        }
        if  ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT]) {
            MARK_IO_PQ_GO(rn[PGO_COUT]);;
            ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
            MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        } else {
            MARK_IO_PQ_GO(rn[PGO_COUT]);;
            ;;  if  (rou->pq) rou->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
            ;;  rou->cortege = -1;
            MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        }
    } else if ((rdb->flags & PGOBLIN_DB_TYPE) == pgoblin_load(exenv->options, 3, "0", -1)) {
        /*   DB 0 */
        if (rct->text) ifBLIN_QX5(" =%s", (char*)rct->text);
        MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;;  ex = pgoblin_db_execute(exenv, rn[PGO_CCON], rn[PGO_COUT], rn[PGO_CCTL], rn[PGO_CIN]);
        MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        if  (!!ex) {
            ifBLIN_QX0( "%d:%s: execute 0=%s"
                      , ex
                      , pgoblin_decond(cond)
                      , pgoblin_db_erinfo(exenv, rn[PGO_COUT])
                      );
            MARK_IO_PQ_GO(rn[PGO_COUT]);;
            ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
            MARK_IO_PQ_WENT(rn[PGO_COUT]);;
            ERROUT(EX_SOFTWARE, EDOOFUS);
        }
        if  ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT]) {
            MARK_IO_PQ_GO(rn[PGO_COUT]);;
            ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
            MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        } else {
            MARK_IO_PQ_GO(rn[PGO_COUT]);;
            ;;  if  (rou->pq) rou->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
            ;;  rou->cortege = -1;
            MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        }
    } else {
        ifBLIN_QX5( "INfields=%d INtuples=%d"
                  , pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Nfields)
                  , pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Ntuples)
                  );
        if  (!(row = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Ntuples))) {
            MARK_IO_PQ_GO(rn[PGO_COUT]);;
            ;;  rou->pq = pgoblin_db00(exenv->options->flags);
            ;;  rou->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
            ;;  rou->cortege = -1;
            MARK_IO_PQ_WENT(rn[PGO_COUT]);;
            goto out;
        }
        ifBLIN_QX4("%d rows", row);
        if  (DBASE(rdb->flags)->flags & PGOBLIN_DB_PREPARE) {
            if  ((ex = pgoblin_db_prepare(exenv, rn[PGO_CCON], PGOBLIN_REGSIZE - 1, rn[PGO_CCTL]))) {
                ifBLIN_QX0( "%s: prepare=%s"
                          , pgoblin_decond(cond)
                          , pgoblin_db_erinfo(exenv, PGOBLIN_REGSIZE - 1)
                          );
                MARK_IO_PQ_GO(rn[PGO_COUT]);;
                ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
                MARK_IO_PQ_WENT(rn[PGO_COUT]);;
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            MARK_IO_PQ_GO(rn[PGO_COUT]);;
            ;;  ex = pgoblin_db_prexec( exenv
         /* ;; */                     , rn[PGO_CCON]
         /* ;; */                     , rn[PGO_COUT]
         /* ;; */                     , PGOBLIN_REGSIZE - 1
         /* ;; */                     , rn[PGO_CIN]
         /* ;; */                     );
            MARK_IO_PQ_WENT(rn[PGO_COUT]);;
            if  (!!ex) {
                ifBLIN_QX0( "%s: execute Q=%s"
                          , pgoblin_decond(cond)
                          , pgoblin_db_erinfo(exenv, rn[PGO_COUT])
                          );
                MARK_IO_PQ_GO(rn[PGO_COUT]);;
                ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
                MARK_IO_PQ_WENT(rn[PGO_COUT]);;
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            if  ((PGOBLIN_CR_OK != cond) || !!rn[PGO_COUT]) {
                MARK_IO_PQ_GO(rn[PGO_COUT]);;
                ;;  if  (rou->pq) rou->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
                ;;  rou->cortege = -1;
                MARK_IO_PQ_WENT(rn[PGO_COUT]);;
            }
        } else {
            MARK_IO_PQ_GO(rn[PGO_COUT]);;
            ;;  ex = pgoblin_db_execute(exenv, rn[PGO_CCON], rn[PGO_COUT], rn[PGO_CCTL], rn[PGO_CIN]);
            MARK_IO_PQ_WENT(rn[PGO_COUT]);;
            if  (!!ex) {
                ifBLIN_QX0( "%s: execute Q=%s"
                          , pgoblin_decond(cond)
                          , pgoblin_db_erinfo(exenv, rn[PGO_COUT])
                          );
                MARK_IO_PQ_GO(rn[PGO_COUT]);;
                ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
                MARK_IO_PQ_WENT(rn[PGO_COUT]);;
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            if  ((PGOBLIN_CR_OK == cond) && !rn[PGO_COUT]) {
                MARK_IO_PQ_GO(rn[PGO_COUT]);;
                ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
                MARK_IO_PQ_WENT(rn[PGO_COUT]);;
            } else {
                MARK_IO_PQ_GO(rn[PGO_COUT]);;
                ;;  if  (rou->pq) rou->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
                ;;  rou->cortege = -1;
                MARK_IO_PQ_WENT(rn[PGO_COUT]);;
    }   }   }
out:
    if  (!!rdb) {
        MARK_R_CONN_GO(rn[PGO_CCON]);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        MARK_R_CONN_WENT(rn[PGO_CCON]);;
    }
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_perform(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+perform %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    ex = presel(exenv, rn, PGOBLIN_CR_OK);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_select(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+select %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    ex = presel(exenv, rn, PGOBLIN_CR_TUPL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_binpre(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+binpresel %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    ex = presel(exenv, rn, PGOBLIN_CR_BTUPL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_display(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rst *rst;
    ssize_t      ex = EX_SOFTWARE;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+display %c.%c..%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    ex = STYLS(rst->flags)->table(exenv, rn[PGO_CSTY], rn[PGO_COUT], rn[PGO_CIN], 0, -2);
    if  (ex < 0) ifBLIN_QX0("pgoblin_display: write error");
out:
    ifBLIN_QX3("- %"BLIN_D, ex);
    return((ex < 0) ? ex : 0);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
sel(pgoblin_exenv *exenv, pgoblin_nr *rn, BLIN_flag cond) {         /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    int          ex   = 0;
    ssize_t      e    = 0;
    pgoblin_rdb *rdb = NULL;
    pgoblin_rst *rst;
    pgoblin_rio *rou;
    pgoblin_rio *rct;
    ssize_t      k;
    size_t       i;
#   define       aim  (INT_MAX / 2)
#   define       aid                                                                                  \
    ((PGOBLIN_BUFMULT * PGOBLIN_BUFSIZE > (aim / 4)) ? (aim / 4) : (PGOBLIN_BUFMULT * PGOBLIN_BUFSIZE))

    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!rct->text) {
        ifBLIN_QX0("pgoblin_strsel: No query");
        ERROUT(EX_DATAERR, EINVAL);
    }
    MARK_IO_PQ_GO(rn[PGO_COUT]);;
    ;;  rou->cortege = -1;
    MARK_IO_PQ_WENT(rn[PGO_COUT]);;
    MARK_R_CONN_GO(rn[PGO_CCON]);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    ;;  rdb->flags |= cond;
    MARK_R_CONN_WENT(rn[PGO_CCON]);;
    if  ((ex = pgoblin_db_query(exenv, rn[PGO_CCON], rn[PGO_COUT], rn[PGO_CCTL]))) goto out;
    for (k = 0, i = 1; ; ) {
        int typn;

        MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;;  if  ((ex = pgoblin_db_getstream(exenv, rn[PGO_CCON], rn[PGO_COUT], i))) goto out;
        MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        typn = pgoblin_db_resinfo(exenv, rn[PGO_COUT], PGOBLIN_Ntuples);
        e = STYLS(rst->flags)->table( exenv
                                    , rn[PGO_CSTY]
                                    , rn[PGO_COUT]
                                    , rn[PGO_COUT]
                                    , k
                                    , typn ? -1 : -2
                                    );
        if  ((e < 0) || (typn <= 0)) break;
        k += typn;
        ifBLIN_QX3("e=%d=>%"BLIN_D" aim=%d i %"BLIN_D" => ", typn, e, aim, i);
        if  (e < (aim * 2)) {
            if  (i < (aid / 2)) i = i * 2; else i = aid;
        } else if (e < aim) {
            if  (i < (aid / aim * e)) i = i / e * aim; else i = aid;
        } else if ((e / 2) > aim) {
            i = i / 4;
        } else if (e > aim) {
            i = i / e * aim;
        }
        ifBLIN_QX3("%"BLIN_D, i);
    }
    pgoblin_db_clear(exenv, rn[PGO_COUT]);
    if  (e < 0) ifBLIN_QX0("pgoblin_strsel: write error");
out:
    /* XXXX END      ? */
    if  (!!rdb) {
        ex = pgoblin_db_endstream(exenv, rn[PGO_CCON]);
        MARK_R_CONN_GO(rn[PGO_CCON]);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        MARK_R_CONN_WENT(rn[PGO_CCON]);;
    }
    ifBLIN_QX3( "- %s %"BLIN_D
              , (cond == PGOBLIN_CR_SSEL)
              ? "pgoblin_strsel"
              : (cond == PGOBLIN_CR_BSEL) ? "pgoblin_binsel" : "pgoblin_???sel"
              , (e < 0) ? e : ex
              );
    return((e < 0) ? e : ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_strsel(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;

    ifBLIN_QX3( "+strselect %c%c.%c.%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CCON]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    ex = sel(exenv, rn, PGOBLIN_CR_SSEL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_binsel(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;

    ifBLIN_QX3( "+binselect %c%c.%c.%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CCON]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    ex = sel(exenv, rn, PGOBLIN_CR_BSEL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
}
