/*-
 * Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_copy.c,v 1.86 2022/03/26 22:17:10 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

enum fich {fn, fs, fp, fo, fx};
enum finde {finde_beg, finde_eol, finde_bsl, finde_dot, finde_end}; /* "\n\\.\n" */
/* static const char *fichn[] = {"fn", "fs", "fp", "fo", "fx"};
 * static const char *finden[] = {"finde_beg", "finde_eol", "finde_bsl", "finde_dot", "finde_end"};
 */

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_copyout(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rdb  *rdb;
    pgoblin_rio  *rct;
    pgoblin_rio  *rou;
    void         *buf;
    ssize_t       e = 0;
    int           f;

    ifBLIN_QX3( "+copyout %c%c.%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  (!e && !rct->text) {
        ifBLIN_QX0("No query");
        e = -1;
        goto out;
    }
    if  (!e) {
        MARK_R_CONN_GO(rn[PGO_CCON]);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        ;;  rdb->flags |= PGOBLIN_CR_OUT;
        MARK_R_CONN_WENT(rn[PGO_CCON]);;
        e = pgoblin_db_query(exenv, rn[PGO_CCON], rn[PGO_COUT], rn[PGO_CCTL]);
        if  (e) {
            e = -1;
            goto out;
        }
        for (; (f = pgoblin_db_getcopy(exenv, rn[PGO_CCON], &buf)) > 0 && e >= 0;) {
            ifBLIN_QX2("%d buf=%s", f, (char*)buf);
            if  (strcmp("\\.", buf) == 0) {
                if  (exenv->options->flags & PGOBLIN_COPEND_PASS)
                    e = pgoblin_wr(rou, buf, f);
                free(buf);
                break;
            }
            e = pgoblin_wr(rou, buf, f);
            free(buf);
        }
        if  ((e < 0) || (f < 0)) {
            ifBLIN_QX0("getcopy error");
            e = f;
        }
        MARK_IO_PQ_GO(rn[PGO_COUT]);;
        ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
        MARK_IO_PQ_WENT(rn[PGO_COUT]);;
        if  (pgoblin_db_endstream(exenv, rn[PGO_CCON])) {
            e = -1;
            goto out;
    }   }
    if  (e < 0) {
        ifBLIN_QX0("write error");
    } else if (exenv->options->flags & PGOBLIN_COPEND_APND) {
        e = pgoblin_wr(rou, "\\.\n", 0);
    }
    if  (e < 0) {
        ifBLIN_QX0("write end error");
    }
    MARK_IO_PQ_GO(rn[PGO_COUT]);;
    ;;  pgoblin_db_clear(exenv, rn[PGO_COUT]);
    MARK_IO_PQ_WENT(rn[PGO_COUT]);;
out:
    MARK_R_CONN_GO(rn[PGO_CCON]);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_WENT(rn[PGO_CCON]);;
    ifBLIN_QX3("- %"BLIN_D, e);
    return(e < 0 ? (int)e : 0);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_copyin(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_rdb  *rdb;
    pgoblin_rio  *rct;
    pgoblin_rio  *rin;
    pgoblin_rio  *rou;
    pgoblin_nr    nou;
    int           ee;                                                /*   putcopy */
    int           ex = 0;                                             /*   putcopy */
    ssize_t       f  = 0;
    char         *d;
    char         *q;
    enum finde    k;
                                                   /*    "\n\\.\n"    */
    const enum fich fich[256] =
    {fn,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fn,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fp,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fs,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    };
    const u_char automa[finde_end][fx] =
    /*      fn         fs         fp         fo */
    {{ finde_eol, finde_beg, finde_beg, finde_beg} /*finde_beg*/
    ,{ finde_beg, finde_bsl, finde_beg, finde_beg} /*finde_eol*/
    ,{ finde_beg, finde_beg, finde_dot, finde_beg} /*finde_bsl*/
    ,{ finde_end, finde_beg, finde_beg, finde_beg} /*finde_dot*/
    };

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    if  (!rn[PGO_COUT]) {
        nou = PGOBLIN_REGSIZE - 1;
        if  (!(rou = pgoblin_pushio(exenv->options, nou))) {
           ifBLIN_QW0("No IO reg -");
           ex = -EX_CANTCREAT;
           goto out;
        }                                 
    } else {
        nou = rn[PGO_COUT];
        GET_RIO(rou, exenv->options, nou);
    }
    ifBLIN_QX3( "+copyin %c%c%c%c.."
              , pgoblin_regn[nou]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    GET_CON(rdb, exenv->options, rn[PGO_CCON]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    d = NULL;                                                                  /*   COPY */
    if  (!ex && !rct->text) {
        ifBLIN_QX0("No query");
        ex = -1;
    }
    if  (!rin->mife) {
        ifBLIN_QX0("No input data");
        ex = -1;
    }
    if  (!ex) {
        MARK_R_CONN_GO(rn[PGO_CCON]);;
        ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
        ;;  rdb->flags |= PGOBLIN_CR_IN;
        MARK_R_CONN_WENT(rn[PGO_CCON]);;
        if  (!!(ex = pgoblin_db_query(exenv, rn[PGO_CCON], rn[PGO_COUT], rn[PGO_CCTL]))) {
            ifBLIN_QW0("Error query=%s~", rct->text);
            ex = -1;
            goto out;
        }
/*      if  (0 > (ex = pgoblin_db_resinfo(exenv, rn[PGO_COUT], PGOBLIN_Nfields))) {
 *          ifBLIN_QW0("Error Nfields in query=%s~", rct->text);
 *          ex = -1;
 *          goto out;
 *      }
 */
        ifBLIN_QX3("Copy %d columns @%"BLIN_X" + %"BLIN_X, ex, (size_t)mife_offset(rin->mife), f);
        ex = 0;
        MARK_IO_PQ_GO(nou);;
        ;;  pgoblin_db_clear(exenv, nou);
        MARK_IO_PQ_WENT(nou);;
        k = finde_eol;
        do {
            char *ofbase;

            if  ((f = mife_read(rin->mife, PGOBLIN_BUFSIZE, mife_offset(rin->mife) + f)) < 0) {
                ifBLIN_QW0("mife_read");
                ex = -1;
            }
            ifBLIN_QX4("mife_read=%"BLIN_D, BLIN_I(f));
            ofbase = mife_get(rin->mife, mife_offset(rin->mife));
            if  (!ex) {
                for ( q = ofbase
                    ; q < (ofbase + f) && k != finde_end
                    ; k = automa[k][fich[(u_char)*q++]]
                    ) {
                    ifBLIN_QX4("%c", *q);
                }
                if  (q - ofbase) {
                    ex = (pgoblin_db_putcopy(exenv, rn[PGO_CCON], ofbase, q - ofbase) < 1);
                    ifBLIN_QX3("putcopy=%d %d (%"BLIN_D")", ex, k, BLIN_I(q - ofbase));
                } else {
                    ifBLIN_QX3("no putcopy=%d %d (%"BLIN_D")", ex, k, BLIN_I(q - ofbase));
            }   }
        } while((f > 0) && (ex == 0));
        if  (!ex && k != finde_end) {                      /*  ()    */
            const char *enstin = "\n\\.\n";
            ifBLIN_QX2("end=%s~%d", &enstin[k], finde_end - k);
            ex = (pgoblin_db_putcopy(exenv, rn[PGO_CCON], &enstin[k], finde_end - k) < 1);
            ifBLIN_QX3("putcopy=%d %d (%d)", ex, k, finde_end - k);
        }
        if  (ex) {                                              /*       */
            ifBLIN_QX0("putcopy failed");
            ex = -1;
        }
        ee = pgoblin_db_endstream(exenv, rn[PGO_CCON]);
        if  (!ex && (ee < 0)) {                                 /*       */
            ex = -1;
            ifBLIN_QX0("endcopy failed");
    }   }
    MARK_IO_PQ_GO(nou);;
    ;;  pgoblin_db_clear(exenv, nou);
    MARK_IO_PQ_WENT(nou);;
    MARK_R_CONN_GO(rn[PGO_CCON]);;
    ;;  rdb->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_WENT(rn[PGO_CCON]);;
out:
    if  (nou == (PGOBLIN_REGSIZE - 1)) {
        MARK_IO_PQ_GO(nou);;
        ;;  pgoblin_db_clear(exenv, nou);
        ;;  pgoblin_popio(exenv->options, PGOBLIN_REGSIZE - 1);
        MARK_IO_PQ_WENT(nou);;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
nulen(u_int64_t i) {
    int l = 1;

    if  (i > 9ULL) ++l;
    if  (i > 99ULL) ++l;
    if  (i > 999ULL) ++l;
    if  (i > 9999ULL) ++l;
    if  (i > 99999ULL) ++l;
    if  (i > 999999ULL) ++l;
    if  (i > 9999999ULL) ++l;
    if  (i > 99999999ULL) ++l;
    if  (i > 999999999ULL) ++l;
    if  (i > 9999999999ULL) ++l;
    if  (i > 99999999999ULL) ++l;
    if  (i > 999999999999ULL) ++l;
    if  (i > 9999999999999ULL) ++l;
    if  (i > 99999999999999ULL) ++l;
    if  (i > 999999999999999ULL) ++l;
    if  (i > 9999999999999999ULL) ++l;
    if  (i > 99999999999999999ULL) ++l;
    if  (i > 999999999999999999ULL) ++l;
    return(l);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getmeta(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          coln;
    char        *buf;
    pgoblin_rio *rou;
    pgoblin_rio *rin;
    ssize_t      e = 0;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getmeta %c.%c..."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CIN]]
              );
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  (!rin->pq) {
        ifBLIN_QX0("No query");
        e = -1;
        goto out;
    }
    coln = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Nfields);
    for (int i = 0; i < coln; ++i) {
        const char *cn;
        const char *ct;
        ssize_t     st;
        ssize_t     sz;
        int         l;
        int         k;

        l = 2 + (3 * 4 /* 4 fields for future*/);
        l += nulen(i);
        cn = pgoblin_db_subinfo(exenv, rn[PGO_CIN], PGOBLIN_ColName, i);
        ct = pgoblin_db_subinfo(exenv, rn[PGO_CIN], PGOBLIN_TypeNm, i);
        st = pgoblin_db_valinfo(exenv, rn[PGO_CIN], PGOBLIN_TypeMod, 0, i);
        sz = pgoblin_db_valinfo(exenv, rn[PGO_CIN], PGOBLIN_ColSize, 0, i);
        if  (cn) l += strlen(cn) * 2 + 1; else l += 3;
        if  (ct) l += strlen(ct) * 2 + 1; else l += 3;
        if  (0 <= st) {
            l += nulen(st);
        } else {
            if (PGOBLIN_SSIZE_MIN != st) l += nulen(-st) + 1; else l += 3;
        }
        if  (0 <= sz) l += nulen(sz); else l += 3;
        if  (!(buf = malloc(l))) {
            ifBLIN_QW0("no RAM");
            e = -EX_OSERR;
            goto out;
        }
        k = snprintf(buf, l, "%d", i);
        l -= k;
        buf[k++] = '\t';
        l--;
        if  (0 > (e = pgoblin_onecopy(&buf[k], cn, -1, -1))) {
            ifBLIN_QW0("COPY format");
            goto out;
        }
        l -= e;
        k += e;
        if  (0 > (e = pgoblin_onecopy(&buf[k], ct, -1, -1))) {
            ifBLIN_QW0("COPY format");
            goto out;
        }
        l -= e;
        k += e;
        if  (PGOBLIN_SSIZE_MIN != st) {
            e = snprintf(&buf[k], l, "%ld", st);
            l -= e;
            k += e;
            buf[k++] = '\t';
            l--;
        } else if (0 > (e = pgoblin_onecopy(&buf[k], NULL, -1, -1))) {
            ifBLIN_QW0("COPY format");
            goto out;
        } else {
            l -= e;
            k += e;
        }
        if  (0 <= sz) {
            e = snprintf(&buf[k], l, "%ld", sz);
            l -= e;
            k += e;
            buf[k++] = '\t';
            l--;
        } else if (0 > (e = pgoblin_onecopy(&buf[k], NULL, -1, -1))) {
            ifBLIN_QW0("COPY format");
            goto out;
        } else {
            l -= e;
            k += e;
        }
        if  (0 > (e = pgoblin_onecopy(&buf[k], NULL, -1, 1))) {
            ifBLIN_QW0("COPY format");
            goto out;
        }
        l -= e;
        k += e;
        if  (0 > (e = pgoblin_wr(rou, buf, k))) {
            ifBLIN_QW0("write error");
            free(buf);
            goto out;
        }
        free(buf);
    }
    if  (exenv->options->flags & PGOBLIN_COPEND_APND) {
        if  (0 > (e = pgoblin_wr(rou, "\\.\n", 3))) ifBLIN_QW0("write end error");
    }
out:
    ifBLIN_QX3("- %"BLIN_D, e);
    return(e < 0 ? (int)e : 0);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_info(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int64_t      ibuf[4];
    char        *buf[4];
    const char  *cuf[7] = {NULL, NULL, NULL, NULL, NULL, NULL, NULL};
    pgoblin_rio *rou;
    pgoblin_rio *rin;
    int          ex      = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+info %c.%c..."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CIN]]
              );
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  (!rin->pq) {
        ifBLIN_QX0("No query");
        ex = EX_USAGE;
        goto out;
    }
    ibuf[0] = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Ntuples);
    ibuf[1] = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Nfields);
    ibuf[2] = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Nchange);
    ibuf[3] = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_LastOid);
    if  ((0 <= ibuf[0]) && (0 > asprintf(&buf[0], "%ld", ibuf[0]))) {
        ifBLIN_QW0("asprintf");
        ex = EX_USAGE;
        goto out;
    }
    if  ((0 <= ibuf[1]) && (0 > asprintf(&buf[1], "%ld", ibuf[1]))) {
        ifBLIN_QW0("asprintf");
        ex = EX_USAGE;
        goto out;
    }
    if  ((0 <= ibuf[2]) && (0 > asprintf(&buf[2], "%ld", ibuf[2]))) {
        ifBLIN_QW0("asprintf");
        ex = EX_USAGE;
        goto out;
    }
    if  ((0 <= ibuf[3]) && (0 > asprintf(&buf[3], "%ld", ibuf[3]))) {
        ifBLIN_QW0("asprintf");
        ex = EX_USAGE;
        goto out;
    }
    for (int i = 0; i < 4; ++i) cuf[i] = buf[i];
    cuf[6] = pgoblin_db_subinfo(exenv, rn[PGO_CIN], PGOBLIN_CmdStat, 0);
    MARK_IO_PQ_GO(rn[PGO_COUT]);;
    ;;  if  (!!(ex = pgoblin_db0_create(exenv, rn[PGO_COUT], 7, cuf, NULL))) {
    ;;      ifBLIN_QW0("pgoblin_db0_create");
    ;;      goto out;
    ;;  }
    ;;  rou->cortege = -1;
    ;;  rou->flags |= PGOBLIN_PQRESULT;
    MARK_IO_MIFE_WENT(rn[PGO_COUT]);;
    for (int i = 0; i < 4; ++i) free(buf[i]);
out:
    ifBLIN_QX3("- %"BLIN_D, ex);
    return(ex);
#   undef blin_internal_flags
}
