/*-
 * Copyright (C)2017..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2017..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: trace.c,v 1.12 2022/01/22 23:31:11 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    4
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sysexits.h>
#include <strings.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

pgoblin_main           *pgoblin_options;
static const size_t     msz[] = {1024, 512, 512};
static mular_descriptor*filenm = NULL;

static int
/************************************************************************
 **                                                                    **/
pgoblin_xwrt(pgoblin_main *options, const void *buf, int len) {       /**
 **                                                                    **
 ************************************************************************/
    int wrt;

    errno = 0;
    if  (len == (wrt = mife_writ(options->xtrace, buf, len))) {
        wrt = 0;
    }
    return(wrt);
}

void
/**************************************************************************************
 **************************************************************************************
 ****                                                                   ****
 **************************************************************************************
 ****                                                                              ****/
pgoblin_toexe(int cmd, pgoblin_exenv *exenv, pgoblin_nr rn[pgoblin.symparam]) {   /****
 ****                                                                              ****
 **************************************************************************************
 **************************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    if  (!!exenv->options->ftrace) {
        u_char         buf[PGOBLIN_GOEXECU];
        int            binreg;
        int            symreg;
        pgoblin_exenv *c;
        int16_t        d;
        int16_t        s;

        for (s = 0, c = exenv; c; c = c->stat) s++;
        for (d = 0, c = exenv; c; c = c->dyna) d++;
        bzero(buf, PGOBLIN_GOEXECU);
        buf[0] = (cmd >> 8) | 0x0C0;
        buf[1] = cmd & 0x0FF;
        recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, getpid());
        for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
            if  (0 <= (binreg = pgoblin_breg(cmd, symreg))) {
                buf[PGOBLIN_GOSHORT + binreg] = rn[symreg];
        }   }
        recobe_store(&buf[PGOBLIN_GOCMD], sizeof(int16_t), s);
        recobe_store(&buf[sizeof(int16_t) + PGOBLIN_GOCMD], sizeof(int16_t), d);
        recobe_store(&buf[sizeof(int16_t) * 2 + PGOBLIN_GOCMD], sizeof(int32_t), exenv->ppoint);
        if  (0 > (exenv->options->xtrace = open( exenv->options->ftrace
                                               , O_WRONLY | O_APPEND | O_EXLOCK
            )     )                            ) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", exenv->options->ftrace);
        } else {
            int wrt;

            if  (!!(wrt = pgoblin_xwrt(exenv->options, buf, PGOBLIN_GOEXECU))) {
                ifBLIN_QW0("pgoblin_xwrt %d <> %d", wrt, PGOBLIN_GOEXECU);
            }
            close(exenv->options->xtrace);
}   }   }
#   undef blin_internal_flags

static int
/**********************************************************************
 **                                                                  **/
putnum(pgoblin_main *options, u_int32_t num) {                      /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    u_char  buff[10];
    ssize_t wrt;
    int     ex = EX_OK;
    int     l;

    l = recobe_cstore(buff, num);
    if  (!!(wrt = pgoblin_xwrt(options, buff, l))) {
        ifBLIN_QW0("pgoblin_xwrt %d", wrt);
        ex = EX_IOERR;
    }
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************
 **                                                                         **/
putext(pgoblin_main *options, const char *text, ssize_t length, int bin) { /**
 **                                                                         **
 *****************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    char    null = 0xFF;
    ssize_t strl;
    ssize_t wrt;
    int     ex   = EX_OK;

    if  (!text) {
        if  (!!(wrt = pgoblin_xwrt(options, &null, 1))) {
            ifBLIN_QW0("mife_writ %d <> 1", wrt);
        }
    } else {
        if (!!bin || !!length) {
           strl = length;
        } else {
           strl = strlen(text);
        }
        if  (strl > 0x000000007FFFFFFFLL) {
            ifBLIN_QX0("string too big %"BLIN_X, strl);
        } else if (!!(ex = putnum(options, strl))) {
            ifBLIN_QW0("putnum");
            goto out;
        } else if (!!(wrt = pgoblin_xwrt(options, text, strl))) {
            ifBLIN_QW0("mife_writ %"BLIN_D" <> %"BLIN_D, wrt, strl);
    }   }
out:
    return(ex);
#   undef blin_internal_flags
}

int
/**************************************************************************
 **************************************************************************
 ****                                                                  ****/
pgoblin_wident(pgoblin_main *options, int num, char *entry) {         /****
 ****                                                                  ****
 **************************************************************************
 **************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int            ex = EX_OK;
    u_char         buf[PGOBLIN_GOSHORT];
    size_t         len;

    if  (0 <= options->xtrace) {
        buf[0] = 0xA0;
        buf[1] = num;
        recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, getpid());
        len = strnlen(entry, PGOBLIN_STRING_ID_LEN);
        if  (0 > (options->xtrace = open(options->ftrace, O_WRONLY | O_APPEND | O_EXLOCK))) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", options->ftrace);
        } else {
            int wrt;

            if  (!!(wrt = pgoblin_xwrt(options, buf, PGOBLIN_GOSHORT))) {
                ifBLIN_QW0("pgoblin_xwrt %d <> %d", wrt, PGOBLIN_GOSHORT);
            }
            putext(options, entry, len, 1);
            entry += PGOBLIN_STRING_ID_LEN;
            len = strnlen(entry, PGOBLIN_STRING_ID_LEN);
            if  (len < PGOBLIN_STRING_ID_LEN) {
                putext( options
                      , entry + len + 1
                      , strnlen(entry + len + 1, PGOBLIN_STRING_ID_LEN - len - 1)
                      , 1
                      );
            } else {
                putext(options, NULL, 0, 0);
            }
            putext(options, entry, len, 1);
            close(options->xtrace);
        }
        ifBLIN_QX3( "- %d", ex);
    }
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_cmdexe(int cmd, pgoblin_exenv *exenv, pgoblin_nr *rn) {     /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_char         buf[PGOBLIN_GOEXECU];
    char           null = 0xFF;
    int8_t         binreg;
    int8_t         symreg;
    ssize_t        wrt;
    int            ex;

    if  (PGOBLIN_max <= cmd) {
        ifBLIN_QX0("cmd = %03X", cmd);
        ex = EX_DATAERR;
        goto out;
    }
    ifBLIN_QX3( "+#%s %c%c%c%c%c%c %08X"
              , pgoblin.a[cmd].str
              , pgoblin_regn[rn[0]]
              , pgoblin_regn[rn[1]]
              , pgoblin_regn[rn[2]]
              , pgoblin_regn[rn[3]]
              , pgoblin_regn[rn[4]]
              , pgoblin_regn[rn[5]]
              , pgoblin.a[cmd].flags
              );
    if  (!!exenv->options->ftrace) {
        {   pgoblin_exenv *c;
            int16_t        d;
            int16_t        s;

        ;   for (s = 0, c = exenv; c; c = c->stat) s++;
        ;   for (d = 0, c = exenv; c; c = c->dyna) d++;
        ;   bzero(PGOBLIN_GOSHORT + buf, pgoblin.binparam);
        ;   buf[0] = (cmd >> 8) | 0x0E0;
        ;   buf[1] = cmd & 0x0FF;
        ;   recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, getpid());
        ;   for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
        ;       if  (0 <= (binreg = pgoblin_breg(cmd, symreg))) {
        ;           buf[PGOBLIN_GOSHORT + binreg] = rn[symreg];
        ;   }   }
        ;   recobe_store(&buf[PGOBLIN_GOCMD], sizeof(int16_t), s);
        ;   recobe_store(&buf[sizeof(int16_t) + PGOBLIN_GOCMD], sizeof(int16_t), d);
            recobe_store(&buf[sizeof(int16_t) * 2 + PGOBLIN_GOCMD], sizeof(int32_t), exenv->ppoint);
        }
        if  (0 > (exenv->options->xtrace = open( exenv->options->ftrace
                                               , O_WRONLY | O_APPEND | O_EXLOCK
            )     )                            ) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", exenv->options->ftrace);
        } else {
            if  (!!(wrt = pgoblin_xwrt(exenv->options, buf, PGOBLIN_GOEXECU))) {
        ;       ifBLIN_QW0("mife_writ %d <> %d", wrt, PGOBLIN_GOEXECU);
        ;   }
        ;   for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
        ;       if  (0 <= (binreg = pgoblin_breg(cmd, symreg))) {
                    pgoblin_nr   nio = buf[PGOBLIN_GOSHORT + binreg] & 0x03F;
                    pgoblin_rio *rio;

        ;           rio = pgoblin_meio(exenv->options, nio);
        ;           ifBLIN_QX4("%d io%08X ch%02X", symreg, rio, pgoblin.a[cmd].ch[binreg]);
#ifndef NOTRACE_PATHPARM
        ;           if  (PGOBLIN_PATHPARM & pgoblin.a[cmd].ch[binreg]) {
        ;               ifBLIN_QX4("[%d]PATHPARM", binreg);
        ;               putext(exenv->options, !rio ? NULL : rio->path, 0, 0);
        ;           }
#endif
#ifndef NOTRACE_TEXTPARM
        ;           if  (PGOBLIN_TEXTPARM & pgoblin.a[cmd].ch[binreg]) {
        ;               ifBLIN_QX4("[%d]TEXTPARM", binreg);
        ;               putext( exenv->options
                              , !rio ? NULL : rio->text
                              , !rio ? 0 : rio->length
                              , !rio ? 0 : rio->flags & PGOBLIN_BINPARM
                              );
        ;           }
#endif
#ifndef NOTRACE_MIFEDES
        ;           if  (PGOBLIN_MIFEDES & pgoblin.a[cmd].ch[binreg]) {
        ;               ifBLIN_QX4("[%d]MIFEDES", binreg);
        ;           }
#endif
#ifndef NO_PQRESULT
        ;           if  (PGOBLIN_PQRESULT & pgoblin.a[cmd].ch[binreg]) {
                        int     row;
                        int     col;
                        int32_t v;

        ;           ;   ifBLIN_QX4("[%d]PQRESULT", binreg);
        ;           ;   if  (!rio || !rio->pq) {
        ;           ;       if  (!!(wrt = pgoblin_xwrt(exenv->options, &null, 1))) {
        ;           ;           ifBLIN_QW0("mife_writ %d <> 1", wrt);
        ;           ;       }
        ;           ;   } else {
        ;           ;       if  (0 > (v = pgoblin_db_resinfo(exenv, nio, PGOBLIN_Ntuples))) {
        ;           ;           ifBLIN_QW0("resinfo Ntuples");
        ;           ;           goto out;
        ;           ;       } else if (!!(ex = putnum(exenv->options, v))) {
        ;           ;           ifBLIN_QW0("putnum");
        ;           ;           goto out;
        ;           ;       }
        ;           ;       if  (0 > (v = pgoblin_db_resinfo(exenv, nio, PGOBLIN_Nfields))) {
        ;           ;           ifBLIN_QW0("resinfo Nfields");
        ;           ;           goto out;
        ;           ;       } else if (!!(ex = putnum(exenv->options, v))) {
        ;           ;           ifBLIN_QW0("putnum");
        ;           ;           goto out;
        ;           ;       }
        ;           ;       if  (0 > rio->cortege) {
        ;           ;           if  (!!(wrt = pgoblin_xwrt(exenv->options, &null, 1))) {
        ;           ;               ifBLIN_QW0("pgoblin_xwrt %d <> 1", wrt);
        ;           ;               goto out;
        ;           ;           }
        ;           ;       } else if (!!(ex = putnum(exenv->options, rio->cortege))) {
        ;           ;           ifBLIN_QW0("putnum");
        ;           ;           goto out;
        ;           ;       }
        ;           ;       for ( row = 0
                                ; row < pgoblin_db_resinfo(exenv, nio, PGOBLIN_Ntuples)
                                ; ++row
                                ) {
        ;           ;           for (col = 0; col < v; ++col) {
        ;           ;               if  (!!pgoblin_db_valinfo(exenv, nio, PGOBLIN_IsNull, row, col)) {
        ;           ;                   putext(exenv->options, NULL, 0, 0);
        ;           ;               } else {
        ;           ;                   putext( exenv->options
                                              , pgoblin_db_getvalue(exenv, nio, row, col)
                                              , pgoblin_db_valinfo( exenv
                                                                  , nio
                                                                  , PGOBLIN_Length
                                                                  , row
                                                                  , col
                                                                  )
                                              , 0
                                              );
        ;           }   }   }   }   }
#endif
#ifndef NOTRACE_CONNECT
        ;           if  (PGOBLIN_CONNECT & pgoblin.a[cmd].ch[binreg]) {
        ;           ;   ifBLIN_QX4("[%d]CONNECT", binreg);
        ;           }
#endif
#ifndef NOTRACE_JOB
        ;           if  (PGOBLIN_JOB & pgoblin.a[cmd].ch[binreg]) {
        ;           ;   ifBLIN_QX4("[%d]JOB", binreg);
        ;           }
#endif
        ;           if  (PGOBLIN_STYLE & pgoblin.a[cmd].ch[binreg]) {
#ifndef NOTRACE_STYLE
        ;           ;   ifBLIN_QX4("[%d]STYLE", binreg);
#endif
        }   }   }   }
        close(exenv->options->xtrace);
        exenv->options->xtrace = -1;
    }
    ex = (*(pgoblin.a[cmd].car))(exenv, rn);
out:
    ifBLIN_QX3( "- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/************************************************************************
 **                                                                    **/
putfilenm(pgoblin_main *options, const char *nm) {                    /**
 **                                                                    **
 ************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    u_char       buf[PGOBLIN_GOSHORT + sizeof(int16_t)];
    int          nmnum = -1;
    int          cmp   = -1;
    int          i;
    const char **c;

    if  (!filenm) filenm = mular_create(MULAR_ZERO | MULAR_CHAR, 3, sizeof(char*), msz);
    if  (!filenm) {
        ifBLIN_QW0("mular_create");
        nmnum = -EX_OSERR;
        goto out;
    }
    for (i = 0; i < (int)MULAR_NEXT(filenm); ++i) {
        if  (!(cmp = strcmp(nm, *(const char **)mular_getix(filenm, i)))) {
            nmnum = i;
            break;
    }   }
    if  (!!cmp) {
        nmnum = MULAR_NEXT(filenm);
        if  (!(c = mular_add(filenm))) {
            ifBLIN_QW0("mular_add");
            nmnum = -EX_OSERR;
            goto out;
        }
        *c = nm;
        buf[0] = 0x60;
        buf[1] = 0;
        recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, getpid());
        recobe_store(&buf[PGOBLIN_GOSHORT], sizeof(int16_t), nmnum);
        if  (0 > (options->xtrace = open(options->ftrace, O_WRONLY | O_APPEND | O_EXLOCK))) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", options->ftrace);
        } else {
            int wrt;

            if  (!!(wrt = pgoblin_xwrt(options, buf, PGOBLIN_GOSHORT + sizeof(int16_t)))) {
                ifBLIN_QW0("pgoblin_xwrt %d <> %d", wrt, PGOBLIN_GOSHORT + sizeof(int16_t));
            }
            putext(options, nm, 0, 0);
            close(options->xtrace);
    }   }
out:
    ifBLIN_QX5(" [%d] %s", nmnum, nm);
    return(nmnum);
#   undef blin_internal_flags
}

void
/*****************************************************************************
 *****************************************************************************
 **                                                                         **/
pgoblin_go( pgoblin_nr  r     /*                                */
/**/      , int         f     /*    pgoblin_syntax.ch[]  *-1 */
/**/      , const char *file  /*                            */
/**/      , const char *func  /*                                   */
/**/      , int         line  /*                        */
/**/      ) {                                                              /**
 **                                                                         **
 *****************************************************************************
 *****************************************************************************/
#   define blin_internal_flags (pgoblin_options->flags & BLIN_MASK)
    if  (!!pgoblin_options && !!pgoblin_options->ftrace) {
        u_char    buf[PGOBLIN_GOSHORT + sizeof(u_int16_t)];
        int       nfile;
        int       i;

        nfile = putfilenm(pgoblin_options, file);
        switch(f) {
        case PGOBLIN_STYLE   :
        case PGOBLIN_JOB     :
        case PGOBLIN_CONNECT :
        case PGOBLIN_OUTSET  :
        case PGOBLIN_PQRESULT:
        case PGOBLIN_MIFEDES :
        case PGOBLIN_TEXTPARM:
        case PGOBLIN_PATHPARM:
            buf[0] = f;
            buf[1] = r;
            break;
        default              :
            buf[0] = 0;
            buf[1] = f;
        }
        recobe_store(&buf[PGOBLIN_HEDLN], PGOBLIN_PIDLN, getpid());
        recobe_store(&buf[PGOBLIN_GOSHORT], sizeof(u_int16_t), nfile);
        if  (0 > (pgoblin_options->xtrace = open( pgoblin_options->ftrace
                                                , O_WRONLY | O_APPEND | O_EXLOCK
            )     )                             ) {
            ifBLIN_QW0("open(%s, WRONLY|APPEND|EXLOCK)", pgoblin_options->ftrace);
        } else {
            if  (!!(i = pgoblin_xwrt(pgoblin_options, buf, PGOBLIN_GOSHORT + sizeof(u_int16_t)))) {
                ifBLIN_QW0("mife_writ %d <> %d", i, PGOBLIN_GOSHORT + sizeof(u_int16_t));
            }
            putnum(pgoblin_options, line);
            close(pgoblin_options->xtrace);
    }   }
#   undef blin_internal_flags
}

static const u_char *
/************************************************************************
 **                                                                    **/
winpoint(mife_descriptor *md, off_t offset, ssize_t trd) {            /**
 **                                                                    **
 ************************************************************************/
    const u_char    *p = NULL;
    ssize_t          rdr;

    errno = 0;
    if  (trd > (rdr = mife_read(md, trd, offset))) {
        if  (!!mife_ctlsize(md)) {
            ifBLIN_QW0("mife_read %"BLIN_D" < %"BLIN_D, rdr, trd);
            if  (rdr >= 0) errno = EFTYPE;
        }
    } else if (!(p = mife_pointer(md))) {
        ifBLIN_QW0("mife_pointer");
    }
    return(p);
}

static char P[] = "Xftmqocjs";
u_int16_t   nums[65536];

static int
/*****************************************************************************
 **                                                                         **/
qdasprint(pgoblin_main *options, u_int32_t f, u_int32_t n) {               /**
 **                                                                         **
 *****************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    u_int32_t l1 = options->flags & f;
    u_int32_t l2 = nums[(n >> 4) & 0x0FFFF] & (1 << (n & 0x0F));
    return((options->flags & PGOBLIN_T_ONLY) ? (!!l1 && !!l2) : !!l1);
#   undef blin_internal_flags
}

static ssize_t
/*****************************************************************************
 **                                                                         **/
cload(pgoblin_main *options, mife_descriptor *md, off_t *offset) {         /**
 **                                                                         **
 *****************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    ssize_t          rdr;
    ssize_t          trd;
    const u_char    *p;

    if  (!(p = winpoint(md, *offset, 1))) {
        ifBLIN_QW0("trace");
        trd = (errno == EFTYPE) ? -EX_DATAERR : -EX_IOERR;
        goto out;
    }
    if  (*p == 0x0FF) {
        ++*offset;
        trd = -1;
        goto out;
    }
    rdr = recobe_clen(*p);
    if  (!(p = winpoint(md, *offset, rdr))) {
        ifBLIN_QW0("trace");
        trd = (errno == EFTYPE) ? -EX_DATAERR : -EX_IOERR;
        goto out;
    }
    trd = recobe_cload(p, &rdr);
    if  (recobe_clen(*p) != rdr) {
        ifBLIN_QX0("recobe_cload <> recobe_clen");
    }
    *offset += rdr;
out:;
    return(trd);
#   undef blin_internal_flags
}

static char *
/***********************************************************************************************
 **                                                                                           **/
txtdup(pgoblin_main *options, mife_descriptor *md, off_t *offset)                         {  /**
 **                                                                                           **
 ***********************************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    char          *ret = NULL;
    ssize_t        trd;
    const u_char  *p = NULL;

    if  (-1 > (trd = cload(options, md, offset))) {
        ifBLIN_QW0("trace @ 0x%"BLIN_O"X", *offset);
    } else {
        if  (!(p = winpoint(md, *offset, trd))) {
            ifBLIN_QW0("trace @ 0x%"BLIN_O"X", *offset);
            goto out;
        }
        ret = strndup((const char *)p, trd);
        *offset += trd;
    }
out:;
    return(ret);
#   undef blin_internal_flags
}

static int
/***********************************************************************************************
 **                                                                                           **/
txtprt(pgoblin_main *options, int dasprint, mife_descriptor *md, off_t *offset, char end) {  /**
 **                                                                                           **
 ***********************************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int              ex = EX_OK;
    ssize_t          trd;
    const u_char    *p;

    if  (-1 > (trd = cload(options, md, offset))) {
        ifBLIN_QW0("trace @ 0x%"BLIN_O"X", *offset);
        ex = -trd;
    } else if (0 > trd) {
        if  (dasprint && ('|' == end)) printf("|");
    } else {
        if  (!(p = winpoint(md, *offset, trd))) {
            ifBLIN_QW0("trace @ 0x%"BLIN_O"X", *offset);
            ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
            goto out;
        }
        if  (dasprint) {
            if  (' ' == end) {
                printf(" %.*s", (int)trd, p);
            } else {
                printf("=%.*s%c", (int)trd, p, end);
        }   }
        *offset += trd;
    }
out:;
    return(ex);
#   undef blin_internal_flags
}

int
/**************************************************************************************
 **************************************************************************************
 **                                                                                  **/
pgoblin_traceat( pgoblin_main *options, const char *tracefile, const char *Tflag) { /**
 **                                                                                  **
 **************************************************************************************
 **************************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    u_char           t[pgoblin.binparam];
    u_char           s[pgoblin.symparam];
    int              ex = EX_OK;
    int              seqnum;
    off_t            offset;
    int              binreg;
    int              symreg;
    pid_t            tpid;
    u_int16_t        cmd;
    mife_descriptor *md;
    const u_char    *p;
    u_int32_t        n;

    if  (!(md = mife_init(PGOBLIN_MIFEFLAGS))) {
        ifBLIN_QW0("mife_init");
        ex = EX_NOINPUT;
        goto out;
    }
    if  (0 > mife_ctlfile(md, tracefile)) {
        ifBLIN_QW0("mife_ctlfile=%s~", tracefile);
        ex = EX_NOINPUT;
        goto out;
    }
    if  (!Tflag) {
        ifBLIN_QX0("no trace task");
        ERROUT(EX_USAGE, EINVAL);
    }
    if  (!!filenm) {
        ifBLIN_QX0("filenm not NULL");
        ERROUT(EX_SOFTWARE, EDOOFUS);
    }
    if  (!(filenm = mular_create(MULAR_ZERO | MULAR_CHAR, 3, sizeof(char*), msz))) {
        ifBLIN_QW0("mular_create");
        ex = EX_OSERR;
        goto out;
    }
    bzero(nums, sizeof(nums));
    n = 0;
    for (char c = 0; ' ' < *(Tflag++);) {
        u_int32_t i;

        ifBLIN_QX4("%c @ %"BLIN_X, *Tflag, BLIN_I(Tflag));
        switch(*Tflag) {
        case 'C': options->flags |= PGOBLIN_T_COMAND;  break;
        case 'E': options->flags |= PGOBLIN_T_EXECUTE; break;
        case 'M': options->flags |= PGOBLIN_T_MODULES; break;
        case 'N': options->flags |= PGOBLIN_T_NAMES;   break;
        case 'O': options->flags |= PGOBLIN_T_ONLY;    break;
        case 'R': options->flags |= PGOBLIN_T_REGO;    break;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
            i = n;
            n = strtoul(Tflag, (char **)&Tflag, 0);
            ifBLIN_QX4("N%u-%u %c", i, n, c);
            if  ('-' != c) i = n;
            c = *Tflag;
            ifBLIN_QX4("N%u-%u %c", i, n, c);
            for (; i <= n; ++i) nums[(i >> 4) & 0x0000FFFF] |= (1 << (i & 0x0000000F));
            ifBLIN_QX4("N%u %c", n, c);
            break;
    }   }
    offset = 0;
    for (seqnum = 0; ; ++seqnum) {
        fflush(stdout);
        if  (!(p = winpoint(md, offset, PGOBLIN_GOSHORT))) {
            if  (!mife_ctlsize(md)) break;
            ifBLIN_QW0("trace file");
            ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
            goto out;
        }
        ifBLIN_QX3("offset %012"BLIN_O"X = %02X %02X", offset, p[0], p[1]);
        switch(*p) {
        case PGOBLIN_STYLE   : t[0] = P[8]; break;
        case PGOBLIN_JOB     : t[0] = P[7]; break;
        case PGOBLIN_CONNECT : t[0] = P[6]; break;
        case PGOBLIN_OUTSET  : t[0] = P[5]; break;
        case PGOBLIN_PQRESULT: t[0] = P[4]; break;
        case PGOBLIN_MIFEDES : t[0] = P[3]; break;
        case PGOBLIN_TEXTPARM: t[0] = P[2]; break;
        case PGOBLIN_PATHPARM: t[0] = P[1]; break;
        case 0               : t[0] = P[0]; break;
        default              : t[0] = 0;
        }
        tpid = recobe_load(PGOBLIN_HEDLN + p, PGOBLIN_PIDLN);
        if  (!!t[0]) {
            int       dasprint = qdasprint(options, PGOBLIN_T_REGO, seqnum);
            u_int16_t line;
            u_int16_t idx;
            char    **c;

            if  (!(p = winpoint(md, offset, PGOBLIN_GOSHORT + sizeof(u_int16_t)))) {
                ifBLIN_QW0("trace file @ 0x%012"BLIN_O"X", offset);
                ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
                goto out;
            }
            if  (dasprint) printf("R%6d.%u P%c %c", seqnum, tpid, t[0], pgoblin_regn[p[1] & 0x03F]);
            idx = recobe_load(PGOBLIN_GOSHORT + p, sizeof(u_int16_t));
            offset += PGOBLIN_GOSHORT + sizeof(u_int16_t);
            line = cload(options, md, &offset);
            if  (!(c = mular_getix(filenm, idx))) {
                ifBLIN_QW0("trace file @ 0x%012"BLIN_O"X idx=%u", offset, idx);
            } else if (!!dasprint) {
                printf(" %s:%u\n", *c, line);
            }
            continue;
        }
        switch(*p & 0x0E0) {
        case 0xE0: {
                int dasprint = qdasprint(options, PGOBLIN_T_COMAND, seqnum);

        ;       if  (!(p = winpoint(md, offset, PGOBLIN_GOEXECU))) {
        ;           ifBLIN_QW0("trace file");
        ;           ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;           goto out;
        ;       }
        ;       cmd = (*(p) << 8) & 0x0100;
        ;       cmd |= *(p + 1);
        ;       if  (PGOBLIN_max <= cmd) {
        ;           ifBLIN_QX0("cmd = %03X", cmd);
        ;           ex = EX_DATAERR;
        ;           goto out;
        ;       }
        ;       bzero(t, pgoblin.binparam);
        ;       bzero(s, pgoblin.symparam);
        ;       for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
        ;           if  (0 <= (binreg = pgoblin_breg(cmd, symreg))) {
        ;               s[symreg] = t[binreg] = p[PGOBLIN_GOSHORT + binreg] & 0x03F;
        ;       }   }
        ;       if  (dasprint) {
        ;           printf( "C%6d.%u (%ds %dd) N%d #%s %c%c%c%c%c%c\n"
                          , seqnum
                          , tpid
                          , (int)recobe_load(PGOBLIN_GOCMD + p, sizeof(int16_t))
                          , (int)recobe_load(sizeof(int16_t) + PGOBLIN_GOCMD + p, sizeof(int16_t))
                          , (int)recobe_load(sizeof(int16_t) * 2 + PGOBLIN_GOCMD + p, sizeof(int32_t))
                          , pgoblin.a[cmd].str
                          , pgoblin_regn[s[0]]
                          , pgoblin_regn[s[1]]
                          , pgoblin_regn[s[2]]
                          , pgoblin_regn[s[3]]
                          , pgoblin_regn[s[4]]
                          , pgoblin_regn[s[5]]
                          );
        ;       }
        ;       offset += PGOBLIN_GOEXECU;
        ;       for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
        ;           if  (0 <= (binreg = pgoblin_breg(cmd, symreg))) {
                        u_char ch = pgoblin.a[cmd].ch[binreg];

#ifndef NOTRACE_PATHPARM
        ;               if  (PGOBLIN_PATHPARM & ch) {
        ;                   ifBLIN_QX4("[%d]PATHPARM", binreg);
        ;                   if  (dasprint) {
        ;                       printf( "        %d %d [%c]%sPf"
                                      , binreg
                                      , symreg
                                      , pgoblin_regn[t[binreg] & 0x03F]
                                      , (ch & PGOBLIN_OUTSET) ? "Po|" : "   "
                                      );
        ;                   }
        ;                   if  (!!(ex = txtprt(options, dasprint, md, &offset, '~'))) {
        ;                       ifBLIN_QW0("trace Pf");
        ;                       goto out;
        ;                   }
        ;                   if  (dasprint) printf("\n");
        ;               }
#endif
#ifndef NOTRACE_TEXTPARM
        ;               if  (PGOBLIN_TEXTPARM & ch) {
        ;                   ifBLIN_QX4("[%d]TEXTPARM", binreg);
        ;                   if  (dasprint) {
        ;                       printf( "        %d %d [%c]%sPt"
                                      , binreg
                                      , symreg
                                      , pgoblin_regn[t[binreg] & 0x03F]
                                      , (ch & PGOBLIN_OUTSET) ? "Po|" : "   "
                                      );
        ;                   }
        ;                   if  (!!(ex = txtprt(options, dasprint, md, &offset, '~'))) {
        ;                       ifBLIN_QW0("trace Pt");
        ;                       goto out;
        ;                   }
        ;                   if  (dasprint) printf("\n");
        ;               }
#endif
#ifndef NOTRACE_MIFEDES
        ;               if  (PGOBLIN_MIFEDES  & ch) {
        ;                   ifBLIN_QX4("[%d]MIFEDES", binreg);
        ;               }
#endif
#ifndef NOTRACE_PQRESULT
        ;               if  (PGOBLIN_PQRESULT & ch) {
        ;                   ifBLIN_QX4("[%d]PQRESULT", binreg);
        ;                   if  (dasprint) {
        ;                       printf( "        %d %d [%c]%sPq"
                                      , binreg
                                      , symreg
                                      , pgoblin_regn[t[binreg] & 0x03F]
                                      , (ch & PGOBLIN_OUTSET) ? "Po|" : "   "
                                      );
        ;                   }
        ;                   if  (!(p = winpoint(md, offset, 1))) {
        ;                        ifBLIN_QW0("trace q");
        ;                        ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;                        goto out;
        ;                   }
        ;                   if  (*p == 0x0FF) {
        ;                       if  (dasprint) printf("\n");
        ;                       ++offset;
        ;                   } else {
                                int     row;
                                int     col;
                                int     ctg;

        ;                       row = cload(options, md, &offset); /* 0 > ? XXXX*/
        ;                       col = cload(options, md, &offset); /* 0 > ? XXXX*/
        ;                       ctg = cload(options, md, &offset); /* 0 > ? XXXX*/
        ;                       if  (dasprint) {
        ;                           if  (0 > ctg) {
        ;                               printf(" %d rows x %d cols\n", row, col);
        ;                           } else {
        ;                               printf(" %d(%d rows) x %d cols\n", ctg, row, col);
        ;                       }   }
        ;                       for ( int r = (0 > ctg) ? 0 : ctg
                                    ; (0 > ctg) ? (r < row) : (r == ctg)
                                    ; ++r
                                    ) {
        ;                           for (int c = 0; c < col; ++c) {
        ;                               if  (!!(ex = txtprt(options, dasprint, md, &offset, '|'))) {
        ;                                   ifBLIN_QW0("trace Pq");
        ;                                   goto out;
        ;                           }   }
        ;                           if  (dasprint) printf("\n");
        ;               }   }   }
#endif
#ifndef NOTRACE_OUTSET
        ;               if  (PGOBLIN_OUTSET   & ch) {
        ;                   ifBLIN_QX4("[%d]OUTSET", binreg);
        ;               }
#endif
#ifndef NOTRACE_CONNECT
        ;               if  (PGOBLIN_CONNECT  & ch) {
        ;                   ifBLIN_QX4("[%d]CONNECT", binreg);
        ;               }
#endif
#ifndef NOTRACE_JOB
        ;               if  (PGOBLIN_JOB      & ch) {
        ;                   ifBLIN_QX4("[%d]JOB", binreg);
        ;               }
#endif
        ;               if  (PGOBLIN_STYLE    & ch) {
#ifndef NOTRACE_STYLE
        ;                   ifBLIN_QX4("[%d]STYLE", binreg);
#endif
        ;   }   }   }   }
        ;   continue;
        case 0xC0: {
        ;       if  (!(p = winpoint(md, offset, PGOBLIN_GOEXECU))) {
        ;           ifBLIN_QW0("trace file");
        ;           ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;           goto out;
        ;       }
        ;       cmd = (*(p) << 8) & 0x0100;
        ;       cmd |= *(p + 1);
        ;       bzero(t, pgoblin.binparam);
        ;       bzero(s, pgoblin.symparam);
        ;       for (symreg = 0; symreg < pgoblin.symparam; symreg++) {
        ;           if  (0 <= (binreg = pgoblin_breg(cmd, symreg))) {
        ;               s[symreg] = t[binreg] = p[PGOBLIN_GOSHORT + binreg];
        ;       }   }
        ;       if  (qdasprint(options, PGOBLIN_T_EXECUTE, seqnum)) {
        ;           printf( "E%6d.%u (%ds %dd) N%d #%s %c%c%c%c%c%c\n"
                          , seqnum
                          , tpid
                          , (int)recobe_load(p + PGOBLIN_GOCMD, sizeof(int16_t))
                          , (int)recobe_load(sizeof(int16_t) + p + PGOBLIN_GOCMD, sizeof(int16_t))
                          , (int)recobe_load(sizeof(int16_t) * 2 + p + PGOBLIN_GOCMD, sizeof(int32_t))
                          , pgoblin.a[cmd].str
                          , pgoblin_regn[s[0] & 0x03F]
                          , pgoblin_regn[s[1] & 0x03F]
                          , pgoblin_regn[s[2] & 0x03F]
                          , pgoblin_regn[s[3] & 0x03F]
                          , pgoblin_regn[s[4] & 0x03F]
                          , pgoblin_regn[s[5] & 0x03F]
                          );
        ;       }
        ;       offset += PGOBLIN_GOEXECU;
        ;   }
        ;   continue;
        case 0xA0: {
                int dasprint = qdasprint(options, PGOBLIN_T_MODULES, seqnum);

        ;       if  (!(p = winpoint(md, offset, PGOBLIN_GOSHORT))) {
        ;           ifBLIN_QW0("trace file");
        ;           ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;           goto out;
        ;       }
        ;       if  (dasprint) printf("M%6d.%u[%u]", seqnum, tpid, *(p + 1));
        ;       offset += PGOBLIN_GOSHORT;
        ;       for (int i = 0; i < 3; ++i) {
        ;           if  (!!(ex = txtprt(options, dasprint, md, &offset, ' '))) {
        ;               ifBLIN_QW0("trace mod");
        ;               goto out;
        ;       }   }
        ;       if  (dasprint) printf("\n");
        ;   }
        ;   continue;
        case 0x60: break;
        default: {
        ;       ifBLIN_QX0("illegal trace file 0x%02X @ 0x%012"BLIN_O"X", *p, offset);
        ;       ERROUT(EX_DATAERR, EILSEQ);
        }   }
        switch(p[1]) {
        case 0x00: {
                u_int16_t idx;

        ;       if  (!(p = winpoint(md, offset, PGOBLIN_GOSHORT + sizeof(int16_t)))) {
        ;           ifBLIN_QW0("trace file");
        ;           ex = (errno == EFTYPE) ? EX_DATAERR : EX_IOERR;
        ;           goto out;
        ;       }
        ;       idx = recobe_load(PGOBLIN_GOSHORT + p, sizeof(int16_t));
        ;       if  (MULAR_NEXT(filenm) < idx) {
        ;           ifBLIN_QX0("Gap in seq: %u < [%u]", MULAR_NEXT(filenm), idx);
        ;           ERROUT(EX_DATAERR, EILSEQ);
        ;       }
        ;       offset += PGOBLIN_GOSHORT + sizeof(int16_t);
        ;       if  (MULAR_NEXT(filenm) > idx) {
        ;           ifBLIN_QX0( "Overwrite [%u]=%s~: [%u]"
                              , idx
                              , *(char **)mular_getix(filenm, idx)
                              , MULAR_NEXT(filenm)
                              );
        ;           printf("N%6d.%u [%u]", seqnum, tpid, idx);
        ;           if  (!!(ex = txtprt(options, 1, md, &offset, '~'))) {
        ;               ifBLIN_QW0("trace N");
        ;               goto out;
        ;           }
        ;           printf("\n");
        ;       } else {
        ;           *(char **)mular_add(filenm) = txtdup(options, md, &offset);
        ;           if  (qdasprint(options, PGOBLIN_T_NAMES, seqnum)) {
        ;               printf( "N%6d.%u [%u]=%s~\n"
                              , seqnum
                              , tpid
                              , idx
                              , *(char **)mular_getix(filenm, MULAR_NEXT(filenm) - 1)
                              );
        ;   }   }   }
        ;   continue;
        default: {
        ;       ifBLIN_QX0("illegal trace file 0x60X 0x%02X @ 0x%012"BLIN_O"X", p[1], offset);
        ;       ERROUT(EX_DATAERR, EILSEQ);
    }   }   }
out:;
    return(ex);
#   undef blin_internal_flags
}
