#!/bin/sh
# Copyright (C)2004..2021 @BABOLO http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: regres8.m4,v 1.51 2021/10/16 20:20:22 babolo Exp $
define(DBMS,sqlite3)dnl
changecom(--)dnl

OO="$0 $*"
TF=`mktemp -t pgoblin` || exit 1
TP=`mktemp -t pgoblin` || exit 1
TR=`mktemp -t pgoblin` || exit 1
TI=`mktemp -t pgoblin` || exit 1
TD=`mktemp -t pgoblin` || exit 1
prog="`pwd`/pgoblin -z -L WITHDIR/pgoblin3sqlite3 -L WITHDIR/pgoblin5pgo0 -BDBMS -d${TD} ${1}"
${prog} -qD 'DROP TABLE pgoblin_test_table' || true
e=0

define(EOFBEGIN,"EOF")define(EOFEND,EOF)dnl


echo '= 0 ==='

EXFILE(dnl
#perform
CREATE TABLE pgoblin_test_table
     ( t text
     , i int
     ))

COPYIN(,dnl
#copyin
COPY pgoblin_test_table FROM stdin,dnl
test	0
test	1)

COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	2
')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	3
\.')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	4
\.
')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	5')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	6
')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	7
\')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	8
\.')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	9
\.
')


echo '= 1 ==='

SELECTEST(,#select 1
#perform 0102
,)

SELECTEST(,#select 102
#perform 0102
,)

SELECTEST(,#select 1
SELECT NULL;
#perform 01
,)

SELECTEST(,#connect 000O
0
#select  100O
0 0
#perform 01
#perform 001
CREATE TEMP TABLE t(t text);
#select  001
SELECT * FROM t;
,)

SELECTEST(,#echo 0O
#echo
#connect 000O
0
#select  100O
0 0
#echo 0O
,)

define(CONst1,dnl
|test|0|
|test|1|
|test|2|
|test|3|
|test|4|
|test|5|
|test|6|
|test|7|
|test|8|
|test|9|)dnl

SELECTEST(s,"SELECT '|', t, '|', i, '|
' FROM pgoblin_test_table",CONst1)

SELECTEST(,#select
SELECT '|', t, '|', i, '|
' FROM pgoblin_test_table,CONst1)

SELECTEST(,#strselect
SELECT '|', t, '|', i, '|
' FROM pgoblin_test_table,CONst1)


echo '= 2 ==='

define(CONst1,dnl
0	sfoidjg995t77bn&^*&^	text	\N	\N	\N	\N
1	t	text	\N	\N	\N	\N
2	\tYTFlm	text	\N	\N	\N	\N
3	i	integer	\N	\N	\N	\N
4	'	text	\N	\N	\N	\N)dnl

SELECTEST(=,#select 1
SELECT '|' AS "sfoidjg995t77bn&^*&^", t, '|' AS "	YTFlm", i, '|
' AS "'" FROM pgoblin_test_table
#getmeta 001,CONst1)


echo '= 3 ==='

define(CONst1,dnl
test	0
test	1
test	2
test	3
test	4
test	5
test	6
test	7
test	8
test	9)dnl

SELECTEST(c,'COPY pgoblin_test_table TO stdout',CONst1)

SELECTEST(,#copyout
COPY pgoblin_test_table TO stdout,CONst1)


echo '= 4 ==='

inTEXT(tset	10)
SELECTEST(,#copyin 
COPY pgoblin_test_table FROM stdin
#strselect
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
#select
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
#copyout
COPY pgoblin_test_table TO stdout
#perform
DELETE FROM pgoblin_test_table WHERE i = 10

,test 00
test 11
test 24
test 39
test 416
test 525
test 636
test 749
test 864
test 981
tset 10100
test 00
test 11
test 24
test 39
test 416
test 525
test 636
test 749
test 864
test 981
tset 10100
test	0
test	1
test	2
test	3
test	4
test	5
test	6
test	7
test	8
test	9
tset	10)

SELECTEST(=,#perform
CREATE TEMP TABLE t(t text);
#select 2
SELECT i, 9 - i FROM pgoblin_test_table ORDER BY i ASC;
#perform 002
INSERT INTO t SELECT ? || ?;
#copyout
COPY t TO stdout;
,09
18
27
36
45
54
63
72
81
90)

SELECTEST(,#begin
#strselect
SELECT t, ' ', i, ' ', i * i, '
' FROM pgoblin_test_table
#end
#select
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
,test 0 0
test 1 1
test 2 4
test 3 9
test 4 16
test 5 25
test 6 36
test 7 49
test 8 64
test 9 81
test 00
test 11
test 24
test 39
test 416
test 525
test 636
test 749
test 864
test 981)

inTEXT(test	0
test	1
tnet	\N)
SELECTEST(=,#perform
DELETE FROM pgoblin_test_table;
#copyin 
COPY pgoblin_test_table FROM stdin
#strselect
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
ORDER BY t, i
#copyout
COPY pgoblin_test_table TO stdout
,test 00
test 11
tnet 
test	0
test	1
tnet	\N)

SELECTEST(D,'DROP TABLE pgoblin_test_table')

SELECTEST(,#perform
,)

SELECTEST(,#select
,)


echo '= 5 ==='

define(CONst1,a
#b
ctest)dnl

SELECTEST(,

##

#

#echo 0 wdfgWEHG #  
a
##b
c
#echo
test
,CONst1)

SELECTEST(,#echo 0 wdfgWEHG #  
a
##b
c
#echo
test
,CONst1)

SELECTEST(,#echo
a
##b
c
#echo 0 wdfgWEHG #  
test
,CONst1)

SELECTEST(,#echo
##b
c
#echo
test
,#b
ctest)

SELECTEST(,#echo
a
##b
c
#echo
test
#echo 2
##echo
a
###b
c
##echo
test


#eval 02
,CONst1CONst1)

SELECTEST(,#echo
a
##b
c
#echo
test
#eval
##echo
a
###b
c
##echo
test

,CONst1CONst1)

SELECTEST(,#echo
a
##b
c
#echo
test
#echo 2
##echo
a
###b
c
##echo
test
##echo 3
###echo
a
####b
c
###echo
test


##eval 03

#eval 02
,CONst1CONst1CONst1)

SELECTEST(,#echo
a
##b
c
#echo
test
#eval
##echo
a
###b
c
##echo
test
##eval
###echo
a
####b
c
###echo
test


,CONst1CONst1CONst1)

SELECTEST(,#echo
a
##b
c
#echo
test
#eval

##echo
a
###b
c
##echo
test
##eval

###echo
a
####b
c
###echo
test


,CONst1CONst1CONst1)

SELECTEST(,#perform
CREATE TEMP TABLE t(t text);
INSERT INTO t VALUES('1');
#select
SELECT t, '
'FROM t ORDER BY t;
#echo 2
##perform
INSERT INTO t VALUES('2');
##select
SELECT t, '
'FROM t ORDER BY t;
##echo 3
###perform
INSERT INTO t VALUES('3');
###select
SELECT t, '
'FROM t ORDER BY t;

##eval 03

#eval 02
,1
1
2
1
2
3)

SELECTEST(,#perform
CREATE TEMP TABLE t(t text);
INSERT INTO t VALUES('1');
#select
SELECT t, '
'FROM t ORDER BY t;
#eval
##perform
INSERT INTO t VALUES('2');
##select
SELECT t, '
'FROM t ORDER BY t;
##eval
###perform
INSERT INTO t VALUES('3');
###select
SELECT t, '
'FROM t ORDER BY t;


,1
1
2
1
2
3)

SELECTEST(,#perform
CREATE TEMP TABLE t(t text);
INSERT INTO t VALUES('1');
#select
SELECT t, '
'FROM t ORDER BY t;
#eval
##perform
INSERT INTO t VALUES('2');
##select
SELECT t, '
'FROM t ORDER BY t;
##eval
###perform
INSERT INTO t VALUES('3');
###select
SELECT t, '
'FROM t ORDER BY t;
,1
1
2
1
2
3)


echo '= 6 ==='

SELECTEST(=,#select  1
SELECT 11, 12, 13, 14;
#select  001
SELECT ?3, ' ', ?2, '
'
;
#select  1
SELECT 11, 12;
#select  001
SELECT ?3, ' ', ?2, '
'
;
,13 12
 12)

SELECTEST(=,#perform
CREATE TEMP TABLE t(t0 int, t1 int, t2 int, t3 int);
#perform
INSERT INTO t
 VALUES (11, 12, 13, 14)
      , (21, 22, 23, 24)
      , (31, 32, 33, 34)
;
#select  1
SELECT * FROM t ORDER BY t1;
#select  001
SELECT ?3, ' ', ?2, '
'
;
,33 32)

SELECTEST(=,#perform
CREATE TEMP TABLE t(t0 int, t1 int);
#perform
INSERT INTO t
 VALUES (11, 12)
      , (21, 22)
      , (31, 32)
;
#select  1
SELECT * FROM t ORDER BY t1;
#select  001
SELECT ?3, ' ', ?2, '
'
;
, 32)

SELECTEST(=,#perform
CREATE TEMP TABLE t(t0 int, t1 int, t2 int, t3 int);
#perform
CREATE TEMP TABLE f(f0 int, f1 int);
#perform
INSERT INTO t
 VALUES (11, 12, 13, 14)
      , (21, 22, 23, 24)
      , (31, 32, 33, 34)
;
#select  1
SELECT * FROM t ORDER BY t1;
#perform 001
INSERT INTO f SELECT ?3, ?2;
#select
SELECT f0, ' ', f1, '
'FROM f
ORDER BY f1
;
,13 12
23 22
33 32)

SELECTEST(=,#perform
CREATE TEMP TABLE t(t0 int, t1 int);
#perform
CREATE TEMP TABLE f(f0 int, f1 int);
#perform
INSERT INTO t
 VALUES (11, 12)
      , (21, 22)
      , (31, 32)
;
#select  1
SELECT * FROM t ORDER BY t1;
#perform 001
INSERT INTO f SELECT ?3, ?2;
#select
SELECT f0, ' ', f1, '
'FROM f
ORDER BY f1
;
, 12
 22
 32)


echo '= 7 ==='

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text)
#getpost 1
#copyin 001
COPY p FROM stdin
#copyout
COPY p TO stdout)dnl

inCONS('')
SELECTEST(,CONst1,0	\N	)

inCONS('nf95')
SELECTEST(,CONst1,0	\N	nf95)

inCONS('nfh95=')
SELECTEST(,CONst1,0	nfh95	)

inCONS('nfh95=lk')
SELECTEST(,CONst1,0	nfh95	lk)

inCONS('nfh95=lkjb&')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	)

inCONS('nfh95=lkjb&gjnh')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	gjnh)

inCONS('nfh95=lkjb&kn=')
SELECTEST(,CONst1,0	nfh95	lkjb
1	kn	)

inTEXT(nfh9=kjb&knr=r&idfj=ns)
SELECTEST(,CONst1,0	nfh9	kjb
1	knr	r
2	idfj	ns)

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text)
#getpost 1
#copyin 001
COPY "p" FROM stdin
#copyout
COPY "p" TO stdout)dnl

inTEXT(nfh9=kjb&knr=r&idfj=ns)
SELECTEST(,CONst1,0	nfh9	kjb
1	knr	r
2	idfj	ns)

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text)
#getpost 1
#copyin 001
COPY 'p' FROM stdin
#copyout
COPY 'p' TO stdout)dnl

inTEXT(nfh9=kjb&knr=r&idfj=ns)
SELECTEST(,CONst1,0	nfh9	kjb
1	knr	r
2	idfj	ns)

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text)
#getpost 2
#copyin 002
COPY p FROM stdin
#copyout
COPY p TO stdout)dnl

inCONS('')
SELECTEST(,CONst1,0	\N	)

inCONS('nf95')
SELECTEST(,CONst1,0	\N	nf95)

inCONS('nfh95=')
SELECTEST(,CONst1,0	nfh95	)

inCONS('nfh95=lk')
SELECTEST(,CONst1,0	nfh95	lk)

inCONS('nfh95=lkjb&')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	)

inCONS('nfh95=lkjb&gjnh')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	gjnh)

inCONS('nfh95=lkjb&kn=')
SELECTEST(,CONst1,0	nfh95	lkjb
1	kn	)

inTEXT(nfh9=kjb&knr=r&idfj=ns)
SELECTEST(,CONst1,0	nfh9	kjb
1	knr	r
2	idfj	ns)


echo '= 8 ==='

define(CONst1,#perform
CREATE TEMP TABLE a(n int, e text, c text)
#getget 1
#copyin 001
COPY a FROM stdin
#copyout
COPY a TO stdout)dnl

unset QUERY_STRING || true
SELECTEST(,CONst1)

export QUERY_STRING=''
SELECTEST(,CONst1,0	\N	)

export QUERY_STRING='kjn=er&kjb'
SELECTEST(,CONst1,0	kjn	er
1	\N	kjb)

define(CONst1,#perform
CREATE TEMP TABLE a(n int, e text, c text)
#getget 2
#copyin 002
COPY a FROM stdin
#copyout
COPY a TO stdout)dnl

unset QUERY_STRING || true
SELECTEST(,CONst1)

export QUERY_STRING=''
SELECTEST(,CONst1,0	\N	)

export QUERY_STRING='kjn=er&kjb'
SELECTEST(,CONst1,0	kjn	er
1	\N	kjb)


echo '= 9 ==='

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text);
CREATE TEMP TABLE a(n int, c text);
CREATE TEMP TABLE e(n int, e text, c text);
CREATE TEMP TABLE g(n int, e text, c text)
#getpost 1
#copyin 001
COPY p FROM stdin
#getarg 1
#copyin 001
COPY a FROM stdin
#getenv 1
#copyin 001
COPY e FROM stdin
#getget 1
#copyin 001
COPY g FROM stdin
#echo
  :

#select
SELECT COALESCE(e, '?') || ' = ' || COALESCE(c, '?') || '
' FROM e
 WHERE e IN('TEST_STRING1', 'TEST_STRING2', 'QUERY_STRING')
ORDER BY e
#select
SELECT COALESCE(n, '?') || '=' || COALESCE(c, '?') || '
' FROM a
#select
SELECT COALESCE(n, '?') || ': ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM g
#select
SELECT COALESCE(n, '?') || '! ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM p
#perform
DROP TABLE p;
DROP TABLE a;
DROP TABLE e;
DROP TABLE g;)dnl

export TEST_STRING1='lefn'
export TEST_STRING2='8r7wv'
inTEXT(bnu)
SELECTEST(=,CONst1,dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
EOF
cat << EOF >> ${TP}
0=${TF}
EOF
cat << "EOF" >> ${TP}
0: kjn=er
1: ?=kjb
0! ?=bnu)

inTEXT(bnu)
SELECTEST(f,${TF},dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
0: kjn=er
1: ?=kjb
0! ?=bnu)

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text);
CREATE TEMP TABLE a(n int, c text);
CREATE TEMP TABLE e(n int, e text, c text);
CREATE TEMP TABLE g(n int, e text, c text)
#getpost 2
#copyin 002
COPY p FROM stdin
#getarg 2
#copyin 002
COPY a FROM stdin
#getenv 2
#copyin 002
COPY e FROM stdin
#getget 2
#copyin 002
COPY g FROM stdin
#echo
  :

#select
SELECT COALESCE(e, '?') || ' = ' || COALESCE(c, '?') || '
' FROM e
 WHERE e IN('TEST_STRING1', 'TEST_STRING2', 'QUERY_STRING')
ORDER BY e
#select
SELECT COALESCE(n, '?') || '=' || COALESCE(c, '?') || '
' FROM a
#select
SELECT COALESCE(n, '?') || ': ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM g
#select
SELECT COALESCE(n, '?') || '! ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM p
#perform
DROP TABLE p;
DROP TABLE a;
DROP TABLE e;
DROP TABLE g;)dnl

export TEST_STRING1='lefn'
export TEST_STRING2='8r7wv'
inTEXT(bnu)
SELECTEST(=,CONst1,dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
EOF
cat << EOF >> ${TP}
0=${TF}
EOF
cat << "EOF" >> ${TP}
0: kjn=er
1: ?=kjb
0! ?=bnu)

inTEXT(bnu)
SELECTEST(f,${TF},dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
0: kjn=er
1: ?=kjb
0! ?=bnu)


echo '= 10 ==='

define(CONst1,dnl
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.)

SELECTEST(,#cat
tools/LICENSE,CONst1)

SELECTEST(,#cat
tools/LICENSE
#echo
=== Test Done ===

,CONst1
=== Test Done ===
)

SELECTEST(,#echo 3
lala
#clear 3
#echo 03
#,)

SELECTEST(,#echo 3
##echo 4
lala

##echo 04
#eval 03,lala)

SELECTEST(,#echo 3
##echo 4
lala

##echo 04 -
#eval 03,lala)

export QUERY_STRING='p=13'
SELECTEST(,#echo 3
##getget
#eval 03,0	p	13
\.)

SELECTEST(,#echo 3
##getget 
#eval 03,0	p	13
\.)


echo '= 11 ==='

define(DOinPIPE,cat /dev/null |)dnl
SELECTEST(,#perform
CREATE TEMP TABLE t(i int);
#copyin
COPY t FROM stdin
#strselect
SELECT * FROM t
)

define(DOinPIPE,cat /dev/null |)dnl
SELECTEST(C,'CREATE TEMP TABLE p(i int);COPY p FROM stdin')

SELECTEST(=,#echo 2
\t.\\\001\\\\
\.

#perform
CREATE TEMP TABLE t(t text);
#copyin 002
COPY t FROM stdin;
#select
SELECT t, '
'FROM t
;
,	.\\\)


echo '= 12 ==='

define(CONst1,dnl
$$:[0]=/bin/sh~
$$:[1]=${0}~)

SELECTEST(,#getproc 1
#perform
CREATE TEMP TABLE t(p int, i int, t text);
#copyin 001
COPY t FROM stdin
#strselect
SELECT p, ':[', i, ']=', t ,'~
'FROM t WHERE p = $$ ORDER BY i,CONst1,EOF)


echo '= 13 ==='

prog="`pwd`/pgoblin -z -qBDBMS -d${TD} ${1}"
inTEXT(dnl

	
\\
erty)

SELECTEST(,#getstr 2
#perform
CREATE TEMP TABLE t(i int, t text);
#echo 3
111	 
112	?
#copyin 003
COPY t FROM stdin
#trap
#select
SELECT '[', i, ']=', t, '~
'FROM t ORDER BY i DESC
#return
#copyin 002
COPY t FROM stdin
#select
SELECT '[', i, ']=', t, '~
'FROM t ORDER BY i
#select
SELECT * FROM never_never_nether_not_for_anything_nowhere_non_existing_nor_imaginable
#echo
Done
,dnl
[0]=~
[1]=	~
[2]=\~
[3]=erty~
[111]= ~
[112]=?~
[112]=?~
[111]= ~
[3]=erty~
[2]=\~
[1]=	~
[0]=~
Done)

SELECTEST(,dnl
#trap
#echo
Done

#exit
#perform
CREATE TEMP TABLE t(i int, t text);
#echo 3
111	 
112	?
#copyin 003
COPY t FROM stdin
#select
SELECT '[', i, ']=', t, '~
'FROM t ORDER BY i DESC
#select
SELECT * FROM never_never_nether_not_for_anything_nowhere_non_existing_nor_imaginable
#select
SELECT '[', i, ']=', t, '~
'FROM t ORDER BY i
,dnl
[112]=?~
[111]= ~
Done)


echo '= 14 ==='

prog="`pwd`/pgoblin -z -BDBMS -d${TD} ${1}"


SELECTEST(,dnl
#select 3001
SELECT '/usr/bin/uname' WHERE NULL;
#select W001
SELECT '#exec 0V
##exit
'WHERE NULL
;
#eval 0W
#echo

,dnl
)


SELECTEST(,dnl
#select 3001
SELECT NULL;
#file 43
#select 3001
SELECT '/bin/cat' WHERE NULL;
#exec 43
#wait
#close 403
#echo

,dnl
)


SELECTEST(,dnl
#wait
#echo

,dnl
)


SELECTEST(,dnl
#fork
#echo
TEST IN FORK

#exit
#exec
/bin/sleep
#
1
#wait
#echo
TEST OUT FORK
,dnl
TEST IN FORK
TEST OUT FORK)


SELECTEST(,dnl
#fork 4
#echo 4
TEST IN FORK

#exit
#echo 04
,dnl
TEST IN FORK)

SELECTEST(,dnl
#fork 404
#getstr 504
#perform 0001
CREATE TEMP TABLE t(i int, t text);
#copyin 0051
COPY t FROM stdin;
#strselect 4001
SELECT '[' || i || ']=' || t || '~
'FROM t
#exit
#echo 4
TEST IN FORK

#close 4
#echo 04,dnl
[0]=TEST IN FORK~)

SELECTEST(,dnl
#fork 404
#echo 44
#exit
#echo 4
TEST IN FORK

#close 4
#echo 04,dnl
TEST IN FORK)

SELECTEST(,dnl
#echo 4
/usr/bin/uname
#exec 04
#wait,dnl
FreeBSD)


echo '= 15 ==='

define(CONst1dnl
,dnl
#cat     Z
/dev/zero
#echo    2
0
1
2
3
4
#perform
CREATE TEMP TABLE t(c int);
#copyin  002
COPY t FROM stdin;
#select  2
SELECT '/bin/sh','-c','sleep 2; echo $$' FROM t;
#exec    42002
#exec
/bin/sleep
#
0.2
#wait
#getproc 2
#perform
CREATE TEMP TABLE c(c int, i int, a text);
#copyin  002
COPY c FROM stdin;
#getjob  20002
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin  002
COPY j FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
#getstr  204
#perform
CREATE TEMP TABLE f(i int, c int);
#copyin  002
COPY f FROM stdin;
#select
SELECT 'j-f ', c, '
'FROM (SELECT c FROM j EXCEPT SELECT c FROM f)c;
#select
SELECT 'f-j ', c, '
'FROM (SELECT c FROM f EXCEPT SELECT c FROM j)c;
#select
SELECT j.i, ':[', c.i, ']=', a, '~
'FROM c JOIN j USING(c) ORDER BY j.i, c.i;
#wait    00002
#getjob  20002
#perform
DELETE FROM j;
#copyin  002
COPY j FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM j;
dnl
)dnl

define(CONst2,dnl
0[5]=-1
1[5]=-1
2[5]=-1
3[5]=-1
4[5]=-1
0:[0]=/bin/sh~
0:[1]=-c~
0:[2]=sleep 2; echo $$~
1:[0]=/bin/sh~
1:[1]=-c~
1:[2]=sleep 2; echo $$~
2:[0]=/bin/sh~
2:[1]=-c~
2:[2]=sleep 2; echo $$~
3:[0]=/bin/sh~
3:[1]=-c~
3:[2]=sleep 2; echo $$~
4:[0]=/bin/sh~
4:[1]=-c~
4:[2]=sleep 2; echo $$~
0[5]=0
1[5]=0
2[5]=0
3[5]=0
4[5]=0dnl
)dnl

SELECTEST(=,CONst1,CONst2)dnl
SELECTEST(f,${TF},CONst2)dnl

define(CONst1dnl
,dnl
#cat     N
/dev/null
#echo    2
0
1
2
3
4
#perform
CREATE TEMP TABLE t(c int);
#copyin  002
COPY t FROM stdin;
#select  2
SELECT '/bin/sh','-c','sleep 2; echo $$' FROM t;
#exec    42N02
#exec    00N
/bin/sleep
#
0.2
#wait
#getproc 2
#perform
CREATE TEMP TABLE c(c int, i int, a text);
#copyin  002
COPY c FROM stdin;
#getjob  20002
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin  002
COPY j FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
#getstr  204
#perform
CREATE TEMP TABLE f(i int, c int);
#copyin  002
COPY f FROM stdin;
#select
SELECT 'j-f ', c, '
'FROM (SELECT c FROM j EXCEPT SELECT c FROM f)c;
#select
SELECT 'f-j ', c, '
'FROM (SELECT c FROM f EXCEPT SELECT c FROM j)c;
#select
SELECT j.i, ':[', c.i, ']=', a, '~
'FROM c JOIN j USING(c) ORDER BY j.i, c.i;
#wait    00002
#getjob  20002
#perform
DELETE FROM j;
#copyin  002
COPY j FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM j;
dnl
)dnl

SELECTEST(=,CONst1,CONst2)dnl
SELECTEST(f,${TF},CONst2)dnl

SELECTEST(dnl
,dnl
#exec    40002
/bin/sh
#
-c
#
echo There
#exec    50002
/bin/sh
#
-c
#
echo Then
#exec    60002
/bin/mkdir
#
/dev/null/newerNewerNEWERexistingdirectory/newerestabsolytelyNONexisting
#wait 00002
#getjob 20002
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin 002
COPY j FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
#getstr 204
#perform
CREATE TEMP TABLE t(i int, t text);
#copyin 002
COPY t FROM stdin;
#getstr 205
#copyin 002
COPY t FROM stdin;
#select 5
SELECT '=', t, '~
'FROM t ORDER BY t;
#wait
#getjob 2
#perform
CREATE TEMP TABLE g(i int, n int, c int, s int);
#copyin 002
COPY g FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM g ORDER BY i;
#display 005
dnl
,dnl
0[0]=0
1[3]=0
2[6]=256
0[-1]=-1
1[-1]=-1
2[9]=0
3[13]=0
4[16]=0
=Then~
=There~dnl
)dnl

SELECTEST(dnl
,dnl
#cat     N
/dev/null
#exec    40N02
/bin/sh
#
-c
#
echo There
#exec    50N02
/bin/sh
#
-c
#
echo Then
#exec    60N02
/bin/mkdir
#
/dev/null/newerNewerNEWERexistingdirectory/newerestabsolytelyNONexisting
#wait 00002
#getjob 20002
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin 002
COPY j FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
#getstr 204
#perform
CREATE TEMP TABLE t(i int, t text);
#copyin 002
COPY t FROM stdin;
#getstr 205
#copyin 002
COPY t FROM stdin;
#select 5
SELECT '=', t, '~
'FROM t ORDER BY t;
#wait
#getjob 2
#perform
CREATE TEMP TABLE g(i int, n int, c int, s int);
#copyin 002
COPY g FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM g ORDER BY i;
#display 005
dnl
,dnl
0[1]=0
1[4]=0
2[7]=256
0[-1]=-1
1[-1]=-1
2[10]=0
3[14]=0
4[17]=0
=Then~
=There~dnl
)dnl


echo '= 16 ==='

cat << "EOF" >> ${TI}
#id1 pgo0
# -H15
-H15-
# -H0
-H0-

# +H0
--------

# +H1
-h1-
# +H2
-h2-
# +H
-h-
# +V
-v-
# +V0
-v0-
# -V0
-V0-

# +U1
-u1-
# +U12
-u12-
# -U0
-U0-
# +D
-d-
# +D1
-d1-
# -D3
-D3-
# +V0
-W0-
# +L
-l-
# +L1
-l1-
# -L1
-L1-
# -R
-r-
# +R0
-r0-
# -R1
-R1-
# -R0
-R0-
#id2 pgo0
# -H15
=H15-
# -H0
=H0-

# +H0
--------

# +H1
=h1-
# +H2
=h2-
# +H
=h-
# +V
=v-
# +V0
=v0-
# -V0
=V0-

# +U1
=u1-
# +U12
=u12-
# -U0
=U0-
# +D
=d-
# +D1
=d1-
# -D3
=D3-
# +V0
=W0-
# +L
=l-
# +L1
=l1-
# -L1
=L1-
# -R
=r-
# +R0
=r0-
# -R1
=R1-
# -R0
=R0-
#id3 pgo0
# -H15
=H15=
# -H0
=H0=

# +H0
--------

# +H1
=h1=
# +H2
=h2=
# +H
=h=
# +V
=v=
# +V0
=v0=
# -V0
=V0=

# +U1
=u1=
# +U12
=u12=
# -U0
=U0=
# +D
=d=
# +D1
=d1=
# -D3
=D3=
# +V0
=W0=
# +L
=l=
# +L1
=l1=
# -L1
=L1=
# -R
=r=
# +R0
=r0=
# -R1
=R1=
# -R0
=R0=
#id4 pgo0
# +H
# +D
#
#id5 pgo0 UD
#id6 pgo0 U
#id7 pgo0 D
#
EOF

define(DO2x,dnl
#perform
CREATE TEMP TABLE i(i int4);
INSERT INTO i VALUES(0);
INSERT INTO i SELECT i + 1 FROM i;dnl
)

define(CONst1,DO2x
INSERT INTO i SELECT i + 2 FROM i;
#select 2
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003002
id2
#close 3
#file 3
${TI}
#style 003003
id3)

SELECTEST(,CONst1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-d--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--H15--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-D3--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--U0--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002002,dnl
--------
=W0-=L1-0=r0-=v-=l1-0=R0-=V0-
=d-=H15-=u1-=W0-=L1-0=r0-=v-=l1-1=R0-=V0-
=d1-=h2-=W0-=L1-0=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-0=r0-=v-=l1-3=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-3=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-3=R0-=V0-
=d-=h-=u12-=W0-=L1-3=r0-=v-=l1-0=R0-=V0-
=D3-=h-=W0-=L1-3=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-3=r0-=v-=l1-2=R0-=V0-
=d-=h-=U0-=W0-=L1-3=r0-=v-=l1-3=R0-=V0-
=d-=H0-,EOF)

SELECTEST(,CONst1
#display 002003,dnl
--------
=W0==L1=0=r0==v==l1=0=R0==V0=
=d==H15==u1==W0==L1=0=r0==v==l1=1=R0==V0=
=d1==h2==W0==L1=0=r0==v==l1=2=R0==V0=
=d==h==W0==L1=0=r0==v==l1=3=R0==V0=
=d==h==W0==L1=1=r0==v==l1=0=R0==V0=
=d==h==W0==L1=1=r0==v==l1=1=R0==V0=
=d==h==W0==L1=1=r0==v==l1=2=R0==V0=
=d==h==W0==L1=1=r0==v==l1=3=R0==V0=
=d==h==W0==L1=2=r0==v==l1=0=R0==V0=
=d==h==W0==L1=2=r0==v==l1=1=R0==V0=
=d==h==W0==L1=2=r0==v==l1=2=R0==V0=
=d==h==W0==L1=2=r0==v==l1=3=R0==V0=
=d==h==u12==W0==L1=3=r0==v==l1=0=R0==V0=
=D3==h==W0==L1=3=r0==v==l1=1=R0==V0=
=d==h==W0==L1=3=r0==v==l1=2=R0==V0=
=d==h==U0==W0==L1=3=r0==v==l1=3=R0==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#echo 5
FreeBSD
#display 005003,--------
=U0==W0==l=FreeBSD=r0==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#file 5
tools/LICENSE
#display 005003,--------
=U0==W0==l=Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS \`\`AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
=r0==V0=
=d==H0=,EOF)

define(CONst1,DO2x
#select 2
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-D3--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--l1-0-R0--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)

SELECTEST(,CONst1
#select 2
SELECT NULLIF(j.i, 0), NULLIF(k.i, 0) FROM i j, i k ORDER BY j.i, k.i;
#display 002001,dnl
--------
-W0--v--V0-
-D3--h1--u1--W0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,,EOF)

define(CONst1,DO2x
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4
#close 3
#file 3
${TI}
#style 003001
id5)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,dnl
--------
-H0-,EOF)

define(CONst1,DO2x
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4
#close 3
#file 3
${TI}
#style 003001
id6)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,dnl
--------,EOF)

define(CONst1,DO2x
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4
#close 3
#file 3
${TI}
#style 003001
id7)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,dnl
-H0-,EOF)

cat << "EOF" >> ${TI}
#id7 pgo0 D
#id6 pgo0 U
#id5 pgo0 UD
#id4 pgo0
# +H
# +D
#
#id3 pgo0
# -H15
=H15=
# -H0
=H0=

# +H0
--------

# +H1
=h1=
# +H2
=h2=
# +H
=h=
# +V
=v=
# +V0
=v0=
# -V0
=V0=

# +U1
=u1=
# +U12
=u12=
# -U0
=U0=
# +D
=d=
# +D1
=d1=
# -D3
=D3=
# +V0
=W0=
# +L
=l=
# +L1
=l1=
# -L1
=L1=
# -R
=r=
# +R0
=r0=
# -R1
=R1=
# -R0
=R0=
#id2 pgo0
# -H15
=H15-
# -H0
=H0-

# +H0
--------

# +H1
=h1-
# +H2
=h2-
# +H
=h-
# +V
=v-
# +V0
=v0-
# -V0
=V0-

# +U1
=u1-
# +U12
=u12-
# -U0
=U0-
# +D
=d-
# +D1
=d1-
# -D3
=D3-
# +V0
=W0-
# +L
=l-
# +L1
=l1-
# -L1
=L1-
# -R
=r-
# +R0
=r0-
# -R1
=R1-
# -R0
=R0-
#id1 pgo0
# -H15
-H15-
# -H0
-H0-

# +H0
--------

# +H1
-h1-
# +H2
-h2-
# +H
-h-
# +V
-v-
# +V0
-v0-
# -V0
-V0-

# +U1
-u1-
# +U12
-u12-
# -U0
-U0-
# +D
-d-
# +D1
-d1-
# -D3
-D3-
# +V0
-W0-
# +L
-l-
# +L1
-l1-
# -L1
-L1-
# -R
-r-
# +R0
-r0-
# -R1
-R1-
# -R0
-R0-
#
EOF

define(CONst1,DO2x
INSERT INTO i SELECT i + 2 FROM i;
#select 2
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003002
id2
#close 3
#file 3
${TI}
#style 003003
id3)

SELECTEST(,CONst1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-d--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--H15--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-D3--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--U0--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002002,dnl
--------
=W0-=L1-0=r0-=v-=l1-0=R0-=V0-
=d-=H15-=u1-=W0-=L1-0=r0-=v-=l1-1=R0-=V0-
=d1-=h2-=W0-=L1-0=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-0=r0-=v-=l1-3=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-3=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-3=R0-=V0-
=d-=h-=u12-=W0-=L1-3=r0-=v-=l1-0=R0-=V0-
=D3-=h-=W0-=L1-3=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-3=r0-=v-=l1-2=R0-=V0-
=d-=h-=U0-=W0-=L1-3=r0-=v-=l1-3=R0-=V0-
=d-=H0-,EOF)

SELECTEST(,CONst1
#display 002003,dnl
--------
=W0==L1=0=r0==v==l1=0=R0==V0=
=d==H15==u1==W0==L1=0=r0==v==l1=1=R0==V0=
=d1==h2==W0==L1=0=r0==v==l1=2=R0==V0=
=d==h==W0==L1=0=r0==v==l1=3=R0==V0=
=d==h==W0==L1=1=r0==v==l1=0=R0==V0=
=d==h==W0==L1=1=r0==v==l1=1=R0==V0=
=d==h==W0==L1=1=r0==v==l1=2=R0==V0=
=d==h==W0==L1=1=r0==v==l1=3=R0==V0=
=d==h==W0==L1=2=r0==v==l1=0=R0==V0=
=d==h==W0==L1=2=r0==v==l1=1=R0==V0=
=d==h==W0==L1=2=r0==v==l1=2=R0==V0=
=d==h==W0==L1=2=r0==v==l1=3=R0==V0=
=d==h==u12==W0==L1=3=r0==v==l1=0=R0==V0=
=D3==h==W0==L1=3=r0==v==l1=1=R0==V0=
=d==h==W0==L1=3=r0==v==l1=2=R0==V0=
=d==h==U0==W0==L1=3=r0==v==l1=3=R0==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#echo 5
FreeBSD
#display 005003,--------
=U0==W0==l=FreeBSD=r0==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#file 5
tools/LICENSE
#display 005003,--------
=U0==W0==l=Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS \`\`AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
=r0==V0=
=d==H0=,EOF)

define(CONst1,DO2x
#select 2
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-D3--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--l1-0-R0--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)

SELECTEST(,CONst1
#select 2
SELECT NULLIF(j.i, 0), NULLIF(k.i, 0) FROM i j, i k ORDER BY j.i, k.i;
#display 002001,dnl
--------
-W0--v--V0-
-D3--h1--u1--W0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,,EOF)

define(CONst1,DO2x
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4
#close 3
#file 3
${TI}
#style 003001
id5)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,dnl
--------
-H0-,EOF)

define(CONst1,DO2x
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4
#close 3
#file 3
${TI}
#style 003001
id6)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,dnl
--------,EOF)

define(CONst1,DO2x
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4
#close 3
#file 3
${TI}
#style 003001
id7)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,dnl
-H0-,EOF)


echo '= 17 ==='

cat << "EOF" > ${TI}
#C
comment
#id1 pgo0
# = 0 1
# -H15
-H15-
# -H0
-H0-

# +H0
--------

# +H1
-h1-
# +H2
-h2-
# +H
-h-
# +V
-v-
# +V0
-v0-
# -V0
-V0-

# +U1
-u1-
# +U12
-u12-
# -U0
-U0-
# +D
-d-
# +D1
-d1-
# -D3
-D3-
# +V0
-W0-
# +L
-l-
# +L1
-l1-
# -L1
-L1-
# -R
-r-
# +R0
-r0-
# -R1
-R1-
# -R0
-R0-
#id2 pgo0
# -H15
=H15-
# -H0
=H0-

# +H0
--------

# = 1 0
# +H1
=h1-
# +H2
=h2-
# +H
=h-
# +V
=v-
# +V0
=v0-
# -V0
=V0-

# +U1
=u1-
# +U12
=u12-
# -U0
=U0-
# +D
=d-
# +D1
=d1-
# -D3
=D3-
# +V0
=W0-
# +L
=l-
# +L1
=l1-
# -L1
=L1-
# -R
=r-
# +R0
=r0-
# -R1
=R1-
# -R0
=R0-
#id3 pgo0
# -H15
=H15=
# -H0
=H0=

# +H0
--------

# +H1
=h1=
# +H2
=h2=
# +H
=h=
# +V
=v=
# +V0
=v0=
# -V0
=V0=

# +U1
=u1=
# +U12
=u12=
# -U0
=U0=
# +D
=d=
# +D1
=d1=
# -D3
=D3=
# +V0
=W0=
# +L
=l=
# +L1
=l1=
# -L1
=L1=
# -R
=r=
# +R0
=r0=
# -R1
=R1=
# -R0
=R0=
# = a b
#id4 pgo0
# +H
# +D
#
EOF

define(DO2x,dnl
#perform
CREATE TEMP TABLE i(i int4);
INSERT INTO i VALUES(0);
INSERT INTO i SELECT i + 1 FROM i;dnl
)

define(CONst1,DO2x
INSERT INTO i SELECT i + 2 FROM i;
#select 2
SELECT j.i AS a, k.i AS b FROM i j, i k ORDER BY j.i, k.i;
#close 300001
#file 3
${TI}
#style 003001
id1
#close 300002
#file 3
${TI}
#style 003002
id2
#close 300003
#file 3
${TI}
#style 003003
id3)

SELECTEST(,CONst1
#strselect 000001
SELECT j.i AS a, k.i AS b FROM i j, i k ORDER BY j.i, k.i;
,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-d--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--H15--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-D3--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--U0--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002002,dnl
--------
=W0-=L1-0=r0-=v-=l1-0=R0-=V0-
=d-=H15-=u1-=W0-=L1-1=r0-=v-=l1-0=R0-=V0-
=d1-=h2-=W0-=L1-2=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-3=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-0=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-3=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-0=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-3=r0-=v-=l1-2=R0-=V0-
=d-=h-=u12-=W0-=L1-0=r0-=v-=l1-3=R0-=V0-
=D3-=h-=W0-=L1-1=r0-=v-=l1-3=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-3=R0-=V0-
=d-=h-=U0-=W0-=L1-3=r0-=v-=l1-3=R0-=V0-
=d-=H0-,EOF)

SELECTEST(,CONst1
#display 002003,dnl
--------
=W0==L1=0=r0==v==l1=0=R0==V0=
=d==H15==u1==W0==L1=0=r0==v==l1=1=R0==V0=
=d1==h2==W0==L1=0=r0==v==l1=2=R0==V0=
=d==h==W0==L1=0=r0==v==l1=3=R0==V0=
=d==h==W0==L1=1=r0==v==l1=0=R0==V0=
=d==h==W0==L1=1=r0==v==l1=1=R0==V0=
=d==h==W0==L1=1=r0==v==l1=2=R0==V0=
=d==h==W0==L1=1=r0==v==l1=3=R0==V0=
=d==h==W0==L1=2=r0==v==l1=0=R0==V0=
=d==h==W0==L1=2=r0==v==l1=1=R0==V0=
=d==h==W0==L1=2=r0==v==l1=2=R0==V0=
=d==h==W0==L1=2=r0==v==l1=3=R0==V0=
=d==h==u12==W0==L1=3=r0==v==l1=0=R0==V0=
=D3==h==W0==L1=3=r0==v==l1=1=R0==V0=
=d==h==W0==L1=3=r0==v==l1=2=R0==V0=
=d==h==U0==W0==L1=3=r0==v==l1=3=R0==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#echo 5
FreeBSD
#display 005003,--------
=U0==W0==v==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#file 5
tools/LICENSE
#display 005003,--------
=U0==W0==v==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#echo 5
FreeBSD
#display 005001,--------
-U0--W0--L1-FreeBSD-r0--v--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#echo 5
FreeBSD
#display 005002,--------
=U0-=W0-=v-=l1-FreeBSD=R0-=V0-
=d-=H0-,EOF)

define(CONst1,DO2x
#select 2
SELECT j.i AS a, k.i AS b FROM i j, i k ORDER BY j.i, k.i;
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-D3--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--l1-0-R0--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)

SELECTEST(,CONst1
#select 2
SELECT NULLIF(j.i, 0), NULLIF(k.i, 0) FROM i j, i k ORDER BY j.i, k.i;
#display 002001,dnl
--------
-W0--v--V0-
-D3--h1--u1--W0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)

cat << "EOF" > ${TI}
#C 
comment
#id4 pgo0
# +H
# +D
#id3 pgo0
# -H15
=H15=
# -H0
=H0=

# +H0
--------

# +H1
=h1=
# +H2
=h2=
# +H
=h=
# +V
=v=
# +V0
=v0=
# -V0
=V0=

# +U1
=u1=
# +U12
=u12=
# -U0
=U0=
# +D
=d=
# +D1
=d1=
# -D3
=D3=
# +V0
=W0=
# +L
=l=
# +L1
=l1=
# -L1
=L1=
# -R
=r=
# +R0
=r0=
# -R1
=R1=
# -R0
=R0=
# = a b
#id2 pgo0
# -H15
=H15-
# -H0
=H0-

# +H0
--------

# = 1 0
# +H1
=h1-
# +H2
=h2-
# +H
=h-
# +V
=v-
# +V0
=v0-
# -V0
=V0-

# +U1
=u1-
# +U12
=u12-
# -U0
=U0-
# +D
=d-
# +D1
=d1-
# -D3
=D3-
# +V0
=W0-
# +L
=l-
# +L1
=l1-
# -L1
=L1-
# -R
=r-
# +R0
=r0-
# -R1
=R1-
# -R0
=R0-
#id1 pgo0
# = 0 1
# -H15
-H15-
# -H0
-H0-

# +H0
--------

# +H1
-h1-
# +H2
-h2-
# +H
-h-
# +V
-v-
# +V0
-v0-
# -V0
-V0-

# +U1
-u1-
# +U12
-u12-
# -U0
-U0-
# +D
-d-
# +D1
-d1-
# -D3
-D3-
# +V0
-W0-
# +L
-l-
# +L1
-l1-
# -L1
-L1-
# -R
-r-
# +R0
-r0-
# -R1
-R1-
# -R0
-R0-
#
EOF

define(CONst1,DO2x
INSERT INTO i SELECT i + 2 FROM i;
#select 2
SELECT j.i AS a, k.i AS b FROM i j, i k ORDER BY j.i, k.i;
#close 300001
#file 3
${TI}
#style 003001
id1
#close 300002
#file 3
${TI}
#style 003002
id2
#close 300003
#file 3
${TI}
#style 003003
id3)

SELECTEST(,CONst1
#strselect 000001
SELECT j.i AS a, k.i AS b FROM i j, i k ORDER BY j.i, k.i;
,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-d--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--H15--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-D3--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--U0--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002002,dnl
--------
=W0-=L1-0=r0-=v-=l1-0=R0-=V0-
=d-=H15-=u1-=W0-=L1-1=r0-=v-=l1-0=R0-=V0-
=d1-=h2-=W0-=L1-2=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-3=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-0=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-3=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-0=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-3=r0-=v-=l1-2=R0-=V0-
=d-=h-=u12-=W0-=L1-0=r0-=v-=l1-3=R0-=V0-
=D3-=h-=W0-=L1-1=r0-=v-=l1-3=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-3=R0-=V0-
=d-=h-=U0-=W0-=L1-3=r0-=v-=l1-3=R0-=V0-
=d-=H0-,EOF)

SELECTEST(,CONst1
#display 002003,dnl
--------
=W0==L1=0=r0==v==l1=0=R0==V0=
=d==H15==u1==W0==L1=0=r0==v==l1=1=R0==V0=
=d1==h2==W0==L1=0=r0==v==l1=2=R0==V0=
=d==h==W0==L1=0=r0==v==l1=3=R0==V0=
=d==h==W0==L1=1=r0==v==l1=0=R0==V0=
=d==h==W0==L1=1=r0==v==l1=1=R0==V0=
=d==h==W0==L1=1=r0==v==l1=2=R0==V0=
=d==h==W0==L1=1=r0==v==l1=3=R0==V0=
=d==h==W0==L1=2=r0==v==l1=0=R0==V0=
=d==h==W0==L1=2=r0==v==l1=1=R0==V0=
=d==h==W0==L1=2=r0==v==l1=2=R0==V0=
=d==h==W0==L1=2=r0==v==l1=3=R0==V0=
=d==h==u12==W0==L1=3=r0==v==l1=0=R0==V0=
=D3==h==W0==L1=3=r0==v==l1=1=R0==V0=
=d==h==W0==L1=3=r0==v==l1=2=R0==V0=
=d==h==U0==W0==L1=3=r0==v==l1=3=R0==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#echo 5
FreeBSD
#display 005003,--------
=U0==W0==v==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#file 5
tools/LICENSE
#display 005003,--------
=U0==W0==v==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#echo 5
FreeBSD
#display 005001,--------
-U0--W0--L1-FreeBSD-r0--v--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#echo 5
FreeBSD
#display 005002,--------
=U0-=W0-=v-=l1-FreeBSD=R0-=V0-
=d-=H0-,EOF)

define(CONst1,DO2x
#select 2
SELECT j.i AS a, k.i AS b FROM i j, i k ORDER BY j.i, k.i;
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-D3--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--l1-0-R0--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)

SELECTEST(,CONst1
#select 2
SELECT NULLIF(j.i, 0), NULLIF(k.i, 0) FROM i j, i k ORDER BY j.i, k.i;
#display 002001,dnl
--------
-W0--v--V0-
-D3--h1--u1--W0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)


echo '= 18 ==='

SELECTEST(,#echo 2
##t pgo0
## = i0 i0 i1 i1
#style 002001
t
#perform
CREATE TEMP TABLE t(i0 int, i1 int);
#perform
INSERT INTO t VALUES(0, 1);
#select 300001
SELECT * FROM t;
#display 003001
#echo


#,dnl
0011dnl
,EOF)

SELECTEST(,#echo 2
##t pgo0
## = 0 0 1 1
#style 002001
t
#perform
CREATE TEMP TABLE t(i0 int, i1 int);
#perform
INSERT INTO t VALUES(0, 1);
#select 300001
SELECT * FROM t;
#display 003001
#echo


#,dnl
0011dnl
,EOF)

SELECTEST(,#echo 2
##t pgo0
## = i0 i0 i1 i1
#style 002001
t
#perform
CREATE TEMP TABLE t(i0 int, i1 int);
#perform
INSERT INTO t VALUES(0, 1);
#strselect 000001
SELECT * FROM t;
#echo


#,dnl
0011dnl
,EOF)

SELECTEST(,#echo 2
##t pgo0
## = 0 0 1 1
#style 002001
t
#perform
CREATE TEMP TABLE t(i0 int, i1 int);
#perform
INSERT INTO t VALUES(0, 1);
#strselect 000001
SELECT * FROM t;
#echo


#,dnl
0011dnl
,EOF)

SELECTEST(,#echo 2
##t pgo0
## = i1 i1 i0 i0
#style 002001
t
#perform
CREATE TEMP TABLE t(i0 int, i1 int);
#perform
INSERT INTO t VALUES(0, 1);
#select 300001
SELECT * FROM t;
#display 003001
#echo


#,dnl
1100dnl
,EOF)

SELECTEST(,#echo 2
##t pgo0
## = 1 1 0 0
#style 002001
t
#perform
CREATE TEMP TABLE t(i0 int, i1 int);
#perform
INSERT INTO t VALUES(0, 1);
#select 300001
SELECT * FROM t;
#display 003001
#echo


#,dnl
1100dnl
,EOF)

SELECTEST(,#echo 2
##t pgo0
## = i1 i1 i0 i0
#style 002001
t
#perform
CREATE TEMP TABLE t(i0 int, i1 int);
#perform
INSERT INTO t VALUES(0, 1);
#strselect 000001
SELECT * FROM t;
#echo


#,dnl
1100dnl
,EOF)

SELECTEST(,#echo 2
##t pgo0
## = 1 1 0 0
#style 002001
t
#perform
CREATE TEMP TABLE t(i0 int, i1 int);
#perform
INSERT INTO t VALUES(0, 1);
#strselect 000001
SELECT * FROM t;
#echo


#,dnl
1100dnl
,EOF)


echo '= 19 ==='

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H0
## +H 
-
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
-00-01-10-11-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H 
-
#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
-00-01-10-11-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H0
## +H

##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H

#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H
#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H
## +H0

##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0

#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H0
## +H 

##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H 

#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H 
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H 
#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H
## +H0 

##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0 

#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0 
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0 
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -V0
|
## +D
--

## -H0
O


#style 003001
id1
#strselect 000001
SELECT NULL, NULL FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## -V0


#style 003001
id1
#strselect 000001
SELECT NULL, NULL FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## -V0
#style 003001
id1
#strselect 000001
SELECT NULL, NULL FROM i j, i k ORDER BY j.i, k.i;
,dnl
|--
|--
|--
|--
O
--
--
--
--
O
Odnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## +L0
## +L1
## +L2
## +L
## +U0
## +U1
## +U2
## +U
>
## +R0
## +R1
## +R2
## +R
## +D0
## +D1
## +D2
## +D
<
## -H0



#style 003001
id1
#select 4
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#display 004001
,dnl
>>0<>0<<>>0<>1<<>>1<>0<<>>1<>1<<dnl
)

SELECTEST(,DO2x
#echo 3
##id pgo0
## +L
## +U
>
## +R
## +D
<
## -H0


##id1 pgo0
## +L
## +U
}
## +R
## +D
{
## -H0



#style 003001
id1
#select 4
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#display 004001
,dnl
}}0{}0{{}}0{}1{{}}1{}0{{}}1{}1{{dnl
)

SELECTEST(,DO2x
#echo 3
##id pgo0
## +L
>
## +R
<
## -V0


## -N
O
## +N0
o

#style 003001
id
#select 4
SELECT j.i, NULLIF(k.i, 1) FROM i j, i k ORDER BY j.i, k.i;
#display 004001
#select 5
SELECT NULLIF(j.i, 1), k.i FROM i j, i k ORDER BY j.i, k.i;
#display 005001
#select 6
SELECT NULLIF(j.i, 1), NULLIF(k.i, 1) FROM i j, i k ORDER BY j.i, k.i;
#display 006001
,dnl
>0<>0<
>0<O
>1<>0<
>1<O
>0<>0<
>0<>1<
o>0<
o>1<
>0<>0<
>0<O
o>0<
oO)


echo '= 20 ==='

define(CONst1,#id1 pgo0
# buratino


# testfile
${TI}
#)

cat << EOF > ${TI}
CONst1
EOF

SELECTEST(,#file 3
${TI}
#style 003001
id1
#echo 000001
buratino
#file 000001
testfile
#cat 000001
testfile,dnl

CONst1
CONst1,EOF)

SELECTEST(,#
#echo
OK
,OK)

SELECTEST(,# $
#echo
OK
,OK)

SELECTEST(,#--
#echo
OK
,OK)

SELECTEST(, #
#echo
OK
,OK)

SELECTEST(, # $
#echo
OK
,OK)

SELECTEST(, #--
#echo
OK
,OK)

define(CONst1,#id1 pgo0
# bu


# te
${TI}

#)

cat << EOF > ${TI}
CONst1
EOF

SELECTEST(,#file 3
${TI}
#style 003001
id1
#select 2
SELECT 'bu';
#echo 020001
#select 2
SELECT 'te';
#echo 020001
,
${TI},EOF)


echo '= 21 ==='

rm -rf ${TI}
mkdir ${TI}
mkdir ${TI}/b
(cd ${TI}/b;ln -s . a; ln -s /dev/null/newerNewerNEWERexistingdirectory)

SELECTEST(,#perform
CREATE TEMP TABLE d(i int4, t text, s int4, y int8)
#getdir 2
0x0F ${TI}/b
#copyin 002
COPY d FROM stdin
#perform
UPDATE d SET s = s - (SELECT s FROM d WHERE t = '.')
 WHERE t = 'a'
   AND y = 16877
;
CREATE TEMP TABLE t(tt text, ts int4);
INSERT INTO t SELECT t, s FROM d WHERE t IN('.', '..');
UPDATE d SET s = s - (SELECT ts FROM t WHERE t <> tt)
 WHERE t IN('.', '..')
;
#select
SELECT i, '	', t, '	', s, '	', y, '
'FROM d
ORDER BY i, y DESC
,0	.	0	16877
1	..	0	16877
2	a	1	41453
2	a	0	16877
3	newerNewerNEWERexistingdirectory	42	41453dnl
,EOF)

SELECTEST(,#perform
CREATE TEMP TABLE t(t text);
#perform
INSERT INTO t VALUES('#!
##perform
CREATE TEMP TABLE tmp(tmp text);
##select 2
SELECT ''/dev/null/newerNewerNEWERexistingdirectory''
##getdir 602
0x04
##copyin 006
COPY tmp FROM stdin;
##close 606
##select 6
SELECT tmp FROM tmp;
##select 006
SELECT ?;
');
#select 3
SELECT t FROM t;
#eval 03
,,EOF)

SELECTEST(,#perform
CREATE TEMP TABLE d(i int4, t text, s int4, y int8)
#select D
SELECT * FROM (SELECT '${TI}/b' UNION ALL SELECT '${TI}/b')u
#getdir 20D
0x0F
#copyin 002
COPY d FROM stdin
#perform
UPDATE d SET s = s - (SELECT s FROM d WHERE t = '.' LIMIT 1)
 WHERE t = 'a'
   AND y = 16877
;
CREATE TEMP TABLE t(tt text, ts int4);
INSERT INTO t SELECT DISTINCT t, s FROM d WHERE t IN('.', '..');
UPDATE d SET s = s - (SELECT ts FROM t WHERE t <> tt)
 WHERE t IN('.', '..')
;
#select
SELECT i, '	', t, '	', s, '	', y, '
'FROM d
ORDER BY i, y DESC
,0	.	0	16877
0	.	0	16877
1	..	0	16877
1	..	0	16877
2	a	1	41453
2	a	1	41453
2	a	0	16877
2	a	0	16877
3	newerNewerNEWERexistingdirectory	42	41453
3	newerNewerNEWERexistingdirectory	42	41453dnl
,EOF)

rm -rf ${TI}

SELECTEST(,#getdir
0x0F /dev/null/newerNewerNEWERexistingdirectory
#,0	newerNewerNEWERexistingdirectory	\N	\N
\.)


echo '= 22 ==='

SELECTEST(=,
#perform
CREATE TEMP TABLE t(i integer);
INSERT INTO t VALUES(0);
INSERT INTO t SELECT i + 1 FROM t;
INSERT INTO t SELECT i + 2 FROM t;
INSERT INTO t VALUES(4);
INSERT INTO t SELECT i + 5 FROM t;
INSERT INTO t SELECT i + 10 FROM t;
INSERT INTO t VALUES(20);
#exec    3
/bin/date
#
+%s
#select  2
SELECT '/bin/sh', '-c', 'sleep 1' FROM t
#job     00002
local 5
#exec    02002
#wait    00002
#exec    4
/bin/date
#
+%s
#perform
CREATE TEMP TABLE t1(t1 integer);
CREATE TEMP TABLE t2(t2 integer);
#copyin 003
COPY t1 FROM stdin
#copyin 004 
COPY t2 FROM stdin
#select
SELECT CASE WHEN (t2 - t1) < 5 THEN 'FAIL' ELSE 'OK' END, '
'FROM t2, t1
,OK)

SELECTEST(=,
#cat     N
/dev/null
#perform
CREATE TEMP TABLE t(i integer);
INSERT INTO t VALUES(0);
INSERT INTO t SELECT i + 1 FROM t;
INSERT INTO t SELECT i + 2 FROM t;
INSERT INTO t VALUES(4);
INSERT INTO t SELECT i + 5 FROM t;
INSERT INTO t SELECT i + 10 FROM t;
INSERT INTO t VALUES(20);
#exec    30N
/bin/date
#
+%s
#select  2
SELECT '/bin/sh', '-c', 'sleep 1' FROM t
#job     00002
local 5
#exec    02N02
#wait    00002
#exec    40N
/bin/date
#
+%s
#perform
CREATE TEMP TABLE t1(t1 integer);
CREATE TEMP TABLE t2(t2 integer);
#copyin 003
COPY t1 FROM stdin
#copyin 004 
COPY t2 FROM stdin
#select
SELECT CASE WHEN (t2 - t1) < 5 THEN 'FAIL' ELSE 'OK' END, '
'FROM t2, t1
,OK)


echo '= 23 ==='

SELECTEST(,#select
SELECT REGEX('aa', 'a+'), '
'
#select
SELECT REGEX('a', '^A$'), '
'
#select
SELECT REGEX('a', NULL), '
'
#select
SELECT REGEX(NULL, '^A$'), '
'
#select
SELECT REGEX(NULL, NULL), '
',1
0


)

SELECTEST(=,#select
SELECT quote_literal('regexp(\''a+", \\''aa'')'), '
'
#select
SELECT quote_ident('(''^B$'', ''a'')'), '
'
#select
SELECT quote_ident('0fu'), quote_ident('CASE'), quote_ident('case0'), '
'
#select
SELECT quote_ident('notident'), quote_ident('case'), quote_ident(' case'), '
'
#select
SELECT quote_ident_always('(''^B$'', ''a'')'), '
'
#select
SELECT quote_ident_always('0fu'), quote_ident_always('CASE'), quote_ident_always('case0'), '
'
#select
SELECT quote_ident_always('notident'), quote_ident_always('case'), quote_ident_always(' case'), '
','regexp(\''a+", \\''aa'')'
"('^B$', 'a')"
"0fu""CASE"case0
notident"case"" case"
"('^B$', 'a')"
"0fu""CASE""case0"
"notident""case"" case")

SELECTEST(=,#select
SELECT quote_html('-<''>+&">-'), '
',-&lt;'&gt;+&amp;&quot;&gt;-)


echo '= 24 ==='

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
INSERT INTO a(a, b) VALUES('foo', 'bar');
#select 2
SELECT b, a FROM a ORDER BY i;
#perform 002
INSERT INTO a(a, b) VALUES(?, ?);
#select 2
SELECT b FROM a ORDER BY a LIMIT 1;
#select 302
SELECT a, b FROM a WHERE a = ? ORDER BY i;
#perform 003
INSERT INTO a(a, b) VALUES(?, ?);
#select 2
SELECT a, a FROM a ORDER BY i;
#perform 002
INSERT INTO a(a, b) VALUES(?, ?);
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
,dnl
 | 1 | foo | bar
 | 2 | bar | foo
 | 3 | foo | bar
 | 4 | foo | foo
 | 5 | bar | bar
 | 6 | foo | foo
--)

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
#echo 2
foo
#perform 002
INSERT INTO a(a) VALUES(?);
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
,dnl
 | 1 | foo | 
--)

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
INSERT INTO a(a, b) VALUES('foo', 'bar');
#select 2
SELECT * FROM a ORDER BY i;
#echo 32
#perform 003
INSERT INTO a(a) VALUES(?);
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
#echo 32
#perform 003
INSERT INTO a(a) VALUES(?);
#select  2
SELECT a, b FROM a ORDER BY i;
#display 00200r
#perform 002
INSERT INTO a(b, a) VALUES(?, ?);
#select  2
SELECT * FROM a ORDER BY i;
#display 00200r
#select  2
SELECT 'INSERT INTO a(a, b) VALUES('
     , COALESCE(quote_literal(b), 'NULL')
     , ', '
     , COALESCE(quote_literal(a), 'NULL')
     , ');
'FROM a
;
#echo    42
#perform 04
#select  2
SELECT * FROM a ORDER BY i;
#display 00200r
#select  2
SELECT * FROM a ORDER BY i DESC;
#select  302
SELECT * FROM a WHERE a = ? || ? || COALESCE(?, '') ORDER BY i;
#display 00300r
,dnl
 | 1 | foo | bar
 | 2 | 1foobar | 
--
 | foo | bar
 | 1foobar | 
 | 1foobar21foobar | 
--
 | 1 | foo | bar
 | 2 | 1foobar | 
 | 3 | 1foobar21foobar | 
 | 4 | bar | foo
 | 5 |  | 1foobar
 | 6 |  | 1foobar21foobar
--
 | 1 | foo | bar
 | 2 | 1foobar | 
 | 3 | 1foobar21foobar | 
 | 4 | bar | foo
 | 5 |  | 1foobar
 | 6 |  | 1foobar21foobar
 | 7 | bar | foo
 | 8 |  | 1foobar
 | 9 |  | 1foobar21foobar
 | 10 | foo | bar
 | 11 | 1foobar | 
 | 12 | 1foobar21foobar | 
--
 | 2 | 1foobar | 
 | 11 | 1foobar | 
--)

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
INSERT INTO a(a, b) VALUES('INSERT ', 'INTO a(a, b)');
INSERT INTO a(a, b) VALUES(' VALUES', '(');
INSERT INTO a(a, b) VALUES('?', ', ?);');
#select 2
SELECT a, b FROM a ORDER BY i;
#select 3
SELECT a, b FROM a ORDER BY i;
#echo    42
#perform 043
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
,dnl
 | 1 | INSERT  | INTO a(a, b)
 | 2 |  VALUES | (
 | 3 | ? | , ?);
 | 4 | INSERT  | INTO a(a, b)
 | 5 |  VALUES | (
 | 6 | ? | , ?);
--)

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
INSERT INTO a(a, b) VALUES('INSERT ', 'INTO a(a, b)');
INSERT INTO a(a, b) VALUES(' VALUES', '(');
INSERT INTO a(a, b) VALUES('?', ', ?);');
#select 2
SELECT a, b FROM a ORDER BY i;
#echo    42
#perform 042
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
,dnl
 | 1 | INSERT  | INTO a(a, b)
 | 2 |  VALUES | (
 | 3 | ? | , ?);
 | 4 | INSERT  | INTO a(a, b)
 | 5 |  VALUES | (
 | 6 | ? | , ?);
--)

SELECTEST(,dnl
#perform
CREATE TEMP TABLE t(t text);
INSERT INTO t VALUES(NULL);
#select 2
SELECT * FROM t;
#perform 002
INSERT INTO t VALUES(?);
#copyout
COPY t TO stdout;
,dnl
\N
\N)


echo '= 25 ==='

SELECTEST(dnl
,
#echo   1
eoghr
934
0o5gh
#exec    001
/usr/bin/grep
#
-E
#
[45]
#wait
dnl
,dnl
934
0o5ghdnl
)dnl

SELECTEST(dnl
,
#perform
CREATE TEMP TABLE t(t text);
#echo    1
eoghr
934
0o5gh
#copyin   001
COPY t FROM stdin;
#echo     P
##P pgo0
## +V0
SELECT '
## -V0
';

##
#style   00P00P
P
#select  2
SELECT * FROM t;
#display 30200P
#echo    03
#wait
dnl
,dnl
SELECT 'eoghr';
SELECT '934';
SELECT '0o5gh';dnl
)dnl


echo '= 26 ==='

dnl ##############
dnl thTEST
dnl
define(thTEST,; then
fiTEST($1)
)dnl

export QUERY_STRING='kjn=er&kjb'

SELECTEST(,dnl
#file 2
${TR}
#getget 2
#getjob 3
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin 003
COPY j FROM stdin;
#strselect 2
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
,dnl
0	kjn	er
1	\N	kjb
\.
0[-1]=-1
1[-1]=-1,EOF)


SELECTEST(,dnl
#file 4
${TP}
#cat 4
${TR}
#echo 4
0	kjn	er
1	\N	kjb
\.
0[-1]=-1
1[-1]=-1

#cat 2
${TR}
#getget 2
#getjob 3
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin 003
COPY j FROM stdin;
#strselect 2
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
,,EOF)


echo '= 27 ==='

dnl ##############
dnl ifTEST
dnl
define(ifTEST,dnl
define(COUNTER,incr(COUNTER))dnl
# COUNTER #####################################
DOinPIPE
)dnl
dnl
dnl ##############
dnl fiTEST
dnl
define(fiTEST,dnl
if  [ "$?" -eq "RESSULT" ]; then
    echo -n "COUNTER OK	# "
else
    e=$(( ${e} + 1 ))
    echo -n "COUNTER diff	# "
fi
head -2 ${TF} | tail -1dnl
)dnl
dnl
dnl ##############
dnl thTEST
dnl
define(thTEST,
fiTEST($1)
)dnl

define(RESSULT,0)

SELECTEST(,#exit)

define(RESSULT,14)

SELECTEST(,#exit
14)

SELECTEST(,#echo 2
14
#exit 02)

define(RESSULT,1)

SELECTEST(,#exec 00002
/usr/bin/false
#wait 00002
#getjob 20002
#perform
CREATE TEMP TABLE j(i int, n int, p int, s int);
#copyin 002
COPY j FROM stdin;
#strselect 3
SELECT (s >> 8) & 255 FROM j;
#exit 03)


echo '= 28 ==='

cat << "EOF" > ${TP}
0	d	{"planius","a","d"}
1	:	{}
2	a	{}
3	b	{"-t"}
4	c	{"-v","-y"}
5	t	\N
6	b	{"\\\\"}
EOF
cat << "EOF" > ${TF}
#getopt
1 :ab:c::d:::
#
EOF

if  ! ${prog} ${TF} -d planius a d -z '-: -a -b -t -c -v -y' -t -b '\' > ${TR}; then
        e=$(( ${e} + 1 ))
    echo "#1 err	#"
elif ! diff ${TP} ${TR}; then
    e=$(( ${e} + 1 ))
    echo -n "#1 diff	# "
    head -2 ${TF} | tail -1
else
    echo -n "#1 OK	# "
    head -2 ${TF} | tail -1
fi

if  ! ${prog} -f ${TF} -- -d planius a d -z '-: -a -b -t -c -v -y' -t -b '\' > ${TR}; then
        e=$(( ${e} + 1 ))
    echo "#2 err	#"
elif ! diff ${TP} ${TR}; then
    e=$(( ${e} + 1 ))
    echo -n "#2 diff	# "
    head -2 ${TF} | tail -1
else
    echo -n "#2 OK	# "
    head -2 ${TF} | tail -1
fi

if  ! ${prog} -e "#getopt
0 :ab:c::d:::
#
" -- -d planius a d -z '-: -a -b -t -c -v -y' -t -b '\' > ${TR}; then
    e=$(( ${e} + 1 ))
    echo "#3 err	#"
elif ! diff ${TP} ${TR}; then
    e=$(( ${e} + 1 ))
    echo -n "#3 diff	# "
    head -2 ${TF} | tail -1
else
    echo -n "#3 OK	# "
    head -2 ${TF} | tail -1
fi

if  ! ${prog} -e "#!${prog}
#getopt
0 :ab:c::d:::
#
" -- -d planius a d -z '-: -a -b -t -c -v -y' -t -b '\' > ${TR}; then
    e=$(( ${e} + 1 ))
    echo "#4 err	#"
elif ! diff ${TP} ${TR}; then
    e=$(( ${e} + 1 ))
    echo -n "#4 diff	# "
    head -2 ${TF} | tail -1
else
    echo -n "#4 OK	# "
    head -2 ${TF} | tail -1
fi

cat << EOF > ${TF}
#!${prog}
#getopt
1 :ab:c::d:::
#
EOF

if  ! ${prog} ${TF} -d planius a d -z '-: -a -b -t -c -v -y' -t -b '\' > ${TR}; then
        e=$(( ${e} + 1 ))
    echo "#5 err	#"
elif ! diff ${TP} ${TR}; then
    e=$(( ${e} + 1 ))
    echo -n "#5 diff	# "
    head -2 ${TF} | tail -1
else
    echo -n "#5 OK	# "
    head -2 ${TF} | tail -1
fi

if  ! ${prog} -f ${TF} -- -d planius a d -z '-: -a -b -t -c -v -y' -t -b '\' > ${TR}; then
        e=$(( ${e} + 1 ))
    echo "#6 err	#"
elif ! diff ${TP} ${TR}; then
    e=$(( ${e} + 1 ))
    echo -n "#6 diff	# "
    head -2 ${TF} | tail -1
else
    echo -n "#6 OK	# "
    head -2 ${TF} | tail -1
fi

if  ! ${TF} -d planius a d -z '-: -a -b -t -c -v -y' -t -b '\' > ${TR}; then
        e=$(( ${e} + 1 ))
    echo "#7 err	#"
elif ! diff ${TP} ${TR}; then
    e=$(( ${e} + 1 ))
    echo -n "#7 diff	# "
    head -2 ${TF} | tail -1
else
    echo -n "#7 OK	# "
    head -2 ${TF} | tail -1
fi

cat << EOF > ${TF}
#!${prog} -f
#getopt
1 :ab:c::d:::
#
EOF

if  ! ${TF} -- -d planius a d -z '-: -a -b -t -c -v -y' -t -b '\' > ${TR}; then
        e=$(( ${e} + 1 ))
    echo "#8 err	#"
elif ! diff ${TP} ${TR}; then
    e=$(( ${e} + 1 ))
    echo -n "#8 diff	# "
    head -2 ${TF} | tail -1
else
    echo -n "#8 OK	# "
    head -2 ${TF} | tail -1
fi

dnl inTEXT()
dnl SELECTEST(,,)

rm -f ${TF} ${TP} ${TR} ${TI} ${TD}
echo "${e} errors in ${OO}"
if [ "${e}" -ne 0 ]; then exit 1; fi
