/*-
 * Copyright (C)2008..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: style_0.c,v 1.58 2022/01/08 18:35:13 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

static int
/**********************************************************************
 **                                                                  **/
init(pgoblin_main *options, int slot) {                             /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
fini(pgoblin_main *options) {                                       /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
parser(pgoblin_exenv *exenv, pgoblin_nr nst, char *tin) {           /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static void
/**********************************************************************
 **                                                                  **/
dump(pgoblin_exenv *exenv, pgoblin_nr nst) {                        /**
 **                                                                  **
 **********************************************************************/
    return;
}

static int
/**********************************************************************
 **                                                                  **/
clear(pgoblin_exenv *exenv, pgoblin_nr nst) {                       /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static char *
/**********************************************************************
 **                                                                  **/
get(pgoblin_exenv *exenv, pgoblin_nr nst, pgoblin_nr nct) {         /**
 **                                                                  **
 **********************************************************************/
    return(NULL);
}

static int
/*******************************************************************************
 **                                                                           **/
sout(pgoblin_exenv *exenv, pgoblin_nr nou, char *c, ssize_t l, ssize_t ll) { /**
 **                                                                           **
 *******************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rou;
    int          ex = 0;

    GET_RIO(rou, exenv->options, nou);
    if  (c) {
        ifBLIN_QX5("%"BLIN_U"<%"BLIN_U"=%.*s~", l, ll, (int)l, c);
        if  (rou->wri) {
            ex = rou->wri(rou->onu, c, l);
            ifBLIN_QX5("%d", ex);
        } else if (0 > ll) {
            ifBLIN_QX0("invalid out buf ");
            ERROUT(-EX_SOFTWARE, EDOOFUS);
        } else if (rou->length + l > (size_t)ll) {
            ifBLIN_QX0("out buf len err");
            ERROUT(-EX_SOFTWARE, EDOOFUS);
        } else {
            MARK_IO_TEXT_GO(nou);;
            ;;  bcopy(c, &((char*)(rou->text))[rou->length], l);
            ;;  rou->length += l;
            ;;  ((char*)(rou->text))[rou->length] = '\0';
            MARK_IO_TEXT_WENT(nou);;
            ifBLIN_QX5("%"BLIN_U"<%"BLIN_U, l, ll);
    }   }
out:
    return(ex);
#   undef blin_internal_flags
}

static ssize_t
/*************************************************************************************
 **                                                                                 **/
table( pgoblin_exenv *exenv                                                        /**/
     , pgoblin_nr     nst                                                          /**/
     , pgoblin_nr     nou                                                          /**/
     , pgoblin_nr     nin                                                          /**/
     , ssize_t        low                                                          /**/
     , ssize_t        hig                                                          /**/
     ) {                                                                           /**
 **                                                                                 **
 *************************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    int             isnull;
    ssize_t         minc;
    ssize_t         maxc;
    pgoblin_rio    *rou;
    pgoblin_rio    *rin;
    ssize_t         ex = 0;
    ssize_t         ll = 0;
    ssize_t         i  = 0;
    ssize_t         l  = 0;
    ssize_t         m;
    ssize_t         w;
    ssize_t         j;

    GET_RIO(rou, exenv->options, nou);
    GET_RIO(rin, exenv->options, nin);
    if  (0 > (m = pgoblin_db_resinfo(exenv, nin, PGOBLIN_Ntuples))) {
        ifBLIN_QW0("Ntuples");
        ex = -EX_DATAERR;
        goto out;
    }
    if  (0 > (w = pgoblin_db_resinfo(exenv, nin, PGOBLIN_Nfields))) {
        ifBLIN_QW0("Nfields");
        ex = -EX_DATAERR;
        goto out;
    }
    isnull = ((m == 0) || (w == 0)) ? 1 : 0;
    if  (hig == -3) {
        minc = low;
        maxc = (low < m) ? low + 1 : m;
    } else {
        minc = 0;
        maxc = m;
    }
    ifBLIN_QX3("+ %08X %d x %d %d..%d", !(rin->pq) ? 0 : *(rin->pq), m, w, minc, maxc);
    if  (!rou->wri) {
        char *s;

        /*      */
        for (i = minc, isnull = 1, l = 0; i < maxc; i++) {
            for (j = 0; j < w; j++) {
                if  (!pgoblin_db_valinfo(exenv, nin, PGOBLIN_IsNull, i, j)) {
                    isnull = 0;
                    ex = pgoblin_db_valinfo(exenv, nin, PGOBLIN_Length, i, j);
                    ifBLIN_QX5("%"BLIN_U"+%d", l, ex);
                    if  (ex < 0) {
                        ifBLIN_QW0("table in 0 STYLE");
                        ex = -EX_IOERR;
                        goto out;
                    }
                    l += ex;
        }   }   }
        if  (isnull) {
            s = NULL;
        } else if (!(s = malloc(l + 1))) {
            ifBLIN_QX0("table in 0 STYLE: No mem");
            ERROUT(-EX_OSERR, ENOMEM);
        }
        ifBLIN_QX5("%"BLIN_X"+%"BLIN_U, BLIN_I(s), l);
        /*       */
        MARK_IO_TEXT_GO(nou);;
        ;;  if  (rou->text && (rou->flags & PGOBLIN_FREETEXT)) free(rou->text);
        ;;  rou->text = s;
        ;;  rou->length = 0;
        ;;  if  (s) {
        ;;      rou->flags |= PGOBLIN_BINPARM | PGOBLIN_FREETEXT;
        ;;      ((char*)(rou->text))[rou->length] = '\0';
        ;;  } else {
        ;;      rou->flags &= ~(PGOBLIN_TEXTPARM | PGOBLIN_BINPARM | PGOBLIN_FREETEXT);
        ;;  }
        MARK_IO_TEXT_WENT(nou);;
    }
    for (i = minc, ll = 0; i < maxc; i++) {
        for (j = 0; j < w; j++) {
            if  (!pgoblin_db_valinfo(exenv, nin, PGOBLIN_IsNull, i, j)) {
                ex = sout( exenv
                         , nou
                         , pgoblin_db_getvalue(exenv, nin, i, j)
                         , pgoblin_db_valinfo(exenv, nin, PGOBLIN_Length, i, j)
                         , l
                         );
                if  (ex < 0) {
                    ifBLIN_QW0("table in 0 STYLE");
                    ex = -EX_IOERR;
                    goto out;
                }
                ll += ex;
    }   }   }
out:
    ifBLIN_QX3("- %d %d", ex, ll);
    return((ex < 0) ? ex : ll);
#   undef blin_internal_flags
}

pgoblin_styles pgoblin_style_0 =
{ 0
, "5pGoblin-" VERS
, "0\0" VERS
, 0
, init
, fini
, parser
, dump
, clear
, get
, table
, NULL /* load   */
, NULL /* store  */
, NULL /* dummy0 */
, NULL /* dummy1 */
};
