/*-
 * Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: pgoblin.h,v 1.193 2022/01/23 18:06:14 babolo Exp $
 */

#ifndef _PGOBLIN_H_
#define _PGOBLIN_H_

__BEGIN_DECLS

# ifndef PGOBLIN_COMPAT
#  warning PGOBLIN_COMPAT not defined
# endif

# define PGOBLIN_REGSIZE   64
# define PGOBLIN_SOSIZE    16
# define PGOBLIN_DBTABLESZ 256
# define PGOBLIN_STYLETBSZ 256
# define PGOBLIN_JOBTABSIZ 256
# define PGOBLIN_MIFEFLAGS MIFE_FULL
# define PGOBLIN_SSIZE_MIN ((ssize_t)(1ULL << (sizeof(ssize_t) * 8 - 1)))

# ifdef PGOBLIN_MODULE
   struct pgoblin_realpq;
   typedef struct pgoblin_realpq pgoblin_realpq;
   struct pgoblin_realsty;
   typedef struct pgoblin_realsty pgoblin_realsty;
# else
   typedef BLIN_flag pgoblin_realpq;   /* (BLIN_flag*)pgoblin_realpq*     */
   typedef BLIN_flag pgoblin_realsty;
# endif
  typedef u_int8_t pgoblin_nr;

/****************************************************************************************/
/* For pgoblin_rio.flags                                                                */
/* + used                                                                               */
/* # used and stay from cycle to cycle                                                  */
/* : write only (with something else)                                                   */
/* - no room for                                                                        */
# define  PGOBLIN_EMPTY     0x000000
/*             For         pgoblin_syntax.ch[]  pgoblin_syntax.a[].flags                */
/*                                          \    /                                      */
/*               pgoblin_rio.flags ------\   |  |   /------ pgoblin_exenv.flags         */
/*                                        |  |  |  |                                    */
# define  PGOBLIN_PATHPARM  0x000001  /*  +  +     :  * Pf                              */
# define  PGOBLIN_ISIN      0x000001  /*        +     * IN used                         */
# define  PGOBLIN_TEXTPARM  0x000002  /*  +  +     :  * Pt                              */
# define  PGOBLIN_MIFEDES   0x000004  /*  +  +     :  * Pm                              */
# define  PGOBLIN_CTL       0x000004  /*        +     * CTL used                        */
# define  PGOBLIN_PQRESULT  0x000008  /*  +  +     :  * Pq                              */
# define  PGOBLIN_OUTSET    0x000010  /*  +  +  +  -  * Po, OUT used                    */
# define  PGOBLIN_BINPARM   0x000020  /*  +           * Pt is binary                    */
# define  PGOBLIN_CONNECT   0x000020  /*     +  +     * CONN used                       */
# define  PGOBLIN_FORKOUT   0x000020  /*           +  * fork for OUT                    */
# define  PGOBLIN_JOB       0x000040  /*     +  +     * JOB used                        */
# define  PGOBLIN_FORKIN    0x000040  /*           +  * fork for IN                     */
# define  PGOBLIN_STYLE     0x000080  /*     +  +     * STYLE used                      */
# define  PGOBLIN_FORKCTL   0x000080  /*           +  * fork for CTL                    */
# define  PGOBLIN_ANYIVL    (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_MIFEDES | PGOBLIN_PQRESULT)
/**** First byte ends ****/
# define  PGOBLIN_EXTENDED  0x000100  /*     -  +     * extended command                */
# define  PGOBLIN_FORKED    0x000800  /*     -  +  #  *                                 */
# define  PGOBLIN_STYLEN    0x003000  /*     -  +     * phys addr of R_STYLE            */
# define  PGOBLIN_TRAPDEF   0x001000  /*     -     #  *                                 */
# define  PGOBLIN_ROLLBACK  0x002000  /*     -     #  *                                 */
# define  PGOBLIN_END       0x004000  /*     -     #  *                                 */
# define  PGOBLIN_ERROR     0x008000  /*     -     #  *                                 */
# define  PGOBLIN_EXTABLE   0x00FF00  /*     -     #  *                                 */
/**** Second byte ends ****/
# define  PGOBLIN_FREEPATH  0x010000  /*  +  -     +  * free() Pf after using           */
# define  PGOBLIN_FREETEXT  0x020000  /*  +  -     +  * free() Pt after using           */
# define  PGOBLIN_FREEMIFE  0x040000  /*  +  -        * free() Pm after using           */
# define  PGOBLIN_FREEPQRE  0x080000  /*  +  -     +  * free() Pq after using           */
# define  PGOBLIN_CTLCORTG  0x080000  /*     -  +     *  cortege  CTL fork */
# define  PGOBLIN_FREEOUTS  0x100000  /*  +  -        * free() Po after using           */
# define  PGOBLIN_LEXLVUP   0x100000  /*     -  +     *                                 */
# define  PGOBLIN_FILEOVER  0x200000  /*  +  -        *                                 */
# define  PGOBLIN_LEXLDOWN  0x200000  /*     -  +     *                                 */
# define  PGOBLIN_OPEN      0x200000  /*     -     +  *                                 */
# define  PGOBLIN_NOLITER   0x400000  /*     -  +     *                                 */
# define  PGOBLIN_CHILD     0x400000  /*     -     +  *                                 */
# define  PGOBLIN_IGNORE    0x800000  /*     -  +  +  *                                 */
# define  PGOBLIN_ILLEGAL   (PGOBLIN_IGNORE | PGOBLIN_NOLITER)
/**** Third byte ends ****/

/***************************/
/* pgoblin's command codes */
/***************************/

  typedef enum pgoblin_command
  { PGOBLIN_extended   = 0x00
  , PGOBLIN_null       = 0x01
  , PGOBLIN_cont       = 0x02
  , PGOBLIN_bang       = 0x03

  , PGOBLIN_connect    = 0x10
  , PGOBLIN_listen     = 0x11
  , PGOBLIN_exec       = 0x12
  , PGOBLIN_trap       = 0x13
  , PGOBLIN_call       = 0x14
  , PGOBLIN_eval       = 0x15
  , PGOBLIN_style      = 0x16
  , PGOBLIN_job        = 0x17
  , PGOBLIN_echo       = 0x18
  , PGOBLIN_file       = 0x19
  , PGOBLIN_cat        = 0x1A
  , PGOBLIN_exit       = 0x1B

  , PGOBLIN_perform    = 0x20
  , PGOBLIN_binpresel  = 0x21
  , PGOBLIN_select     = 0x22
  , PGOBLIN_binselect  = 0x23
  , PGOBLIN_strselect  = 0x24

  , PGOBLIN_copyin     = 0x28
  , PGOBLIN_copyout    = 0x29
  , PGOBLIN_getstr     = 0x2A
  , PGOBLIN_getdir     = 0x2B
  , PGOBLIN_getcsv     = 0x2C
  , PGOBLIN_getopt     = 0x2D
  , PGOBLIN_getarg     = 0x2E

  , PGOBLIN_begin      = 0x30
  , PGOBLIN_end        = 0x31
  , PGOBLIN_rollback   = 0x32

/*, PGOBLIN_begin   = PGOBLIN_EXTENDED | 0x00 */
/*, PGOBLIN_end     = PGOBLIN_EXTENDED | 0x01 */
  , PGOBLIN_fork    = PGOBLIN_EXTENDED | 0x02
  , PGOBLIN_wait    = PGOBLIN_EXTENDED | 0x03

  , PGOBLIN_return  = PGOBLIN_EXTENDED | 0x05
  , PGOBLIN_display = PGOBLIN_EXTENDED | 0x06
  , PGOBLIN_pipe    = PGOBLIN_EXTENDED | 0x07
  , PGOBLIN_close   = PGOBLIN_EXTENDED | 0x08
  , PGOBLIN_clear   = PGOBLIN_EXTENDED | 0x09
  , PGOBLIN_untrap  = PGOBLIN_EXTENDED | 0x0A

/*, PGOBLIN_getarg  = PGOBLIN_EXTENDED | 0x10 */
  , PGOBLIN_getenv  = PGOBLIN_EXTENDED | 0x11
  , PGOBLIN_getget  = PGOBLIN_EXTENDED | 0x12
  , PGOBLIN_getpost = PGOBLIN_EXTENDED | 0x13
  , PGOBLIN_getproc = PGOBLIN_EXTENDED | 0x14
  , PGOBLIN_getjob  = PGOBLIN_EXTENDED | 0x15
  , PGOBLIN_getspq  = PGOBLIN_EXTENDED | 0x16
  , PGOBLIN_getmeta = PGOBLIN_EXTENDED | 0x17
  , PGOBLIN_info    = PGOBLIN_EXTENDED | 0x18
  , PGOBLIN_max     = PGOBLIN_EXTENDED | 0x19
  } pgoblin_command;

  typedef u_int32_t pgoblin_cmd;
# define PGOBLIN_COMMAND 0x000000FF
# define PGOBLIN_ARG1    0x00003F00
# define PGOBLIN_ARG2    0x000FC000
# define PGOBLIN_ARG3    0x03F00000
# define PGOBLIN_ARG4    0xFC000000
# define PGOBLIN_ARGMASK 0x0000003F
# define PGOBLIN_BPARG   6           /* Bits per argument */
# define PGOBLIN_ARG1S   8           /* 1st arg shift     */
# define PGOBLIN_ARG2S   14          /* 2nd arg shift     */
# define PGOBLIN_ARG3S   20          /* 3rd arg shift     */
# define PGOBLIN_ARG4S   26          /* 4th arg shift     */

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_prog                                                    *
 *                                                                                                   *
 *****************************************************************************************************/
  typedef struct pgoblin_tuple {
      u_int32_t   linum;
      pgoblin_cmd cmd;                         /*                                             */
      union {
          char       *lit;                     /*                            */
          ssize_t     sts;                     /*                         */
          pgoblin_cmd ecmd;                    /*                                  */
      };
  } pgoblin_tuple;

  typedef struct pgoblin_prog {
#     define        PGOBLIN_STRING_ID_LEN 16
#     define        PGOBLIN_STRING_ID_TST 11       /*  "#pGoblin-"VERS  ,  .   */
      char              id[PGOBLIN_STRING_ID_LEN]; /*  "#pGoblin"     ASCII       */
      BLIN_flag         flags;
      void             *debug;                     /*   -                  */
# ifdef _MULTILAR_H_
      mular_descriptor *code;                      /*                                 */
# else
      void            *code;                       /* For compatibility with pgoblin-3               */
# endif
  } pgoblin_prog;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_rio                                                     *
 *                                                                                                   *
 *****************************************************************************************************/
  typedef struct pgoblin_rio pgoblin_rio;
  struct pgoblin_rio {
      BLIN_flag         flags;
      pid_t             pid;                         /* ,    mife      */
      pgoblin_rio      *prev;
      void             *text;
      char             *path;
      size_t            length;                      /*   text                             */
      mife_descriptor  *mife;
# ifdef _MULTILAR_H_
      mular_descriptor *stymd;                       /*                                   */
# else
      void             *stymd;                       /* For compatibility with pgoblin-3             */
# endif
      pgoblin_realpq   *pq;
      int             (*wri)(int onu, const void *buf, size_t size);
      int             (*clo)(int onu);
      int               onu;
      int               cortege;                     /*       */
  };

  struct pgoblin_main;
  typedef struct pgoblin_main pgoblin_main;
  struct pgoblin_exenv;
  typedef struct pgoblin_exenv pgoblin_exenv;
  typedef struct pgoblin_longnotify {
      u_int32_t   majorlen : 8
              ,   minorlen : 8
              ,   anothlen : 8
              ,   flags    : 8
      ;
      u_int32_t   ident;
      char        tail[0];
  } pgoblin_longnotify;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_rdb                                                     *
 *                                                                                                   *
 *****************************************************************************************************/
  typedef struct pgoblin_rdb pgoblin_rdb;
  struct pgoblin_rdb {
      BLIN_flag    flags;
#     define           PGOBLIN_DB_TYPE      0x0000FF
#     define           PGOBLIN_CR_OK        0x000000 /* Query without result                         */
#     define           PGOBLIN_CR_TUPL      0x000100 /* Query with result                            */
#     define           PGOBLIN_CR_OUT       0x000200 /* COPY out                                     */
#     define           PGOBLIN_CR_IN        0x000300 /* COPY in                                      */
#     define           PGOBLIN_CR_SSEL      0x000400 /* Text stream query                            */
#     define           PGOBLIN_CR_BSEL      0x000500 /* Binary stream query                          */
#     define           PGOBLIN_CR_BTUPL     0x000600 /* Binary query with result                     */
#     define           PGOBLIN_CR_MAX       0x000700 /* Query type number limit                      */
#     define           PGOBLIN_CR_MASK      0x000F00 /* Query type mask                              */
#     define           PGOBLIN_ALTERV       0x001000 /* For internal DB modules use                  */
#     define           PGOBLIN_ALTERQ       0x002000 /* For internal DB modules use                  */
#     define           PGOBLIN_ACR_MASK     0x003F00 /* All query descriptor mask                    */
#     define           PGOBLIN_CR_SHIFT     8        /* Shift of query type                          */
#     define           PGOBLIN_LONGTARRY    0x008000 /* Long tarry result                            */
#     define           PGOBLIN_INT64TIME    0x010000 /* DB known to have int64 timestamp             */
#     define           PGOBLIN_FLOATTIME    0x020000 /* DB known to have float timestamp             */
#     define           PGOBLIN_NEEDINTIME   0x040000 /* Ask DB for timestamp format                  */
#     define           PGOBLIN_CLOSECONN    0x080000 /* Close this connection on exit                */
#     define           PGOBLIN_PARMIN       0x100000 /* Parms in dbname                              */
#     define           PGOBLIN_PARMDBFREE   0x200000 /* Free DB parms when pgoblin_rdb destoyed      */
/*    define           PGOBLIN_ERROR_SENSOR 0x400000    Eror reaction                                */
/*    define           PGOBLIN_ERROR_SENSIB 0x800000    Immediate error reaction                     */
/*                     BLINflag                         copied from pgoblin_main                     */
      u_char       intran;   /* Transaction level */
      char         dummy0;
      u_int16_t    dummy1;
      pgoblin_rdb *prev;
      const char  *dbname;   /* For libpq         */
      const char  *host;     /* For libpq         */
      const char  *port;     /* For libpq         */
      const char  *username; /* For libpq         */
      void        *conn;
      const char  *password;
      const char  *libexec;
      void        *dummy2;
      void        *dummy3;
  };

  typedef struct pgoblin_dbases {
      BLIN_flag     flags;
#     define        PGOBLIN_DB_PREPARE  0x800000
#     define        PGOBLIN_DB_COPYIN   0x400000
#     define        PGOBLIN_DB_COPYOUT  0x200000
#     define        PGOBLIN_LONGNOTIFY  0x100000     /* Long tarry result                            */
/*                  BLINflag                            copied from pgoblin_main                     */
      char          id        [PGOBLIN_STRING_ID_LEN];
      char          name      [PGOBLIN_STRING_ID_LEN];
      int           dummy;
      int         (*init)     (pgoblin_main *options, int slot);
      int         (*fini)     (pgoblin_main *options);
      int         (*shurecon) (pgoblin_exenv *exenv, pgoblin_nr ndb);
      int         (*query)    (pgoblin_exenv *exenv, pgoblin_nr ndb, pgoblin_nr nou, pgoblin_nr nct);
      int         (*prepare)  (pgoblin_exenv *exenv, pgoblin_nr ndb, pgoblin_nr nou, pgoblin_nr nct);
      int         (*execute)  ( pgoblin_exenv *exenv
                              , pgoblin_nr     ndb
                              , pgoblin_nr     nou
                              , pgoblin_nr     nct
                              , pgoblin_nr     nin
                              );
      int64_t     (*resinfo)  (pgoblin_exenv *exenv, pgoblin_nr nio, int kind);
      const char *(*subinfo)  (pgoblin_exenv *exenv, pgoblin_nr nio, int kind, int64_t sub);
      char       *(*erinfo)   (pgoblin_exenv *exenv, pgoblin_nr nio);
      ssize_t     (*valinfo)  (pgoblin_exenv *exenv, pgoblin_nr nio, int kind, int row, int col);
      char       *(*getvalue) (pgoblin_exenv *exenv, pgoblin_nr nio, int row, int col);
      int         (*getstream)(pgoblin_exenv *exenv, pgoblin_nr ndb, pgoblin_nr nou, int quant);
      int         (*getcopy)  (pgoblin_exenv *exenv, pgoblin_nr ndb, void **buf);
      int         (*putcopy)  (pgoblin_exenv *exenv, pgoblin_nr ndb, const void *buf, int len);
      int         (*endstream)(pgoblin_exenv *exenv, pgoblin_nr ndb);
      int         (*tarry)    (pgoblin_exenv *exenv, pgoblin_nr ndb, int timeout);
      void       *(*notifies) (pgoblin_exenv *exenv, pgoblin_nr ndb);
      int         (*finish)   (pgoblin_exenv *exenv, pgoblin_nr ndb);
      int         (*clear)    (pgoblin_exenv *exenv, pgoblin_nr nio);
      char       *(*erconn)   (pgoblin_exenv *exenv, pgoblin_nr ndb);
      int         (*prexec)   ( pgoblin_exenv *exenv
                              , pgoblin_nr     ndb
                              , pgoblin_nr     nou
                              , pgoblin_nr     nio
                              , pgoblin_nr     nin
                              );
      int         (*denote)   (pgoblin_exenv *exenv, pgoblin_nr ndb, void **note);
      void         *dummy1;
      void         *dummy2;
  } pgoblin_dbases;

  int         pgoblin_db_shurecon  __P((pgoblin_exenv *exenv, pgoblin_nr ndb));
  int         pgoblin_db_query     __P(( pgoblin_exenv *exenv
                                       , pgoblin_nr     ndb
                                       , pgoblin_nr     nou
                                       , pgoblin_nr     nct
                                      ));
  int         pgoblin_db_prepare   __P(( pgoblin_exenv *exenv
                                       , pgoblin_nr     ndb
                                       , pgoblin_nr     nio
                                       , pgoblin_nr     nct
                                      ));
  int         pgoblin_db_execute   __P(( pgoblin_exenv *exenv
                                       , pgoblin_nr     ndb
                                       , pgoblin_nr     nou
                                       , pgoblin_nr     nct
                                       , pgoblin_nr     nin
                                      ));
  int64_t     pgoblin_db_resinfo   __P((pgoblin_exenv *exenv, pgoblin_nr nio, int kind));
  const char *pgoblin_db_subinfo   __P((pgoblin_exenv *exenv, pgoblin_nr nio, int kind, int64_t sub));
  char       *pgoblin_db_erinfo    __P((pgoblin_exenv *exenv, pgoblin_nr nio));
  ssize_t     pgoblin_db_valinfo   __P(( pgoblin_exenv *exenv
                                       , pgoblin_nr     nio
                                       , int            kind
                                       , int            row
                                       , int            col
                                      ));
  char       *pgoblin_db_getvalue  __P((pgoblin_exenv *exenv, pgoblin_nr nio, int row, int col));
  int         pgoblin_db_getstream __P(( pgoblin_exenv *exenv
                                       , pgoblin_nr     ndb
                                       , pgoblin_nr     nou
                                       , int            quant
                                      ));
  int         pgoblin_db_getcopy   __P((pgoblin_exenv *exenv, pgoblin_nr ndb, void **buf));
  int         pgoblin_db_putcopy   __P(( pgoblin_exenv *exenv
                                       , pgoblin_nr     ndb
                                       , const void    *buf
                                       , int            len
                                      ));
  int         pgoblin_db_endstream __P((pgoblin_exenv *exenv, pgoblin_nr ndb));
  int         pgoblin_db_tarry     __P((pgoblin_exenv *exenv, pgoblin_nr ndb, int timeout));
  void       *pgoblin_db_notifies  __P((pgoblin_exenv *exenv, pgoblin_nr ndb));
  int         pgoblin_db_finish    __P((pgoblin_exenv *exenv, pgoblin_nr ndb));
  int         pgoblin_db_clear     __P((pgoblin_exenv *exenv, pgoblin_nr ndb));
  char       *pgoblin_db_erconn    __P((pgoblin_exenv *exenv, pgoblin_nr ndb));
  int         pgoblin_db_prexec    __P(( pgoblin_exenv *exenv
                                       , pgoblin_nr     ndb
                                       , pgoblin_nr     nou
                                       , pgoblin_nr     nio
                                       , pgoblin_nr     nin
                                      ));
  int         pgoblin_db_denote    __P((pgoblin_exenv *exenv, pgoblin_nr ndb, void **note));

/*****************************************************************************************************
 *                                                                                                   *
 *                                  pgoblin_rjb                                                      *
 *                                                                                                   *
 *****************************************************************************************************/

  typedef struct pgoblin_rjb pgoblin_rjb;
  struct pgoblin_rjb {
      BLIN_flag        flags;
#     define           PGOBLIN_JOB_TYPE     0x0000FF
#     define           PGOBLIN_INITED       0x040000      /* initialisedsed                          */
#     define           PGOBLIN_KQUEUED      0x080000      /* kq created and used                     */
#     define           PGOBLIN_HOSTJFREE    0x200000      /* Free job host when pgoblin_rjb destoyed */
#     define           PGOBLIN_ERROR_SENSOR 0x400000      /* Eror reaction                           */
#     define           PGOBLIN_ERROR_SENSIB (PGOBLIN_ERROR_SENSOR << 1) /* Immediate error reaction  */
/*                     BLINflag                         copied from pgoblin_main                     */
      int              kq;
      pgoblin_rjb  *prev;
# ifdef _MULTILAR_H_
      mular_descriptor*pids;                         /* Child processes register set                 */
# else
      void            *pids;                         /* For compatibility with pgoblin-3             */
# endif
      char            *host;
      u_int32_t        concur;
      u_int32_t        dead;
  };

  typedef struct pgoblin_jobl {
      ssize_t          cmdn;
      pid_t            pid;
      int              status;
#     define           PGOBLIN_NOSTATUS (-1)
#     define           PGOBLIN_LOSTSTAT 0x00010000
  } pgoblin_jobl;

  typedef struct pgoblin_dir {
      void        *dirp;
      int          i; /*   ,                           */
      int          f; /*                     */
      int          g; /* 1 -  ; 0 -                                    */
      char        *ent;
      struct stat *sb;
  } pgoblin_dir;

  struct pgoblin_jobs;
  typedef struct pgoblin_jobs pgoblin_jobs;

  struct pgoblin_jobs {
      BLIN_flag      flags;
/*                   BLINflag                           copied from pgoblin_main                     */
      char           id   [PGOBLIN_STRING_ID_LEN];
      char           name [PGOBLIN_STRING_ID_LEN];
      int            dummy;
      int          (*init)(pgoblin_main *options, int slot);
      int          (*fini)(pgoblin_main *options);
      int          (*jpen)(pgoblin_exenv *exenv, pgoblin_nr *rn, void *opt);
      u_int32_t    (*jest)(pgoblin_exenv *exenv, pgoblin_command cmd);
#     define    PGOBLIN_TOFORK    0x000800  /*              */
#     define    PGOBLIN_TVFORK    0x000400  /*    exec */
#     define    PGOBLIN_TOEXIT    0x000200  /*      */
      int          (*jork)(pgoblin_exenv *exenv, pgoblin_nr *rn);
      int          (*jxec)(pgoblin_exenv *exenv, pgoblin_nr *rn, char **argv);
      int          (*jait)(pgoblin_exenv *exenv, pgoblin_nr *rn);
      int          (*jose)(pgoblin_exenv *exenv, pgoblin_nr *rn);
      pgoblin_dir *(*jdir)(pgoblin_exenv *exenv, pgoblin_dir *dir, char *path);
      void          *dummy0;
      void          *dummy1;
  };

/*****************************************************************************************************
 *                                                                                                   *
 *                                  pgoblin_rst                                                      *
 *                                                                                                   *
 *****************************************************************************************************/

  typedef struct pgoblin_rst pgoblin_rst;
  struct pgoblin_rst {
      u_int32_t        flags;
#     define       PGOBLIN_STYLE_TYPE   0x0000FF
/*                 BLINflag                             copied from pgoblin_main                     */
      int              dummy;
      pgoblin_rst     *prev;
      char            *path;
      pgoblin_realsty *style;
  };

  struct pgoblin_styles;
  typedef struct pgoblin_styles pgoblin_styles;

  struct pgoblin_styles {
      BLIN_flag    flags;
/*                 BLINflag                             copied from pgoblin_main                     */
      char         id     [PGOBLIN_STRING_ID_LEN];
      char         name   [PGOBLIN_STRING_ID_LEN];
      int          dummy;
      int        (*init)  (pgoblin_main *options, int slot);
      int        (*fini)  (pgoblin_main *options);
      int        (*parser)(pgoblin_exenv *exenv, pgoblin_nr nst, char *srcstyle);
      void       (*dump)  (pgoblin_exenv *exenv, pgoblin_nr nst);
      int        (*clear) (pgoblin_exenv *exenv, pgoblin_nr nst);
      char      *(*get)   (pgoblin_exenv *exenv, pgoblin_nr nst, pgoblin_nr nct);
      ssize_t    (*table) ( pgoblin_exenv *exenv
                          , pgoblin_nr nst
                          , pgoblin_nr nou
                          , pgoblin_nr nin
                          , ssize_t    low
                          , ssize_t    hig
                          );
      int        (*load)  (pgoblin_exenv *exenv, pgoblin_nr nst, pgoblin_nr nin);
      int        (*store) (pgoblin_exenv *exenv, pgoblin_nr nst, pgoblin_nr nou);
      void        *dummy0;
      void        *dummy1;
  };

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_main                                                    *
 *                                                                                                   *
 *****************************************************************************************************/
  struct pgoblin_main {
      BLIN_flag         flags;
#     define                PGOBLIN_FORK_WAIT    0x0000FF /* Child waits after fork                  */
#     define                PGOBLIN_VERIFY       0x000100 /* Verify analizer and dump parsed program */
#     define                PGOBLIN_COPEND_PASS  0x000200 /* Pass through unconsumed end of file     */
#     define                PGOBLIN_COPEND_APND  0x000400 /* Append EOF marker to COPY out file      */
#     define                PGOBLIN_COPEND_NOGEN 0x000800 /* Not append EOF marker to #get***        */
#     define                PGOBLIN_T_REGO       0x001000 /* Trace GO-WENT                           */
#     define                PGOBLIN_T_COMAND     0x002000 /* Comand trace                            */
#     define                PGOBLIN_T_EXECUTE    0x004000 /* Execute trace                           */
#     define                PGOBLIN_T_MODULES    0x008000 /* Modules trace                           */
#     define                PGOBLIN_CLEAR_ONEXIT 0x010000 /* clear registers on exit                 */
#     define                PGOBLIN_T_NAMES      0x020000 /* File names trace                        */
#     define                PGOBLIN_DEFAULDB     0x040000 /* 0 reg DBMS to any on clear              */
#     define                PGOBLIN_T_ONLY       0x100000 /* Ordered classes only                    */
/*    define                PGOBLIN_ERROR_SENSOR 0x400000    Eror reaction                           */
/*    define                PGOBLIN_ERROR_SENSIB 0x800000    Immediate error reaction                */
      char              vers[4];                     /* Version                                      */
      u_char            delim[4];                    /* Delimiter                                    */
      u_int32_t         maxtmout;                    /* Max timeout for LISTEN                       */
      size_t            dummys;
      size_t            dummya;
      mular_descriptor *deargs;                      /* File names array                             */
      pgoblin_rio      *io   [PGOBLIN_REGSIZE];      /* I/O register set                             */
      pgoblin_rdb      *conn [PGOBLIN_REGSIZE];      /* Connections register set                     */
      pgoblin_rjb      *job  [PGOBLIN_REGSIZE];
      pgoblin_rst      *style[PGOBLIN_REGSIZE];      /* Styles register set                          */
      u_int64_t         useio;
      u_int64_t         usecon;
      u_int64_t         usejob;
      u_int64_t         usesty;
      u_int64_t         demaskf;
      u_int64_t         demaskt;
      u_int64_t         demaskm;
      u_int64_t         demaskq;
      u_int64_t         demasko;
      u_int64_t         demaskc;
      u_int64_t         demaskj;
      u_int64_t         demasks;
      char            **argv;
      char            **envp;
      const char       *ftrace;
      int               xtrace;
      int               pip0[2];
      int               pip1[2];
      int               pip2[2];
      const char       *libexec[PGOBLIN_SOSIZE];
      babolo_opts      *bos;
      void             *dummy1;
  };

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_exenv                                                   *
 *                                                                                                   *
 *****************************************************************************************************/
  struct pgoblin_exenv {
      BLIN_flag        flags;
      pgoblin_main    *options;                      /* Interpretator's data state                   */
      pgoblin_exenv   *stat;                         /* Parent in static call chain                  */
      pgoblin_exenv   *dyna;                         /* Parent in dynamic call chain                 */
      pgoblin_exenv   *next;                         /* Child in dynamic call chain                  */
      pgoblin_prog    *pgm;                          /* Programm                                     */
      int              ppoint;                       /* Programm counter                             */
      int              ctrap;                        /*    trap                    */
      int              lexlevel;                     /* To skip nested blocks                        */
      int              dummy;
  };

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_syntax                                                  *
 *                                                                                                   *
 *****************************************************************************************************/

  typedef enum pgoblin_cmdres
  { PGOBLIN_Ntuples =  7 /* resinfo         */
  , PGOBLIN_Nfields =  8 /* resinfo         */
  , PGOBLIN_IsNull  =  9 /*     valinfo     */
  , PGOBLIN_Length  = 10 /*     valinfo     */
  , PGOBLIN_BinForm = 11 /*     valinfo     */
  , PGOBLIN_TypeOid = 12 /*     valinfo     */
  , PGOBLIN_TypeNm  = 13 /*         subinfo */
  , PGOBLIN_TypeMod = 14 /*     valinfo     */
  , PGOBLIN_Nchange = 15 /* resinfo         */
  , PGOBLIN_LastOid = 16 /* resinfo         */
  , PGOBLIN_ColName = 17 /*         subinfo */
  , PGOBLIN_CmdStat = 18 /*         subinfo */
  , PGOBLIN_ColSize = 23 /*     valinfo     */
  } pgoblin_cmdres;

  typedef struct pgoblin_syntax {
      int16_t             dbtablesz;
      int16_t             jobtabsiz;
      int16_t             styletbsz;
      int16_t             symparam;
#     define PGOBLIN_SYMREGS 6
      int16_t             binparam;
#     define PGOBLIN_BINREGS 4
      int16_t             regsize;
      u_int16_t           max;
      pgoblin_dbases    **dbasetable;
      pgoblin_jobs      **jobtable;
      pgoblin_styles    **styletable;
      const babolo_lexor *cmds;
      const babolo_lexor *sqlkeywords;
      int8_t              binparams[PGOBLIN_BINREGS];
      struct {
          u_int8_t            sym;
          u_int8_t            val;
          int8_t              bin;
          u_int8_t            mask;
          char               *name;
      }                   p[PGOBLIN_SYMREGS];
      struct pgoblin_syntax_a {
          u_int32_t           flags;
          u_int8_t            ch[PGOBLIN_BINREGS];
          int               (*car)(pgoblin_exenv *exenv, pgoblin_nr *nr);
          char               *str;
      }                   a[PGOBLIN_max];
  } pgoblin_syntax;

  extern const pgoblin_syntax pgoblin;
  extern const char           pgoblin_regn[PGOBLIN_REGSIZE];
  extern pgoblin_main        *pgoblin_options;

  const char *pgoblin_decond __P((BLIN_flag cond));
  pgoblin_main *pgoblin_init __P((BLIN_flag flags, int outfd));
  int           pgoblin_load __P((pgoblin_main *options, int mode, const char *nm, int rs));
  int           pgoblin_breg __P((pgoblin_command cmd, pgoblin_nr rn));
  int         pgoblin_parser __P((pgoblin_main   *options
                                 , u_char        *text
                                 , ssize_t        len
                                 , pgoblin_prog **ppgm
                                 , u_int32_t      lfcount
                                 , const char    *finam
                                ));
  void      pgoblin_markconn __P((pgoblin_rdb *db));
  int          pgoblin_ctonr __P((char c));
  void        pgoblin_VVdump __P(());
  void         pgoblin_Vdump __P((pgoblin_main *options, pgoblin_prog *pgm));
  void        pgoblin_verify __P((pgoblin_main *options));
  void          pgoblin_fini __P((pgoblin_main *options));
  int        pgoblin_traceat __P((pgoblin_main *options, const char *tracefile, const char *Tflag));
  int        pgoblin_execute __P(( pgoblin_main  *options
                                 , pgoblin_prog  *pgm
                                 , pgoblin_exenv *dexenv
                                 , pgoblin_exenv *sexenv
                                 , ssize_t        pp
                                ));
/*****************************************************************************************************/
/*****************************************************************************************************/
/********                                                                                     ********/
/********                                            ********/
/********                                                                                     ********/
/*****************************************************************************************************/
/*****************************************************************************************************/
# ifdef PGOBLIN_INTERNAL

#  ifndef EDOOFUS
#   define EDOOFUS EINVAL
#  endif

#  define PGOBLIN_GOSHORT  5
#  define PGOBLIN_GOCMD    (PGOBLIN_GOSHORT + pgoblin.binparam)
#  define PGOBLIN_GOEXECU  (sizeof(int16_t) * 2 + sizeof(int32_t) + PGOBLIN_GOCMD)
#  define PGOBLIN_HEDLN    2
#  define PGOBLIN_PIDLN    3

#  define DBASE(N)         (pgoblin.dbasetable[(N) & PGOBLIN_DB_TYPE])
#  define JOBE(N)          (pgoblin.jobtable[(N) & PGOBLIN_JOB_TYPE])
#  define STYLS(N)         (pgoblin.styletable[(N) & PGOBLIN_STYLE_TYPE])
#  define ERROUT(A,B)      do {errno = (B); ex = (A); goto out;} while(0)
#  define BLIN_5STA24G     ((blin_statectl){{5, 1, 8, 24, ' ', 5, 1, 0, 0}})
#  define BLIN_5STO24G     ((blin_statectl){{5, 1, 8, 24, ' ', 5, 1, 1, 0}})

/*    */
#  define PGO_COUT    0
#  define PGO_CCTL    1
#  define PGO_CIN     2
#  define PGO_CCON    3
#  define PGO_CJOB    4
#  define PGO_CSTY    5

#  define RNOUT       (!ch[PGO_COUT] ? 0 : rn[PGO_COUT])
#  define RNCTL       (!ch[PGO_CCTL] ? 0 : rn[PGO_CCTL])
#  define RNIN        (!ch[PGO_CIN]  ? 0 : rn[PGO_CIN])
#  define RNCON       (!ch[PGO_CCON] ? 0 : rn[PGO_CCON])
#  define RNJOB       (!ch[PGO_CJOB] ? 0 : rn[PGO_CJOB])
#  define RNSTY       (!ch[PGO_CSTY] ? 0 : rn[PGO_CSTY])
#  define IO_RG0      (options->io[0])
#  define R_STY0      (options->style[0])
#  define IO_OUT      (rset[PGO_COUT].io)
#  define IO_CTL      (rset[PGO_CCTL].io)
#  define IO_IN       (rset[PGO_CIN].io)
#  define R_CONN      (rset[PGO_CCON].c)
#  define R_JOB       (rset[PGO_CJOB].j)
#  define R_STYLE     (rset[PGO_CSTY].s)

#  define PGOBLIN_BUFSIZE   (size_t)8192
#  define PGOBLIN_BUFMULT   2
#  define PGOBLIN_RAWIOBUFL 1

#  define UNRESERVED_KEYWORD     1 /* U */
#  define COL_NAME_KEYWORD       2 /* C */
#  define TYPE_FUNC_NAME_KEYWORD 3 /* T */
#  define RESERVED_KEYWORD       4 /* R */

#  define   MARK_IO_PATH_GO(r) pgoblin_go((r), PGOBLIN_PATHPARM, __FILE__, __func__, __LINE__)
#  define MARK_IO_PATH_WENT(r)
#  define   MARK_IO_TEXT_GO(r) pgoblin_go((r), PGOBLIN_TEXTPARM, __FILE__, __func__, __LINE__)
#  define MARK_IO_TEXT_WENT(r)
#  define   MARK_IO_MIFE_GO(r) pgoblin_go((r), PGOBLIN_MIFEDES , __FILE__, __func__, __LINE__)
#  define MARK_IO_MIFE_WENT(r)
#  define     MARK_IO_PQ_GO(r) pgoblin_go((r), PGOBLIN_PQRESULT, __FILE__, __func__, __LINE__)
#  define   MARK_IO_PQ_WENT(r)
#  define    MARK_IO_OUT_GO(r) pgoblin_go((r), PGOBLIN_OUTSET  , __FILE__, __func__, __LINE__)
#  define  MARK_IO_OUT_WENT(r)
#  define    MARK_R_CONN_GO(r) pgoblin_go((r), PGOBLIN_CONNECT , __FILE__, __func__, __LINE__)
#  define  MARK_R_CONN_WENT(r)
#  define     MARK_R_JOB_GO(r) pgoblin_go((r), PGOBLIN_JOB     , __FILE__, __func__, __LINE__)
#  define   MARK_R_JOB_WENT(r)
#  define   MARK_R_STYLE_GO(r) pgoblin_go((r), PGOBLIN_STYLE   , __FILE__, __func__, __LINE__)
#  define MARK_R_STYLE_WENT(r)

#  define GET_RIO(RIO, OPT, R) do {                                   \
       if  (!(RIO = pgoblin_meio(OPT, R))) {                          \
           ifBLIN_QW0("No IO reg %u", R);                             \
           goto out;                                                  \
       }                                                              \
   } while(0)
#  define GET_CON(CON, OPT, R) do {                                   \
       if  (!(CON = pgoblin_mecon(OPT, R))) {                         \
           ifBLIN_QW0("No CONN reg %u", R);                           \
           goto out;                                                  \
       }                                                              \
   } while(0)
#  define GET_JOB(JOB, OPT, R) do {                                   \
       if  (!(JOB = pgoblin_mejob(OPT, R))) {                         \
           ifBLIN_QW0("No JOB reg %u", R);                            \
           goto out;                                                  \
       }                                                              \
   } while(0)
#  define GET_STY(STY, OPT, R) do {                                   \
       if  (!(STY = pgoblin_mesty(OPT, R))) {                         \
           ifBLIN_QW0("No STYLE reg %u", R);                          \
           goto out;                                                  \
       }                                                              \
   } while(0)

   extern pgoblin_jobs       pgoblin_job_local;
   extern pgoblin_dbases     pgoblin_db_0;
   extern BLIN_flag          pgoblin_default;
   extern pgoblin_styles     pgoblin_style_0;
   extern const char * const pgoblin_syntaxa_flags[];

   int            pgoblin_cmdexe __P((int cmd, pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_listen __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int             pgoblin_begin __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int               pgoblin_end __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int           pgoblin_perform __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_echo __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_file __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int               pgoblin_cat __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_pipe __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int             pgoblin_close __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int             pgoblin_clear __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_exec __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_fork __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_wait __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_exit __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_trap __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_untrap __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_call __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_eval __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int             pgoblin_style __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int               pgoblin_job __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int           pgoblin_connect __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_return __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_copyin __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int           pgoblin_copyout __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_binsel __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_strsel __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_binpre __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_select __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int           pgoblin_display __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_getstr __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_getarg __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_getenv __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_getget __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int           pgoblin_getpost __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int           pgoblin_getproc __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_getjob __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_getspq __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_getdir __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_getopt __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_getcsv __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int           pgoblin_getmeta __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int              pgoblin_info __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   int            pgoblin_rollbk __P((pgoblin_exenv *exenv, pgoblin_nr *rn));
   void            pgoblin_toexe __P((int cmd, pgoblin_exenv *exenv, pgoblin_nr rn[pgoblin.symparam]));
   int            pgoblin_wident __P((pgoblin_main *options, int num, char *entry));
   pgoblin_rio     *pgoblin_upio __P((pgoblin_main *options, pgoblin_nr nio));
   pgoblin_rdb    *pgoblin_upcon __P((pgoblin_main *options, pgoblin_nr ndb));
   pgoblin_rjb    *pgoblin_upjob __P((pgoblin_main *options, pgoblin_nr njb));
   pgoblin_rst    *pgoblin_upsty __P((pgoblin_main *options, pgoblin_nr nst));
   pgoblin_rio     *pgoblin_meio __P((pgoblin_main *options, pgoblin_nr nio));
   pgoblin_rdb    *pgoblin_mecon __P((pgoblin_main *options, pgoblin_nr ndb));
   pgoblin_rjb    *pgoblin_mejob __P((pgoblin_main *options, pgoblin_nr njb));
   pgoblin_rst    *pgoblin_mesty __P((pgoblin_main *options, pgoblin_nr nst));
   pgoblin_rio   *pgoblin_pushio __P((pgoblin_main *options, pgoblin_nr nio));
   pgoblin_rdb  *pgoblin_pushcon __P((pgoblin_main *options, pgoblin_nr ndb));
   pgoblin_rjb  *pgoblin_pushjob __P((pgoblin_main *options, pgoblin_nr njb));
   pgoblin_rst  *pgoblin_pushsty __P((pgoblin_main *options, pgoblin_nr nst));
   int             pgoblin_popio __P((pgoblin_main *options, pgoblin_nr nio));
   int            pgoblin_popcon __P((pgoblin_main *options, pgoblin_nr ndb));
   int            pgoblin_popjob __P((pgoblin_main *options, pgoblin_nr njb));
   int            pgoblin_popsty __P((pgoblin_main *options, pgoblin_nr nst));
   ssize_t       pgoblin_onecopy __P((char *escaped, const char *in, ssize_t l, int end));
   int           pgoblin_onecsym __P((char in));
   pgoblin_realpq  *pgoblin_db00 __P((BLIN_flag flags));
   int        pgoblin_db0_create __P(( pgoblin_exenv      *exenv
                                     , pgoblin_nr          nou
                                     , int                 cnt
                                     , const char * const *val
                                     , const int          *len
                                    ));
   void               pgoblin_go __P(( pgoblin_nr  r
                                     , int         f
                                     , const char *file
                                     , const char *func
                                     , int         line
                                    ));


#  ifdef DEBUG
#   include <dmalloc.h>
//# include <memcheck.h>
#   define DMALLOC_FUNC_CHECK 1
#  endif

# endif /* PGOBLIN_INTERNAL */
__END_DECLS

#endif /* !_PGOBLIN_H_ */
