/*-
 * Copyright (C)2017..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2017..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: func.c,v 1.66 2022/01/07 13:57:49 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    4
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sysexits.h>
#include <strings.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

static int16_t          onecopy[16] = {-1, 0, 0, 0,  0, 0, 0, 0,  'b', 't', 'n', 'v',  'f', 'r', 0, 0};

int
pgoblin_onecsym(char in) {
    if  (16 > (in & 0x00FF)) return(onecopy[in & 0x00FF]);
    if  ('\\' == in) return('\\');
    return(0);
}

ssize_t
/*************************************************************************
 **    COPY  in,                                    **
 **  end NULL  ( end > 0)  -end - 1 ,             **
 **  end < 0, ,  end < 0,  \t,  end >= 0,           **
 **    .                                            **
 **  len < 0,  in   \0,                                **
 **   len   in.                                    **
 *************************************************************************
 **                                                                     **/
pgoblin_onecopy(char *escaped, const char *in, ssize_t len, int end) { /**
 **                                                                     **
 *************************************************************************/
    ssize_t ex = 0;
    int     c;

    if  (!in) {
        escaped[ex++]  = '\\';
        escaped[ex++]  = 'N';
    } else {
        for (int j = 0; (0 > len) ? in[j] : (0 < len--); ++j) {
            switch((c = pgoblin_onecsym(in[j]))) {
            case -1:
                errno = EINVAL;
                ex = -EX_USAGE;
                goto out;
            case 0:
                escaped[ex++] = in[j];
                break;
            default:
                escaped[ex++] = '\\';
                escaped[ex++] = c;
    }   }   }
    for (int c = (0 > end) ? ~end : end; c > 0; --c) {
        escaped[ex++] = '\t';
        escaped[ex++] = '\\';
        escaped[ex++] = 'N';
    }
    escaped[ex++] = (0 > end) ? '\t' : '\n';
out:
    return(ex);
}

int
/************************************************************************
 ************************************************************************
 **                                                                    **/
pgoblin_breg(pgoblin_command cmd, pgoblin_nr r) {                     /**
 **                                                                    **
 ************************************************************************
 **      cmd   r.      **
 **    cmd  r  ,   -1.  **
 **   job   -2.                             **
 ************************************************************************
 ************************************************************************/
    int j;

    j = -1;
    if  (pgoblin.a[cmd].flags & pgoblin.p[r].sym) {
        /*  a[cmd].flags    [r] */
        j = (pgoblin.p[r].bin < 0)
            /*      */
          ? (pgoblin.a[cmd].flags >> ~pgoblin.p[r].bin) & pgoblin.p[r].mask
            /*      */
          : pgoblin.p[r].bin
        ;
        if  (!(pgoblin.a[cmd].ch[j] & pgoblin.p[r].val) && !!pgoblin.a[cmd].ch[j]) {
            /*                            *
             *     ,  -     . *
             *    0 j ,   j  ,      *
             *        j                    *
             */
            j = -2;
    }   }
    return(j);
}

pgoblin_rio *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_upio(pgoblin_main *options, pgoblin_nr nio) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rio *prev = NULL;
    pgoblin_rio *rio  = NULL;


    if  (pgoblin.regsize <= nio) {
        ifBLIN_QX0("Ill IO reg num %u", nio);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << nio) & options->useio)) {
        ifBLIN_QX4("IO reg %u masked+", nio);
        prev = options->io[nio];
        options->io[nio] = NULL;
    }
    if  (!(rio = options->io[nio])) {
        if  (!(options->io[nio] = rio = calloc(1, sizeof(pgoblin_rio)))) {
            ifBLIN_QW0("No mem IO reg %u", nio);
            goto out;
        }
        rio->prev = prev;
        rio->flags = options->flags & BLIN_MASK;
        options->useio |= (1ULL << nio);
    }
out:
    return(rio);
#   undef blin_internal_flags
}

pgoblin_rdb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_upcon(pgoblin_main *options, pgoblin_nr ndb)          {     /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rdb *prev = NULL;
    pgoblin_rdb *rdb  = NULL;

    if  (pgoblin.regsize <= ndb) {
        ifBLIN_QX0("Ill CONN reg num %u", ndb);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << ndb) & options->usecon)) {
        ifBLIN_QX4("CONN reg %u masked+", ndb);
        prev = options->conn[ndb];
        options->conn[ndb] = NULL;
    }
    if  (!(rdb = options->conn[ndb])) {
        if  (!(options->conn[ndb] = rdb = calloc(1, sizeof(pgoblin_rdb)))) {
            ifBLIN_QW0("No mem CONN reg %u", ndb);
            goto out;
        }
        rdb->prev = prev;
        rdb->flags = options->flags & BLIN_MASK;
        options->usecon |= (1ULL << ndb);
    }
out:
    return(rdb);
#   undef blin_internal_flags
}

pgoblin_rjb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_upjob(pgoblin_main *options, pgoblin_nr njb) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rjb *prev = NULL;
    pgoblin_rjb *rjb = NULL;

    if  (pgoblin.regsize <= njb) {
        ifBLIN_QX0("Ill JOB reg num %u", njb);
        goto out;
    }
    if  (!((1ULL << njb) & options->usejob)) {
        ifBLIN_QX4("JOB reg %u masked+", njb);
        prev = options->job[njb];
        options->job[njb] = NULL;
    }
    if  (!(rjb = options->job[njb])) {
        if  (!(options->job[njb] = rjb = calloc(1, sizeof(pgoblin_rjb)))) {
            ifBLIN_QW0("No mem JOB reg %u", njb);
            goto out;
        }
        rjb->prev = prev;
        rjb->flags = options->flags & BLIN_MASK;
        options->usejob |= (1ULL << njb);
    }
out:
    return(rjb);
#   undef blin_internal_flags
}

pgoblin_rst *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_upsty(pgoblin_main *options, pgoblin_nr nst) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rst *prev = NULL;
    pgoblin_rst *rst  = NULL;

    if  (pgoblin.regsize <= nst) {
        ifBLIN_QX0("Ill STY reg num %u", nst);
        goto out;
    }
    if  (!((1ULL << nst) & options->usesty)) {
        ifBLIN_QX4("STY reg %u masked+", nst);
        prev = options->style[nst];
        options->style[nst] = NULL;
    }
    if  (!(rst = options->style[nst])) {
        if  (!(options->style[nst] = rst = calloc(1, sizeof(pgoblin_rst)))) {
            ifBLIN_QW0("No mem STY reg %u", nst);
            goto out;
        }
        rst->prev = prev;
        rst->flags = options->flags & BLIN_MASK;
        options->usesty |= (1ULL << nst);
    }
out:
    return(rst);
#   undef blin_internal_flags
}

pgoblin_rio *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_meio(pgoblin_main *options, pgoblin_nr nio) {               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rio *prev = NULL;
    pgoblin_rio *rio  = NULL;


    if  (pgoblin.regsize <= nio) {
        ifBLIN_QX0("Ill IO reg num %u", nio);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << nio) & options->useio)) {
        ifBLIN_QX4("IO reg %u masked", nio);
        prev = options->io[nio];
        errno = ENOENT;
        goto out;
    }
    if  (!(rio = options->io[nio])) {
        errno = ENOENT;
        goto out;
    }
out:
    return(rio);
#   undef blin_internal_flags
}

pgoblin_rdb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_mecon(pgoblin_main *options, pgoblin_nr ndb) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rdb *prev = NULL;
    pgoblin_rdb *rdb  = NULL;

    if  (pgoblin.regsize <= ndb) {
        ifBLIN_QX0("Ill CONN reg num %u", ndb);
        errno = EDOM;
        goto out;
    }
    if  (!((1ULL << ndb) & options->usecon)) {
        ifBLIN_QX4("CONN reg %u masked", ndb);
        prev = options->conn[ndb];
        errno = ENOENT;
        goto out;
    }
    if  (!(rdb = options->conn[ndb])) {
        errno = ENOENT;
        goto out;
    }
out:
    return(rdb);
#   undef blin_internal_flags
}

pgoblin_rjb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_mejob(pgoblin_main *options, pgoblin_nr njb) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rjb *prev = NULL;
    pgoblin_rjb *rjb = NULL;

    if  (pgoblin.regsize <= njb) {
        ifBLIN_QX0("Ill JOB reg num %u", njb);
        goto out;
    }
    if  (!((1ULL << njb) & options->usejob)) {
        ifBLIN_QX4("JOB reg %u masked", njb);
        prev = options->job[njb];
        errno = ENOENT;
        goto out;
    }
    if  (!(rjb = options->job[njb])) {
        errno = ENOENT;
        goto out;
    }
out:
    return(rjb);
#   undef blin_internal_flags
}

pgoblin_rst *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_mesty(pgoblin_main *options, pgoblin_nr nst) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rst *prev = NULL;
    pgoblin_rst *rst  = NULL;

    if  (pgoblin.regsize <= nst) {
        ifBLIN_QX0("Ill STY reg num %u", nst);
        goto out;
    }
    if  (!((1ULL << nst) & options->usesty)) {
        ifBLIN_QX4("STY reg %u masked", nst);
        prev = options->style[nst];
        errno = ENOENT;
        goto out;
    }
    if  (!(rst = options->style[nst])) {
        errno = ENOENT;
        goto out;
    }
out:
    return(rst);
#   undef blin_internal_flags
}

pgoblin_rio *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushio(pgoblin_main *options, pgoblin_nr nio) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rio *prev = NULL;
    pgoblin_rio *rio  = NULL;


    if  (pgoblin.regsize <= nio) {
        ifBLIN_QX0("Ill IO reg num %u", nio);
        errno = EDOM;
        goto out;
    }
    prev = options->io[nio];
    if  (!(options->io[nio] = rio = calloc(1, sizeof(pgoblin_rio)))) {
        ifBLIN_QW0("IO reg %u", nio);
        goto out;
    }
    rio->prev = prev;
    rio->flags = options->flags & BLIN_MASK;
    options->useio |= (1ULL << nio);
out:
    ifBLIN_QX6( "IO   %"BLIN_X"->%"BLIN_X"=%s~"
              , BLIN_I(rio)
              , BLIN_I(prev)
              , (rio && rio->text) ? rio->text : ""
              );
    return(rio);
#   undef blin_internal_flags
}

pgoblin_rdb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushcon(pgoblin_main *options, pgoblin_nr ndb)          {     /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rdb *prev = NULL;
    pgoblin_rdb *rdb  = NULL;

    if  (pgoblin.regsize <= ndb) {
        ifBLIN_QX0("Ill CONN reg num %u", ndb);
        errno = EDOM;
        goto out;
    }
    prev = options->conn[ndb];
    if  (!(options->conn[ndb] = rdb = calloc(1, sizeof(pgoblin_rdb)))) {
        ifBLIN_QW0("CONN reg %u", ndb);
        goto out;
    }
    rdb->prev = prev;
    rdb->flags = options->flags & BLIN_MASK;
    options->usecon |= (1ULL << ndb);
out:
    ifBLIN_QX6("CONN %"BLIN_X"->%"BLIN_X, BLIN_I(rdb), BLIN_I(prev));
    return(rdb);
#   undef blin_internal_flags
}

pgoblin_rjb *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushjob(pgoblin_main *options, pgoblin_nr njb) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rjb *prev = NULL;
    pgoblin_rjb *rjb = NULL;

    if  (pgoblin.regsize <= njb) {
        ifBLIN_QX0("Ill JOB reg num %u", njb);
        goto out;
    }
    prev = options->job[njb];
    if  (!(options->job[njb] = rjb = calloc(1, sizeof(pgoblin_rjb)))) {
        ifBLIN_QW0("JOB reg %u", njb);
        goto out;
    }
    rjb->prev = prev;
    rjb->flags = options->flags & BLIN_MASK;
    options->usejob |= (1ULL << njb);
out:
    ifBLIN_QX6("JOB  %"BLIN_X"->%"BLIN_X, BLIN_I(rjb), BLIN_I(prev));
    return(rjb);
#   undef blin_internal_flags
}

pgoblin_rst *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pushsty(pgoblin_main *options, pgoblin_nr nst) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    pgoblin_rst *prev = NULL;
    pgoblin_rst *rst  = NULL;

    if  (pgoblin.regsize <= nst) {
        ifBLIN_QX0("Ill STY reg num %u", nst);
        goto out;
    }
    prev = options->style[nst];
    if  (!(options->style[nst] = rst = calloc(1, sizeof(pgoblin_rst)))) {
        ifBLIN_QW0("STY reg %u", nst);
        goto out;
    }
    rst->prev = prev;
    rst->flags = options->flags & BLIN_MASK;
    options->usesty |= (1ULL << nst);
out:
    ifBLIN_QX6("STY  %"BLIN_X"->%"BLIN_X, BLIN_I(rst), BLIN_I(prev));
    return(rst);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popio(pgoblin_main *options, pgoblin_nr nio) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int ex = EX_OK;
    pgoblin_rio *prev = NULL;

    if  (pgoblin.regsize <= nio) {
        ifBLIN_QX0("Ill IO reg num %u", nio);
        goto out;
    }
    prev = options->io[nio]->prev;
    free(options->io[nio]); /* XXXX   XXXX */
    options->io[nio] = prev;
    if  (!prev) options->useio &= ~(1ULL << nio);
out:
    ifBLIN_QX6("IO   %"BLIN_X" %u", BLIN_I(prev), ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popcon(pgoblin_main *options, pgoblin_nr ndb) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int ex = EX_OK;
    pgoblin_rdb *prev = NULL;

    if  (pgoblin.regsize <= ndb) {
        ifBLIN_QX0("Ill CONN reg num %u", ndb);
        goto out;
    }
    prev = options->conn[ndb]->prev;
    free(options->conn[ndb]); /* XXXX   XXXX */
    options->conn[ndb] = prev;
    if  (!prev) options->usecon &= ~(1ULL << ndb);
out:
    ifBLIN_QX6("CONN %"BLIN_X" %u", BLIN_I(prev), ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popjob(pgoblin_main *options, pgoblin_nr njb) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int ex = EX_OK;
    pgoblin_rjb *prev = NULL;

    if  (pgoblin.regsize <= njb) {
        ifBLIN_QX0("Ill JOB reg num %u", njb);
        goto out;
    }
    prev = options->job[njb]->prev;
    free(options->job[njb]); /* XXXX   XXXX */
    options->job[njb] = prev;
    if  (!prev) options->usejob &= ~(1ULL << njb);
out:
    ifBLIN_QX6("JOB  %"BLIN_X" %u", BLIN_I(prev), ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_popsty(pgoblin_main *options, pgoblin_nr nst) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int ex = EX_OK;
    pgoblin_rst *prev = NULL;

    if  (pgoblin.regsize <= nst) {
        ifBLIN_QX0("Ill STY reg num %u", nst);
        goto out;
    }
    prev = options->style[nst]->prev;
    free(options->style[nst]); /* XXXX   XXXX */
    options->style[nst] = prev;
    if  (!prev) options->usesty &= ~(1ULL << nst);
out:
    ifBLIN_QX6("STY  %"BLIN_X" %u", BLIN_I(prev), ex);
    return(ex);
#   undef blin_internal_flags
}
