/*-
 * Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: execute.c,v 1.216 2022/01/23 18:06:14 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define RECOBE_COMPAT    4
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <dlfcn.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

#define SNPTEST  do {                                 \
    if  (0 > n) {                                     \
        ifBLIN_QX0("snprintf failed");                \
        free(buf);                                    \
        buf = NULL;                                   \
        goto out;                                     \
    } else if (n < buflen) {                          \
        buflen -= n;                                  \
        buf += n;                                     \
    } else {                                          \
        ifBLIN_QX1("snprintf overflow");              \
        buflen = 0;                                   \
}   } while(0)

BLIN_flag pgoblin_default;
static size_t u12[] = {341, 512, 512};

static void
/**********************************************************************
 **                                                                  **/
dump_ioreg(pgoblin_main *options, pgoblin_nr r) {                   /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int          buflen = 1000;
    char        *ret    = NULL;
    char        *buf    = NULL;
    void        *wdr;
    void        *cdr;
    pgoblin_rio *rio;
    int          n;

    if  (!(rio = pgoblin_meio(options, r))) goto out;
    if  ((rio->flags & PGOBLIN_TEXTPARM) && !!rio->text) {
        if  (!(rio->flags & PGOBLIN_BINPARM)) {
            buflen += strlen(rio->text);
        } else {
            buflen += 4 * rio->length;
    }   }
    if  (!(ret = buf = malloc(buflen))) {
        ifBLIN_QX0("Malloc failed");
        goto out;
    }
    n = snprintf(buf, buflen, "[%c]", pgoblin_regn[r]);
    SNPTEST;
    if  (rio->flags || rio->mife || rio->pq || rio->wri || rio->clo || rio->path || rio->text) {
        n = snprintf( buf
                    , buflen
                    , "(%06X%s%s%s%s%s%s%s%s%s%s%s%s):"
                    , rio->flags
                    , (rio->flags & PGOBLIN_PATHPARM) ? " path"  : ""
                    , (rio->flags & PGOBLIN_FREEPATH) ? " path*" : ""
                    , (rio->flags & PGOBLIN_FILEOVER) ? " over"  : ""
                    , (rio->flags & PGOBLIN_TEXTPARM) ? " text"  : ""
                    , (rio->flags & PGOBLIN_FREETEXT) ? " text*" : ""
                    , (rio->flags & PGOBLIN_BINPARM ) ? " bin"   : ""
                    , (rio->flags & PGOBLIN_MIFEDES ) ? " mife"  : ""
                    , (rio->flags & PGOBLIN_FREEMIFE) ? " mife*" : ""
                    , (rio->flags & PGOBLIN_PQRESULT) ? " pq"    : ""
                    , (rio->flags & PGOBLIN_FREEPQRE) ? " pq*"   : ""
                    , (rio->flags & PGOBLIN_OUTSET  ) ? " out"   : ""
                    , (rio->flags & PGOBLIN_FREEOUTS) ? " out*"  : ""
                    );
        SNPTEST;
        if  (!!rio->mife) {
            n = snprintf(buf, buflen, " mife=%"BLIN_X" pid=%d", BLIN_I(rio->mife), rio->pid);
            SNPTEST;
        }
        if  (!!rio->pq) {
            n = snprintf(buf, buflen, " pq=%"BLIN_X" flags=%08X", BLIN_I(rio->pq), *rio->pq);
            SNPTEST;
        }
        wdr = rio->wri;
        if  (wdr == write) {
            n = snprintf(buf, buflen, " wri=write");
            SNPTEST;
        } else if (wdr == mife_writ) {
            n = snprintf(buf, buflen, " wri=mife_writ");
            SNPTEST;
        } else if (wdr) {
            n = snprintf(buf, buflen, " wri=%" BLIN_X, BLIN_I(wdr));
            SNPTEST;
        }
        cdr = rio->clo;
        if  (cdr == close) {
            n = snprintf(buf, buflen, " clo=close");
            SNPTEST;
        } else if (cdr) {
            n = snprintf(buf, buflen, " clo=%" BLIN_X, BLIN_I(cdr));
            SNPTEST;
        }
        if  (wdr || cdr) {
            n = snprintf(buf, buflen, " onu=%d", rio->onu);
            SNPTEST;
        }
        if  ((rio->flags & PGOBLIN_PATHPARM) && !!rio->path) {
            n = snprintf(buf, buflen, " path=%s~", rio->path);
            SNPTEST;
        }
        if  ((rio->flags & PGOBLIN_TEXTPARM) && !!rio->text) {
            if  (!(rio->flags & PGOBLIN_BINPARM)) {
                n = snprintf(buf, buflen, " text=%s~", (char*)rio->text);
                SNPTEST;
            } else ifBLIN_QO4 {
                u_int i;

                n = snprintf(buf, buflen, " bin=");
                SNPTEST;
                for (i = 0; i < rio->length; i++) {
                    if  (  ((((u_char*)rio->text)[i] >= 0177) && (((u_char*)rio->text)[i] < 0300))
                        || (((u_char*)rio->text)[i] < ' ')
                        ) {
                        n = snprintf(buf, buflen, "\\%03o", ((u_char*)rio->text)[i]);
                        SNPTEST;
                    } else if (((char*)rio->text)[i] == '\\') {
                        n = snprintf(buf, buflen, "\\\\");
                        SNPTEST;
                    } else {
                        n = snprintf(buf, buflen, "%c", ((char*)rio->text)[i]);
                        SNPTEST;
                }   }
                n = snprintf(buf, buflen, "~");
                SNPTEST;
            } else {
                n = snprintf( buf
                            , buflen
                            , " bin %" BLIN_X " length %d\n"
                            , BLIN_I(rio->text)
                            , (int)rio->length
                            );
                SNPTEST;
    }   }   }
    ifBLIN_QX3("%s", ret);
    free(ret);
out:
    return;
#   undef blin_internal_flags
}

static void
/***********************************************************************************************
 **                                                                                           **/
iorassert(pgoblin_exenv *exenv, pgoblin_command cmd, u_int32_t lfcount, const char *finam) { /**
 **                                                                                           **
 ***********************************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
#   define W "%s:%u cmd[%d]=%03X(%s) fl[%c]=%08X "
#   define WW(A) do {ifBLIN_QX1(W A, finam, lfcount, exenv->ppoint, cmd, s, n, rio->flags);} while(0)
    pgoblin_rio *rio;
    u_char       rr[pgoblin.regsize + 1];
    u_char       rp[pgoblin.regsize + 1];

    bzero(rr, pgoblin.regsize + 1);
    for (int r = 0; r < pgoblin.regsize; r++) {
        char       *s = pgoblin.a[cmd].str;
        char        n = pgoblin_regn[r];
        u_int32_t   e;

        if  (!(rio = pgoblin_meio(exenv->options, r))) continue;
        e = 0; /*  ,    */
        if  (rio->path) {
            e |= PGOBLIN_PATHPARM;
        } else if (rio->flags & PGOBLIN_PATHPARM) {
            WW("  path");
        } else if (rio->flags & PGOBLIN_FREEPATH) {
            WW("  path");
        }
        if  (rio->text) {
            e |= PGOBLIN_TEXTPARM;
        } else if (rio->flags & PGOBLIN_TEXTPARM) {
            WW("  text");
        } else if (rio->flags & PGOBLIN_FREETEXT) {
            WW("  text");
        }
        if  (rio->mife) {
            e |= PGOBLIN_MIFEDES;
        } else if (rio->flags & PGOBLIN_MIFEDES) {
            WW("  mife");
        } else if (rio->flags & PGOBLIN_FREEMIFE) {
            WW("  mife");
        }
        if  (rio->pq) {
            e |= PGOBLIN_PQRESULT;
        } else if (rio->flags & PGOBLIN_PQRESULT) {
            WW("  pq");
        } else if (rio->flags & PGOBLIN_FREEPQRE) {
            WW("  pq");
        }
        if  (!(rio->flags & PGOBLIN_ANYIVL) && e) {
            ifBLIN_QX1( W "  %02X(%s%s%s%s)"
                      , finam
                      , lfcount
                      , exenv->ppoint
                      , cmd
                      , s
                      , n
                      , rio->flags
                      , e
                      , (e & PGOBLIN_PATHPARM) ? "f" : ""
                      , (e & PGOBLIN_TEXTPARM) ? "t" : ""
                      , (e & PGOBLIN_MIFEDES)  ? "m" : ""
                      , (e & PGOBLIN_PQRESULT) ? "q" : ""
                      );
        }
        if  (rio->wri) {
            e |= PGOBLIN_OUTSET;
            if  (!(rio->flags & PGOBLIN_OUTSET)) {
                WW("  wri");
            }
        } else if (rio->flags & (PGOBLIN_OUTSET | PGOBLIN_FREEOUTS)) {
            WW("  wri");
        }
        if  (rio->clo && !(rio->flags & PGOBLIN_FREEOUTS)) {
            WW("  clo");
        }
        rr[r] = e;
    }
    ifBLIN_QO2 {
        /*    - ,     ,
         *     .
         */
        for (int r = 0; r < pgoblin.regsize; r++) {
            rp[r] = pgoblin_regn[rr[r]];
            if  (!(rio = exenv->options->io[r])) {
                rr[r] = '.';
            } else if (rr[r] == (rio->flags & (PGOBLIN_ANYIVL | PGOBLIN_OUTSET))) {
                rr[r] = '=';
            } else {
                rr[r] = pgoblin_regn[rio->flags & (PGOBLIN_ANYIVL | PGOBLIN_OUTSET)];
        }   }
        rr[pgoblin.regsize] = rp[pgoblin.regsize] = '\0';
        ifBLIN_QX2("     %.*s", 64, pgoblin_regn);
        ifBLIN_QX2("regs %s", rp);
        ifBLIN_QX2("flag %s", rr);
    }
    ifBLIN_QX4( "\n    00 0   08 8   10 G   18 O   20 W   28 e   30 m   38 u"
                "\n    01 1   09 9   11 H   19 P   21 X   29 f   31 n   39 v"
                "\n    02 2   0A A   12 I   1A Q   22 Y   2A g   32 o   3A w"
                "\n    03 3   0B B   13 J   1B R   23 Z   2B h   33 p   3B x"
                "\n    04 4   0C C   14 K   1C S   24 a   2C i   34 q   3C y"
                "\n    05 5   0D D   15 L   1D T   25 b   2D j   35 r   3D z"
                "\n    06 6   0E E   16 M   1E U   26 c   2E k   36 s   3E _"
                "\n    07 7   0F F   17 N   1F V   27 d   2F l   37 t   3F -"
              );
#   undef WW
#   undef W
#   undef blin_internal_flags
}

/*
 *   IO      . score[][] 
 *  -     r ()   ch ()   
 *  .     procomp(options, r, ch).  
 *   propush(exenv, r, ch)  ,     
 *  ,  ,  Co   propush(), 
 *    Cf, Ct, Cm, Cq  Cw  cleareg(options, r, m),  m
 *   ,   procomp() -     .
 *       exenv->flags,      (
 * Ce == PGOBLIN_FORKOUT)   ( Cs, Cp, Cu  PGOBLIN_FREE*) 
 *  .
 */

static int
/**********************************************************************
 **                                                                  **/
cleareg(pgoblin_exenv *exenv, pgoblin_nr r, u_int32_t m) {          /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rio;
    int          ex  = EX_OK;
    int          cl  = 0;                /*     , *
                                          *    ,    . */

    if  (!(rio = pgoblin_meio(exenv->options, r))) goto out;
    ifBLIN_QX4("+ %"BLIN_X" %08X", BLIN_I(rio), m);
    if  (m & PGOBLIN_PATHPARM) {
        ++cl;
        MARK_IO_PATH_GO(r);;
        ;;  if  (!!rio->path && (rio->flags & PGOBLIN_FREEPATH)) free(rio->path);
        ;;  rio->path = NULL;
        ;;  rio->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        MARK_IO_PATH_WENT(r);;
    }
    if  (m & PGOBLIN_TEXTPARM) {
        ++cl;
        MARK_IO_TEXT_GO(r);;
        ;;  if  (!!rio->stymd) {
        ;;      mular_destroy(rio->stymd);
        ;;      rio->stymd = NULL;
        ;;  }
        ;;  if  (!!rio->text && (rio->flags & PGOBLIN_FREETEXT)) free(rio->text);
        ;;  rio->text = NULL;
        ;;  rio->length = 0;
        ;;  rio->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_TEXTPARM | PGOBLIN_BINPARM);
        MARK_IO_TEXT_WENT(r);;
    }
    if  (m & PGOBLIN_PQRESULT) {
        ++cl;
        MARK_IO_PQ_GO(r);;
        ;;  if  (!!rio->pq && (rio->flags & PGOBLIN_FREEPQRE) && !!DBASE(*(BLIN_flag*)(rio->pq))) {
        ;;      pgoblin_db_clear(exenv, r);
        ;;  }
        ;;  rio->pq = NULL;
        ;;  rio->flags &= ~(PGOBLIN_FREEPQRE | PGOBLIN_PQRESULT);
        ;;  rio->cortege = -1;
        MARK_IO_PQ_WENT(r);;
    }
    if  (m & PGOBLIN_MIFEDES) {
        ++cl;
        MARK_IO_MIFE_GO(r);;
        ;;  if  (!!rio->mife && (rio->flags & PGOBLIN_FREEMIFE) && (ex = mife_fini(rio->mife))) {
        ;;      ifBLIN_QW0("mife_fini in cleareg");
        ;;  }
        ;;  rio->mife = NULL;
        ;;  rio->pid = 0;
        ;;  rio->flags &= ~(PGOBLIN_FREEMIFE | PGOBLIN_MIFEDES);
        MARK_IO_MIFE_WENT(r);;
    }
    if  (m & PGOBLIN_OUTSET) {
        ++cl;
        MARK_IO_OUT_GO(r);;
        ;;  if  (!!rio->clo && (rio->flags & PGOBLIN_FREEOUTS) && (ex = rio->clo(rio->onu))) {
        ;;      ifBLIN_QW0("clo in cleareg");
        ;;  }
        ;;  rio->clo = NULL;
        ;;  rio->wri = NULL;
        ;;  rio->onu = 0;
        ;;  rio->flags &= ~(PGOBLIN_OUTSET | PGOBLIN_FREEOUTS);
        MARK_IO_OUT_WENT(r);;
    }
    if  (!!cl) {
        if  (!!rio->path && !(rio->flags & PGOBLIN_PATHPARM)) {
            MARK_IO_PATH_GO(r);;
            ;;  if  (rio->flags & PGOBLIN_FREEPATH) free(rio->path);
            ;;  rio->path = NULL;
            ;;  rio->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
            MARK_IO_PATH_WENT(r);;
        }
        if  (!!rio->text && !(rio->flags & PGOBLIN_TEXTPARM)) {
            MARK_IO_TEXT_GO(r);;
            ;;  if  (!!rio->stymd) {
            ;;      mular_destroy(rio->stymd);
            ;;      rio->stymd = NULL;
            ;;  }
            ;;  if  (rio->flags & PGOBLIN_FREETEXT) free(rio->text);
            ;;  rio->text = NULL;
            ;;  rio->length = 0;
            ;;  rio->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_TEXTPARM | PGOBLIN_BINPARM);
            MARK_IO_TEXT_WENT(r);;
        }
        if  (!!rio->pq && !(rio->flags & PGOBLIN_PQRESULT)) {
            MARK_IO_PQ_GO(r);;
            ;;  if  ((rio->flags & PGOBLIN_FREEPQRE) && !!DBASE(*(BLIN_flag*)(rio->pq))) {
            ;;      pgoblin_db_clear(exenv, r);
            ;;  }
            ;;  rio->pq = NULL;
            ;;  rio->flags &= ~(PGOBLIN_FREEPQRE | PGOBLIN_PQRESULT);
            ;;  rio->cortege = -1;
            MARK_IO_PQ_WENT(r);;
        }
        if  (!!rio->mife && !(rio->flags & PGOBLIN_MIFEDES)) {
            MARK_IO_MIFE_GO(r);;
            ;;  if  ((rio->flags & PGOBLIN_FREEMIFE) && (ex = mife_fini(rio->mife))) {
            ;;      ifBLIN_QW0("mife_fini in cleareg");
            ;;  }
            ;;  rio->mife = NULL;
            ;;  rio->pid = 0;
            ;;  rio->flags &= ~(PGOBLIN_FREEMIFE | PGOBLIN_MIFEDES);
            MARK_IO_MIFE_WENT(r);;
    }   }
    if  (!rio->text && !!rio->stymd) {
        ifBLIN_QX1("stymd without TEXT");
        MARK_IO_TEXT_GO(r);;
        ;;  mular_destroy(rio->stymd);
        ;;  rio->stymd = NULL;
        MARK_IO_TEXT_WENT(r);;
    }
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#define Cx PGOBLIN_IGNORE   /* impossible         0x800000 */
#define Co PGOBLIN_OPEN     /* open               0x200000 */
#define Cf PGOBLIN_PATHPARM /* free path          0x000001 */
#define Ct PGOBLIN_TEXTPARM /* free text          0x000002 */
#define Cm PGOBLIN_MIFEDES  /* free mife          0x000004 */
#define Cq PGOBLIN_PQRESULT /* free pq            0x000008 */
#define Cw PGOBLIN_OUTSET   /* free wri           0x000010 */
#define Ce PGOBLIN_FORKOUT  /* fork               0x000020 */
#define Cs PGOBLIN_FREEPATH /* stream file out    0x010000 */
#define Cp PGOBLIN_FREETEXT /* copy text out      0x020000 */
#define Cu PGOBLIN_FREEPQRE /* unstore pq out     0x080000 */

static const u_int32_t score[32][4] =
 /*ftmqw          Pf           Pt           Pm           Pq   Wish*/
{/*00000*/{0              ,0           ,          Ce,0           }
,/*10000*/{ Co|Cf|      Cs, Co|      Cp, Co         , Co|      Cu}
,/*01000*/{       Ct      ,    Ct      ,    Ct|   Ce,    Ct      }
,/*11000*/{ Co|Cf|Ct|   Cs, Co|Ct|   Cp, Co|Ct      , Co|Ct|   Cu}
,/*00100*/{ Cm            , Cm         ,          Ce, Cm         }
,/*10100*/{ Co|Cf|      Cs, Co|      Cp, Co         , Co|      Cu}
,/*01100*/{ Cm|   Ct      , Cm|Ct      ,    Ct|   Ce, Cm|Ct      }
,/*11100*/{ Co|Cf|Ct|   Cs, Co|Ct|   Cp, Co|Ct      , Co|Ct|   Cu}
,/*00010*/{          Cq   ,       Cq   ,       Cq|Ce,       Cq   }
,/*10010*/{ Co|Cf|   Cq|Cs, Co|   Cq|Cp, Co|   Cq   , Co|   Cq|Cu}
,/*01010*/{       Ct|Cq   ,    Ct|Cq   ,    Ct|Cq|Ce,    Ct|Cq   }
,/*11010*/{ Co|Cf|Ct|Cq|Cs, Co|Ct|Cq|Cp, Co|Ct|Cq   , Co|Ct|Cq|Cu}
,/*00110*/{ Cm|      Cq   , Cm|   Cq   ,       Cq|Ce, Cm|   Cq   }
,/*10110*/{ Co|Cf|   Cq|Cs, Co|   Cq|Cp, Co|   Cq   , Co|   Cq|Cu}
,/*01110*/{ Cm|   Ct|Cq   , Cm|Ct|Cq   ,    Ct|Cq|Ce, Cm|Ct|Cq   }
,/*11110*/{ Co|Cf|Ct|Cq|Cs, Co|Ct|Cq|Cp, Co|Ct|Cq   , Co|Ct|Cq|Cu}
,/*00001*/{             Cs,          Cp,0           ,          Cu}
,/*10001*/{    Cf|      Cs,          Cp,0           ,          Cu}
,/*01001*/{       Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*11001*/{    Cf|Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*00101*/{             Cs,          Cp,0           ,          Cu} /* IO_RG0 */
,/*10101*/{    Cf|      Cs,          Cp,0           ,          Cu}
,/*01101*/{       Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*11101*/{    Cf|Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*00011*/{          Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*10011*/{    Cf|   Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*01011*/{       Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*11011*/{    Cf|Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*00111*/{          Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*10111*/{    Cf|   Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*01111*/{       Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*11111*/{    Cf|Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
}/* Reg */;

static u_int32_t
/**********************************************************************
 **                                                                  **/
procomp(pgoblin_main *options, pgoblin_rio *rio, u_int32_t ch) {    /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    u_int32_t price;
    u_int32_t abil;
    int       i;
    int       j;

    abil = 0;
    for (j = 0; j < 5; j++) { /* From */
        if  (  ((j == 0) && (rio->path))
            || ((j == 1) && (rio->text))
            || ((j == 2) && (rio->mife))
            || ((j == 3) && (rio->pq  ))
            || ((j == 4) && (rio->wri ))
            ) {
            abil |= (1 << j);
    }   }
    price = 0;
    for (i = 0; i < 4; i++) { /* To */
        if  (  ((i == 0) && (ch & PGOBLIN_PATHPARM))
            || ((i == 1) && (ch & PGOBLIN_TEXTPARM))
            || ((i == 2) && (ch & PGOBLIN_MIFEDES ))
            || ((i == 3) && (ch & PGOBLIN_PQRESULT))
            ) {
            ifBLIN_QX3("%d abil=%02X %04X", i, abil, score[abil][i]);
            price |= score[abil][i];
    }   }
    ifBLIN_QX3("abil=%02X %04X", abil, price);
    return(price);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
propush(pgoblin_exenv *exenv, pgoblin_nr r, u_int32_t ch) {         /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int32_t    price;
    pgoblin_rio *rio;
    int          ex = EX_OK;

    if  (!(rio = pgoblin_meio(exenv->options, r))) {
        ifBLIN_QX4("+ ch=%02X", ch);
        goto out;
    }
    ifBLIN_QX4( "+ rio %u ch=%02X io=%08X%s%s%s%s"
              , r
              , ch
              , rio->flags
              , rio->path ? " path" : ""
              , rio->text ? " text" : ""
              , rio->wri  ? " mife" : ""
              , rio->pq   ? " pq"   : ""
              );
    if  (!(ch & PGOBLIN_OUTSET)) {
        ifBLIN_QX0("No output in propush");
        ERROUT(EX_DATAERR, EINVAL);
    } else if (  ((rio->flags & PGOBLIN_PATHPARM) && !rio->path)
              || ((rio->flags & PGOBLIN_TEXTPARM) && !rio->text)
              || ((rio->flags & PGOBLIN_OUTSET  ) && !rio->wri )
              || ((rio->flags & PGOBLIN_PQRESULT) && !rio->pq  )
              ) {
        if  ((rio->flags & PGOBLIN_PATHPARM) && !rio->path) {
            ifBLIN_QX0("rio %u no PATH f=%08X %08X", r, rio->flags, rio->flags & PGOBLIN_PATHPARM);
        }
        if  ((rio->flags & PGOBLIN_TEXTPARM) && !rio->text) {
            ifBLIN_QX0("rio %u no TEXT f=%08X %08X", r, rio->flags, rio->flags & PGOBLIN_TEXTPARM);
        }
        if  ((rio->flags & PGOBLIN_OUTSET  ) && !rio->wri ) {
            ifBLIN_QX0("rio %u no WRI  f=%08X %08X", r, rio->flags, rio->flags & PGOBLIN_OUTSET);
        }
        if  ((rio->flags & PGOBLIN_PQRESULT) && !rio->pq  ) {
            ifBLIN_QX0("rio %u no PQ   f=%08X %08X", r, rio->flags, rio->flags & PGOBLIN_PQRESULT);
        }
        ERROUT(EX_DATAERR, EINVAL);
    }
    price = procomp(exenv->options, rio, ch);
    if  (price & Cx) {
        ifBLIN_QX0("No way @%d f=%08X", exenv->ppoint, rio->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (price & Co) {
        int o;

        if  (rio->path) {
            o = open( rio->path
                    , O_WRONLY | O_CREAT | ((rio->flags & PGOBLIN_FILEOVER) ? O_TRUNC : O_APPEND)
                    , 0666
                    );
            if  (o < 0) {
                ifBLIN_QW0("Open=%s~%s", rio->path, (rio->flags & PGOBLIN_FILEOVER) ? " over" : "");
                ex = EX_IOERR;
                goto out;
            }
            MARK_IO_OUT_GO(r);;
            ;;  rio->onu = o;
            ;;  rio->clo = close;
            ;;  rio->wri = (int(*)(int, const void *, size_t))mife_writ;
            ;;  rio->flags |= PGOBLIN_FREEOUTS | PGOBLIN_OUTSET;
            MARK_IO_OUT_WENT(r);;
        } else {
            ifBLIN_QW1("Open NULL %s", (rio->flags & PGOBLIN_FILEOVER) ? " over" : "");
            o = -1;
            MARK_IO_OUT_GO(r);;
            ;;  rio->onu = o;
            ;;  rio->clo = NULL;
            ;;  rio->wri = NULL;
            ;;  rio->flags &= ~PGOBLIN_FREEOUTS;
            MARK_IO_OUT_WENT(r);;
    }   }
    if  (!ex) {
        cleareg(exenv, r, price);
    } else {
        ex = cleareg(exenv, r, price);
    }
    if  (!ex) exenv->flags |= price;
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

/*
 *   IO    . dcore[][]   
 *      .       
 *    ( )     .  
 *      D*. coercion(exenv, rio, ch)  
 * coercomp(options, rio, ch)    ,     
 *     D*.       
 *      rio      ch   
 * ,    . ,   rio  ,
 *   ch,   0     .
 */

#define DC 0x000F /* price              */
#define Dx 0x8000 /* impossible         */
#define Dq 0x4000 /* read to text       */
#define Do 0x2000 /* open file name     */
#define Dr 0x1000 /* read file          */
#define Dl 0x0800 /* db_0 from text     */
#define Dn 0x0400 /* temp file name     XXXX */
#define Dw 0x0200 /* write file         XXXX */
#define Dm 0x0100 /* do mife from text  */
#define Da 0x0080 /* throw pq to file   XXXX */
#define Db 0x0040 /* throw mife to file XXXX */

static const u_int16_t dcore[4][4] =
      /*              Pf          Pt          Pm          Pq   Reg */
{/* Pf */{             0, Dx|Dn|Dw|7, Dx|Dn|Db|9, Dx|Dn|Da|8}
,/* Pt */{    Do|Dr   |4,          0,    Dr   |3,    Dq   |5}
,/* Pm */{    Do      |1,       Dm|2,          0,    Dq|Dm|6}
,/* Pq */{    Do|Dr|Dl|5,       Dl|1,    Dr|Dl|4,          0}
}/*Wish*/;

static u_int32_t
/**********************************************************************
 **        rio      **
 **    ch                                       **
 **********************************************************************
 **                                                                  **/
coercomp(pgoblin_main *options, pgoblin_rio *rio, u_int32_t ch) {   /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int       surprise;
    u_int32_t price;
    int       i;
    int       j;

    price = Dx | 15;
    surprise = 1;
    for (i = 0; i < 4; i++) { /* To */
        if  (  ((i == 0) && (ch & PGOBLIN_PATHPARM))
            || ((i == 1) && (ch & PGOBLIN_TEXTPARM))
            || ((i == 2) && (ch & PGOBLIN_MIFEDES ))
            || ((i == 3) && (ch & PGOBLIN_PQRESULT))
            ) {
            surprise = 0;
            for (j = 0; j < 4; j++) { /* From */
                if  (  (  ((j == 0) && (rio->path))
                       || ((j == 1) && (rio->text))
                       || ((j == 2) && (rio->mife))
                       || ((j == 3) && (rio->pq  ))
                       )
                    && (dcore[i][j] & DC) < (price & DC)
                    ) {
                    price = dcore[i][j];
                    ifBLIN_QX3("i=%d j=%d %04X", i, j, dcore[i][j]);
    }   }   }   }
    return(surprise ? 0 : price);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **     rio     ch   **
 **********************************************************************
 **                                                                  **/
coercion(pgoblin_exenv *exenv, pgoblin_nr r, u_int32_t ch) {        /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    u_int32_t    price;
    pgoblin_rio *rio;
    int          ex = EX_OK;

    if  (!(rio = pgoblin_meio(exenv->options, r))) {
        ifBLIN_QX4("+ ruo %u ch=%02X", r, ch);
        goto out;
    }
    ifBLIN_QX4( "+ ch=%02X io=%08X%s%s%s%s"
              , ch
              , rio->flags
              , rio->path ? " path" : ""
              , rio->text ? " text" : ""
              , rio->mife ? " mife" : ""
              , rio->pq   ? " pq"   : ""
              );
    if  (ch & PGOBLIN_OUTSET) {
        ifBLIN_QX0("Output in coercion");
        ERROUT(EX_DATAERR, EINVAL);
    } else if (  ((rio->flags & PGOBLIN_PATHPARM) && !rio->path)
              || ((rio->flags & PGOBLIN_TEXTPARM) && !rio->text)
              || ((rio->flags & PGOBLIN_MIFEDES ) && !rio->mife)
              || ((rio->flags & PGOBLIN_PQRESULT) && !rio->pq  )
              ) {
        ifBLIN_QX0("No info f=%08X", rio->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    price = coercomp(exenv->options, rio, ch);
    ifBLIN_QX4( "price %08X<%s%s%s%s%s%s%s%s%s%s%u%s>"
              , price
              , (price & Dx) ? "Dx" : ""
              , (price & Dq) ? "Dq" : ""
              , (price & Do) ? "Do" : ""
              , (price & Dr) ? "Dr" : ""
              , (price & Dl) ? "Dl" : ""
              , (price & Dn) ? "Dn" : ""
              , (price & Dw) ? "Dw" : ""
              , (price & Dm) ? "Dm" : ""
              , (price & Da) ? "Da" : ""
              , (price & Db) ? "Db" : ""
              , price & DC
              , (price & ~(Dx | Dq | Do | Dr | Dl | Dn | Dw | Dm | Da | Db | DC)) ? "?" : ""
              );
    if  (price & Dx) {
        ifBLIN_QX0("No way @%d f=%08X", exenv->ppoint, rio->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (price & Dq) {
        if  (0 > (ex = pgoblin_style_0.table(exenv, 0, r, r, 0, -2))) {
            ifBLIN_QW0("coercion: No STYLE 0");
            goto out;
        }
        ex = EX_OK;
    }
    if  (price & Do) {
        MARK_IO_MIFE_GO(r);;
        ;;  rio->pid = 0;
        ;;  rio->mife = mife_init(PGOBLIN_MIFEFLAGS);
        ;;  rio->flags |= PGOBLIN_FREEMIFE;
        MARK_IO_MIFE_WENT(r);;
        if  (!rio->mife || (0 > mife_ctlfile(rio->mife, rio->path))) {
            rio->flags &= ~(PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE);
            ifBLIN_QW0("coercion mife open %s", rio->path);
            ex = EX_IOERR;
            goto out;
    }   }
    if  (price & Dr) {
        ssize_t l;
        void *t;

        if  ((l = mife_read(rio->mife, (ssize_t)0, (off_t)0)) < 0) {
            ifBLIN_QX0("mife_read");
            ex = EX_IOERR;
            goto out;
        }
        if  (!(t = mife_pointer(rio->mife))) {
            ifBLIN_QX0("mife_pointer");
            ex = EX_IOERR;
            goto out;
        }
        MARK_IO_TEXT_GO(r);;
        ;;  rio->length = l;
        ;;  rio->text = t;
        ;;  rio->flags |= PGOBLIN_BINPARM;
        ;;  rio->flags &= ~PGOBLIN_FREETEXT;
        MARK_IO_TEXT_WENT(r);;
    }
    if  (price & Dl) {
        MARK_IO_TEXT_GO(r);;
        ;;  rio->flags &= ~PGOBLIN_FREETEXT;
        MARK_IO_TEXT_WENT(r);;
        MARK_IO_PQ_GO(r);;
        ;;  pgoblin_db0_create(exenv, r, 1, (const char **)&(rio->text), NULL);
        ;;  rio->flags |= PGOBLIN_FREEPQRE;
        ;;  rio->cortege = -1;
        MARK_IO_PQ_WENT(r);;
    }
    if  (price & Dn) {/* XXXX */}
    if  (price & Dw) {/* XXXX */}
    if  (price & Dm) {
        mife_descriptor *m;
        int tmpi;

        if  (!rio->text) {
            m = NULL;
            tmpi = 0;
        } else {
            if  (!(m = mife_init(PGOBLIN_MIFEFLAGS /* | MIFE_STRI */))) {
                ifBLIN_QX0("mife_init");
                ex = EX_IOERR;
                goto out;
            }
            if  (rio->flags & (PGOBLIN_FREETEXT | PGOBLIN_BINPARM)) {
                tmpi = mife_ctlbuff(m, rio->text, rio->length);
            } else {
                tmpi = mife_ctlcnst(m, rio->text, rio->length);
        }   }
        if  (0 > tmpi) {
            ifBLIN_QX0("mife_ctl");
            ex = EX_IOERR;
            goto out;
        }
        MARK_IO_MIFE_GO(r);;
        ;;  rio->mife = m;
        ;;  rio->pid = 0;
        ;;  rio->flags |= PGOBLIN_FREEMIFE;
        MARK_IO_MIFE_WENT(r);;
    }
    if  (price & Da) {/* XXXX */}
    if  (price & Db) {/* XXXX */}
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
waitjob(pgoblin_main *options, pgoblin_nr r) {                      /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int            status;
    pgoblin_rjb   *rjb;
    struct kevent  kev;
    int            exx = EX_OK;
    int            ex  = EX_OK;
    pgoblin_jobl  *j;
    u_int          i;

    if  (!(rjb = pgoblin_mejob(options, r))) {
        ifBLIN_QX0("No JOB reg %u", r);
        ex = EX_SOFTWARE;
        goto out;
    }
#   undef blin_internal_flags
#   define blin_internal_flags (rjb->flags & BLIN_MASK)
    bzero(&kev, sizeof(kev));
    if  (!(rjb->flags & PGOBLIN_KQUEUED) && ((rjb->kq = kqueue()) < 0)) {
        ex = EX_OSERR;
        goto out;
    }
    MARK_R_JOB_GO(r);;
    ;;  rjb->flags |= PGOBLIN_KQUEUED;
    MARK_R_JOB_WENT(r);;
try:
    for (i = 0; !ex && (i < MULAR_NEXT(rjb->pids)); i++) {
        j = mular_getix(rjb->pids, i);
        if  (j->pid <= 0) {
            ifBLIN_QX0("No pid in %d", (int)j->cmdn);
            errno = EINVAL;
            ex = EX_SOFTWARE;
        } else if (j->cmdn < 0) {
            ifBLIN_QX0("No cmdn %d", (int)j->cmdn);
            errno = EINVAL;
            ex = EX_SOFTWARE;
        } else if (j->status == PGOBLIN_NOSTATUS) {
            EV_SET(&kev, j->pid, EVFILT_PROC, EV_ADD | EV_ONESHOT | EV_CLEAR, NOTE_EXIT, 0, NULL);
            if  (0 > kevent(rjb->kq, &kev, 1, NULL, 0, NULL)) {
                ifBLIN_QW0("No pid %d for kevent ADD", (int)j->pid);
                ex = EX_SOFTWARE;
            } else if (0 > (ex = waitpid(j->pid, &status, WNOHANG))) {
                if  (errno == ECHILD) {
                    ifBLIN_QX1("Lost pid %d in %d", j->pid, (int)j->cmdn);
                    MARK_R_JOB_GO(r);;
                    ;;  j->status = PGOBLIN_LOSTSTAT;
                    ;;  rjb->dead++;
                    MARK_R_JOB_WENT(r);;
                    errno = 0;
                    ex = 0;
                } else {
                    ifBLIN_QW0("Pid %d in %d", j->pid, (int)j->cmdn);
                }
            } else if (0 < ex) {
                if  (ex == j->pid) {
                    EV_SET(&kev, j->pid, EVFILT_PROC, EV_DELETE, NOTE_EXIT, 0, NULL);
                    if  (0 > kevent(rjb->kq, &kev, 1, NULL, 0, NULL)) {
                        ifBLIN_QW1("No pid %d for kevent DELETE", (int)j->pid);
                    }
                    MARK_R_JOB_GO(r);;
                    ;;  j->status = status;
                    ;;  rjb->dead++;
                    MARK_R_JOB_WENT(r);;
                    ex = 0;
                    if  (  (rjb->flags & PGOBLIN_ERROR_SENSOR)
                        && WIFEXITED(status)
                        && WEXITSTATUS(status)
                        && !exx
                        ) exx = WEXITSTATUS(status);
                    if  ((rjb->flags & PGOBLIN_ERROR_SENSIB) && exx) break;
                } else {
                    ifBLIN_QX0("Pid %d<>%d at %d", ex, j->pid, (int)j->cmdn);
    }   }   }   }
    if  (!ex && rjb->concur && (MULAR_NEXT(rjb->pids) >= (rjb->concur + rjb->dead))) {
        kevent(rjb->kq, NULL, 0, &kev, 1, NULL);
        goto try;
    }
out:
    return(ex ? ex : exx);
#   undef blin_internal_flags
}

static int
/*************************************************************************
 **                                                                     **/
pgoblin_inx(pgoblin_exenv *exenv, pgoblin_nr nio, int p[2], int c) {   /**
 **                                                                     **
 *************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rio;
    int          ex = EX_OK; /* Errors must be < 0 */

    GET_RIO(rio, exenv->options, nio);
    if  (c) close(p[1]);
    MARK_IO_MIFE_GO(nio);;
    ;;  if  (  !(rio->mife = mife_init(PGOBLIN_MIFEFLAGS))
            || (0 > mife_ctlfdsc(rio->mife, p[0]))
            ) {
    ;;      ifBLIN_QW0("mife_init inx");
    ;;      ex = -EX_NOINPUT;
    ;;  } else rio->flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
    ;;  rio->pid = 0;
    MARK_IO_MIFE_WENT(nio);;
out:
    return(ex);
#   undef blin_internal_flags
}

static int
/**************************************************************************
 **                                                                      **/
pgoblin_outx(pgoblin_exenv *exenv, pgoblin_nr nio, int p[2], int c) {   /**
 **                                                                      **
 **************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio *rio;
    int          ex = EX_OK; /* Errors must be < 0 */

    GET_RIO(rio, exenv->options, nio);
    if  (c) close(p[0]);
    MARK_IO_OUT_GO(nio);;
    ;;  rio->onu = p[1];
    ;;  rio->wri = (int(*)(int, const void *, size_t))mife_writ;
    ;;  rio->clo = close;
    ;;  rio->flags |= PGOBLIN_OUTSET | PGOBLIN_FREEOUTS;
    MARK_IO_OUT_WENT(nio);;
out:
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pipe(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;
    int pipa[2];

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+pipe %c.%c...", pgoblin_regn[rn[PGO_COUT]], pgoblin_regn[rn[PGO_CIN]]);
    if  (pipe(pipa) < 0) {
        ifBLIN_QW0("pipe in pipe");
        close(pipa[0]);
        close(pipa[1]);
        ex = EX_OSERR;
    }
    pgoblin_upio(exenv->options, rn[PGO_CIN]);
    pgoblin_upio(exenv->options, rn[PGO_COUT]);
    if  (!(ex = pgoblin_inx(exenv, rn[PGO_CIN], pipa, 0))) {
        ex = pgoblin_outx(exenv, rn[PGO_COUT], pipa, 0);
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#define CICLEWARN(N, A) {                                                                            \
    int CICLEWARN_INTERNAL = N;                                                                      \
    ifBLIN_QX1( "%s:%u cmd[%d]=[%03X(%s %c%c%c%c%c%c)].fl=%08X %s ch=%02X " A                        \
              , finam                                                                                \
              , lfcount                                                                              \
              , exenv->ppoint                                                                        \
              , cmd, a_cmd->str                                                                      \
              , pgoblin_regn[rn[0]]                                                                  \
              , pgoblin_regn[rn[1]]                                                                  \
              , pgoblin_regn[rn[2]]                                                                  \
              , pgoblin_regn[rn[3]]                                                                  \
              , pgoblin_regn[rn[4]]                                                                  \
              , pgoblin_regn[rn[5]]                                                                  \
              , a_cmd->flags                                                                         \
              , pgoblin.p[CICLEWARN_INTERNAL].name                                                   \
              , ch[CICLEWARN_INTERNAL]                                                               \
              );                                                                                     \
    continue;                                                                                        \
}

#define CICLEERR(A) do {                                                                             \
    ifBLIN_QW0( "%s:%u cmd[%d]=%03X(%s %c%c%c%c%c%c) %08X %02X %02X %02X %02X %02X %02X " A          \
              , finam                                                                                \
              , lfcount                                                                              \
              , exenv->ppoint                                                                        \
              , cmd                                                                                  \
              , a_cmd->str                                                                           \
              , pgoblin_regn[rn[0]]                                                                  \
              , pgoblin_regn[rn[1]]                                                                  \
              , pgoblin_regn[rn[2]]                                                                  \
              , pgoblin_regn[rn[3]]                                                                  \
              , pgoblin_regn[rn[4]]                                                                  \
              , pgoblin_regn[rn[5]]                                                                  \
              , a_cmd->flags                                                                         \
              , ch[0]                                                                                \
              , ch[1]                                                                                \
              , ch[2]                                                                                \
              , ch[3]                                                                                \
              , ch[4]                                                                                \
              , ch[5]                                                                                \
              );                                                                                     \
} while(0)

#define DUMPIOREGS do {                                                                              \
    for (int DUMPIOREGS_I = 0; DUMPIOREGS_I < pgoblin.regsize; DUMPIOREGS_I++) {                     \
        if  (  (DUMPIOREGS_I == rn[PGO_COUT])                                                        \
            || (DUMPIOREGS_I == rn[PGO_CCTL])                                                        \
            || (DUMPIOREGS_I == rn[PGO_CIN])                                                         \
            ) {                                                                                      \
            dump_ioreg(options, DUMPIOREGS_I);                                                       \
}   }   } while(0)

int
/***********************************************
 ***********************************************
 **                                           **/
pgoblin_execute( pgoblin_main  *options      /**/
/**/           , pgoblin_prog  *pgm          /**/
/**/           , pgoblin_exenv *dexenv       /**/
/**/           , pgoblin_exenv *sexenv       /**/
/**/           , ssize_t        pp           /**/
/**/           ) {                           /**
 **                                           **
 ***********************************************
 ***********************************************/
    u_int32_t      lfcount;
    pgoblin_exenv *exenv = NULL;
    const char    *finam = "";
    int            ex    = EX_OK;
    u_int32_t      ch[pgoblin.symparam];
    pgoblin_nr     rn[pgoblin.symparam];
    u_int32_t      m;
    int            g;
    int            i;
    union {
        pgoblin_rio *io;                     /* io                                                   */
        pgoblin_rdb *c;                      /* conn                                                 */
        pgoblin_rjb *j;                      /* job                                                  */
        pgoblin_rst *s;                      /* style                                                */
        void        *v;
    } rset[pgoblin.symparam];

#   define blin_internal_flags (options->flags & BLIN_MASK)
    ifBLIN_QX2("+ pgm@%"BLIN_D, MULAR_NEXT(pgm->code));
    if  (!pgm || !!strncmp(pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_TST)) {
        ifBLIN_QX0("Illegal pgoblin program %s", pgm->id);
        ERROUT(EX_DATAERR, EPROGMISMATCH);
    }
    if  (!(exenv = calloc(1, sizeof(pgoblin_exenv)))) {
        ifBLIN_QW0("no mem");
        ex = EX_OSERR;
        goto out;
    }
    exenv->flags = options->flags & BLIN_MASK;
    if  (!!dexenv) dexenv->next = exenv;
    exenv->dyna = dexenv;
    exenv->stat = sexenv;
    exenv->pgm = pgm;
    exenv->options = options;
    for (exenv->ppoint = pp; !(exenv->flags & PGOBLIN_END); exenv->ppoint++) {
        u_int32_t                      jobflags;
        pgoblin_tuple                 *command;
        int                            pqjump = 0;
        const struct pgoblin_syntax_a *a_cmd;
        int                            ntyp;
        pgoblin_command                cmd;
        char                          *lit;
        u_int32_t                      t;

    ;   exenv->flags &= PGOBLIN_EXTABLE;
    ;   if  (ex) {
            /*    ,    #trap */
            int            trapdone;
            pgoblin_exenv *ev;

    ;       trapdone = 0;
    ;       for (ev = exenv; ev; ev = ev->stat) {
    ;           if  (ev->flags & PGOBLIN_TRAPDEF) {
    ;               ifBLIN_QX1("%s:%u Trap from %d to %d", finam, lfcount, exenv->ppoint, ev->ctrap);
    ;               if  (!!(ex = pgoblin_execute(options, ev->pgm, exenv, ev->stat, ev->ctrap))) {
    ;                   ifBLIN_QX1("%s:%u Fail in trap PC %d", finam, lfcount, exenv->ppoint);
    ;                   exenv->flags |= PGOBLIN_END | PGOBLIN_ERROR;
    ;               }
    ;               trapdone++;
    ;               break;
    ;       }   }
    ;       if  (!trapdone) {
    ;           ifBLIN_QX0("%s:%u Fail PC %d", finam, lfcount, exenv->ppoint);
    ;           exenv->flags |= PGOBLIN_END | PGOBLIN_ERROR;
    ;   }   }
    ;   if  (((size_t)exenv->ppoint < MULAR_NEXT(exenv->pgm->code)) && !(exenv->flags & PGOBLIN_END)) {
    ;       if  (!(command = mular_getix(exenv->pgm->code, exenv->ppoint))) {
    ;           ifBLIN_QW0("%s:%u mular_getix %d", finam, lfcount, exenv->ppoint);
    ;           ex = EX_SOFTWARE;
    ;           goto out;
    ;       }
    ;       lfcount = command->linum;
    ;       t = command->cmd;
    ;       if  ((cmd = t & PGOBLIN_COMMAND) == PGOBLIN_extended) {
    ;           cmd = (command->ecmd & PGOBLIN_COMMAND) | PGOBLIN_EXTENDED;
    ;           lit = NULL;
    ;       } else {
    ;           lit = command->lit;
    ;       }
    ;       if  (cmd >= pgoblin.max || !(~pgoblin.a[cmd].flags & PGOBLIN_ILLEGAL)) {
    ;           ex = EX_DATAERR;
    ;           ifBLIN_QX0("%s:%u cmd[%d]=%03X unknown", finam, lfcount, exenv->ppoint, cmd);
    ;           continue;
    ;       } else if (!pgoblin.a[cmd].flags) {
    ;           continue;
    ;       } else if (!pgoblin.a[cmd].car) {
    ;           ex = EX_DATAERR;
    ;           ifBLIN_QX1( "%s:%u cmd[%d]=%03X(%s) Undefined"
                          , finam
                          , lfcount
                          , exenv->ppoint
                          , cmd
                          , pgoblin.a[cmd].str
                          );
    ;           continue;
    ;       }
    ;       a_cmd = &(pgoblin.a[cmd]);
    ;       if  (!!exenv->lexlevel) {
    ;           if  (a_cmd->flags & PGOBLIN_LEXLVUP) exenv->lexlevel++;
    ;           if  (a_cmd->flags & PGOBLIN_LEXLDOWN) exenv->lexlevel--;
    ;           continue;
    ;       }
    ;       if  (PGOBLIN_ROLLBACK & exenv->flags) continue;
    ;   } else {
    ;       t = 0;
    ;       lfcount = 0;
    ;       lit = NULL;
    ;       cmd = PGOBLIN_return;
    ;       a_cmd = &(pgoblin.a[cmd]);
    ;       exenv->flags |= PGOBLIN_END;
    ;   }
    ;   ifBLIN_QO2 {
            pgoblin_exenv *c;
            int32_t        d;
            int32_t        s;

    ;       for (s = 0, c = exenv; c; c = c->stat) s++;
    ;       for (d = 0, c = exenv; c; c = c->dyna) d++;
    ;       ifBLIN_QX2( "#### %s:%u (%ds %dd) N%d e%06X f%08X c%03X %s%s%s%s"
                      , finam
                      , lfcount
                      , s
                      , d
                      , exenv->ppoint
                      , exenv->flags
                      , a_cmd->flags
                      , cmd
                      , pgoblin.a[cmd].str
                      , (!lit) ? "" : "="
                      , (!lit) ? "" : lit
                      , (!lit) ? "" : "~"
                      );
    ;   }
    ;   for (i = 0; i < pgoblin.symparam; i++) {
            int   b;

    ;       if  (0 > (b = pgoblin_breg(cmd, i))) {
    ;           ch[i] = 0;
    ;           rn[i] = 0;
    ;           if  ((a_cmd->flags & pgoblin.p[i].val) || (i == PGO_CJOB)) {
    ;               switch(i) {
    ;               case PGO_CSTY: rset[i].s = pgoblin_upsty(options, 0); break;
    ;               case PGO_CJOB: rset[i].j = pgoblin_upjob(options, 0); break;
    ;               case PGO_CCON: rset[i].c = pgoblin_upcon(options, 0); break;
    ;               default:       rset[i].io = pgoblin_upio(options, 0); break;
    ;               }
    ;           } else {
    ;               rset[i].v = NULL;
    ;           }
    ;       } else {
    ;           ch[i] = a_cmd->ch[b];
    ;           rn[i] = (t >> pgoblin.binparams[b]) & PGOBLIN_ARGMASK;
    ;           switch(i) {
    ;           case PGO_CSTY:
    ;               rset[i].s = pgoblin_upsty(options, rn[i]);
    ;               break;
    ;           case PGO_CJOB:
    ;               rset[i].j = pgoblin_upjob(options, !(ch[i] & PGOBLIN_JOB) ? 0 : rn[i]);
    ;               break;
    ;           case PGO_CCON:
    ;               rset[i].c = pgoblin_upcon(options, rn[i]);
    ;               break;
    ;           default:
    ;               rset[i].io = pgoblin_upio(options, rn[i]);
    ;               break;
    ;   }   }   }
    ;   ifBLIN_QX2("Registers:");
    ;   ifBLIN_QO2 for (i = 0; i < pgoblin.symparam; i++) {
            char *fico = "# 012345678";
            char *sco  = &fico[2];
            int   b;

    ;       b = pgoblin_breg(cmd, i);
    ;       ifBLIN_QX2( "%s%c%s%d[%c] %s %"BLIN_X" (%02X%s%s%s%s%s%s%s%s) %08X%s%s=%s%s"
                      , (0 > b) ? "   " : ""
                      , sco[b]
                      , (0 > b) ? "" : "->"
                      , i
                      , pgoblin_regn[rn[i]]
                      , pgoblin.p[i].name
                      , BLIN_I((rset[i].v))
                      , ch[i]
                      , (ch[i] & PGOBLIN_STYLE   ) ? " sty"  : ""
                      , (ch[i] & PGOBLIN_JOB     ) ? " job"  : ""
                      , (ch[i] & PGOBLIN_CONNECT ) ? " db"   : ""
                      , (ch[i] & PGOBLIN_OUTSET  ) ? " out"  : ""
                      , (ch[i] & PGOBLIN_PQRESULT) ? " pq"   : ""
                      , (ch[i] & PGOBLIN_MIFEDES ) ? " mife" : ""
                      , (ch[i] & PGOBLIN_TEXTPARM) ? " text" : ""
                      , (ch[i] & PGOBLIN_PATHPARM) ? " path" : ""
                      , (!!rset[i].v) ? ( (PGO_CSTY == i)
                                      ? rset[i].s->flags
                                      : (PGO_CJOB == i)
                                      ? rset[i].j->flags
                                      : (PGO_CCON == i)
                                      ? rset[i].c->flags
                                      : 0
                                      )
                      : 0
                      , (!!rset[i].v) ? ( (PGO_CSTY == i)
                                        ? ((!STYLS(rset[i].s->flags)) ? "" : "+")
                                        : (PGO_CJOB == i)
                                        ? ((!JOBE(rset[i] .j->flags)) ? "" : "+")
                                        : (PGO_CCON == i)
                                        ? ((!DBASE(rset[i].c->flags)) ? "" : "+")
                                        : ""
                                        )
                      : ""
                      , (!!rset[i].v) ? ( ( PGO_CSTY == i)
                                        ? ( (!STYLS(rset[i].s->flags))
                                          ? "-"
                                          : STYLS(rset[i].s->flags)->name
                                          )
                                        : (PGO_CJOB == i)
                                        ? ( (!JOBE(rset[i] .j->flags))
                                          ? "-"
                                          : JOBE(rset[i] .j->flags)->name
                                          )
                                        : (PGO_CCON == i)
                                        ? ( (!DBASE(rset[i].c->flags))
                                          ? "-"
                                          : DBASE(rset[i].c->flags)->name
                                          )
                                        : ""
                                        )
                      : ""
                      , (!!rset[i].v) ? ( (PGO_CJOB == i)
                                        ? ((!rset[i].j->host  ) ? "" : rset[i].j->host)
                                        : (PGO_CCON == i)
                                        ? ((!rset[i].c->dbname) ? "" : rset[i].c->dbname)
                                        : ""
                                        )
                      : ""
                      , (!!rset[i].v) ? ( (PGO_CJOB == i)
                                        ? ((!rset[i].j->host  ) ? "" : "~")
                                        : (PGO_CCON == i)
                                        ? ((!rset[i].c->dbname) ? "" : "~")
                                        : ""
                                        )
                      : ""
                      );
    ;       switch(i) {
            case PGO_CSTY:
    ;       case PGO_CJOB:
    ;       case PGO_CCON:
    ;           break;
    ;       default:
    ;           dump_ioreg(options, rn[i]);
    ;   }   }
    ;   pgoblin_toexe(cmd, exenv, rn);
    ;   ifBLIN_QO3 {
    ;       ifBLIN_QX3("exenv->flags=%08X", exenv->flags);
    ;       DUMPIOREGS;
    ;   }
    ;   /**************************
    ;    *   OUT *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_OUTSET) {
    ;       if  (!(ch[PGO_COUT] & PGOBLIN_OUTSET)) {
    ;           if  (!!RNOUT) {
    ;               if  ((ex = cleareg(exenv, RNOUT, PGOBLIN_PATHPARM | PGOBLIN_OUTSET))) {
    ;                   CICLEWARN(0, "Not clear path|wri OUT");
    ;           }   }
    ;       } else if ((ex = propush(exenv, RNOUT, ch[PGO_COUT]))) {
    ;           CICLEWARN(0, "No propush");
    ;       } else if ((RNOUT == RNCTL) || (RNOUT == RNIN)) {
    ;               /* copy XXXX */
    ;   }   }
    ;   /**************************
    ;    *   CTL *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_CTL) {
    ;       if  (ch[PGO_CCTL] & PGOBLIN_OUTSET) {
    ;           ex = EX_SOFTWARE;
    ;           CICLEWARN(1, "CTL&out");
    ;       } else if (!!RNCTL) {
    ;           if  (  (RNCTL == RNOUT)
                    && ( ch[PGO_CCTL]
                       & ch[PGO_COUT]
                       & (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT)
                    )  ) {
    ;               ifBLIN_QX1( "%s:%u cmd[%d]=[%03X(%s)]    "
                              , finam
                              , lfcount
                              , exenv->ppoint
                              , cmd
                              , a_cmd->str
                              );
    ;           }
    ;           if  (!(IO_CTL->flags & PGOBLIN_ANYIVL)) {
    ;               if  (RNCTL != RNIN) exenv->flags |= PGOBLIN_FORKCTL;
    ;           } else if (!!(ex = coercion(exenv, RNCTL, ch[PGO_CCTL]))) {
    ;               CICLEWARN(1, "No coercion CTL");
    ;           }
    ;       } else if ((ch[PGO_CCTL] & PGOBLIN_TEXTPARM)) {
    ;           if  ((ex = cleareg(exenv, RNCTL, PGOBLIN_TEXTPARM))) {
    ;               CICLEWARN(1, "Not ready text CTL");
    ;           }
    ;           if  (!lit) {
    ;               MARK_IO_TEXT_GO(RNCTL);;
    ;               ;;  IO_CTL->text = NULL;
    ;               ;;  IO_CTL->length = 0;
    ;               ;;  IO_CTL->flags &= ~(PGOBLIN_BINPARM | PGOBLIN_FREETEXT | PGOBLIN_TEXTPARM);
    ;               MARK_IO_TEXT_WENT(RNCTL);;
    ;           } else if (!(pgm->flags & PGOBLIN_FREETEXT)) {
    ;               MARK_IO_TEXT_GO(RNCTL);;
    ;               ;;  IO_CTL->text = lit;
    ;               ;;  IO_CTL->length = strlen(lit);
    ;               ;;  IO_CTL->flags &= ~(PGOBLIN_BINPARM | PGOBLIN_FREETEXT);
    ;               MARK_IO_TEXT_WENT(RNCTL);;
    ;           } else {
    ;               MARK_IO_TEXT_GO(RNCTL);;
    ;               ;;  IO_CTL->text = strdup(lit);
    ;               ;;  IO_CTL->length = strlen(lit);
    ;               ;;  IO_CTL->flags &= ~PGOBLIN_BINPARM;
    ;               ;;  IO_CTL->flags |= PGOBLIN_FREETEXT;
    ;               MARK_IO_TEXT_WENT(RNCTL);;
    ;           }
    ;       } else if ((ch[PGO_CCTL] & PGOBLIN_PQRESULT)) {
                const char **cell;
                int i, c;
    ;
    ;           if  ((ex = cleareg(exenv, RNCTL, PGOBLIN_PQRESULT))) {
    ;               CICLEWARN(1, "Not ready pq CTL");
    ;           }
    ;           for (i = 0; ; i++) {
    ;               c = i;
    ;               if  ((size_t)(exenv->ppoint + c) >= MULAR_NEXT(exenv->pgm->code)) break;
    ;               if  (!(command = mular_getix(exenv->pgm->code, exenv->ppoint + c))) {
    ;                   ifBLIN_QW0("%s:%u mular_getix %d", finam, lfcount, exenv->ppoint);
    ;                   ex = EX_SOFTWARE;
    ;                   goto out;
    ;               }
    ;               if  (c && (command->cmd != PGOBLIN_cont)) break;
    ;               if  (!command->lit) break;
    ;           }
    ;           if  (c) {
    ;               if  (!(cell = malloc(c * sizeof(char**)))) { CICLEWARN(1, "No mem for Pq"); }
    ;               for (i = 0; i < c; i++) {
    ;                   if  (!(command = mular_getix(exenv->pgm->code, exenv->ppoint + i))) {
    ;                       ifBLIN_QW0("%s:%u mular_getix %d", finam, lfcount, exenv->ppoint);
    ;                       ex = EX_SOFTWARE;
    ;                       goto out;
    ;                   }
    ;                   cell[i] = command->lit;
    ;               }
    ;               MARK_IO_PQ_GO(RNCTL);;
    ;               ;;  pgoblin_db0_create(exenv, rn[PGO_CCTL], c, cell, NULL);
    ;               ;;  IO_CTL->flags |= PGOBLIN_FREEPQRE;
    ;               ;;  IO_CTL->cortege = -1;
    ;               MARK_IO_PQ_WENT(RNCTL);;
    ;               free(cell);
    ;           }
    ;           pqjump = pgoblin_db_resinfo(exenv, rn[PGO_CCTL], PGOBLIN_Nfields) - 1;
    ;       } else if ((ex = coercomp(options, IO_CTL, ch[PGO_CCTL]))) {
    ;           CICLEWARN(1, "Not compatible CTL");
    ;   }   }
    ;   /**************************
    ;    *    IN *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_ISIN) {
    ;       if  (ch[PGO_CIN] & PGOBLIN_OUTSET) {
    ;           if  (!!RNIN) {
                    if  ((ex = cleareg(exenv, RNIN, PGOBLIN_PATHPARM | PGOBLIN_MIFEDES))) {
    ;                   CICLEWARN(2, "Not clear path|mife IN");
    ;           }   }
    ;       } else if (!!RNIN) {
    ;           if  (  (RNIN == RNOUT)
                    && ( ch[PGO_CIN]
                       & ch[PGO_COUT]
                       & (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT)
                    )  ) {
    ;               ifBLIN_QX1( "%s:%u cmd[%d]=[%03X(%s)]    "
                              , finam
                              , lfcount
                              , exenv->ppoint
                              , cmd
                              , a_cmd->str
                              );
    ;           }
    ;           if  (!(IO_IN->flags & PGOBLIN_ANYIVL)) {
    ;               exenv->flags |= PGOBLIN_FORKIN;
    ;           } else if (!!(ex = coercion(exenv, RNIN, ch[PGO_CIN]))) {
    ;               CICLEWARN(2, "No coercion IN");
    ;           }
    ;       } else if ((ex = coercomp(options, IO_IN, ch[PGO_CIN] & ~PGOBLIN_PQRESULT))) {
    ;           CICLEWARN(2, "Not compatible IN");
    ;   }   }
    ;   /***************************
    ;    *   CONN *
    ;    ***************************/
    ;   if  (a_cmd->flags & PGOBLIN_CONNECT) {
    ;       if  (ch[PGO_CCON] & PGOBLIN_OUTSET) {
    ;           if  (RNCON) {
    ;               pgoblin_db_finish(exenv, rn[PGO_CCON]);
    ;               MARK_R_CONN_GO(RNCON);;
    ;               ;;  if  (R_CONN->flags & PGOBLIN_PARMDBFREE) free((char*)R_CONN->dbname);
    ;               ;;  R_CONN->conn = NULL;
    ;               ;;  R_CONN->flags = (options->flags & BLIN_MASK)
                /*  ;;  */            | (pgoblin_mecon(options, 0)->flags & PGOBLIN_DB_TYPE)
    ;               ;;  ;
    ;               ;;  R_CONN->dbname = NULL;
    ;               ;;  R_CONN->host = NULL;
    ;               ;;  R_CONN->port = NULL;
    ;               ;;  R_CONN->username = NULL;
    ;               ;;  R_CONN->intran = 0;
    ;               MARK_R_CONN_WENT(RNCON);;
    ;           }
    ;       } else {
    ;           MARK_R_CONN_GO(RNCON);;
    ;           ;;  R_CONN->flags = (options->flags & BLIN_MASK) | (R_CONN->flags & ~BLIN_MASK);
    ;           MARK_R_CONN_WENT(RNCON);;
    ;           if  ((ex = pgoblin_db_shurecon(exenv, rn[PGO_CCON]))) {
    ;               CICLEWARN(3, "Not connected");
    ;   }   }   }
    ;   /**************************
    ;    *   JOB *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_JOB) {
    ;       if  (ch[PGO_CJOB] & PGOBLIN_OUTSET) {
    ;           if  (!!RNJOB) {
    ;               ex = JOBE(R_JOB->flags)->jose(exenv, rn);
    ;               MARK_R_JOB_GO(RNJOB);;
    ;               ;;  mular_destroy(R_JOB->pids);
    ;               ;;  R_JOB->pids = NULL;
    ;               ;;  R_JOB->host = NULL;
    ;               ;;  R_JOB->concur = 0;
    ;               ;;  R_JOB->dead = 0;
    ;               ;;  if  (R_JOB->flags & PGOBLIN_KQUEUED) close(R_JOB->kq);
    ;               ;;  R_JOB->flags = options->flags & BLIN_MASK;
    ;               MARK_R_JOB_WENT(RNJOB);;
    ;               if  (ex) {
    ;                   CICLEERR("Close JOB");
    ;                   continue;
    ;           }   }
    ;       } else if (  !(R_JOB->pids)
                      && !(R_JOB->pids = mular_create(MULAR_ZERO, 3, sizeof(pgoblin_jobl), u12))
                      ) {
    ;           ex = EX_SOFTWARE;
    ;           CICLEERR("No JOB");
    ;           continue;
    ;   }   }
    ;   /****************************
    ;    *   STYLE *
    ;    ****************************/
    ;   if  (a_cmd->flags & PGOBLIN_STYLE) {
    ;       if  (ch[PGO_CSTY] & PGOBLIN_OUTSET) {
    ;           if  (!!RNSTY) {
    ;               MARK_R_STYLE_GO(RNSTY);;
    ;               ;;  if  (R_STYLE->style) STYLS(R_STYLE->flags)->clear(exenv, rn[PGO_CSTY]);
    ;               ;;  R_STYLE->style = NULL;
    ;               ;;  R_STYLE->path = NULL;
    ;               ;;  R_STYLE->flags = options->flags & BLIN_MASK;
    ;               MARK_R_STYLE_WENT(RNSTY);;
    ;   }   }   }
    ;   /******************************
    ;    *     *
    ;    ******************************/
    ;   if  (exenv->flags & PGOBLIN_FORKIN) {
    ;       ifBLIN_QX2("FORKIN")
    ;       if  (!!(ex = pipe(options->pip2))) {
    ;           CICLEERR("pipe #2");
    ;           close(options->pip2[0]);
    ;           close(options->pip2[1]);
    ;           continue;
    ;   }   }
    ;   if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;       ifBLIN_QX2("FORKCTL")
    ;       if  (!!(ex = pipe(options->pip1))) {
    ;           CICLEERR("pipe #1");
    ;           close(options->pip1[0]);
    ;           close(options->pip1[1]);
    ;           continue;
    ;   }   }
    ;   if  (exenv->flags & PGOBLIN_FORKOUT) {
    ;       ifBLIN_QX2("FORKOUT")
    ;       if  (!!(ex = pipe(options->pip0))) {
    ;           CICLEERR("pipe #0");
    ;           close(options->pip0[0]);
    ;           close(options->pip0[1]);
    ;           continue;
    ;   }   }
    ;   ifBLIN_QO3 {
    ;       ifBLIN_QX3("exenv->flags=%08X", exenv->flags);
    ;       DUMPIOREGS;
    ;   }
    ;   /*******************************
    ;    *     *
    ;    *******************************/
    ;   ntyp = 1;
    ;   jobflags = PGOBLIN_TOEXIT;
    ;   if  ((cmd == PGOBLIN_exec) && !!RNCTL) {
    ;       ntyp = pgoblin_db_resinfo(exenv, rn[PGO_CCTL], PGOBLIN_Ntuples);
    ;   }
    ;   if  (a_cmd->flags & PGOBLIN_FORKED) jobflags = JOBE(R_JOB->flags)->jest(exenv, cmd);
    ;   if  (exenv->flags & (PGOBLIN_FORKIN | PGOBLIN_FORKCTL | PGOBLIN_FORKOUT)) {
    ;       jobflags |= PGOBLIN_TOFORK;
    ;   }
    ;   for (int sequen = 0; (sequen < ntyp) && !ex; sequen++) {
    ;       if  (!(jobflags & (PGOBLIN_TVFORK | PGOBLIN_TOFORK))) {
    ;           ifBLIN_QX2( "e%06X DO x %d(%d) c%03X %s"
                          , exenv->flags, ntyp, sequen, cmd, a_cmd->str
                          );
    ;           ex = pgoblin_cmdexe(cmd, exenv, rn);
    ;           ifBLIN_QX3("DONE %d", ex);
    ;       } else {
    ;       ;   ifBLIN_QX2( "e%06X FORK x %d(%d) c%03X %s"
                          , exenv->flags, ntyp, sequen, cmd, a_cmd->str
                          );
    ;       ;   if  (R_JOB->concur && (MULAR_NEXT(R_JOB->pids) >= (R_JOB->concur + R_JOB->dead))) {
    ;       ;       if  ((ex = waitjob(exenv->options, RNJOB))) {
    ;       ;           CICLEERR("waitjob");
    ;       ;           continue;
    ;       ;   }   }
    ;       ;   /*  if  ((ex = ((jobflags & PGOBLIN_TOFORK) ? fork() : vfork())) < 0) { */
    ;       ;   if  (!(pgoblin.a[cmd].flags & PGOBLIN_JOB)) {
    ;       ;       CICLEWARN(2, "fork without Ij");
    ;       ;   }
    ;       ;   if  ((ex = fork()) < 0) {
    ;       ;       CICLEERR("fork #1");
    ;       ;       continue;
    ;       ;   } else if (ex == 0) {
    ;       ;       ifBLIN_QX3("FORK CHILD");
    ;       ;       /*********************************
    ;       ;        * ,    *
    ;       ;   ;    *********************************/
    ;       ;   ;   for (int g = 0; g < pgoblin.regsize; g++) {
                        pgoblin_rdb *con;

    ;       ;   ;       if  (!!(con = pgoblin_mecon(options, g))) con->flags &= ~PGOBLIN_CLOSECONN;
    ;       ;   ;   }
    ;       ;   ;   if  (!!(pgoblin.a[cmd].flags & PGOBLIN_CTLCORTG)) {
    ;       ;   ;       MARK_IO_PQ_GO(RNCTL);;
    ;       ;   ;       ;;  IO_CTL->cortege = sequen;
    ;       ;   ;       MARK_IO_PQ_WENT(RNCTL);;
    ;       ;   ;   }
    ;       ;   ;   exenv->flags |= PGOBLIN_FORKED | PGOBLIN_CHILD;
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;       ;   ;       ifBLIN_QX0("%s:%u fork with CTL", finam, lfcount);
    ;       ;   ;       ex = -EX_SOFTWARE;
    ;       ;   ;       exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKIN) {
    ;       ;   ;       if  ((ex = pgoblin_inx(exenv, rn[PGO_CIN], options->pip2, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;       ;   ;       if  ((ex = pgoblin_inx(exenv, rn[PGO_CCTL], options->pip1, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKOUT) {
    ;       ;   ;       if  ((ex = pgoblin_outx(exenv, rn[PGO_COUT], options->pip0, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->options->flags & PGOBLIN_FORK_WAIT) {
    ;       ;   ;       ifBLIN_QX2( "sleep %us in fork"
                                  , exenv->options->flags & PGOBLIN_FORK_WAIT
                                  );
    ;       ;   ;       sleep(exenv->options->flags & PGOBLIN_FORK_WAIT);
    ;       ;   ;   }
    ;       ;   ;   ex = pgoblin_cmdexe(cmd, exenv, rn);
    ;       ;       ifBLIN_QX3("CHILD DONE %d", ex);
    ;       ;       if  (jobflags & PGOBLIN_TOEXIT) exit(ex);
    ;       ;   } else {
                    pgoblin_jobl *j;
    ;       ;       ifBLIN_QX3("FORK DONE %d", ex);
    ;       ;       MARK_R_JOB_GO(RNJOB);;
    ;       ;       ;;  j = mular_add(R_JOB->pids);
    ;       ;       ;;  j->cmdn = exenv->ppoint;
    ;       ;       ;;  j->pid = ex;
    ;       ;       ;;  j->status = PGOBLIN_NOSTATUS;
    ;       ;       MARK_R_JOB_WENT(RNJOB);;
    ;       ;       if  (cmd == PGOBLIN_fork) exenv->lexlevel++;
    ;       ;       ex = 0;
    ;   }   }   }
    ;   if  (!(exenv->flags & PGOBLIN_CHILD)) {
    ;       if  (exenv->flags & PGOBLIN_FORKIN) {
    ;           if  ((ex = pgoblin_outx(exenv, rn[PGO_CIN], options->pip2, 1))) continue;
    ;       }
    ;       if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;           if  ((ex = pgoblin_outx(exenv, rn[PGO_CCTL], options->pip1, 1))) continue;
    ;       }
    ;       if  (exenv->flags & PGOBLIN_FORKOUT) {
    ;           close(options->pip0[1]);
    ;           MARK_IO_MIFE_GO(RNOUT);;
    ;           ;;  if  (  !(IO_OUT->mife = mife_init(PGOBLIN_MIFEFLAGS))) {
    ;           ;;      ex = EX_NOINPUT;
    ;           ;;      CICLEERR("mife_init");
    ;           ;;  } else if (0 > mife_ctlfdsc(IO_OUT->mife, options->pip0[0])) {
    ;           ;;      mife_fini(IO_OUT->mife);
    ;           ;;      ex = EX_NOINPUT;
    ;           ;;      CICLEERR("mife_ctlfdsc");
    ;           ;;  } else {
    ;           ;;      IO_OUT->pid = 0;
    ;           ;;      IO_OUT->flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
    ;           ;;  }
    ;           MARK_IO_MIFE_WENT(RNOUT);;
    ;   }   }
    ;   if  (ex) continue;
    ;   /*****************************
    ;    *  IO_OUT  *
    ;    *****************************/
    ;   if  (a_cmd->flags & PGOBLIN_OUTSET) {
    ;       ifBLIN_QO3 {
    ;   ;       ifBLIN_QX3("exenv->flags %08X", exenv->flags);
    ;   ;       dump_ioreg(options, rn[PGO_COUT]);
    ;   ;       if  (!ch[PGO_COUT] && !rn[PGO_COUT]) dump_ioreg(options, 0);
    ;   ;   }
    ;   ;   if  (exenv->flags & PGOBLIN_FREEPATH) {
                off_t off;
                mife_descriptor *md;
                char *cont;
                ssize_t bl;

    ;   ;       if  (!(IO_OUT->path)) {
    ;   ;           CICLEWARN(0, "unload no path");
    ;   ;       }
    ;   ;       md = mife_init(((PGOBLIN_RAWIOBUFL << 8) & MIFE_BUFL) | MIFE_BUFX);
    ;   ;       if  (!md || (0 > mife_ctlfile(md, IO_OUT->path))) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload mife init");
    ;   ;           continue;
    ;   ;       }
    ;   ;       for (off = 0; !(md->flags & MIFE_EOFL); off += bl) {
    ;   ;           bl = mife_read(md, (ssize_t)(1 << (PGOBLIN_RAWIOBUFL + 16)), off);
    ;   ;           if  (bl < 0) {
    ;   ;               ifBLIN_QW0("%s:%u unload mife read %s:", finam, lfcount, IO_OUT->path);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;           }
    ;   ;           if  (!(cont = mife_get(md, off))) {
    ;   ;               ifBLIN_QW0("%s:%u unload mife get %s:", finam, lfcount, IO_OUT->path);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;           }
    ;   ;           if  (IO_OUT->wri(IO_OUT->onu, cont, bl) < 0) {
    ;   ;               ifBLIN_QW0("%s:%u unload mife write", finam, lfcount);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;       }   }
    ;   ;       if  (ex) continue;
    ;   ;       if  (mife_fini(md)) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload close");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(exenv, RNOUT, PGOBLIN_PATHPARM);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->path not cleared");
    ;   ;   }
    ;   ;   if  (exenv->flags & PGOBLIN_FREETEXT) {
    ;   ;       if  (!(IO_OUT->text)) {
    ;   ;           CICLEWARN(0, "unload no text");
    ;   ;       }
    ;   ;       ex = IO_OUT->wri(IO_OUT->onu, IO_OUT->text, IO_OUT->length);
    ;   ;       if  (ex < 0) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload text write");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(exenv, RNOUT, PGOBLIN_TEXTPARM);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->text not cleared");
    ;   ;   }
    ;   ;   if  (exenv->flags & PGOBLIN_FREEPQRE) {
    ;   ;       if  (!(IO_OUT->pq)) {
    ;   ;           CICLEWARN(0, "unload no pq");
    ;   ;       }
    ;   ;       ex = STYLS(pgoblin_load(options, 5, "0", -1))->table( exenv
                                                                    , 0
                                                                    , rn[PGO_COUT]
                                                                    , rn[PGO_COUT]
                                                                    , 0
                                                                    , -2
                                                                    );
    ;   ;       if  (ex < 0) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload pq");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(exenv, RNOUT, PGOBLIN_PQRESULT);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->pq not cleared");
    ;   ;   }
    ;   ;   if  (!RNOUT) {
    ;   ;       if  (IO_OUT->path && !(IO_OUT->flags & PGOBLIN_PATHPARM)) {
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_PATHPARM);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->path not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->text && !(IO_OUT->flags & PGOBLIN_TEXTPARM)) {
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_TEXTPARM);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->text not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->pq && !(IO_OUT->flags & PGOBLIN_PQRESULT)) {
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_PQRESULT);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->pq not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->mife && !(IO_OUT->flags & PGOBLIN_MIFEDES)) {
    ;   ;           ifBLIN_QX0("%s:%u Clear mife in io[0]", finam, lfcount);
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_MIFEDES);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->mife not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->wri && !(IO_OUT->flags & PGOBLIN_OUTSET)) {
    ;   ;           ifBLIN_QX0("%s:%u Clear wri in io[0]", finam, lfcount);
    ;   ;           ex = cleareg(exenv, RNOUT, PGOBLIN_OUTSET);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->wri not cleared");
    ;   ;   }   }
    ;   ;   ifBLIN_QO3 {
    ;   ;       dump_ioreg(options, rn[PGO_COUT]);
    ;           if  (!ch[PGO_COUT] && !rn[PGO_COUT]) dump_ioreg(options, 0);
    ;   }   }
    ;   if  ((a_cmd->flags & PGOBLIN_CTL) && !RNCTL && (ch[PGO_CCTL] & PGOBLIN_TEXTPARM)) {
    ;       ex = cleareg(exenv, RNCTL, PGOBLIN_TEXTPARM);
    ;       if  (ex) CICLEWARN(0, "0 IO_CTL->text not cleared");
    ;   }
    ;   if  (pqjump > 0) exenv->ppoint += pqjump;
    ;   ifBLIN_QO0 iorassert(exenv, cmd, lfcount, finam);
    ;   if  (PGOBLIN_end == cmd) {
    ;       exenv->flags &= ~PGOBLIN_ROLLBACK;
    }   }
    if  (!ex && (exenv->flags & PGOBLIN_ERROR)) ex = -1;
    if  (!!dexenv) {
        dexenv->next = NULL;
    } else if (options->flags & PGOBLIN_CLEAR_ONEXIT) {
        for (g = 0; g < pgoblin.regsize; g++) {
            pgoblin_rdb *rdb;
            pgoblin_rjb *rjb;
            pgoblin_rst *rst;

            m = PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT;
            if  (g) m |= PGOBLIN_OUTSET | PGOBLIN_MIFEDES;
            cleareg(exenv, g, m);
            if  (  !!(rdb = pgoblin_mecon(exenv->options, g))
                && !!DBASE(rdb->flags)
                && (rdb->flags & PGOBLIN_CLOSECONN)
                ) {
                MARK_R_CONN_GO(g);;
                ;;  pgoblin_db_finish(exenv, rn[PGO_CCON]);
                ;;  rdb->conn = NULL;
                ;;  rdb->flags &= options->flags & BLIN_MASK;
                ;;  rdb->intran = 0;
                MARK_R_CONN_WENT(g);;
            }
            if  (!!(rjb = pgoblin_mejob(exenv->options, g)) && !!JOBE(rjb->flags)) {
                MARK_R_JOB_GO(g);;
                ;;  mular_destroy(rjb->pids);
                ;;  rjb->pids = NULL;
                ;;  if  (rjb->flags & PGOBLIN_HOSTJFREE) free(rjb->host);
                ;;  rjb->host = NULL;
                ;;  rjb->concur = 0;
                ;;  rjb->dead = 0;
                ;;  rjb->flags = options->flags & BLIN_MASK;
                MARK_R_JOB_WENT(g);;
            }
            if  (!!(rst = pgoblin_mesty(exenv->options, g)) && !!STYLS(rst->flags)) {
                MARK_R_STYLE_GO(g);;
                ;;  STYLS(rst->flags)->clear(exenv, g);
                ;;  rst->style = NULL;
                ;;  rst->path = NULL;
                ;;  rst->flags &= ~PGOBLIN_STYLE_TYPE;
                MARK_R_STYLE_WENT(g);;
    }   }   }
out:
    if  (exenv) free(exenv);
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
};
