/*-
 * Copyright (C)2008..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: db_0.c,v 1.90 2022/01/08 22:59:07 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_MODULE   2
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

#define INDX(R, C) ((R) * rio->pq->ncol + (C))  /*           */

                                           /* Pc  db_0  NULL                                */
struct pgoblin_realpq {                      /*  Pq                                           */
    BLIN_flag flags;
/*            PGOBLIN_DB_TYPE               *                                                        */
#   define    PGOBLIN_DB_0FREEC 0x010000   /*     free()                       */
#   define    PGOBLIN_DB_0FREEA 0x020000   /* cell  free()                                       */
#   define    PGOBLIN_DB_0FREES 0x040000   /* serv  free()                                       */
#   define    PGOBLIN_DB_0FREET 0x080000   /*   serv  free()                          */
#   define    PGOBLIN_DB_0FREEL 0x100000   /* llen  free()                                       */
#   define    PGOBLIN_DB_0INDIR 0xC00000   /*   Pq    Pq (1),  (2), (3)  */
    int       ncol;                        /*                               */
    char    **cell;                        /*                */
    size_t   *llen;                        /*        *
                                            *  ,         *
                                            *  strlen()                                  */
    char    **serv;                        /*  ͣ                                */
    int       nrow;                        /*                                 */
};

pgoblin_realpq *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db00(BLIN_flag flags) {                                     /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_realpq *rsv = NULL;

#   define blin_internal_flags (flags & BLIN_MASK)
    if  (!(rsv = calloc(1, sizeof(pgoblin_realpq)))) {
        ifBLIN_QW0("");
    } else {
        rsv->flags = (flags & BLIN_MASK) | pgoblin_load(pgoblin_options, 3, "0", -1);
    }
    return(rsv);
#   undef blin_internal_flags
}

static pgoblin_realpq *
/**********************************************************************
 **                                                                  **/
resv(pgoblin_rdb *rdb) {                                            /**
 **                                                                  **
 **********************************************************************/
    return(pgoblin_db00(rdb->flags));
}

int
/**********************************************************************
 **                                                                  **/
pgoblin_db0_create( pgoblin_exenv      *exenv                       /**/
/**/              , pgoblin_nr          nou                         /**/
/**/              , int                 cnt                         /**/
/**/              , const char * const *val                         /**/
/**/              , const int          *len                         /**/
/**/              ) {                                               /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio   *rou;
    int            ex = EX_OK;

    GET_RIO(rou, exenv->options, nou);
    rou->pq = pgoblin_db00( (exenv->options->flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
                          | (pgoblin_db_0.flags & (BLIN_MASK | PGOBLIN_DB_TYPE))
                          );
    if  (!rou->pq) {
        ifBLIN_QX0("No mem #1");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else if (!(rou->pq->llen = malloc(cnt * sizeof(size_t)))) {
        free(rou->pq);
        ifBLIN_QX0("No mem #2");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else if (!(rou->pq->cell = malloc(cnt * sizeof(char*)))) {
        free(rou->pq->llen);
        free(rou->pq);
        ifBLIN_QX0("No mem #3");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else {
        rou->pq->flags |= PGOBLIN_DB_0FREEL | PGOBLIN_DB_0FREEC | PGOBLIN_DB_0FREEA;
        rou->pq->nrow = 1;
        rou->pq->ncol = cnt;
        for (int i = 0; i < cnt; i++) {
            if  (!val || !val[i]) {
                rou->pq->cell[i] = NULL;
                rou->pq->llen[i] = 0;
            } else if (!len || (len[i] < 0)) {
                rou->pq->cell[i] = strdup(val[i]);
                rou->pq->llen[i] = strlen(val[i]);
            } else {
                rou->pq->cell[i] = malloc(len[i] + 1);
                bcopy(val[i], rou->pq->cell[i], len[i]);
                rou->pq->cell[i][len[i]] = '\0';
                rou->pq->llen[i] = len[i];
    }   }   }
out:
    if  (!!ex) rou->pq = NULL;
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
init(pgoblin_main *options, int slot) {                             /**
 **                                                                  **
 **********************************************************************/
    pgoblin_db_0.flags = (pgoblin_db_0.flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
                       | (options->flags & BLIN_MASK)
                       | (slot & PGOBLIN_DB_TYPE)
    ;
    return(0);
}

static int
/**********************************************************************
 **                                                                  **/
fini(pgoblin_main *options) {                                       /**
 **                                                                  **
 **********************************************************************/
    return(0);
}

static int
/**********************************************************************
 **                                                                  **/
shurecon(pgoblin_exenv *exenv, pgoblin_nr ndb) {                    /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rdb *rdb;
    int          ex = EX_OK;

    GET_CON(rdb, exenv->options, ndb);
    MARK_R_CONN_GO(ndb);;
    ;;  rdb->conn = NULL;                                                              /* Pc  */
    ;;  rdb->flags = (rdb->flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
 /* ;; */          | (pgoblin_db_0.flags & (BLIN_MASK | PGOBLIN_DB_TYPE))
    ;;  ;
    MARK_R_CONN_WENT(ndb);;
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/********************************************************************************
 **                                                                            **/
query(pgoblin_exenv *exenv, pgoblin_nr ndb, pgoblin_nr nou, pgoblin_nr nct) { /**
 **                                                                            **
 ********************************************************************************
 **  #select      NULL,                       **
 **    qry "rows cols"                                             **
 ********************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rdb   *rdb;
    pgoblin_rio   *rou;
    pgoblin_rio   *rct;
    int            ex = EX_OK;
    char          *q;

    GET_CON(rdb, exenv->options, ndb);
    GET_RIO(rou, exenv->options, nou);
    GET_RIO(rct, exenv->options, nct);
    if  (!(rou->pq = resv(rdb))) {
        ifBLIN_QX0("No mem");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else if (rct->text) {
        rou->pq->nrow = strtoul(rct->text, &q, 0);
        rou->pq->ncol = strtoul(q, &q, 0);
    }
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
 **                                                                                                 **/
execute(pgoblin_exenv *exenv, pgoblin_nr ndb, pgoblin_nr nou, pgoblin_nr nct, pgoblin_nr nin) {    /**
 **                                                                                                 **
 *****************************************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rdb *rdb;
    pgoblin_rio *rou;
    int          ex = EX_SOFTWARE;

    GET_CON(rdb, exenv->options, ndb);
    GET_RIO(rou, exenv->options, nou);
    if  (!(rou->pq = resv(rdb))) {
        ifBLIN_QX0("No mem #1");
        errno = ENOMEM;
        ex = EX_OSERR;
    }
out:
    return(ex);
#   undef blin_internal_flags
}

static int64_t
/**********************************************************************
 **                                                                  **/
resinfo(pgoblin_exenv *exenv, pgoblin_nr nio, int kind) {           /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio  *rio;
    int64_t       ex = 0;

    GET_RIO(rio, exenv->options, nio);
    if  (!rio->pq) {
        errno = EFAULT;
        ex = -1;
    } else {
        switch (kind) {
        case PGOBLIN_Ntuples:
            ex = rio->pq->nrow;
            break;
        case PGOBLIN_Nfields:
            ex = rio->pq->ncol;
            break;
        default:
            ex = -1;
            errno = ENOTSUP;
    }   }
out:
    return(ex);
#   undef blin_internal_flags
}

static const char *
/**************************************************************************
 **                                                                      **/
subinfo(pgoblin_exenv *exenv, pgoblin_nr nio, int kind, int64_t sub) {  /**
 **                                                                      **
 **************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio  *rio;
    const char   *cx = NULL;

    GET_RIO(rio, exenv->options, nio);
    switch (kind) {
    case PGOBLIN_ColName:
        if  (!!rio->pq->serv && (rio->pq->ncol > sub)) cx = rio->pq->serv[sub];
        break;
    case PGOBLIN_TypeNm:
        if  (!!rio->pq->serv && (rio->pq->ncol > sub)) cx = rio->pq->serv[sub + rio->pq->ncol];
        break;
    default:;
    }
out:
    return(cx);
#   undef blin_internal_flags
}

static char *
/**********************************************************************
 **                                                                  **/
erinfo(pgoblin_exenv *exenv, pgoblin_nr nio) {                      /**
 **                                                                  **
 **********************************************************************/
    char *cx = NULL;

    return(cx);
}

static ssize_t
/******************************************************************************
 **                                                                          **/
valinfo(pgoblin_exenv *exenv, pgoblin_nr nio, int kind, int row, int col) { /**
 **                                                                          **
 ******************************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio  *rio;
    ssize_t       ex = PGOBLIN_SSIZE_MIN;

    GET_RIO(rio, exenv->options, nio);
    switch (kind) {
    case PGOBLIN_IsNull:
        if  (rio->pq) {
            if  (!rio->pq->cell) {
                ex = 1;
            } else if ((row >= 0) && (row < rio->pq->nrow) && (col >= 0) && (col < rio->pq->ncol)) {
                ex = !rio->pq->cell[INDX(row, col)];
            } else {
                ifBLIN_QX1( "+ row %d %s in [0..%d], col %d %s in [0..%d]"
                          , row
                          , (row >= 0 && row < rio->pq->nrow) ? "" : "NOT"
                          , rio->pq->nrow - 1
                          , col
                          , (col >= 0 && col < rio->pq->ncol) ? "" : "NOT"
                          , rio->pq->ncol - 1
                          );
                errno = EINVAL;
            }
        } else if (row == 0 && col == 0) {
            ex = 1;
        } else {
            ifBLIN_QX0( "row %d col %d in emty", row, col);
            errno = EINVAL;
        }
        break;
    case PGOBLIN_Length:
        if  (0 > (ex = valinfo(exenv, nio, PGOBLIN_IsNull, row, col))) {
        } else if (!!ex) {
            ex = 0;
        } else if (rio->pq->llen) {
            ex = rio->pq->llen[INDX(row, col)];
        } else if (rio->pq->cell) {
            ex = strlen(rio->pq->cell[INDX(row, col)]);
        }
        break;
    default:
        errno = ENOTSUP;
    }
out:
    return(ex);
#   undef blin_internal_flags
}

static char *
/**********************************************************************
 **                                                                  **/
getvalue(pgoblin_exenv *exenv, pgoblin_nr nio, int row, int col) {  /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio  *rio;
    char         *c = NULL;

    GET_RIO(rio, exenv->options, nio);
    if  (!!rio->pq && !valinfo(exenv, nio, PGOBLIN_IsNull, row, col)) {
        c = rio->pq->cell[INDX(row, col)];
    }
out:
    return(c);
#   undef blin_internal_flags
}

static int
/***********************************************************************************
 **                                                                               **/
getstream(pgoblin_exenv *exenv, pgoblin_nr ndb, pgoblin_nr nou, int quant) {     /**
 **                                                                               **
 ***********************************************************************************/
    ifBLIN_QX0("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
}

static int
/**********************************************************************
 **                                                                  **/
getcopy(pgoblin_exenv *exenv, pgoblin_nr ndb, void **buf) {         /**
 **                                                                  **
 **********************************************************************/
    ifBLIN_QX0("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
}

static int
/****************************************************************************
 **                                                                        **/
putcopy(pgoblin_exenv *exenv, pgoblin_nr ndb, const void *buf, int nby) { /**
 **                                                                        **
 ****************************************************************************/
    ifBLIN_QX0("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
}

static int
/**********************************************************************
 **                                                                  **/
endstream(pgoblin_exenv *exenv, pgoblin_nr ndb) {                   /**
 **                                                                  **
 **********************************************************************/
    ifBLIN_QX0("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
}

static int
/**********************************************************************
 **                                                                  **/
tarry(pgoblin_exenv *exenv, pgoblin_nr ndb, int timeout) {          /**
 **                                                                  **
 **********************************************************************/
    return(0);
}

static void*
/**********************************************************************
 **                                                                  **/
notifies(pgoblin_exenv *exenv, pgoblin_nr ndb) {                    /**
 **                                                                  **
 **********************************************************************/
    return(NULL);
}

static int
/**********************************************************************
 **                                                                  **/
finish(pgoblin_exenv *exenv, pgoblin_nr ndb) {                      /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rdb *rdb;
    int          ex = EX_OK;

    GET_CON(rdb, exenv->options, ndb);
    rdb->conn = NULL;
out:
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
clear(pgoblin_exenv *exenv, pgoblin_nr nio) {                       /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    pgoblin_rio  *rio;
    int           ex = EX_OK;
    int           i;

    GET_RIO(rio, exenv->options, nio);
    if  (!!rio->pq) {
        ifBLIN_QX4("No rio->pq");
        if  ((rio->pq->llen) && (rio->pq->flags & PGOBLIN_DB_0FREEL)) {
            free(rio->pq->llen);
            rio->pq->llen = NULL;
        }
        if  (rio->pq->serv) {
            if  (rio->pq->flags & PGOBLIN_DB_0FREET) {
                for (i = 0; i < rio->pq->ncol; i++) {
                    free(rio->pq->serv[i]);
                    rio->pq->serv[i] = NULL;
            }   }
            if  (rio->pq->flags & PGOBLIN_DB_0FREES) {
                free(rio->pq->serv);
                rio->pq->serv = NULL;
        }   }
        if  (rio->pq->cell) {
            if  (rio->pq->flags & PGOBLIN_DB_0FREEC) {
                for (i = 0; i < rio->pq->nrow * rio->pq->ncol; i++) {
                    free(rio->pq->cell[i]);
                    rio->pq->cell[i] = NULL;
            }   }
            if  (rio->pq->flags & PGOBLIN_DB_0FREEA) {
                free(rio->pq->cell);
                rio->pq->cell = NULL;
        }   }
        free(rio->pq);
        rio->pq = NULL;
    }
out:
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
denote(pgoblin_exenv *exenv, pgoblin_nr ndb, void **note) {         /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

pgoblin_dbases pgoblin_db_0 =
{ 0
, "3pGoblin-" VERS
, "0\0" VERS
, 0
, init
, fini
, shurecon
, query
, NULL      /* prepare */
, execute
, resinfo
, subinfo
, erinfo
, valinfo
, getvalue
, getstream
, getcopy
, putcopy
, endstream
, tarry
, notifies
, finish
, clear
, NULL      /* erconn  */
, NULL      /* prexec  */
, denote
, NULL      /* dummy1  */
, NULL      /* dummy2  */
};
