/*-
 * Copyright (C)2004..2022 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2004..2022 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_file.c,v 1.102 2022/01/08 18:35:12 babolo Exp $"

#define BLIN_COMPAT      4
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      5
#define PGOBLIN_COMPAT   4
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <errno.h>
#include <stdio.h>
#include <fts.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <getCGIparm.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_echo(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rst *rst;
    pgoblin_rio *rct;
    pgoblin_rio *rou;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+echo %c%c...%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  (!rct->text) {
        MARK_IO_TEXT_GO(rn[PGO_COUT]);;
        ;;  rou->text = NULL;
        ;;  rou->length = 0;
        ;;  rou->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_BINPARM | PGOBLIN_TEXTPARM);
        MARK_IO_TEXT_WENT(rn[PGO_COUT]);;
        ifBLIN_QX1("NULL rct");
        goto out;
    }
    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    if  (rn[PGO_CSTY]) {
        char *tmpo;

        tmpo = STYLS(rst->flags)->get(exenv, rn[PGO_CSTY], rn[PGO_CCTL]);
        if  (tmpo) {
            MARK_IO_TEXT_GO(rn[PGO_COUT]);;
            ;;  rou->text = tmpo;
            ;;  rou->length = strlen(rou->text);
            ;;  rou->flags &= ~PGOBLIN_BINPARM;
            ;;  rou->flags |= PGOBLIN_TEXTPARM | PGOBLIN_FREETEXT;
            MARK_IO_TEXT_WENT(rn[PGO_COUT]);;
        } else {
            MARK_IO_TEXT_GO(rn[PGO_COUT]);;
            ;;  rou->text = NULL;
            ;;  rou->length = 0;
            ;;  rou->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_BINPARM | PGOBLIN_TEXTPARM);
            MARK_IO_TEXT_WENT(rn[PGO_COUT]);;
            ifBLIN_QX1("No const STY %u CTL %u", rn[PGO_CSTY], rn[PGO_CCTL]);
        }
    } else if (rn[PGO_COUT] != rn[PGO_CCTL]) {
        if  (!(rct->flags & PGOBLIN_FREETEXT)) {
            MARK_IO_TEXT_GO(rn[PGO_COUT]);;
            ;;  rou->text = rct->text;
            ;;  rou->length = rct->length;
            ;;  rou->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_BINPARM);
            ;;  rou->flags |= PGOBLIN_TEXTPARM | (rct->flags & PGOBLIN_BINPARM);
            MARK_IO_TEXT_WENT(rn[PGO_COUT]);;
        } else {
            MARK_IO_TEXT_GO(rn[PGO_COUT]);;
            ;;  if  (!(rou->text = malloc(rct->length + 1))) {
            ;;      ifBLIN_QX0("No mem #echo #2");
            ;;      ERROUT(EX_OSERR, ENOMEM);
            ;;  } else {
            ;;      rou->length = rct->length;
            ;;      bcopy(rct->text, rou->text, rct->length);
            ;;      ((u_char*)rou->text)[rou->length] = '\0'
            ;;      rou->flags &= ~PGOBLIN_BINPARM;
            ;;      rou->flags |= PGOBLIN_TEXTPARM | PGOBLIN_FREETEXT;
            ;;  }
            MARK_IO_TEXT_WENT(rn[PGO_COUT]);;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_file(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rst *rst;
    pgoblin_rio *rct;
    pgoblin_rio *rou;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+file %c%c...%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (rn[PGO_CSTY]) {
        if  (!rct->text) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  (rct->flags & PGOBLIN_BINPARM) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        MARK_IO_PATH_GO(rn[PGO_COUT]);;
        ;;  rou->path = STYLS(rst->flags)->get(exenv, rn[PGO_CSTY], rn[PGO_CCTL]);
        ;;  if  (rou->path) {
        ;;      rou->flags |= PGOBLIN_FILEOVER | PGOBLIN_PATHPARM | PGOBLIN_FREEPATH;
        ;;  } else {
        ;;      rou->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        ;;      ERROUT(EX_DATAERR, EINVAL);
        ;;  }
        MARK_IO_PATH_WENT(rn[PGO_COUT]);;
    } else if (!rct->text) {
        MARK_IO_PATH_GO(rn[PGO_COUT]);;
        ;;  rou->path = rct->text;
        ;;  rou->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_PATHPARM);
        ;;  rou->flags |= PGOBLIN_FILEOVER;
        MARK_IO_PATH_WENT(rn[PGO_COUT]);;
    } else if (rct->flags & PGOBLIN_FREETEXT) {
        MARK_IO_PATH_GO(rn[PGO_COUT]);;
        ;;  if  (!(rou->path = strdup(rct->text))) {
        ;;      ifBLIN_QX0("No mem #file");
        ;;      ERROUT(EX_OSERR, ENOMEM);
        ;;  } else {
        ;;      rou->flags |= PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM;
        ;;  }
        MARK_IO_PATH_WENT(rn[PGO_COUT]);;
    } else {
        MARK_IO_PATH_GO(rn[PGO_COUT]);;
        ;;  rou->path = rct->text;
        ;;  rou->flags &= ~PGOBLIN_FREEPATH;
        ;;  rou->flags |= PGOBLIN_FILEOVER | PGOBLIN_PATHPARM;
        MARK_IO_PATH_WENT(rn[PGO_COUT]);;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_cat(pgoblin_exenv *exenv, pgoblin_nr *rn) {                 /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rst *rst;
    pgoblin_rio *rct;
    pgoblin_rio *rou;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+cat %c%c...%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    GET_STY(rst, exenv->options, rn[PGO_CSTY]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (rn[PGO_CSTY]) {
        if  (!rct->text) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  (rct->flags & PGOBLIN_BINPARM) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        MARK_IO_PATH_GO(rn[PGO_COUT]);;
        ;;  rou->path = STYLS(rst->flags)->get(exenv, rn[PGO_CSTY], rn[PGO_CCTL]);
        ;;  if  (rou->path) {
        ;;      rou->flags &= ~PGOBLIN_FILEOVER;
        ;;      rou->flags |= PGOBLIN_PATHPARM | PGOBLIN_FREEPATH;
        ;;  } else {
        ;;      rou->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        ;;      ERROUT(EX_DATAERR, EINVAL);
        ;;  }
        MARK_IO_PATH_WENT(rn[PGO_COUT]);;
    } else if (!rct->text) {
        MARK_IO_PATH_GO(rn[PGO_COUT]);;
        ;;  rou->path = rct->text;
        ;;  rou->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        MARK_IO_PATH_WENT(rn[PGO_COUT]);;
    } else if (rct->flags & PGOBLIN_FREETEXT) {
        MARK_IO_PATH_GO(rn[PGO_COUT]);;
        ;;  if  (!(rou->path = strdup(rct->text))) {
        ;;      ifBLIN_QX0("No mem #cat");
        ;;      ERROUT(EX_OSERR, ENOMEM);
        ;;  } else {
        ;;      rou->flags &= ~PGOBLIN_FILEOVER;
        ;;      rou->flags |= PGOBLIN_FREEPATH | PGOBLIN_PATHPARM;
        ;;  }
        MARK_IO_PATH_WENT(rn[PGO_COUT]);;
    } else {
        MARK_IO_PATH_GO(rn[PGO_COUT]);;
        ;;  rou->path = rct->text;
        ;;  rou->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER);
        ;;  rou->flags |= PGOBLIN_PATHPARM;
        MARK_IO_PATH_WENT(rn[PGO_COUT]);;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getarg(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    size_t       nowl;
    pgoblin_rio *rou;
    pgoblin_rio *rct;
    int          ex   = EX_OK;
    FILE        *fi   = NULL;
    const char  *o;
    char        *q;
    u_int64_t    n;
    ssize_t      l;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getarg %c%c....", pgoblin_regn[rn[PGO_COUT]], pgoblin_regn[rn[PGO_CCTL]]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    if  (!!exenv->options->deargs) {
        n = 0;
        --n;
        if  (!!rct->text) {
            errno = 0;
/*          ((PGOBLIN_BINPARM & exenv->options->flags) ? rct->length : strlen(q)) XXXX */
            n = strtoul(rct->text, NULL, 0);
            if  (!!errno) {
                ifBLIN_QW0("Invalid CTL in #getarg: %s", rct);
                ex = EX_DATAERR;
                goto out;
        }   }
        if  (!(fi = funopen( (void*)(size_t)(rou->onu)
                           , NULL
                           , (int (*)(void*, const char*, int))rou->wri
                           , NULL
                           , NULL
            ) )            ) {
            ifBLIN_QW0("funopen on %d", rn[PGO_COUT]);
            ex = EX_IOERR;
            goto out;
        }
        q = NULL;
        nowl = 0;
        for (u_int64_t i = 0; (i < n) && (i < MULAR_NEXT(exenv->options->deargs)); ++i) {
            o = *(char**)mular_getix(exenv->options->deargs, i);
            ifBLIN_QX4("[%"BLIN_U"]%"BLIN_X"=%s%s", i, o, o ? o : "", o ? "~" : "");
            if  (nowl < (strlen(o) * 2 + 2)) {
                q = realloc(q, strlen(o) * 2 + 2);
                nowl = strlen(o) * 2 + 2;
            }
            if  (!q) {
                ifBLIN_QW0("No mem");
                ex = EX_OSERR;
                goto out;
            }
            if  (0 > (l = pgoblin_onecopy(q, o, -1, 0))) {
                ifBLIN_QW0("pgoblin_onecopy");
                ex = EX_SOFTWARE;
                goto out;
            }
            q[l] = '\0';
            if  (0 > fprintf(fi, "%"BLIN_O"u\t%s", i, q)) {
                ifBLIN_QW0("write error");
                ex = EX_IOERR;
                goto out;
        }   }
        free(q);
        if  (exenv->options->flags & PGOBLIN_COPEND_APND) {
            ex = fprintf(fi, "\\.\n");
            if  (0 > ex) {
                ifBLIN_QW0("write end error");
            } else {
                ex = EX_OK;
    }   }   }
out:
    if  (fi && fclose(fi) < 0) {
        ifBLIN_QW0("fclose #1 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getenv(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rio *rou;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getenv %c.....", pgoblin_regn[rn[PGO_COUT]]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  ((ex = getCGIparmenv( gCGI_RNUM, (const u_char **)exenv->options->envp
                            , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                            , rou->wri, rou->onu
        ))                  ) {
        ifBLIN_QW0("getCGIparmenv");
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getget(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rio *rou;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getget %c.....", pgoblin_regn[rn[PGO_COUT]]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  ((ex = getCGIparmcopy( gCGI_RNUM | gCGI_SEPR, (u_char*)getenv("QUERY_STRING")
                             , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                             , rou->wri, rou->onu
        ))                   ) {
        ifBLIN_QW0("getCGIparmcopy");
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getpost(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rio *rou;
    pgoblin_rio *rin;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getpost %c.%c...", pgoblin_regn[rn[PGO_COUT]], pgoblin_regn[rn[PGO_CIN]]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    if  (mife_read(rin->mife, (ssize_t)0, mife_offset(rin->mife)) < 0) {
        ifBLIN_QW0("mife_read");
        return(EX_OSERR);
    }
    if  ((ex = getCGIparmcopy( gCGI_RNUM | gCGI_SEPR
                             , mife_get(rin->mife, mife_offset(rin->mife))
                             , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                             , rou->wri, rou->onu
        ))                   ) {
        ifBLIN_QW0("getCGIparmcopy");
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getproc(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    pgoblin_rio *rou;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getproc %c.....", pgoblin_regn[rn[PGO_COUT]]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    if  ((ex = getCGIparmproc( 0, (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                             , rou->wri, rou->onu
        ))                   ) {
        ifBLIN_QW0("getCGIparmproc");
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getspq(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    ifBLIN_QX3( "+getspq......");
    ifBLIN_QX3("- %d", EX_UNAVAILABLE);
    return(EX_UNAVAILABLE);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getstr(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int          ex = EX_OK;
    char        *cont;
    pgoblin_rio *rou;
    pgoblin_rio *rin;
    FILE        *fi;
    ssize_t      bl = 0;
    ssize_t      i;
    int          j;
    int          l;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getstr %c.%c...", pgoblin_regn[rn[PGO_COUT]], pgoblin_regn[rn[PGO_CIN]]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    if  (!(fi = funopen( (void*)(size_t)(rou->onu)
                       , NULL
                       , (int (*)(void*, const char*, int))mife_writ
                       , NULL
                       , NULL
        ) )            ) {
        ifBLIN_QW0("getstr funopen #0 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    } else {
        for (j = 0, l = 1; !(rin->mife->flags & MIFE_EOFL);) {
            bl = mife_read( rin->mife
                          , (ssize_t)(1 << (PGOBLIN_RAWIOBUFL + 16))
                          , mife_offset(rin->mife) + bl
                          );
            if  (0 > bl) {
                ifBLIN_QW0("mife_read");
                ex = EX_IOERR;
                break;
            }
            if  (!(cont = mife_get(rin->mife, mife_offset(rin->mife)))) {
                ifBLIN_QW0("mife_get");
                ex = EX_IOERR;
                break;
            }
            for (i = 0; i < bl; i++, cont++) {
                switch (*cont) {
                    case '\\': if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "\\\\");      break;
                    case '\0': if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "\\0");       break;
                    case '\t': if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "\\t");       break;
                    case '\n': if (l) fprintf(fi, "%d\t", j); l = 1; fprintf(fi, "\n"); j++;   break;
                    default:   if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "%c", *cont); break;
        }   }   }
        if  (!l) fprintf(fi, "\n");
        if  (~exenv->options->flags & PGOBLIN_COPEND_NOGEN) fprintf(fi, "\\.\n");
    }
    if  (fclose(fi) < 0) {
        ifBLIN_QW0("fclose #0 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static const char statenames[][3] =
{ "bg", "cp", "be", "cq", "qq", "xx"};

enum states
{ bg /*                                      */
, cp /*                  */
, be /*                        */
, cq /*                    */
, qq /*                         */
, xx
};

static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "- ", "Ct", "Cd", "Cb", "Cp", "Cn", "- ", "Cq"
, "- ", "- ", "- ", "- ", "Cx", "- ", "- ", "- "
};

#define Ct  0x400000 /* \t                                 */
#define Cd  0x200000 /*            */
#define Cb  0x100000 /*             */
#define Cp  0x080000 /*      */
#define Cn  0x040000 /*                     */
#define Cq  0x010000 /*   ++                */
#define Cx  0x000800 /*                           */
#define C_state 0xFF /*                  */

static const char clasnames[][3] =
{ "L0", "Ll", "Lb", "Ls", "Lq", "Lc", "Lo", "Lx"};

#define L0 0 /* \0                                         */
#define Ll 1 /*                                 */
#define Lb 2 /*                                      */
#define Ls 3 /*                                */
#define Lq 4 /* "                                          */
#define Lc 5 /* ,                                          */
#define Lo 6 /*                                   */
#define Lx 7

static const char clasi[257] =
{ L0
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lb, Ll, Ls,  Lo, Ls, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lb, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
};

static u_int32_t automa[xx][Lx] =
/*    \0 L0     \n Ll  \b Lb x Ls         " Lq      ; Lc         * Lo  *    */
{{       xx, Cn|Cb|bg,    bg,  bg,          cq, Ct|Cb|bg,       Cp|cp}/* bg */
,{ Cn|Cb|xx, Cn|Cb|bg, Cq|be,  cp,          cp, Ct|Cb|bg,       Cp|cp}/* cp */
,{ Cn|Cb|xx, Cn|Cb|bg,    be,  be, Cd|Cb|Cp|cp, Ct|Cb|bg, Cd|Cb|Cp|cp}/* be */
,{    Cx|xx,    Cp|cq, Cp|cq,  cq,          qq,    Cp|cq,       Cp|cq}/* cq */
,{ Cn|Cb|xx, Cn|Cb|bg,    be,  qq,       Cp|cq, Ct|Cb|bg,          cp}/* qq */
};

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getcsv(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    char         class[257];
    int          coln;
    int          max = 0;
    pgoblin_rio *rou;
    pgoblin_rio *rct;
    pgoblin_rio *rin;
    int          ex  = EX_OK;
    FILE        *fi;
    u_char      *t;
    u_char       c;
    u_char       q;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getcsv %c%c%c..."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              );
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    c = ';';
    q = '\"';
    if  ((t = rct->text)) {
        c = t[0];
        q = t[1];
        errno = 0;
        if  (t[2]) max = strtol((char*)&(t[2]), NULL, 0);
        if  (errno) {
            ifBLIN_QW0("strtol=%s~", (char *)rct->text);
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  (max < 0) {
            ifBLIN_QX0("strtol %d<0", max);
            ERROUT(EX_DATAERR, EINVAL);
    }   }
    bcopy(clasi, class, 257);
    class[c + 1] = Lc;
    class[q + 1] = Lq;
    if  (!(fi = funopen( (void*)(size_t)(rou->onu)
                       , NULL
                       , (int (*)(void*, const char*, int))mife_writ
                       , NULL
                       , NULL
        ) )            ) {
        ifBLIN_QW0("funopen #0 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    } else {
        u_int32_t   control;
        enum states state;
        char       *cont;
        int         rs;
        ssize_t     l;
        u_char      p;
        int         s;

        blin_stateheader((blin_statectl){{4, 0, 8, 24, '\n', 5, 1, 0, 0}}, pn);
        for (state = bg, control = 0, coln = 0, rs = 0, l = 0
            ; state < xx
            ; state = control & C_state
            ) {
            if  ((l = mife_read(rin->mife, (ssize_t)1, mife_offset(rin->mife) + l)) < 0) {
                ifBLIN_QW0("mife_read");
                ex = EX_IOERR;
                break;
            }
            if  (!(cont = mife_get(rin->mife, mife_offset(rin->mife)))) {
                ifBLIN_QW0("mife_get");
                ex = EX_IOERR;
                break;
            }
            if  (!!l) {
                l = 1;
                s = *cont & 0xFF;
            } else {
                s = -1;
            }
            p = (u_char)(class[s + 1]);
            control = automa[state][p];
            blin_statebody( (blin_statectl){{4, 0, 8, 24, '\n', 5, 1, 0, 0}}
                          , pn
                          , statenames
                          , clasnames[(u_char)p]
                          , cont
                          , BLIN_I(cont)
                          , control
                          , state
                          , rs
                          , coln
                          );
            if  (control & Ct) {
                if  (++coln < max || !max) fputc('\t', fi);
            }
            if  (control & Cd) {
                for (;rs && (coln <= max || !max); rs--) fputc(' ', fi);
            }
            if  (control & Cb) rs = 0;
            if  (control & Cp) {
                if  (coln <= max || !max) switch (s) {
                    case '\\': fprintf(fi, "\\\\");      break;
                    case '\0': fprintf(fi, "\\0");       break;
                    case '\t': fprintf(fi, "\\t");       break;
                    case '\n': fprintf(fi, "\\n");       break;
                    default  : fputc(s, fi);
            }   }
            if  (control & Cn) {
                for (;++coln < max;) {
                    fprintf(fi, "\t\\N");
                }
                fprintf(fi, "\n");
                coln = 0;
            }
            if  (control & Cq) rs++;
            if  (control & Cx) {
                ifBLIN_QX0("syntax");
                errno = EINVAL;
                ex = EX_DATAERR;
        }   }
        if  (~exenv->options->flags & PGOBLIN_COPEND_NOGEN) fprintf(fi, "\\.\n");
        if  (fclose(fi) < 0) {
            ifBLIN_QW0("fclose on %d", rn[PGO_COUT]);
            ex = EX_OSERR;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getdir(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    u_int32_t    mode;
    int          ncol;
    pgoblin_rjb *rjb;
    pgoblin_dir *dir;
    int          max;
    pgoblin_rio *rou;
    pgoblin_rio *rct;
    pgoblin_rio *rin;
    int          ex = EX_OK;
    FILE        *fi = NULL;
    int          i  = 0;
    char        *s;
    char        *q;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getdir %c%c%c.%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    GET_RIO(rin, exenv->options, rn[PGO_CIN]);
    if  (!rct->text) {
        ifBLIN_QX0("No CTL Pt");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!(fi = funopen( (void*)(size_t)(rou->onu)
                       , NULL
                       , (int (*)(void*, const char*, int))mife_writ
                       , NULL
                       , NULL
        ) )            ) {
        ifBLIN_QW0("funopen #1 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    } else {
        mode = strtoul(rct->text, &q, 0);
        for (i = 0; ; ++i)  {
            if  (rn[PGO_CIN]) {
                ssize_t k;
                ssize_t m;
                int     j;

                max = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Ntuples);
                if  (i >= max) break;
                ncol = pgoblin_db_resinfo(exenv, rn[PGO_CIN], PGOBLIN_Nfields);
                ifBLIN_QX3(" %d @ %d : %d", i, max, ncol);
                switch (ncol) {
                case 0 : ifBLIN_QX1("Null name in getdir %d", rn[PGO_CCTL]);
                       ; goto out;
                case 1 : q = pgoblin_db_getvalue(exenv, rn[PGO_CIN], i, 0);
                       ; ifBLIN_QX3("1Dir=%s~", q);
                       ; break;
                default: for (j = 0, k = 0; j < ncol; j++) {
                       ;     if  (!pgoblin_db_valinfo(exenv, rn[PGO_CIN], PGOBLIN_IsNull, i, j)) {
                       ;         k += pgoblin_db_valinfo(exenv, rn[PGO_CIN], PGOBLIN_Length, i, j);
                       ; }   }
                       ; if  (!k) {
                       ;     ifBLIN_QX1("Empty name in getdir %d", rn[PGO_CCTL]);
                       ;     goto out;
                       ; }
                       ; if  (!(q = malloc(k + 1))) {
                       ;     ifBLIN_QX0("No mem %ld", k + 1);
                       ;     ERROUT(EX_OSERR, ENOMEM);
                       ; }
                       ; for (j = 0, k = 0; j < ncol; j++) {
                       ;     if  (!pgoblin_db_valinfo(exenv, rn[PGO_CIN], PGOBLIN_IsNull, i, j)) {
                       ;         m = pgoblin_db_valinfo(exenv, rn[PGO_CIN], PGOBLIN_Length, i, j);
                       ;         bcopy(pgoblin_db_getvalue(exenv, rn[PGO_CIN], i, j), &(q[k]), m);
                       ;         k += m;
                       ;         q[k] = '\0';
                       ; }   }
                       ; ifBLIN_QX3("NDir=%s~", q);
                }
            } else { /* XXXX MAJORDELETE XXXX */
                max = 0, ncol = 1;
                if  (i > max) break;
                if  (*q) {
                    if  (*q != ' ' && *q != '\t') {
                        ifBLIN_QX1("No white space in getdir %d", rn[PGO_CCTL]);
                    } else {
                        q++;
            }   }   }
            for (dir = NULL; (dir = JOBE(rjb->flags)->jdir(exenv, dir, q));) {
                if  (q && (ncol > 1)) free(q);
                q = dir->ent;
                if  (getCGIparmpass3(0, (u_char*)"copy", (u_char**)&q)) {
                    ifBLIN_QX0("getCGIparmpass3");
                    ex = EX_SOFTWARE;
                    goto out;
                }
                s = "";
                if  (mode & 0x01) {
                    fprintf(fi, "%d", dir->i);
                    s = "\t";
                }
                if  (mode & 0x02) {
                    fprintf(fi, "%s%s", s, q);
                    s = "\t";
                }
                if  (mode & 0x04) {
                    if  (dir->sb) {
                        fprintf(fi, "%s%lld", s, (long long)dir->sb->st_size);
                    } else {
                        fprintf(fi, "%s\\N", s);
                    }
                    s = "\t";
                }
                if  (mode & 0x08) {
                    if  (dir->sb) {
                        fprintf(fi, "%s%u", s, dir->sb->st_mode);
                    } else {
                        fprintf(fi, "%s\\N", s);
                    }
                    s = "\t";
                }
                if  (mode & 0x10) {
                    if  (dir->sb) {
                        fprintf(fi, "%s%u", s, dir->sb->st_uid);
                    } else {
                        fprintf(fi, "%s\\N", s);
                    }
                    s = "\t";
                }
                if  (mode & 0x20) {
                    if  (dir->sb) {
                        fprintf(fi, "%s%u", s, dir->sb->st_gid);
                    } else {
                        fprintf(fi, "%s\\N", s);
                    }
                    s = "\t";
                }
                fprintf(fi, "\n");
                if  (q != dir->ent) free(q);
                q = NULL;
        }   }
        if  (~exenv->options->flags & PGOBLIN_COPEND_NOGEN) fprintf(fi, "\\.\n");
    }
out:
    if  (fi && fclose(fi) < 0) {
        ifBLIN_QW0("fclose #1 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getopt(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    BLIN_flag    flopt = 0;
    babolo_opts *bos   = NULL;
    pgoblin_rjb *rjb;
    pgoblin_rio *rou;
    pgoblin_rio *rct;
    FILE        *fi    = NULL;
    int          ex    = EX_OK;
    char       **av    = NULL;
    u_int64_t    ai    = 0;
    const char  *o;
    const char  *q;
    char         z;
    int          s;
    int          c;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+ %c%c..%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    GET_JOB(rjb, exenv->options, rn[PGO_CJOB]);
    GET_RIO(rou, exenv->options, rn[PGO_COUT]);
    GET_RIO(rct, exenv->options, rn[PGO_CCTL]);
    q = rct->text;
    if  (!q) {
        ifBLIN_QX0("No CTL Pt");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!(fi = funopen( (void*)(size_t)(rou->onu)
                       , NULL
                       , (int (*)(void*, const char*, int))rou->wri
                       , NULL
                       , NULL
        ) )            ) {
        ifBLIN_QW0("funopen on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
        goto out;
    }
    switch(*q) {
    case '0':
        break;
    case '1':
        flopt = Bpars_NONU;
        break;
    default:
        ifBLIN_QX0("Ill flag %c(%02X)", *q, *q & 0x00FF);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (' ' != q[1]) {
        ifBLIN_QX0( "No space in CTL=%.*s~"
                  , (int)((PGOBLIN_BINPARM & exenv->options->flags) ? rct->length : strlen(q))
                  , q
                  );
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!!exenv->options->deargs) {
        ai = MULAR_NEXT(exenv->options->deargs);
        if  (!(av = calloc(ai + 1, sizeof(char *)))) {
            ifBLIN_QW0("no RAM");
            ex = EX_OSERR;
            goto out;
        }
        for (u_int64_t i = 0; i < ai; ++i) {
            if  (!(av[i] = *(char**)(mular_getix(exenv->options->deargs, i)))) {
                ifBLIN_QW0("mular_getix %p", i);
                ex = EX_OSERR;
                goto out;
            }
            ifBLIN_QX5("[%p]=%s~", i, av[i]);
        }
        if  (!(bos = babolo_openopts(Bpars_SYME | Bpars_ESYM | Bpars_EPRM, 'Z'))) {
            ifBLIN_QW0("babolo_openopts");
            ex = EX_SOFTWARE;
            goto out;
        }
        if  (babolo_setopts(bos, flopt, ai, av, &q[2])) {
            ifBLIN_QW0("babolo_setopts");
            ex = EX_SOFTWARE;
            goto out;
        } else if (babolo_chopts(bos, flopt, &q[2])) {
            ifBLIN_QW0("babolo_chopts");
            ex = EX_SOFTWARE;
            goto out;
        }
        for (int i = 0; !!(c = babolo_getopts(bos)); ++i) {
            if  (0 > c) {
                ifBLIN_QW0( "babolo_getopts -%c(%02X)"
                          , bos->c
                          , bos->c & 0x00FF
                          );
                ex = EX_USAGE;
                goto out;
            }
            fprintf(fi, "%d\t", i);
            switch((s = pgoblin_onecsym(c))) {
            case -1:
                errno = EINVAL;
                ex = EX_USAGE;
                goto out;
            case 0:
                fprintf(fi, "%c", c);
                break;
            default:
                fprintf(fi, "\\%c", s);
            }
            switch(bos->next->opts[c]) {
            case 0:
                fprintf(fi, "\t\\N\n");
                break;
            case 1:
                fprintf(fi, "\t{}\n");
                break;
            default:
                fprintf(fi, "\t");
                z = '{';
                for (int j = 1, l = 0, m = bos->next->opts[c]; j < m; ++j) {
                    if  (!!l) {
                        fprintf(fi, "%cNULL", z);
                    } else if (!(o = babolo_getoptsarg(bos))) {
                        ifBLIN_QW1("No -%c[%d] arg", c, j - 1);
                        fprintf(fi, "%cNULL", z);
                        l++;
                    } else {
                        fprintf(fi, "%c\"", z);
                        for (int k = 0; !!o[k]; ++k) {
                            switch((s = pgoblin_onecsym(o[k]))) {
                            case -1:
                                errno = EINVAL;
                                ex = EX_USAGE;
                                goto out;
                            case 0:
                                fprintf(fi, "%c", o[k]);
                                break;
                            case '\\':
                                fprintf(fi, "\\\\\\\\");
                                break;
                            default:
                                fprintf(fi, "\\\\%c", s);
                        }   }
                        fprintf(fi, "\"");
                    }
                    z = ',';
                }
                fprintf(fi, "}\n");
    }   }   }
    if  (exenv->options->flags & PGOBLIN_COPEND_APND) {
        ex = fprintf(fi, "\\.\n");
        if  (0 > ex) {
            ifBLIN_QW0("write end error");
        } else {
            ex = EX_OK;
    }   }
out:
    free(av);
    if  (bos) babolo_closeopts(bos);
    if  (fi && fclose(fi) < 0) {
        ifBLIN_QW0("fclose #1 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
