/*-
 * Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: vdump.c,v 1.33 2018/07/16 23:50:40 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <limits.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"

const char pgoblin_regn[] =
"0123456789"
"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
"abcdefghijklmnopqrstuvwxyz"
"_-"
;

void
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_Vdump(pgoblin_main *options, pgoblin_prog *pgm) {           /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    ssize_t p;
    int i;
    u_int32_t t, cmd;
    char *lit;

#   define blin_internal_flags (options->flags & BLIN_MASK)
    if  (pgm) ifBLIN_QX3("+ pgm=%"BLIN_D, pgm->curr); else ifBLIN_QX3("+ pgm=NULL");
    printf("+######################################");
    for (p = 0; p < PGOBLIN_STRING_ID_LEN && pgm->id[p]; p++) printf("%c", pgm->id[p]);
    for (p = 0; p < pgm->curr; p++) {
        t = pgm->code[p].cmd;
        cmd = t & PGOBLIN_COMMAND;
        if  (cmd == PGOBLIN_extended) {
            cmd = (pgm->code[p].ecmd & PGOBLIN_COMMAND) | PGOBLIN_EXTENDED;
            lit = NULL;
        } else {
            lit = pgm->code[p].lit;
        }
        if  (cmd >= pgoblin.max && !(~pgoblin.a[cmd].flags & PGOBLIN_ILLEGAL)) {
            printf("\n#ILLEGAL ");
        } else {
            printf("\n#%s ", pgoblin.a[cmd].str);
        }
        t >>= 2;
        for (i = 0; i < pgoblin.binparam; i++)
            printf("%c", pgoblin_regn[(t >>= PGOBLIN_BPARG) & PGOBLIN_ARGMASK]);
        printf(" ([%d]=%03X)", (int)p, cmd);
        if  (lit) printf("\n%s", pgm->code[p].lit);
    }
    printf("\n-######################################\n");
    ifBLIN_QX3("-");
#   undef blin_internal_flags
};

void
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_VVdump() {                                                  /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    u_int j;
    int i;

    printf( "SYMREGS=%d BINREGS=%d PGOBLIN_max=%03X\n"
          , pgoblin.symparam, pgoblin.binparam, pgoblin.max
          );
    for (i = 0; i < pgoblin.binparam; i++)
        printf("ARG%dS=%d%s", i + 1, pgoblin.binparams[i], (i + 1 < pgoblin.binparam) ? " " : "\n");
    printf("sym val bin mask name\n");
    for (i = 0; i < pgoblin.symparam; i++)
        printf( " %02X  %02X %s%2d %4d %s\n"
              , pgoblin.p[i].sym
              , pgoblin.p[i].val
              , (pgoblin.p[i].bin < 0) ? "~" : " "
              , (pgoblin.p[i].bin < 0) ? ~pgoblin.p[i].bin : pgoblin.p[i].bin
              , pgoblin.p[i].mask
              , pgoblin.p[i].name
              );
    printf("      flags     car   str\n");
    for (j = 0; j < pgoblin.max; ++j) printf( "%03X %08X %" BLIN_X "%s%s%s\n"
                                            , j
                                            , pgoblin.a[j].flags
                                            , BLIN_I(pgoblin.a[j].car)
                                            , (pgoblin.a[j].str) ? " =" : ""
                                            , (pgoblin.a[j].str) ? pgoblin.a[j].str : ""
                                            , (pgoblin.a[j].str) ? "~" : ""
                                            );
}

void
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_verify(pgoblin_main *options) {                             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_command cmd;
    u_int32_t m;
    int i, b;

    for (i = 0; i <= (PGOBLIN_ANYIVL | PGOBLIN_OUTSET); i++) {
        printf( "%c%s%s%s%s%s\n"
              , pgoblin_regn[i]
              , (i & PGOBLIN_PATHPARM) ? " path"  : ""
              , (i & PGOBLIN_TEXTPARM) ? " text"  : ""
              , (i & PGOBLIN_MIFEDES ) ? " mife"  : ""
              , (i & PGOBLIN_PQRESULT) ? " pq"    : ""
              , (i & PGOBLIN_OUTSET  ) ? " out"   : ""
              );
    }
    if  (pgoblin.symparam != PGOBLIN_SYMREGS) {
        printf("!!! pgoblin.symparam=%d <> SYMREGS=%d\n", pgoblin.symparam, PGOBLIN_SYMREGS);
    }
    if  (pgoblin.binparam != PGOBLIN_BINREGS) {
        printf("!!! pgoblin.binparam=%d <> BINREGS=%d\n", pgoblin.binparam, PGOBLIN_BINREGS);
    }
    if  (pgoblin.regsize != PGOBLIN_REGSIZE) {
        printf("!!! pgoblin.regsize=%d <> REGSIZE=%d\n", pgoblin.regsize, PGOBLIN_REGSIZE);
    }
    if  (pgoblin.max != PGOBLIN_max) {
        printf("!!! pgoblin.max=%d <> PGOBLIN_max=%d\n", pgoblin.max, PGOBLIN_max);
    }
    if  (pgoblin.binparams[0] != PGOBLIN_ARG1S) {
        printf( "!!! pgoblin.binparams[0]=%d <> PGOBLIN_ARG1S=%d\n"
              , pgoblin.binparams[0], PGOBLIN_ARG1S
              );
    }
    if  (pgoblin.binparams[1] != PGOBLIN_ARG2S) {
        printf( "!!! pgoblin.binparams[1]=%d <> PGOBLIN_ARG2S=%d\n"
              , pgoblin.binparams[1], PGOBLIN_ARG2S
              );
    }
    if  (pgoblin.binparams[2] != PGOBLIN_ARG3S) {
        printf( "!!! pgoblin.binparams[2]=%d <> PGOBLIN_ARG3S=%d\n"
              , pgoblin.binparams[2], PGOBLIN_ARG3S
              );
    }
    if  (pgoblin.binparams[3] != PGOBLIN_ARG4S) {
        printf( "!!! pgoblin.binparams[3]=%d <> PGOBLIN_ARG4S=%d\n"
              , pgoblin.binparams[3], PGOBLIN_ARG4S
              );
    }
    for (i = 1; i < pgoblin.binparam; i++) {
        if  (pgoblin.binparams[i - 1] + PGOBLIN_BPARG != pgoblin.binparams[i]) {
            printf( "!!! pgoblin.binparams[%d]=%d + %d <> pgoblin.binparams[%d]=%d\n"
                  , i - 1, pgoblin.binparams[i - 1]
                  , PGOBLIN_BPARG
                  , i, pgoblin.binparams[i]
                  );
    }   }
    for (i = 0; i < pgoblin.regsize; i++) {
        if  (pgoblin_ctonr(pgoblin_regn[i]) != i) {
            printf( "reg[%d <> %d] name %c\n"
                  , i, pgoblin_ctonr(pgoblin_regn[i]), pgoblin_regn[i]
                  );
    }   }
    for (i = 0; i < 256; i++) {
        if  ((pgoblin_ctonr(i) >= 0) && (pgoblin_regn[pgoblin_ctonr(i)] != i)) {
            printf( "name %c <> %c reg[%d]\n"
                  , pgoblin_regn[pgoblin_ctonr(i)], i, pgoblin_ctonr(i)
                  );
    }   }
    for (cmd = 1; cmd < pgoblin.max; cmd++) {
        m = 0;
        if  (!(~pgoblin.a[cmd].flags & PGOBLIN_ILLEGAL)) {
            if  (pgoblin.a[cmd].car) printf("!executor for illegal command %03X\n", cmd);
            if  (pgoblin.a[cmd].str) {
                printf("!name=%s~ for illegal command %03X\n", pgoblin.a[cmd].str, cmd);
            }
        } else {
            if  (!pgoblin.a[cmd].str) {
                printf("!! No name for legal command %03X\n", cmd);
            } else if  (babolo_testword(pgoblin.cmds, pgoblin.a[cmd].str) != cmd) {
                printf( "!!! cmd=%03X: %s=%03X\n"
                      , cmd
                      , pgoblin.a[cmd].str
                      , babolo_testword(pgoblin.cmds, pgoblin.a[cmd].str)
                      );
            }
            if  (pgoblin.a[cmd].flags & PGOBLIN_IGNORE) {
                if  (pgoblin.a[cmd].car) printf("!executor for ignored command %03X\n", cmd);
                if  (pgoblin.a[cmd].str) {
                    printf("!name=%s~ for ignored command %03X\n", pgoblin.a[cmd].str, cmd);
                }
            } else if (pgoblin.a[cmd].flags && !pgoblin.a[cmd].car) {
                printf("!! No executor for legal command %03X\n", cmd);
            }
            if  (!!(pgoblin.a[cmd].flags & PGOBLIN_NOLITER) && !(cmd & PGOBLIN_EXTENDED)) {
                printf("!short command %03X without literal\n", cmd);
                if  (pgoblin.a[cmd].str) {
                    printf("!short command without literal name=%s~\n", pgoblin.a[cmd].str);
            }   }
            if  (!(pgoblin.a[cmd].flags & PGOBLIN_NOLITER) && !!(cmd & PGOBLIN_EXTENDED)) {
                printf("!extended command %03X with literal\n", cmd);
                if  (pgoblin.a[cmd].str) {
                    printf("!extended command with literal name=%s~\n", pgoblin.a[cmd].str);
        }   }   }
        for (i = 0; i < pgoblin.symparam; i++) {
            if  (0 <= (b = pgoblin_breg(cmd, i))) {
                if  (!pgoblin.a[cmd].ch[b]) {
                    printf("!! cmd=%03X: a[cmd].flags <#> a[cmd].ch[%df=>%dl)]\n", cmd, b, i);
                    if  (pgoblin.a[cmd].str) printf("!! name=%s~\n", pgoblin.a[cmd].str);
                    ifBLIN_QX1( "pgoblin.a[%03X].flags=%08X pgoblin.p[%d].sym=%02X, bin=%02X,"
                                " mask=%02X breg(%03X,%d)=%d pgoblin.a[%03X].ch[%d]=%02X"
                              , cmd
                              , pgoblin.a[cmd].flags
                              , i
                              , pgoblin.p[i].sym
                              , pgoblin.p[i].bin & 0xFF
                              , pgoblin.p[i].mask
                              , cmd, i, b
                              , cmd, b, pgoblin.a[cmd].ch[b]
                              );
                } else {
                    if  (m & (1 << b)) {
                        printf("!!! Second hand r=%d for cmd=%03X\n", i, cmd);
                    }
                    m |= (1 << b);
        }   }   }
        for (i = 0; i < pgoblin.binparam; i++) {
            if  (!(m & (1 << i)) && pgoblin.a[cmd].ch[i]) {
                printf("!!! Unused r=%d for cmd=%03X\n", i, cmd);
                if  (pgoblin.a[cmd].str) printf("!!! Unused in name=%s~\n", pgoblin.a[cmd].str);
}   }   }   }
