/*-
 * Copyright (C)2008..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: style_0.c,v 1.38 2018/08/21 09:22:40 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"

static int
/**********************************************************************
 **                                                                  **/
init(u_int32_t flags) {                                             /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
fini() {                                                            /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
parser(pgoblin_styreg *reg_style, u_char *in) {                     /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static void
/**********************************************************************
 **                                                                  **/
dump(pgoblin_styreg *reg_style) {                                   /**
 **                                                                  **
 **********************************************************************/
    return;
}

static int
/**********************************************************************
 **                                                                  **/
clear(pgoblin_styreg *reg_style) {                                  /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static char *
/**********************************************************************
 **                                                                  **/
get(pgoblin_styreg *reg_style, u_char *stringname) {                /**
 **                                                                  **
 **********************************************************************/
    return(NULL);
}

static int
/**********************************************************************
 **                                                                  **/
sout(pgoblin_io *reg_out, char *c, size_t l, size_t ll) {           /**
 **                                                                  **
 **********************************************************************/
    int ex = 0;

    if  (c) {
        if  (reg_out->wri) {
            ex = reg_out->wri(reg_out->onu, c, l);
        } else if (reg_out->length + l > ll) {
            ifBLIN_QX0("out buf len err");
            ERROUT(-EX_SOFTWARE, EDOOFUS);
        } else {
            MARK_IO_TEXT_GO(reg_out);;
            ;;  bcopy(c, &((char*)(reg_out->text))[reg_out->length], l);
            ;;  reg_out->length += l;
            ;;  ((char*)(reg_out->text))[reg_out->length] = '\0';
            MARK_IO_TEXT_WENT(reg_out);;
    }   }
out:
    return(ex);
}

static int
/**********************************************************************
 **                                                                  **/
tbl( pgoblin_io     *reg_out                                        /**/
   , pgoblin_styreg *reg_style                                      /**/
   , pgoblin_io     *reg_in                                         /**/
   , ssize_t         low                                            /**/
   , ssize_t         hig                                            /**/
   ) {                                                              /**
 **                                                                  **
 **********************************************************************/
    int             isnull;
    int             ex = 0;
    ssize_t         i = 0;
    ssize_t         minc;
    ssize_t         maxc;
    size_t          ll;
    size_t          l;
    ssize_t         m;
    ssize_t         w;
    ssize_t         j;

#   define blin_internal_flags ((reg_style ? reg_style->flags : pgoblin_default) & BLIN_MASK)
    m = pgoblin_db_resinfo(PGOBLIN_Ntuples, reg_in->pq);
    w = pgoblin_db_resinfo(PGOBLIN_Nfields, reg_in->pq);
    isnull = ((m == 0) || (w == 0)) ? 1 : 0;
    if  (hig == -3) {
        minc = low;
        maxc = (low < m) ? low + 1 : m;
    } else {
        minc = 0;
        maxc = m;
    }
    ifBLIN_QX3("+ %08X %d x %d %d..%d", *(reg_in->pq), m, w, minc, maxc);
    if  (!reg_out->wri) {
        char *s;

        /*      */
        for (i = minc, isnull = 1, l = 0; i < maxc; i++) {
            for (j = 0; j < w; j++) {
                if  (!pgoblin_db_valinfo(PGOBLIN_IsNull, reg_in->pq, i, j)) {
                    isnull = 0;
                    ex = pgoblin_db_valinfo(PGOBLIN_Length, reg_in->pq, i, j);
                    if  (ex < 0) {
                        ifBLIN_QW0("table in 0 STYLE");
                        ex = -EX_IOERR;
                        goto out;
                    }
                    l += ex;
        }   }   }
        if  (isnull) {
            s = NULL;
        } else if (!(s = malloc(l + 1))) {
            ifBLIN_QX0("table in 0 STYLE: No mem");
            ERROUT(-EX_OSERR, ENOMEM);
        }
        /*       */
        MARK_IO_TEXT_GO(reg_out);;
        ;;  if  (reg_out->text && (reg_out->flags & PGOBLIN_FREETEXT)) free(reg_out->text);
        ;;  reg_out->text = s;
        ;;  reg_out->length = 0;
        ;;  if  (s) {
        ;;      reg_out->flags |= PGOBLIN_BINPARM | PGOBLIN_FREETEXT;
        ;;      ((char*)(reg_out->text))[reg_out->length] = '\0';
        ;;  } else {
        ;;      reg_out->flags &= ~(PGOBLIN_TEXTPARM | PGOBLIN_BINPARM | PGOBLIN_FREETEXT);
        ;;  }
        MARK_IO_TEXT_WENT(reg_out);;
    }
    for (i = minc, ll = 0; i < maxc; i++) {
        for (j = 0; j < w; j++) {
            if  (!pgoblin_db_valinfo(PGOBLIN_IsNull, reg_in->pq, i, j)) {
                ex = sout( reg_out
                         , pgoblin_db_getvalue(reg_in->pq, i, j)
                         , pgoblin_db_valinfo(PGOBLIN_Length, reg_in->pq, i, j)
                         , l
                         );
                if  (ex < 0) {
                    ifBLIN_QW0("table in 0 STYLE");
                    ex = -EX_IOERR;
                    goto out;
                }
                ll += ex;
    }   }   }
out:
    ifBLIN_QX3("- %d %d", ex, ll);
    return((ex < 0) ? ex : ll);
#   undef blin_internal_flags
}

pgoblin_styles pgoblin_style_0 =
{ 0
, "5pGoblin-" VERS
, "0\0" VERS
, 0
, init
, fini
, parser
, dump
, clear
, get
, tbl
, NULL
, NULL
, NULL
, NULL
};
