/*-
 * Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: pgoblin.c,v 1.104 2018/09/13 18:11:43 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"

static const char *const prms[256] =
{                  "",                   "Pf",                   "Pt",                   "Pt Pf"
,                "Pm",                "Pm Pf",                "Pm Pt",                "Pm Pt Pf"
,             "Pq"   ,                "Pq Pf",                "Pq Pt",                "Pq Pt Pf"
,             "Pq Pm",             "Pq Pm Pf",             "Pq Pm Pt",             "Pq Pm Pt Pf"
, "Po"               ,                "Po Pf",                "Po Pt",                "Po Pt Pf"
, "Po Pm"            ,             "Po Pm Pf",             "Po Pm Pt",             "Po Pm Pt Pf"
, "Po Pq"            ,             "Po Pq Pf",             "Po Pq Pt",             "Po Pq Pt Pf"
, "Po Pq Pm"         ,          "Po Pq Pm Pf",          "Po Pq Pm Pt",          "Po Pq Pm Pt Pf"
,          "Pc"      ,                "Pc Pf",                "Pc Pt",                "Pc Pt Pf"
,          "Pc Pm"   ,             "Pc Pm Pf",             "Pc Pm Pt",             "Pc Pm Pt Pf"
,          "Pc Pq"   ,             "Pc Pq Pf",             "Pc Pq Pt",             "Pc Pq Pt Pf"
,          "Pc Pq Pm",          "Pc Pq Pm Pf",          "Pc Pq Pm Pt",          "Pc Pq Pm Pt Pf"
, "Po Pc"            ,             "Po Pc Pf",             "Po Pc Pt",             "Po Pc Pt Pf"
, "Po Pc Pm"         ,          "Po Pc Pm Pf",          "Po Pc Pm Pt",          "Po Pc Pm Pt Pf"
, "Po Pc Pq"         ,          "Po Pc Pq Pf",          "Po Pc Pq Pt",          "Po Pc Pq Pt Pf"
, "Po Pc Pq Pm"      ,       "Po Pc Pq Pm Pf",       "Po Pc Pq Pm Pt",       "Po Pc Pq Pm Pt Pf"
,       "Pj"         ,                "Pj Pf",                "Pj Pt",                "Pj Pt Pf"
,       "Pj Pm"      ,             "Pj Pm Pf",             "Pj Pm Pt",             "Pj Pm Pt Pf"
,       "Pj Pq"      ,             "Pj Pq Pf",             "Pj Pq Pt",             "Pj Pq Pt Pf"
,       "Pj Pq Pm"   ,          "Pj Pq Pm Pf",          "Pj Pq Pm Pt",          "Pj Pq Pm Pt Pf"
, "Po Pj"            ,             "Po Pj Pf",             "Po Pj Pt",             "Po Pj Pt Pf"
, "Po Pj Pm"         ,          "Po Pj Pm Pf",          "Po Pj Pm Pt",          "Po Pj Pm Pt Pf"
, "Po Pj Pq"         ,          "Po Pj Pq Pf",          "Po Pj Pq Pt",          "Po Pj Pq Pt Pf"
, "Po Pj Pq Pm"      ,       "Po Pj Pq Pm Pf",       "Po Pj Pq Pm Pt",       "Po Pj Pq Pm Pt Pf"
,       "Pj Pc"      ,             "Pj Pc Pf",             "Pj Pc Pt",             "Pj Pc Pt Pf"
,       "Pj Pc Pm"   ,          "Pj Pc Pm Pf",          "Pj Pc Pm Pt",          "Pj Pc Pm Pt Pf"
,       "Pj Pc Pq"   ,          "Pj Pc Pq Pf",          "Pj Pc Pq Pt",          "Pj Pc Pq Pt Pf"
,       "Pj Pc Pq Pm",       "Pj Pc Pq Pm Pf",       "Pj Pc Pq Pm Pt",       "Pj Pc Pq Pm Pt Pf"
, "Po Pj Pc"         ,          "Po Pj Pc Pf",             "Po Pj Pt",          "Po Pj Pc Pt Pf"
, "Po Pj Pc Pm"      ,       "Po Pj Pc Pm Pf",       "Po Pj Pc Pm Pt",       "Po Pj Pc Pm Pt Pf"
, "Po Pj Pc Pq"      ,       "Po Pj Pc Pq Pf",       "Po Pj Pc Pq Pt",       "Po Pj Pc Pq Pt Pf"
, "Po Pj Pc Pq Pm"   ,    "Po Pj Pc Pq Pm Pf",    "Po Pj Pc Pq Pm Pt",    "Po Pj Pc Pq Pm Pt Pf"
,    "Ps"            ,                "Ps Pf",                "Ps Pt",                "Ps Pt Pf"
,    "Ps Pm"         ,             "Ps Pm Pf",             "Ps Pm Pt",             "Ps Pm Pt Pf"
,    "Ps Pq"         ,             "Ps Pq Pf",             "Ps Pq Pt",             "Ps Pq Pt Pf"
,    "Ps Pq Pm"      ,          "Ps Pq Pm Pf",          "Ps Pq Pm Pt",          "Ps Pq Pm Pt Pf"
, "Po Ps"            ,             "Po Ps Pf",             "Po Ps Pt",             "Po Ps Pt Pf"
, "Po Ps Pm"         ,          "Po Ps Pm Pf",          "Po Ps Pm Pt",          "Po Ps Pm Pt Pf"
, "Po Ps Pq"         ,          "Po Ps Pq Pf",          "Po Ps Pq Pt",          "Po Ps Pq Pt Pf"
, "Po Ps Pq Pm"      ,       "Po Ps Pq Pm Pf",       "Po Ps Pq Pm Pt",       "Po Ps Pq Pm Pt Pf"
,    "Ps Pc"         ,             "Ps Pc Pf",             "Ps Pc Pt",             "Ps Pc Pt Pf"
,    "Ps Pc Pm"      ,          "Ps Pc Pm Pf",          "Ps Pc Pm Pt",          "Ps Pc Pm Pt Pf"
,    "Ps Pc Pq"      ,          "Ps Pc Pq Pf",          "Ps Pc Pq Pt",          "Ps Pc Pq Pt Pf"
,    "Ps Pc Pq Pm"   ,       "Ps Pc Pq Pm Pf",       "Ps Pc Pq Pm Pt",       "Ps Pc Pq Pm Pt Pf"
, "Po Ps Pc"         ,          "Po Ps Pc Pf",             "Po Ps Pt",          "Po Ps Pc Pt Pf"
, "Po Ps Pc Pm"      ,       "Po Ps Pc Pm Pf",       "Po Ps Pc Pm Pt",       "Po Ps Pc Pm Pt Pf"
, "Po Ps Pc Pq"      ,       "Po Ps Pc Pq Pf",       "Po Ps Pc Pq Pt",       "Po Ps Pc Pq Pt Pf"
, "Po Ps Pc Pq Pm"   ,    "Po Ps Pc Pq Pm Pf",    "Po Ps Pc Pq Pm Pt",    "Po Ps Pc Pq Pm Pt Pf"
,    "Ps Pj"         ,             "Ps Pj Pf",             "Ps Pj Pt",             "Ps Pj Pt Pf"
,    "Ps Pj Pm"      ,          "Ps Pj Pm Pf",          "Ps Pj Pm Pt",          "Ps Pj Pm Pt Pf"
,    "Ps Pj Pq"      ,          "Ps Pj Pq Pf",          "Ps Pj Pq Pt",          "Ps Pj Pq Pt Pf"
,    "Ps Pj Pq Pm"   ,       "Ps Pj Pq Pm Pf",       "Ps Pj Pq Pm Pt",       "Ps Pj Pq Pm Pt Pf"
, "Po Ps Pj"         ,          "Po Ps Pj Pf",          "Po Ps Pj Pt",          "Po Ps Pj Pt Pf"
, "Po Ps Pj Pm"      ,       "Po Ps Pj Pm Pf",       "Po Ps Pj Pm Pt",       "Po Ps Pj Pm Pt Pf"
, "Po Ps Pj Pq"      ,       "Po Ps Pj Pq Pf",       "Po Ps Pj Pq Pt",       "Po Ps Pj Pq Pt Pf"
, "Po Ps Pj Pq Pm"   ,    "Po Ps Pj Pq Pm Pf",    "Po Ps Pj Pq Pm Pt",    "Po Ps Pj Pq Pm Pt Pf"
,    "Ps Pj Pc"      ,          "Ps Pj Pc Pf",          "Ps Pj Pc Pt",          "Ps Pj Pc Pt Pf"
,    "Ps Pj Pc Pm"   ,       "Ps Pj Pc Pm Pf",       "Ps Pj Pc Pm Pt",       "Ps Pj Pc Pm Pt Pf"
,    "Ps Pj Pc Pq"   ,       "Ps Pj Pc Pq Pf",       "Ps Pj Pc Pq Pt",       "Ps Pj Pc Pq Pt Pf"
,    "Ps Pj Pc Pq Pm",    "Ps Pj Pc Pq Pm Pf",    "Ps Pj Pc Pq Pm Pt",    "Ps Pj Pc Pq Pm Pt Pf"
, "Po Ps Pj Pc"      ,       "Po Ps Pj Pc Pf",          "Po Ps Pj Pt",       "Po Ps Pj Pc Pt Pf"
, "Po Ps Pj Pc Pm"   ,    "Po Ps Pj Pc Pm Pf",    "Po Ps Pj Pc Pm Pt",    "Po Ps Pj Pc Pm Pt Pf"
, "Po Ps Pj Pc Pq"   ,    "Po Ps Pj Pc Pq Pf",    "Po Ps Pj Pc Pq Pt",    "Po Ps Pj Pc Pq Pt Pf"
, "Po Ps Pj Pc Pq Pm", "Po Ps Pj Pc Pq Pm Pf", "Po Ps Pj Pc Pq Pm Pt", "Po Ps Pj Pc Pq Pm Pt Pf"
};

static const u_char flms[256] =
{  4, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
};

static int
/**********************************************************************
 **                                                                  **/
cmp(const void *a, const void *b) {                                 /**
 **                                                                  **
 **********************************************************************/
    return(strcmp(pgoblin.a[*(int*)a].str, pgoblin.a[*(int*)b].str));
}

static void
/**********************************************************************
 **                                                                  **/
regtran() {                                                         /**
 **                                                                  **
 **********************************************************************/
    u_int32_t f;
    int       k;

    for (int i = 0; i < pgoblin.max; ++i) {
        f = pgoblin.a[i].flags;
        if  ((f & PGOBLIN_ILLEGAL) != PGOBLIN_ILLEGAL) {
            printf("%03X", i);
            for (int j = 0; j < pgoblin.symparam; ++j) {
                k = pgoblin_breg(i, j);
                switch(k) {
                case -2: printf("\t#");     break;
                case -1: printf("\t.");     break;
                default: printf("\t%d", k); break;
            }   }
            printf("\t%s\n", pgoblin.a[i].str);
}   }   }

static int
/**********************************************************************
 **                                                                  **/
htman(u_int32_t flags) {                                            /**
 **                                                                  **
 **********************************************************************/
#   define blin_internal_flags (flags & BLIN_MASK)
    u_int32_t   tag[pgoblin.symparam];
    const char *pt[pgoblin.symparam];
    u_int8_t    p[pgoblin.binparam];
    int         ex = EX_OK;
    char        cf[8];
    int        *sqn;
    int         i;
    int         j;
    int         k;
    int         m;
    u_int       u;

    if  (!(sqn = malloc(sizeof(int) * pgoblin.max))) {
        ifBLIN_QX0("malloc");
        errno = ENOMEM;
        ex = EX_UNAVAILABLE;
        goto out;
    }
    for (u = 1, j = 0; u < pgoblin.max; ++u) {
        if  (pgoblin.a[u].str) sqn[j++] = u;
    }
    if  (heapsort(sqn, j, sizeof(int), cmp) < 0) {
        ifBLIN_QW0("heapsort");
        ex = EX_SOFTWARE;
        goto out;
    }
    for (i = 0; i < j; i++) {
        u_int32_t f;
        u_int8_t h;
        char c;
        int b;

        f = pgoblin.a[sqn[i]].flags;
        if  ((f & PGOBLIN_ILLEGAL) == PGOBLIN_ILLEGAL) {
            tag[0] = 8;
            f &= ~PGOBLIN_ILLEGAL;
        } else {
            for (k = 0; k < pgoblin.binparam; k++) p[k] = 0;
            for (k = 0; k < pgoblin.symparam; k++) {
                tag[k] = 0;
                if  (0 <= (b = pgoblin_breg(sqn[i], k))) {
                    h = pgoblin.a[sqn[i]].ch[b];
                    tag[k] |= flms[h & 0xFF];
                    pt[k] = prms[h & 0xFF];
//printf("%d s%d b%d t%c %02X\n", tag[k], k, b, (!p[b]) ? '~' : ('0' + ~p[b]), h);
                    if  (h & ~(PGOBLIN_OUTSET | pgoblin.p[k].val)) tag[k] |= 1;
                    if  (!(h & pgoblin.p[k].val) != !*(pt[k])) tag[k] |= 1;
                    f &= ~pgoblin.p[k].sym;
                    if  (p[b]) {
                        tag[~p[b]] |= 2;
                        tag[k] |= 2;
                    }
                    p[b] = ~k;
                } else {
                    pt[k] = "";
                }
                if  (pgoblin.p[k].bin < 0) f &= ~(pgoblin.p[k].mask << ~pgoblin.p[k].bin);
        }   }
        k = 0;
        c = ' ';
        if  (f & PGOBLIN_IGNORE) {
            cf[k++] = 'i';
            for (m = 0; m < pgoblin.binparam; m++) if (p[m]) c = '!';
            for (m = 0; m < pgoblin.symparam; m++) if (*(pt[m])) c = '!';
            f &= ~PGOBLIN_IGNORE;
        }
        if  (f & PGOBLIN_NOLITER) {
            cf[k++] = 'l';
            if (p[1]) c = '!';
            if (tag[1] || *(pt[1])) c = '!';
            f &= ~PGOBLIN_NOLITER;
        }
        if  (f & PGOBLIN_LEXLVUP) cf[k++] = 'u';
        if  (f & PGOBLIN_LEXLDOWN) cf[k++] = 'd';
        if  (f & PGOBLIN_FORKED) cf[k++] = 'f';
        f &= ~(PGOBLIN_LEXLVUP | PGOBLIN_LEXLDOWN | PGOBLIN_FORKED);
        if  (f) c = '!';
        for (m = 0; m < pgoblin.symparam; m++) if (tag[m] & ~8) c = '!';
        if  (c == '!') cf[k++] = '!';
        cf[k++] = '\0';
        ifBLIN_QO1 printf( "%08X%c\t", f, c);
        if  (tag[0] & 8) {
            printf( "%s\t%s\t%d\t\t0\t\t0\t\t0\t\t0\t\t0\t\n"
                  , cf, pgoblin.a[sqn[i]].str, tag[0]
                  );
        } else {
            printf( "%s\t%s\t%d\t%s\t%d\t%s\t%d\t%s\t%d\t%s\t%d\t%s\t%d\t%s\n"
                  , cf, pgoblin.a[sqn[i]].str
                  , tag[0], pt[0]
                  , tag[1], pt[1]
                  , tag[2], pt[2]
                  , tag[3], pt[3]
                  , tag[4], pt[4]
                  , tag[5], pt[5]
                  );
    }   }
out:;
    return(0);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
keycodes(pgoblin_main *options) {                                   /**
 **                                                                  **
 **********************************************************************/
#   define PROGSIZE   3
#   define RESCLASSES 4
#   define IOREGFOR   1
    static const char KeyCodes[] = {'U', 'C', 'T', 'R'};
    int               ex = EX_OK;
    pgoblin_exenv    *exenv;
    pgoblin_io       *r;
    char              c;
    char             *m;
    char             *s;
    int               i;
    int               j;
    int               k;

#   define blin_internal_flags (options->flags & BLIN_MASK)
    if  (!(exenv = calloc(1, sizeof(pgoblin_exenv)))) {
        ifBLIN_QW0("no mem for exenv");
        ex = EX_OSERR;
        goto out;
    }
    exenv->options = options;
    exenv->flags = options->flags & BLIN_MASK;
    if  (!(exenv->pgm = calloc(1, sizeof(pgoblin_tuple) * PROGSIZE + sizeof(pgoblin_prog)))) {
        ifBLIN_QW0("no mem for pgm");
        ex = EX_UNAVAILABLE;
        goto out;
    }
    strncpy(exenv->pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_LEN);
    exenv->pgm->maxx = PROGSIZE;
    exenv->pgm->curr = 0;
    exenv->pgm->debug = NULL;
    options->flags &= ~PGOBLIN_CLEAR_ONEXIT;
    if  (exenv->pgm->curr < exenv->pgm->maxx) {
        exenv->pgm->code[exenv->pgm->curr].cmd = PGOBLIN_select | IOREGFOR << pgoblin.binparams[0];
        exenv->pgm->code[exenv->pgm->curr].lit = "SELECT word, catcode, catdesc FROM pg_get_keywords();";
        exenv->pgm->curr++;
        if  (options->flags & PGOBLIN_VERIFY) pgoblin_Vdump(options, exenv->pgm);
        if  ((ex = pgoblin_execute(exenv->options, exenv->pgm, NULL, NULL, 0))) {
            ifBLIN_QW0("Execute failed");
        }
        r = &(options->io[IOREGFOR]);
        for (i = 0; i < pgoblin_db_resinfo(PGOBLIN_Ntuples, r->pq); i++) {
            m = pgoblin_db_getvalue(r->pq, i, 2);
            c = *(pgoblin_db_getvalue(r->pq, i, 1));
            s = pgoblin_db_getvalue(r->pq, i, 0);
            j = babolo_testword(pgoblin.sqlkeywords, s);
            ifBLIN_QX6("%3d %c %s %s\n", j, c, s, m);
            if  (!j) {
                ifBLIN_QX0( "Unknown keyword \'%s\' with type \'%c\', comment is \'%s\'", s, c, m);
            } else {
                for (k = 0; k < RESCLASSES; k++) if  (KeyCodes[k] == c) break;
                if  (k >= RESCLASSES) {
                    ifBLIN_QX0("Unknown keyword type \'%c\' for \'%s\', comment is \'%s\'", c, s, m);
                    ex = EX_SOFTWARE;
                } else if (k > (j - 1)) {
                    ifBLIN_QX0( "We know of type \'%c\' for keyword \'%s\', "
                                "but DBMS knows stronger type \'%c\'"
                              , KeyCodes[(j - 1)], s, c
                              );
                    ex = EX_SOFTWARE;
                } else if (k != (j - 1)) {
                    ifBLIN_QX0( "Our type \'%c\' for keyword \'%s\' mismatch with DBMS type \'%c\'"
                              , KeyCodes[(j - 1)], s, c
                              );
        }   }   }
    } else {
        errx(EX_SOFTWARE, "Programm too big in keycodes");
    }
out:
    return(ex);
#   undef blin_internal_flags
}

static void 
/**********************************************************************
 **                                                                  **/
tinr(u_int64_t *demask, const char *Tflag) {                        /**
 **                                                                  **
 **********************************************************************/
    int i;

    for (i = 1; !!Tflag[i]; ++i) {
        if  (pgoblin_ctonr(Tflag[i]) >= 0) {
            *demask |= 1 << pgoblin_ctonr(Tflag[i]);
}   }   }

static void
/**********************************************************************
 **                                                                  **/
usage(int ex) {                                                     /**
 **                                                                  **
 **********************************************************************/
    int i;
    char *q;

    fprintf( stderr
           , "pgoblin @BABOLO V.M " VERS "  " DATE " http://www.babolo.ru/\n"
             "Usage:\n"
             "pgoblin [-aAbNOqvV][ -B DBMS][ -d DB][ -h Host][ -p Port][ -U User][ -f File] args\n"
             "    -B DBMS      default DBMS\n"
             "    -d DB        DB name\n"
             "    -E -opt ENV  get optarg for -opt from environment\n"
             "    -f File      execute pgoblin program from File\n"
             "    -h Host      backend server\n"
             "    -p Port      backend server\n"
             "    -q           quiet\n"
             "    -z ArgString break ArgString to opts\n"
             "    -Z ArgString break ArgString to opts with env vars subst\n"
             "    -t num       max time wait in #listen (sec)\n"
             "    -U Username  for connect to DB\n"
             "    -v           verbose\n"
             "____-X File      trace to File\n"
             "    -c Command   COPY out\n"
             "    -C Command   COPY in\n"
             "    -D Command   perform query without result\n"
             "    -e Program   execute pgoblin program from optarg\n"
             "    -s Command   perform query with text result\n"
             "____-S Command   perform query with binary result\n"
             "    -a           transit out \\. from COPY\n"
             "    -A           add \\. to COPY if not prezent\n"
             "    -b           do not create \\. on some get*** commands\n"
             "    -F           float time format in CON 0 PostgreSQL\n"
             "    -I           integer time format in CON 0 PostgreSQL\n"
             "Hooked up:\n"
           )
    ;
    for (i = 0; DBASE(i); i++) {
        q = index(DBASE(i)->name, '\0');
        fprintf(stderr, "  %s %s %s\n", DBASE(i)->id, DBASE(i)->name, ++q);
    }
    for (i = 0; JOBE(i); i++) {
        q = index(JOBE(i)->name, '\0');
        fprintf(stderr, "  %s %s %s\n", JOBE(i)->id, JOBE(i)->name, ++q);
    }
    for (i = 0; STYLS(i); i++) {
        q = index(STYLS(i)->name, '\0');
        fprintf(stderr, "  %s %s %s\n", STYLS(i)->id, STYLS(i)->name, ++q);
    }
    exit(ex);
}

static int
/***************************************************************************************
 **                                                                                   **/
cmdin(pgoblin_main *options, pgoblin_prog *pgm, pgoblin_cmd cmd, babolo_opts *bos) { /**
 **                                                                                   **
 ***************************************************************************************/
#   define blin_internal_flags (options->flags)
    int ex = EX_OK;

    if  (pgm->curr < pgm->maxx) {
        pgm->code[pgm->curr].cmd = cmd;
        if  (!(pgm->code[pgm->curr].lit = strdup(babolo_getoptsarg(bos)))) {
            ifBLIN_QW0("babolo_getoptsarg -%c", bos->c);
            ex = EX_USAGE;
        } else {
            pgm->curr++;
        }
    } else {
        ifBLIN_QX0("To big program");
        errno = EFBIG;
        ex = EX_SOFTWARE;
    }
    return(ex);
#   undef blin_internal_flags
}

static mife_descriptor *
/**********************************************************************
 **                                                                  **/
popin(pgoblin_main *options) {                                      /**
 **                                                                  **
 **********************************************************************/
    mife_descriptor *in = NULL;
    int              tmpi = 0;

    if  (!(in = mife_init(PGOBLIN_MIFEFLAGS))) {
        ifBLIN_QW0("mife_init");
    } else if (options->stack[options->sp]) {
        tmpi = mife_ctl(in, MIFE_CTLFILE, options->stack[options->sp++]);
    } else {
        tmpi = mife_ctl(in, MIFE_CTLFDSC, fileno(stdin));
    }
    if  ((0 > tmpi) && in) {
        mife_ctl(in,  MIFE_CTLFINI);
        in = NULL;
    }
    return(in);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
main(int argc, char *argv[], char **envp) {                         /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
#   define blin_internal_flags (options->flags)
    const char      *Tflag = NULL;
    babolo_opts     *bos = NULL;
    int              ex = EX_OK;
    int              ldn = -1;
    pgoblin_main    *options;
    pgoblin_exenv   *exenv;
    ssize_t          txlen;
    u_int            spmax;
    u_char          *text;
    u_int32_t        tmp;
    mife_descriptor *in;
    const char      *o;
    int              c;
    /* ,     flar   '1'.
     * ,        ,
     * . htman(),  flar   .
     */
    const char *flar = "aAbB:c:C:d:D:e:f:Fh:IL:Np:P:qs:S:t:U:vVw:X:=:?";

    if  (!(options = pgoblin_init( BLIN_BIT0 | PGOBLIN_DEFAULDB
                                 | PGOBLIN_ERROR_SENSOR | PGOBLIN_CLEAR_ONEXIT
                                 , fileno(stdout)
        ) )                      ) {
        ifBLIN_QW0("pgoblin_init");
        ex = EX_OSERR;
        goto out;
    }
    spmax = (argc + 16);
    if  (!(options->stack = malloc(sizeof(char**) * (spmax + 1)))) {
        ifBLIN_QX0("Malloc failed #2");
        ex = EX_OSERR;
        goto out;
    }
    if  (!(exenv = calloc(1, sizeof(pgoblin_exenv)))) {
        ifBLIN_QW0("no mem for exenv");
        ex = EX_OSERR;
        goto out;
    }
    exenv->options = options;
    exenv->flags = options->flags & BLIN_MASK;
    if  (!(exenv->pgm = calloc(1, sizeof(pgoblin_tuple) * PGOBLIN_PROGSIZE + sizeof(pgoblin_prog)))) {
        ifBLIN_QW0("Calloc failed #3");
        ex = EX_OSERR;
        goto out;
    }
    options->sp = 0;
    options->stack[0] = NULL;
    options->argv = argv;
    options->envp = envp;
    strncpy(exenv->pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_LEN);
    exenv->pgm->maxx = PGOBLIN_PROGSIZE;
    exenv->pgm->curr = 0;
    exenv->pgm->debug = NULL;
    if  (!(bos = babolo_openopts(Bpars_NONU | Bpars_SYME, 'Z'))) {
        ifBLIN_QW0("babolo_openopts");
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (babolo_setopts(bos, Bpars_NONU, argc, argv, flar)) {
        ifBLIN_QW0("babolo_setopts");
        ex = EX_SOFTWARE;
        goto out;
    }
    while (0 < (c = babolo_getopts(bos))) {
        switch (c) {
        case 'a': options->flags |= PGOBLIN_COPEND_PASS;
//    COPY ( \.)    #copyout.
                ; break;
        case 'A': options->flags |= PGOBLIN_COPEND_APND;
//    COPY ( \.)    #copyout,    .
                ; break;
        case 'b': options->flags |= PGOBLIN_COPEND_NOGEN;
//     COPY ( \.)  #get***.
//     #get*** ,   getCGIparm.
                ; break;
        case 'B': if  (!(o = babolo_getoptsarg(bos))) {
// Ar 
//    .
                ;     ifBLIN_QW0("No -%c arg", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; if  (ldn >= 0) {
                ;     ifBLIN_QX1("Dublicate DBMS definition %s", o);
                ; } else if (0 > (ldn = pgoblin_load(options, 3, o, -1))) {
                ;     ifBLIN_QX1("Illegal DBMS %s", o);
                ; }
                ; break;
        case 'c': if  (cmdin(options, exenv->pgm, PGOBLIN_copyout, bos)) {
// Ar 
//  #copyout      .
                ;     ifBLIN_QW0("-%c cmdin", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'C': if  (cmdin(options, exenv->pgm, PGOBLIN_copyin, bos)) {
// Ar 
//  #copyin      .
                ;     ifBLIN_QW0("-%c cmdin", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; break;
        case 'd': if  (!(options->conn[0].dbname = babolo_getoptsarg(bos))) {
// Ar 
//   
                      ifBLIN_QW0("No -%c arg", bos->c);
                      ex = EX_USAGE;
                      goto out;
                ; }
                ; break;
        case 'D': if  (cmdin(options, exenv->pgm, PGOBLIN_perform, bos)) {
// Ar 
//  #perform      .
                      ifBLIN_QW0("-%c cmdin", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 'e': if  (!(o = babolo_getoptsarg(bos))) {
// Ar 
//    .
                      ifBLIN_QW0("No -%c arg", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; if  ((ex = pgoblin_parser(options, (u_char*)o, strlen(o), &exenv->pgm))) {
                      ifBLIN_QW0("Syntax?");
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 'f': if  (!(options->stack[options->sp] = babolo_getoptsarg(bos))) {
// Ar 
//  .     .
                      ifBLIN_QW0("No -%c arg", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; if  (options->stack[options->sp]) options->stack[++options->sp] = NULL;
                ; break;
        case 'F': if  (options->conn[0].flags & PGOBLIN_INT64TIME) {
//    CON 0 .
                ;     MARK_R_CONN_NGO(0);;
                ;     ;;  options->conn[0].flags |= PGOBLIN_NEEDINTIME;
                ;     ;;  options->conn[0].flags &= ~PGOBLIN_INT64TIME;
                ;     MARK_R_CONN_NWENT(0);;
                ; } else {
                ;     MARK_R_CONN_NGO(0);;
                ;     ;;  options->conn[0].flags |= PGOBLIN_FLOATTIME;
                ;     MARK_R_CONN_NWENT(0);;
                ; }
                ; break;
        case 'h': if  (!(options->conn[0].host = babolo_getoptsarg(bos))) {
// Ar 
//    CON 0.
                      ifBLIN_QW0("No -%c arg", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 'I': if  (options->conn[0].flags & PGOBLIN_FLOATTIME) {
//    CON 0 .
                ;     MARK_R_CONN_NGO(0);;
                ;     ;;  options->conn[0].flags |= PGOBLIN_NEEDINTIME;
                ;     ;;  options->conn[0].flags &= ~PGOBLIN_FLOATTIME;
                ;     MARK_R_CONN_NWENT(0);;
                ; } else {
                ;     MARK_R_CONN_NGO(0);;
                ;     ;;  options->conn[0].flags |= PGOBLIN_INT64TIME;
                ;     MARK_R_CONN_NWENT(0);;
                ; }
                ; break;
        case 'L': if  (!(options->libexec = babolo_getoptsarg(bos))) {
// Ar    
//      ,    .
                      ifBLIN_QW0("No -%c arg", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 'N':
                ; break;
        case 'p': if  (!(options->conn[0].port = babolo_getoptsarg(bos))) {
//    CON 0.
                      ifBLIN_QW0("No -%c arg", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 'P': if  (!(options->conn[0].password = babolo_getoptsarg(bos))) {
// Ar 
//      
                      ifBLIN_QW0("No -%c arg", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 'q': options->flags &= ~BLIN_MASK;
//   .
                ; break;
        case 's': if  (cmdin(options, exenv->pgm, PGOBLIN_strselect, bos)) {
// Ar 
//  #strselect      .
                      ifBLIN_QW0("-%c cmdin", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 'S': if  (cmdin(options, exenv->pgm, PGOBLIN_binselect, bos)) {
// Ar 
//  #binselect      .
                      ifBLIN_QW0("-%c cmdin", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 't': errno = 0;
// Ar 
//       #listen.   1 .
                ; options->maxtmout = babolo_getoptunum(bos, 0) * 1000;
                ; if  (errno) {
                      ifBLIN_QW0("-%s babolo_getoptunum", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 'U': if  (!(options->conn[0].username = babolo_getoptsarg(bos))) {
// Ar 
//    
                      ifBLIN_QW0("No -%c arg", bos->c);
                      ex = EX_USAGE;
                      goto out;
                  }
                ; break;
        case 'v': BLIN_VERBOSE(options->flags);
//   .
//  :
//u
// 0 -      
// 1 -      stderr
// 2 -  stderr    ,   
//  3 -  
//u
//      1.
                ; break;
        case 'V': if  (options->flags & PGOBLIN_VERIFY) {
//      .
//     .
                ;     pgoblin_VVdump();
                ; } else {
                ;     options->flags |= PGOBLIN_VERIFY;
                ; }
                ; break;
        case 'w': errno = 0;
// Ar 
//         ,   255,   255.
//   .      ,  .
                ; tmp = babolo_getoptunum(bos, 0);
                ; if  (errno) {
                ;     ifBLIN_QW0("-%c babolo_getoptunum", bos->c);
                ;     ex = EX_USAGE;
                ;     goto out;
                ; }
                ; options->maxtmout = tmp;
                ; options->flags |= ((tmp > 255) ? 255 : tmp);
                ; break;
        case 'X': {   if  (!(options->ftrace = babolo_getoptsarg(bos))) {
// Ar 
//        .
//     pgoblin   
//     .
                ;         ifBLIN_QW0("No -%c arg", bos->c);
                ;         ex = EX_USAGE;
                ;         goto out;
                ;     }
                ;     options->xtrace = open( options->ftrace
                                            , O_WRONLY | O_APPEND | O_CREAT | O_TRUNC | O_EXLOCK
                                            , 0666
                                            );
                ;     if  (0 > options->xtrace) {
                ;         ifBLIN_QW0("open(%s, WRONLY|APPEND|CREAT|TRUNC|EXLOCK)", options->ftrace);
                ;         ex = EX_IOERR;
                ;         goto out;
                ;     } else {
                ;         close(options->xtrace);
                ; }   }
                ; break;
        case '=': switch((Tflag = babolo_getoptsarg(bos))[0]) {
// Ar 
//  ,    ,
//      .
                  case '0': blin_ctl(BLIN_CTL_DUMP);           exit(EX_OK);
                  case '1': babolo_optest(flar);               exit(EX_OK);
                  case '2': babolo_optext(bos);                exit(EX_OK);
                  case '3': babolo_dumpopts(bos);              exit(EX_OK);
                  case 'C': ex = htman(options->flags);        exit(ex);
                  case 'K': ex = keycodes(options);            exit(ex);
                  case 'R': regtran();                         exit(EX_OK);
                  case 'X':
                      options->sp = 0;
                      exit((ex = pgoblin_traceat(options, popin, Tflag)));
                  case 'B':
                      ldn = strtol(++Tflag, NULL, 0);
                      for (int symreg = 0; symreg < pgoblin.symparam; symreg++) {
                          int binreg = pgoblin_breg(ldn, symreg);

                          printf("%c", (0 > binreg) ? '.' : ('0' + binreg));
                      }
                      printf("\n");
                      exit(EX_OK);
                  case 'f': tinr(&options->demaskf, Tflag);    break;
                  case 't': tinr(&options->demaskt, Tflag);    break;
                  case 'm': tinr(&options->demaskm, Tflag);    break;
                  case 'q': tinr(&options->demaskq, Tflag);    break;
                  case 'o': tinr(&options->demasko, Tflag);    break;
                  case 'c': tinr(&options->demaskc, Tflag);    break;
                  case 'j': tinr(&options->demaskj, Tflag);    break;
                  case 's': tinr(&options->demasks, Tflag);    break;
                  default:                                     break;
                  }
                ; break;
        case '?': usage(EX_OK);
//  .
        default : usage(EX_USAGE);
    }   }
    MARK_IO_MIFE_NGO(0);;
    ;;  MARK_IO_OUT_NGO(0);;
    ;;  ;;  options->io[0].flags |= options->flags & BLIN_MASK;
    ;;  MARK_IO_OUT_NWENT(0);;
    MARK_IO_MIFE_NWENT(0);;
    if  ((0 > ldn) && (0 > (ldn = pgoblin_load(options, 3, "0", -1)))) {
        ifBLIN_QX1("Can't load DB 0");
        goto out;
    }
    for (int i = 0; i < (!!(options->flags & PGOBLIN_DEFAULDB) ? pgoblin.regsize : 1); ++i) {
        MARK_R_CONN_NGO(i);;
        ;;  options->conn[i].flags |= (options->flags & BLIN_MASK) | ldn;
        MARK_R_CONN_NWENT(i);;
    }
    if  (0 > (ldn = pgoblin_load(options, 4, "local", -1))) {
        ifBLIN_QW0("Can't load JOB local");
        goto out;
    }
    MARK_R_JOB_NGO(0);;
    ;;  options->job[0].flags |= (options->flags & BLIN_MASK) | ldn;
    MARK_R_JOB_NWENT(0);;
    if  (0 > (ldn = pgoblin_load(options, 5, "0", -1))) {
        ifBLIN_QW0("Can't load STYLE 0");
        goto out;
    }
    MARK_R_STYLE_NGO(0);;
    ;;  options->style[0].flags |= (options->flags & BLIN_MASK) | ldn;
    MARK_R_STYLE_NWENT(0);;
    if  (options->flags & PGOBLIN_VERIFY) pgoblin_verify(options);
    options->ap = options->sp;
    while ((o = babolo_getargs(bos))) {
        options->stack[options->sp++] = o;
        if  (options->sp >= spmax) {
            ifBLIN_QX0("Arg list too grows");
    }   }
    options->stack[options->sp] = NULL;
    options->sp = 0;
    if  (!exenv->pgm->curr) {
        if  (!(in = popin(options))) {
            ifBLIN_QW0("Programm");
            ex = EX_IOERR;
        } else if ((txlen = mife_ctl(in, MIFE_CTLREAD, (off_t)0, (ssize_t)0)) < 0) {
            ifBLIN_QW0("mife_ctl(MIFE_CTLREAD)");
            ex = EX_IOERR;
        } else if (!(text = mife_point(in, MIFE_POINTER))) {
            ifBLIN_QW0("Program get failed");
            ex = EX_IOERR;
        } else if (pgoblin_parser(options, text, txlen, &exenv->pgm)) {
            ifBLIN_QX0("Parser failed");
            ex = EX_DATAERR;
    }   }
    if  (!ex) {
        MARK_IO_MIFE_NGO(0);;
        ;;  if  ((options->io[0].mife = popin(options))) {
        ;;      options->io[0].pid = 0;
        ;;      options->io[0].offset = 0;
        ;;      options->io[0].flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
        ;;  }
        MARK_IO_MIFE_NWENT(0);;
        if  (options->flags & PGOBLIN_VERIFY) pgoblin_Vdump(exenv->options, exenv->pgm);
        if  ((ex = pgoblin_execute(exenv->options, exenv->pgm, NULL, NULL, 0))) {
            ifBLIN_QX0("Execute failed");
    }   }
out:
    babolo_closeopts(bos);
    return(ex);
#   undef blin_internal_flags
}
