/*-
 * Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: parser.c,v 1.62 2018/07/25 16:34:11 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"

#define L0 0 /* \0           */
#define Ll 1 /*   */
#define Lb 2 /*        */
#define Ls 3 /*    */
#define Ld 4 /* #            */
#define Lo 5 /*     */
#define Lx 6

static const char *clasnames[] =
{ "L0", "Ll", "Lb", "Ls", "Ld", "Lo", "Lx"};

static const char class[256] =
{ L0, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lb, Ll, Ll,  Lo, Ll, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lb, Lo, Lo, Ld,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, -1, -2, -3, -4,  -5, -6, -7, -8,  -9,-10, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo,-11,-12,-13, -14,-15,-16,-17, -18,-19,-20,-21, -22,-23,-24,-25
,-26,-27,-28,-29, -30,-31,-32,-33, -34,-35,-36, Lo,  Lo, Lo, Lo,-63
, Lo,-37,-38,-39, -40,-41,-42,-43, -44,-45,-46,-47, -48,-49,-50,-51
,-52,-53,-54,-55, -56,-57,-58,-59, -60,-61,-62, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
};

static const char statenames[][3] =
{ "bg", "bs", "nl", "nq", "tc", "tb", "tp", "sc", "cl", "cq", "ml", "mc", "tq", "xx"};

enum states
{ bg /*                                */
, bs /*                                 */
, nl /*                           */
, nq /*     ?       */
, tc /*                 */
, tb /*         */
, tp /*                                */
, sc /*       () */
, cl /*                        */
, cq /* ?                       */
, ml /*                           */
, mc /*                                 */
, tq /*   ?                 */
, xx
};

static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "- ", "- ", "Cp", "- ", "Cb", "Ce", "Cc", "Ci"
, "Co", "Cl", "- ", "- ", "Cx", "Cy", "- ", "- "
};

#define Cp  0x200000 /*             */
#define Cb  0x080000 /*       */
#define Ce  0x040000 /*        */
#define Cc  0x020000 /*               */
#define Ci  0x010000 /*     */
#define Co  0x008000 /*             */
#define Cl  0x004000 /*  lexor                   */
#define Cj  0x001000 /*     */
#define Cx  0x000800 /*                 */
#define Cy  0x000400 /*                    */
#define C_state 0xFF /*           */
#define Cio (Ci | Co)
#define Cd  (Cb | Ce)

static u_int32_t automa[xx][Lx] =
/*    \0 L0        \n Ll      \b Lb   Ls       # Ld       * Lo  *    @          */
{{    Cx|xx,          nl,        bs,        bs,        nq,        bs}/* bg @                   */
,{    Cx|xx,          nl,        bs,        bs,        bs,        bs}/* bs @                   */
,{    Cx|xx,          nl,        bs,        bs,        nq,        bs}/* nl @                */
,{ Co|Cl|xx,  Co|Cl|  cl,  Co|Cl|tb,  Co|Cl|tc,        bs,  Co|Cl|sc}/* nq @ 1           */
,{ Cl|Cj|xx,     Cl|  cl,     Cl|tb,     Cl|tc,     Cl|sc,     Cl|sc}/* tc                    */
,{Ci |   xx,          cl,        tb, Cp|    tp,        sc,        sc}/* tb        */
,{Ci |   xx,          cl,        sc, Cp|    tp,        sc,        sc}/* tp           */
,{Ci |   xx,          cl,        sc,        sc,        sc,        sc}/* sc                */
,{Ci |   xx, Cd|   Cc|ml, Cd|Cc| mc, Cd|Cc| mc,        cq, Cd|Cc| mc}/* cl               */
,{Cio|Cl|xx, Cio|Cl|  ml, Cio|Cl|tb, Cio|Cl|tc, Cd|Cc| mc, Cio|Cl|sc}/* q   1           */
,{Ci |   xx,    Ce|Cc|ml,    Cc| mc,    Cc| mc,        tq,    Cc| mc}/* ml #             */
,{Ce|Cc|Ci|xx,  Ce|Cc|ml,    Cc| mc,    Cc| mc, Cc|    mc,    Cc| mc}/* mc #                 */
,{Cio|Cl|xx, Cio|Cl|  cl, Cio|Cl|tb, Cio|Cl|tc, Cc|    mc, Cio|Cl|sc}/* tq # 1           */
};                                                                      /* #                  */

static int
/**********************************************************************
 **                                                                  **/
placmd( pgoblin_main *options                                       /**/
/**/  , pgoblin_prog *pgm                                           /**/
/**/  , u_int64_t     r_parm                                        /**/
/**/  , u_int32_t     r_cmd                                         /**/
/**/  , char         *r_beg                                         /**/
/**/  , u_char       *r_end                                         /**/
/**/  , int           lfcount                                       /**/
/**/  , u_int32_t    *localflags                                    /**/
/**/  ) {                                                           /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK;
    int i;

#   define blin_internal_flags (options->flags & BLIN_MASK)
    ifBLIN_QX2("[%"BLIN_D"]=%02X(%016"BLIN_O"X)", pgm->curr, r_cmd, r_parm);
    if  (!r_cmd) {
        ifBLIN_QX0("Unknown command at line %d", lfcount);
        ERROUT(EX_DATAERR, EINVAL);
    } else if (r_cmd > pgoblin.max) {
        ifBLIN_QX0("Out of command range at line %d", lfcount);
        ERROUT(EX_SOFTWARE, EDOOFUS);
    }
    ifBLIN_QX3("[%08X]", pgoblin.a[r_cmd].flags);
    if  (!(~pgoblin.a[r_cmd].flags & PGOBLIN_ILLEGAL)) {
        ifBLIN_QX0("Illegal command at line %d", lfcount);
        ERROUT(EX_SOFTWARE, EDOOFUS);
    } else if (pgm->curr > pgm->maxx) {
        ifBLIN_QX0("Programm too big");
        ERROUT(EX_SOFTWARE, EFBIG);
    } else if (pgoblin.a[r_cmd].flags & PGOBLIN_IGNORE) {
        *localflags |= PGOBLIN_IGNORE;
    } else if (!(*localflags & PGOBLIN_IGNORE) || (r_cmd != PGOBLIN_cont)) {
        u_int32_t cc;
        int b;

        cc = 0;
        *localflags &= ~PGOBLIN_IGNORE;
        for (i = 0; i < pgoblin.symparam; i++) {
            if  (0 <= (b = pgoblin_breg(r_cmd, i))) {
                u_int32_t y = pgoblin.binparams[b];

                cc &= ~(PGOBLIN_ARGMASK << y);
                cc |= ((r_parm & PGOBLIN_ARGMASK) << y);
            }
            r_parm >>= PGOBLIN_BPARG;
        }
        if  (r_cmd & PGOBLIN_EXTENDED) {
            pgm->code[pgm->curr].cmd = PGOBLIN_extended | (cc & ~PGOBLIN_COMMAND);
            pgm->code[pgm->curr].ecmd = (r_cmd & PGOBLIN_COMMAND);
        } else {
            pgm->code[pgm->curr].cmd = (r_cmd & PGOBLIN_COMMAND) | (cc & ~PGOBLIN_COMMAND);
            pgm->code[pgm->curr].lit = NULL;
            if  (r_beg && r_end) {
                *r_end = '\0';
                if  (!(pgoblin.a[r_cmd].flags & PGOBLIN_NOLITER)) {
                    pgm->code[pgm->curr].lit = r_beg;
                }
                if  (pgm->code[pgm->curr].lit) {
                        ifBLIN_QX2(">%s~", pgm->code[pgm->curr].lit);
        }   }   }
        pgm->curr++;
    }
out:
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_ctonr(char c) {                                             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    return(~class[c & 0xFF]);
}

int
/********************************************************************************************
 ********************************************************************************************
 **                                                                                        **/
pgoblin_parser(pgoblin_main *options, u_char *text, ssize_t txlen, pgoblin_prog **ppgm) { /**
 **                                                                                        **
 ********************************************************************************************
 ********************************************************************************************/
    u_char        *literal = NULL;
    char          *r_beg = NULL;
    u_char        *r_end = NULL;
    u_int32_t      localflags;
    int            ex = EX_OK;
    pgoblin_prog  *pgm = NULL;
    int            lfcount;
    u_int32_t      control;
    u_int64_t      r_parm;
    ssize_t        offset;
    enum states    state;
    u_int32_t      r_cmd;
    u_int32_t      r_lex;
    const u_char  *qp;
    const u_char **qq;
    int            rs;
    char           p;
    u_char         s;

#   define blin_internal_flags (options->flags & BLIN_MASK)
    ifBLIN_QX2( "+ options %s, ppgm %s txt %"BLIN_D
              , options ? "OK" : "NULL"
              , ppgm ? "OK" : "NULL"
              , txlen
              );
    if  (!text && txlen) {
        ifBLIN_QX0("No pgoblin program text");
        ERROUT(EX_DATAERR, EINVAL);
    } else if (!ppgm) {
        ifBLIN_QX0("No pgoblin program");
        ERROUT(EX_DATAERR, EINVAL);
    } else if (!!(pgm = *ppgm)) {
        ifBLIN_QX2("pgm %s", pgm ? "OK" : "NULL");
        if  (strncmp(pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_TST)) {
            ifBLIN_QX0("Illegal pgoblin program");
            ERROUT(EX_DATAERR, EPROGMISMATCH);
        }
    } else {
        if  (!(pgm = malloc(sizeof(pgoblin_tuple) * PGOBLIN_PROGSIZE + sizeof(pgoblin_prog)))) {
            ifBLIN_QX0("Malloc failed in parser #1");
            ERROUT(EX_OSERR, ENOMEM);
        }
        bzero(pgm, sizeof(pgoblin_tuple) * PGOBLIN_PROGSIZE + sizeof(pgoblin_prog));
        strncpy(pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_LEN);
        pgm->maxx = PGOBLIN_PROGSIZE;
        pgm->curr = 0;
        pgm->debug = NULL;
    }
    if  (0 >= txlen) {
        ifBLIN_QX1("Empty pgoblin program text");
        goto out;
    }
    ifBLIN_QX3("pgm@%"BLIN_D":%"BLIN_D, pgm->curr, pgm->maxx);
    blin_stateheader(BLIN_4STA24G, pn);
    lfcount = 0;
    qp = &s;
    qq = &qp;
    r_parm = 0;
    r_lex = 0;
    r_cmd = 0;
    rs = -PGOBLIN_BPARG;
    localflags = PGOBLIN_IGNORE;
    for (state = bg, offset = 0, control = 0; state < xx; offset++, state = control & C_state) {
        if  (offset < txlen) {
            s = text[offset];
            p = class[s];
            if  (p < 0) p = Ls;
            if  (s == '\n') lfcount++;
        } else {
            p = L0;
            s = 0;
        }
        control = automa[state][(u_char)p];
        blin_statebody( BLIN_4STO24G
                      , pn
                      , statenames
                      , clasnames[(u_char)p]
                      , (char*)text
                      , offset
                      , control
                      , state
                      , r_lex
                      , rs & 0xFF
                      );
        if  (control & Cp) r_parm |= (~(u_int64_t)(class[s])) << (rs += PGOBLIN_BPARG);
        if  (control & Cb && !r_beg) r_beg = (char*)(literal = &text[offset]);
        if  (control & Ce && r_beg) r_end = literal;
        if  (control & Cc) {
            if  (!literal) {
                ifBLIN_QX0("  @ line %d", lfcount - 1);
                errno = EINVAL;
                ex = EX_DATAERR;
                goto out;
            }
            if  (literal != &text[offset]) *literal = text[offset];
            literal++;
        }
        if  (control & Ci) {
            if  (r_lex >= pgoblin.cmds->szt) r_cmd = ~r_lex;
            if  ((ex = placmd(options, pgm, r_parm, r_cmd, r_beg, r_end, lfcount, &localflags)))
                goto out;
        }
        if  (control & Co) {
            r_lex = 0;
            r_cmd = 0;
            r_parm = 0;
            rs = -PGOBLIN_BPARG;
            r_beg = 0;
            r_end = 0;
        }
        if  (control & Cl) {
            qp = &s;
            r_lex = babolo_testchar(pgoblin.cmds, r_lex, (const char**)qq);
        }
        if  (control & Cj) {
            if  (r_lex >= pgoblin.cmds->szt) r_cmd = ~r_lex;
            if  ((ex = placmd(options, pgm, r_parm, r_cmd, r_beg, r_end, lfcount, &localflags))) {
                goto out;
        }   }
        if  (control & Cx) {
            ifBLIN_QX1(" ");
        }
        if  (control & Cy) {
            errno = EINVAL;
            ex = EX_DATAERR;
    }   }
out:
    *ppgm = pgm;
    ifBLIN_QX2("- %d pgm %s", ex, pgm ? "OK" : "NULL");
    return(ex);
#   undef blin_internal_flags
}
