/*-
 * Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: job_local.c,v 1.36 2018/08/13 20:54:27 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fts.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

static int
/**********************************************************************
 **                                                                  **/
init(u_int32_t flags) {                                             /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
fini() {                                                            /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}

static int
/**********************************************************************
 **                                                                  **/
none(pgoblin_exenv *exenv, pgoblin_nr *rn) {                        /**
 **                                                                  **
 **********************************************************************/
    return(EX_OK);
}
 
static int
/**********************************************************************
 **                                                                  **/
jpen(pgoblin_exenv *exenv, pgoblin_nr *rn, void *opt) {             /**
 **                                                                  **
 **********************************************************************/
    exenv->options->flags |= PGOBLIN_INITED;
    return(EX_OK);
}

static u_int32_t
/**********************************************************************
 **                                                                  **/
jest(pgoblin_command cmd) {                                         /**
 **                                                                  **
 **********************************************************************/
    u_int32_t e;

    if  (cmd == PGOBLIN_fork) e = PGOBLIN_TVFORK; else e = PGOBLIN_TOFORK | PGOBLIN_TOEXIT;
    return(e);
}

static int
/**********************************************************************
 **                                                                  **/
jxec(pgoblin_exenv *exenv, pgoblin_nr *rn, char **argv) {           /**
 **                                                                  **
 **********************************************************************/
    int ex = 0;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX4( "+ %d %d %d %d %08X argv %s"
              , rn[PGO_COUT], rn[PGO_CCTL], rn[PGO_CIN], rn[PGO_CJOB]
              , exenv->flags, argv ? "OK" : "NULL"
              );
    ifBLIN_QO5 {
        int z;
        for (z = 0; argv[z]; z++) fprintf(stderr, "[%d]=%s~\n", z, argv[z]);
    }
    if  (argv && !ex) {
        int g;
        /************************************************
         * local_exec  ,    *
         ************************************************/
    ;   if  (dup2(exenv->options->io[rn[PGO_CIN]].mife->f.fd, fileno(stdin)) < 0) {
    ;       ifBLIN_QW0("dup2 #4");
    ;       ex = -EX_OSERR;
    ;       exit(ex);
    ;   }
    ;   if  (dup2(exenv->options->io[rn[PGO_COUT]].onu, fileno(stdout)) < 0) {
    ;       ifBLIN_QW0("dup2 #3");
    ;       ex = -EX_OSERR;
    ;       exit(ex);
    ;   }
    ;   if  (exenv->options->flags & PGOBLIN_FORK_WAIT) {
    ;       ifBLIN_QX2("sleep %us in fork", exenv->options->flags & PGOBLIN_FORK_WAIT);
    ;       sleep(exenv->options->flags & PGOBLIN_FORK_WAIT);
    ;   }
    ;   for (g = 0; g < pgoblin.regsize; g++) {
#           define R exenv->options->io[g]
    ;       if  (R.mife && (R.mife->f.fd != fileno(stdin)) && (R.mife->f.fd != fileno(stdout))) {
    ;           if  ((R.flags & PGOBLIN_FREEMIFE) && (ex = mife_fini(R.mife)))
                    ifBLIN_QW0("mife_fini in exec");
    ;       }
    ;       if  (R.clo && (R.onu != fileno(stdin)) && (R.onu != fileno(stdout))) {
    ;           if  ((R.flags & PGOBLIN_FREEOUTS) && (ex = R.clo(R.onu)))
                    ifBLIN_QW0("clo in exec");
    ;       }
#           undef R
    ;   }
    ;   execve(argv[0], argv, exenv->options->envp);
    ;   ex = EX_OSERR;
        ifBLIN_QW0("execve %s", argv[0]);
    }
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
jait(pgoblin_exenv *exenv, pgoblin_nr *rn) {                        /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK, exx = EX_OK, status;
    pgoblin_jobreg *rj;
    pgoblin_jobl *j;
    size_t i;

    rj = &(exenv->options->job[rn[PGO_CJOB]]);
#   define blin_internal_flags (rj->flags & BLIN_MASK)
    if  (rj) {
        ifBLIN_QX4("+");
        for (i = 0; i <  MULAR_NEXT(rj->pids); i++) {
            j = mular_getix(rj->pids, i);
            if  (!(j->pid)) {
                ifBLIN_QX0("No pid in %d", (int)j->cmdn);
                errno = EINVAL;
                ex = EX_SOFTWARE;
            } else if ((j->cmdn >= 0) && (j->status == PGOBLIN_NOSTATUS)) {
                if  ((ex = waitpid(j->pid, &status, 0)) < 0) {
                    ifBLIN_QW1("Pid %d in %d", j->pid, (int)j->cmdn);
                    ex = EX_OSERR;
                } else if (ex == j->pid) {
                    j->status = status;
                    ifBLIN_QX3( " st=%08X fl=%08X ex=%d exx=%d IFEX=%d EXST=%d"
                              , status, rj->flags, ex, exx, WIFEXITED(status), WEXITSTATUS(status)
                              );
                    if  (  (rj->flags & PGOBLIN_ERROR_SENSOR)
                        && WIFEXITED(status)
                        && WEXITSTATUS(status)
                        ) exx = WEXITSTATUS(status);
                    if  ((rj->flags & PGOBLIN_ERROR_SENSIB) && exx) break;
                    ex = EX_OK;
                } else {
                    ifBLIN_QW0("Pid %d<>%d in %d", ex, j->pid, (int)j->cmdn);
                    ex = EX_OSERR;
        }   }   }
        ifBLIN_QX4("- %d", ex);
    }
    return(ex ? ex : exx);
#   undef blin_internal_flags
}

static pgoblin_dir*
/**********************************************************************
 **                                                                  **/
jdir(pgoblin_exenv *exenv, pgoblin_dir *dir, char *path) {          /**
 **                                                                  **
 **********************************************************************/
    pgoblin_dir *d = NULL;
    int ex = EX_OK;
    FTSENT *ent;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    if  (!dir == !path) {
        ifBLIN_QX0("local: exactly one of dir and path should be");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (path) {
        char *p[2] = {NULL, NULL};

        if  (!(d = calloc(1, sizeof(pgoblin_dir)))) {
            ifBLIN_QX0("local dir: no mem");
            ERROUT(EX_OSERR, ENOMEM);
        }
        d->i = 0;
        d->f = 1;
        d->g = 1;
        p[0] = path;
        if  (!(d->dirp = fts_open(p, FTS_PHYSICAL | FTS_NOCHDIR | FTS_SEEDOT, NULL))) {
            ifBLIN_QX0("local dir: no fts");
            ERROUT(EX_OSERR, EIO);
        }
    } else {
        d = dir;
        d->i += d->g;
        d->g = 1;
    }
    for (;;) {
        if  (!(ent = fts_read(d->dirp))) {
            if  (d->dirp) fts_close(d->dirp);
            free(d);
            d = NULL;
            break;
        }
        switch(ent->fts_info) {
        case FTS_SLNONE:
        case FTS_DP:
            continue;
        case FTS_SL:
            fts_set(d->dirp, ent, FTS_FOLLOW);
            d->g = 0;
            break;
        case FTS_DOT:
        case FTS_DC:
        case FTS_D:
            if  (d->f) {
                d->f = 0;
                continue;
            } else fts_set(d->dirp, ent, FTS_SKIP);
            /* FALLTHRU */
        case FTS_DEFAULT:
        case FTS_F:
            break;
        case FTS_DNR:
            errno = ent->fts_errno;
            ifBLIN_QW1("fts_read DNR");
            break;
        case FTS_NS:
            errno = ent->fts_errno;
            ifBLIN_QW1("fts_read NS");
            /* FALLTHRU */
        case FTS_NSOK:
            ent->fts_statp = NULL;
            break;
        case FTS_ERR:
            errno = ent->fts_errno;
            ifBLIN_QW0("fts_read");
            ex = EX_OSERR;
            goto out;
        default:
            ifBLIN_QW0("unknown fts_read");
            ERROUT(EX_OSERR, EIO);
        }
        d->sb = ent->fts_statp;
        d->ent = ent->fts_name;
        break;
    }
out:
    if  (ex) {
        if  (d) {
            if  (d->dirp) fts_close(d->dirp);
            free(d);
            d = NULL;
    }   }
    return(d);
#   undef blin_internal_flags
}

pgoblin_jobs pgoblin_job_local =
{ 0
, "4pGoblin-" VERS
, "local\0" VERS
, 0
, init
, fini
, jpen
, jest
, none /* jork */
, jxec
, jait
, none /* jose */
, jdir
, NULL
, NULL
};
