/*-
 * Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: execute.c,v 1.164 2018/09/13 18:11:43 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MULAR_COMPAT     0
#define MIFE_COMPAT      4
#define RECOBE_COMPAT    4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <dlfcn.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <babolo/recobe.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"

BLIN_flag pgoblin_default;
static size_t u12[] = {341, 512, 512};

static struct {
    char *nm;
    void *mod;
} mods[PGOBLIN_SYMREGS][3] =
{ { {     NULL, NULL}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {     NULL, NULL}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {     NULL, NULL}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"0"      , &pgoblin_db_0}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"local"  , &pgoblin_job_local}
  , {     NULL, NULL}
  , {     NULL, NULL}
  }
 ,{ {"0"      , &pgoblin_style_0}
  , {     NULL, NULL}
  , {     NULL, NULL}
} };

static void *
/**************************************************************************
 **************************************************************************
 **                                                                      **/
dload(pgoblin_main *options, int domain, int rs, const char *nm)      { /**
 **                                                                      **
 **************************************************************************
 **************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    char *libname = NULL;
    void *module = NULL;
    void *handle = NULL;

    if  (!!options->libexec) {
        asprintf(&libname, "%s/libpgoblin%d%.*s.so", options->libexec, domain, rs, nm);
        if  (!libname) {
            ifBLIN_QW0("No mem");
            goto out;
        }
        if  (!(handle = dlopen(libname, /* RTLD_NOW | */ RTLD_LAZY | RTLD_LOCAL))) {
            ifBLIN_QX1("dlopen %s: %s", libname, dlerror());
    }   }
    if  (!handle) {
        asprintf(&libname, PGOBLIN_LIBDIR"/libpgoblin%d%.*s.so", domain, rs, nm);
        if  (!libname) {
            ifBLIN_QW0("No mem");
            goto out;
        }
        if  (!(handle = dlopen(libname, /* RTLD_NOW | */ RTLD_LAZY | RTLD_LOCAL))) {
            ifBLIN_QX0("dlopen %s: %s", libname, dlerror());
            goto out;
    }   }
    if  ((!!handle) && !(module = dlsym(handle, "pgoblin_module"))) {
        ifBLIN_QX0("dlsym pgoblin_module: %s", dlerror());
        goto out;
    }
out:;
    return(module);
#   undef blin_internal_flags
}

int
/**************************************************************************
 **************************************************************************
 **                                                                      **/
pgoblin_load(pgoblin_main *options, int mode, const char *nm, int rs) { /**
 **                                                                      **
 **************************************************************************
 **************************************************************************/
#   define blin_internal_flags (options->flags & BLIN_MASK)
    int           loaded = -1;
    int           wrt;
    int           ex;
    int           i;

    if  (0 > rs) rs = strlen(nm);
    ifBLIN_QX4("Load %d [%d]=%.*s", mode, rs, rs, nm);
    switch(mode) {
    case 3:
        for (i = PGOBLIN_MODSHIFT; (i < pgoblin.dbtablesz) && !!pgoblin.dbasetable[i]; ++i) {
            if  (!strncmp(pgoblin.dbasetable[i]->name, nm, rs) && !pgoblin.dbasetable[i]->name[rs]) {
                loaded = i;
                goto out;
        }   }
        if  (i >= pgoblin.dbtablesz) {
            ifBLIN_QX0("No free slots for DB %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == i) {
            pgoblin.dbasetable[PGOBLIN_MODSHIFT] = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(options, i, pgoblin.dbasetable[PGOBLIN_MODSHIFT]->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  ((ex = pgoblin.dbasetable[PGOBLIN_MODSHIFT]->init( (options->flags & BLIN_MASK)
                                                                 | PGOBLIN_MODSHIFT
                ))                                               ) {
                ifBLIN_QW0("DB %s init failed", pgoblin.dbasetable[PGOBLIN_MODSHIFT]->name);
                pgoblin.dbasetable[PGOBLIN_MODSHIFT] = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            ++i;
        }
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        for (int k = 1; !!mods[mode][k].nm; ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                pgoblin.dbasetable[i] = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(options, i, pgoblin.dbasetable[i]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.dbasetable[i]->init((options->flags & BLIN_MASK) | i))) {
                    ifBLIN_QW0("DB %s init failed", pgoblin.dbasetable[i]->name);
                    pgoblin.dbasetable[i] = NULL;
                } else {
                    loaded = i;
        }   }   }
        if  (0 > loaded) {
            if  (!!(pgoblin.dbasetable[i] = dload(options, 3, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(options, i, pgoblin.dbasetable[i]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.dbasetable[i]->init((options->flags & BLIN_MASK) | i))) {
                    ifBLIN_QW0("DB %s init failed", pgoblin.dbasetable[i]->name);
                    pgoblin.dbasetable[i] = NULL;
                } else {
                    loaded = i;
        }   }   }
        break;
    case 4:
        for (i = PGOBLIN_MODSHIFT; (i < pgoblin.jobtabsiz) && !!pgoblin.jobtable[i]; ++i) {
            if  (!strncmp(pgoblin.jobtable[i]->name, nm, rs) && !pgoblin.jobtable[i]->name[rs]) {
                loaded = i;
                goto out;
        }   }
        if  (i >= pgoblin.jobtabsiz) {
            ifBLIN_QX0("No free slots for JOB %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == i) {
            pgoblin.jobtable[PGOBLIN_MODSHIFT] = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(options, i, pgoblin.jobtable[PGOBLIN_MODSHIFT]->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  ((ex = pgoblin.jobtable[PGOBLIN_MODSHIFT]->init( (options->flags & BLIN_MASK)
                                                               | PGOBLIN_MODSHIFT
                ))                                             ) {
                ifBLIN_QW0("JOB %s init failed", pgoblin.jobtable[PGOBLIN_MODSHIFT]->name);
                pgoblin.jobtable[PGOBLIN_MODSHIFT] = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            } else {
                pgoblin_jobl *j;

                MARK_R_JOB_NGO(0);;
                ;;  options->job[0].pids = mular_create(MULAR_ZERO, 3, sizeof(pgoblin_jobl), u12);
                MARK_R_JOB_NWENT(0);;
                j = mular_add(options->job[0].pids);
                j->cmdn = -1;
                j->pid = getppid();
                j->status = PGOBLIN_NOSTATUS;
                j = mular_add(options->job[0].pids);
                j->cmdn = -1;
                j->pid = getpid();
                j->status = PGOBLIN_NOSTATUS;
            }
            ++i;
        }
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        for (int k = 1; !!mods[mode][k].nm; ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                pgoblin.jobtable[i] = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(options, i, pgoblin.jobtable[i]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.jobtable[i]->init((options->flags & BLIN_MASK) | i))) {
                    ifBLIN_QW0("JOB %s init failed", pgoblin.jobtable[i]->name);
                    pgoblin.jobtable[i] = NULL;
                } else {
                    loaded = i;
        }   }   }
        if  (0 > loaded) {
            if  (!!(pgoblin.jobtable[i] = dload(options, 4, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(options, i, pgoblin.jobtable[i]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.jobtable[i]->init((options->flags & BLIN_MASK) | i))) {
                    ifBLIN_QW0("DB %s init failed", pgoblin.jobtable[i]->name);
                    pgoblin.jobtable[i] = NULL;
                } else {
                    loaded = i;
        }   }   }
        break;
    case 5:
        for (i = PGOBLIN_MODSHIFT; (i < pgoblin.styletbsz) && !!pgoblin.styletable[i]; ++i) {
            if  (!strncmp(pgoblin.styletable[i]->name, nm, rs) && !pgoblin.styletable[i]->name[rs]) {
                loaded = i;
                goto out;
        }   }
        if  (i >= pgoblin.styletbsz) {
            ifBLIN_QX0("No free slots for DB %s", nm);
            goto out;
        }
        if  (PGOBLIN_MODSHIFT == i) {
            pgoblin.styletable[PGOBLIN_MODSHIFT] = mods[mode][0].mod;
            if  (!!(wrt = pgoblin_wident(options, i, pgoblin.styletable[PGOBLIN_MODSHIFT]->id))) {
                ifBLIN_QW0("pgoblin_wident %d", wrt);
            }
            if  ((ex = pgoblin.styletable[PGOBLIN_MODSHIFT]->init( (options->flags & BLIN_MASK)
                                                                 | PGOBLIN_MODSHIFT
                ))                                               ) {
                ifBLIN_QW0("STYLE %s init failed", pgoblin.styletable[PGOBLIN_MODSHIFT]->name);
                pgoblin.styletable[PGOBLIN_MODSHIFT] = NULL;
                loaded = (0 > ex) ? ex : -ex;
                goto out;
            }
            ++i;
        }
        if  (!strncmp(mods[mode][0].nm, nm, rs) && !mods[mode][0].nm[rs]) {
            loaded = PGOBLIN_MODSHIFT;
            goto out;
        }
        for (int k = 1; !!mods[mode][k].nm; ++k) {
            if  (!strncmp(mods[mode][k].nm, nm, rs) && !mods[mode][k].nm[rs]) {
                pgoblin.styletable[i] = mods[mode][k].mod;
                if  (!!(wrt = pgoblin_wident(options, i, pgoblin.styletable[i]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.styletable[i]->init((options->flags & BLIN_MASK) | i))) {
                    ifBLIN_QW0("STYLE %s init failed", pgoblin.styletable[i]->name);
                    pgoblin.styletable[i] = NULL;
                } else {
                    loaded = i;
        }   }   }
        if  (0 > loaded) {
            if  (!!(pgoblin.styletable[i] = dload(options, 5, rs, nm))) {
                if  (!!(wrt = pgoblin_wident(options, i, pgoblin.styletable[i]->id))) {
                    ifBLIN_QW0("pgoblin_wident %d", wrt);
                }
                if  ((ex = pgoblin.styletable[i]->init((options->flags & BLIN_MASK) | i))) {
                    ifBLIN_QW0("DB %s init failed", pgoblin.styletable[i]->name);
                    pgoblin.styletable[i] = NULL;
                } else {
                    loaded = i;
        }   }   }
        break;
    default:;
    }
out:;
    return(loaded);
#   undef blin_internal_flags
}

pgoblin_main *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_init(BLIN_flag flags, int outfd) {                          /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_main *options = NULL;

#   define blin_internal_flags (flags & BLIN_MASK)
    ifBLIN_QX2("+ flags=%08X", flags);
    if  (!(options = calloc(1, sizeof(pgoblin_main)))) {
        ifBLIN_QX0("no mem for options");
        errno = ENOMEM;
    } else {
        pgoblin_options = options;
        options->xtrace = -1;
        options->flags = flags;
        pgoblin_default = flags;
        strncpy(options->vers, VERS, 4);
        options->maxtmout = 3600000;
        strncpy((char*)options->delim, "#", 3);

        MARK_IO_OUT_NGO(0);;
        ;;  IO_RG0.onu = outfd;
        ;;  IO_RG0.wri = (int(*)(int, const void *, size_t))mife_writ;
        ;;  IO_RG0.flags |= PGOBLIN_OUTSET;
        MARK_IO_OUT_NWENT(0);;
    }
    ifBLIN_QX2("- %s", options ? "OK" : "FAIL");
    return(options);
#   undef blin_internal_flags
}

void
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_fini(pgoblin_main *options) {                               /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int i;

    i = pgoblin.dbtablesz;
    if  (i < pgoblin.jobtabsiz) i = pgoblin.jobtabsiz;
    if  (i < pgoblin.styletbsz) i = pgoblin.styletbsz;
    for (; 0 <= i; --i) {
        if  ((i < pgoblin.styletbsz) && !!pgoblin.styletable[i]) {
            pgoblin.styletable[i]->fini();
        }
        if  ((i < pgoblin.dbtablesz) && !!pgoblin.dbasetable[i]) {
            pgoblin.dbasetable[i]->fini();
        }
        if  ((i < pgoblin.jobtabsiz) && !!pgoblin.jobtable[i]) {
            pgoblin.jobtable[i]->fini();
    }   }
    free(options);
}

static void
/**********************************************************************
 **                                                                  **/
dump_ioreg(pgoblin_main *options, pgoblin_nr r) {                   /**
 **                                                                  **
 **********************************************************************/
    void *wdr, *cdr;

#   define blin_internal_flags (options->flags & BLIN_MASK)
#   define R options->io[r]
    if  (R.flags || R.mife || R.pq || R.wri || R.clo || R.path || R.text) {
        fprintf( stderr, "[%c](%06X%s%s%s%s%s%s%s%s%s%s%s%s):"
               , pgoblin_regn[r], R.flags
               , (R.flags & PGOBLIN_PATHPARM) ? " path"  : ""
               , (R.flags & PGOBLIN_FREEPATH) ? " path*" : ""
               , (R.flags & PGOBLIN_FILEOVER) ? " over"  : ""
               , (R.flags & PGOBLIN_TEXTPARM) ? " text"  : ""
               , (R.flags & PGOBLIN_FREETEXT) ? " text*" : ""
               , (R.flags & PGOBLIN_BINPARM ) ? " bin"   : ""
               , (R.flags & PGOBLIN_MIFEDES ) ? " mife"  : ""
               , (R.flags & PGOBLIN_FREEMIFE) ? " mife*" : ""
               , (R.flags & PGOBLIN_PQRESULT) ? " pq"    : ""
               , (R.flags & PGOBLIN_FREEPQRE) ? " pq*"   : ""
               , (R.flags & PGOBLIN_OUTSET  ) ? " out"   : ""
               , (R.flags & PGOBLIN_FREEOUTS) ? " out*"  : ""
               );
        if  (R.mife) {
            fprintf(stderr, " mife=%" BLIN_X, BLIN_I(R.mife));
            fprintf(stderr, " pid=%d", R.pid);
        }
        if  (R.pq) {
            fprintf(stderr, " pq=%" BLIN_X, BLIN_I(R.pq));
            fprintf(stderr, " flags=%08X", *R.pq);
        }
        wdr = R.wri;
        if  (wdr == write) fprintf(stderr, " wri=write");
        else if (wdr == mife_writ) fprintf(stderr, " wri=mife_writ");
        else if (wdr) fprintf(stderr, " wri=%" BLIN_X, BLIN_I(wdr));

        cdr = R.clo;
        if  (cdr == close) fprintf(stderr, " clo=close");
        else if (cdr) fprintf(stderr, " clo=%" BLIN_X, BLIN_I(cdr));

        if  (wdr || cdr) fprintf(stderr, " onu=%d", R.onu);
        fprintf(stderr, "\n");

        if  (R.path) fprintf(stderr, " path=%s~\n", R.path);
        if  (R.text) {
            if  (!(R.flags & PGOBLIN_BINPARM)) {
                fprintf(stderr, " text=%s~\n", (char*)R.text);
            } else ifBLIN_QO4 {
                u_int i;

                fprintf(stderr, " text=");
                for (i = 0; i < R.length; i++) {
                    if  (  ((((u_char*)R.text)[i] >= 0177) && (((u_char*)R.text)[i] < 0300))
                        || (((u_char*)R.text)[i] < ' ')
                        ) {
                        fprintf(stderr, "\\%03o", ((u_char*)R.text)[i]);
                    } else if (((char*)R.text)[i] == '\\') {
                        fprintf(stderr, "\\\\");
                    } else {
                        fprintf(stderr, "%c", ((char*)R.text)[i]);
                }   }
                fprintf(stderr, "~\n");
            } else {
                fprintf(stderr, " text %" BLIN_X " length %d\n", BLIN_I(R.text), (int)R.length);
        }   }
    } else {
        fprintf(stderr, "\n");
    }
#   undef R
#   undef blin_internal_flags
}

static void
/**********************************************************************
 **                                                                  **/
iorassert(pgoblin_exenv *exenv, pgoblin_command cmd) {              /**
 **                                                                  **
 **********************************************************************/
    int r;
    u_int32_t e;
    u_char rr[pgoblin.regsize + 1], rp[pgoblin.regsize + 1];

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
#   define R exenv->options->io[r]
#   define W "cmd[%d]=%03X(%s) fl[%d]=%08X "
    for (r = 0; r < pgoblin.regsize; r++) {
        e = 0;
        if  (R.path) {
            e |= PGOBLIN_PATHPARM;
        } else if (R.flags & PGOBLIN_PATHPARM) {
            warnx(W "  path", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        } else if (R.flags & PGOBLIN_FREEPATH) {
            warnx(W "  path", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        }
        if  (R.text) {
            e |= PGOBLIN_TEXTPARM;
        } else if (R.flags & PGOBLIN_TEXTPARM) {
            warnx(W "  text", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        } else if (R.flags & PGOBLIN_FREETEXT) {
            warnx(W "  text", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        }
        if  (R.mife) {
            e |= PGOBLIN_MIFEDES;
        } else if (R.flags & PGOBLIN_MIFEDES) {
            warnx(W "  mife", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        } else if (R.flags & PGOBLIN_FREEMIFE) {
            warnx(W "  mife", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        }
        if  (R.pq) {
            e |= PGOBLIN_PQRESULT;
        } else if (R.flags & PGOBLIN_PQRESULT) {
            warnx(W "  pq", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        } else if (R.flags & PGOBLIN_FREEPQRE) {
            warnx(W "  pq", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        }
        if  (!(R.flags & PGOBLIN_ANYIVL) && e) {
            ifBLIN_QX1( W "  %02X(%s%s%s%s)"
                      , exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags
                      , e
                      , (e & PGOBLIN_PATHPARM) ? "f" : ""
                      , (e & PGOBLIN_TEXTPARM) ? "t" : ""
                      , (e & PGOBLIN_MIFEDES)  ? "m" : ""
                      , (e & PGOBLIN_PQRESULT) ? "q" : ""
                      );
        }
        if  (R.wri) {
            e |= PGOBLIN_OUTSET;
            if  (!(R.flags & PGOBLIN_OUTSET)) {
                ifBLIN_QX1(W "  wri", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
            }
        } else if (R.flags & (PGOBLIN_OUTSET | PGOBLIN_FREEOUTS)) {
            warnx(W "  wri", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        }
        if  (R.clo && !(R.flags & PGOBLIN_FREEOUTS)) {
            ifBLIN_QX1(W "  clo", exenv->ppoint, cmd, pgoblin.a[cmd].str, r, R.flags);
        }
        rr[r] = e;
    }
    ifBLIN_QO2 {
        /*    - ,
         *     ,
         *     .
         */
        for (r = 0; r < pgoblin.regsize; r++) {
            rp[r] = pgoblin_regn[rr[r]];
            if  (rr[r] == (R.flags & (PGOBLIN_ANYIVL | PGOBLIN_OUTSET))) rr[r] = '=';
              else rr[r] = pgoblin_regn[R.flags & (PGOBLIN_ANYIVL | PGOBLIN_OUTSET)];
        }
        rr[pgoblin.regsize] = rp[pgoblin.regsize] = '\0';
        fprintf(stderr, "regs %s\n", rp);
        fprintf(stderr, "flag %s\n", rr);
    }
    ifBLIN_QX4("\n"
               "    00 0   08 8   10 G   18 O   20 W   28 e   30 m   38 u\n"
               "    01 1   09 9   11 H   19 P   21 X   29 f   31 n   39 v\n"
               "    02 2   0A A   12 I   1A Q   22 Y   2A g   32 o   3A w\n"
               "    03 3   0B B   13 J   1B R   23 Z   2B h   33 p   3B x\n"
               "    04 4   0C C   14 K   1C S   24 a   2C i   34 q   3C y\n"
               "    05 5   0D D   15 L   1D T   25 b   2D j   35 r   3D z\n"
               "    06 6   0E E   16 M   1E U   26 c   2E k   36 s   3E _\n"
               "    07 7   0F F   17 N   1F V   27 d   2F l   37 t   3F -\n"
              );
#   undef W
#   undef R
#   undef blin_internal_flags
}

/*
 *   IO      . score[][] 
 *  -     r ()   ch ()   
 *  .     procomp(options, r, ch).  
 *   propush(exenv, r, ch)  ,     
 *  ,  ,  Co   propush(), 
 *    Cf, Ct, Cm, Cq  Cw  cleareg(options, r, m),  m
 *   ,   procomp() -     .
 *       exenv->flags,      (
 * Ce == PGOBLIN_FORKOUT)   ( Cs, Cp, Cu  PGOBLIN_FREE*) 
 *  .
 */

static int
/**********************************************************************
 **                                                                  **/
cleareg(pgoblin_main *options, pgoblin_nr rn, u_int32_t m) {        /**
 **                                                                  **
 **********************************************************************/
    pgoblin_io *r = &(options->io[rn]);
    int ex = EX_OK;

#   define blin_internal_flags (options->flags & BLIN_MASK)
    ifBLIN_QX4("+ %"BLIN_X" %08X", BLIN_I(r), m);
    if  (m & PGOBLIN_PATHPARM) {
        MARK_IO_PATH_NGO(rn);;
        ;;  if  (r->path && (r->flags & PGOBLIN_FREEPATH)) free(r->path);
        ;;  r->path = NULL;
        ;;  r->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        MARK_IO_PATH_NWENT(rn);;
    }
    if  (m & PGOBLIN_TEXTPARM) {
        MARK_IO_TEXT_NGO(rn);;
        ;;  if  (!!r->stymd) {
        ;;      mular_destroy(r->stymd);
        ;;      r->stymd = NULL;
        ;;  }
        ;;  if  (r->text && (r->flags & PGOBLIN_FREETEXT)) free(r->text);
        ;;  r->text = NULL;
        ;;  r->length = 0;
        ;;  r->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_TEXTPARM | PGOBLIN_BINPARM);
        MARK_IO_TEXT_NWENT(rn);;
    }
    if  (m & PGOBLIN_PQRESULT) {
        MARK_IO_PQ_NGO(rn);;
        ;;  if  (r->pq && (r->flags & PGOBLIN_FREEPQRE) && !!DBASE(*(BLIN_flag*)(r->pq))) {
        ;;      pgoblin_db_clear(&r->pq);
        ;;  }
        ;;  r->pq = NULL;
        ;;  r->flags &= ~(PGOBLIN_FREEPQRE | PGOBLIN_PQRESULT);
        MARK_IO_PQ_NWENT(rn);;
    }
    if  (m & PGOBLIN_MIFEDES) {
        MARK_IO_MIFE_NGO(rn);;
        ;;  if  (r->mife && (r->flags & PGOBLIN_FREEMIFE) && (ex = mife_ctl(r->mife, MIFE_CTLFINI))) {
        ;;      ifBLIN_QW0("mife_ctl(MIFE_CTLFINI) in cleareg");
        ;;  }
        ;;  r->mife = NULL;
        ;;  r->offset = 0;
        ;;  r->pid = 0;
        ;;  r->flags &= ~(PGOBLIN_FREEMIFE | PGOBLIN_MIFEDES);
        MARK_IO_MIFE_NWENT(rn);;
    }
    if  (m & PGOBLIN_OUTSET) {
        MARK_IO_OUT_NGO(rn);;
        ;;  if  (r->clo && (r->flags & PGOBLIN_FREEOUTS) && (ex = r->clo(r->onu))) {
        ;;      ifBLIN_QW0("clo in cleareg");
        ;;  }
        ;;  r->clo = NULL;
        ;;  r->wri = NULL;
        ;;  r->onu = 0;
        ;;  r->flags &= ~(PGOBLIN_OUTSET | PGOBLIN_FREEOUTS);
        MARK_IO_OUT_NWENT(rn);;
    }
    if  (!!r->stymd) {
        ifBLIN_QX1("stymd without TEXT");
        MARK_IO_TEXT_NGO(rn);;
        ;;  mular_destroy(r->stymd);
        ;;  r->stymd = NULL;
        MARK_IO_TEXT_NWENT(rn);;
    }
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#define Cx PGOBLIN_IGNORE   /* impossible         0x800000 */
#define Co PGOBLIN_OPEN     /* open               0x200000 */
#define Cf PGOBLIN_PATHPARM /* free path          0x000001 */
#define Ct PGOBLIN_TEXTPARM /* free text          0x000002 */
#define Cm PGOBLIN_MIFEDES  /* free mife          0x000004 */
#define Cq PGOBLIN_PQRESULT /* free pq            0x000008 */
#define Cw PGOBLIN_OUTSET   /* free wri           0x000010 */
#define Ce PGOBLIN_FORKOUT  /* fork               0x000020 */
#define Cs PGOBLIN_FREEPATH /* stream file out    0x010000 */
#define Cp PGOBLIN_FREETEXT /* copy text out      0x020000 */
#define Cu PGOBLIN_FREEPQRE /* unstore pq out     0x080000 */

static const u_int32_t score[32][4] =
 /*ftmqw          Pf           Pt           Pm           Pq   Wish*/
{/*00000*/{0              ,0           ,          Ce,0           }
,/*10000*/{ Co|Cf|      Cs, Co|      Cp, Co         , Co|      Cu}
,/*01000*/{       Ct      ,    Ct      ,    Ct|   Ce,    Ct      }
,/*11000*/{ Co|Cf|Ct|   Cs, Co|Ct|   Cp, Co|Ct      , Co|Ct|   Cu}
,/*00100*/{ Cm            , Cm         ,          Ce, Cm         }
,/*10100*/{ Co|Cf|      Cs, Co|      Cp, Co         , Co|      Cu}
,/*01100*/{ Cm|   Ct      , Cm|Ct      ,    Ct|   Ce, Cm|Ct      }
,/*11100*/{ Co|Cf|Ct|   Cs, Co|Ct|   Cp, Co|Ct      , Co|Ct|   Cu}
,/*00010*/{          Cq   ,       Cq   ,       Cq|Ce,       Cq   }
,/*10010*/{ Co|Cf|   Cq|Cs, Co|   Cq|Cp, Co|   Cq   , Co|   Cq|Cu}
,/*01010*/{       Ct|Cq   ,    Ct|Cq   ,    Ct|Cq|Ce,    Ct|Cq   }
,/*11010*/{ Co|Cf|Ct|Cq|Cs, Co|Ct|Cq|Cp, Co|Ct|Cq   , Co|Ct|Cq|Cu}
,/*00110*/{ Cm|      Cq   , Cm|   Cq   ,       Cq|Ce, Cm|   Cq   }
,/*10110*/{ Co|Cf|   Cq|Cs, Co|   Cq|Cp, Co|   Cq   , Co|   Cq|Cu}
,/*01110*/{ Cm|   Ct|Cq   , Cm|Ct|Cq   ,    Ct|Cq|Ce, Cm|Ct|Cq   }
,/*11110*/{ Co|Cf|Ct|Cq|Cs, Co|Ct|Cq|Cp, Co|Ct|Cq   , Co|Ct|Cq|Cu}
,/*00001*/{             Cs,          Cp,0           ,          Cu}
,/*10001*/{    Cf|      Cs,          Cp,0           ,          Cu}
,/*01001*/{       Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*11001*/{    Cf|Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*00101*/{             Cs,          Cp,0           ,          Cu} /* IO_RG0 */
,/*10101*/{    Cf|      Cs,          Cp,0           ,          Cu}
,/*01101*/{       Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*11101*/{    Cf|Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*00011*/{          Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*10011*/{    Cf|   Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*01011*/{       Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*11011*/{    Cf|Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*00111*/{          Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*10111*/{    Cf|   Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*01111*/{       Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*11111*/{    Cf|Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
}/* Reg */;

static u_int32_t
/**********************************************************************
 **                                                                  **/
procomp(pgoblin_main *options, pgoblin_io *r, u_int32_t ch) {       /**
 **                                                                  **
 **********************************************************************/
    int i, j;
    u_int32_t price, abil;

#   define blin_internal_flags (options->flags & BLIN_MASK)
    abil = 0;
    for (j = 0; j < 5; j++) { /* From */
        if  (  ((j == 0) && (r->path))
            || ((j == 1) && (r->text))
            || ((j == 2) && (r->mife))
            || ((j == 3) && (r->pq  ))
            || ((j == 4) && (r->wri ))
            ) {
            abil |= (1 << j);
    }   }
    price = 0;
    for (i = 0; i < 4; i++) { /* To */
        if  (  ((i == 0) && (ch & PGOBLIN_PATHPARM))
            || ((i == 1) && (ch & PGOBLIN_TEXTPARM))
            || ((i == 2) && (ch & PGOBLIN_MIFEDES ))
            || ((i == 3) && (ch & PGOBLIN_PQRESULT))
            ) {
            ifBLIN_QX3("%d abil=%02X %04X", i, abil, score[abil][i]);
            price |= score[abil][i];
    }   }
    ifBLIN_QX3("abil=%02X %04X", abil, price);
    return(price);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
propush(pgoblin_exenv *exenv, pgoblin_nr rn, u_int32_t ch) {        /**
 **                                                                  **
 **********************************************************************/
    pgoblin_io *r = &(exenv->options->io[rn]);
    u_int32_t price;
    int ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX4( "+ ch=%02X io=%08X%s%s%s%s"
              , ch
              , r->flags, r->path ? " path" : ""
              , r->text ? " text" : ""
              , r->wri  ? " mife" : ""
              , r->pq   ? " pq"   : ""
              );
    if  (!(ch & PGOBLIN_OUTSET)) {
        ifBLIN_QX0("No output in propush");
        ERROUT(EX_DATAERR, EINVAL);
    } else if (  ((r->flags & PGOBLIN_PATHPARM) && !r->path)
              || ((r->flags & PGOBLIN_TEXTPARM) && !r->text)
              || ((r->flags & PGOBLIN_OUTSET  ) && !r->wri )
              || ((r->flags & PGOBLIN_PQRESULT) && !r->pq  )
              ) {
        ifBLIN_QX0("No info f=%08X", r->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    price = procomp(exenv->options, r, ch);
    if  (price & Cx) {
        ifBLIN_QX0("No way @%d f=%08X", exenv->ppoint, r->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (price & Co) {
        int o;

        if  (r->path) {
            o = open( r->path
                    , O_WRONLY | O_CREAT | ((r->flags & PGOBLIN_FILEOVER) ? O_TRUNC : O_APPEND)
                    , 0666
                    );
            if  (o < 0) {
                ifBLIN_QW0("Open %s%s", r->path, (r->flags & PGOBLIN_FILEOVER) ? " over" : "");
                ex = EX_IOERR;
                goto out;
            }
            MARK_IO_OUT_NGO(rn);;
            ;;  r->onu = o;
            ;;  r->clo = close;
            ;;  r->wri = (int(*)(int, const void *, size_t))mife_writ;
            ;;  r->flags |= PGOBLIN_FREEOUTS;
            MARK_IO_OUT_NWENT(rn);;
        } else {
            ifBLIN_QW1("Open NULL %s", (r->flags & PGOBLIN_FILEOVER) ? " over" : "");
            o = -1;
            MARK_IO_OUT_NGO(rn);;
            ;;  r->onu = o;
            ;;  r->clo = NULL;
            ;;  r->wri = NULL;
            ;;  r->flags &= ~PGOBLIN_FREEOUTS;
            MARK_IO_OUT_NWENT(rn);;
    }   }
    ex = cleareg(exenv->options, rn, price);
    if  (!ex) exenv->flags |= price;
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

/*
 *   IO    . dcore[][]   
 *      .       
 *    ( )     .  
 *      D*. coercion(exenv, r, ch)  
 * coercomp(options, r, ch)    ,     
 *     D*.       
 *      r      ch   
 * ,    . ,   r  ,
 *   ch,   0     .
 */

#define DC 0x000F /* price              */
#define Dx 0x8000 /* impossible         */
#define Dq 0x4000 /* read to text       */
#define Do 0x2000 /* open file name     */
#define Dr 0x1000 /* read file          */
#define Dl 0x0800 /* db_0 from text     */
#define Dn 0x0400 /* temp file name     XXXX */
#define Dw 0x0200 /* write file         XXXX */
#define Dm 0x0100 /* do mife from text  */
#define Da 0x0080 /* throw pq to file   XXXX */
#define Db 0x0040 /* throw mife to file XXXX */

static const u_int16_t dcore[4][4] =
      /*              Pf          Pt          Pm          Pq   Reg */
{/* Pf */{             0, Dx|Dn|Dw|7, Dx|Dn|Db|9, Dx|Dn|Da|8}
,/* Pt */{    Do|Dr   |4,          0,    Dr   |3,    Dq   |5}
,/* Pm */{    Do      |1,       Dm|2,          0,    Dq|Dm|6}
,/* Pq */{    Do|Dr|Dl|5,       Dl|1,    Dr|Dl|4,          0}
}/*Wish*/;

static u_int32_t
/**********************************************************************
 **                                                                  **/
coercomp(pgoblin_main *options, pgoblin_io *r, u_int32_t ch) {      /**
 **                                                                  **
 **********************************************************************/
/*
 *        r     ch 
 */
    int i, j, surprise;
    u_int32_t price;

#   define blin_internal_flags (options->flags & BLIN_MASK)
    price = Dx | 15;
    surprise = 1;
    for (i = 0; i < 4; i++) { /* To */
        if  (  ((i == 0) && (ch & PGOBLIN_PATHPARM))
            || ((i == 1) && (ch & PGOBLIN_TEXTPARM))
            || ((i == 2) && (ch & PGOBLIN_MIFEDES ))
            || ((i == 3) && (ch & PGOBLIN_PQRESULT))
            ) {
            surprise = 0;
            for (j = 0; j < 4; j++) { /* From */
                if  (  (  ((j == 0) && (r->path))
                       || ((j == 1) && (r->text))
                       || ((j == 2) && (r->mife))
                       || ((j == 3) && (r->pq  ))
                       )
                    && (dcore[i][j] & DC) < (price & DC)
                    ) {
                    price = dcore[i][j];
                    ifBLIN_QX3("i=%d j=%d %04X", i, j, dcore[i][j]);
    }   }   }   }
    return(surprise ? 0 : price);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
coercion(pgoblin_exenv *exenv, pgoblin_nr rn, u_int32_t ch) {       /**
 **                                                                  **
 **********************************************************************/
/*
 *     r     ch 
 */
    pgoblin_io *r = &(exenv->options->io[rn]);
    u_int32_t price;
    int ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX4( "+ ch=%02X io=%08X%s%s%s%s"
              , ch
              , r->flags
              , r->path ? " path" : ""
              , r->text ? " text" : ""
              , r->mife ? " mife" : ""
              , r->pq   ? " pq"   : ""
              );
    if  (ch & PGOBLIN_OUTSET) {
        ifBLIN_QX0("Output in coercion");
        ERROUT(EX_DATAERR, EINVAL);
    } else if (  ((r->flags & PGOBLIN_PATHPARM) && !r->path)
              || ((r->flags & PGOBLIN_TEXTPARM) && !r->text)
              || ((r->flags & PGOBLIN_MIFEDES ) && !r->mife)
              || ((r->flags & PGOBLIN_PQRESULT) && !r->pq  )
              ) {
        ifBLIN_QX0("No info f=%08X", r->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    price = coercomp(exenv->options, r, ch);
    if  (price & Dx) {
        ifBLIN_QX0("No way @%d f=%08X", exenv->ppoint, r->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (price & Dq) {
        if  ((ex = pgoblin_style_0.table(r, exenv->options->style, r, 0, -2)) < 0) {
            ifBLIN_QW0("coercion: No STYLE 0");
            goto out;
    }   }
    if  (price & Do) {
        MARK_IO_MIFE_NGO(rn);;
        ;;  r->offset = 0;
        ;;  r->pid = 0;
        ;;  r->mife = mife_init(PGOBLIN_MIFEFLAGS);
        ;;  r->flags |= PGOBLIN_FREEMIFE;
        MARK_IO_MIFE_NWENT(rn);;
        if  (!r->mife || (0 > mife_ctl(r->mife, MIFE_CTLFILE, r->path))) {
            r->flags &= ~(PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE);
            ifBLIN_QW0("coercion mife open %s", r->path);
            ex = EX_IOERR;
            goto out;
    }   }
    if  (price & Dr) {
        ssize_t l;
        void *t;

        if  ((l = mife_ctl(r->mife, MIFE_CTLREAD, (off_t)0, (ssize_t)0)) < 0) {
            ifBLIN_QX0("mife_ctl(MIFE_CTLREAD)");
            ex = EX_IOERR;
            goto out;
        }
        if  (!(t = mife_point(r->mife, MIFE_POINTER))) {
            ifBLIN_QX0("mife_point(MIFE_POINTER)");
            ex = EX_IOERR;
            goto out;
        }
        MARK_IO_TEXT_NGO(rn);;
        ;;  r->length = l;
        ;;  r->text = t;
        ;;  r->flags |= PGOBLIN_BINPARM;
        ;;  r->flags &= ~PGOBLIN_FREETEXT;
        MARK_IO_TEXT_NWENT(rn);;
    }
    if  (price & Dl) {
        pgoblin_conn conn0;

        MARK_IO_TEXT_NGO(rn);;
        ;;  r->flags &= ~PGOBLIN_FREETEXT;
        MARK_IO_TEXT_NWENT(rn);;
        MARK_IO_PQ_NGO(rn);;
        ;;  pgoblin_db0_create(&conn0, &(r->pq), 1, (const char **)&(r->text), NULL);
        ;;  r->flags |= PGOBLIN_FREEPQRE;
        MARK_IO_PQ_NWENT(rn);;
    }
    if  (price & Dn) {/* XXXX */}
    if  (price & Dw) {/* XXXX */}
    if  (price & Dm) {
        mife_descriptor *m;
        int tmpi;

        if  (!r->text) {
            m = NULL;
            tmpi = 0;
        } else {
            if  (!(m = mife_init(PGOBLIN_MIFEFLAGS /* | MIFE_STRI */))) {
                ifBLIN_QX0("mife_init");
                ex = EX_IOERR;
                goto out;
            }
            if  (r->flags & (PGOBLIN_FREETEXT | PGOBLIN_BINPARM)) {
                tmpi = mife_ctl(m, MIFE_CTLBUFF, r->text, r->length);
            } else {
                tmpi = mife_ctl(m, MIFE_CTLCNST, r->text, r->length);
        }   }
        if  (0 > tmpi) {
            ifBLIN_QX0("mife_ctl");
            ex = EX_IOERR;
            goto out;
        }
        MARK_IO_MIFE_NGO(rn);;
        ;;  r->mife = m;
        ;;  r->pid = 0;
        ;;  r->offset = 0;
        ;;  r->flags |= PGOBLIN_FREEMIFE;
        MARK_IO_MIFE_NWENT(rn);;
    }
    if  (price & Da) {/* XXXX */}
    if  (price & Db) {/* XXXX */}
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
waitjob(pgoblin_main *options, pgoblin_nr rn) {                     /**
 **                                                                  **
 **********************************************************************/
    pgoblin_jobreg *g = &(options->job[rn]);
    int status, ex = EX_OK, exx = EX_OK;
    pgoblin_jobl *j;
    struct kevent kev;
    u_int i;

#   define blin_internal_flags (g->flags & BLIN_MASK)
    bzero(&kev, sizeof(kev));
    if  (!(g->flags & PGOBLIN_KQUEUED) && ((g->kq = kqueue()) < 0)) {
        ex = EX_OSERR;
        goto out;
    }
    MARK_R_JOB_NGO(rn);;
    ;;  g->flags |= PGOBLIN_KQUEUED;
    MARK_R_JOB_NWENT(rn);;
try:
    for (i = 0; !ex && (i < MULAR_NEXT(g->pids)); i++) {
        j = mular_getix(g->pids, i);
        if  (j->pid <= 0) {
            ifBLIN_QX0("No pid in %d", (int)j->cmdn);
            errno = EINVAL;
            ex = EX_SOFTWARE;
        } else if (j->cmdn < 0) {
            ifBLIN_QX0("No cmdn %d", (int)j->cmdn);
            errno = EINVAL;
            ex = EX_SOFTWARE;
        } else if (j->status == PGOBLIN_NOSTATUS) {
            EV_SET(&kev, j->pid, EVFILT_PROC, EV_ADD | EV_ONESHOT | EV_CLEAR, NOTE_EXIT, 0, NULL);
            if  (0 > kevent(g->kq, &kev, 1, NULL, 0, NULL)) {
                ifBLIN_QW0("No pid %d for kevent ADD", (int)j->pid);
                ex = EX_SOFTWARE;
            } else if (0 > (ex = waitpid(j->pid, &status, WNOHANG))) {
                if  (errno == ECHILD) {
                    ifBLIN_QX1("Lost pid %d in %d", j->pid, (int)j->cmdn);
                    MARK_R_JOB_NGO(rn);;
                    ;;  j->status = PGOBLIN_LOSTSTAT;
                    ;;  g->dead++;
                    MARK_R_JOB_NWENT(rn);;
                    errno = 0;
                    ex = 0;
                } else {
                    ifBLIN_QW0("Pid %d in %d", j->pid, (int)j->cmdn);
                }
            } else if (0 < ex) {
                if  (ex == j->pid) {
                    EV_SET(&kev, j->pid, EVFILT_PROC, EV_DELETE, NOTE_EXIT, 0, NULL);
                    if  (0 > kevent(g->kq, &kev, 1, NULL, 0, NULL)) {
                        ifBLIN_QW1("No pid %d for kevent DELETE", (int)j->pid);
                    }
                    MARK_R_JOB_NGO(rn);;
                    ;;  j->status = status;
                    ;;  g->dead++;
                    MARK_R_JOB_NWENT(rn);;
                    ex = 0;
                    if  (  (g->flags & PGOBLIN_ERROR_SENSOR)
                        && WIFEXITED(status)
                        && WEXITSTATUS(status)
                        && !exx
                        ) exx = WEXITSTATUS(status);
                    if  ((g->flags & PGOBLIN_ERROR_SENSIB) && exx) break;
                } else {
                    ifBLIN_QX0("Pid %d<>%d at %d", ex, j->pid, (int)j->cmdn);
    }   }   }   }
    if  (!ex && g->concur && (MULAR_NEXT(g->pids) >= (g->concur + g->dead))) {
        kevent(g->kq, NULL, 0, &kev, 1, NULL);
        goto try;
    }
out:
    return(ex ? ex : exx);
#   undef blin_internal_flags
}

static int
/***********************************************************************
 **                                                                   **/
pgoblin_inx(pgoblin_main *options, pgoblin_io *r, int p[2], int c) { /**
 **                                                                   **
 ***********************************************************************/
    int ex = EX_OK; /* Errors must be < 0 */

#   define blin_internal_flags (options->flags & BLIN_MASK)
    if  (c) close(p[1]);
    MARK_IO_MIFE_GO(r);;
    ;;  if  (  !(r->mife = mife_init(PGOBLIN_MIFEFLAGS))
            || (0 > mife_ctl(r->mife, MIFE_CTLFDSC, p[0]))
            ) {
    ;;      ifBLIN_QW0("mife_init inx");
    ;;      ex = -EX_NOINPUT;
    ;;  } else r->flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
    ;;  r->pid = 0;
    ;;  r->offset = 0;
    MARK_IO_MIFE_WENT(r);;
    return(ex);
#   undef blin_internal_flags
}

static int
/************************************************************************
 **                                                                    **/
pgoblin_outx(pgoblin_main *options, pgoblin_io *r, int p[2], int c) { /**
 **                                                                    **
 ************************************************************************/
    int ex = EX_OK; /* Errors must be < 0 */

    if  (c) close(p[0]);
    MARK_IO_OUT_GO(r);;
    ;;  r->onu = p[1];
    ;;  r->wri = (int(*)(int, const void *, size_t))mife_writ;
    ;;  r->clo = close;
    ;;  r->flags |= PGOBLIN_OUTSET | PGOBLIN_FREEOUTS;
    MARK_IO_OUT_WENT(r);;
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_pipe(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;
    int pipa[2];

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3("+pipe %c.%c...", pgoblin_regn[rn[PGO_COUT]], pgoblin_regn[rn[PGO_CIN]]);
    if  (pipe(pipa) < 0) {
        ifBLIN_QW0("pipe in pipe");
        close(pipa[0]);
        close(pipa[1]);
        ex = EX_OSERR;
    }
    if  (!(ex = pgoblin_inx(exenv->options, &(exenv->options->io[rn[PGO_CIN]]), pipa, 0)))
        ex = pgoblin_outx(exenv->options, &(exenv->options->io[rn[PGO_COUT]]), pipa, 0);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#define CICLEWARN(N,A) { int CICLEWARN_INTERNAL = N;                                                 \
    ifBLIN_QX1( "cmd[%d]=[%03X(%s %c%c%c%c%c%c)].fl=%08X %s ch=%02X " A                              \
              , exenv->ppoint, cmd, a_cmd->str                                                       \
              , pgoblin_regn[rn[0]], pgoblin_regn[rn[1]], pgoblin_regn[rn[2]]                        \
              , pgoblin_regn[rn[3]], pgoblin_regn[rn[4]], pgoblin_regn[rn[5]]                        \
              , a_cmd->flags, pgoblin.p[CICLEWARN_INTERNAL].name, ch[CICLEWARN_INTERNAL]             \
              );                                                                                     \
    continue;                                                                                        \
}

#define CICLEERR(A) {                                                                                \
    ifBLIN_QW0( "cmd[%d]=%03X(%s %c%c%c%c%c%c) %08X %02X %02X %02X %02X %02X %02X " A                \
              , exenv->ppoint, cmd, a_cmd->str                                                       \
              , pgoblin_regn[rn[0]], pgoblin_regn[rn[1]], pgoblin_regn[rn[2]]                        \
              , pgoblin_regn[rn[3]], pgoblin_regn[rn[4]], pgoblin_regn[rn[5]]                        \
              , a_cmd->flags, ch[0], ch[1], ch[2], ch[3], ch[4], ch[5]                               \
              );                                                                                     \
}

#define DUMPIOREGS { int DUMPIOREGS_INTERNAL;                                                        \
    for (DUMPIOREGS_INTERNAL = 0; DUMPIOREGS_INTERNAL < pgoblin.regsize; DUMPIOREGS_INTERNAL++) {    \
        if  (  (DUMPIOREGS_INTERNAL == rn[PGO_COUT])                                                 \
            || (DUMPIOREGS_INTERNAL == rn[PGO_CCTL])                                                 \
            || (DUMPIOREGS_INTERNAL == rn[PGO_CIN])                                                  \
            ) {                                                                                      \
            dump_ioreg(options, DUMPIOREGS_INTERNAL);                                                \
}   }   }

int
/***********************************************
 ***********************************************
 **                                           **/
pgoblin_execute( pgoblin_main  *options      /**/
/**/           , pgoblin_prog  *pgm          /**/
/**/           , pgoblin_exenv *dexenv       /**/
/**/           , pgoblin_exenv *sexenv       /**/
/**/           , ssize_t        pp           /**/
/**/           ) {                           /**
 **                                           **
 ***********************************************
 ***********************************************/
    u_int32_t                      ch[pgoblin.symparam];
    pgoblin_nr                     rn[pgoblin.symparam];
    pgoblin_exenv                 *exenv;
    u_int32_t                      m;
    int                            i, g, ex = EX_OK;
    union {
        pgoblin_io        *io;                     /* io                                             */
        pgoblin_conn      *c;                      /* conn                                           */
        pgoblin_jobreg    *j;                      /* job                                            */
        pgoblin_styreg    *s;                      /* style                                          */
        void              *v;
    } r[pgoblin.symparam];

#   define blin_internal_flags (options->flags & BLIN_MASK)
    ifBLIN_QX2("+ pgm@%"BLIN_D":%"BLIN_D, pgm->curr, pgm->maxx);
    ifBLIN_QO4 for (g = 0; g < pgoblin.regsize; g++) dump_ioreg(options, g);
    if  (!pgm || !!strncmp(pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_TST)) {
        ifBLIN_QX0("Illegal pgoblin program %s", pgm->id);
        ERROUT(EX_DATAERR, EPROGMISMATCH);
    }
    if  (!(exenv = calloc(1, sizeof(pgoblin_exenv)))) {
        ifBLIN_QW0("no mem");
        ex = EX_OSERR;
        goto out;
    }
    exenv->flags = options->flags & BLIN_MASK;
    if  (dexenv) dexenv->next = exenv;
    exenv->dyna = dexenv;
    exenv->stat = sexenv;
    exenv->pgm = pgm;
    exenv->options = options;
    for (exenv->ppoint = pp; !(exenv->flags & PGOBLIN_END); exenv->ppoint++) {
        u_int32_t                      jobflags;
        int                            pqjump = 0;
        const struct pgoblin_syntax_a *a_cmd;
        int                            ntyp;
        pgoblin_command                cmd;
        char                          *lit;
        u_int32_t                      t;

    ;   exenv->flags &= PGOBLIN_EXTABLE;
    ;   if  (ex) {
            /*    ,    #trap */
            pgoblin_exenv *ev;
            int trapdone;

    ;       trapdone = 0;
    ;       for (ev = exenv; ev; ev = ev->stat) {
    ;           if  (ev->flags & PGOBLIN_TRAPDEF) {
    ;               ifBLIN_QX1("Trap from %d to %d", exenv->ppoint, ev->ctrap);
    ;               if  (!!(ex = pgoblin_execute(options, ev->pgm, exenv, ev->stat, ev->ctrap))) {
    ;                   ifBLIN_QX1("Fail in trap PC %d", exenv->ppoint);
    ;                   exenv->flags |= PGOBLIN_END | PGOBLIN_ERROR;
    ;               }
    ;               trapdone++;
    ;               break;
    ;       }   }
    ;       if  (!trapdone) {
    ;           ifBLIN_QX1("Fail PC %d", exenv->ppoint);
    ;           exenv->flags |= PGOBLIN_END | PGOBLIN_ERROR;
    ;   }   }
    ;   if  ((exenv->ppoint < exenv->pgm->curr) && !(exenv->flags & PGOBLIN_END)) {
    ;       t = exenv->pgm->code[exenv->ppoint].cmd;
    ;       if  ((cmd = t & PGOBLIN_COMMAND) == PGOBLIN_extended) {
    ;           cmd = (exenv->pgm->code[exenv->ppoint].ecmd & PGOBLIN_COMMAND) | PGOBLIN_EXTENDED;
    ;           lit = NULL;
    ;       } else {
    ;           lit = exenv->pgm->code[exenv->ppoint].lit;
    ;       }
    ;       if  (cmd >= pgoblin.max || !(~pgoblin.a[cmd].flags & PGOBLIN_ILLEGAL)) {
    ;           ex = EX_DATAERR;
    ;           ifBLIN_QX0("cmd[%d]=%03X unknown", exenv->ppoint, cmd);
    ;           continue;
    ;       } else if (!pgoblin.a[cmd].flags) {
    ;           continue;
    ;       } else if (!pgoblin.a[cmd].car) {
    ;           ex = EX_DATAERR;
    ;           ifBLIN_QX1( "cmd[%d]=%03X(%s) Undefined"
                          , exenv->ppoint, cmd, pgoblin.a[cmd].str
                          );
    ;           continue;
    ;       }
    ;       a_cmd = &(pgoblin.a[cmd]);
    ;       if  (exenv->lexlevel) {
    ;           if  (a_cmd->flags & PGOBLIN_LEXLVUP) exenv->lexlevel++;
    ;           if  (a_cmd->flags & PGOBLIN_LEXLDOWN) exenv->lexlevel--;
    ;           continue;
    ;       }
    ;   } else {
    ;       t = 0;
    ;       lit = NULL;
    ;       cmd = PGOBLIN_return;
    ;       a_cmd = &(pgoblin.a[cmd]);
    ;       exenv->flags |= PGOBLIN_END;
    ;   }
    ;   ifBLIN_QO2 {
            pgoblin_exenv *c;
            int32_t        d;
            int32_t        s;

    ;       for (s = 0, c = exenv; c; c = c->stat) s++;
    ;       for (d = 0, c = exenv; c; c = c->dyna) d++;
    ;       fprintf( stderr, "#### (%ds %dd) N%d e%06X f%08X c%03X %s"
                   , s, d, exenv->ppoint, exenv->flags, a_cmd->flags, cmd, pgoblin.a[cmd].str
                   );
    ;       if  (lit) fprintf(stderr, "=%s~\n", lit); else fprintf(stderr, "\n");
    ;   }
    ;   ifBLIN_QX2("Registers:");
    ;   for (i = 0; i < pgoblin.symparam; i++) {
            int b;

    ;       if  (0 > (b = pgoblin_breg(cmd, i))) {
    ;           ch[i] = 0;
    ;           rn[i] = 0;
    ;           if  ((a_cmd->flags & pgoblin.p[i].val) || (i == PGO_CJOB)) {
    ;               r[i].v = pgoblin_getr(options, 0, i);
    ;           } else {
    ;               r[i].v = NULL;
    ;           }
    ;           ifBLIN_QO2 fprintf(stderr, "    ");
    ;       } else {
    ;           ch[i] = a_cmd->ch[b];
    ;           rn[i] = (t >> pgoblin.binparams[b]) & PGOBLIN_ARGMASK;
    ;           r[i].v = pgoblin_getr(options, !ch[i] ? 0 : rn[i], i);
    ;           ifBLIN_QO2 fprintf(stderr, "%d->", b);
    ;       }
    ;       ifBLIN_QO2 {
    ;           fprintf( stderr, "%d[%c] %s %" BLIN_X
                       , i
                       , pgoblin_regn[rn[i]]
                       , pgoblin.p[i].name
                       , BLIN_I((r[i].v))
                       )
    ;           ;
    ;           fprintf( stderr, " (%02X%s%s%s%s%s%s%s%s)"
                       , ch[i]
                       , (ch[i] & PGOBLIN_STYLE   ) ? " style": ""
                       , (ch[i] & PGOBLIN_JOB     ) ? " job"  : ""
                       , (ch[i] & PGOBLIN_CONNECT ) ? " conn" : ""
                       , (ch[i] & PGOBLIN_OUTSET  ) ? " out"  : ""
                       , (ch[i] & PGOBLIN_PQRESULT) ? " pq"   : ""
                       , (ch[i] & PGOBLIN_MIFEDES ) ? " mife" : ""
                       , (ch[i] & PGOBLIN_TEXTPARM) ? " text" : ""
                       , (ch[i] & PGOBLIN_PATHPARM) ? " path" : ""
                       )
    ;           ;
    ;           if  (!!r[i].v) {
    ;               switch(i) {
                    case PGO_CSTY:
    ;                   fprintf(stderr, " %08X %s\n", r[i].s->flags, STYLS(r[i].s->flags)->name);
    ;                   break;
    ;               case PGO_CJOB:
    ;                   fprintf(stderr, " %08X %s", r[i].j->flags, JOBE(r[i].j->flags)->name);
    ;                   if  (!!r[i].j->host) {
    ;                       fprintf(stderr, "=%s~\n", r[i].j->host);
    ;                   } else {
    ;                       fprintf(stderr, "\n");
    ;                   }
    ;                   break;
    ;               case PGO_CCON:
    ;                   fprintf(stderr, " %08X %s", r[i].c->flags, DBASE(r[i].c->flags)->name);
    ;                   if  (!!r[i].c->dbname) {
    ;                       fprintf(stderr, "=%s~\n", r[i].c->dbname);
    ;                   } else {
    ;                       fprintf(stderr, "\n");
    ;                   }
    ;                   break;
    ;               default:
    ;                   dump_ioreg(options, rn[i]);
    ;               }
    ;           } else {
    ;               fprintf(stderr, "\n");
    ;   }   }   }
    ;   pgoblin_toexe(cmd, exenv, rn);
    ;   ifBLIN_QO3 DUMPIOREGS;
    ;   /**************************
    ;    *   OUT *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_OUTSET) {
    ;       if  (!(ch[PGO_COUT] & PGOBLIN_OUTSET)) {
    ;           if  (!!RNOUT) {
    ;               if  ((ex = cleareg(options, RNOUT, PGOBLIN_PATHPARM | PGOBLIN_OUTSET))) {
    ;                   CICLEWARN(0, "Not clear path|wri OUT");
    ;           }   }
    ;       } else if ((ex = propush(exenv, RNOUT, ch[PGO_COUT]))) {
    ;           CICLEWARN(0, "No propush");
    ;       } else if ((RNOUT == RNCTL) || (RNOUT == RNIN)) {
    ;               /* copy XXXX */
    ;   }   }
    ;   /**************************
    ;    *   CTL *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_CTL) {
    ;       if  (ch[PGO_CCTL] & PGOBLIN_OUTSET) {
    ;           ex = EX_SOFTWARE;
    ;           CICLEWARN(1, "CTL&out");
    ;       } else if (!!RNCTL) {
    ;           if  (  (RNCTL == RNOUT)
                    && ( ch[PGO_CCTL]
                       & ch[PGO_COUT]
                       & (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT)
                    )  ) {
    ;               ifBLIN_QX1( "cmd[%d]=[%03X(%s)]    "
                              , exenv->ppoint, cmd, a_cmd->str
                              );
    ;           }
    ;           if  (!(IO_CTL->flags & PGOBLIN_ANYIVL)) {
    ;               if  (RNCTL != RNIN) exenv->flags |= PGOBLIN_FORKCTL;
    ;           } else if ((ex = coercion(exenv, RNCTL, ch[PGO_CCTL]))) {
    ;               CICLEWARN(1, "No coercion CTL");
    ;           }
    ;       } else if ((ch[PGO_CCTL] & PGOBLIN_TEXTPARM)) {
    ;           if  ((ex = cleareg(options, RNCTL, PGOBLIN_TEXTPARM))) {
    ;               CICLEWARN(1, "Not ready text CTL");
    ;           }
    ;           if  (!lit) {
    ;               MARK_IO_TEXT_NGO(RNCTL);;
    ;               ;;  IO_CTL->text = NULL;
    ;               ;;  IO_CTL->length = 0;
    ;               ;;  IO_CTL->flags &= ~(PGOBLIN_BINPARM | PGOBLIN_FREETEXT | PGOBLIN_TEXTPARM);
    ;               MARK_IO_TEXT_NWENT(RNCTL);;
    ;           } else if (!(pgm->flags & PGOBLIN_FREETEXT)) {
    ;               MARK_IO_TEXT_NGO(RNCTL);;
    ;               ;;  IO_CTL->text = lit;
    ;               ;;  IO_CTL->length = strlen(lit);
    ;               ;;  IO_CTL->flags &= ~(PGOBLIN_BINPARM | PGOBLIN_FREETEXT);
    ;               MARK_IO_TEXT_NWENT(RNCTL);;
    ;           } else {
    ;               MARK_IO_TEXT_NGO(RNCTL);;
    ;               ;;  IO_CTL->text = strdup(lit);
    ;               ;;  IO_CTL->length = strlen(lit);
    ;               ;;  IO_CTL->flags &= ~PGOBLIN_BINPARM;
    ;               ;;  IO_CTL->flags |= PGOBLIN_FREETEXT;
    ;               MARK_IO_TEXT_NWENT(RNCTL);;
    ;           }
    ;       } else if ((ch[PGO_CCTL] & PGOBLIN_PQRESULT)) {
                pgoblin_conn conn0;
                const char **cell;
                int i, c;
    ;
    ;           if  ((ex = cleareg(options, RNCTL, PGOBLIN_PQRESULT))) {
    ;               CICLEWARN(1, "Not ready pq CTL");
    ;           }
    ;           for (i = 0; ; i++) {
    ;               c = i;
    ;               if  (c && exenv->pgm->code[exenv->ppoint + c].cmd != PGOBLIN_cont) break;
    ;               if  (!exenv->pgm->code[exenv->ppoint + c].lit) break;
    ;           }
    ;           if  (c) {
    ;               if  (!(cell = malloc(c * sizeof(char**)))) { CICLEWARN(1, "No mem for Pq"); }
    ;               for (i = 0; i < c; i++) cell[i] = exenv->pgm->code[exenv->ppoint + i].lit;
    ;               MARK_R_CONN_GO(&conn0);;
    ;               ;;  conn0.flags = (options->flags & BLIN_MASK) | pgoblin_load(options, 3, "0", -1);
    ;               MARK_R_CONN_WENT(&conn0);;
    ;               MARK_IO_PQ_NGO(RNCTL);;
    ;               ;;  pgoblin_db0_create(&conn0, &IO_CTL->pq, c, cell, NULL);
    ;               ;;  IO_CTL->flags |= PGOBLIN_FREEPQRE;
    ;               MARK_IO_PQ_NWENT(RNCTL);;
    ;               free(cell);
    ;           }
    ;           pqjump = pgoblin_db_resinfo(PGOBLIN_Nfields, IO_CTL->pq) - 1;
    ;       } else if ((ex = coercomp(options, IO_CTL, ch[PGO_CCTL]))) {
    ;           CICLEWARN(1, "Not compatible CTL");
    ;   }   }
    ;   /**************************
    ;    *    IN *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_ISIN) {
    ;       if  (ch[PGO_CIN] & PGOBLIN_OUTSET) {
    ;           if  (!!RNIN) {
                    if  ((ex = cleareg(options, RNIN, PGOBLIN_PATHPARM | PGOBLIN_MIFEDES))) {
    ;                   CICLEWARN(2, "Not clear path|mife IN");
    ;           }   }
    ;       } else if (!!RNIN) {
    ;           if  (  (RNIN == RNOUT)
                    && ( ch[PGO_CIN]
                       & ch[PGO_COUT]
                       & (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT)
                    )  ) {
    ;               ifBLIN_QX1( "cmd[%d]=[%03X(%s)]    "
                              , exenv->ppoint, cmd, a_cmd->str
                              );
    ;           }
    ;           if  (!(IO_IN->flags & PGOBLIN_ANYIVL)) {
    ;               exenv->flags |= PGOBLIN_FORKIN;
    ;           } else if ((ex = coercion(exenv, RNIN, ch[PGO_CIN]))) {
    ;               CICLEWARN(2, "No coercion IN");
    ;           }
    ;       } else if ((ex = coercomp(options, IO_IN, ch[PGO_CIN] & ~PGOBLIN_PQRESULT))) {
    ;           CICLEWARN(2, "Not compatible IN");
    ;   }   }
    ;   /***************************
    ;    *   CONN *
    ;    ***************************/
    ;   if  (a_cmd->flags & PGOBLIN_CONNECT) {
    ;       if  (ch[PGO_CCON] & PGOBLIN_OUTSET) {
    ;           if  (RNCON) {
    ;               pgoblin_db_finish(R_CONN->flags, PGOBLIN_Connect, &R_CONN->conn);
    ;               MARK_R_CONN_NGO(RNCON);;
    ;               ;;  if  (R_CONN->flags & PGOBLIN_PARMDBFREE) free((char*)R_CONN->dbname);
    ;               ;;  R_CONN->conn = NULL;
    ;               ;;  R_CONN->flags = (options->flags & BLIN_MASK)
                /*  ;;  */            | (options->conn[0].flags & PGOBLIN_DB_TYPE);
    ;               ;;  R_CONN->dbname = NULL;
    ;               ;;  R_CONN->host = NULL;
    ;               ;;  R_CONN->port = NULL;
    ;               ;;  R_CONN->username = NULL;
    ;               ;;  R_CONN->intran = 0;
    ;               MARK_R_CONN_NWENT(RNCON);;
    ;           }
    ;       } else {
    ;           MARK_R_CONN_NGO(RNCON);;
    ;           ;;  R_CONN->flags = (options->flags & BLIN_MASK) | (R_CONN->flags & ~BLIN_MASK);
    ;           MARK_R_CONN_NWENT(RNCON);;
    ;           if  ((ex = pgoblin_db_shurecon(R_CONN))) {
    ;               CICLEWARN(3, "Not connected");
    ;   }   }   }
    ;   /**************************
    ;    *   JOB *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_JOB) {
    ;       if  (ch[PGO_CJOB] & PGOBLIN_OUTSET) {
    ;           if  (!!RNJOB) {
    ;               ex = JOBE(R_JOB->flags)->jose(exenv, rn);
    ;               MARK_R_JOB_NGO(RNJOB);;
    ;               ;;  mular_destroy(R_JOB->pids);
    ;               ;;  R_JOB->pids = NULL;
    ;               ;;  R_JOB->host = NULL;
    ;               ;;  R_JOB->concur = 0;
    ;               ;;  R_JOB->dead = 0;
    ;               ;;  if  (R_JOB->flags & PGOBLIN_KQUEUED) close(R_JOB->kq);
    ;               ;;  R_JOB->flags = options->flags & BLIN_MASK;
    ;               MARK_R_JOB_NWENT(RNJOB);;
    ;               if  (ex) {
    ;                   CICLEERR("Close JOB");
    ;                   continue;
    ;           }   }
    ;       } else if (  !(R_JOB->pids)
                      && !(R_JOB->pids = mular_create(MULAR_ZERO, 3, sizeof(pgoblin_jobl), u12))
                      ) {
    ;           ex = EX_SOFTWARE;
    ;           CICLEERR("No JOB");
    ;           continue;
    ;   }   }
    ;   /****************************
    ;    *   STYLE *
    ;    ****************************/
    ;   if  (a_cmd->flags & PGOBLIN_STYLE) {
    ;       if  (ch[PGO_CSTY] & PGOBLIN_OUTSET) {
    ;           if  (!!RNSTY) {
    ;               MARK_R_STYLE_NGO(RNSTY);;
    ;               ;;  if  (R_STYLE->style) STYLS(R_STYLE->flags)->clear(R_STYLE);
    ;               ;;  R_STYLE->style = NULL;
    ;               ;;  R_STYLE->path = NULL;
    ;               ;;  R_STYLE->flags = options->flags & BLIN_MASK;
    ;               MARK_R_STYLE_NWENT(RNSTY);;
    ;   }   }   }
    ;   /******************************
    ;    *     *
    ;    ******************************/
    ;   if  (exenv->flags & PGOBLIN_FORKIN) {
    ;       ifBLIN_QX2("FORKIN")
    ;       if  (!!(ex = pipe(options->pip2))) {
    ;           CICLEERR("pipe #2");
    ;           close(options->pip2[0]);
    ;           close(options->pip2[1]);
    ;           continue;
    ;   }   }
    ;   if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;       ifBLIN_QX2("FORKCTL")
    ;       if  (!!(ex = pipe(options->pip1))) {
    ;           CICLEERR("pipe #1");
    ;           close(options->pip1[0]);
    ;           close(options->pip1[1]);
    ;           continue;
    ;   }   }
    ;   if  (exenv->flags & PGOBLIN_FORKOUT) {
    ;       ifBLIN_QX2("FORKOUT")
    ;       if  (!!(ex = pipe(options->pip0))) {
    ;           CICLEERR("pipe #0");
    ;           close(options->pip0[0]);
    ;           close(options->pip0[1]);
    ;           continue;
    ;   }   }
    ;   ifBLIN_QO3 {
    ;       DUMPIOREGS;
    ;       fprintf(stderr, "flags=%08X\n", exenv->flags);
    ;   }
    ;   /*******************************
    ;    *     *
    ;    *******************************/
    ;   ntyp = 1;
    ;   jobflags = PGOBLIN_TOEXIT;
    ;   if  ((cmd == PGOBLIN_exec) && !!RNCTL) {
    ;       ntyp = pgoblin_db_resinfo(PGOBLIN_Ntuples, IO_CTL->pq);
    ;   }
    ;   if  (a_cmd->flags & PGOBLIN_FORKED) jobflags = JOBE(R_JOB->flags)->jest(cmd);
    ;   if  (exenv->flags & (PGOBLIN_FORKIN | PGOBLIN_FORKCTL | PGOBLIN_FORKOUT)) {
    ;       jobflags |= PGOBLIN_TOFORK;
    ;   }
    ;   for (exenv->sequen = 0; (exenv->sequen < ntyp) && !ex; exenv->sequen++) {
    ;       if  (!(jobflags & (PGOBLIN_TVFORK | PGOBLIN_TOFORK))) {
    ;           ifBLIN_QX2( "e%06X DO x %d(%d) c%03X %s"
                          , exenv->flags, ntyp, exenv->sequen, cmd, a_cmd->str
                          );
    ;           ex = pgoblin_cmdexe(cmd, exenv, rn);
    ;           ifBLIN_QX3("DONE %d", ex);
    ;       } else {
    ;       ;   ifBLIN_QX2( "e%06X FORK x %d(%d) c%03X %s"
                          , exenv->flags, ntyp, exenv->sequen, cmd, a_cmd->str
                          );
    ;       ;   if  (R_JOB->concur && (MULAR_NEXT(R_JOB->pids) >= (R_JOB->concur + R_JOB->dead))) {
    ;       ;       if  ((ex = waitjob(exenv->options, RNJOB))) {
    ;       ;           CICLEERR("waitjob");
    ;       ;           continue;
    ;       ;   }   }
    ;       ;   /*  if  ((ex = ((jobflags & PGOBLIN_TOFORK) ? fork() : vfork())) < 0) { */
    ;       ;   if  (!(pgoblin.a[cmd].flags & PGOBLIN_JOB)) {
    ;       ;       CICLEWARN(2, "fork without Ij");
    ;       ;   }
    ;       ;   if  ((ex = fork()) < 0) {
    ;       ;       CICLEERR("fork #1");
    ;       ;       continue;
    ;       ;   } else if (ex == 0) {
    ;       ;       ifBLIN_QX3("FORK CHILD");
    ;       ;       /*********************************
    ;       ;        * ,    *
    ;       ;   ;    *********************************/
    ;       ;   ;   for (int g = 0; g < pgoblin.regsize; g++) {
    ;       ;   ;       options->conn[g].flags &= ~PGOBLIN_CLOSECONN;
    ;       ;   ;   }
    ;       ;   ;   exenv->flags |= PGOBLIN_FORKED | PGOBLIN_CHILD;
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;       ;   ;       ifBLIN_QX0("fork with CTL");
    ;       ;   ;       ex = -EX_SOFTWARE;
    ;       ;   ;       exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKIN) {
    ;       ;   ;       if  ((ex = pgoblin_inx(options, IO_IN, options->pip2, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;       ;   ;       if  ((ex = pgoblin_inx(options, IO_CTL, options->pip1, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->flags & PGOBLIN_FORKOUT) {
    ;       ;   ;       if  ((ex = pgoblin_outx(options, IO_OUT, options->pip0, 1))) exit(ex);
    ;       ;       }
    ;       ;       if  (exenv->options->flags & PGOBLIN_FORK_WAIT) {
    ;       ;           ifBLIN_QX2( "sleep %us in fork"
                                  , exenv->options->flags & PGOBLIN_FORK_WAIT
                                  );
    ;       ;           sleep(exenv->options->flags & PGOBLIN_FORK_WAIT);
    ;       ;       }
    ;       ;       ex = pgoblin_cmdexe(cmd, exenv, rn);
    ;       ;       ifBLIN_QX3("CHILD DONE %d", ex);
    ;       ;       if  (jobflags & PGOBLIN_TOEXIT) exit(ex);
    ;       ;   } else {
                    pgoblin_jobl *j;

    ;       ;       ifBLIN_QX3("FORK DONE %d", ex);
    ;       ;       MARK_R_JOB_NGO(RNJOB);;
    ;       ;       ;;  j = mular_add(R_JOB->pids);
    ;       ;       ;;  j->cmdn = exenv->ppoint;
    ;       ;       ;;  j->pid = ex;
    ;       ;       ;;  j->status = PGOBLIN_NOSTATUS;
    ;       ;       MARK_R_JOB_NWENT(RNJOB);;
    ;       ;       if  (cmd == PGOBLIN_fork) exenv->lexlevel++;
    ;       ;       ex = 0;
    ;   }   }   }
    ;   if  (!(exenv->flags & PGOBLIN_CHILD)) {
    ;       if  (exenv->flags & PGOBLIN_FORKIN) {
    ;           if  ((ex = pgoblin_outx(options, IO_IN, options->pip2, 1))) continue;
    ;       }
    ;       if  (exenv->flags & PGOBLIN_FORKCTL) {
    ;           if  ((ex = pgoblin_outx(options, IO_CTL, options->pip1, 1))) continue;
    ;       }
    ;       if  (exenv->flags & PGOBLIN_FORKOUT) {
    ;           close(options->pip0[1]);
    ;           MARK_IO_MIFE_NGO(RNOUT);;
    ;           ;;  if  (  !(IO_OUT->mife = mife_init(MIFE_FULL))
                        || (0 > mife_ctl(IO_OUT->mife, MIFE_CTLFDSC, options->pip0[0]))
                        ) {
    ;           ;;      ex = EX_NOINPUT;
    ;           ;;      CICLEERR("mife_init");
    ;           ;;  } else {
    ;           ;;      IO_OUT->offset = 0;
    ;           ;;      IO_OUT->pid = 0;
    ;           ;;      IO_OUT->flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
    ;           ;;  }
    ;           MARK_IO_MIFE_NWENT(RNOUT);;
    ;   }   }
    ;   if  (ex) continue;
    ;   /*****************************
    ;    *  IO_OUT  *
    ;    *****************************/
    ;   if  (a_cmd->flags & PGOBLIN_OUTSET) {
    ;       ifBLIN_QO3 {
    ;   ;       fprintf(stderr, " %08X ", exenv->flags);
    ;   ;       dump_ioreg(options, rn[PGO_COUT]);
    ;   ;       if  (!ch[PGO_COUT] && !rn[PGO_COUT]) dump_ioreg(options, 0);
    ;   ;   }
    ;   ;   if  (exenv->flags & PGOBLIN_FREEPATH) {
                off_t off;
                mife_descriptor *md;
                char *cont;
                ssize_t bl;

    ;   ;       if  (!(IO_OUT->path)) {
    ;   ;           CICLEWARN(0, "unload no path");
    ;   ;       }
    ;   ;       md = mife_init(((PGOBLIN_RAWIOBUFL << 8) & MIFE_BUFL) | MIFE_BUFX);
    ;   ;       if  (!md || (0 > mife_ctl(md, MIFE_CTLFILE, IO_OUT->path))) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload mife init");
    ;   ;           continue;
    ;   ;       }
    ;   ;       for (off = 0; !(md->flags & MIFE_EOFL); off += bl) {
    ;   ;           bl = mife_ctl(md, MIFE_CTLREAD, off, (ssize_t)(1 << (PGOBLIN_RAWIOBUFL + 16)));
    ;   ;           if  (bl < 0) {
    ;   ;               ifBLIN_QW0("unload mife read %s:", IO_OUT->path);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;           }
    ;   ;           if  (!(cont = mife_point(md, MIFE_POINOFF, off))) {
    ;   ;               ifBLIN_QW0("unload mife get %s:", IO_OUT->path);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;           }
    ;   ;           if  (IO_OUT->wri(IO_OUT->onu, cont, bl) < 0) {
    ;   ;               ifBLIN_QW0("unload mife write");
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;       }   }
    ;   ;       if  (ex) continue;
    ;   ;       if  (mife_ctl(md, MIFE_CTLFINI)) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload close");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(options, RNOUT, PGOBLIN_PATHPARM);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->path not cleared");
    ;   ;   }
    ;   ;   if  (exenv->flags & PGOBLIN_FREETEXT) {
    ;   ;       if  (!(IO_OUT->text)) {
    ;   ;           CICLEWARN(0, "unload no text");
    ;   ;       }
    ;   ;       ex = IO_OUT->wri(IO_OUT->onu, IO_OUT->text, IO_OUT->length);
    ;   ;       if  (ex < 0) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload text write");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(options, RNOUT, PGOBLIN_TEXTPARM);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->text not cleared");
    ;   ;   }
    ;   ;   if  (exenv->flags & PGOBLIN_FREEPQRE) {
    ;   ;       if  (!(IO_OUT->pq)) {
    ;   ;           CICLEWARN(0, "unload no pq");
    ;   ;       }
    ;   ;       ex = STYLS(pgoblin_load(options, 5, "0", -1))->table(IO_OUT, &R_STY0, IO_OUT, 0, -2);
    ;   ;       if  (ex < 0) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload pq");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(options, RNOUT, PGOBLIN_PQRESULT);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->pq not cleared");
    ;   ;   }
    ;   ;   if  (!RNOUT) {
    ;   ;       if  (IO_OUT->path && !(IO_OUT->flags & PGOBLIN_PATHPARM)) {
    ;   ;           ex = cleareg(options, RNOUT, PGOBLIN_PATHPARM);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->path not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->text && !(IO_OUT->flags & PGOBLIN_TEXTPARM)) {
    ;   ;           ex = cleareg(options, RNOUT, PGOBLIN_TEXTPARM);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->text not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->pq && !(IO_OUT->flags & PGOBLIN_PQRESULT)) {
    ;   ;           ex = cleareg(options, RNOUT, PGOBLIN_PQRESULT);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->pq not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->mife && !(IO_OUT->flags & PGOBLIN_MIFEDES)) {
    ;   ;           ifBLIN_QX0("Clear mife in io[0]");
    ;   ;           ex = cleareg(options, RNOUT, PGOBLIN_MIFEDES);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->mife not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->wri && !(IO_OUT->flags & PGOBLIN_OUTSET)) {
    ;   ;           ifBLIN_QX0("Clear wri in io[0]");
    ;   ;           ex = cleareg(options, RNOUT, PGOBLIN_OUTSET);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->wri not cleared");
    ;   ;   }   }
    ;   ;   ifBLIN_QO3 {
    ;           fprintf(stderr, "  ");
    ;           dump_ioreg(options, rn[PGO_COUT]);
    ;           if  (!ch[PGO_COUT] && !rn[PGO_COUT]) dump_ioreg(options, 0);
    ;   }   }
    ;   if  ((a_cmd->flags & PGOBLIN_CTL) && !RNCTL && (ch[PGO_CCTL] & PGOBLIN_TEXTPARM)) {
    ;       ex = cleareg(options, RNCTL, PGOBLIN_TEXTPARM);
    ;       if  (ex) CICLEWARN(0, "0 IO_CTL->text not cleared");
        }
        if  (pqjump > 0) exenv->ppoint += pqjump;
        ifBLIN_QO0 iorassert(exenv, cmd);
    }
    if  (!ex && (exenv->flags & PGOBLIN_ERROR)) ex = -1;
    if  (dexenv) {
        dexenv->next = NULL;
    } else if (options->flags & PGOBLIN_CLEAR_ONEXIT) {
        for (g = 0; g < pgoblin.regsize; g++) {
            m = PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT;
            if  (g) m |= PGOBLIN_OUTSET | PGOBLIN_MIFEDES;
            cleareg(exenv->options, g, m);

#           define O(G) (exenv->options->conn[G])
            if  (!!DBASE(O(g).flags) && (O(g).flags & PGOBLIN_CLOSECONN)) {
                MARK_R_CONN_NGO(g);;
                ;;  pgoblin_db_finish(O(g).flags, PGOBLIN_Connect, &O(g).conn);
                ;;  O(g).conn = NULL;
                ;;  O(g).flags &= options->flags & BLIN_MASK;
                ;;  O(g).intran = 0;
                MARK_R_CONN_NWENT(g);;
            }
#           undef O

#           define O(G) (exenv->options->job[G])
            if  (!!JOBE(O(g).flags)) {
                MARK_R_JOB_NGO(g);;
                ;;  mular_destroy(O(g).pids);
                ;;  O(g).pids = NULL;
                ;;  if  (O(g).flags & PGOBLIN_HOSTJFREE) free(O(g).host);
                ;;  O(g).host = NULL;
                ;;  O(g).concur = 0;
                ;;  O(g).dead = 0;
                ;;  O(g).flags = options->flags & BLIN_MASK;
                MARK_R_JOB_NWENT(g);;
            }
#           undef O

#           define O(G) (exenv->options->style[G])
            if  (!!STYLS(O(g).flags)) {
                MARK_R_STYLE_NGO(g);;
                ;;  STYLS(O(g).flags)->clear(&O(g));
                ;;  O(g).style = NULL;
                ;;  O(g).path = NULL;
                ;;  O(g).flags &= ~PGOBLIN_STYLE_TYPE;
                MARK_R_STYLE_NWENT(g);;
            }
#           undef O
    }   }
out:
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
};
