/*-
 * Copyright (C)2008..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: db_0.c,v 1.60 2018/09/20 21:35:15 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MIFE_COMPAT      4
#define PGOBLIN_MODULE   2
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"

#define INDX(R, C) ((R) * rsv->ncol + (C)) /*        */

                                           /* Pc  db_0  NULL                                */
struct pgoblin_mode {                      /*  Pq                                           */
    BLIN_flag flags;
/*            PGOBLIN_DB_TYPE               *                                                        */
#   define    PGOBLIN_DB_0FREEC 0x010000   /*     free()                       */
#   define    PGOBLIN_DB_0FREEA 0x020000   /* cell  free()                                       */
#   define    PGOBLIN_DB_0FREES 0x040000   /* serv  free()                                       */
#   define    PGOBLIN_DB_0FREET 0x080000   /*   serv  free()                          */
#   define    PGOBLIN_DB_0FREEL 0x100000   /* llen  free()                                       */
#   define    PGOBLIN_DB_0INDIR 0x00000   /*   Pq    Pq (1),  (2), (3)  */
    int       ncol;                        /*                               */
    char    **cell;                        /*                */
    size_t   *llen;                        /*        *
                                            *  ,         *
                                            *  strlen()                                  */
    char    **serv;                        /*  ͣ                                */
    int       nrow;                        /*                                 */
};

pgoblin_mode *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db00(BLIN_flag flags) {                                     /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_mode *rsv = NULL;

#   define blin_internal_flags (flags & BLIN_MASK)
    if  (!(rsv = calloc(1, sizeof(pgoblin_mode)))) {
        ifBLIN_QW0("");
    } else {
        rsv->flags = (flags & BLIN_MASK) | pgoblin_load(pgoblin_options, 3, "0", -1);
    }
    return(rsv);
#   undef blin_internal_flags
}

static pgoblin_mode *
/**********************************************************************
 **                                                                  **/
resv(pgoblin_conn *db) {                                            /**
 **                                                                  **
 **********************************************************************/
    return(pgoblin_db00(db->flags));
}

int
/**********************************************************************
 **                                                                  **/
pgoblin_db0_create( pgoblin_conn       *db                          /**/
/**/              , pgoblin_mode      **rsv                         /**/
/**/              , int                 cnt                         /**/
/**/              , const char * const *val                         /**/
/**/              , const int          *len                         /**/
/**/              ) {                                               /**
 **                                                                  **
 **********************************************************************/
    int i, ex = EX_OK;

#   define blin_internal_flags ((db ? db->flags : pgoblin_default) & BLIN_MASK)
    if  (!db) {
        errno = EFAULT;
        ex = EX_DATAERR;
    } else if (!!rsv) {
        MARK_R_CONN_GO(db);;
        ;;  db->conn = NULL;                                                              /* Pc  */
        ;;  db->flags = (db->flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
     /* ;; */         | (pgoblin_db_0.flags & (BLIN_MASK | PGOBLIN_DB_TYPE))
        ;;  ;
        MARK_R_CONN_WENT(db);;
        if  (!(*rsv = resv(db))) {
            ifBLIN_QX0("No mem #1");
            errno = ENOMEM;
            ex = EX_OSERR;
        } else if (!((*rsv)->llen = malloc(cnt * sizeof(size_t)))) {
            free(*rsv);
            ifBLIN_QX0("No mem #2");
            errno = ENOMEM;
            ex = EX_OSERR;
        } else if (!((*rsv)->cell = malloc(cnt * sizeof(char*)))) {
            free((*rsv)->llen);
            free(*rsv);
            ifBLIN_QX0("No mem #3");
            errno = ENOMEM;
            ex = EX_OSERR;
        } else {
            (*rsv)->flags |= PGOBLIN_DB_0FREEL | PGOBLIN_DB_0FREEC | PGOBLIN_DB_0FREEA;
            (*rsv)->nrow = 1;
            (*rsv)->ncol = cnt;
            for (i = 0; i < cnt; i++) {
                if  (!val || !val[i]) {
                    (*rsv)->cell[i] = NULL;
                } else {
                    (*rsv)->cell[i] = strdup(val[i]);
                }
                if  (!len || (len[i] < 0)) {
                    (*rsv)->llen[i] = strlen(val[i]);
                } else {
                    (*rsv)->llen[i] = len[i];
    }   }   }   }
    if  (!!ex && !!rsv) *rsv = NULL;
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
init(BLIN_flag flags) {                                             /**
 **                                                                  **
 **********************************************************************/
    pgoblin_db_0.flags = (pgoblin_db_0.flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
                       | (flags & (BLIN_MASK | PGOBLIN_DB_TYPE))
    ;
    return(0);
}

static int
/**********************************************************************
 **                                                                  **/
fini() {                                                            /**
 **                                                                  **
 **********************************************************************/
    return(0);
}

static int
/**********************************************************************
 **                                                                  **/
shurecon(pgoblin_conn *db) {                                        /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK;

#   define blin_internal_flags (db->flags & BLIN_MASK)
    if  (!db) {
        ex = EX_DATAERR;
        errno = EINVAL;
    } else {
        MARK_R_CONN_GO(db);;
        ;;  db->conn = NULL;                                                              /* Pc  */
        ;;  db->flags = (db->flags & ~(BLIN_MASK | PGOBLIN_DB_TYPE))
     /* ;; */         | (pgoblin_db_0.flags & (BLIN_MASK | PGOBLIN_DB_TYPE))
        ;;  ;
        MARK_R_CONN_WENT(db);;
    }
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
query(pgoblin_conn *db, pgoblin_mode **rsv, char *qry) {            /**
 **                                                                  **
 **********************************************************************
 **  #select      NULL,             **
 **    qry "rows cols"                                   **
 **********************************************************************/
    int ex = EX_OK;
    char *q;

#   define blin_internal_flags ((db ? db->flags : pgoblin_default) & BLIN_MASK)
    if  (!db) {
        errno = EFAULT;
        ex = EX_DATAERR;
    } else if (rsv) {
        if  (!(*rsv = resv(db))) {
            ifBLIN_QU0(*(u_int32_t*)(db->conn), "No mem"); /* ???? XXXX ???? */
            errno = ENOMEM;
            ex = EX_OSERR;
        } else if (qry) {
            (*rsv)->nrow = strtoul(qry, &q, 0);
            (*rsv)->ncol = strtoul(q, &q, 0);
    }   }
    ifBLIN_QX4("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*************************************************************************************
 **                                                                                 **/
execute(pgoblin_conn *db, pgoblin_mode **rsv, const void *qp, pgoblin_mode *qin) { /**
 **                                                                                 **
 *************************************************************************************/
    int  ex = EX_SOFTWARE;

#   define blin_internal_flags ((db ? db->flags : pgoblin_default) & BLIN_MASK)
    if  (!db) {
        errno = EFAULT;
        ex = EX_DATAERR;
    } else if (!!rsv) {
        if  (!(*rsv = resv(db))) {
            ifBLIN_QX0("No mem #1");
            errno = ENOMEM;
            ex = EX_OSERR;
    }   }
    if  (!!ex && !!rsv) *rsv = NULL;
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
resinfo(int kind, pgoblin_mode *rsv) {                              /**
 **                                                                  **
 **********************************************************************/
    int ex;

#   define blin_internal_flags ((rsv ? rsv->flags : pgoblin_default) & BLIN_MASK)
    switch (kind) {
    if  (!rsv) {
        errno = EFAULT;
        ex = -1;
    } else {
        case PGOBLIN_Ntuples:
            ex = rsv->nrow;
            break;
        case PGOBLIN_Nfields:
            ex = rsv->ncol;
            break;
        default:
        ex = -1;
        errno = ENOTSUP;
    }   }
    return(ex);
#   undef blin_internal_flags
}

static const char *
/**********************************************************************
 **                                                                  **/
subinfo(int kind, pgoblin_mode *rsv, int sub) {                     /**
 **                                                                  **
 **********************************************************************/
    const char *cx = NULL;

    switch (kind) {
    case PGOBLIN_ColName:
        if  (!!rsv->serv && (rsv->ncol > sub)) cx = rsv->serv[sub];
        break;
    case PGOBLIN_TypeNm:
        if  (!!rsv->serv && (rsv->ncol > sub)) cx = rsv->serv[sub + rsv->ncol];
        break;
    default:;
    }
    return(cx);
}

static char *
/**********************************************************************
 **                                                                  **/
erinfo(pgoblin_mode *rsv) {                                         /**
 **                                                                  **
 **********************************************************************/
    char *cx = NULL;

    return(cx);
}

static int
/**********************************************************************
 **                                                                  **/
valinfo(int kind, pgoblin_mode *rsv, int row, int col) {            /**
 **                                                                  **
 **********************************************************************/
    int ex;

#   define blin_internal_flags ((rsv ? rsv->flags : pgoblin_default) & BLIN_MASK)
    switch (kind) {
    case PGOBLIN_IsNull:
        if  (rsv) {
            if  (!rsv->cell) {
                ex = 1;
            } else if ((row >= 0) && (row < rsv->nrow) && (col >= 0) && (col < rsv->ncol)) {
                ex = !rsv->cell[INDX(row, col)];
            } else {
                ifBLIN_QX1( "+ row %d %s in [0..%d], col %d %s in [0..%d]"
                          , row, (row >= 0 && row < rsv->nrow) ? "" : "NOT", rsv->nrow
                          , col, (col >= 0 && col < rsv->ncol) ? "" : "NOT", rsv->ncol
                          );
                ex = -1;
                errno = EINVAL;
            }
        } else if (row == 0 && col == 0) {
            ex = 1;
        } else {
            ifBLIN_QX0( "row %d col %d in emty", row, col);
            ex = -1;
            errno = EINVAL;
        }
        break;
    case PGOBLIN_Length:
        if  ((ex = valinfo(PGOBLIN_IsNull, rsv, row, col)) < 0) {
        } else if (ex) {
            ex = 0;
        } else if (rsv->llen) {
            ex = rsv->llen[INDX(row, col)];
        } else if (rsv->cell) {
            ex = strlen(rsv->cell[INDX(row, col)]);
        }
        break;
    default:
        ex = -1;
        errno = ENOTSUP;
    }
    return(ex);
#   undef blin_internal_flags
}

static char *
/**********************************************************************
 **                                                                  **/
getvalue(pgoblin_mode *rsv, int row, int col) {                     /**
 **                                                                  **
 **********************************************************************/
    char *c = NULL;

    if  (!valinfo(PGOBLIN_IsNull, rsv, row, col)) c = rsv->cell[INDX(row, col)];
    return(c);
}

static char*
/**********************************************************************
 **                                                                  **/
notifies(pgoblin_conn *db) {                                        /**
 **                                                                  **
 **********************************************************************/
    return(NULL);
}

static int
/**********************************************************************
 **                                                                  **/
finish(u_int32_t flags, int kind, void **entity) {                  /**
 **                                                                  **
 **********************************************************************/
    int ex = EX_OK;

#   define blin_internal_flags (flags & BLIN_MASK)
    switch (kind) {
    case PGOBLIN_Connect: {
            void **conn = entity;

            if  (conn) *conn = NULL;
        }
        break;
    case PGOBLIN_FrCOPY:
    case PGOBLIN_FrNote:
        break;
    default:
        ex = EX_UNAVAILABLE;
        errno = ENOTSUP;
    }
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
tarry(pgoblin_conn *db, int timeout) {                              /**
 **                                                                  **
 **********************************************************************/
    return(0);
}

static int
/**********************************************************************
 **                                                                  **/
clear(pgoblin_mode **rsv) {                                         /**
 **                                                                  **
 **********************************************************************/
    int i, ex = EX_OK;

#   define blin_internal_flags ((*rsv)->flags & BLIN_MASK)
    if  (rsv && *rsv) {
        ifBLIN_QX4("No rsv");
        if  (((*rsv)->llen) && ((*rsv)->flags & PGOBLIN_DB_0FREEL)) {
            free((*rsv)->llen);
            (*rsv)->llen = NULL;
        }
        if  ((*rsv)->serv) {
            if  ((*rsv)->flags & PGOBLIN_DB_0FREET) {
                for (i = 0; i < (*rsv)->ncol; i++) {
                    free((*rsv)->serv[i]);
                    (*rsv)->serv[i] = NULL;
            }   }
            if  ((*rsv)->flags & PGOBLIN_DB_0FREES) {
                free((*rsv)->serv);
                (*rsv)->serv = NULL;
        }   }
        if  ((*rsv)->cell) {
            if  ((*rsv)->flags & PGOBLIN_DB_0FREEC) {
                for (i = 0; i < (*rsv)->nrow * (*rsv)->ncol; i++) {
                    free((*rsv)->cell[i]);
                    (*rsv)->cell[i] = NULL;
            }   }
            if  ((*rsv)->flags & PGOBLIN_DB_0FREEA) {
                free((*rsv)->cell);
                (*rsv)->cell = NULL;
        }   }
        free(*rsv);
        *rsv = NULL;
    }
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
getstream(pgoblin_conn *db,pgoblin_mode** res, int quant) {         /**
 **                                                                  **
 **********************************************************************/
    warnx("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
}

static int
/**********************************************************************
 **                                                                  **/
getcopy(pgoblin_conn *db, void **buf) {                             /**
 **                                                                  **
 **********************************************************************/
    warnx("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
}

static int
/**********************************************************************
 **                                                                  **/
putcopy(pgoblin_conn *db, const void *buf, int nby) {               /**
 **                                                                  **
 **********************************************************************/
    warnx("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
}

static int
/**********************************************************************
 **                                                                  **/
endstream(pgoblin_conn *db) {                                       /**
 **                                                                  **
 **********************************************************************/
    warnx("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
}

pgoblin_dbases pgoblin_db_0 =
{ 0
, "3pGoblin-" VERS
, "0\0" VERS
, 0
, init
, fini
, shurecon
, query
, NULL      /* prepare   */
, execute
, resinfo
, subinfo
, erinfo
, valinfo
, getvalue
, getstream
, getcopy
, putcopy
, endstream
, tarry
, notifies
, finish
, clear
, NULL
, NULL
};
