/*-
 * Copyright (C)2017..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2017..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: db.c,v 1.22 2018/09/09 20:24:58 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_shurecon(pgoblin_conn *db) {                             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = 0;

    if  (!DBASE(db->flags)->shurecon) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(db->flags)->shurecon(db);
    }
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_query(pgoblin_conn *db, pgoblin_mode **rsv, char *qry) { /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    /*    */
    int ex = 0;

    if  (!DBASE(db->flags)->query) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(db->flags)->query(db, rsv, qry);
    }
    return(ex);
}

int
/************************************************************************
 ************************************************************************
 **                                                                    **/
pgoblin_db_prepare(pgoblin_conn *db, pgoblin_mode **rsv, char *qry) { /**
 **                                                                    **
 ************************************************************************
 ************************************************************************/
    int ex = 0;

    if  (!DBASE(db->flags)->prepare) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(db->flags)->prepare(db, rsv, qry);
    }
    return(ex);
}

int
/************************************************************************************************
 ************************************************************************************************
 **                                                                                            **/
pgoblin_db_execute(pgoblin_conn *db, pgoblin_mode **rsv, const void *qp, pgoblin_mode *qin) { /**
 **                                                                                            **
 ************************************************************************************************
 ************************************************************************************************/
    int ex = 0;

    if  (!DBASE(db->flags)->execute) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(db->flags)->execute(db, rsv, qp, qin);
    }
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_resinfo(int kind, pgoblin_mode *rsv) {                   /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = 0;

    if  (!rsv) {
        errno = EFAULT;
        ex = -EX_UNAVAILABLE;
    } else if (!DBASE(*rsv)->resinfo) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(*rsv)->resinfo(kind, rsv);
    }
    return(ex);

}

const char *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_subinfo(int kind, pgoblin_mode *rsv, int sub) {          /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    const char *c = NULL;

    if  (!rsv) {
        errno = EFAULT;
    } else if (!DBASE(*rsv)->subinfo) {
        errno = ENOSYS;
    } else {
        c = DBASE(*rsv)->subinfo(kind, rsv, sub);
    }
    return(c);
}

char *
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_erinfo(pgoblin_mode *rsv) {                              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    char *c = NULL;

    if  (!rsv) {
        errno = EFAULT;
    } else if (!DBASE(*rsv)->erinfo) {
        errno = ENOSYS;
    } else {
        c = DBASE(*rsv)->erinfo(rsv);
    }
    return(c);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_valinfo(int kind, pgoblin_mode *rsv, int row, int col) { /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = 0;

    if  (!rsv) {
        errno = EFAULT;
        ex = -EX_UNAVAILABLE;
    } else if (!DBASE(*rsv)->valinfo) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(*rsv)->valinfo(kind, rsv, row, col);
    }
    return(ex);
}

char*
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_getvalue(pgoblin_mode *rsv, int row, int col) {          /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    char *c = NULL;

    if  (!rsv) {
        errno = EFAULT;
    } else if (!DBASE(*rsv)->getvalue) {
        errno = ENOSYS;
    } else {
        c = DBASE(*rsv)->getvalue(rsv, row, col);
    }
    return(c);
}

int
/**************************************************************************
 **************************************************************************
 **                                                                      **/
pgoblin_db_getstream(pgoblin_conn *db, pgoblin_mode **rsv, int quant) { /**
 **                                                                      **
 **************************************************************************
 **************************************************************************/
    int ex = 0;

    if  (!DBASE(db->flags)->getstream) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(db->flags)->getstream(db, rsv, quant);
    }
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_getcopy(pgoblin_conn *db, void **buf) {                  /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = 0;

    if  (!DBASE(db->flags)->getcopy) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(db->flags)->getcopy(db, buf);
    }
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_putcopy(pgoblin_conn *db, const void *buf, int len) {    /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = 0;

    if  (!DBASE(db->flags)->putcopy) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(db->flags)->putcopy(db, buf, len);
    }
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_endstream(pgoblin_conn *db) {                            /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = 0;

    if  (!DBASE(db->flags)->endstream) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(db->flags)->endstream(db);
    }
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_tarry(pgoblin_conn *db, int timeout) {                   /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = 0;

    if  (!DBASE(db->flags)->tarry) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(db->flags)->tarry(db, timeout);
    }
    return(ex);
}

char*
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_notifies(pgoblin_conn *db) {                             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    char *c = NULL;

    if  (!DBASE(db->flags)->tarry) {
        errno = ENOSYS;
    } else {
        c = DBASE(db->flags)->notifies(db);
    }
    return(c);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_finish(u_int32_t flags, int kind, void **entity) {       /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = 0;

    if  (!DBASE(flags)->finish) {
        errno = ENOSYS;
        ex = -EX_UNAVAILABLE;
    } else {
        ex = DBASE(flags)->finish(flags, kind, entity);
    }
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_db_clear(pgoblin_mode **rsv) {                              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = 0;

    if  (rsv && *rsv) {
        if  (!DBASE(**rsv)->clear) {
            errno = ENOSYS;
            ex = -EX_UNAVAILABLE;
        } else {
            ex = DBASE(**rsv)->clear(rsv);
    }   }
    return(ex);
}
