/*-
 * Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_select.c,v 1.83 2019/01/22 18:46:57 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_perform(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;
    pgoblin_conn *conn;
    pgoblin_mode *res;
    const char  **val;
    pgoblin_io   *ctl;
    int          *len;
    int           row;
    int           col;
    pgoblin_io   *in;
    pgoblin_mode *n;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+perform .%c%c%c.."
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    conn = &(exenv->options->conn[rn[PGO_CCON]]);
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    in = &(exenv->options->io[rn[PGO_CIN]]);
    if (ctl->text) ifBLIN_QX3(" =%s", (char*)ctl->text);
    MARK_R_CONN_NGO(rn[PGO_CCON]);;
    ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
    ;;  conn->flags |= PGOBLIN_CR_OK;
    MARK_R_CONN_NWENT(rn[PGO_CCON]);;
    if  (!!rn[PGO_CIN] && !!in->pq) {
        if  (ctl->text) {
        } else if (!ctl->pq) {
            ifBLIN_QX0("perform: No query #1");
            ERROUT(EX_NOINPUT, EINVAL);
        } else if ((ex = pgoblin_style_0.table(ctl, exenv->options->style, ctl, 0, -2)) < 0) {
            ifBLIN_QW0("perform: No STYLE 0 #1");
            goto out;
        }
        if  (  !(col = pgoblin_db_resinfo(PGOBLIN_Nfields, in->pq))
            || !(row = pgoblin_db_resinfo(PGOBLIN_Ntuples, in->pq))
            ) goto out;
        ifBLIN_QX4("%d rows x %d cols", row, col);
        if  (!(val = malloc(sizeof(char *) * col))) {
            ifBLIN_QX0("perform: No mem #1");
            ERROUT(EX_OSERR, ENOMEM);
        }
        if  (!(len = malloc(sizeof(int) * col))) {
            ifBLIN_QX0("perform: No mem #2");
            ERROUT(EX_OSERR, ENOMEM);
        }
        if  (DBASE(conn->flags)->flags & PGOBLIN_DB_PREPARE) {
            if  ((ex = pgoblin_db_prepare(conn, &n, ctl->text))) {
                ifBLIN_QX0(" prepare\n%s", pgoblin_db_erinfo(n));
                errno = EDOOFUS;
                goto out;
            }
            MARK_R_CONN_NGO(rn[PGO_CCON]);;
            ;;  conn->flags |= PGOBLIN_ALTERQ;
            MARK_R_CONN_NWENT(rn[PGO_CCON]);;
            if  ((ex = pgoblin_db_execute(conn, NULL, n, in->pq))) {
                ifBLIN_QX0(" execute\n%s", pgoblin_db_erinfo(n));
                errno = EDOOFUS;
            }
            pgoblin_db_clear(&n);
        } else {
            ex = pgoblin_db_execute(conn, NULL, ctl->text, in->pq);
            /* if  (!!ex) XXXX */
        }
        free(val);
        free(len);
    } else if (ctl->text) {
        if  ((ex = pgoblin_db_query(conn, &res, ctl->text))) {
            ifBLIN_QX0(" query #1: %s", pgoblin_db_erinfo(res));
            ERROUT(EX_SOFTWARE, EDOOFUS);
        }
        pgoblin_db_clear(&res);
    } else if (!ctl->pq) {
        ifBLIN_QX0(" No query #2");
        ERROUT(EX_NOINPUT, EINVAL);
    } else {
        ssize_t k;

        for (k = 0; k < pgoblin_db_resinfo(PGOBLIN_Ntuples, ctl->pq); k++) {
            if  ((ex = pgoblin_style_0.table(ctl, exenv->options->style, ctl, k, -3)) < 0) {
                ifBLIN_QW0(" No STYLE 0 #2");
                goto out;
            }
            if  ((ex = pgoblin_db_query(conn, &res, ctl->text))) {
                ifBLIN_QX0(" query #2: %s", pgoblin_db_erinfo(res));
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            pgoblin_db_clear(&res);
    }   }
out:
    MARK_R_CONN_NGO(rn[PGO_CCON]);;
    ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_NWENT(rn[PGO_CCON]);;
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
presel(pgoblin_exenv *exenv, pgoblin_nr *rn, BLIN_flag cond) {      /**
 **                                                                  **
 **********************************************************************/
    pgoblin_conn  *conn;
    pgoblin_mode  *res;
    pgoblin_io    *out  = NULL;
    pgoblin_io    *ctl;
    int            row;
    int            col;
    pgoblin_io    *in;
    int            ex   = EX_OK;
    pgoblin_mode  *n;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    conn = &(exenv->options->conn[rn[PGO_CCON]]);
    if  (PGOBLIN_CR_OK != cond) {
        out = &(exenv->options->io[rn[PGO_COUT]]);
    }
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    in = &(exenv->options->io[rn[PGO_CIN]]);
    if (ctl->text) ifBLIN_QX3(" =%s", (char*)ctl->text);
    MARK_R_CONN_NGO(rn[PGO_CCON]);;
    ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
    ;;  conn->flags |= cond;
    MARK_R_CONN_NWENT(rn[PGO_CCON]);;
    if  ((ctl->flags & PGOBLIN_PQRESULT) && !!ctl->pq) {
        ifBLIN_QX5("CTLNtuples=%d", pgoblin_db_resinfo(PGOBLIN_Ntuples, ctl->pq));
        for (ssize_t k = 0; k < pgoblin_db_resinfo(PGOBLIN_Ntuples, ctl->pq); ++k) {
            MARK_IO_TEXT_NGO(rn[PGO_CCTL]);;
            ;;  if  (!!ctl->text && (ctl->flags & PGOBLIN_FREETEXT)) free(ctl->text);
            ;;  ex = pgoblin_style_0.table(ctl, exenv->options->style, ctl, k, -3);
            ;;  ctl->flags |= PGOBLIN_FREETEXT;
            MARK_IO_TEXT_NWENT(rn[PGO_CCTL]);;
            if  (0 > ex) {
                ifBLIN_QW0(" No STYLE 0");
                goto out;
            }
            if  (rn[PGO_CIN] && in->pq && !!(col = pgoblin_db_resinfo(PGOBLIN_Nfields, in->pq))) {
                ifBLIN_QX5( "INfields=%d INtuples=%d"
                          , pgoblin_db_resinfo(PGOBLIN_Nfields, in->pq)
                          , pgoblin_db_resinfo(PGOBLIN_Ntuples, in->pq)
                          );
                if  (!(row = pgoblin_db_resinfo(PGOBLIN_Ntuples, in->pq))) {
                    MARK_IO_PQ_NGO(rn[PGO_COUT]);;
                    ;;  out->pq = pgoblin_db00(exenv->options->flags);
                    ;;  out->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
                    MARK_IO_PQ_NWENT(rn[PGO_COUT]);;
                    goto out;
                }
                ifBLIN_QX4("%d rows x %d cols", row, col);
                if  (DBASE(conn->flags)->flags & PGOBLIN_DB_PREPARE) {
                    if  ((ex = pgoblin_db_prepare(conn, &n, ctl->text))) {
                        ifBLIN_QX0("presel %d: prepare\n%s", cond, pgoblin_db_erinfo(n));
                        pgoblin_db_clear(&n);
                        ERROUT(EX_SOFTWARE, EDOOFUS);
                    }
                    MARK_R_CONN_NGO(rn[PGO_CCON]);;
                    ;;  conn->flags |= PGOBLIN_ALTERQ;
                    MARK_R_CONN_NWENT(rn[PGO_CCON]);;
                    if  (!!(ex = pgoblin_db_execute(conn, &res, n, in->pq))) {
                        ifBLIN_QX0("presel %d: execute Q\n%s", cond, pgoblin_db_erinfo(res));
                        pgoblin_db_clear(&res);
                        ERROUT(EX_SOFTWARE, EDOOFUS);
                    }
                    if  (  (k + 1 < pgoblin_db_resinfo(PGOBLIN_Ntuples, ctl->pq))
                        || (PGOBLIN_CR_OK == cond)
                        ) {
                        pgoblin_db_clear(&res);
                    } else {
                        MARK_IO_PQ_NGO(rn[PGO_COUT]);;
                        ;;  out->pq = res;
                        ;;  if  (res) out->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
                        MARK_IO_PQ_NWENT(rn[PGO_COUT]);;
                    }
                    pgoblin_db_clear(&n);
                } else {
                    if  (!!(ex = pgoblin_db_execute(conn, &res, ctl->text, in->pq))) {
                        ifBLIN_QX0("presel %d: execute Q\n%s", cond, pgoblin_db_erinfo(res));
                        pgoblin_db_clear(&res);
                        ERROUT(EX_SOFTWARE, EDOOFUS);
                    }
                    if  (  (k + 1 < pgoblin_db_resinfo(PGOBLIN_Ntuples, ctl->pq))
                        || (PGOBLIN_CR_OK == cond)
                        ) {
                        pgoblin_db_clear(&res);
                    } else {
                        MARK_IO_PQ_NGO(rn[PGO_COUT]);;
                        ;;  out->pq = res
                        ;;  if  (res) out->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
                        MARK_IO_PQ_NWENT(rn[PGO_COUT]);;
                }   }
            } else {
                if  ((ex = pgoblin_db_query(conn, &res, ctl->text))) {
                    ifBLIN_QX0("presel %d: query: %s", cond, pgoblin_db_erinfo(res));
                    pgoblin_db_clear(&res);
                    ERROUT(EX_SOFTWARE, EDOOFUS);
                }
                if  (  (k + 1 < pgoblin_db_resinfo(PGOBLIN_Ntuples, ctl->pq))
                    || (PGOBLIN_CR_OK == cond)
                    ) {
                    pgoblin_db_clear(&res);
                } else {
                    MARK_IO_PQ_NGO(rn[PGO_COUT]);;
                    ;;  out->pq = res;
                    ;;  if  (res) out->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
                    MARK_IO_PQ_NWENT(rn[PGO_COUT]);;
        }   }   }
    } else if (!ctl->text) {
        ifBLIN_QX0("pgoblin_select: No query");
        ex = EX_NOINPUT;
        errno = EINVAL;
    } else if (!rn[PGO_CIN] || !in->pq) {
        ifBLIN_QX5("INNtuples=%d", pgoblin_db_resinfo(PGOBLIN_Ntuples, in->pq));
        if  (!!(ex = pgoblin_db_query(conn, &res, ctl->text))) {
            ifBLIN_QX0("presel %d: query: %s", cond, pgoblin_db_erinfo(res));
            pgoblin_db_clear(&res);
            ERROUT(EX_SOFTWARE, EDOOFUS);
        }
        if  (PGOBLIN_CR_OK == cond) {
            pgoblin_db_clear(&res);
        } else {
            MARK_IO_PQ_NGO(rn[PGO_COUT]);;
            ;;  out->pq = res;
            ;;  if  (res) out->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
            MARK_IO_PQ_NWENT(rn[PGO_COUT]);;
        }
    } else if ((conn->flags & PGOBLIN_DB_TYPE) == pgoblin_load(exenv->options, 3, "0", -1)) {
        if (ctl->text) ifBLIN_QX5(" =%s", (char*)ctl->text);
        if  (!!(ex = pgoblin_db_execute(conn, &res, ctl->text, in->pq))) {
            ifBLIN_QX0("presel %d: execute 0\n%s", cond, pgoblin_db_erinfo(res));
            pgoblin_db_clear(&res);
            ERROUT(EX_SOFTWARE, EDOOFUS);
        }
        if  (PGOBLIN_CR_OK == cond) {
            pgoblin_db_clear(&res);
        } else {
            MARK_IO_PQ_NGO(rn[PGO_COUT]);;
            ;;  out->pq = res;
            ;;  if  (res) out->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
            MARK_IO_PQ_NWENT(rn[PGO_COUT]);;
        }
    } else {
        ifBLIN_QX5( "INfields=%d INtuples=%d"
                  , pgoblin_db_resinfo(PGOBLIN_Nfields, in->pq)
                  , pgoblin_db_resinfo(PGOBLIN_Ntuples, in->pq)
                  );
        if  (!(row = pgoblin_db_resinfo(PGOBLIN_Ntuples, in->pq))) {
            MARK_IO_PQ_NGO(rn[PGO_COUT]);;
            ;;  out->pq = pgoblin_db00(exenv->options->flags);
            ;;  out->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
            MARK_IO_PQ_NWENT(rn[PGO_COUT]);;
            goto out;
        }
        ifBLIN_QX4("%d rows", row);
        if  (DBASE(conn->flags)->flags & PGOBLIN_DB_PREPARE) {
            if  ((ex = pgoblin_db_prepare(conn, &n, ctl->text))) {
                ifBLIN_QX0("presel %d: prepare\n%s", cond, pgoblin_db_erinfo(n));
                pgoblin_db_clear(&n);
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            MARK_R_CONN_NGO(rn[PGO_CCON]);;
            ;;  conn->flags |= PGOBLIN_ALTERQ;
            MARK_R_CONN_NWENT(rn[PGO_CCON]);;
            if  (!!(ex = pgoblin_db_execute(conn, &res, n, in->pq))) {
                ifBLIN_QX0("presel %d: execute Q\n%s", cond, pgoblin_db_erinfo(res));
                pgoblin_db_clear(&res);
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            if  (PGOBLIN_CR_OK == cond) {
                pgoblin_db_clear(&res);
            } else {
                MARK_IO_PQ_NGO(rn[PGO_COUT]);;
                ;;  out->pq = res
                ;;  if  (res) out->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
                MARK_IO_PQ_NWENT(rn[PGO_COUT]);;
            }
            pgoblin_db_clear(&n);
        } else {
            if  (!!(ex = pgoblin_db_execute(conn, &res, ctl->text, in->pq))) {
                ifBLIN_QX0("presel %d: execute Q\n%s", cond, pgoblin_db_erinfo(res));
                pgoblin_db_clear(&res);
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            if  (PGOBLIN_CR_OK == cond) {
                pgoblin_db_clear(&res);
            } else {
                MARK_IO_PQ_NGO(rn[PGO_COUT]);;
                ;;  out->pq = res;
                ;;  if  (res) out->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
                MARK_IO_PQ_NWENT(rn[PGO_COUT]);;
    }   }   }
out:
    MARK_R_CONN_NGO(rn[PGO_CCON]);;
    ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_NWENT(rn[PGO_CCON]);;
    return(ex);
#   undef blin_internal_flags
}

#if 0
int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_perform(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+perform .%c%c%c.."
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    ex = presel(exenv, rn, PGOBLIN_CR_OK);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
#endif

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_select(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+select %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    ex = presel(exenv, rn, PGOBLIN_CR_TUPL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_binpre(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int           ex = EX_OK;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+binpresel %c%c%c%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    ex = presel(exenv, rn, PGOBLIN_CR_BTUPL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_display(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_styreg *sty;
    pgoblin_io     *out;
    pgoblin_io     *in;
    ssize_t         ex;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+display %c.%c..%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    sty = &(exenv->options->style[rn[PGO_CSTY]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    in = &(exenv->options->io[rn[PGO_CIN]]);
    ex = STYLS(sty->flags)->table(out, sty, in, 0, -2);
    if  (ex < 0) ifBLIN_QX0("pgoblin_display: write error");
    ifBLIN_QX3("- %"BLIN_D, ex);
    return((ex < 0) ? ex : 0);
#   undef blin_internal_flags
}

static int
/**********************************************************************
 **                                                                  **/
sel(pgoblin_exenv *exenv, pgoblin_nr *rn, BLIN_flag cond) {         /**
 **                                                                  **
 **********************************************************************/
    ssize_t         ex = 0;
    ssize_t         e = 0;
    pgoblin_conn   *conn;
    pgoblin_styreg *sty;
    pgoblin_io     *out;
    pgoblin_io     *ctl;
    pgoblin_io      tr;
    ssize_t         k;
    size_t          i;
#   define          aim  (INT_MAX / 2)
#   define          aid                                                                                \
    ((PGOBLIN_BUFMULT * PGOBLIN_BUFSIZE > (aim / 4)) ? (aim / 4) : (PGOBLIN_BUFMULT * PGOBLIN_BUFSIZE))

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    sty = &(exenv->options->style[rn[PGO_CSTY]]);
    conn = &(exenv->options->conn[rn[PGO_CCON]]);
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    if  (!ctl->text) {
        ifBLIN_QX0("pgoblin_strsel: No query");
        ERROUT(EX_DATAERR, EINVAL);
    }
    bzero(&tr, sizeof(tr));
    MARK_R_CONN_NGO(rn[PGO_CCON]);;
    ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
    ;;  conn->flags |= cond;
    MARK_R_CONN_NWENT(rn[PGO_CCON]);;
    if  ((ex = pgoblin_db_query(conn, &tr.pq, (char*)ctl->text))) goto out;
    for (k = 0, i = 1; ; ) {
        int typn;

        if  ((ex = pgoblin_db_getstream(conn, &tr.pq, i))) goto out;
        typn = pgoblin_db_resinfo(PGOBLIN_Ntuples, tr.pq);
        e = STYLS(sty->flags)->table(out, sty, &tr, k, typn ? -1 : -2);
        if  ((e < 0) || (typn <= 0)) break;
        k += typn;
        ifBLIN_QX3("e=%d=>%"BLIN_D" aim=%d i %"BLIN_D" => ", typn, e, aim, i);
        if  (e < (aim * 2)) {
            if  (i < (aid / 2)) i = i * 2; else i = aid;
        } else if (e < aim) {
            if  (i < (aid / aim * e)) i = i / e * aim; else i = aid;
        } else if ((e / 2) > aim) {
            i = i / 4;
        } else if (e > aim) {
            i = i / e * aim;
        }
        ifBLIN_QX3("%"BLIN_D, i);
    }
    pgoblin_db_clear(&tr.pq);
    if  (e < 0) ifBLIN_QX0("pgoblin_strsel: write error");
out:
    /* XXXX END      ? */
    ex = pgoblin_db_endstream(conn);
    ifBLIN_QX3( "- %s %"BLIN_D
              , (cond == PGOBLIN_CR_SSEL)
              ? "pgoblin_strsel"
              : (cond == PGOBLIN_CR_BSEL) ? "pgoblin_binsel" : "pgoblin_???sel"
              , (e < 0) ? e : ex
              );
    MARK_R_CONN_NGO(rn[PGO_CCON]);;
    ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_NWENT(rn[PGO_CCON]);;
    return((e < 0) ? e : ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_strsel(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;

    ifBLIN_QX3( "+strselect %c%c.%c.%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CCON]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    ex = sel(exenv, rn, PGOBLIN_CR_SSEL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_binsel(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;

    ifBLIN_QX3( "+binselect %c%c.%c.%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CCON]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    ex = sel(exenv, rn, PGOBLIN_CR_BSEL);
    ifBLIN_QX3("- %d", ex);
    return(ex);
}
