/*-
 * Copyright (C)2004..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2004..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_file.c,v 1.70 2018/09/10 00:42:06 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <errno.h>
#include <stdio.h>
#include <fts.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <getCGIparm.h>
#include <mife.h>
#include "pgoblin.h"

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_echo(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int             ex = EX_OK;
    pgoblin_styreg *sty;
    pgoblin_io     *ctl;
    pgoblin_io     *out;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+echo %c%c...%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    if  (!ctl->text) {
        ERROUT(EX_DATAERR, EINVAL);
    }
    sty = &(exenv->options->style[rn[PGO_CSTY]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    if  (rn[PGO_CSTY]) {
        u_char *tmpc;
        char *tmpo;
        int tfree;

        if  (ctl->flags & PGOBLIN_BINPARM) {
            if  (!(tmpc = malloc(ctl->length + 1))) {
                ifBLIN_QX3("No mem #echo #1");
                ERROUT(EX_OSERR, ENOMEM);
            }
            bcopy(ctl->text, tmpc, ctl->length);
            tmpc[ctl->length] = '\0';
            tfree = 1;
        } else {
            tmpc = ctl->text;
            tfree = 0;
        }
        tmpo = STYLS(sty->flags)->get(sty, tmpc);
        if  (tmpo) {
            MARK_IO_TEXT_NGO(rn[PGO_COUT]);;
            ;;  out->text = tmpo;
            ;;  out->length = strlen(out->text);
            ;;  out->flags &= ~PGOBLIN_BINPARM;
            ;;  out->flags |= PGOBLIN_TEXTPARM | PGOBLIN_FREETEXT;
            MARK_IO_TEXT_NWENT(rn[PGO_COUT]);;
        } else {
            MARK_IO_TEXT_NGO(rn[PGO_COUT]);;
            ;;  out->text = NULL;
            ;;  out->length = 0;
            ;;  out->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_BINPARM | PGOBLIN_TEXTPARM);
            MARK_IO_TEXT_NWENT(rn[PGO_COUT]);;
            ifBLIN_QX1("No const %s", tmpc);
        }
        if  (tfree) free(tmpc);
    } else if (rn[PGO_COUT] != rn[PGO_CCTL]) {
        if  (!(ctl->flags & PGOBLIN_FREETEXT)) {
            MARK_IO_TEXT_NGO(rn[PGO_COUT]);;
            ;;  out->text = ctl->text;
            ;;  out->length = ctl->length;
            ;;  out->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_BINPARM);
            ;;  out->flags |= PGOBLIN_TEXTPARM | (ctl->flags & PGOBLIN_BINPARM);
            MARK_IO_TEXT_NWENT(rn[PGO_COUT]);;
        } else {
            MARK_IO_TEXT_NGO(rn[PGO_COUT]);;
            ;;  if  (!(out->text = malloc(ctl->length + 1))) {
            ;;      ifBLIN_QX0("No mem #echo #2");
            ;;      ERROUT(EX_OSERR, ENOMEM);
            ;;  } else {
            ;;      out->length = ctl->length;
            ;;      bcopy(ctl->text, out->text, ctl->length);
            ;;      ((u_char*)out->text)[out->length] = '\0'
            ;;      out->flags &= ~PGOBLIN_BINPARM;
            ;;      out->flags |= PGOBLIN_TEXTPARM | PGOBLIN_FREETEXT;
            ;;  }
            MARK_IO_TEXT_NWENT(rn[PGO_COUT]);;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_file(pgoblin_exenv *exenv, pgoblin_nr *rn) {                /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int             ex = EX_OK;
    pgoblin_styreg *sty;
    pgoblin_io     *ctl;
    pgoblin_io     *out;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+file %c%c...%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    sty = &(exenv->options->style[rn[PGO_CSTY]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    if  (rn[PGO_CSTY]) {
        if  (!ctl->text) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  (ctl->flags & PGOBLIN_BINPARM) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        MARK_IO_PATH_NGO(rn[PGO_COUT]);;
        ;;  out->path = STYLS(sty->flags)->get(sty, ctl->text);
        ;;  if  (out->path) {
        ;;      out->flags |= PGOBLIN_FILEOVER | PGOBLIN_PATHPARM | PGOBLIN_FREEPATH;
        ;;  } else {
        ;;      out->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        ;;      ERROUT(EX_DATAERR, EINVAL);
        ;;  }
        MARK_IO_PATH_NWENT(rn[PGO_COUT]);;
    } else if (!ctl->text) {
        MARK_IO_PATH_NGO(rn[PGO_COUT]);;
        ;;  out->path = ctl->text;
        ;;  out->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_PATHPARM);
        ;;  out->flags |= PGOBLIN_FILEOVER;
        MARK_IO_PATH_NWENT(rn[PGO_COUT]);;
    } else if (ctl->flags & PGOBLIN_FREETEXT) {
        MARK_IO_PATH_NGO(rn[PGO_COUT]);;
        ;;  if  (!(out->path = strdup(ctl->text))) {
        ;;      ifBLIN_QX0("No mem #file");
        ;;      ERROUT(EX_OSERR, ENOMEM);
        ;;  } else {
        ;;      out->flags |= PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM;
        ;;  }
        MARK_IO_PATH_NWENT(rn[PGO_COUT]);;
    } else {
        MARK_IO_PATH_NGO(rn[PGO_COUT]);;
        ;;  out->path = ctl->text;
        ;;  out->flags &= ~PGOBLIN_FREEPATH;
        ;;  out->flags |= PGOBLIN_FILEOVER | PGOBLIN_PATHPARM;
        MARK_IO_PATH_NWENT(rn[PGO_COUT]);;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_cat(pgoblin_exenv *exenv, pgoblin_nr *rn) {                 /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int             ex = EX_OK;
    pgoblin_styreg *sty;
    pgoblin_io     *ctl;
    pgoblin_io     *out;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+cat %c%c...%c"
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CSTY]]
              );
    sty = &(exenv->options->style[rn[PGO_CSTY]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    if  (rn[PGO_CSTY]) {
        if  (!ctl->text) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  (ctl->flags & PGOBLIN_BINPARM) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        MARK_IO_PATH_NGO(rn[PGO_COUT]);;
        ;;  out->path = STYLS(sty->flags)->get(sty, ctl->text);
        ;;  if  (out->path) {
        ;;      out->flags &= ~PGOBLIN_FILEOVER;
        ;;      out->flags |= PGOBLIN_PATHPARM | PGOBLIN_FREEPATH;
        ;;  } else {
        ;;      out->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        ;;      ERROUT(EX_DATAERR, EINVAL);
        ;;  }
        MARK_IO_PATH_NWENT(rn[PGO_COUT]);;
    } else if (!ctl->text) {
        MARK_IO_PATH_NGO(rn[PGO_COUT]);;
        ;;  out->path = ctl->text;
        ;;  out->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        MARK_IO_PATH_NWENT(rn[PGO_COUT]);;
    } else if (ctl->flags & PGOBLIN_FREETEXT) {
        MARK_IO_PATH_NGO(rn[PGO_COUT]);;
        ;;  if  (!(out->path = strdup(ctl->text))) {
        ;;      ifBLIN_QX0("No mem #cat");
        ;;      ERROUT(EX_OSERR, ENOMEM);
        ;;  } else {
        ;;      out->flags &= ~PGOBLIN_FILEOVER;
        ;;      out->flags |= PGOBLIN_FREEPATH | PGOBLIN_PATHPARM;
        ;;  }
        MARK_IO_PATH_NWENT(rn[PGO_COUT]);;
    } else {
        MARK_IO_PATH_NGO(rn[PGO_COUT]);;
        ;;  out->path = ctl->text;
        ;;  out->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER);
        ;;  out->flags |= PGOBLIN_PATHPARM;
        MARK_IO_PATH_NWENT(rn[PGO_COUT]);;
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getarg(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int         ex = EX_OK;
    pgoblin_io *out;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getarg %c.....", pgoblin_regn[rn[PGO_COUT]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    if  ((ex = getCGIparmarray( 0
                              , (u_char**)&exenv->options->stack[exenv->options->ap]
                              , (u_char*)"any"
                              , (u_char*)"\t"
                              , (u_char*)"\\N"
                              , out->wri
                              , out->onu
        ))                    ) {
        ifBLIN_QW0("getCGIparmarray");
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getenv(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int         ex = EX_OK;
    pgoblin_io *out;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getenv %c.....", pgoblin_regn[rn[PGO_COUT]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    if  ((ex = getCGIparmenv( gCGI_RNUM, (const u_char **)exenv->options->envp
                            , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                            , out->wri, out->onu
        ))                  ) {
        ifBLIN_QW0("getCGIparmenv");
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getget(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int         ex = EX_OK;
    pgoblin_io *out;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getget %c.....", pgoblin_regn[rn[PGO_COUT]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    if  ((ex = getCGIparmcopy( gCGI_RNUM | gCGI_SEPR, (u_char*)getenv("QUERY_STRING")
                             , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                             , out->wri, out->onu
        ))                   ) {
        ifBLIN_QW0("getCGIparmcopy");
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getpost(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int         ex = EX_OK;
    pgoblin_io *out;
    pgoblin_io *in;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getpost %c.%c...", pgoblin_regn[rn[PGO_COUT]], pgoblin_regn[rn[PGO_CIN]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    in = &(exenv->options->io[rn[PGO_CIN]]);
    if  (mife_ctl(in->mife, MIFE_CTLREAD, in->offset, (ssize_t)0) < 0) {
        ifBLIN_QW0("mife_ctl(MIFE_CTLREAD)");
        return(EX_OSERR);
    }
    if  ((ex = getCGIparmcopy( gCGI_RNUM | gCGI_SEPR
                             , mife_point(in->mife, MIFE_POINOFF, in->offset)
                             , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                             , out->wri, out->onu
        ))                   ) {
        ifBLIN_QW0("getCGIparmcopy");
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getproc(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int         ex = EX_OK;
    pgoblin_io *out;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getproc %c.....", pgoblin_regn[rn[PGO_COUT]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    if  ((ex = getCGIparmproc( 0, (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                             , out->wri, out->onu
        ))                   ) {
        ifBLIN_QW0("getCGIparmproc");
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getspq(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    ifBLIN_QX3( "+getspq......");
    ifBLIN_QX3("- %d", EX_UNAVAILABLE);
    return(EX_UNAVAILABLE);
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getstr(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int         ex = EX_OK;
    char       *cont;
    pgoblin_io *out;
    pgoblin_io *in;
    FILE       *fi;
    ssize_t     bl;
    ssize_t     i;
    int         j;
    int         l;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getstr %c.%c...", pgoblin_regn[rn[PGO_COUT]], pgoblin_regn[rn[PGO_CIN]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    in = &(exenv->options->io[rn[PGO_CIN]]);
    if  (!(fi = funopen( (void*)(size_t)(out->onu)
                       , NULL
                       , (int (*)(void*, const char*, int))mife_writ
                       , NULL
                       , NULL
        ) )            ) {
        ifBLIN_QW0("getstr funopen #0 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    } else {
        for (j = 0, l = 1; !(in->mife->flags & MIFE_EOFL); in->offset += bl) {
            bl = mife_ctl( in->mife
                         , MIFE_CTLREAD
                         , in->offset
                         , (ssize_t)(1 << (PGOBLIN_RAWIOBUFL + 16))
                         );
            if  (0 > bl) {
                ifBLIN_QW0("mife_ctl(MIFE_CTLREAD)");
                ex = EX_IOERR;
                break;
            }
            if  (!(cont = mife_point(in->mife, MIFE_POINOFF, in->offset))) {
                ifBLIN_QW0("mife_point(MIFE_POINOFF)");
                ex = EX_IOERR;
                break;
            }
            for (i = 0; i < bl; i++, cont++) {
                switch (*cont) {
                    case '\\': if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "\\\\");      break;
                    case '\0': if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "\\0");       break;
                    case '\t': if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "\\t");       break;
                    case '\n': if (l) fprintf(fi, "%d\t", j); l = 1; fprintf(fi, "\n"); j++;   break;
                    default:   if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "%c", *cont); break;
        }   }   }
        if  (!l) fprintf(fi, "\n");
        if  (~exenv->options->flags & PGOBLIN_COPEND_NOGEN) fprintf(fi, "\\.\n");
    }
    if  (fclose(fi) < 0) {
        ifBLIN_QW0("fclose #0 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static const char statenames[][3] =
{ "bg", "cp", "be", "cq", "qq", "xx"};

enum states
{ bg /*                                      */
, cp /*                  */
, be /*                        */
, cq /*                    */
, qq /*                         */
, xx
};

static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "- ", "Ct", "Cd", "Cb", "Cp", "Cn", "- ", "Cq"
, "- ", "- ", "- ", "- ", "Cx", "- ", "- ", "- "
};

#define Ct  0x400000 /* \t                                 */
#define Cd  0x200000 /*            */
#define Cb  0x100000 /*             */
#define Cp  0x080000 /*      */
#define Cn  0x040000 /*                     */
#define Cq  0x010000 /*   ++                */
#define Cx  0x000800 /*                           */
#define C_state 0xFF /*                  */

static const char clasnames[][3] =
{ "L0", "Ll", "Lb", "Ls", "Lq", "Lc", "Lo", "Lx"};

#define L0 0 /* \0                                         */
#define Ll 1 /*                                 */
#define Lb 2 /*                                      */
#define Ls 3 /*                                */
#define Lq 4 /* "                                          */
#define Lc 5 /* ,                                          */
#define Lo 6 /*                                   */
#define Lx 7

static const char clasi[257] =
{ L0
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lb, Ll, Ls,  Lo, Ls, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lb, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
};

static u_int32_t automa[xx][Lx] =
/*    \0 L0     \n Ll  \b Lb x Ls         " Lq      ; Lc         * Lo  *    */
{{       xx, Cn|Cb|bg,    bg,  bg,          cq, Ct|Cb|bg,       Cp|cp}/* bg */
,{ Cn|Cb|xx, Cn|Cb|bg, Cq|be,  cp,          cp, Ct|Cb|bg,       Cp|cp}/* cp */
,{ Cn|Cb|xx, Cn|Cb|bg,    be,  be, Cd|Cb|Cp|cp, Ct|Cb|bg, Cd|Cb|Cp|cp}/* be */
,{    Cx|xx,    Cp|cq, Cp|cq,  cq,          qq,    Cp|cq,       Cp|cq}/* cq */
,{ Cn|Cb|xx, Cn|Cb|bg,    be,  qq,       Cp|cq, Ct|Cb|bg,          cp}/* qq */
};

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getcsv(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    char        class[257];
    int         ex = EX_OK;
    int         max = 0;
    int         coln;
    pgoblin_io *out;
    pgoblin_io *ctl;
    pgoblin_io *in;
    FILE       *fi;
    u_char     *t;
    u_char      c;
    u_char      q;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getcsv %c%c%c..."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              );
    out = &(exenv->options->io[rn[PGO_COUT]]);
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    in = &(exenv->options->io[rn[PGO_CIN]]);
    c = ';';
    q = '\"';
    if  ((t = ctl->text)) {
        c = t[0];
        q = t[1];
        errno = 0;
        if  (t[2]) max = strtol((char*)&(t[2]), NULL, 0);
        if  (errno) {
            ifBLIN_QW0("strtol=%s~", (char *)ctl->text);
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  (max < 0) {
            ifBLIN_QX0("strtol %d<0", max);
            ERROUT(EX_DATAERR, EINVAL);
    }   }
    bcopy(clasi, class, 257);
    class[c + 1] = Lc;
    class[q + 1] = Lq;
    if  (!(fi = funopen( (void*)(size_t)(out->onu)
                       , NULL
                       , (int (*)(void*, const char*, int))mife_writ
                       , NULL
                       , NULL
        ) )            ) {
        ifBLIN_QW0("funopen #0 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    } else {
        enum states state;
        u_int32_t control;
        char *cont;
        ssize_t l;
        u_char p;
        int s, rs;

        blin_stateheader(BLIN_4STA24G, pn);
        for (state = bg, control = 0, coln = 0, rs = 0
            ; state < xx
            ; in->offset++, state = control & C_state
            ) {
            if  ((l = mife_ctl(in->mife, MIFE_CTLREAD, in->offset, (ssize_t)1)) < 0) {
                ifBLIN_QW0("mife_ctl(MIFE_CTLREAD)");
                ex = EX_IOERR;
                break;
            }
            if  (!(cont = mife_point(in->mife, MIFE_POINOFF, in->offset))) {
                ifBLIN_QW0("mife_point(MIFE_POINOFF)");
                ex = EX_IOERR;
                break;
            }
            if  (l) s = *cont & 0xFF; else s = -1;
            p = (u_char)(class[s + 1]);
            control = automa[state][p];
            blin_statebody( BLIN_4STA24G
                          , pn
                          , statenames
                          , clasnames[(u_char)p]
                          , 0
                          , BLIN_I(cont)
                          , control
                          , state
                          , rs
                          , coln
                          );
            if  (control & Ct) {
                if  (++coln < max || !max) fputc('\t', fi);
            }
            if  (control & Cd) {
                for (;rs && (coln <= max || !max); rs--) fputc(' ', fi);
            }
            if  (control & Cb) rs = 0;
            if  (control & Cp) {
                if  (coln <= max || !max) switch (s) {
                    case '\\': fprintf(fi, "\\\\");      break;
                    case '\0': fprintf(fi, "\\0");       break;
                    case '\t': fprintf(fi, "\\t");       break;
                    case '\n': fprintf(fi, "\\n");       break;
                    default  : fputc(s, fi);
            }   }
            if  (control & Cn) {
                for (;++coln < max;) {
                    fprintf(fi, "\t\\N");
                }
                fprintf(fi, "\n");
                coln = 0;
            }
            if  (control & Cq) rs++;
            if  (control & Cx) {
                ifBLIN_QX0("syntax");
                errno = EINVAL;
                ex = EX_DATAERR;
        }   }
        if  (~exenv->options->flags & PGOBLIN_COPEND_NOGEN) fprintf(fi, "\\.\n");
        if  (fclose(fi) < 0) {
            ifBLIN_QW0("fclose on %d", rn[PGO_COUT]);
            ex = EX_OSERR;
    }   }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_getdir(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int             ex = EX_OK;
    FILE           *fi = NULL;
    int             i = 0;
    u_int32_t       mode;
    int             ncol;
    pgoblin_jobreg *job;
    pgoblin_dir    *dir;
    int             max;
    pgoblin_io     *out;
    pgoblin_io     *ctl;
    pgoblin_io     *in;
    char           *s;
    char           *q;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+getdir %c%c%c.%c."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CJOB]]
              );
    job = &(exenv->options->job[rn[PGO_CJOB]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    in = &(exenv->options->io[rn[PGO_CIN]]);
    if  (!ctl->text) {
        ifBLIN_QX0("No CTL Pt");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!(fi = funopen( (void*)(size_t)(out->onu)
                       , NULL
                       , (int (*)(void*, const char*, int))mife_writ
                       , NULL
                       , NULL
        ) )            ) {
        ifBLIN_QW0("funopen #1 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    } else {
        mode = strtoul(ctl->text, &q, 0);
        for (i = 0; ; ++i)  {
            if  (rn[PGO_CIN]) {
                int j, k, m;

                max = pgoblin_db_resinfo(PGOBLIN_Ntuples, in->pq);
                if  (i >= max) break;
                ncol = pgoblin_db_resinfo(PGOBLIN_Nfields, in->pq);
                ifBLIN_QX3(" %d @ %d : %d", i, max, ncol);
                switch (ncol) {
                case 0 : ifBLIN_QX1("Null name in getdir %d", rn[PGO_CCTL]);
                       ; goto out;
                case 1 : q = pgoblin_db_getvalue(in->pq, i, 0);
                       ; ifBLIN_QX3("1Dir=%s~", q);
                       ; break;
                default: for (j = 0, k = 0; j < ncol; j++) {
                       ;     if  (!pgoblin_db_valinfo(PGOBLIN_IsNull, in->pq, i, j)) {
                       ;         k += pgoblin_db_valinfo(PGOBLIN_Length, in->pq, i, j);
                       ; }   }
                       ; if  (!k) {
                       ;     ifBLIN_QX1("Empty name in getdir %d", rn[PGO_CCTL]);
                       ;     goto out;
                       ; }
                       ; if  (!(q = malloc(k + 1))) {
                       ;     ifBLIN_QX0("No mem %d", k + 1);
                       ;     ERROUT(EX_OSERR, ENOMEM);
                       ; }
                       ; for (j = 0, k = 0; j < ncol; j++) {
                       ;     if  (!pgoblin_db_valinfo(PGOBLIN_IsNull, in->pq, i, j)) {
                       ;         m = pgoblin_db_valinfo(PGOBLIN_Length, in->pq, i, j);
                       ;         bcopy(pgoblin_db_getvalue(in->pq, i, j), &(q[k]), m);
                       ;         k += m;
                       ;         q[k] = '\0';
                       ; }   }
                       ; ifBLIN_QX3("NDir=%s~", q);
                }
            } else { /* MAJORDELETE */
                max = 0, ncol = 1;
                if  (i > max) break;
                if  (*q) {
                    if  (*q != ' ' && *q != '\t') {
                        ifBLIN_QX1("No white space in getdir %d", rn[PGO_CCTL]);
                    } else {
                        q++;
            }   }   }
            for (dir = NULL; (dir = JOBE(job->flags)->jdir(exenv, dir, q));) {
                if  (q && (ncol > 1)) free(q);
                q = dir->ent;
                if  (getCGIparmpass3(0, (u_char*)"copy", (u_char**)&q)) {
                    ifBLIN_QX0("getCGIparmpass3");
                    ex = EX_SOFTWARE;
                    goto out;
                }
                s = "";
                if  (mode & 0x01) {
                    fprintf(fi, "%d", dir->i);
                    s = "\t";
                }
                if  (mode & 0x02) {
                    fprintf(fi, "%s%s", s, q);
                    s = "\t";
                }
                if  (mode & 0x04) {
                    if  (dir->sb) {
                        fprintf(fi, "%s%lld", s, (long long)dir->sb->st_size);
                    } else {
                        fprintf(fi, "%s\\N", s);
                    }
                    s = "\t";
                }
                if  (mode & 0x08) {
                    if  (dir->sb) {
                        fprintf(fi, "%s%u", s, dir->sb->st_mode);
                    } else {
                        fprintf(fi, "%s\\N", s);
                    }
                    s = "\t";
                }
                if  (mode & 0x10) {
                    if  (dir->sb) {
                        fprintf(fi, "%s%u", s, dir->sb->st_uid);
                    } else {
                        fprintf(fi, "%s\\N", s);
                    }
                    s = "\t";
                }
                if  (mode & 0x20) {
                    if  (dir->sb) {
                        fprintf(fi, "%s%u", s, dir->sb->st_gid);
                    } else {
                        fprintf(fi, "%s\\N", s);
                    }
                    s = "\t";
                }
                fprintf(fi, "\n");
                if  (q != dir->ent) free(q);
                q = NULL;
        }   }
        if  (~exenv->options->flags & PGOBLIN_COPEND_NOGEN) fprintf(fi, "\\.\n");
    }
out:
    if  (fi && fclose(fi) < 0) {
        ifBLIN_QW0("fclose #1 on %d", rn[PGO_COUT]);
        ex = EX_OSERR;
    }
    ifBLIN_QX3("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
