/*-
 * Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: cmd_copy.c,v 1.51 2018/11/14 18:47:08 babolo Exp $"

#define BLIN_COMPAT      3
#define Bpars_COMPAT     3
#define MIFE_COMPAT      4
#define PGOBLIN_COMPAT   2
#define PGOBLIN_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"

enum fich {fn, fs, fp, fo, fx};
enum finde {finde_beg, finde_eol, finde_bsl, finde_dot, finde_end}; /* "\n\\.\n" */
/* static const char *fichn[] = {"fn", "fs", "fp", "fo", "fx"};
 * static const char *finden[] = {"finde_beg", "finde_eol", "finde_bsl", "finde_dot", "finde_end"};
 */

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_copyout(pgoblin_exenv *exenv, pgoblin_nr *rn) {             /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_conn *conn;
    pgoblin_mode *res;
    pgoblin_io *ctl;
    pgoblin_io *out;
    ssize_t e = 0;
    void *buf;
    int f;

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+copyout %c%c.%c.."
              , pgoblin_regn[rn[PGO_COUT]]
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    conn = &(exenv->options->conn[rn[PGO_CCON]]);
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    out = &(exenv->options->io[rn[PGO_COUT]]);
    if  (!e && !ctl->text) {
        ifBLIN_QX0("pgoblin_copyout: No query");
        e = -1;
        goto out;
    }
    if  (!e) {
        MARK_R_CONN_NGO(rn[PGO_CCON]);;
        ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
        ;;  conn->flags |= PGOBLIN_CR_OUT;
        MARK_R_CONN_NWENT(rn[PGO_CCON]);;
        if  ((e = pgoblin_db_query(conn, &res, ctl->text))) {
            e = -1;
            goto out;
        }
        for (; (f = pgoblin_db_getcopy(conn, &buf)) > 0 && e >= 0;) {
            ifBLIN_QX2("%d buf=%s", f, (char*)buf);
            if  (strcmp("\\.", buf) == 0) {
                if  (exenv->options->flags & PGOBLIN_COPEND_PASS)
                    e = out->wri(out->onu, buf, f);
                pgoblin_db_finish(conn->flags, PGOBLIN_FrCOPY, &buf);
                break;
            }
            e = out->wri(out->onu, buf, f);
            pgoblin_db_finish(conn->flags, PGOBLIN_FrCOPY, &buf);
        }
        if  ((e < 0) || (f < 0)) {
            ifBLIN_QX0("getcopy error");
            e = f;
        }
        pgoblin_db_clear(&res);
        if  (pgoblin_db_endstream(conn)) {
            e = -1;
            goto out;
    }   }
    if  (e < 0) {
        ifBLIN_QX0("write error");
    } else if (exenv->options->flags & PGOBLIN_COPEND_APND) {
        e = out->wri(out->onu, "\\.\n", 0);
    }
    if  (e < 0) {
        ifBLIN_QX0("write end error");
    }
out:
    MARK_R_CONN_NGO(rn[PGO_CCON]);;
    ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_NWENT(rn[PGO_CCON]);;
    ifBLIN_QX3("- %"BLIN_D, e);
    return(e < 0 ? (int)e : 0);
#   undef blin_internal_flags
}

int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
pgoblin_copyin(pgoblin_exenv *exenv, pgoblin_nr *rn) {              /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    pgoblin_conn *conn;
    pgoblin_mode *res;
    pgoblin_io *ctl;
    pgoblin_io *in;
    int e = 0, ee;                                                   /*   putcopy */
    ssize_t f = 0;
    char *q, *d;
    enum finde k;
                                                   /*    "\n\\.\n"    */
    const enum fich fich[256] =
    {fn,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fn,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fp,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fs,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    };
    const u_char automa[finde_end][fx] =
    /*      fn         fs         fp         fo */
    {{ finde_eol, finde_beg, finde_beg, finde_beg} /*finde_beg*/
    ,{ finde_beg, finde_bsl, finde_beg, finde_beg} /*finde_eol*/
    ,{ finde_beg, finde_beg, finde_dot, finde_beg} /*finde_bsl*/
    ,{ finde_end, finde_beg, finde_beg, finde_beg} /*finde_dot*/
    };

#   define blin_internal_flags (exenv->options->flags & BLIN_MASK)
    ifBLIN_QX3( "+copyin .%c%c%c.."
              , pgoblin_regn[rn[PGO_CCTL]]
              , pgoblin_regn[rn[PGO_CIN]]
              , pgoblin_regn[rn[PGO_CCON]]
              );
    conn = &(exenv->options->conn[rn[PGO_CCON]]);
    ctl = &(exenv->options->io[rn[PGO_CCTL]]);
    in = &(exenv->options->io[rn[PGO_CIN]]);
    d = NULL;                                                                  /*   COPY */
    q = ctl->text;
    if  (!e && !q) {
        ifBLIN_QX0("No query");
        e = -1;
    }
    if  (!in->mife) {
        ifBLIN_QX0("No input data");
        e = -1;
    }
    if  (!e) {
        MARK_R_CONN_NGO(rn[PGO_CCON]);;
        ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
        ;;  conn->flags |= PGOBLIN_CR_IN;
        MARK_R_CONN_NWENT(rn[PGO_CCON]);;
        if  ((e = pgoblin_db_query(conn, &res, q))) {
            e = -1;
            goto out;
        }
        ifBLIN_QX3("Copy %d columns", pgoblin_db_resinfo(PGOBLIN_Nfields, res));
        pgoblin_db_clear(&res);

        for (k = finde_eol, f = 1, e = 0; f > 0 && e == 0; in->offset += f) {
            char *ofbase;

            if  ((f = mife_ctl(in->mife, MIFE_CTLREAD, in->offset, PGOBLIN_BUFSIZE)) < 0) {
                ifBLIN_QW0("mife_ctl(MIFE_CTLREAD)");
                e = -1;
            }
            ifBLIN_QX4("mife_ctl(MIFE_CTLREAD)=%"BLIN_D",", BLIN_I(f));
            ofbase = mife_point(in->mife, MIFE_POINOFF, in->offset);
            if  (!e) {
                for (q = ofbase; q < (ofbase + f) && k != finde_end; k = automa[k][fich[(u_char)*q++]])
                    ifBLIN_QX4("%c", *q);
                if  (q - ofbase) {
                    e = pgoblin_db_putcopy(conn, ofbase, q - ofbase) < 1;
                    ifBLIN_QX3("putcopy=%d %d (%"BLIN_D")", e, k, BLIN_I(q - ofbase));
                } else {
                    ifBLIN_QX3("no putcopy %d (%"BLIN_D")", k, BLIN_I(q - ofbase));
        }   }   }
        if  (!e && k != finde_end) {                       /*  ()    */
            const char *enstin = "\n\\.\n";
            ifBLIN_QX2("end=%s~%d", &enstin[k], finde_end - k);
            e = pgoblin_db_putcopy(conn, &enstin[k], finde_end - k) < 1;
            ifBLIN_QX3("putcopy=%d %d (%d)", e, k, finde_end - k);
        }
        if  (e) {                                               /*       */
            ifBLIN_QX0("putcopy failed");
            e = -1;
        }
        ee = pgoblin_db_endstream(conn);
        if  (!e && (ee < 0)) {                                  /*       */
            e = -1;
            ifBLIN_QX0("endcopy failed");
    }   }
out:
    MARK_R_CONN_NGO(rn[PGO_CCON]);;
    ;;  conn->flags &= ~PGOBLIN_ACR_MASK;
    MARK_R_CONN_NWENT(rn[PGO_CCON]);;
    ifBLIN_QX3("- %d", e);
    return(e);
#   undef blin_internal_flags
}
