#!/bin/sh
# Copyright (C)2004..2011 @BABOLO http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: regres4.m4,v 1.29 2011/12/10 04:51:09 babolo Exp $
define(DBMS,sqlite2)dnl
changecom(--)dnl

TF=`mktemp -t pgoblin` || exit 1
TP=`mktemp -t pgoblin` || exit 1
TR=`mktemp -t pgoblin` || exit 1
TI=`mktemp -t pgoblin` || exit 1
TD=`mktemp -t pgoblin` || exit 1
prog="`pwd`/pgoblin -r -BDBMS -d${TD} ${1}"
${prog} -qD 'DROP TABLE pgoblin_test_table' || true
e=0

define(EOFBEGIN,"EOF")define(EOFEND,EOF)dnl

echo '= 0 ==='
EXFILE(dnl
#perform
CREATE TABLE pgoblin_test_table
     ( t text
     , i int
     ))

COPYIN(,dnl
#copyin
COPY pgoblin_test_table FROM stdin,dnl
test	0
test	1)

COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	2
')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	3
\.')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	4
\.
')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	5')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	6
')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	7
\')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	8
\.')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	9
\.
')

echo '= 1 ==='
define(CONst1,dnl
|test|0|
|test|1|
|test|2|
|test|3|
|test|4|
|test|5|
|test|6|
|test|7|
|test|8|
|test|9|)dnl

SELECTEST(s,"SELECT '|', t, '|', i, '|
' FROM pgoblin_test_table",CONst1)

SELECTEST(,#select
SELECT '|', t, '|', i, '|
' FROM pgoblin_test_table,CONst1)

SELECTEST(,#strselect
SELECT '|', t, '|', i, '|
' FROM pgoblin_test_table,CONst1)

echo '= 2 ==='
define(CONst1,dnl
test	0
test	1
test	2
test	3
test	4
test	5
test	6
test	7
test	8
test	9)dnl

SELECTEST(c,'COPY pgoblin_test_table TO stdout',CONst1)

SELECTEST(,#copyout
COPY pgoblin_test_table TO stdout,CONst1)


echo '= 3 ==='
inTEXT(tset	10)
SELECTEST(,#copyin 
COPY pgoblin_test_table FROM stdin
#strselect
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
#select
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
#copyout
COPY pgoblin_test_table TO stdout
#perform
DELETE FROM pgoblin_test_table WHERE i = 10

,test 00
test 11
test 24
test 39
test 416
test 525
test 636
test 749
test 864
test 981
tset 10100
test 00
test 11
test 24
test 39
test 416
test 525
test 636
test 749
test 864
test 981
tset 10100
test	0
test	1
test	2
test	3
test	4
test	5
test	6
test	7
test	8
test	9
tset	10)

SELECTEST(,#begin
#strselect
SELECT t, ' ', i, ' ', i * i, '
' FROM pgoblin_test_table
#end
#select
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
,test 0 0
test 1 1
test 2 4
test 3 9
test 4 16
test 5 25
test 6 36
test 7 49
test 8 64
test 9 81
test 00
test 11
test 24
test 39
test 416
test 525
test 636
test 749
test 864
test 981)

inTEXT(test	0
test	1
tnet	\N)
SELECTEST(=,#perform
DELETE FROM pgoblin_test_table;
#copyin 
COPY pgoblin_test_table FROM stdin
#strselect
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
ORDER BY t, i
#copyout
COPY pgoblin_test_table TO stdout
,test 00
test 11
tnet 
test	0
test	1
tnet	\N)

SELECTEST(D,'DROP TABLE pgoblin_test_table')

SELECTEST(,#perform
,)

SELECTEST(,#select
,)

echo '= 4 ==='
define(CONst1,a
#b
ctest)dnl

SELECTEST(,

##

#

#echo 0 wdfgWEHG #  
a
##b
c
#echo
test
,CONst1)

SELECTEST(,#echo 0 wdfgWEHG #  
a
##b
c
#echo
test
,CONst1)

SELECTEST(,#echo
a
##b
c
#echo 0 wdfgWEHG #  
test
,CONst1)

SELECTEST(,#echo
##b
c
#echo
test
,#b
ctest)

SELECTEST(,#echo
a
##b
c
#echo
test
#echo 2
##echo
a
###b
c
##echo
test


#eval 02
,CONst1CONst1)

SELECTEST(,#echo
a
##b
c
#echo
test
#eval
##echo
a
###b
c
##echo
test

,CONst1CONst1)

SELECTEST(,#echo
a
##b
c
#echo
test
#echo 2
##echo
a
###b
c
##echo
test
##echo 3
###echo
a
####b
c
###echo
test


##eval 03

#eval 02
,CONst1CONst1CONst1)

SELECTEST(,#echo
a
##b
c
#echo
test
#eval
##echo
a
###b
c
##echo
test
##eval
###echo
a
####b
c
###echo
test


,CONst1CONst1CONst1)

SELECTEST(,#echo
a
##b
c
#echo
test
#eval

##echo
a
###b
c
##echo
test
##eval

###echo
a
####b
c
###echo
test


,CONst1CONst1CONst1)

SELECTEST(,#perform
CREATE TEMP TABLE t(t text);
INSERT INTO t VALUES('1');
#select
SELECT t, '
'FROM t ORDER BY t;
#echo 2
##perform
INSERT INTO t VALUES('2');
##select
SELECT t, '
'FROM t ORDER BY t;
##echo 3
###perform
INSERT INTO t VALUES('3');
###select
SELECT t, '
'FROM t ORDER BY t;

##eval 03

#eval 02
,1
1
2
1
2
3)

SELECTEST(,#perform
CREATE TEMP TABLE t(t text);
INSERT INTO t VALUES('1');
#select
SELECT t, '
'FROM t ORDER BY t;
#eval
##perform
INSERT INTO t VALUES('2');
##select
SELECT t, '
'FROM t ORDER BY t;
##eval
###perform
INSERT INTO t VALUES('3');
###select
SELECT t, '
'FROM t ORDER BY t;


,1
1
2
1
2
3)

SELECTEST(,#perform
CREATE TEMP TABLE t(t text);
INSERT INTO t VALUES('1');
#select
SELECT t, '
'FROM t ORDER BY t;
#eval
##perform
INSERT INTO t VALUES('2');
##select
SELECT t, '
'FROM t ORDER BY t;
##eval
###perform
INSERT INTO t VALUES('3');
###select
SELECT t, '
'FROM t ORDER BY t;
,1
1
2
1
2
3)

echo '= 5 ==='
define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text)
#getpost 1
#copyin
COPY p FROM stdin
#copyout
COPY p TO stdout)dnl

inCONS('')
SELECTEST(,CONst1,0	\N	)

inCONS('nf95')
SELECTEST(,CONst1,0	\N	nf95)

inCONS('nfh95=')
SELECTEST(,CONst1,0	nfh95	)

inCONS('nfh95=lk')
SELECTEST(,CONst1,0	nfh95	lk)

inCONS('nfh95=lkjb&')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	)

inCONS('nfh95=lkjb&gjnh')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	gjnh)

inCONS('nfh95=lkjb&kn=')
SELECTEST(,CONst1,0	nfh95	lkjb
1	kn	)

inTEXT(nfh9=kjb&knr=r&idfj=ns)
SELECTEST(,CONst1,0	nfh9	kjb
1	knr	r
2	idfj	ns)

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text)
#getpost 1
#copyin
COPY "p" FROM stdin
#copyout
COPY "p" TO stdout)dnl

inTEXT(nfh9=kjb&knr=r&idfj=ns)
SELECTEST(,CONst1,0	nfh9	kjb
1	knr	r
2	idfj	ns)

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text)
#getpost 1
#copyin
COPY 'p' FROM stdin
#copyout
COPY 'p' TO stdout)dnl

inTEXT(nfh9=kjb&knr=r&idfj=ns)
SELECTEST(,CONst1,0	nfh9	kjb
1	knr	r
2	idfj	ns)

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text)
#getpost 2
#copyin 002
COPY p FROM stdin
#copyout
COPY p TO stdout)dnl

inCONS('')
SELECTEST(,CONst1,0	\N	)

inCONS('nf95')
SELECTEST(,CONst1,0	\N	nf95)

inCONS('nfh95=')
SELECTEST(,CONst1,0	nfh95	)

inCONS('nfh95=lk')
SELECTEST(,CONst1,0	nfh95	lk)

inCONS('nfh95=lkjb&')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	)

inCONS('nfh95=lkjb&gjnh')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	gjnh)

inCONS('nfh95=lkjb&kn=')
SELECTEST(,CONst1,0	nfh95	lkjb
1	kn	)

inTEXT(nfh9=kjb&knr=r&idfj=ns)
SELECTEST(,CONst1,0	nfh9	kjb
1	knr	r
2	idfj	ns)

echo '= 6 ==='
define(CONst1,#perform
CREATE TEMP TABLE a(n int, e text, c text)
#getget 1
#copyin
COPY a FROM stdin
#copyout
COPY a TO stdout)dnl

unset QUERY_STRING || true
SELECTEST(,CONst1)

export QUERY_STRING=''
SELECTEST(,CONst1,0	\N	)

export QUERY_STRING='kjn=er&kjb'
SELECTEST(,CONst1,0	kjn	er
1	\N	kjb)

define(CONst1,#perform
CREATE TEMP TABLE a(n int, e text, c text)
#getget 2
#copyin 002
COPY a FROM stdin
#copyout
COPY a TO stdout)dnl

unset QUERY_STRING || true
SELECTEST(,CONst1)

export QUERY_STRING=''
SELECTEST(,CONst1,0	\N	)

export QUERY_STRING='kjn=er&kjb'
SELECTEST(,CONst1,0	kjn	er
1	\N	kjb)

echo '= 7 ==='
define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text);
CREATE TEMP TABLE a(n int, c text);
CREATE TEMP TABLE e(n int, e text, c text);
CREATE TEMP TABLE g(n int, e text, c text)
#getpost 1
#copyin
COPY p FROM stdin
#getarg 1
#copyin
COPY a FROM stdin
#getenv 1
#copyin
COPY e FROM stdin
#getget 1
#copyin
COPY g FROM stdin
#echo
  :

#select
SELECT COALESCE(e, '?') || ' = ' || COALESCE(c, '?') || '
' FROM e
 WHERE e IN('TEST_STRING1', 'TEST_STRING2', 'QUERY_STRING')
ORDER BY e
#select
SELECT COALESCE(n, '?') || '=' || COALESCE(c, '?') || '
' FROM a
#select
SELECT COALESCE(n, '?') || ': ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM g
#select
SELECT COALESCE(n, '?') || '! ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM p
#perform
DROP TABLE p;
DROP TABLE a;
DROP TABLE e;
DROP TABLE g;)dnl

export TEST_STRING1='lefn'
export TEST_STRING2='8r7wv'
inTEXT(bnu)
SELECTEST(=,CONst1,dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
EOF
cat << EOF >> ${TP}
0=${TF}
EOF
cat << "EOF" >> ${TP}
0: kjn=er
1: ?=kjb
0! ?=bnu)

inTEXT(bnu)
SELECTEST(f,${TF},dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
0: kjn=er
1: ?=kjb
0! ?=bnu)

define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text);
CREATE TEMP TABLE a(n int, c text);
CREATE TEMP TABLE e(n int, e text, c text);
CREATE TEMP TABLE g(n int, e text, c text)
#getpost 2
#copyin 002
COPY p FROM stdin
#getarg 2
#copyin 002
COPY a FROM stdin
#getenv 2
#copyin 002
COPY e FROM stdin
#getget 2
#copyin 002
COPY g FROM stdin
#echo
  :

#select
SELECT COALESCE(e, '?') || ' = ' || COALESCE(c, '?') || '
' FROM e
 WHERE e IN('TEST_STRING1', 'TEST_STRING2', 'QUERY_STRING')
ORDER BY e
#select
SELECT COALESCE(n, '?') || '=' || COALESCE(c, '?') || '
' FROM a
#select
SELECT COALESCE(n, '?') || ': ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM g
#select
SELECT COALESCE(n, '?') || '! ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM p
#perform
DROP TABLE p;
DROP TABLE a;
DROP TABLE e;
DROP TABLE g;)dnl

export TEST_STRING1='lefn'
export TEST_STRING2='8r7wv'
inTEXT(bnu)
SELECTEST(=,CONst1,dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
EOF
cat << EOF >> ${TP}
0=${TF}
EOF
cat << "EOF" >> ${TP}
0: kjn=er
1: ?=kjb
0! ?=bnu)

inTEXT(bnu)
SELECTEST(f,${TF},dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
0: kjn=er
1: ?=kjb
0! ?=bnu)

echo '= 8 ==='
define(CONst1,dnl
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.)

SELECTEST(,#cat
tools/LICENSE,CONst1)

SELECTEST(,#cat
tools/LICENSE
#echo
=== Test Done ===

,CONst1
=== Test Done ===
)

SELECTEST(,#echo 3
lala
#clear 3
#echo 03
#,)

SELECTEST(,#echo 3
##echo 4
lala

##echo 04
#eval 03,lala)

SELECTEST(,#echo 3
##echo 4
lala

##echo 04 -
#eval 03,lala)

export QUERY_STRING='p=13'
SELECTEST(,#echo 3
##getget
#eval 03,0	p	13
\.)

SELECTEST(,#echo 3
##getget 
#eval 03,0	p	13
\.)

echo '= 9 ==='
define(DOinPIPE,cat /dev/null |)dnl
SELECTEST(,#perform
CREATE TEMP TABLE t(i int);
#copyin
COPY t FROM stdin
#strselect
SELECT * FROM t
)

define(DOinPIPE,cat /dev/null |)dnl
SELECTEST(C,'CREATE TEMP TABLE p(i int);COPY p FROM stdin')

SELECTEST(=,#echo 2
\t.\\\001\\\\
\.

#perform
CREATE TEMP TABLE t(t text);
#copyin 002
COPY t FROM stdin;
#select
SELECT t, '
'FROM t
;
,	.\\\)

echo '= 10 ==='
define(CONst1,dnl
$$:[0]=/bin/sh~
$$:[1]=${0}~)

SELECTEST(,#getproc 1
#begin
#perform
CREATE TEMP TABLE t(p int, i int, t text);
#copyin
COPY t FROM stdin
#end
#strselect
SELECT p, ':[', i, ']=', t ,'~
'FROM t WHERE p = $$ ORDER BY i,CONst1,EOF)

echo '= 11 ==='
prog="`pwd`/pgoblin -r -qBDBMS -d${TD} ${1}"
inTEXT(dnl

	
\\
erty)

SELECTEST(,#getstr 2
#perform
CREATE TEMP TABLE t(i int, t text);
#echo 3
111	 
112	?
#copyin 003
COPY t FROM stdin
#trap
#select
SELECT '[', i, ']=', t, '~
'FROM t ORDER BY i DESC
#return
#copyin 002
COPY t FROM stdin
#select
SELECT '[', i, ']=', t, '~
'FROM t ORDER BY i
#select
SELECT * FROM never_never_nether_not_for_anything_nowhere_non_existing_nor_imaginable
#echo
Done
,dnl
[0]=~
[1]=	~
[2]=\~
[3]=erty~
[111]= ~
[112]=?~
[112]=?~
[111]= ~
[3]=erty~
[2]=\~
[1]=	~
[0]=~
Done)

SELECTEST(,dnl
#trap
#echo
Done

#exit
#perform
CREATE TEMP TABLE t(i int, t text);
#echo 3
111	 
112	?
#copyin 003
COPY t FROM stdin
#select
SELECT '[', i, ']=', t, '~
'FROM t ORDER BY i DESC
#select
SELECT * FROM never_never_nether_not_for_anything_nowhere_non_existing_nor_imaginable
#select
SELECT '[', i, ']=', t, '~
'FROM t ORDER BY i
,dnl
[112]=?~
[111]= ~
Done)

echo '= 12 ==='
prog="`pwd`/pgoblin -r -BDBMS -d${TD} ${1}"


SELECTEST(,dnl
#fork
#echo
TEST IN FORK

#exit
#exec
/bin/sleep
#
1
#wait
#echo
TEST OUT FORK
,dnl
TEST IN FORK
TEST OUT FORK)


SELECTEST(,dnl
#fork 4
#echo 4
TEST IN FORK

#exit
#echo 04
,dnl
TEST IN FORK)

SELECTEST(,dnl
#fork 404
#getstr 504
#perform 0001
CREATE TEMP TABLE t(i int, t text);
#copyin 0051
COPY t FROM stdin;
#strselect 4001
SELECT '[' || i || ']=' || t || '~
'FROM t
#exit
#echo 4
TEST IN FORK

#close 4
#echo 04,dnl
[0]=TEST IN FORK~)

SELECTEST(,dnl
#fork 404
#echo 44
#exit
#echo 4
TEST IN FORK

#close 4
#echo 04,dnl
TEST IN FORK)

SELECTEST(,dnl
#echo 4
/usr/bin/uname
#exec 04
#wait,dnl
FreeBSD)

echo '= 13 ==='

define(CONst1,dnl
#echo 2
0
1
2
3
4
#perform
CREATE TEMP TABLE t(c int);
#copyin 002
COPY t FROM stdin;
#select 2
SELECT '/bin/sh','-c','sleep 2; echo $$' FROM t;
#exec 42002
#exec
/bin/sleep
#
0.2
#wait
#getproc 2
#begin
#perform
CREATE TEMP TABLE c(c int, i int, a text);
#copyin 002
COPY c FROM stdin;
#end
#getjob 20002
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin 002
COPY j FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
#getstr 204
#begin
#perform
CREATE TEMP TABLE f(i int, c int);
#copyin 002
COPY f FROM stdin;
#end
#select
SELECT 'j-f ', c, '
'FROM (SELECT c FROM j EXCEPT SELECT c FROM f)c;
#select
SELECT 'f-j ', c, '
'FROM (SELECT c FROM f EXCEPT SELECT c FROM j)c;
#select
SELECT j.i, ':[', c.i, ']=', a, '~
'FROM c JOIN j USING(c) ORDER BY j.i, c.i;
#wait 00002
#getjob 20002
#begin
#perform
DELETE FROM j;
#copyin 002
COPY j FROM stdin;
#end
#select
SELECT i, '[', n, ']=', s, '
'FROM j;
)

define(CONst2,dnl
0[4]=-1
1[4]=-1
2[4]=-1
3[4]=-1
4[4]=-1
0:[0]=/bin/sh~
0:[1]=-c~
0:[2]=sleep 2; echo $$~
1:[0]=/bin/sh~
1:[1]=-c~
1:[2]=sleep 2; echo $$~
2:[0]=/bin/sh~
2:[1]=-c~
2:[2]=sleep 2; echo $$~
3:[0]=/bin/sh~
3:[1]=-c~
3:[2]=sleep 2; echo $$~
4:[0]=/bin/sh~
4:[1]=-c~
4:[2]=sleep 2; echo $$~
0[4]=0
1[4]=0
2[4]=0
3[4]=0
4[4]=0)

SELECTEST(=,CONst1,CONst2)
SELECTEST(f,${TF},CONst2)

SELECTEST(,dnl
#exec 40002
/bin/sh
#
-c
#
echo There
#exec 50002
/bin/sh
#
-c
#
echo Then
#exec 60002
/bin/mkdir
#
/dev/null/newerNewerNEWERexistingdirectory/newerestabsolytelyNONexisting
#wait 00002
#getjob 20002
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin 002
COPY j FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
#getstr 204
#perform
CREATE TEMP TABLE t(i int, t text);
#copyin 002
COPY t FROM stdin;
#getstr 205
#copyin 002
COPY t FROM stdin;
#select 5
SELECT '=', t, '~
'FROM t ORDER BY t;
#wait
#getjob 2
#perform
CREATE TEMP TABLE g(i int, n int, c int, s int);
#copyin 002
COPY g FROM stdin;
#select
SELECT i, '[', n, ']=', s, '
'FROM g ORDER BY i;
#display 005
,dnl
0[0]=0
1[3]=0
2[6]=256
0[-1]=-1
1[-1]=-1
2[9]=0
3[13]=0
4[16]=0
=Then~
=There~)


echo '= 14 ==='

cat << "EOF" >> ${TI}
#id1 pgo0
# -H15
-H15-
# -H0
-H0-

# +H0
--------

# +H1
-h1-
# +H2
-h2-
# +H
-h-
# +V
-v-
# +V0
-v0-
# -V0
-V0-

# +U1
-u1-
# +U12
-u12-
# -U0
-U0-
# +D
-d-
# +D1
-d1-
# -D3
-D3-
# +V0
-W0-
# +L
-l-
# +L1
-l1-
# -L1
-L1-
# -R
-r-
# +R0
-r0-
# -R1
-R1-
# -R0
-R0-
#id2 pgo0
# -H15
=H15-
# -H0
=H0-

# +H0
--------

# +H1
=h1-
# +H2
=h2-
# +H
=h-
# +V
=v-
# +V0
=v0-
# -V0
=V0-

# +U1
=u1-
# +U12
=u12-
# -U0
=U0-
# +D
=d-
# +D1
=d1-
# -D3
=D3-
# +V0
=W0-
# +L
=l-
# +L1
=l1-
# -L1
=L1-
# -R
=r-
# +R0
=r0-
# -R1
=R1-
# -R0
=R0-
#id3 pgo0
# -H15
=H15=
# -H0
=H0=

# +H0
--------

# +H1
=h1=
# +H2
=h2=
# +H
=h=
# +V
=v=
# +V0
=v0=
# -V0
=V0=

# +U1
=u1=
# +U12
=u12=
# -U0
=U0=
# +D
=d=
# +D1
=d1=
# -D3
=D3=
# +V0
=W0=
# +L
=l=
# +L1
=l1=
# -L1
=L1=
# -R
=r=
# +R0
=r0=
# -R1
=R1=
# -R0
=R0=
#id4 pgo0
# +H
# +D
#
#id5 pgo0 UD
#id6 pgo0 U
#id7 pgo0 D
#
EOF

define(DO2x,dnl
#perform
CREATE TEMP TABLE i(i int4);
INSERT INTO i VALUES(0);
INSERT INTO i SELECT i + 1 FROM i;dnl
)

define(CONst1,DO2x
INSERT INTO i SELECT i + 2 FROM i;
#select 2
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003002
id2
#close 3
#file 3
${TI}
#style 003003
id3)

SELECTEST(,CONst1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-d--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-d--H15--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-0-r0--v--l1-2-R0--V0-
-d--h--W0--L1-0-r0--v--l1-3-R0--V0-
-d--h--W0--L1-1-r0--v--l1-0-R0--V0-
-d--h--W0--L1-1-r0--v--l1-1-R0--V0-
-d--h--W0--L1-1-r0--v--l1-2-R0--V0-
-d--h--W0--L1-1-r0--v--l1-3-R0--V0-
-d--h--W0--L1-2-r0--v--l1-0-R0--V0-
-d--h--W0--L1-2-r0--v--l1-1-R0--V0-
-d--h--W0--L1-2-r0--v--l1-2-R0--V0-
-d--h--W0--L1-2-r0--v--l1-3-R0--V0-
-d--h--u12--W0--L1-3-r0--v--l1-0-R0--V0-
-D3--h--W0--L1-3-r0--v--l1-1-R0--V0-
-d--h--W0--L1-3-r0--v--l1-2-R0--V0-
-d--h--U0--W0--L1-3-r0--v--l1-3-R0--V0-
-d--H0-,EOF)

SELECTEST(,CONst1
#display 002002,dnl
--------
=W0-=L1-0=r0-=v-=l1-0=R0-=V0-
=d-=H15-=u1-=W0-=L1-0=r0-=v-=l1-1=R0-=V0-
=d1-=h2-=W0-=L1-0=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-0=r0-=v-=l1-3=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-1=r0-=v-=l1-3=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-0=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-2=R0-=V0-
=d-=h-=W0-=L1-2=r0-=v-=l1-3=R0-=V0-
=d-=h-=u12-=W0-=L1-3=r0-=v-=l1-0=R0-=V0-
=D3-=h-=W0-=L1-3=r0-=v-=l1-1=R0-=V0-
=d-=h-=W0-=L1-3=r0-=v-=l1-2=R0-=V0-
=d-=h-=U0-=W0-=L1-3=r0-=v-=l1-3=R0-=V0-
=d-=H0-,EOF)

SELECTEST(,CONst1
#display 002003,dnl
--------
=W0==L1=0=r0==v==l1=0=R0==V0=
=d==H15==u1==W0==L1=0=r0==v==l1=1=R0==V0=
=d1==h2==W0==L1=0=r0==v==l1=2=R0==V0=
=d==h==W0==L1=0=r0==v==l1=3=R0==V0=
=d==h==W0==L1=1=r0==v==l1=0=R0==V0=
=d==h==W0==L1=1=r0==v==l1=1=R0==V0=
=d==h==W0==L1=1=r0==v==l1=2=R0==V0=
=d==h==W0==L1=1=r0==v==l1=3=R0==V0=
=d==h==W0==L1=2=r0==v==l1=0=R0==V0=
=d==h==W0==L1=2=r0==v==l1=1=R0==V0=
=d==h==W0==L1=2=r0==v==l1=2=R0==V0=
=d==h==W0==L1=2=r0==v==l1=3=R0==V0=
=d==h==u12==W0==L1=3=r0==v==l1=0=R0==V0=
=D3==h==W0==L1=3=r0==v==l1=1=R0==V0=
=d==h==W0==L1=3=r0==v==l1=2=R0==V0=
=d==h==U0==W0==L1=3=r0==v==l1=3=R0==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#echo 5
FreeBSD
#display 005003,--------
=U0==W0==l=FreeBSD=r0==V0=
=d==H0=,EOF)

SELECTEST(,CONst1
#file 5
tools/LICENSE
#display 005003,--------
=U0==W0==l=Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS \`\`AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
=r0==V0=
=d==H0=,EOF)

define(CONst1,DO2x
#select 2
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4)

SELECTEST(,CONst1
#display 002001,dnl
--------
-W0--L1-0-r0--v--l1-0-R0--V0-
-D3--h1--u1--W0--L1-0-r0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--l1-0-R0--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)

SELECTEST(,CONst1
#select 2
SELECT NULLIF(j.i, 0), NULLIF(k.i, 0) FROM i j, i k ORDER BY j.i, k.i;
#display 002001,dnl
--------
-W0--v--V0-
-D3--h1--u1--W0--v--l1-1-R0--V0-
-d1--h2--W0--L1-1-r0--v--V0-
-U0--W0--L1-1-r0--v--l1-1-R0--V0-
-H0-,EOF)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,,EOF)

define(CONst1,DO2x
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4
#close 3
#file 3
${TI}
#style 003001
id5)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,dnl
--------
-H0-,EOF)

define(CONst1,DO2x
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4
#close 3
#file 3
${TI}
#style 003001
id6)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,dnl
--------,EOF)

define(CONst1,DO2x
#file 3
${TI}
#style 003001
id1
#close 3
#file 3
${TI}
#style 003001
id4
#close 3
#file 3
${TI}
#style 003001
id7)

SELECTEST(,CONst1
#select 2
SELECT i FROM i WHERE i > 1000;
#display 002001,dnl
-H0-,EOF)

echo '= 15 ==='

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H0
## +H 
-
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
-00-01-10-11-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H 
-
#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
-00-01-10-11-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H0
## +H

##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H

#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H
#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H
## +H0

##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0

#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H0
## +H 

##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H 

#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H 
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H0
## +H 
#
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## +H
## +H0 

##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
------
00-h-01-h-10-h-11-H0-
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0 

#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0 
##
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -H0
-H0-

## +H0
------

## +H
-h-
#style 003001
id1
#echo 3
##id1 pgo0
## +H
## +H0 
#style 003001
id1
#strselect 000001
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
,dnl
00011011-H0-dnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## -V0
|
## +D
--

## -H0
O


#style 003001
id1
#strselect 000001
SELECT NULL, NULL FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## -V0


#style 003001
id1
#strselect 000001
SELECT NULL, NULL FROM i j, i k ORDER BY j.i, k.i;
#echo 3
##id1 pgo0
## -V0
#style 003001
id1
#strselect 000001
SELECT NULL, NULL FROM i j, i k ORDER BY j.i, k.i;
,dnl
|--
|--
|--
|--
O
--
--
--
--
O
Odnl
)

SELECTEST(,DO2x
#echo 3
##id1 pgo0
## +L0
## +L1
## +L2
## +L
## +U0
## +U1
## +U2
## +U
>
## +R0
## +R1
## +R2
## +R
## +D0
## +D1
## +D2
## +D
<
## -H0



#style 003001
id1
#select 4
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#display 004001
,dnl
>>0<>0<<>>0<>1<<>>1<>0<<>>1<>1<<dnl
)

SELECTEST(,DO2x
#echo 3
##id pgo0
## +L
## +U
>
## +R
## +D
<
## -H0


##id1 pgo0
## +L
## +U
}
## +R
## +D
{
## -H0



#style 003001
id1
#select 4
SELECT j.i, k.i FROM i j, i k ORDER BY j.i, k.i;
#display 004001
,dnl
}}0{}0{{}}0{}1{{}}1{}0{{}}1{}1{{dnl
)


echo '= 16 ==='

define(CONst1,#id1 pgo0
# buratino


# testfile
${TI}
#)

cat << EOF > ${TI}
CONst1
EOF

SELECTEST(,#file 3
${TI}
#style 003001
id1
#echo 000001
buratino
#file 000001
testfile
#cat 000001
testfile,dnl

CONst1
CONst1,EOF)

SELECTEST(,#
#echo
OK
,OK)

SELECTEST(,# $
#echo
OK
,OK)

SELECTEST(,#--
#echo
OK
,OK)

SELECTEST(, #
#echo
OK
,OK)

SELECTEST(, # $
#echo
OK
,OK)

SELECTEST(, #--
#echo
OK
,OK)

define(CONst1,#id1 pgo0
# bu


# te
${TI}

#)

cat << EOF > ${TI}
CONst1
EOF

SELECTEST(,#file 3
${TI}
#style 003001
id1
#select 2
SELECT 'bu';
#echo 020001
#select 2
SELECT 'te';
#echo 020001
,
${TI},EOF)

echo '= 17 ==='

rm -rf ${TI}
mkdir ${TI}
mkdir ${TI}/b
(cd ${TI}/b;ln -s . a; ln -s /dev/null/newerNewerNEWERexistingdirectory)

SELECTEST(,#perform
CREATE TEMP TABLE d(i int4, t text, s int4, y int8)
#getdir 2
0x0F ${TI}/b
#copyin 002
COPY d FROM stdin
#perform
UPDATE d SET s = s - (SELECT s FROM d WHERE t = '.')
 WHERE t = 'a'
   AND y = 16877
;
CREATE TEMP TABLE t(tt text, ts int4);
INSERT INTO t SELECT t, s FROM d WHERE t IN('.', '..');
UPDATE d SET s = s - (SELECT ts FROM t WHERE tt = '.') WHERE t = '..';
UPDATE d SET s = s - (SELECT ts FROM t WHERE tt = '..') WHERE t = '.';
#select
SELECT i, '	', t, '	', s, '	', y, '
'FROM d
ORDER BY i, y DESC
,0	.	0	16877
1	..	0	16877
2	a	1	41453
2	a	0	16877
3	newerNewerNEWERexistingdirectory	42	41453dnl
,EOF)

SELECTEST(,#perform
CREATE TEMP TABLE d(i int4, t text, s int4, y int8)
#select D
SELECT * FROM (SELECT '${TI}/b' UNION ALL SELECT '${TI}/b')u
#getdir 20D
0x0F
#copyin 002
COPY d FROM stdin
#perform
UPDATE d SET s = s - (SELECT s FROM d WHERE t = '.' LIMIT 1)
 WHERE t = 'a'
   AND y = 16877
;
CREATE TEMP TABLE t(tt text, ts int4);
INSERT INTO t SELECT DISTINCT t, s FROM d WHERE t IN('.', '..');
UPDATE d SET s = s - (SELECT ts FROM t WHERE tt = '.') WHERE t = '..';
UPDATE d SET s = s - (SELECT ts FROM t WHERE tt = '..') WHERE t = '.';
#select
SELECT i, '	', t, '	', s, '	', y, '
'FROM d
ORDER BY i, y DESC
,0	.	0	16877
0	.	0	16877
1	..	0	16877
1	..	0	16877
2	a	1	41453
2	a	1	41453
2	a	0	16877
2	a	0	16877
3	newerNewerNEWERexistingdirectory	42	41453
3	newerNewerNEWERexistingdirectory	42	41453dnl
,EOF)

rm -rf ${TI}

SELECTEST(,#getdir
0x0F /dev/null/newerNewerNEWERexistingdirectory
#,0	newerNewerNEWERexistingdirectory	\N	\N
\.)

echo '= 18 ==='

SELECTEST(=,#perform
CREATE TEMP TABLE t(i integer);
INSERT INTO t VALUES(0);
INSERT INTO t SELECT i + 1 FROM t;
INSERT INTO t SELECT i + 2 FROM t;
INSERT INTO t VALUES(4);
INSERT INTO t SELECT i + 5 FROM t;
INSERT INTO t SELECT i + 10 FROM t;
INSERT INTO t VALUES(20);
#exec 3
/bin/date
#
+%s
#select 2
SELECT '/bin/sh', '-c', 'sleep 1' FROM t
#job 00002
local 5
#exec 02002
#wait 00002
#exec 4
/bin/date
#
+%s
#perform
CREATE TEMP TABLE t1(t1 integer);
CREATE TEMP TABLE t2(t2 integer);
#copyin 003
COPY t1 FROM stdin
#copyin 004 
COPY t2 FROM stdin
#select
SELECT CASE WHEN (t2 - t1) < 5 THEN 'FAIL' ELSE 'OK' END, '
'FROM t2, t1
,OK)

echo '= 19 ==='

SELECTEST(,#select
SELECT REGEX('aa', 'a+'), '
'
#select
SELECT REGEX('a', '^A$'), '
'
#select
SELECT REGEX('a', NULL), '
'
#select
SELECT REGEX(NULL, '^A$'), '
'
#select
SELECT REGEX(NULL, NULL), '
',1
0


)

SELECTEST(=,#select
SELECT quote_literal('regexp(\''a+", \\''aa'')'), '
'
#select
SELECT quote_ident('(''^B$'', ''a'')'), '
'
#select
SELECT quote_ident('0fu'), quote_ident('CASE'), quote_ident('case0'), '
'
#select
SELECT quote_ident('notident'), quote_ident('case'), quote_ident(' case'), '
'
#select
SELECT quote_ident_always('(''^B$'', ''a'')'), '
'
#select
SELECT quote_ident_always('0fu'), quote_ident_always('CASE'), quote_ident_always('case0'), '
'
#select
SELECT quote_ident_always('notident'), quote_ident_always('case'), quote_ident_always(' case'), '
','regexp(\''a+", \\''aa'')'
"('^B$', 'a')"
"0fu""CASE"case0
notident"case"" case"
"('^B$', 'a')"
"0fu""CASE""case0"
"notident""case"" case")

SELECTEST(=,#select
SELECT quote_html('-<''>+&">-'), '
',-&lt;'&gt;+&amp;&quot;&gt;-)

echo '= 20 ==='

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
INSERT INTO a(a, b) VALUES('foo', 'bar');
#select 2
SELECT b, a FROM a ORDER BY i;
#perform 002
INSERT INTO a(a, b) VALUES(?, ?);
#select 2
SELECT b FROM a ORDER BY a LIMIT 1;
#select 302
SELECT a, b FROM a WHERE a = ? ORDER BY i;
#perform 003
INSERT INTO a(a, b) VALUES(?, ?);
#select 2
SELECT a, a FROM a ORDER BY i;
#perform 002
INSERT INTO a(a, b) VALUES(?, ?);
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
,dnl
 | 1 | foo | bar
 | 2 | bar | foo
 | 3 | foo | bar
 | 4 | foo | foo
 | 5 | bar | bar
 | 6 | foo | foo
--)

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
#echo 2
foo
#perform 002
INSERT INTO a(a) VALUES(?);
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
,dnl
 | 1 | foo | 
--)

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
INSERT INTO a(a, b) VALUES('foo', 'bar');
#select 2
SELECT * FROM a ORDER BY i;
#echo 32
#perform 003
INSERT INTO a(a) VALUES(?);
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
#echo 32
#perform 003
INSERT INTO a(a) VALUES(?);
#select 2
SELECT a, b FROM a ORDER BY i;
#display 00200r
#perform 002
INSERT INTO a(b, a) VALUES(?, ?);
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
#select 2
SELECT 'INSERT INTO a(a, b) VALUES('
     , COALESCE(quote_literal(b), 'NULL')
     , ', '
     , COALESCE(quote_literal(a), 'NULL')
     , ');
'FROM a
;
#perform 02
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
#select 2
SELECT * FROM a ORDER BY i LIMIT 2
#select 302
SELECT * FROM a WHERE a = ? || ? || ? || ? || ? || COALESCE(?, '') ORDER BY i;
#display 00300r
,dnl
 | 1 | foo | bar
 | 2 | 1foobar | 
--
 | foo | bar
 | 1foobar | 
 | 1foobar21foobar | 
--
 | 1 | foo | bar
 | 2 | 1foobar | 
 | 3 | 1foobar21foobar | 
 | 4 | bar | foo
 | 5 |  | 1foobar
 | 6 |  | 1foobar21foobar
--
 | 1 | foo | bar
 | 2 | 1foobar | 
 | 3 | 1foobar21foobar | 
 | 4 | bar | foo
 | 5 |  | 1foobar
 | 6 |  | 1foobar21foobar
 | 7 | bar | foo
 | 8 |  | 1foobar
 | 9 |  | 1foobar21foobar
 | 10 | foo | bar
 | 11 | 1foobar | 
 | 12 | 1foobar21foobar | 
--
 | 3 | 1foobar21foobar | 
 | 12 | 1foobar21foobar | 
--)

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
INSERT INTO a(a, b) VALUES('INSERT ', 'INTO a(a, b)');
INSERT INTO a(a, b) VALUES(' VALUES', '(');
INSERT INTO a(a, b) VALUES('?', ', ?);');
#select 2
SELECT a, b FROM a ORDER BY i;
#select 3
SELECT a, b FROM a ORDER BY i;
#perform 023
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
,dnl
 | 1 | INSERT  | INTO a(a, b)
 | 2 |  VALUES | (
 | 3 | ? | , ?);
 | 4 | INSERT  | INTO a(a, b)
 | 5 |  VALUES | (
 | 6 | ? | , ?);
--)

SELECTEST(,dnl
#echo r
##a pgo0 D
## +V
 | 
## -V0


## -H0
--


#style 00r00r
a
#perform
CREATE TEMP TABLE a(i INTEGER PRIMARY KEY, a text, b text);
INSERT INTO a(a, b) VALUES('INSERT ', 'INTO a(a, b)');
INSERT INTO a(a, b) VALUES(' VALUES', '(');
INSERT INTO a(a, b) VALUES('?', ', ?);');
#select 2
SELECT a, b FROM a ORDER BY i;
#perform 022
#select 2
SELECT * FROM a ORDER BY i;
#display 00200r
,dnl
 | 1 | INSERT  | INTO a(a, b)
 | 2 |  VALUES | (
 | 3 | ? | , ?);
 | 4 | INSERT  | INTO a(a, b)
 | 5 |  VALUES | (
 | 6 | ? | , ?);
--)

SELECTEST(,dnl
#perform
CREATE TEMP TABLE t(t text);
INSERT INTO t VALUES(NULL);
#select 2
SELECT * FROM t;
#perform 002
INSERT INTO t VALUES(?);
#copyout
COPY t TO stdout;
,dnl
\N
\N)


echo '= 21 ==='

dnl ##############
dnl thTEST
dnl
define(thTEST,; then
fiTEST($1)
)dnl

export QUERY_STRING='kjn=er&kjb'

SELECTEST(,dnl
#file 2
${TR}
#getget 2
#getjob 3
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin 003
COPY j FROM stdin;
#strselect 2
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
,dnl
0	kjn	er
1	\N	kjb
\.
0[-1]=-1
1[-1]=-1,EOF)


SELECTEST(,dnl
#file 4
${TP}
#cat 4
${TR}
#echo 4
0	kjn	er
1	\N	kjb
\.
0[-1]=-1
1[-1]=-1

#cat 2
${TR}
#getget 2
#getjob 3
#perform
CREATE TEMP TABLE j(i int, n int, c int, s int);
#copyin 003
COPY j FROM stdin;
#strselect 2
SELECT i, '[', n, ']=', s, '
'FROM j ORDER BY i;
,,EOF)

echo '= 22 ==='

dnl ##############
dnl ifTEST
dnl
define(ifTEST,dnl
define(COUNTER,incr(COUNTER))dnl
# COUNTER #####################################
DOinPIPE
)dnl
dnl
dnl ##############
dnl fiTEST
dnl
define(fiTEST,dnl
if  [ "$?" -eq "RESSULT" ]; then
    echo -n "COUNTER OK	# "
else
    e=$(( ${e} + 1 ))
    echo -n "COUNTER diff	# "
fi
head -2 ${TF} | tail -1dnl
)dnl
dnl
dnl ##############
dnl thTEST
dnl
define(thTEST,
fiTEST($1)
)dnl

define(RESSULT,0)

SELECTEST(,#exit)

define(RESSULT,14)

SELECTEST(,#exit
14)

SELECTEST(,#echo 2
14
#exit 02)

define(RESSULT,1)

SELECTEST(,#exec 00002
/usr/bin/false
#wait 00002
#getjob 20002
#perform
CREATE TEMP TABLE j(i int, n int, p int, s int);
#copyin 002
COPY j FROM stdin;
#strselect 3
SELECT (s >> 8) & 255 FROM j;
#exit 03)

dnl inTEXT()
dnl SELECTEST(,,)

rm -f ${TF} ${TP} ${TR} ${TI} ${TD}
echo "${e} errors"
