/*-
 * Copyright (C)2008..2011 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2008..2011 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: style_pgo0.c,v 1.37 2013/03/02 06:23:46 babolo Exp $";
#endif /* not lint */

/*        HVUDLR:
 *     N -   NULL,    L  R
 *     F -   NULL, L  R   .
 *     S -    ,    L  R (?)
 */

#include <sys/types.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"
#include "pgob.h"

#define PGOBLIN_NTBSIZE  8               /*         */
#define PGOBLIN_STYLE_ID "#pGoblin-pgo0"

static int
pgoblin_finit(u_int32_t flags, pgoblin_styles *this) {
    return(0);
}

typedef struct pgo0_arb {
    u_char  *nm;
    ssize_t  vl;
} pgo0_arb;

static int
getind(mular_descriptor *md, u_char *nm) {
    int i;
    pgo0_arb *e;

    for (i = 0; i < MULAR_NEXT(md); i++) {
        e = mular_getix(md, i);
        if  (!strcmp((char*)e->nm, (char*)nm)) return(i);
    }
    if  (md->flags & MULAR_FIXD) return(-1);
    i = MULAR_NEXT(md);
    e = mular_add(md);
    if  (!e) {
        /* XXXX */
    }
    e->nm = nm;
    return(i);
}

#define H 0
#define U 1
#define D 2
#define V 3
#define L 4
#define R 5
#define M 6
#define ENTITY_LETTERS 27

static const u_char entity[ENTITY_LETTERS + 1] =
{ M, M, M, M,  D, M, M, M,  H, M, M, M,  L, M, M, M
, M, M, R, M,  M, U, V, M,  M, M, M, M
};

typedef struct pgo0_ent {
    ssize_t    def;
    struct {
       ssize_t f;
       ssize_t b;
    } spec[1 << PGOBLIN_NTBSIZE];
} pgo0_ent;

typedef struct pgo0_style {
    char              id[PGOBLIN_STRING_ID_LEN]; /*  "#pGoblin"              */
    u_int32_t         flags;
#   define            PGOBLIN_NTBSZMK (~(~0 << PGOBLIN_NTBSIZE)) /* 0x0000FF */
#   define            FIRST           0x000001
#   define            FORWARD (FIRST   << 1)      /* 0x000002 */
#   define            LAST            0x000004
#   define            BAKWARD (LAST    << 1)      /* 0x000008 */
#   define            HSHIFT          12
#   define            VSHIFT          16
#   define            HFIRST  (FIRST   << HSHIFT) /* 0x001000   Output +H0 when zero rows            */
#   define            HHFIRST (FORWARD << HSHIFT) /* 0x002000 */
#   define            HLAST   (LAST    << HSHIFT) /* 0x004000   Output -H0 when zero rows            */
#   define            HHLAST  (BAKWARD << HSHIFT) /* 0x008000 */
#   define            VFIRST  (FIRST   << VSHIFT) /* 0x010000   Output +V0 when zero columns         */
#   define            VVFIRST (FORWARD << VSHIFT) /* 0x020000 */
#   define            VLAST   (LAST    << VSHIFT) /* 0x040000   Output -V0 when zero columns         */
#   define            VVLAST  (BAKWARD << VSHIFT) /* 0x080000 */
#   define            ALWAYS                   0x100000
#   define            HALWAYS  ALWAYS       /* 0x100000 */
#   define            VALWAYS (ALWAYS  << 1)/* 0x200000 */
#   define            EDGE    (HFIRST | HLAST | VFIRST | VLAST)
/*
 * pgo0_style.flags
 * FIRST FORWARD
 *   0      0     @+0
 *   1      0   @+0   +0
 *   1      1   @+0  
 *
 * LAST  BAKWARD
 *   0      0     @-0
 *   1      0   @-0   -0
 *   1      1   @-0  
 */
#   define P_A (FIRST | LAST)
    mular_descriptor *str;
    mular_descriptor *arb;
    pgo0_ent          a[M];
} pgo0_style;

static const u_int32_t flagvalues[M] = {HALWAYS, HFIRST, HLAST, VALWAYS, VFIRST, VLAST};
static const char *clasnames[] = {"L0", "Ll", "Lb", "Ln", "Lz", "Ls", "Lu", "Ld", "Lo", "Lx"};

#define L0 0 /* \0           */
#define Ll 1 /*   */
#define Lb 2 /*        */
#define Ln 3 /*         */
#define Lz 4 /*    */
#define Ls 5 /*         */
#define Lu 6 /* +-           */
#define Ld 7 /* #            */
#define Lo 8 /*     */
#define Lx 9

static const u_char class[256] =
{ L0, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lb, Ll, Ll,  Lo, Ll, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lb, Lo, Lo, Ld,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lu,  Lo, Lu, Lo, Lo
, Ln, Ln, Ln, Ln,  Ln, Ln, Ln, Ln,  Ln, Ln, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Ls, Ls, Ls,  Lz, Ls, Ls, Ls,  Lz, Ls, Ls, Ls,  Lz, Ls, Ls, Ls
, Ls, Ls, Lz, Ls,  Ls, Lz, Lz, Ls,  Ls, Ls, Ls, Lo,  Lo, Lo, Lo, Ls
, Lo, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Ls,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Ls,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
};

static const char *statenames[] =
{"bg", "bf", "bs", "nl", "nq", "tb", "tp", "sz", "ss", "sn", "sc", "cl", "cq", "mc", "ml", "tq", "xx"};

enum states
{ bg /*                                                    */
, bf /*                                                      */
, bs /*                                      */
, nl /*                                           */
, nq /*     ?                       */
, tb /*                             */
, tp /*                                           */
, sz /*   +-                                               */
, ss /*                                        */
, sn /*                                     */
, sc /*       ()          */
, cl /*                                 */
, cq /* ?                                */
, mc /*                                                 */
, ml /*                                           */
, tq /*   ?                                 */
, xx
};

static const char *pn[] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "Cz", "Ci", "Cn", "Cr", "Cs", "Cd", "Cm", "Cf"
, "Cl", "Cb", "Ce", "- ", "Cc", "Ck", "- ", "Cx"
};
#define Cz  0x800000 /*    +   */
#define Ci  0x400000 /*                          */
#define Cn  0x200000 /*                          */
#define Cr  0x100000 /*                      */
#define Cs  0x080000 /*                     */
#define Cd  0x040000 /*  mular     */
#define Cm  0x020000 /*                          */
#define Cf  0x010000 /*                              */
#define Cl  (Cr | Cm)/*                  */
#define Cb  0x004000 /*                 */
#define Ce  0x002000 /*                  */
#define Cc  0x000800 /*                         */
#define Cp  (Cb | Cc)/*          */
#define Ck  0x000400 /*                          */
#define Cx  0x000100 /*                              */
#define C_state 0xFF /*                     */

static u_int32_t automa[xx][Lx] =
/*       L0        Ll        Lb        Ln        Lz        Ls        Lu     Ld        Lo */
{{       xx,       nl,       bg,       bs,    Cf|bf,       bs,       bs,    bs,       bs }/* bg */
,{       xx,       nl,       bs,       bs,    Cf|bf,       bs,       bs,    bs,       bs }/* bf */
,{       xx,       nl,       bs,       bs,       bs,       bs,       bs,    bs,       bs }/* bs */
,{       xx,       nl,       bg,       bg,       bg,       bg,       bg,    nq,       bg }/* nl */
,{       xx,       nl,       tb,       xx,       xx,       xx,       xx,    bg,       xx }/* nq */
,{    Ck|xx,    Ck|nl,       tb,       xx, Cs|Cd|tp, Cs|Cd|tp, Cz|Cd|sz, Ck|xx,    Ck|xx }/* tb */
,{       xx, Cm|   cl, Cm|   sc,       tp,       tp,       tp,       xx,    xx,       xx }/* tp */
,{       xx,       xx,       xx,       xx,    Ci|ss,       xx,       xx,    xx,       xx }/* sz */
,{ Cr|Ck|xx, Cr|   cl, Cr|   sc, Cn|   sn,       xx,       xx,       xx,    xx,       xx }/* ss */
,{ Cr|Ck|xx, Cr|   cl, Cr|   sc, Cn|   sn,       xx,       xx,       xx,    xx,       xx }/* sn */
,{ Cr|Ck|xx,       cl,       sc,       sc,       sc,       sc,       sc,    sc,       sc }/* sc */
,{    Ck|xx, Cp|Ce|ml, Cp|   mc, Cp|   mc, Cp|   mc, Cp|   mc, Cp|   mc,    cq, Cp|   mc }/* cl */
,{    Ck|xx, Ck|   nl,       tb, Ck|   xx, Ck|   xx, Ck|   xx, Ck|   xx,    mc, Ck|   xx }/* cq */
,{ Ce|Ck|xx, Ce|Cc|ml,    Cc|mc,    Cc|mc,    Cc|mc,    Cc|mc,    Cc|mc, Cc|mc,    Cc|mc }/* mc */
,{    Ck|xx, Ce|Cc|ml,    Cc|mc,    Cc|mc,    Cc|mc,    Cc|mc,    Cc|mc,    tq,    Cc|mc }/* ml */
,{    Ck|xx, Ck|   nl, Ck|   tb, Ck|   xx, Ck|   xx, Ck|   xx, Ck|   xx, Cc|mc, Ck|   xx }/* tq */
};

static size_t msz[] = {1024, 512, 512};
static size_t asz[] = {512, 512, 512};

static int
pgoblin_style_parse(pgoblin_styreg *reg_style, u_char *in) {
#   define ST     ((pgo0_style *)(reg_style->style))
    int ex = EX_OK, lfcount, type = 0, i;
    enum states state;
    u_int32_t control;
    size_t offset, s_num = 0, o_beg = 0;
    u_char p, s_lit = M;
    u_char *l_beg = NULL, *l_end = NULL, *literal = NULL;
    mular_descriptor *ids = NULL;
#   define D_ARBI 0x80000000 /*  */
#   define D_SIGN 0x40000000 /* sign (+, -)                             */
#   define D_TYPE 0x00FF0000 /* entity type (H, U, D, V, L, R = 0 .. 5) */
#   define D_TYPS 16         /* shift of D_TYPE                         */
#   define D_DFLT 0x00000100 /* default (no number)                     */
#   define D_DFLS 8          /* shift of D_DFLT                         */
#   define D_NUMB 0x000000FF /* entity number                           */

    if  (!in) {
        ifBLIN_QV1(reg_style->flags) warnx("No pgoblin style");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!ST) {
        if  (!(reg_style->style = malloc(sizeof(pgo0_style)))) {
            ifBLIN_QV1(reg_style->flags) warnx("No memory #1 style pgo0");
            ERROUT(EX_OSERR, ENOMEM);
        }
        bzero(ST, sizeof(pgo0_style));
        strncpy(ST->id, PGOBLIN_STYLE_ID, strlen(PGOBLIN_STYLE_ID));
    } else {
        if  (!!strncmp(ST->id, PGOBLIN_STYLE_ID, strlen(PGOBLIN_STYLE_ID))) {
            ifBLIN_QV1(reg_style->flags) warnx("Illegal pgoblin pgo0 style %s", ST->id);
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  ((ST->flags & PGOBLIN_NTBSZMK) != PGOBLIN_NTBSIZE) {
            ifBLIN_QV1(reg_style->flags)
                warnx("Illegal pgoblin pgo0 style size %d", ST->flags & PGOBLIN_NTBSZMK);
            ERROUT(EX_DATAERR, EINVAL);
    }   }
    if  (!ST->str && !(ST->str = mular_create(MULAR_STRI | MULAR_CHAR, 3, sizeof(char*), msz))) {
        ifBLIN_QV1(reg_style->flags) warn("Style pgo0");
        ERROUT(EX_OSERR, ENOMEM);
    }
    ST->flags = PGOBLIN_NTBSIZE;
    if  (  !ST->arb
        && !(ST->arb = mular_create( MULAR_STRI | MULAR_ZERO | MULAR_HEXU | MULAR_SWP1 | MULAR_SWP2
                                   , 3
                                   , sizeof(pgo0_arb)
                                   , asz
        )   )                      ) {
        ifBLIN_QV1(reg_style->flags) warn("Style pgo0");
        ERROUT(EX_OSERR, ENOMEM);
    }
    ST->arb->flags &= ~MULAR_FIXD;
    ifBLIN_QV5(reg_style->flags) BLIN_STATEHEADER(stderr, pn)
    lfcount = 1;
    for (state = bg, offset = 0, control = 0; state < xx; offset++, state = control & C_state) {
        p = class[in[offset]];
        if  (in[offset] == '\n') lfcount++;
        control = automa[state][p];
        ifBLIN_QV5(reg_style->flags)
            BLIN_STATEBODY(stderr, pn, 0xFF, clasnames[p], in, offset, 0xFFFFFFFF, control, statenames, state, C_state, (in[offset + BLIN_STATEVAR_i]>=' '))
        if  (control & Cz) {
            if  (in[offset] == '-') type = -1; else type = 1;
            s_num = 0;
        }
        if  (control & Ci) s_lit = in[offset];
        if  (control & Cn) {
            if  (s_num >= (1 << PGOBLIN_NTBSIZE)) {
                ifBLIN_QV1(reg_style->flags) fprintf(stderr, "Long number pgo0 line %d\n", lfcount);
                ERROUT(EX_DATAERR, EINVAL);
            }
            s_num = s_num * 10 + (in[offset] - '0');
            if  (type & 0xFF) type <<= 1;
        }
        if  (control & Cr) {
            u_int32_t c;

            if  (!(s_num < (1 << PGOBLIN_NTBSIZE))) {
                ifBLIN_QV1(reg_style->flags) fprintf(stderr, "Big number pgo0 line %d\n", lfcount);
                ERROUT(EX_DATAERR, EINVAL);
            }
            c = entity[s_lit - '@'];
            ifBLIN_QV2(reg_style->flags) {
                if  (type & 1) {
                    if  (ST->a[c].def)
                        fprintf( stderr, "Repeat %c%c in line %d\n"
                               , (type > 0) ? '+' : '-', s_lit
                               , lfcount
                               );
                } else if ((type < 0) ? ST->a[c].spec[s_num].b : ST->a[c].spec[s_num].f) {
                    fprintf( stderr, "Repeat %c%c%d in line %d\n"
                           , (type > 0) ? '+' : '-', s_lit, (int)s_num
                           , lfcount
                           );
            }   }
            ifBLIN_QV6(reg_style->flags) fprintf(stderr, "Cr add [%d]", (int)MULAR_NEXT(ids));
            *(u_int32_t*)mular_add(ids) = (type & D_SIGN)
                                        | (c << D_TYPS)
                                        | ((type << D_DFLS) & D_DFLT)
                                        | (s_num & D_NUMB);
            ifBLIN_QV6(reg_style->flags)
                fprintf(stderr, "%08X\n", *(u_int32_t*)mular_getix(ids, MULAR_NEXT(ids) - 1));
        }
        if  (control & Cs) o_beg = offset;
        if  (control & Cd) {
            if  (!ids) ids = mular_create(MULAR_STRI, 3, sizeof(u_int32_t), msz);
        }
        if  (control & Cm) {
            in[offset] = '\0';
            i = getind(ST->arb, &in[o_beg]);
            if  (!(i < D_ARBI)) {
                ifBLIN_QV1(reg_style->flags) fprintf(stderr, "Overflow pgo0 line %d\n", lfcount);
                ERROUT(EX_DATAERR, EINVAL);
            }
            ifBLIN_QV2(reg_style->flags) {
                if  (((pgo0_arb*)mular_getix(ST->arb, i))->vl) {
                    fprintf(stderr, "Repeat %s in line %d\n", &in[o_beg], lfcount);
            }   }
            ifBLIN_QV6(reg_style->flags) fprintf(stderr, "Cm add [%d]", (int)MULAR_NEXT(ids));
            *(u_int32_t*)mular_add(ids) = i | D_ARBI;
            ifBLIN_QV6(reg_style->flags)
                fprintf(stderr, "%08X\n", *(u_int32_t*)mular_getix(ids, MULAR_NEXT(ids) - 1));
        }
        if  (control & Cf) {
            u_int32_t nwfl = flagvalues[entity[in[offset] - '@']];
            if  (ST->flags & nwfl & EDGE) nwfl <<= 1;
            ST->flags |= nwfl;
        }
        if  (control & Cl) {
            l_beg = NULL;
            l_end = NULL;
        }
        if  ((control & Cb) && !l_beg) literal = l_beg = &in[offset];
        if  (control & Ce && l_beg) l_end = literal;
        if  (control & Cc) {
            if  (literal != &in[offset]) *literal = in[offset];
            literal++;
        }
        if  (control & Ck) {
            u_int32_t *e, n = 0;

            if  (l_beg && l_end) {
                *l_end = '\0';
                n = MULAR_NEXT(ST->str);
                *(u_char**)(mular_add(ST->str)) = l_beg;
            }
            for (i = 0; i < MULAR_NEXT(ids); i++) {
                int localj = 0;

                e = mular_getix(ids, i);
                ifBLIN_QV6(reg_style->flags) {
                    for (localj = 0; localj < ENTITY_LETTERS; localj++)
                        if  (((*e & D_TYPE) >> D_TYPS) == entity[localj]) break;
                    localj += '@';
                }
                if  (*e & D_ARBI) {
                    ifBLIN_QV6(reg_style->flags)
                        fprintf(stderr, "Ck [%d]%08X D_ARBI %d\n", i, *e, *e & ~D_ARBI);
                    ((pgo0_arb*)mular_getix(ST->arb, *e & ~D_ARBI))->vl = l_end ? ~n : 0;
                } else if (*e & D_DFLT) {
                    ifBLIN_QV6(reg_style->flags) fprintf( stderr, "Ck [%d]%08X D_DFLT D_TYPE %c\n"
                                                        , i, *e
                                                        , localj
                                                        );
                    ST->a[(*e & D_TYPE) >> D_TYPS].def = l_end ? ~n : 0;
                } else {
                    ifBLIN_QV6(reg_style->flags)
                        fprintf( stderr, "Ck [%d]%08X D_SIGN %c D_TYPE %c D_NUMB %d\n"
                               , i, *e
                               , (*e & D_SIGN) ? '-' : '+'
                               , localj
                               , *e & D_NUMB
                               );
                    if  (*e & D_SIGN) ST->a[(*e & D_TYPE) >> D_TYPS].spec[*e & D_NUMB].b = l_end ? ~n : 0;
                      else            ST->a[(*e & D_TYPE) >> D_TYPS].spec[*e & D_NUMB].f = l_end ? ~n : 0;
            }   }
            mular_destroy(ids);
            ids = NULL;
        }
        if  (control & Cx) {
            ifBLIN_QV1(reg_style->flags) fprintf(stderr, "Erroneous style pgo0 line %d\n", lfcount);
            ERROUT(EX_DATAERR, EINVAL);
    }   }
out:
    if  (ST->arb) ST->arb->flags |= MULAR_FIXD;
    if  (ids) mular_destroy(ids);
    return(ex);
#   undef  ST
}

static void
pgoblin_style_dump(pgoblin_styreg *reg_style) {
    pgo0_style *st;
    int ex = EX_OK, i, j, k;
    pgo0_arb *e;
    u_char **c;
   /******************************************************/
    u_int tmpidx;  /* Due to the error in cc -v          *
    *** Using built-in specs.                          ***
    *** Configured with: FreeBSD/amd64 system compiler ***
    *** Thread model: posix                            ***
    *** gcc version 3.4.6 [FreeBSD] 20060305           ***
    * I can't use direct                                 *
    *** mular_getix(st->str, ~st->a[i].def)            ***
    ******************************************************/

    if  (!reg_style || !(st = reg_style->style)) {
        printf("Dump pgo0: no style\n");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  ((st->flags & PGOBLIN_NTBSZMK) != PGOBLIN_NTBSIZE) {
        printf("Illegal pgoblin pgo0 style size %d\n", st->flags & PGOBLIN_NTBSZMK);
        ERROUT(EX_DATAERR, EINVAL);
    }
    printf("+######################################");
    for (i = 0; i < PGOBLIN_STRING_ID_LEN && st->id[i]; i++) printf("%c", st->id[i]);
    printf("\n flags=%08X %08X\n", reg_style->flags, st->flags);
    ifBLIN_QV3(reg_style->flags) {
        printf("------->str[%d]\n", (int)MULAR_NEXT(st->str));
        ifBLIN_QV4(reg_style->flags) mular_dump(st->str, stdout);
        for (i = 0; i < MULAR_NEXT(st->str); i++) {
            c = mular_getix(st->str, i);
            if  (!c) printf("[%d]\n", i);
            else if (!*c) printf("[%d]%" BLIN_X "\n", i, BLIN_I(c));
            else printf("[%d]=%s~\n", i, *c);
        }
        printf("------->arb[%d]\n", (int)MULAR_NEXT(st->arb));
        ifBLIN_QV4(reg_style->flags) mular_dump(st->arb, stdout);
        for (i = 0; i < MULAR_NEXT(st->arb); i++) {
            e = mular_getix(st->arb, i);
            if  (!e) printf("[%d]\n", i);
            else if (e->nm) printf("%d[%s]%d\n", i, e->nm, (int)~e->vl);
            else printf("%d[]%d\n", i, (int)~e->vl);
    }   }
    for (i = 0; i < MULAR_NEXT(st->arb); i++) {
        e = mular_getix(st->arb, i);
        tmpidx = ~e->vl;
        printf("# %s\n%s\n", e->nm, *(u_char**)mular_getix(st->str, tmpidx));
    }
    for (i = 0; i < M; i++) {
        for (j = 0; j < ENTITY_LETTERS; j++) if  (i == entity[j]) break;
        j += '@';
        if  (~(tmpidx = ~st->a[i].def)) {
            printf("# +%c\n%s\n", j, *(u_char**)mular_getix(st->str, tmpidx));
        }
        for (k = 0; k < (1 << PGOBLIN_NTBSIZE); k++) {
            if  (~(tmpidx = ~st->a[i].spec[k].f)) {
                printf("# +%c%d\n%s\n", j, k, *(u_char**)mular_getix(st->str, tmpidx));
            }
            if  (~(tmpidx = ~st->a[i].spec[k].b)) {
                printf("# -%c%d\n%s\n", j, k, *(u_char**)mular_getix(st->str, tmpidx));
    }   }   }
    ifBLIN_QV4(reg_style->flags) {
        for (i = 0; i < MULAR_NEXT(st->str); i++)
            printf("[%d]=%s~\n", i, *(u_char**)mular_getix(st->str, i));
        for (i = 0; i < M; i++) {
            for (j = 0; j < ENTITY_LETTERS; j++) if  (i == entity[j]) printf("%c", j + '@');
            printf("%c", st->a[i].def ? '|' : '.');
            for (j = 0; j < 76; j++)
                printf( "%c"
                      , st->a[i].spec[j].f
                      ? (st->a[i].spec[j].b ? '*' : '+')
                      : (st->a[i].spec[j].b ? '-' : '.')
                      );
            printf("\n");
    }   }
    printf("-######################################\n");
out:
    return;
}

static int
pgoblin_style_free(pgoblin_styreg *reg_style) {
    int ex = EX_OK;
    pgo0_style *st;

    if  (reg_style) {
        if  ((st = reg_style->style)) {
            if  (!!strncmp(st->id, PGOBLIN_STYLE_ID, strlen(PGOBLIN_STYLE_ID))) {
                ifBLIN_QV1(reg_style->flags) warnx("Illegal pgoblin pgo0 style %s", st->id);
                ERROUT(EX_DATAERR, EINVAL);
            }
            if  ((st->flags & PGOBLIN_NTBSZMK) != PGOBLIN_NTBSIZE) {
                ifBLIN_QV1(reg_style->flags)
                    warnx("Illegal pgoblin pgo0 style size %d", st->flags & PGOBLIN_NTBSZMK);
                ERROUT(EX_DATAERR, EINVAL);
            }
            if  (st->str) mular_destroy(st->str);
            if  (st->arb) mular_destroy(st->arb);
            free(st);
            st = NULL;
            reg_style->path = NULL;
            reg_style->flags &= ~PGOBLIN_STYLE_TYPE;
    }   }
out:
    return(ex);
}

static char *
pgoblin_style_get(pgoblin_styreg *reg_style, u_char *stringname) {
    int ex = EX_OK;
    pgo0_style *st;
    char *found = NULL;
    int i;
    pgo0_arb *e;
   /******************************************************/
    u_int tmpidx;  /* Due to the error in cc -v          *
    *** Using built-in specs.                          ***
    *** Configured with: FreeBSD/amd64 system compiler ***
    *** Thread model: posix                            ***
    *** gcc version 3.4.6 [FreeBSD] 20060305           ***
    * I can't use direct                                 *
    *** mular_getix(st->str, ~e->vl)                   ***
    ******************************************************/

    st = reg_style->style;
    if  (!!strncmp(st->id, PGOBLIN_STYLE_ID, strlen(PGOBLIN_STYLE_ID))) {
        ifBLIN_QV1(reg_style->flags) warnx("Illegal pgoblin pgo0 style %s", st->id);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  ((st->flags & PGOBLIN_NTBSZMK) != PGOBLIN_NTBSIZE) {
        ifBLIN_QV1(reg_style->flags)
            warnx("Illegal pgoblin pgo0 style size %d", st->flags & PGOBLIN_NTBSZMK);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  ((i = getind(st->arb, stringname)) >= 0) {
        e = mular_getix(st->arb, i);
        if  (e->vl) {
            tmpidx = ~e->vl;
            if  (!(found = strdup(*(char**)mular_getix(st->str, tmpidx)))) errno = ENOMEM;
    }   }
out:
    return(found);
}

static int
sout(pgoblin_io *reg_out, char *c, int l) {
    int ex = 0;

    if  (c) ex = reg_out->wri(reg_out->onu, c, l ? l : strlen(c));
    return(ex);
}

/*****************************************************************************************************
 **       .    f       **
 **    b  ,       +f  canf   **
 ** (     )  -b  canb (       **
 ** ).    ,      .   ,  **
 **  ,      FORWARD  BAKWARD.           **
 **   ,   ,    .                 **
 **   ,   + .     ,      **
 **     .                                                              **/
static char *                                                                                      /**/
dsig(u_int32_t fl, mular_descriptor *s, ssize_t f, ssize_t b, pgo0_ent *pr) {                      /**
 *****************************************************************************************************/
    ssize_t canf = 0, canb = 0, can=0;
    char **ss = NULL;
   /******************************************************/
    u_int tmpidx;  /* Due to the error in cc -v          *
    *** Using built-in specs.                          ***
    *** Configured with: FreeBSD/amd64 system compiler ***
    *** Thread model: posix                            ***
    *** gcc version 3.4.6 [FreeBSD] 20060305           ***
    * I can't use direct                                 *
    *** mular_getix(s, ~can)                           ***
    ******************************************************/

    if  ((fl & FIRST) && (f < (1 << PGOBLIN_NTBSIZE))) {
        canf = pr->spec[f].f;
    }
    if  ((fl & LAST) && (b < (1 << PGOBLIN_NTBSIZE))) {
        canb = pr->spec[b].b;
    }
    if  (!canf) can = canb;
    else if (!canb) can = canf;
    else if ((fl & FORWARD) && !(fl & BAKWARD)) can = canf;
    else if (!(fl & FORWARD) && (fl & BAKWARD)) can = canb;
    else if (canb > canf) can = canb;
    else can = canf;
    if  (!can) can = pr->def;
    tmpidx = ~can;
    if  (can) ss = (char**)mular_getix(s, tmpidx);
    if  (!ss) {
        ifBLIN_QV2(fl) warnx("style pgo0 tbl NULL @ f=%"BLIN_D" b=%"BLIN_D, f, b);
        return(NULL);
    } else {
        return(*ss);
}   }

static int
pgoblin_style_tbl( pgoblin_io    *reg_out
                 , pgoblin_styreg*reg_style
                 , pgoblin_io    *reg_in
                 , ssize_t        low
                 , ssize_t        hig
                 ) {
    int ex = 0;
    ssize_t i = 0, m, w, j, l = 0;
    pgoblin_dbases *db;
    pgo0_style *st;
    u_int32_t flow = 0, f, fwiv;
    char *c, *v;
#   define TRC(E, F, B) { /*   */                                                    \
        ifBLIN_QV4(reg_style->flags) {                                                                \
            int SOUT_i;                                                                               \
            fprintf(stderr, "<");                                                                     \
            for (SOUT_i = 0; SOUT_i < ENTITY_LETTERS; SOUT_i++)                                       \
                if  ((E) == entity[SOUT_i]) fprintf(stderr, "%c", SOUT_i + '@');                      \
            fprintf( stderr, "%c,%d%c,%d%c>"                                                          \
                   , st->a[E].def ? '+' : '-'                                                         \
                   , (int)(F), st->a[E].spec[F].f ? '+' : '-'                                         \
                   , (int)(B), st->a[E].spec[B].b ? '+' : '-'                                         \
                   );                                                                                 \
    }   }
#   define SOUT(C, L) { /*          */                  \
        ex = sout(reg_out, (C), (L));                                                                 \
        if  (ex < 0) goto out;                                                                        \
        l += ex;                                                                                      \
    }
#   define VOUT {                                                                                     \
        if  (c) {                                                                                     \
            flow |= HALWAYS;                                                                          \
            SOUT(v, 0);                                                                               \
            v = NULL;                                                                                 \
            SOUT(c, 0);                                                                               \
    }   }

    st = reg_style->style;
    if  (!!strncmp(st->id, PGOBLIN_STYLE_ID, strlen(PGOBLIN_STYLE_ID))) {
        ifBLIN_QV1(reg_style->flags) warnx("Illegal pgoblin pgo0 style %s", st->id);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  ((st->flags & PGOBLIN_NTBSZMK) != PGOBLIN_NTBSIZE) {
        ifBLIN_QV1(reg_style->flags)
            warnx("Illegal pgoblin pgo0 style size %d", st->flags & PGOBLIN_NTBSZMK);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (low >= 0) {
        flow |= FIRST | FORWARD;
        i = low;
    }
    db = DBASE(reg_in->flagc);
    m = i + db->resinfo(PGOBLIN_Ntuples, reg_in->pq);
    if  ((hig == -2) || ((hig >= 0) && (m == hig))) {
        flow |= LAST | BAKWARD;
    }
    w = db->resinfo(PGOBLIN_Nfields, reg_in->pq);
    f = st->flags;
    flow &= (f >> HSHIFT) | P_A;
    fwiv = (f >> VSHIFT) | P_A;
    ifBLIN_QV3(reg_style->flags)
        fprintf(stderr, "pgo0 %08X %08X %d..%dx%d\n", f, flow, (int)i, (int)m, (int)w);
    if  (m == 0) {
        flow &= P_A;
        if  (f & HFIRST) {
            c = dsig(flow | FORWARD, st->str, 0, 0, &st->a[H]);
            TRC(H, 0, 0);
            SOUT(c, 0);
        }
        if  (f & HLAST) {
            c = dsig(flow | BAKWARD, st->str, 0, 0, &st->a[H]);
            TRC(H, 0, 0);
            SOUT(c, 0);
        }
    } else if (w <= 0) {
        flow &= P_A;
        if  (f & HFIRST) {
            c = dsig(flow, st->str, 0, m, &st->a[H]);
            TRC(H, 0, m);
            SOUT(c, 0);
        }
        for (; i < m; i++) {
            c = dsig(flow, st->str, i, m - i, &st->a[H]);
            TRC(H, i, m - i);
            SOUT(c, 0);
            v = dsig(flow, st->str, i, m - i - 1, &st->a[U]);
            TRC(U, i, m - i - 1);
            flow &= ~HALWAYS;
            if  (f & VFIRST) {
                c = dsig(P_A, st->str, 0, w, &st->a[V]);
                TRC(V, 0, w);
                VOUT;
            }
            if  (f & VLAST) {
                c = dsig(P_A, st->str, w, 0, &st->a[V]);
                TRC(V, w, 0);
                VOUT;
            }
            c = dsig(flow, st->str, i, m - i - 1, &st->a[D]);
            TRC(D, i, m - i - 1);
            if  (flow & HALWAYS) SOUT(c, 0);
        }
        if  (f & HLAST) {
            c = dsig(flow, st->str, m, 0, &st->a[H]);
            TRC(H, m, 0);
            SOUT(c, 0);
        }
    } else {
        ssize_t k;

        for (k = i; i < m; i++) {
            c = dsig(flow, st->str, i, m - i, &st->a[H]);
            TRC(H, i, m - i);
            SOUT(c, 0);
            v = dsig(flow, st->str, i, m - i - 1, &st->a[U]);
            TRC(U, i, m - i - 1);
            flow = (flow & ~HALWAYS) | (st->flags & HALWAYS);
            for (j = 0; j < w; j++) {
                if  (ex < 0) goto out;
                c = dsig(fwiv, st->str, j, w - j, &st->a[V]);
                TRC(V, j, w - j);
                VOUT;
                if  (!db->valinfo(PGOBLIN_IsNull, reg_in->pq, i - k, j)) {
                    flow |= HALWAYS;
                    SOUT(v, 0);
                    v = NULL;
                    c = dsig(fwiv, st->str, j, w - j - 1, &st->a[L]);
                    TRC(L, j, w - j - 1);
                    SOUT(c, 0);
                    SOUT( db->getvalue(reg_in->pq, i - k, j)
                        , db->valinfo(PGOBLIN_Length, reg_in->pq, i - k, j)
                        );
                    c = dsig(fwiv, st->str, j, w - j - 1, &st->a[R]);
                    TRC(R, j, w - j - 1);
                    SOUT(c, 0);
                } else if (f & VALWAYS) {
                    c = dsig(fwiv, st->str, j, w - j - 1, &st->a[L]);
                    TRC(L, j, w - j);
                    VOUT;
                    c = dsig(fwiv, st->str, j, w - j - 1, &st->a[R]);
                    TRC(R, j, w - j - 1);
                    VOUT;
            }   }
            c = dsig(fwiv, st->str, w, 0, &st->a[V]);
            TRC(V, w, 0);
            VOUT;
            c = dsig(flow, st->str, i, m - i - 1, &st->a[D]);
            TRC(D, i, m - i - 1);
            if  (flow & HALWAYS) SOUT(c, 0);
        }
        if  (flow & LAST) {
            c = dsig(flow, st->str, m, 0, &st->a[H]);
            TRC(H, m, 0);
            SOUT(c, 0);
    }   }
out:
    return((ex < 0) ? ex : l);
}

pgoblin_styles pgoblin_style_pgo0 =
{ 0
, "5pGoblin-" VERS
, "pgo0\0" VERS
, pgoblin_finit
, pgoblin_finit
, pgoblin_style_parse
, pgoblin_style_dump
, pgoblin_style_free
, pgoblin_style_get
, pgoblin_style_tbl
};
