/*-
 * Copyright (C)2008..2011 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2008..2011 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: style_0.c,v 1.18 2013/02/05 06:14:37 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <mife.h>
#include "pgoblin.h"
#include "pgob.h"

static int
pgoblin_finit(u_int32_t flags, pgoblin_styles *this) {
    return(EX_OK);
}

static int
pgoblin_style_parse(pgoblin_styreg *reg_style, u_char *in) {
    return(EX_OK);
}

static void
pgoblin_style_dump(pgoblin_styreg *reg_style) {
    return;
}

static int
pgoblin_style_free(pgoblin_styreg *reg_style) {
    return(EX_OK);
}

static char *
pgoblin_style_get(pgoblin_styreg *reg_style, u_char *stringname) {
    return(NULL);
}

static int
sout(pgoblin_io *reg_out, char *c, int l) {
    int ex = 0;

    if  (c) {
        if  (!l) l = strlen(c);
        if  (reg_out->wri) {
            ex = reg_out->wri(reg_out->onu, c, l);
        } else {
            MARK_IO_TEXT_GO(reg_out);;
            ;;  bcopy(c, &((char*)(reg_out->text))[reg_out->length], l);
            ;;  reg_out->length += l;
            ;;  ((char*)(reg_out->text))[reg_out->length] = '\0';
            MARK_IO_TEXT_WENT(reg_out);;
    }   }
    return(ex);
}

static int
pgoblin_style_tbl( pgoblin_io    *reg_out
                 , pgoblin_styreg*reg_style
                 , pgoblin_io    *reg_in
                 , ssize_t        low
                 , ssize_t        hig
                 ) {
    ssize_t i = 0, m, w, j, l, minc, maxc;
    pgoblin_dbases *db;
    int ex = 0;

    db = DBASE(reg_in->flagc);
    m = db->resinfo(PGOBLIN_Ntuples, reg_in->pq);
    w = db->resinfo(PGOBLIN_Nfields, reg_in->pq);
    if  (hig == -3) {
        minc = low;
        maxc = (low < m) ? low + 1 : m;
    } else {
        minc = 0;
        maxc = m;
    }
    if  (!reg_out->wri) {
        char *s;

        for (i = minc, l = 0; i < maxc; i++) {
            for (j = 0; j < w; j++) {
                if  (!db->valinfo(PGOBLIN_IsNull, reg_in->pq, i, j)) {
                    ex = db->valinfo(PGOBLIN_Length, reg_in->pq, i, j);
                    if  (ex < 0) {
                        ifBLIN_QV1(reg_style->flags) warn("table in 0 STYLE");
                        ex = -EX_IOERR;
                        goto out;
                    }
                    l += ex;
        }   }   }
        if  (!(s = malloc(l + 1))) {
            ifBLIN_QV1(reg_style->flags) warnx("table in 0 STYLE: No mem");
            ERROUT(-EX_OSERR, ENOMEM);
        }
        MARK_IO_TEXT_GO(reg_out);;
        ;;  if  (reg_out->text && (reg_out->flags & PGOBLIN_FREETEXT)) free(reg_out->text);
        ;;  reg_out->text = s;
        ;;  reg_out->length = 0;
        ;;  reg_out->flags |= PGOBLIN_BINPARM | PGOBLIN_FREETEXT;
        ;;  ((char*)(reg_out->text))[reg_out->length] = '\0';
        MARK_IO_TEXT_WENT(reg_out);;
    }
    for (i = minc, l = 0; i < maxc; i++) {
        for (j = 0; j < w; j++) {
            if  (!db->valinfo(PGOBLIN_IsNull, reg_in->pq, i, j)) {
                ex = sout( reg_out
                         , db->getvalue(reg_in->pq, i, j)
                         , db->valinfo(PGOBLIN_Length, reg_in->pq, i, j)
                         );
                if  (ex < 0) {
                    ifBLIN_QV1(reg_style->flags) warn("table in 0 STYLE");
                    ex = -EX_IOERR;
                    goto out;
                }
                l += ex;
    }   }   }
out:
    return((ex < 0) ? ex : l);
}

pgoblin_styles pgoblin_style_0 =
{ 0
, "5pGoblin-" VERS
, "0\0" VERS
, pgoblin_finit
, pgoblin_finit
, pgoblin_style_parse
, pgoblin_style_dump
, pgoblin_style_free
, pgoblin_style_get
, pgoblin_style_tbl
};
