/*-
 * Copyright (C)2007..2011 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: pgob.h,v 1.39 2011/12/10 04:51:09 babolo Exp $
 */

#ifndef EDOOFUS
# define EDOOFUS EINVAL
#endif

#define DBASE(N)       (pgoblin.dbasetable[(N) & PGOBLIN_DB_TYPE])
#define JOBE(N)        (pgoblin.jobtable[(N) & PGOBLIN_JOB_TYPE])
#define STYLS(N)       (pgoblin.styletable[(N) & PGOBLIN_STYLE_TYPE])

#define PREG(CMD,REG)  ( (pgoblin.p[REG].bin < 0)                                                     \
                       ? (pgoblin.a[CMD].flags >> ~pgoblin.p[REG].bin) & pgoblin.p[REG].mask          \
                       : pgoblin.p[REG].bin                                                           \
                       )
#define ERROUT(A,B)    do {ex = (A); errno = (B); goto out;} while(0)
#define OFFSETOF(s, e) ((char *)&((s *)0)->e - (char *)((s *)0))

/*    */
#define PGO_COUT    0
#define PGO_CCTL    1
#define PGO_CIN     2
#define PGO_CCON    3
#define PGO_CJOB    4
#define PGO_CSTY    5
#define PGO_MAXR    PGOBLIN_SYMREGS

#define IO_RG0      (options->io[0])
#define R_STY0      (options->style[0])
#define IO_OUT      (r[PGO_COUT].g.io)
#define IO_CTL      (r[PGO_CCTL].g.io)
#define IO_IN       (r[PGO_CIN].g.io)
#define IO_CPY      (r[PGO_CCPY].g.io)
#define R_CONN      (r[PGO_CCON].g.c)
#define R_JOB       (r[PGO_CJOB].g.j)
#define R_STYLE     (r[PGO_CSTY].g.s)
#define CH_OUT      (r[PGO_COUT].c)
#define CH_CTL      (r[PGO_CCTL].c)
#define CH_IN       (r[PGO_CIN].c)
#define CH_CON      (r[PGO_CCON].c)
#define CH_JOB      (r[PGO_CJOB].c)
#define CH_STY      (r[PGO_CSTY].c)

#define PGOBLIN_BUFSIZE   8192
#define PGOBLIN_BUFMULT   2
#define PGOBLIN_RAWIOBUFL 1

#define UNRESERVED_KEYWORD     1
#define COL_NAME_KEYWORD       2
#define TYPE_FUNC_NAME_KEYWORD 3
#define RESERVED_KEYWORD       4

#define MARK_IO_PATH_GO(x)
#define MARK_IO_PATH_WENT(x)
#define MARK_IO_TEXT_GO(x)
#define MARK_IO_TEXT_WENT(x)
#define MARK_IO_MIFE_GO(x)
#define MARK_IO_MIFE_WENT(x)
#define MARK_IO_PQ_GO(x)
#define MARK_IO_PQ_WENT(x)
#define MARK_IO_OUT_GO(x)
#define MARK_IO_OUT_WENT(x)
#define MARK_R_CONN_GO(x)
#define MARK_R_CONN_WENT(x)
#define MARK_R_JOB_GO(x)
#define MARK_R_JOB_WENT(x)
#define MARK_R_STYLE_GO(x)
#define MARK_R_STYLE_WENT(x)

extern pgoblin_jobs   pgoblin_job_local;
extern pgoblin_dbases pgoblin_db_0;
#ifdef HAVE_DB_PGSQL
extern pgoblin_dbases pgoblin_db_pgsql;
#endif
#ifdef HAVE_DB_SQLITE2
extern pgoblin_dbases pgoblin_db_sqlite2;
#endif
#ifdef HAVE_DB_SQLITE3
extern pgoblin_dbases pgoblin_db_sqlite3;
#endif
extern pgoblin_styles pgoblin_style_0;
extern pgoblin_styles pgoblin_style_pgo0;

#ifdef _PGOBLIN_CHAR_CLASSES_
#   define L0 0 /* \0           */
#   define Ll 1 /*   */
#   define Lb 2 /*        */
#   define Ls 3 /*    */
#   define Ld 4 /* #            */
#   define Lo 5 /*     */
#   define Lx 6
#endif /* _PGOBLIN_CHAR_CLASSES_ */

int                  pgoblin_listen __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                   pgoblin_begin __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                     pgoblin_end __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                 pgoblin_perform __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_echo __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_file __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                     pgoblin_cat __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_pipe __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                   pgoblin_close __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                   pgoblin_clear __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_exec __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_fork __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_wait __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_exit __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_trap __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_untrap __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_call __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                    pgoblin_eval __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                   pgoblin_style __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                     pgoblin_job __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                 pgoblin_connect __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_return __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_copyin __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                 pgoblin_copyout __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_binsel __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_strsel __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_binpre __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_select __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                 pgoblin_display __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_getstr __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_getarg __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_getenv __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_getget __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                 pgoblin_getpost __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                 pgoblin_getproc __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_getjob __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_getspq __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_getdir __P((pgoblin_exenv *exenv, pgoblin_r *r));
int                  pgoblin_getcsv __P((pgoblin_exenv *exenv, pgoblin_r *r));

#ifdef DEBUG
//# include <dmalloc.h>
# include <memcheck.h>
# define DMALLOC_FUNC_CHECK 1
#endif
