/*-
 * Copyright (C)2002..2011 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2002..2011 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_trans.c,v 1.58 2013/02/24 14:58:48 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/param.h>
#if defined(__FreeBSD_cc_version) && __FreeBSD_cc_version > 599999 /* I do not know exact version */
#include <arpa/inet.h>
#endif
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <poll.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "pgoblin.h"
#include "pgob.h"

/*****************************************************/
#define R_JOBIN exenv->options->job[r[PGO_CJOB].r]  /*
 * pgoblin_getjob()   2  , *
 *     ,          *
 *     .               *
 *  pgoblin_syntax           *
 *   - Ij  ch[2].               *
 *   - ,         *
 * (  )     *
 *   ,   .   *
 *   R_JOBIN,   R_JOB        */
int
pgoblin_getjob(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK, exx = EX_OK, status;
    pgoblin_jobl *j;
    size_t i;
    FILE *fi;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_getjob %d\n", r[PGO_CJOB].r);
    if  (R_JOBIN.pids) {
        if  (!(fi = funopen( (void*)(IO_OUT->onu)
                           , NULL
                           , (int (*)(void*, const char*, int))mife_writ
                           , NULL
                           , NULL
            ) )            ) {
            ifBLIN_QV1(exenv->options->flags) warn("funopen on %d", r[PGO_CJOB].r);
            ex = EX_OSERR;
        } else {
            for (i = 0; i <  MULAR_NEXT(R_JOBIN.pids); i++) {
                j = mular_getix(R_JOBIN.pids, i);
                if  (j->pid <= 0) {
                    ifBLIN_QV1(exenv->options->flags) warnx("No pid in %d", (int)j->cmdn);
                    errno = EINVAL;
                    ex = EX_SOFTWARE;
                } else if ((j->cmdn >= 0) && (j->status == PGOBLIN_NOSTATUS)) {
                    if  (!(ex = waitpid(j->pid, &status, WNOHANG))) {
                    } else if (ex == j->pid) {
                        j->status = status;
                        R_JOBIN.dead++;
                        ifBLIN_QV4(R_JOBIN.flags)
                            fprintf( stderr
                                   , "pgoblin_getjob st=%08X fl=%08X ex=%d exx=%d IFEX=%d EXST=%d\n"
                                   , status, R_JOBIN.flags, ex, exx
                                   , WIFEXITED(status), WEXITSTATUS(status)
                                   );
                        if  (  (R_JOBIN.flags & PGOBLIN_ERROR_SENSOR)
                            && WIFEXITED(status)
                            && WEXITSTATUS(status)
                            ) exx = WEXITSTATUS(status);
                        if  ((R_JOBIN.flags & PGOBLIN_ERROR_SENSIB) && exx) break;
                        ex = EX_OK;
                    } else if (ex > 0) {
                        ifBLIN_QV1(exenv->options->flags) warn("Pid %d<>%d in %d", ex, j->pid, (int)j->cmdn);
                        ERROUT(EX_OSERR, ENOATTR);
                    } else if (errno == ECHILD || errno == EDEADLK || errno == EAGAIN) {
                        ex = EX_OK;
                    } else {
                        ifBLIN_QV1(exenv->options->flags) warn("Pid %d in %d", j->pid, (int)j->cmdn);
                        ex = EX_OSERR;
                        goto out;
                }   }
                fprintf(fi, "%d	%d	%d	%d\n", (int)i, (int)j->cmdn, j->pid, j->status);
            }
            fprintf(fi, "\\.\n");
            if  (fclose(fi) < 0) {
                ifBLIN_QV1(exenv->options->flags) warn("fclose on %d", r[PGO_CJOB].r);
                ex = EX_OSERR;
    }   }   }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_getjob %d\n", ex);
    return(ex ? ex : exx);
}

int
pgoblin_exec(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;
    int c, g = 0, i;
    char **argv = NULL;

    ifBLIN_QV4(exenv->options->flags)
        fprintf( stderr, "+pgoblin_exec %d %d %d %d\n"
               , r[PGO_COUT].r, r[PGO_CCTL].r, r[PGO_CIN].r, r[PGO_CJOB].r
               );
    g = DBASE(IO_CTL->flagc)->resinfo(PGOBLIN_Nfields, IO_CTL->pq);
    i = 0;
    if  (g && !(argv = malloc((g + 1) * sizeof(char**)))) {
        ERROUT(EX_OSERR, ENOMEM);
    }
    for (c = 0; c < g; c++) {
        if  (!(DBASE(IO_CTL->flagc)->valinfo(PGOBLIN_IsNull, IO_CTL->pq, exenv->sequen, c))) {
            argv[i++] = DBASE(IO_CTL->flagc)->getvalue(IO_CTL->pq, exenv->sequen, c);
    }   }
    if  (i) {
        int eex;
        argv[i] = NULL;
        eex = JOBE(R_JOB->flags)->exec(exenv, r, argv);
        if  (eex) {
            ifBLIN_QV1(exenv->options->flags) {
                int z;

                warn("Exec error on %d", r[PGO_CJOB].r);
                for (z = 0; argv[z]; z++) fprintf(stderr, "[%d]=%s~\n", z, argv[z]);
            }
            if  (eex < 0) {
                if  (eex  < ex) ex = eex;
            } else if (ex >= 0) {
                if  (eex > ex) ex = eex;
    }   }   }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "-pgoblin_exec %d\n", ex);
    return(ex);
}

int
pgoblin_fork(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags)
        fprintf( stderr, "+pgoblin_fork %s %d %d %d %d %d %d\n"
               , pgoblin.a[PGOBLIN_fork].str
               , r[PGO_COUT].r, r[PGO_CCTL].r, r[PGO_CIN].r
               , r[PGO_CCON].r, r[PGO_CJOB].r, r[PGO_CSTY].r
               );
    if  (R_JOB) ex = JOBE(R_JOB->flags)->fork(exenv, r);
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_fork %d\n", ex);
    return(ex);
}

int
pgoblin_wait(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_wait %d\n", r[PGO_CJOB].r);
    if  (R_JOB) {
        ex = JOBE(R_JOB->flags)->wait(exenv, r);
        MARK_R_JOB_GO(R_JOB);;
        ;;  R_JOB->dead = MULAR_NEXT(R_JOB->pids);
        MARK_R_JOB_WENT(R_JOB);;
    }
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_wait %d\n", ex);
    return(ex);
}

int
pgoblin_untrap(pgoblin_exenv *exenv, pgoblin_r *r) {
    exenv->exeflags &= ~PGOBLIN_TRAPDEF;
    return(EX_OK);
}

int
pgoblin_trap(pgoblin_exenv *exenv, pgoblin_r *r) {
    exenv->ctrap = exenv->ppoint + 1,
    exenv->exeflags |= PGOBLIN_TRAPDEF,
    exenv->lexlevel++;
    return(EX_OK);
}

int
pgoblin_call(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_UNAVAILABLE;
    return(ex);
}

int
pgoblin_eval(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;
    pgoblin_prog *pgm = NULL;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_eval %d\n", r[PGO_CCTL].r);
    if  ((ex = pgoblin_parser(exenv->options, IO_CTL->text, IO_CTL->length, &pgm))) {
        ifBLIN_QV1(exenv->options->flags) warn("Parser failed in #eval");
    } else {
        if  (exenv->options->flags & PGOBLIN_VERIFY) pgoblin_Vdump(exenv->options, pgm);
        if  ((ex = pgoblin_execute(exenv->options, pgm, exenv, exenv, 0))) {
            ifBLIN_QV1(exenv->options->flags)
                warn( "cmd[%d]=%03X(%s %c%c%c%c%c%c) %08X %02X %02X %02X %02X %02X %02X "
                      "Executor failed in #eval"
                    , (int)exenv->ppoint, exenv->pgm->code[exenv->ppoint].cmd
                    , pgoblin.a[exenv->pgm->code[exenv->ppoint].cmd].str
                    , pgoblin_regn[r[0].r], pgoblin_regn[r[1].r], pgoblin_regn[r[2].r]
                    , pgoblin_regn[r[3].r], pgoblin_regn[r[4].r], pgoblin_regn[r[5].r]
                    , pgoblin.a[exenv->pgm->code[exenv->ppoint].cmd].flags
                    , r[0].c, r[1].c, r[2].c, r[3].c, r[4].c, r[5].c
                    );
    }   }
    if  (pgm) free(pgm);
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_eval %d\n", ex);
    return(ex);
}

int
pgoblin_close(pgoblin_exenv *exenv, pgoblin_r *r) {
    if  (r[PGO_CCON].r) {
        MARK_R_CONN_GO(R_CONN);;
        ;;  R_CONN->flags &= ~PGOBLIN_CLOSECONN;
        MARK_R_CONN_WENT(R_CONN);;
    }
    return(EX_OK);
}

int
pgoblin_clear(pgoblin_exenv *exenv, pgoblin_r *r) {
    return(EX_OK);
}

static void
exitfin(pgoblin_exenv *exenv, pgoblin_r *r, int ex) {
    int g, f, t;

    f = 0, t = PGOBLIN_REGSIZE;
    if  (r[PGO_CCON].r) {
        f = r[PGO_CCON].r;
        t = f + 1;
    }
    for (g = f; g < t; g++) {
#       define O(G) (exenv->options->conn[G])
        MARK_R_CONN_GO(&O(g));;
        ;;  if  (O(g).flags & PGOBLIN_CLOSECONN)
    /*  ;;  */  DBASE(O(g).flags)->finish(exenv->options->flags, PGOBLIN_Connect, &O(g).conn);
        ;;  O(g).conn = NULL;
        ;;  if  (O(g).flags & PGOBLIN_PARMDBFREE) free(O(g).dbname);
        ;;  O(g).dbname = NULL;
        ;;  O(g).flags = exenv->options->conn[0].flags & PGOBLIN_DB_TYPE;
        ;;  O(g).host = NULL;
        ;;  O(g).port = NULL;
        ;;  O(g).username = NULL;
        ;;  O(g).intran = 0;
        MARK_R_CONN_WENT(&O(g));;
#       undef O
    }
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "pgoblin exit %d\n", ex);
    exit(ex);
}

int
pgoblin_return(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_return\n");
    if  (exenv->exeflags & PGOBLIN_FORKED) exitfin(exenv, r, ex);
    exenv->exeflags |= PGOBLIN_END;
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_return %d\n", ex);
    return(ex);
}

int
pgoblin_exit(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;
    ifBLIN_QV4(exenv->options->flags) {
        fprintf(stderr, "+pgoblin_exit");
        if  (r[PGO_CIN].r) fprintf(stderr, " %d", r[PGO_CCTL].r);
        if  (IO_CTL->text) fprintf(stderr, "=%s~", (char*)(IO_CTL->text));
        fprintf(stderr, "\n");
    }
    if  (IO_CTL->text) ex = strtol(IO_CTL->text, NULL, 0);
    exitfin(exenv, r, ex);
    return(ex);
}

int
pgoblin_begin(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;
    void *res;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_begin\n");
    if  (  !(R_CONN->intran++)
        && !(ex = DBASE(R_CONN->flags)->query(R_CONN, &res, "BEGIN", PGOBLIN_CR_OK))
        ) {
        DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &res);
    }
    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "-pgoblin_begin %d\n", ex);
    return(ex);
}

int
pgoblin_end(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;
    void *res;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_end\n");
    if  (!R_CONN->intran) {
        ifBLIN_QV1(exenv->options->flags) warnx("Non transaction end");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (  !(--R_CONN->intran)
        && !(ex = DBASE(R_CONN->flags)->query(R_CONN, &res, "END", PGOBLIN_CR_OK))
        ) {
        DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &res);
    }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "-pgoblin_end %d\n", ex);
    return(ex);
}

int
pgoblin_listen(pgoblin_exenv *exenv, pgoblin_r *r) {
    int timeout, e, ex = EX_OK;
    int64_t tout;
    char *notify;
    struct timeval t;
    union {
        int64_t itime;
        u_int32_t d[2];
    } dbtime;
    typedef union {
        u_int64_t p;
        u_int32_t d[2];
    } pmatsemit;

    ifBLIN_QV4(exenv->options->flags) {
        fprintf( stderr, "+pgoblin_listen %d %d %d", r[PGO_CCTL].r, r[PGO_CCON].r, r[PGO_CIN].r);
        if  (IO_CTL->text) fprintf( stderr, " =%s~", (char*)(IO_CTL->text));
        fprintf( stderr, "\n");
    }
    if  (!IO_CTL->text) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_listen CTL[%d]: no command", r[PGO_CCTL].r);
        ex = EX_DATAERR;
        errno = EINVAL;
    } else if (!IO_IN->text || (IO_IN->length < sizeof(pmatsemit))) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_listen IN[%d]: no timeout", r[PGO_CIN].r);
        ex = EX_DATAERR;
        errno = EINVAL;
    } else {
        /* Should be 64 bit time wait to in usec from 1970-01-01 00:00:00 UTC          *
         * ((date_part('epoch', t))::int8 * 1000000                                    *
         * +((date_part('second', t) - floor(date_part('second', t))) * 1000000)::int8 *
         * ) , where t - time wait to                                                  *
         *******************************************************************************/
        dbtime.d[1] = ntohl(((pmatsemit*)(IO_IN->text))->d[0]);
        dbtime.d[0] = ntohl(((pmatsemit*)(IO_IN->text))->d[1]);
        for (; !ex;) {
            for (e = 0; (notify = DBASE(R_CONN->flags)->notifies(R_CONN));) {
                ifBLIN_QV4(exenv->options->flags)
                    fprintf(stderr, "Received NOTIFY=%s~\n", notify);
                e = !strcmp(notify, IO_CTL->text);
                DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_FrNote, (void **)&notify);
            }
            if  (e) break;
            if  (gettimeofday(&t, NULL)) {
                ifBLIN_QV1(exenv->options->flags) warn("pgoblin_listen gettimeofday:");
                ex = EX_OSERR;
                break;
            }
            tout = dbtime.itime - ((int64_t)1000000LL * t.tv_sec + t.tv_usec);
            if  (tout <= 0) break;
            else if ((tout / 1000) > exenv->options->maxtmout) {
                timeout = exenv->options->maxtmout;
                dbtime.itime = ((int64_t)1000LL * exenv->options->maxtmout)
                           + ((int64_t)1000000LL * t.tv_sec)
                           + t.tv_usec
                           ;
            } else timeout = tout / 1000;
            ifBLIN_QV4(exenv->options->flags)
                fprintf( stderr, "LISTEN=%s~ for %d ms\n", (char*)IO_CTL->text, timeout);
            if  (DBASE(R_CONN->flags)->tarry(R_CONN, timeout) < 0) {
                ifBLIN_QV1(exenv->options->flags) warn("pgoblin_listen tarry:");
                ex = EX_OSERR;
                break;
    }   }   }
    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "-pgoblin_listen %d\n", ex);
    return(ex);
}

#define L0 0 /* \0           */
#define Ll 1 /*   */
#define Lb 2 /*        */
#define Ls 3 /*    */
#define Ld 4 /* #            */
#define Lo 5 /*     */
#define Lx 6
static const char *clasnames[] =
{ "L0", "Ll", "Lb", "Ls", "Ld", "Lo", "Lx"};

static const u_char class[256] =
{ L0, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lb, Ll, Ll,  Lo, Ll, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lb, Lo, Lo, Ld,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Lo,  Lo, Lo, Lo, Ls
, Lo, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Ls,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Ls,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
, Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls,  Ls, Ls, Ls, Ls
};

static const char *statenames[] =
{ "bg", "bs", "nq", "tc", "tb", "tp", "xx"};

enum states
{ bg /*                                           */
, bs /*                                                 */
, nq /*     ?                       */
, tc /*                           */
, tb /*        */
, tp /*                                       */
, xx
};
static const char *pn[] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "- ", "- ", "Ci", "Cp", "- ", "- ", "Ce", "- "
, "Co", "Cl", "Cf", "- ", "- ", "Cx", "- ", "- "
};

#define Ci  0x200000 /*     */
#define Cp  0x100000 /*               */
#define Ce  0x020000 /*          */
#define Co  0x008000 /*             */
#define Cl  0x004000 /*                 */
#define Cf  0x002000 /*               */
#define Cx  0x000400 /*                    */
#define C_state 0xFF /*           */

static u_int32_t automa[xx][Lx] =
/* \0 L0  \n Ll  \b Lb  Ls   # Ld   * Lo   *    @          */
{{ Cx|xx,    bg,    bs,       bs,    nq,    bs }/* bg @                   */
,{ Cx|xx,    bg,    bs,       bs,    bs,    bs }/* bs @                   */
,{ Cx|xx,    bg,    bs, Co|Cl|tc,    bs,    bs }/* nq @ 1           */
,{ Cx|xx, Cx|xx, Cf|tb,    Cl|tc, Cx|xx, Cx|xx }/* tc              */
,{ Cx|xx, Cx|xx,    tb, Ci|Cp|tp, Cx|xx, Cx|xx }/* tb          */
,{ Cx|xx, Ce|xx, Ce|xx,    Cp|tp, Ce|xx, Ce|xx }/* tp      */
};

int
pgoblin_style(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK, lfcount, i;
    enum states state;
    u_int32_t control;
    size_t offset, b = 0, d = 0;
    u_char s, p, *q;
    int cmp = 0, rs = 0;

    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "+pgoblin_style %d %d %d =%s~\n"
                                             , r[PGO_CCTL].r, r[PGO_CIN].r, r[PGO_CSTY].r
                                             , (char*)(IO_CTL->text)
                                             );
    if  (!r[PGO_CSTY].r) {
        ifBLIN_QV1(exenv->options->flags) warnx("Try to change style 0");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!IO_CTL->text) {
        ifBLIN_QV1(exenv->options->flags) warnx("No pgoblin style name");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!IO_IN->text) {
        ifBLIN_QV1(exenv->options->flags) warnx("No pgoblin style text");
        ERROUT(EX_DATAERR, EINVAL);
    }
    MARK_IO_TEXT_GO(IO_IN);;
    ;;  MARK_IO_MIFE_GO(IO_IN);;
    ;;  ;;  IO_IN->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_FREEMIFE); /* XXXX */
    ;;  MARK_IO_MIFE_WENT(IO_IN);;
    MARK_IO_TEXT_WENT(IO_IN);;
    ifBLIN_QV5(exenv->options->flags) BLIN_STATEHEADER(stderr, pn)
    q = IO_IN->text;
    lfcount = 1;
    for (state = bg, offset = 0, control = 0; state < xx; offset++, state = control & C_state) {
        if  (((IO_IN->flags & PGOBLIN_BINPARM) || IO_IN->length) && (offset >= IO_IN->length)) {
            p = L0;
            s = 0;
        } else {
            s = q[offset];
            p = class[s];
            if  (s == '\n') lfcount++;
        }
        control = automa[state][p];
        ifBLIN_QV5(exenv->options->flags)
            BLIN_STATEBODY(stderr, pn, rs, clasnames[p], q, offset, b, control, statenames, state, C_state, (q[offset + BLIN_STATEVAR_i]>=' '))
        if  (control & Ci) b = offset;
        if  (control & Cp) rs++;
        if  (control & Ce) {
            for (i = 0; i < pgoblin.styletbsz; i++) {
                if  (STYLS(i) && STYLS(i)->name) {
                    if  (!strncmp((char*)&q[b], STYLS(i)->name, rs)) {
                        MARK_R_STYLE_GO(R_STYLE);;
                        ;;  R_STYLE->path = NULL;
                        ;;  R_STYLE->flags = (exenv->options->flags & BLIN_VERMASK) | i;
                        MARK_R_STYLE_WENT(R_STYLE);;
                        if  ((ex = STYLS(R_STYLE->flags)->parser(R_STYLE, &q[b + rs])))
                            ifBLIN_QV1(exenv->options->flags) fprintf(stderr, "style parser fail\n");
                        if  (exenv->options->flags & PGOBLIN_VERIFY)
                            STYLS(R_STYLE->flags)->dump(R_STYLE);
                        goto out;
            }   }   }
            ifBLIN_QV1(exenv->options->flags) fprintf(stderr, "Invalid style interpretor name\n");
            ERROUT(EX_DATAERR, EINVAL);
        }
        if  (control & Co) {
            cmp = 0, d = 0, rs = 0;
        }
        if  (control & Cl) {
            cmp |= (((u_char*)IO_CTL->text)[d++] - q[offset]);
            if  (cmp) control = bs;
        }
        if  (control & Cf) {
            cmp |= ((u_char*)IO_CTL->text)[d++];
            if  (cmp) control = bs;
        }
        if  (control & Cx) {
            ifBLIN_QV1(exenv->options->flags) fprintf(stderr, "Erroneous style\n");
            ERROUT(EX_DATAERR, EINVAL);
    }   }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "-pgoblin_style %d\n", ex);
    return(ex);
}

static const babolo_lexor modsel =
/* 0(FF) - 
 * 1(FE) - 
 * 2(FD) -  
 * 3(FC) -    
 * 4(FB) -   
 */
{ (u_char*)class, NULL, Bpars_AABS, 0x07, 0x07, 1
, { /*00*/ 1, L0,0xFE, Ls,0x03, 0xFF
  , /*03*/ 2, L0,0xFD, Ls,0x03, Lb,0xFB, 0xFC
} };

int
pgoblin_connect(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK, i;
    char *q;

    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "+pgoblin_connect %d %d =%s~\n"
                                             , r[PGO_CCTL].r, r[PGO_CCON].r
                                             , (char*)(IO_CTL->text)
                                             );
    if  (!(q = IO_CTL->text)) {
        ifBLIN_QV2(exenv->options->flags) warnx("Empty DB #1");
        goto out;
    }
    switch(babolo_goword(&modsel, (const u_char**)&q)) {
    case 0 : ifBLIN_QV1(exenv->options->flags) warnx("Illegal DB");
           ; ERROUT(EX_DATAERR, EINVAL);
    case 1 : ifBLIN_QV2(exenv->options->flags) warnx("Empty DB #2");
           ; goto out;
    case 3 : ifBLIN_QV2(exenv->options->flags) warnx("Illegal DB separator");
           ; *--q = '\0';
           ; /* FALLTHRU */
    case 2 : q = NULL;
           ; break;
    case 4 : *--q = '\0';
           ; q++;
           ; break;
    default: ifBLIN_QV1(exenv->options->flags) warnx("Internal error");
           ; ERROUT(EX_SOFTWARE, EINVAL);
    }
    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "db=%s%s%s~\n", (char*)IO_CTL->text, q ? "~\nparm=" : "", q ? q : "");
    for (i = 0; i < pgoblin.dbtablesz; i++) {
        ifBLIN_QV4(exenv->options->flags)
            if  (DBASE(i)) fprintf(stderr, "db?=%s~\n", DBASE(i)->name);
        if  (DBASE(i) && DBASE(i)->name) {
            if  (!strcmp(IO_CTL->text, DBASE(i)->name)) {
                u_int32_t nwflags = PGOBLIN_PARMIN;

                if  (!q) {
                } else if (!*q) {
                    q = "";
                } else if (IO_CTL->flags & PGOBLIN_FREETEXT) {
                    if  (!(q = strdup(q))) {
                        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_connect: no mem");
                        ERROUT(EX_OSERR, ENOMEM);
                    }
                    nwflags |= PGOBLIN_PARMDBFREE;
                }
                MARK_R_CONN_GO(R_CONN);;
                ;;  R_CONN->flags = (exenv->options->flags & BLIN_VERMASK) | nwflags | i;
                ;;  R_CONN->dbname = q;
                MARK_R_CONN_WENT(R_CONN);;
                goto out;
    }   }   }
    ifBLIN_QV1(exenv->options->flags) fprintf(stderr, "Invalid DBMS name %s\n", (char*)IO_CTL->text);
    ERROUT(EX_DATAERR, EINVAL);
out:
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_connect %d\n", ex);
    return(ex);
}

int
pgoblin_job(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK, i;
    char *q;

    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "+pgoblin_job %d %d =%s~\n"
                                             , r[PGO_CCTL].r, r[PGO_CCON].r
                                             , (char*)(IO_CTL->text)
                                             );
    if  (!(q = IO_CTL->text)) {
        ifBLIN_QV2(exenv->options->flags) warnx("Empty JOB #1");
        goto out;
    }
    switch(babolo_goword(&modsel, (const u_char**)&q)) {
    case 0 : ifBLIN_QV1(exenv->options->flags) warnx("Illegal JOB");
           ; ERROUT(EX_DATAERR, EINVAL);
    case 1 : ifBLIN_QV2(exenv->options->flags) warnx("Empty JOB #2");
           ; goto out;
    case 3 : ifBLIN_QV2(exenv->options->flags) warnx("Illegal JOB separator");
           ; *--q = '\0';
           ; /* FALLTHRU */
    case 2 : q = NULL;
           ; break;
    case 4 : *--q = '\0';
           ; q++;
           ; break;
    default: ifBLIN_QV1(exenv->options->flags) warnx("Internal error");
           ; ERROUT(EX_SOFTWARE, EINVAL);
    }
    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "job=%s%s%s~\n", (char*)IO_CTL->text, q ? "~\nparm=" : "", q ? q : "");
    for (i = 0; i < pgoblin.jobtabsiz; i++) {
        ifBLIN_QV4(exenv->options->flags)
            if  (JOBE(i)) fprintf(stderr, "job?=%s~\n", JOBE(i)->name);
        if  (JOBE(i) && JOBE(i)->name) {
            if  (!strcmp(IO_CTL->text, JOBE(i)->name)) {
                u_int32_t u = 0, nwflags = 0;
                babolo_parm *bp;
                babolo_opt *opt = NULL;
                int c;

                ifBLIN_QV5(exenv->options->flags) fprintf(stderr, "opt=%s~\n", q);
                bp = babolo_getparm(Bpars_NOEN | Bpars_NOAL, (u_char**)&q, (u_char*)"", 0);
                opt = NULL;
                if  (bp) {
                    if  (babolo_openopt(0, &opt, bp->argc, (char **)bp->argv, "zZ")) {
                        ifBLIN_QV1(exenv->options->flags) warn("openopt");
                        ex = EX_SOFTWARE;
                        goto out;
                    }
                    for (; (c = babolo_getopt(&opt)) != 0;) {
                        switch (c) {
                        case 'z': nwflags |= (nwflags & PGOBLIN_ERROR_SENSOR) << 1;
                                ; nwflags |= PGOBLIN_ERROR_SENSOR;
                                ; break;
                        case 'Z': nwflags &= ~(PGOBLIN_ERROR_SENSIB | PGOBLIN_ERROR_SENSOR);
                                ; break;
                        default : ;
                }   }   }
                ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "nwflags=%08X\n", nwflags);
                if  ((q = babolo_getarg(&opt)) && *q) u = strtoul(q, NULL, 0);
                if  ((R_JOB->flags & PGOBLIN_JOB_TYPE) == i) {
                    u_int32_t svflags = R_JOB->flags & ~(BLIN_VERMASK | PGOBLIN_ERROR_SENSIB | PGOBLIN_ERROR_SENSOR);

                    MARK_R_JOB_GO(R_JOB);;
                    ;;  R_JOB->flags = (exenv->options->flags & BLIN_VERMASK) | svflags | nwflags;
                    ;;  R_JOB->concur = u;
                    MARK_R_JOB_WENT(R_JOB);;
                } else {
                    ex = JOBE(R_JOB->flags)->close(exenv, r);
                    MARK_R_JOB_GO(R_JOB);;
                    ;;  mular_destroy(R_JOB->pids);
                    ;;  R_JOB->pids = NULL;
                    ;;  R_JOB->host = NULL;
                    ;;  R_JOB->concur = u;
                    ;;  R_JOB->dead = 0;
                    ;;  R_JOB->flags = (exenv->options->flags & BLIN_VERMASK) | nwflags | i;
                    MARK_R_JOB_WENT(R_JOB);;
                    ifBLIN_QV1(exenv->options->flags & ex) warn("Close JOB in #job");
                }
                JOBE(R_JOB->flags)->open(exenv, r, opt);
                goto out;
    }   }   }
    ifBLIN_QV1(exenv->options->flags) fprintf(stderr, "Invalid JOBE name %s\n", (char*)IO_CTL->text);
    ERROUT(EX_DATAERR, EINVAL);
out:
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_job %d\n", ex);
    return(ex);
}
