/*-
 * Copyright (C) @BABOLO  2002 Dec 23
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 23\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: vdump.c,v 1.17 2009/10/23 22:27:10 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <limits.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <mife.h>
#include <err.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include "pgoblin.h"
#include "pgob.h"

const char pgoblin_regn[] =
"0123456789"
"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
"abcdefghijklmnopqrstuvwxyz"
"_-"
;

void
pgoblin_Vdump(pgoblin_main *options, pgoblin_prog *pgm) {
    ssize_t p;
    int i;
    u_int32_t t, cmd;
    char *lit;

    ifBLIN_QV4(options->flags) {
        if  (pgm) fprintf(stderr, "+pgoblin_Vdump pgm=%d\n", (int)pgm->curr);
          else fprintf( stderr, "+pgoblin_Vdump pgm=NULL\n");
    }
    printf("+######################################");
    for (p = 0; p < PGOBLIN_STRING_ID_LEN && pgm->id[p]; p++) printf("%c", pgm->id[p]);
    for (p = 0; p < pgm->curr; p++) {
        t = pgm->code[p].cmd;
        cmd = t & PGOBLIN_COMMAND;
        if  (cmd == PGOBLIN_extended) {
            cmd = (pgm->code[p].e.cmd & PGOBLIN_COMMAND) | PGOBLIN_EXTENDED;
            lit = NULL;
        } else {
            lit = pgm->code[p].e.lit;
        }
        if  (cmd >= pgoblin.max && !(~pgoblin.a[cmd].flags & PGOBLIN_ILLEGAL)) {
            printf("\n#ILLEGAL ");
        } else {
            printf("\n#%s ", pgoblin.a[cmd].str);
        }
        t >>= 2;
        for (i = 0; i < pgoblin.binparam; i++)
            printf("%c", pgoblin_regn[(t >>= PGOBLIN_BPARG) & PGOBLIN_ARGMASK]);
        printf(" ([%d]=%03X)", (int)p, cmd);
        if  (lit) printf("\n%s", pgm->code[p].e.lit);
    }
    printf("\n-######################################\n");
    ifBLIN_QV4(options->flags) fprintf(stderr, "-pgoblin_Vdump\n");
};

void
pgoblin_VVdump() {
    int i;

    printf( "SYMREGS=%d BINREGS=%d PGOBLIN_max=%03X\n"
          , (int)pgoblin.symparam, (int)pgoblin.binparam, pgoblin.max
          );
    for (i = 0; i < pgoblin.binparam; i++)
        printf("ARG%dS=%d%s", i + 1, pgoblin.binparams[i], (i + 1 < pgoblin.binparam) ? " " : "\n");
    printf("sym val bin mask name\n");
    for (i = 0; i < pgoblin.symparam; i++)
        printf( " %02X  %02X %s%2d %4d %s\n"
              , pgoblin.p[i].sym
              , pgoblin.p[i].val
              , (pgoblin.p[i].bin < 0) ? "~" : " "
              , (pgoblin.p[i].bin < 0) ? ~pgoblin.p[i].bin : pgoblin.p[i].bin
              , pgoblin.p[i].mask
              , pgoblin.p[i].name
              );
    printf("      flags     car   str\n");
    for (i = 0; i < pgoblin.max; i++) printf( "%03X %08X %" BLIN_X "%s%s%s\n"
                                            , i
                                            , pgoblin.a[i].flags
                                            , BLIN_I(pgoblin.a[i].car)
                                            , (pgoblin.a[i].str) ? " =" : ""
                                            , (pgoblin.a[i].str) ? pgoblin.a[i].str : ""
                                            , (pgoblin.a[i].str) ? "~" : ""
                                            );
}
