/*-
 * Copyright (C) @BABOLO  2002 Dec 04
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: pgoblin.h,v 1.79 2009/11/05 01:15:33 babolo Exp $
 */

#ifndef _PGOBLIN_H_
#define _PGOBLIN_H_

__BEGIN_DECLS

#define PGOBLIN_REGSIZE   64
#define PGOBLIN_PROGSIZE  16383
#define PGOBLIN_DBTABLESZ 16
#define PGOBLIN_STYLETBSZ 16
#define PGOBLIN_JOBTABSIZ 16
#define PGOBLIN_MIFEFLAGS MIFE_FULL
#define PGOBLIN_DB_0      0
#ifdef HAVE_DB_PGSQL
#define PGOBLIN_DB_PGSQL  1
#endif
#ifdef HAVE_DB_SQLITE2
#define PGOBLIN_DB_SQLIT2 2
#endif
#ifdef HAVE_DB_SQLITE3
#define PGOBLIN_DB_SQLIT3 3
#endif

/************************************************************************************/
/* For pgoblin_io.flags                                                             */
/* + used                                                                           */
/* # used and stay from cycle to cycle                                              */
/* : write only (with something else)                                               */
/* - no room for                                                                    */
#define  PGOBLIN_EMPTY     0x000000
/*            For         pgoblin_syntax.ch[]  pgoblin_syntax.a[].flags             */
/*                                         \    /                                   */
/*               pgoblin_io.flags ---\      |  |      /--- pgoblin_exeparm.exeflags */
/*                                     \    |  |    /                               */
#define  PGOBLIN_PATHPARM  0x000001  /*  +  +     :  * Pf                           */
#define  PGOBLIN_ISIN      0x000001  /*        +     * IN used                      */
#define  PGOBLIN_TEXTPARM  0x000002  /*  +  +     :  * Pt                           */
#define  PGOBLIN_MIFEDES   0x000004  /*  +  +     :  * Pm                           */
#define  PGOBLIN_CTL       0x000004  /*        +     * CTL used                     */
#define  PGOBLIN_PQRESULT  0x000008  /*  +  +     :  * Pq                           */
#define  PGOBLIN_OUTSET    0x000010  /*  +  +  +  -  * Po, OUT used                 */
#define  PGOBLIN_BINPARM   0x000020  /*  +           * Pt is binary                 */
#define  PGOBLIN_CONNECT   0x000020  /*     +  +     * CONN used                    */
#define  PGOBLIN_FORKOUT   0x000020  /*           +  * fork for OUT                 */
#define  PGOBLIN_JOB       0x000040  /*     +  +     * JOB used                     */
#define  PGOBLIN_FORKIN    0x000040  /*           +  * fork for IN                  */
#define  PGOBLIN_STYLE     0x000080  /*     +  +     * STYLE used                   */
#define  PGOBLIN_FORKCTL   0x000080  /*           +  * fork for CTL                 */
#define  PGOBLIN_ANYIVL    (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_MIFEDES | PGOBLIN_PQRESULT)
/**** First byte ends ****/
#define  PGOBLIN_EXTENDED  0x000100  /*     -  +     * extended command             */
#define  PGOBLIN_FORKED    0x000800  /*     -  +  #  *                              */
#define  PGOBLIN_STYLEN    0x003000  /*     -  +     * phys addr of R_STYLE         */
#define  PGOBLIN_TRAPDEF   0x001000  /*     -     #  *                              */
#define  PGOBLIN_END       0x004000  /*     -     #  *                              */
#define  PGOBLIN_ERROR     0x008000  /*     -     #  *                              */
#define  PGOBLIN_EXTABLE   0x00FF00  /*     -     #  *                              */
/**** Second byte ends ****/
#define  PGOBLIN_FREEPATH  0x010000  /*  +  -     +  * free() Pf after using        */
#define  PGOBLIN_FREETEXT  0x020000  /*  +  -     +  * free() Pt after using        */
#define  PGOBLIN_FREEMIFE  0x040000  /*  +  -        * free() Pm after using        */
#define  PGOBLIN_FREEPQRE  0x080000  /*  +  -     +  * free() Pq after using        */
#define  PGOBLIN_FREEOUTS  0x100000  /*  +  -        * free() Po after using        */
#define  PGOBLIN_LEXLVUP   0x100000  /*     -  +     *                              */
#define  PGOBLIN_FILEOVER  0x200000  /*  +  -        *                              */
#define  PGOBLIN_LEXLDOWN  0x200000  /*     -  +     *                              */
#define  PGOBLIN_OPEN      0x200000  /*     -     +  *                              */
#define  PGOBLIN_NOLITER   0x400000  /*     -  +     *                              */
#define  PGOBLIN_CHILD     0x400000  /*     -     +  *                              */
#define  PGOBLIN_IGNORE    0x800000  /*     -  +  +  *                              */
#define  PGOBLIN_ILLEGAL   (PGOBLIN_IGNORE | PGOBLIN_NOLITER)
/**** Third byte ends ****/

/***************************/
/* pgoblin's command codes */
/***************************/

typedef enum pgoblin_command
{ PGOBLIN_extended   = 0x00
, PGOBLIN_null       = 0x01
, PGOBLIN_cont       = 0x02
, PGOBLIN_bang       = 0x03

, PGOBLIN_connect    = 0x10
, PGOBLIN_listen     = 0x11
, PGOBLIN_exec       = 0x12
, PGOBLIN_trap       = 0x13
, PGOBLIN_call       = 0x14
, PGOBLIN_eval       = 0x15
, PGOBLIN_style      = 0x16
, PGOBLIN_job        = 0x17
, PGOBLIN_echo       = 0x18
, PGOBLIN_file       = 0x19
, PGOBLIN_cat        = 0x1A
, PGOBLIN_exit       = 0x1B

, PGOBLIN_perform    = 0x20
, PGOBLIN_binpresel  = 0x21
, PGOBLIN_select     = 0x22
, PGOBLIN_binselect  = 0x23
, PGOBLIN_strselect  = 0x24
, PGOBLIN_copyin     = 0x28
, PGOBLIN_copyout    = 0x29
, PGOBLIN_getstr     = 0x2A
, PGOBLIN_getdir     = 0x2B

, PGOBLIN_begin   = PGOBLIN_EXTENDED | 0x00
, PGOBLIN_end     = PGOBLIN_EXTENDED | 0x01
, PGOBLIN_fork    = PGOBLIN_EXTENDED | 0x02
, PGOBLIN_wait    = PGOBLIN_EXTENDED | 0x03

, PGOBLIN_return  = PGOBLIN_EXTENDED | 0x05
, PGOBLIN_display = PGOBLIN_EXTENDED | 0x06
, PGOBLIN_pipe    = PGOBLIN_EXTENDED | 0x07
, PGOBLIN_close   = PGOBLIN_EXTENDED | 0x08
, PGOBLIN_clear   = PGOBLIN_EXTENDED | 0x09
, PGOBLIN_untrap  = PGOBLIN_EXTENDED | 0x0A

, PGOBLIN_getarg  = PGOBLIN_EXTENDED | 0x10
, PGOBLIN_getenv  = PGOBLIN_EXTENDED | 0x11
, PGOBLIN_getget  = PGOBLIN_EXTENDED | 0x12
, PGOBLIN_getpost = PGOBLIN_EXTENDED | 0x13
, PGOBLIN_getproc = PGOBLIN_EXTENDED | 0x14
, PGOBLIN_getjob  = PGOBLIN_EXTENDED | 0x15
, PGOBLIN_getspq  = PGOBLIN_EXTENDED | 0x16
, PGOBLIN_max     = PGOBLIN_EXTENDED | 0x17
} pgoblin_command;

typedef u_int32_t pgoblin_cmd;
#define PGOBLIN_COMMAND 0x000000FF
#define PGOBLIN_ARG1    0x00003F00
#define PGOBLIN_ARG2    0x000FC000
#define PGOBLIN_ARG3    0x03F00000
#define PGOBLIN_ARG4    0xFC000000
#define PGOBLIN_ARGMASK 0x0000003F
#define PGOBLIN_BPARG   6           /* Bits per argument */
#define PGOBLIN_ARG1S   8           /* 1st arg shift     */
#define PGOBLIN_ARG2S   14          /* 2nd arg shift     */
#define PGOBLIN_ARG3S   20          /* 3rd arg shift     */
#define PGOBLIN_ARG4S   26          /* 4th arg shift     */

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_prog                                                    *
 *                                                                                                   *
 *****************************************************************************************************/
typedef struct pgoblin_tuple {
    pgoblin_cmd cmd;                         /*                                               */
    union {
        char       *lit;                     /*                              */
        ssize_t     sts;                     /*                           */
        pgoblin_cmd cmd;                     /*                                    */
    }           e;
} pgoblin_tuple;

typedef struct pgoblin_prog {
#   define        PGOBLIN_STRING_ID_LEN 16
#   define        PGOBLIN_STRING_ID_TST 11
    char          id[PGOBLIN_STRING_ID_LEN]; /*  "#pGoblin"     ASCII             */
    void         *debug;                     /*   -                        */
    ssize_t       maxx;                      /*                                 */
    ssize_t       curr;                      /*   pgoblin_t                           */
    u_int32_t     flags;
    pgoblin_tuple code[1];                   /*                                       */
} pgoblin_prog;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_io                                                      *
 *                                                                                                   *
 *****************************************************************************************************/
typedef struct pgoblin_io {
    u_int32_t        flags;
    void            *text;
    char            *path;
    size_t           length;                       /*   text                               */
    off_t            offset;
    pid_t            pid;                          /* ,    mife        */
    mife_descriptor *mife;
    void            *pq;
    u_int32_t        flagc;                        /*  pgoblin_conn.flags ( pq)              */
    int            (*wri)(int onu, const void *buf, size_t size);
    int            (*clo)(int onu);
    int              onu;
} pgoblin_io;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_conn                                                    *
 *                                                                                                   *
 *****************************************************************************************************/
typedef struct pgoblin_conn {
    char            *dbname;   /* For libpq         */
    char            *host;     /* For libpq         */
    char            *port;     /* For libpq         */
    char            *username; /* For libpq         */
    void            *conn;
    u_int32_t        flags;
#   define           PGOBLIN_DB_TYPE      0x00000F
#   define           PGOBLIN_PARMDBFREE   0x004000 /* Free DB parms when pgoblin_conn destoyed       */
#   define           PGOBLIN_PARMIN       0x008000 /* Parms in dbname                                */
#   define           PGOBLIN_INT64TIME    0x010000 /* DB known to have int64 timestamp               */
#   define           PGOBLIN_FLOATTIME    0x020000 /* DB known to have float timestamp               */
#   define           PGOBLIN_NEEDINTIME   0x040000 /* Ask DB for timestamp format                    */
#   define           PGOBLIN_CLOSECONN    0x080000 /* Close this connection on exit                  */
/*  define           PGOBLIN_ERROR_SENSOR 0x400000    Eror reaction                                  */
/*  define           PGOBLIN_ERROR_SENSIB 0x800000    Immediate error reaction                       */
/*                   BLINflag                         copied from pgoblin_main                       */
    u_char           intran;   /* Transaction level */
} pgoblin_conn;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_jobreg                                                  *
 *                                                                                                   *
 *****************************************************************************************************/
typedef struct pgoblin_jobreg {
#ifdef _MULTILAR_H_
    mular_descriptor*pids;                         /* Child processes register set                   */
#else
    void            *pids;
#endif
    char            *host;
    u_int32_t        flags;
#   define           PGOBLIN_JOB_TYPE     0x00000F
#   define           PGOBLIN_HOSTJFREE    0x004000 /* Free job host when pgoblin_jobreg destoyed     */
#   define           PGOBLIN_INITED       0x040000 /* initialisedsed                                 */
#   define           PGOBLIN_KQUEUED      0x080000 /* kq created and used                            */
#   define           PGOBLIN_ERROR_SENSOR 0x400000 /* Eror reaction                                  */
#   define           PGOBLIN_ERROR_SENSIB (PGOBLIN_ERROR_SENSOR << 1) /* Immediate error reaction    */
/*                   BLINflag                         copied from pgoblin_main                       */
    u_int32_t        concur;
    u_int32_t        dead;
    int              kq;
} pgoblin_jobreg;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_styreg                                                  *
 *                                                                                                   *
 *****************************************************************************************************/
typedef struct pgoblin_styreg {
    char            *path;
    void            *style;
    u_int32_t        flags;
#   define           PGOBLIN_STYLE_TYPE   0x00000F
/*                   BLINflag                         copied from pgoblin_main                       */
} pgoblin_styreg;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_main                                                    *
 *                                                                                                   *
 *****************************************************************************************************/
typedef struct pgoblin_main {
    u_int32_t        flags;
#   define           PGOBLIN_FORK_WAIT    0x0000FF /* Child waits after fork                         */
#   define           PGOBLIN_VERIFY       0x000100 /* Verify analizer and dump parsed program        */
#   define           PGOBLIN_COPEND_PASS  0x000200 /* Pass through unconsumed end of file            */
#   define           PGOBLIN_COPEND_APND  0x000400 /* Append EOF marker to COPY out file             */
/*  define           PGOBLIN_ERROR_SENSOR 0x400000    Eror reaction                                  */
/*  define           PGOBLIN_ERROR_SENSIB 0x800000    Immediate error reaction                       */
#   define           PGOBLIN_CLEAR_ONEXIT 0x010000 /* clear registers on exit                        */
#   define           PGOBLIN_ARGVSTACK    0x020000 /* #getarg from stack                             */
#   define           PGOBLIN_DEFAULDB     0x040000 /* 0 reg DBMS to any on clear                     */
#   define           PGOBLIN_OLDSTYLE     0x080000 /* Redirect execed output to 0 reg_in             */
    char             vers[4];                      /* Version                                        */
    u_char           delim[4];                     /* Delimiter                                      */
    size_t           sp;                           /* File names stack pointer                       */
    size_t           ap;                           /* argv stack pointer                             */
    char           **stack;                        /* File names stack                               */
    u_int32_t        maxtmout;                     /* Max timeout for LISTEN                         */
    pgoblin_io       io   [PGOBLIN_REGSIZE];       /* I/O register set                               */
    pgoblin_conn     conn [PGOBLIN_REGSIZE];       /* Connections register set                       */
    pgoblin_jobreg   job  [PGOBLIN_REGSIZE];
    pgoblin_styreg   style[PGOBLIN_REGSIZE];       /* Styles register set                            */
    char           **argv;
    char           **envp;
    int              pip0[2];
    int              pip1[2];
    int              pip2[2];
} pgoblin_main;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_exenv                                                   *
 *                                                                                                   *
 *****************************************************************************************************/
struct pgoblin_exenv;
typedef struct pgoblin_exenv pgoblin_exenv;

struct pgoblin_exenv {
    pgoblin_main    *options;                      /* Interpretator's data state                     */
    pgoblin_exenv   *stat;                         /* Parent in static call chain                    */
    pgoblin_exenv   *dyna;                         /* Parent in dynamic call chain                   */
    pgoblin_exenv   *next;                         /* Child in dynamic call chain                    */
    pgoblin_prog    *pgm;                          /* Programm                                       */
    ssize_t          ppoint;                       /* Programm counter                               */
    ssize_t          ctrap;                        /*    trap                      */
    int              lexlevel;                     /* To skip nested blocks                          */
    int              sequen;                       /*                 */
    u_int32_t        exeflags;
};

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_jobl                                                    *
 *                                                                                                   *
 *****************************************************************************************************/
typedef struct pgoblin_jobl {
    ssize_t          cmdn;
    pid_t            pid;
    int              status;
#   define           PGOBLIN_NOSTATUS (-1)
#   define           PGOBLIN_LOSTSTAT 0x00010000
} pgoblin_jobl;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_r                                                       *
 *                                                                                                   *
 *****************************************************************************************************/
typedef struct pgoblin_r {
    union {
        pgoblin_io        *io;
        pgoblin_conn      *c;
        pgoblin_jobreg    *j;
        pgoblin_styreg    *s;                      /* style                                          */
    }         g;                                   /*                                 */
    int       r;                                   /*                            */
    u_int32_t c;                                   /*  a_cmd->ch                                */
} pgoblin_r;

/*****************************************************************************************************
 *                                                                                                   *
 *                                   pgoblin_syntax                                                  *
 *                                                                                                   *
 *****************************************************************************************************/
struct pgoblin_dbases;
typedef struct pgoblin_dbases pgoblin_dbases;

typedef enum pgoblin_cmdres
{ PGOBLIN_CR_OK   =  0
, PGOBLIN_CR_TUPL =  1
, PGOBLIN_CR_OUT  =  2
, PGOBLIN_CR_IN   =  3
, PGOBLIN_CR_SSEL =  4
, PGOBLIN_CR_BSEL =  5
, PGOBLIN_CR_MAX  =  6
, PGOBLIN_Ntuples =  7
, PGOBLIN_Nfields =  8
, PGOBLIN_IsNull  =  9
, PGOBLIN_Length  = 10
, PGOBLIN_BinForm = 11
, PGOBLIN_TypeOid = 12
, PGOBLIN_TypeNm  = 13
, PGOBLIN_TypeMod = 14
, PGOBLIN_Nchange = 15
, PGOBLIN_LastOid = 16
, PGOBLIN_ColName = 17
, PGOBLIN_CmdStat = 18
, PGOBLIN_Connect = 19
, PGOBLIN_PFormed = 20
, PGOBLIN_FrCOPY  = 21
, PGOBLIN_FrNote  = 22
, PGOBLIN_CleaRes = 23
, PGOBLIN_ResMess = 25
, PGOBLIN_FrMess  = 26
, PGOBLIN_ALTERQ  = 0x80
} pgoblin_cmdres;

struct pgoblin_dbases {
    u_int32_t   flags;
#   define PGOBLIN_DB_PREPARE  0x800000
#   define PGOBLIN_DB_COPYIN   0x400000
#   define PGOBLIN_DB_COPYOUT  0x200000
    char           id[PGOBLIN_STRING_ID_LEN];
    char         name[PGOBLIN_STRING_ID_LEN];
    int        (*init)(u_int32_t flags, pgoblin_dbases *this);
    int        (*fini)(u_int32_t flags, pgoblin_dbases *this);
    int    (*shurecon)(pgoblin_conn *db);
    int       (*query)(pgoblin_conn *db, void **res, const char *query, u_char cond);
    int     (*prepare)(pgoblin_conn *db, void **qp, const char *query);
    int     (*execute)( pgoblin_conn *db, void **res, const void *qp
                      , int cnt, const char * const *val, const int *len, u_char cond
                      );
    int     (*resinfo)(int kind, void *res);
    char   *(*subinfo)(int kind, void *res, int sub);
    int     (*valinfo)(int kind, void *res, int row, int col);
    char  *(*getvalue)(void *res, int row, int col);
    int   (*getstream)(pgoblin_conn *db, void **res, int quant, u_char cond);
    int     (*getcopy)(pgoblin_conn *db, void **buf);
    int     (*putcopy)(pgoblin_conn *db, const void *buf, int len);
    int   (*endstream)(pgoblin_conn *db, u_char cond);
    int       (*tarry)(pgoblin_conn *db, int timeout);
    char  *(*notifies)(pgoblin_conn *db);
    int      (*finish)(u_int32_t flags, int kind, void **entity);
};

typedef struct pgoblin_dir {
    void      *dirp;
    int           i; /*   ,                */
    int           f; /*          */
    int           g; /* 1 -  ; 0 -                         */
    char       *ent;
    struct stat *sb;
} pgoblin_dir;

struct pgoblin_jobs;
typedef struct pgoblin_jobs pgoblin_jobs;

struct pgoblin_jobs {
    u_int32_t    flags;
    char            id[PGOBLIN_STRING_ID_LEN];
    char          name[PGOBLIN_STRING_ID_LEN];
    int         (*init)(u_int32_t flags, pgoblin_jobs *this);
    int         (*fini)(u_int32_t flags, pgoblin_jobs *this);
    int         (*open)(pgoblin_exenv *exenv, pgoblin_r *r, void *opt);
    u_int32_t   (*test)(pgoblin_command cmd);
#   define    PGOBLIN_TOFORK    0x000800  /*              */
#   define    PGOBLIN_TVFORK    0x000400  /*    exec */
#   define    PGOBLIN_TOEXIT    0x000200  /*      */
    int         (*fork)(pgoblin_exenv *exenv, pgoblin_r *r);
    int         (*exec)(pgoblin_exenv *exenv, pgoblin_r *r, char **argv);
    int         (*wait)(pgoblin_exenv *exenv, pgoblin_r *r);
    int        (*close)(pgoblin_exenv *exenv, pgoblin_r *r);
    pgoblin_dir *(*dir)(pgoblin_exenv *exenv, pgoblin_dir *dir, char *path);
};

struct pgoblin_styles;
typedef struct pgoblin_styles pgoblin_styles;

struct pgoblin_styles {
    u_int32_t    flags;
    char       id[PGOBLIN_STRING_ID_LEN];
    char     name[PGOBLIN_STRING_ID_LEN];
    int    (*init)(u_int32_t flags, pgoblin_styles *this);
    int    (*fini)(u_int32_t flags, pgoblin_styles *this);
    int  (*parser)(pgoblin_styreg *reg_style, u_char *in);
    void   (*dump)(pgoblin_styreg *reg_style);
    int    (*free)(pgoblin_styreg *reg_style);
    char   *(*get)(pgoblin_styreg *reg_style, u_char *stringname);
    int   (*table)( pgoblin_io    *reg_out
                  , pgoblin_styreg*reg_style
                  , pgoblin_io    *reg_in
                  , ssize_t        low
                  , ssize_t        hig
                  );
};

typedef struct pgoblin_syntax {
    ssize_t             dbtablesz;
    ssize_t             jobtabsiz;
    ssize_t             styletbsz;
    ssize_t             symparam;
#   define PGOBLIN_SYMREGS 6
    ssize_t             binparam;
#   define PGOBLIN_BINREGS 4
    pgoblin_command     max;
    pgoblin_dbases    **dbasetable;
    pgoblin_jobs      **jobtable;
    pgoblin_styles    **styletable;
    const char        **clasnames;
    const char         *class;
    const babolo_lexor *cmds;
    const babolo_lexor *sqlkeywords;
    int8_t              binparams[PGOBLIN_BINREGS];
    struct {
        u_int8_t            sym;
        u_int8_t            val;
        int8_t              bin;
        u_int8_t            mask;
        char               *name;
    }                   p[PGOBLIN_SYMREGS];
    struct pgoblin_syntax_a {
        u_int32_t           flags;
        u_int8_t            ch[PGOBLIN_BINREGS];
        int               (*car)(pgoblin_exenv *exenv, pgoblin_r *r);
        char               *str;
    }                   a[PGOBLIN_max];
} pgoblin_syntax;

extern const pgoblin_syntax pgoblin;
extern const char pgoblin_regn[PGOBLIN_REGSIZE];

pgoblin_main *pgoblin_init __P((u_int32_t flags, int outfd));
int         pgoblin_parser __P((pgoblin_main *options, u_char *text, size_t len, pgoblin_prog **ppgm));
void         pgoblin_Vdump __P((pgoblin_main *options, pgoblin_prog *pgm));
void        pgoblin_VVdump __P(());
void          pgoblin_fini __P((pgoblin_main *options));
int        pgoblin_execute __P(( pgoblin_main *options
                               , pgoblin_prog *pgm
                               , pgoblin_exenv *dexenv
                               , pgoblin_exenv *sexenv
                               , ssize_t pp
                              ));

__END_DECLS

#endif /* !_PGOBLIN_H_ */
