/*-
 * Copyright (C) @BABOLO  2002 Dec 04
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 04\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pgoblin.c,v 1.46 2009/11/05 01:15:33 babolo Exp $";
#endif /* not lint */

#define _PGOBLIN_CHAR_CLASSES_ 1
#include <sys/types.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <mife.h>
#include <err.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include "pgoblin.h"
#include "pgob.h"

static void
pgoblin_verify(pgoblin_main *options) {
    int i;
    u_int32_t m;
    pgoblin_command cmd;

    for (i = 0; i <= (PGOBLIN_ANYIVL | PGOBLIN_OUTSET); i++) {
        printf( "%c%s%s%s%s%s\n"
              , pgoblin_regn[i]
              , (i & PGOBLIN_PATHPARM) ? " path"  : ""
              , (i & PGOBLIN_TEXTPARM) ? " text"  : ""
              , (i & PGOBLIN_MIFEDES ) ? " mife"  : ""
              , (i & PGOBLIN_PQRESULT) ? " pq"    : ""
              , (i & PGOBLIN_OUTSET  ) ? " out"   : ""
              );
    }
    if  (pgoblin.symparam != PGOBLIN_SYMREGS) {
        printf("!!! pgoblin.symparam=%d <> SYMREGS=%d\n", (int)pgoblin.symparam, PGOBLIN_SYMREGS);
    }
    if  (pgoblin.binparam != PGOBLIN_BINREGS) {
        printf("!!! pgoblin.binparam=%d <> BINREGS=%d\n", (int)pgoblin.binparam, PGOBLIN_BINREGS);
    }
    if  (pgoblin.max != PGOBLIN_max) {
        printf("!!! pgoblin.max=%d <> PGOBLIN_max=%d\n", pgoblin.max, PGOBLIN_max);
    }
    if  (pgoblin.binparams[0] != PGOBLIN_ARG1S) {
        printf( "!!! pgoblin.binparams[0]=%d <> PGOBLIN_ARG1S=%d\n"
              , pgoblin.binparams[0], PGOBLIN_ARG1S
              );
    }
    if  (pgoblin.binparams[1] != PGOBLIN_ARG2S) {
        printf( "!!! pgoblin.binparams[1]=%d <> PGOBLIN_ARG2S=%d\n"
              , pgoblin.binparams[1], PGOBLIN_ARG2S
              );
    }
    if  (pgoblin.binparams[2] != PGOBLIN_ARG3S) {
        printf( "!!! pgoblin.binparams[2]=%d <> PGOBLIN_ARG3S=%d\n"
              , pgoblin.binparams[2], PGOBLIN_ARG3S
              );
    }
    if  (pgoblin.binparams[3] != PGOBLIN_ARG4S) {
        printf( "!!! pgoblin.binparams[3]=%d <> PGOBLIN_ARG4S=%d\n"
              , pgoblin.binparams[3], PGOBLIN_ARG4S
              );
    }
    for (i = 1; i < pgoblin.binparam; i++) {
        if  (pgoblin.binparams[i - 1] + PGOBLIN_BPARG != pgoblin.binparams[i]) {
            printf( "!!! pgoblin.binparams[%d]=%d + %d <> pgoblin.binparams[%d]=%d\n"
                  , i - 1, pgoblin.binparams[i - 1]
                  , PGOBLIN_BPARG
                  , i, pgoblin.binparams[i]
                  );
    }   }
    for (i = 0; i < PGOBLIN_REGSIZE; i++) {
        if  ((~pgoblin.class[pgoblin_regn[i] & 0xFF]) != i) {
            printf( "reg[%d <> %d] name %c\n"
                  , i, ~pgoblin.class[pgoblin_regn[i] & 0xFF], pgoblin_regn[i]
                  );
    }   }
    for (i = 0; i < 256; i++) {
        if  ((pgoblin.class[i] < 0) && (pgoblin_regn[~pgoblin.class[i] & 0xFF] != i)) {
            printf( "name %c <> %c reg[%d]\n"
                  , pgoblin_regn[~pgoblin.class[i] & 0xFF], i, ~pgoblin.class[i] & 0xFF
                  );
    }   }
    for (cmd = 1; cmd < pgoblin.max; cmd++) {
        m = 0;
        if  (!(~pgoblin.a[cmd].flags & PGOBLIN_ILLEGAL)) {
            if  (pgoblin.a[cmd].car) printf("!executor for illegal command %03X\n", cmd);
            if  (pgoblin.a[cmd].str)
                printf("!name=%s~ for illegal command %03X\n", pgoblin.a[cmd].str, cmd);
        } else {
            if  (!pgoblin.a[cmd].str) {
                printf("!! No name for legal command %03X\n", cmd);
            } else if  (babolo_testword(pgoblin.cmds, (u_char*)pgoblin.a[cmd].str) != cmd) {
                printf( "!!! cmd=%03X: %s=%03X\n"
                      , cmd
                      , pgoblin.a[cmd].str
                      , babolo_testword(pgoblin.cmds
                      , (u_char*)pgoblin.a[cmd].str)
                      );
            }
            if  (pgoblin.a[cmd].flags & PGOBLIN_IGNORE) {
                if  (pgoblin.a[cmd].car) printf("!executor for ignored command %03X\n", cmd);
            } else if (pgoblin.a[cmd].flags && !pgoblin.a[cmd].car) {
                printf("!! No executor for legal command %03X\n", cmd);
            }
            if  (pgoblin.a[cmd].flags & PGOBLIN_NOLITER) {
                if  (!(cmd & PGOBLIN_EXTENDED)) printf("!short command %03X without literal\n", cmd);
        }   }
        for (i = 0; i < pgoblin.symparam; i++) {
            if  (pgoblin.a[cmd].flags & pgoblin.p[i].sym) {
                if  (!pgoblin.a[cmd].ch[PREG(cmd, i)]) {
                    printf("!! cmd=%03X: pgoblin.a[cmd].flags <> pgoblin.a[cmd].ch[PREG(%d)]\n", cmd, i);
                    ifBLIN_QV2(options->flags) {
                        printf( "pgoblin.a[%03X].flags=%08X pgoblin.p[%d].sym=%02X, bin=%02X, mask=%02X "
                                "PREG(%03X,%d)=%d pgoblin.a[%03X].ch[%d]=%02X\n"
                              , cmd
                              , pgoblin.a[cmd].flags
                              , i
                              , pgoblin.p[i].sym
                              , pgoblin.p[i].bin & 0xFF
                              , pgoblin.p[i].mask
                              , cmd, i, PREG(cmd, i)
                              , cmd, PREG(cmd, i), pgoblin.a[cmd].ch[PREG(cmd, i)]
                              );
                    }
                } else {
                    if  (m & (1 << PREG(cmd, i))) {
                        printf("!!! Second hand r=%d for cmd=%03X\n", i, cmd);
                    }
                    m |= (1 << PREG(cmd, i));
        }   }   }
        for (i = 0; i < pgoblin.binparam; i++) {
            if  (!(m & (1 << i)) && pgoblin.a[cmd].ch[i]) {
                printf("!!! Unused r=%d for cmd=%03X\n", i, cmd);
}   }   }   }

static const char *const prms[256] =
{                  "",                   "Pf",                   "Pt",                   "Pt Pf"
,                "Pm",                "Pm Pf",                "Pm Pt",                "Pm Pt Pf"
,             "Pq"   ,                "Pq Pf",                "Pq Pt",                "Pq Pt Pf"
,             "Pq Pm",             "Pq Pm Pf",             "Pq Pm Pt",             "Pq Pm Pt Pf"
, "Po"               ,                "Po Pf",                "Po Pt",                "Po Pt Pf"
, "Po Pm"            ,             "Po Pm Pf",             "Po Pm Pt",             "Po Pm Pt Pf"
, "Po Pq"            ,             "Po Pq Pf",             "Po Pq Pt",             "Po Pq Pt Pf"
, "Po Pq Pm"         ,          "Po Pq Pm Pf",          "Po Pq Pm Pt",          "Po Pq Pm Pt Pf"
,          "Pc"      ,                "Pc Pf",                "Pc Pt",                "Pc Pt Pf"
,          "Pc Pm"   ,             "Pc Pm Pf",             "Pc Pm Pt",             "Pc Pm Pt Pf"
,          "Pc Pq"   ,             "Pc Pq Pf",             "Pc Pq Pt",             "Pc Pq Pt Pf"
,          "Pc Pq Pm",          "Pc Pq Pm Pf",          "Pc Pq Pm Pt",          "Pc Pq Pm Pt Pf"
, "Po Pc"            ,             "Po Pc Pf",             "Po Pc Pt",             "Po Pc Pt Pf"
, "Po Pc Pm"         ,          "Po Pc Pm Pf",          "Po Pc Pm Pt",          "Po Pc Pm Pt Pf"
, "Po Pc Pq"         ,          "Po Pc Pq Pf",          "Po Pc Pq Pt",          "Po Pc Pq Pt Pf"
, "Po Pc Pq Pm"      ,       "Po Pc Pq Pm Pf",       "Po Pc Pq Pm Pt",       "Po Pc Pq Pm Pt Pf"
,       "Pj"         ,                "Pj Pf",                "Pj Pt",                "Pj Pt Pf"
,       "Pj Pm"      ,             "Pj Pm Pf",             "Pj Pm Pt",             "Pj Pm Pt Pf"
,       "Pj Pq"      ,             "Pj Pq Pf",             "Pj Pq Pt",             "Pj Pq Pt Pf"
,       "Pj Pq Pm"   ,          "Pj Pq Pm Pf",          "Pj Pq Pm Pt",          "Pj Pq Pm Pt Pf"
, "Po Pj"            ,             "Po Pj Pf",             "Po Pj Pt",             "Po Pj Pt Pf"
, "Po Pj Pm"         ,          "Po Pj Pm Pf",          "Po Pj Pm Pt",          "Po Pj Pm Pt Pf"
, "Po Pj Pq"         ,          "Po Pj Pq Pf",          "Po Pj Pq Pt",          "Po Pj Pq Pt Pf"
, "Po Pj Pq Pm"      ,       "Po Pj Pq Pm Pf",       "Po Pj Pq Pm Pt",       "Po Pj Pq Pm Pt Pf"
,       "Pj Pc"      ,             "Pj Pc Pf",             "Pj Pc Pt",             "Pj Pc Pt Pf"
,       "Pj Pc Pm"   ,          "Pj Pc Pm Pf",          "Pj Pc Pm Pt",          "Pj Pc Pm Pt Pf"
,       "Pj Pc Pq"   ,          "Pj Pc Pq Pf",          "Pj Pc Pq Pt",          "Pj Pc Pq Pt Pf"
,       "Pj Pc Pq Pm",       "Pj Pc Pq Pm Pf",       "Pj Pc Pq Pm Pt",       "Pj Pc Pq Pm Pt Pf"
, "Po Pj Pc"         ,          "Po Pj Pc Pf",             "Po Pj Pt",          "Po Pj Pc Pt Pf"
, "Po Pj Pc Pm"      ,       "Po Pj Pc Pm Pf",       "Po Pj Pc Pm Pt",       "Po Pj Pc Pm Pt Pf"
, "Po Pj Pc Pq"      ,       "Po Pj Pc Pq Pf",       "Po Pj Pc Pq Pt",       "Po Pj Pc Pq Pt Pf"
, "Po Pj Pc Pq Pm"   ,    "Po Pj Pc Pq Pm Pf",    "Po Pj Pc Pq Pm Pt",    "Po Pj Pc Pq Pm Pt Pf"
,    "Ps"            ,                "Ps Pf",                "Ps Pt",                "Ps Pt Pf"
,    "Ps Pm"         ,             "Ps Pm Pf",             "Ps Pm Pt",             "Ps Pm Pt Pf"
,    "Ps Pq"         ,             "Ps Pq Pf",             "Ps Pq Pt",             "Ps Pq Pt Pf"
,    "Ps Pq Pm"      ,          "Ps Pq Pm Pf",          "Ps Pq Pm Pt",          "Ps Pq Pm Pt Pf"
, "Po Ps"            ,             "Po Ps Pf",             "Po Ps Pt",             "Po Ps Pt Pf"
, "Po Ps Pm"         ,          "Po Ps Pm Pf",          "Po Ps Pm Pt",          "Po Ps Pm Pt Pf"
, "Po Ps Pq"         ,          "Po Ps Pq Pf",          "Po Ps Pq Pt",          "Po Ps Pq Pt Pf"
, "Po Ps Pq Pm"      ,       "Po Ps Pq Pm Pf",       "Po Ps Pq Pm Pt",       "Po Ps Pq Pm Pt Pf"
,    "Ps Pc"         ,             "Ps Pc Pf",             "Ps Pc Pt",             "Ps Pc Pt Pf"
,    "Ps Pc Pm"      ,          "Ps Pc Pm Pf",          "Ps Pc Pm Pt",          "Ps Pc Pm Pt Pf"
,    "Ps Pc Pq"      ,          "Ps Pc Pq Pf",          "Ps Pc Pq Pt",          "Ps Pc Pq Pt Pf"
,    "Ps Pc Pq Pm"   ,       "Ps Pc Pq Pm Pf",       "Ps Pc Pq Pm Pt",       "Ps Pc Pq Pm Pt Pf"
, "Po Ps Pc"         ,          "Po Ps Pc Pf",             "Po Ps Pt",          "Po Ps Pc Pt Pf"
, "Po Ps Pc Pm"      ,       "Po Ps Pc Pm Pf",       "Po Ps Pc Pm Pt",       "Po Ps Pc Pm Pt Pf"
, "Po Ps Pc Pq"      ,       "Po Ps Pc Pq Pf",       "Po Ps Pc Pq Pt",       "Po Ps Pc Pq Pt Pf"
, "Po Ps Pc Pq Pm"   ,    "Po Ps Pc Pq Pm Pf",    "Po Ps Pc Pq Pm Pt",    "Po Ps Pc Pq Pm Pt Pf"
,    "Ps Pj"         ,             "Ps Pj Pf",             "Ps Pj Pt",             "Ps Pj Pt Pf"
,    "Ps Pj Pm"      ,          "Ps Pj Pm Pf",          "Ps Pj Pm Pt",          "Ps Pj Pm Pt Pf"
,    "Ps Pj Pq"      ,          "Ps Pj Pq Pf",          "Ps Pj Pq Pt",          "Ps Pj Pq Pt Pf"
,    "Ps Pj Pq Pm"   ,       "Ps Pj Pq Pm Pf",       "Ps Pj Pq Pm Pt",       "Ps Pj Pq Pm Pt Pf"
, "Po Ps Pj"         ,          "Po Ps Pj Pf",          "Po Ps Pj Pt",          "Po Ps Pj Pt Pf"
, "Po Ps Pj Pm"      ,       "Po Ps Pj Pm Pf",       "Po Ps Pj Pm Pt",       "Po Ps Pj Pm Pt Pf"
, "Po Ps Pj Pq"      ,       "Po Ps Pj Pq Pf",       "Po Ps Pj Pq Pt",       "Po Ps Pj Pq Pt Pf"
, "Po Ps Pj Pq Pm"   ,    "Po Ps Pj Pq Pm Pf",    "Po Ps Pj Pq Pm Pt",    "Po Ps Pj Pq Pm Pt Pf"
,    "Ps Pj Pc"      ,          "Ps Pj Pc Pf",          "Ps Pj Pc Pt",          "Ps Pj Pc Pt Pf"
,    "Ps Pj Pc Pm"   ,       "Ps Pj Pc Pm Pf",       "Ps Pj Pc Pm Pt",       "Ps Pj Pc Pm Pt Pf"
,    "Ps Pj Pc Pq"   ,       "Ps Pj Pc Pq Pf",       "Ps Pj Pc Pq Pt",       "Ps Pj Pc Pq Pt Pf"
,    "Ps Pj Pc Pq Pm",    "Ps Pj Pc Pq Pm Pf",    "Ps Pj Pc Pq Pm Pt",    "Ps Pj Pc Pq Pm Pt Pf"
, "Po Ps Pj Pc"      ,       "Po Ps Pj Pc Pf",          "Po Ps Pj Pt",       "Po Ps Pj Pc Pt Pf"
, "Po Ps Pj Pc Pm"   ,    "Po Ps Pj Pc Pm Pf",    "Po Ps Pj Pc Pm Pt",    "Po Ps Pj Pc Pm Pt Pf"
, "Po Ps Pj Pc Pq"   ,    "Po Ps Pj Pc Pq Pf",    "Po Ps Pj Pc Pq Pt",    "Po Ps Pj Pc Pq Pt Pf"
, "Po Ps Pj Pc Pq Pm", "Po Ps Pj Pc Pq Pm Pf", "Po Ps Pj Pc Pq Pm Pt", "Po Ps Pj Pc Pq Pm Pt Pf"
};

static const u_char flms[256] =
{  4, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  0, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
};

static int
cmp(const void *a, const void *b) {
    return(strcmp(pgoblin.a[*(int*)a].str, pgoblin.a[*(int*)b].str));
}

static int
pgoblin_htman(u_int32_t flags, char *Tflag) {
    switch(Tflag[0]) {
    case '1': {
            u_int32_t tag[PGOBLIN_SYMREGS];
            const char *pt[PGOBLIN_SYMREGS];
            u_int8_t p[PGOBLIN_BINREGS];
            int ex = EX_OK, i, j, k, m;
            int *sqn;
            char cf[8];

        ;   if  (!(sqn = malloc(sizeof(int) * pgoblin.max))) {
        ;       errno = ENOMEM;
        ;       ex = EX_UNAVAILABLE;
        ;       ifBLIN_QV1(flags) warn("pgoblin_htman:malloc");
        ;       goto out;
        ;   }
        ;   for (i = 1, j = 0; i < pgoblin.max; i++) {
        ;       if  (pgoblin.a[i].str) sqn[j++] = i;
        ;   }
        ;   if  (heapsort(sqn, j, sizeof(int), cmp) < 0) {
        ;       ex = EX_SOFTWARE;
        ;       ifBLIN_QV1(flags) warn("radixsort");
        ;       goto out;
        ;   }
        ;   for (i = 0; i < j; i++) {
                u_int32_t f;
                u_int8_t h;
                char c;

        ;       f = pgoblin.a[sqn[i]].flags;
        ;       if  ((f & PGOBLIN_ILLEGAL) == PGOBLIN_ILLEGAL) {
        ;           tag[0] = 8;
        ;           f &= ~PGOBLIN_ILLEGAL;
        ;       } else {
        ;           for (k = 0; k < PGOBLIN_BINREGS; k++) p[k] = 0;
        ;           for (k = 0; k < PGOBLIN_SYMREGS; k++) {
        ;               tag[k] = 0;
        ;               if  (f & pgoblin.p[k].sym) {
                            int r;

        ;                   h = pgoblin.a[sqn[i]].ch[r = PREG(sqn[i], k)];
        ;                   tag[k] |= flms[h & 0xFF];
        ;                   pt[k] = prms[h & 0xFF];
//printf("%d s%d b%d t%c %02X\n", tag[k], k, r, (!p[r]) ? '~' : ('0' + ~p[r]), h);
        ;                   if  (h & ~(PGOBLIN_OUTSET | pgoblin.p[k].val)) tag[k] |= 1;
        ;                   if  (!(h & pgoblin.p[k].val) != !*(pt[k])) tag[k] |= 1;
        ;                   f &= ~pgoblin.p[k].sym;
        ;                   if  (p[r]) {
        ;                       tag[~p[r]] |= 2;
        ;                       tag[k] |= 2;
        ;                   }
        ;                   p[r] = ~k;
        ;               } else {
        ;                   pt[k] = "";
        ;               }
        ;               if  (pgoblin.p[k].bin < 0) f &= ~(pgoblin.p[k].mask << ~pgoblin.p[k].bin);
        ;       }   }
        ;       k = 0;
        ;       c = ' ';
        ;       if  (f & PGOBLIN_IGNORE) {
        ;           cf[k++] = 'i';
        ;           for (m = 0; m < PGOBLIN_BINREGS; m++) if (p[m]) c = '!';
        ;           for (m = 0; m < PGOBLIN_SYMREGS; m++) if (*(pt[m])) c = '!';
        ;           f &= ~PGOBLIN_IGNORE;
        ;       }
        ;       if  (f & PGOBLIN_NOLITER) {
        ;           cf[k++] = 'l';
        ;           if (p[1]) c = '!';
        ;           if (tag[1] || *(pt[1])) c = '!';
        ;           f &= ~PGOBLIN_NOLITER;
        ;       }
        ;       if  (f & PGOBLIN_LEXLVUP) cf[k++] = 'u';
        ;       if  (f & PGOBLIN_LEXLDOWN) cf[k++] = 'd';
        ;       if  (f & PGOBLIN_FORKED) cf[k++] = 'f';
        ;       f &= ~(PGOBLIN_LEXLVUP | PGOBLIN_LEXLDOWN | PGOBLIN_FORKED);
        ;       if  (f) c = '!';
        ;       for (m = 0; m < PGOBLIN_SYMREGS; m++) if (tag[m] & ~8) c = '!';
        ;       if  (c == '!') cf[k++] = '!';
        ;       cf[k++] = '\0';
        ;       ifBLIN_QV2(flags) printf( "%08X%c\t", f, c);
        ;       if  (tag[0] & 8) printf( "%s\t%s\t%d\t\t0\t\t0\t\t0\t\t0\t\t0\t\n"
                                       , cf, pgoblin.a[sqn[i]].str, tag[0]
                                       );
                  else printf( "%s\t%s\t%d\t%s\t%d\t%s\t%d\t%s\t%d\t%s\t%d\t%s\t%d\t%s\n"
                                 , cf, pgoblin.a[sqn[i]].str
                             , tag[0], pt[0]
                             , tag[1], pt[1]
                             , tag[2], pt[2]
                             , tag[3], pt[3]
                             , tag[4], pt[4]
                             , tag[5], pt[5]
                             );
        }   }
        break;
    default: {
            char *p;

            for (p = Tflag; *p; p++) {
                if  (p[1] == ':') printf("%c\t1\n", *(p++));
                  else printf("%c\t0\n", *p);
    }   }   }
out:;
    return(0);
}

static int
pgoblin_keycodes(pgoblin_main *options) {
    static const char KeyCodes[] = {'U', 'C', 'T', 'R'};
    int ex = EX_OK, i, j, k;
    pgoblin_prog *pgm;
#   define PROGSIZE   3
#   define RESCLASSES 4
#   define IOREGFOR   1
    pgoblin_io *r;
    char *s, c, *m;

    if (!(pgm = malloc(sizeof(pgoblin_tuple) * PROGSIZE + sizeof(pgoblin_prog)))) {
        errx(EX_UNAVAILABLE, "Malloc failed #3");
    }
    bzero(pgm, sizeof(pgoblin_tuple) * PROGSIZE + sizeof(pgoblin_prog));
    strncpy(pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_LEN);
    pgm->maxx = PROGSIZE;
    pgm->curr = 0;
    pgm->debug = NULL;
    pgm->flags = options->flags & ~PGOBLIN_CLEAR_ONEXIT;
    if  (pgm->curr < pgm->maxx) {
        pgm->code[pgm->curr].cmd = PGOBLIN_select | IOREGFOR << PGOBLIN_ARG1S;
        pgm->code[pgm->curr].e.lit = "SELECT word, catcode, catdesc FROM pg_get_keywords();";
        pgm->curr++;
        if  (options->flags & PGOBLIN_VERIFY) pgoblin_Vdump(options, pgm);
        if  ((ex = pgoblin_execute(options, pgm, NULL, NULL, 0))) {
            ifBLIN_QV1(options->flags) warn("Execute failed");
        }
        r = &(options->io[IOREGFOR]);
        for (i = 0; i < DBASE(r->flagc)->resinfo(PGOBLIN_Ntuples, r->pq); i++) {
            m = DBASE(r->flagc)->getvalue(r->pq, i, 2);
            c = *(DBASE(r->flagc)->getvalue(r->pq, i, 1));
            s = DBASE(r->flagc)->getvalue(r->pq, i, 0);
            j = babolo_testword(pgoblin.sqlkeywords, (u_char*)s);
            if  (!j) {
                ifBLIN_QV1(options->flags)
                    warnx( "Unknown keyword \'%s\' with type \'%c\', comment is \'%s\'", s, c, m);
            } else {
                for (k = 0; k < RESCLASSES; k++) if  (KeyCodes[k] == c) break;
                if  (k >= RESCLASSES) {
                    ifBLIN_QV1(options->flags)
                        warnx("Unknown keyword type \'%c\' for \'%s\', comment is \'%s\'", c, s, m);
                    ex = EX_SOFTWARE;
                } else if (k & ~(j - 1)) {
                    ifBLIN_QV1(options->flags)
                        warnx( "We know of type \'%c\' for keyword \'%s\', "
                               "but DBMS knows stronger type \'%c\'"
                             , KeyCodes[(j - 1)], s, c
                             );
                    ex = EX_SOFTWARE;
                } else if (k != (j - 1)) {
                    ifBLIN_QV2(options->flags)
                        warnx( "Our type \'%c\' mismatch with DBMS type \'%c\' for keyword \'%s\'"
                             , KeyCodes[(j - 1)], c, s
                             );
        }   }   }
    } else {
        errx(EX_SOFTWARE, "Programm too big in pgoblin_keycodes");
    }
    return(ex);
}

static void
usage(int ex) {
    int i;
    char *q;

    fprintf(stderr, "pgoblin " VERS "  " DATE "\n"
"Usage:\n"
"pgoblin [-aANOqvV ][-d DataBase ][-h Hostname ][-p Port ][-U User ][-f QueryFile][-Eflag[env]] args\n"
"    -f QueryFile\n"
"    -d DataBase name\n"
"    -h Hostname of backend server\n"
"    -p Port\n"
"____-U Username\n"
"    -c COPY out\n"
"    -C COPY in\n"
"    -D perform query without result\n"
"    -s SELECT\n"
"    -S SELECT BINARY emulation\n"
"____-e QueryArgument\n"
"    -q quiet\n"
"    -v verbose\n"
"    -N new style\n"
"    -O old style\n"
"Hooked up:\n"
);
    for (i = 0; DBASE(i); i++) {
        q = index(DBASE(i)->name, '\0');
        fprintf(stderr, "  %s %s %s\n", DBASE(i)->id, DBASE(i)->name, ++q);
    }
    for (i = 0; JOBE(i); i++) {
        q = index(JOBE(i)->name, '\0');
        fprintf(stderr, "  %s %s %s\n", JOBE(i)->id, JOBE(i)->name, ++q);
    }
    for (i = 0; STYLS(i); i++) {
        q = index(STYLS(i)->name, '\0');
        fprintf(stderr, "  %s %s %s\n", STYLS(i)->id, STYLS(i)->name, ++q);
    }
    exit(ex);
}

static char *
rediropt(pgoblin_main *options, char *optarg, int redirenv) {
    char *cr;
    if  (redirenv > 0) {
        if  (!(cr = getenv(optarg))) {
            ifBLIN_QV1(options->flags) warnx("No ENV %s", optarg);
            exit(EX_USAGE);
        }
    }else{
        cr = optarg;
    }
    return(cr);
}

static void
cmdin(pgoblin_main *options, int redirenv, pgoblin_prog *pgm, pgoblin_cmd cmd, char *optarg) {
    if  (pgm->curr < pgm->maxx) {
        pgm->code[pgm->curr].cmd = cmd;
        pgm->code[pgm->curr].e.lit = rediropt(options, optarg, redirenv);
        pgm->curr++;
    } else {
        errx(EX_SOFTWARE, "Programm too big");
}   }

static mife_descriptor *
popin(pgoblin_main *options) {
    mife_descriptor *in;
    if  (options->stack[options->sp]) {
        in = mife_open(PGOBLIN_MIFEFLAGS, options->stack[options->sp++]);
    } else {
        in = mife_opef(PGOBLIN_MIFEFLAGS, fileno(stdin));
    }
    return(in);
}

int
main(int argc, char *argv[], char **envp) {
    pgoblin_main *options;
    babolo_opt *opt;
    babolo_parm *bp;
    int c, i, redirenv, ex = EX_OK;
    int dbn = -1, spmax;
    u_int32_t tmp;
    char *o;
    u_char *text;
    size_t txlen;
    mife_descriptor *in;
    pgoblin_prog *pgm;
    char *Tflag = NULL, *flar;

    if  (!(options = pgoblin_init( BLIN_VER1 | PGOBLIN_DEFAULDB | PGOBLIN_OLDSTYLE
                                 | PGOBLIN_ARGVSTACK | PGOBLIN_ERROR_SENSOR | PGOBLIN_CLEAR_ONEXIT
                                 , fileno(stdout)
        ) )                      ) {
        errx(EX_UNAVAILABLE, "Malloc failed #1");
    }
    if  (!(options->stack = malloc(sizeof(char**) * ((spmax = (argc + 16)) + 1)))) {
        errx(EX_UNAVAILABLE, "Malloc failed #2");
    }
    if (!(pgm = malloc(sizeof(pgoblin_tuple) * PGOBLIN_PROGSIZE + sizeof(pgoblin_prog)))) {
        errx(EX_UNAVAILABLE, "Malloc failed #3");
    }
    options->sp = 0;
    options->stack[0] = NULL;
    options->argv = argv;
    options->envp = envp;
    bzero(pgm, sizeof(pgoblin_tuple) * PGOBLIN_PROGSIZE + sizeof(pgoblin_prog));
    strncpy(pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_LEN);
    pgm->maxx = PGOBLIN_PROGSIZE;
    pgm->curr = 0;
    pgm->debug = NULL;
    opt = NULL;
    if  (babolo_openopt( Bpars_NONU, &opt, argc, argv
                       , flar = "aAB:c:C:d:D:e:Ef:Fh:INOp:qr:R:s:S:t:T:U:vVw:zZ?"
        )              ) {
        errx(EX_SOFTWARE, "openopt");
    }
    for (redirenv = 0; (c = babolo_getopt(&opt)) != 0; redirenv--) {
        if  (redirenv < 0) redirenv = 0;
        switch (c) {
        case 'a': options->flags |= PGOBLIN_COPEND_PASS;                                         break;
//    COPY ( \.)    #copyout.
        case 'A': options->flags |= PGOBLIN_COPEND_APND;                                         break;
//    COPY ( \.)    #copyout,    .
        case 'B': if  (dbn >= 0) {
// Ar 
//    .
                ;     ifBLIN_QV1(options->flags)
                          warnx("Dublicate DBMS definition %s", babolo_getoptarg(&opt, 0));
                ;     break;
                ; }
                ; for (i = 0; i < pgoblin.dbtablesz; i++) {
                ;     if  (DBASE(i) && DBASE(i)->name) {
                ;         if  (!strcmp(babolo_getoptarg(&opt, 0), DBASE(i)->name)) {
                ;             dbn = i;
                ;             break;
                ; }   }   }
                ; if  (dbn < 0) {
                ;     ifBLIN_QV1(options->flags) warnx("Illegal DBMS %s", babolo_getoptarg(&opt, 0));
                ; }
                ; break;
        case 'c': cmdin(options, redirenv, pgm, PGOBLIN_copyout, babolo_getoptarg(&opt, 0));     break;
// Ar 
//  #copyout      .
        case 'C': cmdin(options, redirenv, pgm, PGOBLIN_copyin, babolo_getoptarg(&opt, 0));      break;
// Ar 
//  #copyin      .
        case 'd': options->conn[0].dbname = rediropt(options, babolo_getoptarg(&opt, 0), redirenv);
// Ar 
//   
                ; break;
        case 'D': cmdin(options, redirenv, pgm, PGOBLIN_perform, babolo_getoptarg(&opt, 0));     break;
// Ar 
//  #perform      .
        case 'e': ex = pgoblin_parser( options
// Ar 
//    .
                                     , (u_char*)rediropt(options, babolo_getoptarg(&opt, 0), redirenv)
                                     , strlen(rediropt(options, babolo_getoptarg(&opt, 0), redirenv))
                                     , &pgm
                                     );
                ; if  (ex) err(EX_DATAERR, "Syntax?");
                ; break;
        case 'E': redirenv = 2;                                                                  break;
//         .
//      ,   
//   ,     .
        case 'f': options->stack[options->sp] = rediropt(options, babolo_getoptarg(&opt, 0), redirenv);
// Ar 
//  .     .
                ; if  (options->stack[options->sp]) options->stack[++options->sp] = NULL;
                ; break;
        case 'F': if  (options->conn[0].flags & PGOBLIN_INT64TIME) {
//    CON 0 .
                ;     options->conn[0].flags |= PGOBLIN_NEEDINTIME;
                ;     options->conn[0].flags &= ~PGOBLIN_INT64TIME;
                ; } else {
                ;     options->conn[0].flags |= PGOBLIN_FLOATTIME;
                ; }
                ; break;
        case 'h': options->conn[0].host = rediropt(options, babolo_getoptarg(&opt, 0), redirenv);break;
//    CON 0.
        case 'I': if  (options->conn[0].flags & PGOBLIN_FLOATTIME) {
//    CON 0 .
                ;     options->conn[0].flags |= PGOBLIN_NEEDINTIME;
                ;     options->conn[0].flags &= ~PGOBLIN_FLOATTIME;
                ; } else {
                ;     options->conn[0].flags |= PGOBLIN_INT64TIME;
                ; }
                ; break;
        case 'N': options->flags &= ~PGOBLIN_OLDSTYLE;                                           break;
// ""    OUT 1   .
//    "".
        case 'O': options->flags |= PGOBLIN_OLDSTYLE;                                            break;
// "" ( pgoblin-0)    OUT 1   .
        case 'p': options->conn[0].port = rediropt(options, babolo_getoptarg(&opt, 0), redirenv);break;
//    CON 0.
        case 'q': options->flags &= ~BLIN_VERMASK;                                               break;
//   .
        case 'r': if  (!(o = babolo_getoptarg(&opt, 0))) usage(EX_USAGE);
// Ar 
//          babolo_getoptarg()
//  .       ,
//   FreeBSD       .
                ; bp = babolo_getparm(Bpars_NOEN | Bpars_NOAL | Bpars_NONU, (u_char**)&o, (u_char*)"", 0);
                ; babolo_openopt(0, &opt, bp->argc, (char **)bp->argv, NULL);
                ; break;
        case 'R': if  (!(o = babolo_getoptarg(&opt, 0))) usage(EX_USAGE);
// Ar 
//       ,
//         babolo_getoptarg()
//  .       ,
//   FreeBSD       .
                ; bp = babolo_getparm(Bpars_NOAL | Bpars_NONU, (u_char**)&o, (u_char*)"", 0);
                ; babolo_openopt(0, &opt, bp->argc, (char **)bp->argv, NULL);
                ; break;
        case 's': cmdin(options, redirenv, pgm, PGOBLIN_strselect, babolo_getoptarg(&opt, 0));   break;
// Ar 
//  #strselect      .
        case 'S': cmdin(options, redirenv, pgm, PGOBLIN_binselect, babolo_getoptarg(&opt, 0));   break;
// Ar 
//  #binselect      .
        case 't': options->maxtmout
// Ar 
//       #listen.   1 .
                = strtoul(rediropt(options, babolo_getoptarg(&opt, 0), redirenv), NULL, 0) * 1000;
                ; break;
        case 'T': Tflag = rediropt(options, babolo_getoptarg(&opt, 0), redirenv);                break;
// Ar 
//     ,    ,
//      .
        case 'U': options->conn[0].username = rediropt(options, babolo_getoptarg(&opt, 0), redirenv);
// Ar 
//    
                ; break;
        case 'v': BLIN_VERBOSE(options->flags);                                                  break;
//   .
//  :
//u
// 0 -      
// 1 -      stderr
// 2 -  stderr    ,   
//  3 -  
//u
//      1.
        case 'V': if  (options->flags & PGOBLIN_VERIFY) {
//      .
//     .
                ;     pgoblin_VVdump();
                ; } else {
                ;     options->flags |= PGOBLIN_VERIFY;
                ; }
                ; break;
        case 'w': tmp = strtoul(rediropt(options, babolo_getoptarg(&opt, 0), redirenv), NULL, 0);
// Ar 
//       #listen.
//         ,   255,   255.
//   .      ,  .
                ; options->maxtmout = tmp;
                ; options->flags |= ((tmp > 255) ? 255 : tmp);
                ; break;
        case 'z': /* | PGOBLIN_ERROR_SENSIB not yet */;                                          break;
        case 'Z': /* & ~(PGOBLIN_ERROR_SENSIB | PGOBLIN_ERROR_SENSOR) not yet */;                break;
        case '?': usage(EX_OK);
//  .
        default : usage(EX_USAGE);
    }   }

    MARK_IO_MIFE_GO(&(options->io[0]));;
    ;;  MARK_IO_OUT_GO(&(options->io[0]))
    ;;  ;;  options->io[0].flags |= options->flags & BLIN_VERMASK;
    ;;  MARK_IO_OUT_WENT(&(options->io[0]))
    MARK_IO_MIFE_WENT(&(options->io[0]));;
#ifdef HAVE_DB_PGSQL
    if  (dbn < 0) dbn = PGOBLIN_DB_PGSQL;
#else
    if  (dbn < 0) dbn = PGOBLIN_DB_0;
#endif
    MARK_R_CONN_GO(&(options->conn[0]));;
    ;;  options->conn[0].flags |= (options->flags & BLIN_VERMASK) | dbn;
    MARK_R_CONN_WENT(&(options->conn[0]));;
    if  (options->flags & PGOBLIN_DEFAULDB) for (i = 1; i < PGOBLIN_REGSIZE; i++) {
        MARK_R_CONN_GO(&(options->conn[i]));;
        ;;  options->conn[i].flags |= dbn;
        MARK_R_CONN_WENT(&(options->conn[i]));;
    }
    MARK_R_JOB_GO(&(options->job[0]));;
    ;;  options->job[0].flags |= options->flags & BLIN_VERMASK;
    MARK_R_JOB_WENT(&(options->job[0]));;
    MARK_R_STYLE_GO(&(options->style[0]));;
    ;;  options->style[0].flags |= options->flags & BLIN_VERMASK;
    MARK_R_STYLE_WENT(&(options->style[0]));;

    if  (options->flags & PGOBLIN_VERIFY) pgoblin_verify(options);
    options->ap = options->sp;
    while ((o = babolo_getarg(&opt))) {
        options->stack[options->sp++] = o;
        if  (options->sp >= spmax) {
            ifBLIN_QV1(options->flags) warnx("Arg list too grows");
    }   }
    options->stack[options->sp] = NULL;
    options->sp = 0;
    if  (Tflag) {
        switch (Tflag[0]) {
        case '0': ex = pgoblin_htman(options->flags, Tflag); break;
        case '1': ex = pgoblin_htman(options->flags, Tflag); break;
        case '2': ex = pgoblin_keycodes(options);            break;
        }
    } else {
        pgm->flags = options->flags;
        if  (!pgm->curr) {
            if  (!(in = popin(options))) {
                ifBLIN_QV1(options->flags) warn("Programm");
                ex = EX_IOERR;
            } else if ((txlen = mife_read(in, 0, 0)) < 0) {
                ifBLIN_QV1(options->flags) warn("Program read failed");
                ex = EX_IOERR;
            } else if (!(text = mife_get(in, 0))) {
                ifBLIN_QV1(options->flags) warn("Program get failed");
                ex = EX_IOERR;
            } else if (pgoblin_parser(options, text, txlen, &pgm)) {
                ifBLIN_QV1(options->flags) warnx("Parser failed");
                ex = EX_DATAERR;
        }   }
        if  (!ex) {
            MARK_IO_MIFE_GO(&(options->io[0]));;
            ;;  if  ((options->io[0].mife = popin(options))) {
            ;;      options->io[0].pid = 0;
            ;;      options->io[0].offset = 0;
            ;;      options->io[0].flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
            ;;  }
            MARK_IO_MIFE_WENT(&(options->io[0]));;
            if  (options->flags & PGOBLIN_VERIFY) pgoblin_Vdump(options, pgm);
            if  ((ex = pgoblin_execute(options, pgm, NULL, NULL, 0)))
                ifBLIN_QV1(options->flags) warnx("Execute failed");
    }   }
    exit(ex);
}
