/*-
 * Copyright (C) @BABOLO  2002 Dec 04
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2008 Apr 05\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: job_local.c,v 1.14 2009/11/04 19:09:23 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <mife.h>
#include <fts.h>
#include <err.h>
#include <multilar.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include "pgoblin.h"
#include "pgob.h"

static int
pgoblin_finit(u_int32_t flags, pgoblin_jobs *this) {
    return(EX_OK);
}

static int
local_none(pgoblin_exenv *exenv, pgoblin_r *r) {
    return(EX_OK);
}
 
static int
pgoblin_open(pgoblin_exenv *exenv, pgoblin_r *r, void *opt) {
    exenv->options->flags |= PGOBLIN_INITED;
    return(EX_OK);
}

static u_int32_t
local_test(pgoblin_command cmd) {
    u_int32_t e;

    if  (cmd == PGOBLIN_fork) e = PGOBLIN_TVFORK; else e = PGOBLIN_TOFORK | PGOBLIN_TOEXIT;
    return(e);
}

static int
local_exec(pgoblin_exenv *exenv, pgoblin_r *r, char **argv) {
    int ex = 0;

    ifBLIN_QV5(exenv->options->flags) fprintf( stderr, "+local_exec %d %d %d %d %08X argv %s\n"
                                      , r[PGO_COUT].r, r[PGO_CCTL].r, r[PGO_CIN].r, r[PGO_CJOB].r
                                      , exenv->exeflags, argv ? "OK" : "NULL"
                                      );
    ifBLIN_QV6(exenv->options->flags) {
        int z;
        for (z = 0; argv[z]; z++) fprintf(stderr, "[%d]=%s~\n", z, argv[z]);
    }
    if  (argv && !ex) {
        int g;
        /************************************************
         * local_exec  ,    *
         ************************************************/
    ;   if  (dup2(IO_IN->mife->fd, fileno(stdin)) < 0) {
    ;       ifBLIN_QV1(exenv->options->flags) warn("dup2 #4");
    ;       ex = -EX_OSERR;
    ;       exit(ex);
    ;   }
    ;   if  (dup2(IO_OUT->onu, fileno(stdout)) < 0) {
    ;       ifBLIN_QV1(exenv->options->flags) warn("dup2 #3");
    ;       ex = -EX_OSERR;
    ;       exit(ex);
    ;   }
    ;   if  (exenv->options->flags & PGOBLIN_FORK_WAIT) {
    ;       ifBLIN_QV3(exenv->options->flags)
                fprintf(stderr, "sleep %us in fork\n", exenv->options->flags & PGOBLIN_FORK_WAIT);
    ;       sleep(exenv->options->flags & PGOBLIN_FORK_WAIT);
    ;   }
    ;   for (g = 0; g < PGOBLIN_REGSIZE; g++) {
#           define R exenv->options->io[g]
    ;       if  (R.mife && (R.mife->fd != fileno(stdin)) && (R.mife->fd != fileno(stdout))) {
    ;           if  ((R.flags & PGOBLIN_FREEMIFE) && (ex = mife_close(R.mife)))
                    ifBLIN_QV1(exenv->options->flags) warn("mife_close in exec");
    ;       }
    ;       if  (R.clo && (R.onu != fileno(stdin)) && (R.onu != fileno(stdout))) {
    ;           if  ((R.flags & PGOBLIN_FREEOUTS) && (ex = R.clo(R.onu)))
                    ifBLIN_QV1(exenv->options->flags) warn("clo in exec");
    ;       }
#           undef R
    ;   }
    ;   execve(argv[0], argv, exenv->options->envp);
    ;   ex = EX_OSERR;
        ifBLIN_QV1(exenv->options->flags) warn("execve %s", argv[0]);
    }
    ifBLIN_QV5(exenv->options->flags) fprintf( stderr, "-local_exec %d\n", ex);
    return(ex);
}

static int
local_wait(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK, exx = EX_OK, status;
    pgoblin_jobreg *rj;
    pgoblin_jobl *j;
    size_t i;

    rj = R_JOB;
    if  (rj) {
        ifBLIN_QV5(rj->flags) fprintf(stderr, "+local_wait\n");
        for (i = 0; i <  MULAR_NEXT(rj->pids); i++) {
            j = mular_getix(rj->pids, i);
            if  (!(j->pid)) {
                ifBLIN_QV1(rj->flags) warnx("No pid in %d", (int)j->cmdn);
                errno = EINVAL;
                ex = EX_SOFTWARE;
            } else if ((j->cmdn >= 0) && (j->status == PGOBLIN_NOSTATUS)) {
                if  ((ex = waitpid(j->pid, &status, 0)) < 0) {
                    ifBLIN_QV1(rj->flags) warn("Pid %d in %d", j->pid, (int)j->cmdn);
                    ex = EX_OSERR;
                } else if (ex == j->pid) {
                    j->status = status;
                    ifBLIN_QV4(rj->flags)
                        fprintf( stderr
                               , "local_wait st=%08X fl=%08X ex=%d exx=%d IFEX=%d EXST=%d\n"
                               , status, rj->flags, ex, exx, WIFEXITED(status), WEXITSTATUS(status)
                               );
                    if  (  (rj->flags & PGOBLIN_ERROR_SENSOR)
                        && WIFEXITED(status)
                        && WEXITSTATUS(status)
                        ) exx = WEXITSTATUS(status);
                    if  ((rj->flags & PGOBLIN_ERROR_SENSIB) && exx) break;
                    ex = EX_OK;
                } else {
                    ifBLIN_QV1(rj->flags) warn("Pid %d<>%d in %d", ex, j->pid, (int)j->cmdn);
                    ex = EX_OSERR;
        }   }   }
        ifBLIN_QV5(rj->flags) fprintf(stderr, "-pgoblin_wait %d\n", ex);
    }
    return(ex ? ex : exx);
}

static pgoblin_dir*
local_dir(pgoblin_exenv *exenv, pgoblin_dir *dir, char *path) {
    pgoblin_dir *d = NULL;
    int ex = EX_OK;
    FTSENT *ent;

    if  (!dir == !path) {
        ifBLIN_QV1(exenv->options->flags) warnx("local: exactly one of dir and path should be");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (path) {
        char *p[2] = {NULL, NULL};

        if  (!(d = calloc(1, sizeof(pgoblin_dir)))) {
            ifBLIN_QV1(exenv->options->flags) warnx("local dir: no mem");
            ERROUT(EX_OSERR, ENOMEM);
        }
        d->i = 0;
        d->f = 1;
        d->g = 1;
        p[0] = path;
        if  (!(d->dirp = fts_open(p, FTS_PHYSICAL | FTS_NOCHDIR | FTS_SEEDOT, NULL))) {
            ifBLIN_QV1(exenv->options->flags) warnx("local dir: no fts");
            ERROUT(EX_OSERR, EIO);
        }
    } else {
        d = dir;
        d->i += d->g;
        d->g = 1;
    }
    for (;;) {
        if  (!(ent = fts_read(d->dirp))) {
            if  (d->dirp) fts_close(d->dirp);
            free(d);
            d = NULL;
            break;
        }
        switch(ent->fts_info) {
        case FTS_SLNONE:
        case FTS_DP:
            continue;
        case FTS_SL:
            fts_set(d->dirp, ent, FTS_FOLLOW);
            d->g = 0;
            break;
        case FTS_DOT:
        case FTS_DC:
        case FTS_D:
            if  (d->f) {
                d->f = 0;
                continue;
            } else fts_set(d->dirp, ent, FTS_SKIP);
            /* FALLTHRU */
        case FTS_DEFAULT:
        case FTS_F:
            break;
        case FTS_DNR:
            ifBLIN_QV2(exenv->options->flags) warnc(ent->fts_errno, "local dir: fts_read DNR");
            break;
        case FTS_NS:
            ifBLIN_QV2(exenv->options->flags) warnc(ent->fts_errno, "local dir: fts_read NS");
            /* FALLTHRU */
        case FTS_NSOK:
            ent->fts_statp = NULL;
            break;
        case FTS_ERR:
            errno = ent->fts_errno;
            ifBLIN_QV1(exenv->options->flags) warn("local dir: fts_read");
            ex = EX_OSERR;
            goto out;
        default:
            ifBLIN_QV1(exenv->options->flags) warn("local dir: unknown fts_read");
            ERROUT(EX_OSERR, EIO);
        }
        d->sb = ent->fts_statp;
        d->ent = ent->fts_name;
        break;
    }
out:
    if  (ex) {
        if  (d) {
            if  (d->dirp) fts_close(d->dirp);
            free(d);
            d = NULL;
    }   }
    return(d);
}

pgoblin_jobs pgoblin_job_local =
{ 0
, "4pGoblin-" VERS
, "local\0" VERS
, pgoblin_finit
, pgoblin_finit
, pgoblin_open
, local_test
, local_none /* fork */
, local_exec
, local_wait
, local_none /* close */
, local_dir
};
