/*-
 * Copyright (C) @BABOLO  2002 Dec 23
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 23\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: execute.c,v 1.80 2009/11/17 09:04:40 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <mife.h>
#include <err.h>
#include <multilar.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include "pgoblin.h"
#include "pgob.h"

static int
pgoblin_connown(pgoblin_main *options) {
    int ex = EX_OK; /* All errors must be < 0 */
    ssize_t g;

    ifBLIN_QV5(options->flags) fprintf(stderr, "+pgoblin_connown\n");
    for (g = 0; g < PGOBLIN_REGSIZE; g++) {
        options->conn[g].flags &= ~PGOBLIN_CLOSECONN;
    }
    ifBLIN_QV5(options->flags) fprintf(stderr, "-pgoblin_connown %d\n", ex);
    return(ex);
}

static size_t u12[] = {341, 512, 512};

pgoblin_main *
pgoblin_init(u_int32_t flags, int outfd) {
    pgoblin_main *options = NULL;
    int ex = EX_OK;

    ifBLIN_QV3(flags) fprintf(stderr, "+pgoblin_init options=%s\n", options ? "OK" : "NULL");
    if  (!(options = malloc(sizeof(pgoblin_main)))) {
        errno = ENOMEM;
    } else {
        pgoblin_jobl *j;

        bzero(options, sizeof(pgoblin_main));
        options->flags = flags;
        strncpy(options->vers, VERS, 4);
        options->maxtmout = 3600000;
        strncpy((char*)options->delim, "#", 3);

        MARK_IO_OUT_GO(IO_RG0);;
        ;;  IO_RG0.onu = outfd;
        ;;  IO_RG0.wri = (int(*)(int, const void *, size_t))mife_writ;
        ;;  IO_RG0.flags |= PGOBLIN_OUTSET;
        MARK_IO_OUT_WENT(IO_RG0);;

        pgoblin.jobtable[0] = &pgoblin_job_local;
        if  ((ex = pgoblin_job_local.init(flags, &pgoblin_job_local))) {
            ifBLIN_QV1(flags) warn("JOB %s init failed", pgoblin_job_local.name);
            pgoblin.jobtable[0] = NULL;
        } else {
            MARK_R_JOB_GO(&(options->job[0]));;
            ;;  options->job[0].pids = mular_create(MULAR_ZERO, 3, sizeof(pgoblin_jobl), u12);
            MARK_R_JOB_WENT(&(options->job[0]));;
            j = mular_add(options->job[0].pids);
            j->cmdn = -1;
            j->pid = getppid();
            j->status = PGOBLIN_NOSTATUS;
            j = mular_add(options->job[0].pids);
            j->cmdn = -1;
            j->pid = getpid();
            j->status = PGOBLIN_NOSTATUS;
        }
        pgoblin.dbasetable[PGOBLIN_DB_0] = &pgoblin_db_0;
        if  ((ex = pgoblin_db_0.init(flags, &pgoblin_db_0))) {
            ifBLIN_QV1(flags) warn("DB %s init failed", pgoblin_db_0.name);
            pgoblin.dbasetable[PGOBLIN_DB_0] = NULL;
        }
#ifdef HAVE_DB_PGSQL
        pgoblin.dbasetable[PGOBLIN_DB_PGSQL] = &pgoblin_db_pgsql;
        if  ((ex = pgoblin_db_pgsql.init(flags, &pgoblin_db_pgsql))) {
            ifBLIN_QV1(flags) warn("DB %s init failed", pgoblin_db_pgsql.name);
            pgoblin.dbasetable[PGOBLIN_DB_PGSQL] = NULL;
        }
#endif
#ifdef HAVE_DB_SQLITE2
        pgoblin.dbasetable[PGOBLIN_DB_SQLIT2] = &pgoblin_db_sqlite2;
        if  ((ex = pgoblin_db_sqlite2.init(flags, &pgoblin_db_sqlite2))) {
            ifBLIN_QV1(flags) warn("DB %s init failed", pgoblin_db_sqlite2.name);
            pgoblin.dbasetable[PGOBLIN_DB_SQLIT2] = NULL;
        }
#endif
#ifdef HAVE_DB_SQLITE3
        pgoblin.dbasetable[PGOBLIN_DB_SQLIT3] = &pgoblin_db_sqlite3;
        if  ((ex = pgoblin_db_sqlite3.init(flags, &pgoblin_db_sqlite3))) {
            ifBLIN_QV1(flags) warn("DB %s init failed", pgoblin_db_sqlite3.name);
            pgoblin.dbasetable[PGOBLIN_DB_SQLIT3] = NULL;
        }
#endif
        pgoblin.styletable[0] = &pgoblin_style_0;
        if  ((ex = pgoblin_style_0.init(flags, &pgoblin_style_0))) {
            ifBLIN_QV1(flags) warn("DB %s init failed", pgoblin_style_0.name);
            pgoblin.styletable[0] = NULL;
        }
        pgoblin.styletable[1] = &pgoblin_style_pgo0;
        if  ((ex = pgoblin_style_pgo0.init(flags, &pgoblin_style_pgo0))) {
            ifBLIN_QV1(flags) warn("DB %s init failed", pgoblin_style_pgo0.name);
            pgoblin.styletable[1] = NULL;
    }   }
    ifBLIN_QV3(flags) fprintf(stderr, "-pgoblin_init %s\n", options ? "OK" : "FAIL");
    return(options);
}

void
pgoblin_fini(pgoblin_main *options) {
    pgoblin_style_pgo0.fini(options->flags, &pgoblin_style_pgo0);
    pgoblin_style_0.fini(options->flags, &pgoblin_style_0);
#ifdef HAVE_DB_SQLITE3
    pgoblin_db_sqlite3.fini(options->flags, &pgoblin_db_sqlite3);
#endif
#ifdef HAVE_DB_SQLITE2
    pgoblin_db_sqlite2.fini(options->flags, &pgoblin_db_sqlite2);
#endif
#ifdef HAVE_DB_PGSQL
    pgoblin_db_pgsql.fini(options->flags, &pgoblin_db_pgsql);
#endif
    pgoblin_db_0.fini(options->flags, &pgoblin_db_0);
    pgoblin_job_local.fini(options->flags, &pgoblin_job_local);
    free(options);
}

#define R options->io[r]

static void
dump_ioreg(pgoblin_main *options, int r) {
    u_int32_t wdr, cdr;

    fprintf( stderr, "[%c](%06X%s%s%s%s%s%s%s%s%s%s%s%s):"
           , pgoblin_regn[r], R.flags
           , (R.flags & PGOBLIN_PATHPARM) ? " path"  : ""
           , (R.flags & PGOBLIN_FREEPATH) ? " path*" : ""
           , (R.flags & PGOBLIN_FILEOVER) ? " over"  : ""
           , (R.flags & PGOBLIN_TEXTPARM) ? " text"  : ""
           , (R.flags & PGOBLIN_FREETEXT) ? " text*" : ""
           , (R.flags & PGOBLIN_BINPARM ) ? " bin"   : ""
           , (R.flags & PGOBLIN_MIFEDES ) ? " mife"  : ""
           , (R.flags & PGOBLIN_FREEMIFE) ? " mife*" : ""
           , (R.flags & PGOBLIN_PQRESULT) ? " pq"    : ""
           , (R.flags & PGOBLIN_FREEPQRE) ? " pq*"   : ""
           , (R.flags & PGOBLIN_OUTSET  ) ? " out"   : ""
           , (R.flags & PGOBLIN_FREEOUTS) ? " out*"  : ""
           );
    if  (R.mife) {
        fprintf(stderr, " mife=%" BLIN_X, BLIN_I(R.mife));
        fprintf(stderr, " pid=%d", R.pid);
    }
    if  (R.pq) {
        fprintf(stderr, " pq=%" BLIN_X, BLIN_I(R.pq));
        fprintf(stderr, " flagc=%08X", R.flagc);
    }
    wdr = BLIN_I(R.wri);
    if  (wdr == BLIN_I(write)) fprintf(stderr, " wri=write");
    else if (wdr == BLIN_I(mife_writ)) fprintf(stderr, " wri=mife_writ");
    else if (wdr) fprintf(stderr, " wri=%" BLIN_X, wdr);

    cdr = BLIN_I(R.clo);
    if  (cdr == BLIN_I(close)) fprintf(stderr, " clo=close");
    else if (cdr) fprintf(stderr, " clo=%08X", cdr);

    if  (wdr || cdr) fprintf(stderr, " onu=%d", R.onu);
    fprintf(stderr, "\n");

    if  (R.path) fprintf(stderr, " path=%s~\n", R.path);
    if  (R.text) {
        if  (!(R.flags & PGOBLIN_BINPARM)) {
            fprintf(stderr, " text=%s~\n", (char*)R.text);
        } else ifBLIN_QV5(options->flags) {
            int i;

            fprintf(stderr, " text=");
            for (i = 0; i < R.length; i++) {
                if  (  ((((u_char*)R.text)[i] >= 0177) && (((u_char*)R.text)[i] < 0300))
                    || (((u_char*)R.text)[i] < ' ')
                    ) {
                    fprintf(stderr, "\\%03o", ((u_char*)R.text)[i]);
                } else if (((char*)R.text)[i] == '\\') {
                    fprintf(stderr, "\\\\");
                } else {
                    fprintf(stderr, "%c", ((char*)R.text)[i]);
            }   }
            fprintf(stderr, "~\n");
        } else {
            fprintf(stderr, " text %" BLIN_X " length %d\n", BLIN_I(R.text), (int)R.length);
}   }   }

#undef R
#define R exenv->options->io[r]

static void
iorassert(pgoblin_exenv *exenv, pgoblin_command cmd) {
    int r;
    u_int32_t e;
    u_char rr[PGOBLIN_REGSIZE + 1], rp[PGOBLIN_REGSIZE + 1];
    const u_char hex[16] = "0123456789ABCDEF";
#   define W "cmd[%d]=%03X fl[%d]=%08X "

    for (r = 0; r < PGOBLIN_REGSIZE; r++) {
        e = 0;
        if  (R.path) e |= PGOBLIN_PATHPARM;
          else if (R.flags & PGOBLIN_PATHPARM)
            warnx(W "  path", (int)exenv->ppoint, cmd, r, R.flags);
          else if (R.flags & PGOBLIN_FREEPATH)
            warnx(W "  path", (int)exenv->ppoint, cmd, r, R.flags);
        if  (R.text) e |= PGOBLIN_TEXTPARM;
          else if (R.flags & PGOBLIN_TEXTPARM)
            warnx(W "  text", (int)exenv->ppoint, cmd, r, R.flags);
          else if (R.flags & PGOBLIN_FREETEXT)
            warnx(W "  text", (int)exenv->ppoint, cmd, r, R.flags);
        if  (R.mife) e |= PGOBLIN_MIFEDES;
          else if (R.flags & PGOBLIN_MIFEDES)
            warnx(W "  mife", (int)exenv->ppoint, cmd, r, R.flags);
          else if (R.flags & PGOBLIN_FREEMIFE)
            warnx(W "  mife", (int)exenv->ppoint, cmd, r, R.flags);
        if  (R.pq) e |= PGOBLIN_PQRESULT;
          else if (R.flags & PGOBLIN_PQRESULT)
            warnx(W "  pq", (int)exenv->ppoint, cmd, r, R.flags);
          else if (R.flags & PGOBLIN_FREEPQRE)
            warnx(W "  pq", (int)exenv->ppoint, cmd, r, R.flags);
        ifBLIN_QV2(exenv->options->flags)
            if  (!(R.flags & PGOBLIN_ANYIVL) && e)
                warnx(W "  %02X", (int)exenv->ppoint, cmd, r, R.flags, e);
        if  (R.wri) {
            e |= PGOBLIN_OUTSET;
            ifBLIN_QV2(exenv->options->flags)
                if  (!(R.flags & PGOBLIN_OUTSET))
                    warnx(W "  wri", (int)exenv->ppoint, cmd, r, R.flags);
        } else if (R.flags & (PGOBLIN_OUTSET | PGOBLIN_FREEOUTS)) {
            warnx(W "  wri", (int)exenv->ppoint, cmd, r, R.flags);
        }
        ifBLIN_QV2(exenv->options->flags)
            if  (R.clo && !(R.flags & PGOBLIN_FREEOUTS))
                warnx(W "  clo", (int)exenv->ppoint, cmd, r, R.flags);
        rr[r] = e;
    }
    ifBLIN_QV3(exenv->options->flags) {
        /*    - ,
         *     ,
         *     .
         */
        for (r = 0; r < PGOBLIN_REGSIZE; r++) {
            rp[r] = pgoblin_regn[rr[r]];
            if  (rr[r] == (R.flags & (PGOBLIN_ANYIVL | PGOBLIN_OUTSET))) rr[r] = '=';
              else rr[r] = pgoblin_regn[R.flags & (PGOBLIN_ANYIVL | PGOBLIN_OUTSET)];
        }
        rr[PGOBLIN_REGSIZE] = rp[PGOBLIN_REGSIZE] = '\0';
        fprintf(stderr, "regs %s\n", rp);
        fprintf(stderr, "flag %s\n", rr);
    }
    ifBLIN_QV5(exenv->options->flags) {
        /*    -    */
        fprintf(stderr, "      00     08     10     18     20     28     30     38\n");
        for (r = 0; r < PGOBLIN_REGSIZE; r++) rr[r] = ' ';
        rr[1] = '0';
        rr[56] = '\0';
        for (r = 0; r < PGOBLIN_REGSIZE; r++) {
            e = ((r << 3) & 070) | ((r >> 3) & 007);
            rr[(r & 007) * 7 + 6] = hex[(e >> 4) & 0x0F];
            rr[(r & 007) * 7 + 7] = hex[e & 0x0F];
            rr[(r & 007) * 7 + 9] = pgoblin_regn[e];
            if  ((r & 007) == 007) {
                rr[2] = hex[(r >> 3) & 007];
                fprintf(stderr, "%s\n", rr);
}   }   }   }
#undef W
#undef R

/*
 *   IO      . score[][] 
 *  -     r ()   ch ()   
 *  .     procomp(options, r, ch).  
 *   propush(exenv, r, ch)  ,     
 *  ,  ,  Co   propush(), 
 *    Cf, Ct, Cm, Cq  Cw  cleareg(options, r, m),  m
 *   ,   procomp() -     .
 *       exenv->exeflags,      (
 * Ce == PGOBLIN_FORKOUT)   ( Cs, Cp, Cu  PGOBLIN_FREE*) 
 *  .
 */

static int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
cleareg(pgoblin_main *options, pgoblin_io *r, u_int32_t m) {        /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK;

    ifBLIN_QV5(options->flags) fprintf(stderr, "+cleareg %" BLIN_X " %08X\n", BLIN_I(r), m);
    if  (m & PGOBLIN_PATHPARM) {
        MARK_IO_PATH_GO(r);;
        ;;  if  (r->path && (r->flags & PGOBLIN_FREEPATH)) free(r->path);
        ;;  r->path = NULL;
        ;;  r->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        MARK_IO_PATH_WENT(r);;
    }
    if  (m & PGOBLIN_TEXTPARM) {
        MARK_IO_TEXT_GO(r);;
        ;;  if  (r->text && (r->flags & PGOBLIN_FREETEXT)) free(r->text);
        ;;  r->text = NULL;
        ;;  r->length = 0;
        ;;  r->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_TEXTPARM | PGOBLIN_BINPARM);
        MARK_IO_TEXT_WENT(r);;
    }
    if  (m & PGOBLIN_PQRESULT) {
        MARK_IO_PQ_GO(r);;
        ;;  if  (r->pq && (r->flags & PGOBLIN_FREEPQRE)) {
        ;;      DBASE(r->flagc)->finish(r->flagc, PGOBLIN_CleaRes, &r->pq);
        ;;  }
        ;;  r->pq = NULL;
        ;;  r->flagc = 0;
        ;;  r->flags &= ~(PGOBLIN_FREEPQRE | PGOBLIN_PQRESULT);
        MARK_IO_PQ_WENT(r);;
    }
    if  (m & PGOBLIN_MIFEDES) {
        MARK_IO_MIFE_GO(r);;
        ;;  if  (r->mife && (r->flags & PGOBLIN_FREEMIFE) && (ex = mife_close(r->mife))) {
        ;;      ifBLIN_QV1(options->flags) warn("mife_close in cleareg");
        ;;  }
        ;;  r->mife = NULL;
        ;;  r->offset = 0;
        ;;  r->pid = 0;
        ;;  r->flags &= ~(PGOBLIN_FREEMIFE | PGOBLIN_MIFEDES);
        MARK_IO_MIFE_WENT(r);;
    }
    if  (m & PGOBLIN_OUTSET) {
        MARK_IO_OUT_GO(r);;
        ;;  if  (r->clo && (r->flags & PGOBLIN_FREEOUTS) && (ex = r->clo(r->onu))) {
        ;;      ifBLIN_QV1(options->flags) warn("clo in cleareg");
        ;;  }
        ;;  r->clo = NULL;
        ;;  r->wri = NULL;
        ;;  r->onu = 0;
        ;;  r->flags &= ~(PGOBLIN_OUTSET | PGOBLIN_FREEOUTS);
        MARK_IO_OUT_WENT(r);;
    }
    ifBLIN_QV5(options->flags) fprintf(stderr, "-cleareg %d\n", ex);
    return(ex);
}

#define Cx PGOBLIN_IGNORE   /* impossible         */
#define Co PGOBLIN_OPEN     /* open               */
#define Cf PGOBLIN_PATHPARM /* free path          */
#define Ct PGOBLIN_TEXTPARM /* free text          */
#define Cm PGOBLIN_MIFEDES  /* free mife          */
#define Cq PGOBLIN_PQRESULT /* free pq            */
#define Cw PGOBLIN_OUTSET   /* free wri           */
#define Ce PGOBLIN_FORKOUT  /* fork               */
#define Cs PGOBLIN_FREEPATH /* stream file out    */
#define Cp PGOBLIN_FREETEXT /* copy text out      */
#define Cu PGOBLIN_FREEPQRE /* unstore pq out     */

static const u_int32_t score[32][4] =
 /*ftmqw          Pf           Pt           Pm           Pq   Wish*/
{/*00000*/{0              ,0           ,          Ce,0           }
,/*10000*/{ Co|Cf|      Cs, Co|      Cp, Co         , Co|      Cu}
,/*01000*/{       Ct      ,    Ct      ,    Ct|   Ce,    Ct      }
,/*11000*/{ Co|Cf|Ct|   Cs, Co|Ct|   Cp, Co|Ct      , Co|Ct|   Cu}
,/*00100*/{ Cm            , Cm         ,          Ce, Cm         }
,/*10100*/{ Co|Cf|      Cs, Co|      Cp, Co         , Co|      Cu}
,/*01100*/{ Cm|   Ct      , Cm|Ct      ,    Ct|   Ce, Cm|Ct      }
,/*11100*/{ Co|Cf|Ct|   Cs, Co|Ct|   Cp, Co|Ct      , Co|Ct|   Cu}
,/*00010*/{          Cq   ,       Cq   ,       Cq|Ce,       Cq   }
,/*10010*/{ Co|Cf|   Cq|Cs, Co|   Cq|Cp, Co|   Cq   , Co|   Cq|Cu}
,/*01010*/{       Ct|Cq   ,    Ct|Cq   ,    Ct|Cq|Ce,    Ct|Cq   }
,/*11010*/{ Co|Cf|Ct|Cq|Cs, Co|Ct|Cq|Cp, Co|Ct|Cq   , Co|Ct|Cq|Cu}
,/*00110*/{ Cm|      Cq   , Cm|   Cq   ,       Cq|Ce, Cm|   Cq   }
,/*10110*/{ Co|Cf|   Cq|Cs, Co|   Cq|Cp, Co|   Cq   , Co|   Cq|Cu}
,/*01110*/{ Cm|   Ct|Cq   , Cm|Ct|Cq   ,    Ct|Cq|Ce, Cm|Ct|Cq   }
,/*11110*/{ Co|Cf|Ct|Cq|Cs, Co|Ct|Cq|Cp, Co|Ct|Cq   , Co|Ct|Cq|Cu}
,/*00001*/{             Cs,          Cp,0           ,          Cu}
,/*10001*/{    Cf|      Cs,          Cp,0           ,          Cu}
,/*01001*/{       Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*11001*/{    Cf|Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*00101*/{             Cs,          Cp,0           ,          Cu} /* IO_RG0 */
,/*10101*/{    Cf|      Cs,          Cp,0           ,          Cu}
,/*01101*/{       Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*11101*/{    Cf|Ct|   Cs,    Ct|   Cp,    Ct      ,    Ct|   Cu}
,/*00011*/{          Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*10011*/{    Cf|   Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*01011*/{       Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*11011*/{    Cf|Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*00111*/{          Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*10111*/{    Cf|   Cq|Cs,       Cq|Cp,       Cq   ,       Cq|Cu}
,/*01111*/{       Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
,/*11111*/{    Cf|Ct|Cq|Cs,    Ct|Cq|Cp,    Ct|Cq   ,    Ct|Cq|Cu}
}/* Reg */;

static u_int32_t
/**********************************************************************
 **********************************************************************
 **                                                                  **/
procomp(pgoblin_main *options, pgoblin_io *r, u_int32_t ch) {       /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int i, j;
    u_int32_t price, abil;

    abil = 0;
    for (j = 0; j < 5; j++) { /* From */
        if  (  ((j == 0) && (r->path))
            || ((j == 1) && (r->text))
            || ((j == 2) && (r->mife))
            || ((j == 3) && (r->pq  ))
            || ((j == 4) && (r->wri ))
            ) {
            abil |= (1 << j);
    }   }

    price = 0;
    for (i = 0; i < 4; i++) { /* To */
        if  (  ((i == 0) && (ch & PGOBLIN_PATHPARM))
            || ((i == 1) && (ch & PGOBLIN_TEXTPARM))
            || ((i == 2) && (ch & PGOBLIN_MIFEDES ))
            || ((i == 3) && (ch & PGOBLIN_PQRESULT))
            ) {
            ifBLIN_QV4(options->flags) fprintf(stderr, "%d abil=%02X %04X\n", i, abil, score[abil][i]);
            price |= score[abil][i];
    }   }
    ifBLIN_QV4(options->flags) fprintf(stderr, "abil=%02X %04X\n", abil, price);
    return(price);
}

static int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
propush(pgoblin_exenv *exenv, pgoblin_io *r, u_int32_t ch) {        /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    u_int32_t price;
    int ex = EX_OK;

    ifBLIN_QV5(exenv->options->flags) fprintf( stderr, "+propush ch=%02X io=%08X%s%s%s%s\n"
                                             , ch, r->flags
                                             , r->path ? " path" : ""
                                             , r->text ? " text" : ""
                                             , r->wri  ? " mife" : ""
                                             , r->pq   ? " pq"   : ""
                                             );
    if  (!(ch & PGOBLIN_OUTSET)) {
        ifBLIN_QV1(exenv->options->flags) warnx("No output in propush");
        ERROUT(EX_DATAERR, EINVAL);
    } else if (  ((r->flags & PGOBLIN_PATHPARM) && !r->path)
              || ((r->flags & PGOBLIN_TEXTPARM) && !r->text)
              || ((r->flags & PGOBLIN_OUTSET  ) && !r->wri )
              || ((r->flags & PGOBLIN_PQRESULT) && !r->pq  )
              ) {
        ifBLIN_QV1(exenv->options->flags) warnx("No info f=%08X", r->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    price = procomp(exenv->options, r, ch);
    if  (price & Cx) {
        ifBLIN_QV1(exenv->options->flags) warnx("No way @%d f=%08X", (int)exenv->ppoint, r->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (price & Co) {
        int o;

        o = open( r->path
                , O_WRONLY | O_CREAT | ((r->flags & PGOBLIN_FILEOVER) ? O_TRUNC : O_APPEND)
                , 0666
                );
        if  (o < 0) {
            ifBLIN_QV1(exenv->options->flags)
                warn("Open %s%s", r->path, (r->flags & PGOBLIN_FILEOVER) ? " over" : "");
            ex = EX_IOERR;
            goto out;
        }
        MARK_IO_OUT_GO(r);;
        ;;  r->onu = o;
        ;;  r->clo = close;
        ;;  r->wri = (int(*)(int, const void *, size_t))mife_writ;
        ;;  r->flags |= PGOBLIN_FREEOUTS;
        MARK_IO_OUT_WENT(r);;
    }
    ex = cleareg(exenv->options, r, price);
    if  (!ex) exenv->exeflags |= price;
out:
    ifBLIN_QV5(exenv->options->flags) fprintf(stderr, "-propush %d\n", ex);
    return(ex);
}

/*
 *   IO    . dcore[][]   
 *      .       
 *    ( )     .  
 *      D*. coercion(exenv, r, ch)  
 * coercomp(options, r, ch)    ,     
 *     D*.       
 *      r      ch   
 * ,    . ,   r  ,
 *   ch,   0     .
 */

#define DC 0x000F /* price              */
#define Dx 0x8000 /* impossible         */
#define Dq 0x4000 /* read to text       */
#define Do 0x2000 /* open file name     */
#define Dr 0x1000 /* read file          */
#define Dl 0x0800 /* db_0 from text     */
#define Dn 0x0400 /* temp file name     XXXX */
#define Dw 0x0200 /* write file         XXXX */
#define Dm 0x0100 /* do mife from text  */
#define Da 0x0080 /* throw pq to file   XXXX */
#define Db 0x0040 /* throw mife to file XXXX */

static const u_int16_t dcore[4][4] =
      /*              Pf          Pt          Pm          Pq   Reg */
{/* Pf */{             0, Dx|Dn|Dw|7, Dx|Dn|Db|9, Dx|Dn|Da|8}
,/* Pt */{    Do|Dr   |4,          0,    Dr   |3,    Dq   |5}
,/* Pm */{    Do      |1,       Dm|2,          0,    Dq|Dm|6}
,/* Pq */{    Do|Dr|Dl|5,       Dl|1,    Dr|Dl|4,          0}
}/*Wish*/;

static u_int32_t
/**********************************************************************
 **********************************************************************
 **                                                                  **/
coercomp(pgoblin_main *options, pgoblin_io *r, u_int32_t ch) {      /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
/*
 *        r     ch 
 */
    int i, j, surprise;
    u_int32_t price;

    price = Dx | 15;
    surprise = 1;
    for (i = 0; i < 4; i++) { /* To */
        if  (  ((i == 0) && (ch & PGOBLIN_PATHPARM))
            || ((i == 1) && (ch & PGOBLIN_TEXTPARM))
            || ((i == 2) && (ch & PGOBLIN_MIFEDES ))
            || ((i == 3) && (ch & PGOBLIN_PQRESULT))
            ) {
            surprise = 0;
            for (j = 0; j < 4; j++) { /* From */
                if  (  (  ((j == 0) && (r->path))
                       || ((j == 1) && (r->text))
                       || ((j == 2) && (r->mife))
                       || ((j == 3) && (r->pq  ))
                       )
                    && (dcore[i][j] & DC) < (price & DC)
                    ) {
                    price = dcore[i][j];
                    ifBLIN_QV4(options->flags)
                        fprintf(stderr, "i=%d j=%d %04X\n", i, j, dcore[i][j]);
    }   }   }   }
    return(surprise ? 0 : price);
}

static int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
coercion(pgoblin_exenv *exenv, pgoblin_io *r, u_int32_t ch) {       /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
/*
 *     r     ch 
 */
    u_int32_t price;
    int ex = EX_OK;

    ifBLIN_QV5(exenv->options->flags) fprintf( stderr, "+coercion ch=%02X io=%08X%s%s%s%s\n"
                                             , ch, r->flags
                                             , r->path ? " path" : ""
                                             , r->text ? " text" : ""
                                             , r->mife ? " mife" : ""
                                             , r->pq   ? " pq"   : ""
                                             );
    if  (ch & PGOBLIN_OUTSET) {
        ifBLIN_QV1(exenv->options->flags) warnx("Output in coercion");
        ERROUT(EX_DATAERR, EINVAL);
    } else if (  ((r->flags & PGOBLIN_PATHPARM) && !r->path)
              || ((r->flags & PGOBLIN_TEXTPARM) && !r->text)
              || ((r->flags & PGOBLIN_MIFEDES ) && !r->mife)
              || ((r->flags & PGOBLIN_PQRESULT) && !r->pq  )
              ) {
        ifBLIN_QV1(exenv->options->flags) warnx("No info f=%08X", r->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    price = coercomp(exenv->options, r, ch);
    if  (price & Dx) {
        ifBLIN_QV1(exenv->options->flags) warnx("No way @%d f=%08X", (int)exenv->ppoint, r->flags);
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (price & Dq) {
        if  ((ex = pgoblin_style_0.table(r, exenv->options->style, r, 0, -2)) < 0) {
            ifBLIN_QV1(exenv->options->flags) warn("coercion: No STYLE 0");
            goto out;
    }   }
    if  (price & Do) {
        MARK_IO_MIFE_GO(r);;
        ;;  r->offset = 0;
        ;;  r->pid = 0;
        ;;  r->mife = mife_open(PGOBLIN_MIFEFLAGS, r->path);
        ;;  r->flags |= PGOBLIN_FREEMIFE;
        MARK_IO_MIFE_WENT(r);;
        if  (!r->mife) {
            r->flags &= ~(PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE);
            ifBLIN_QV1(exenv->options->flags) warn("coercion mife open %s", r->path);
            ex = EX_IOERR;
            goto out;
    }   }
    if  (price & Dr) {
        size_t l;
        void *t;

        if  ((l = mife_read(r->mife, 0, 0)) < 0) {
            ifBLIN_QV1(exenv->options->flags) warnx("mife_read");
            ex = EX_IOERR;
            goto out;
        }
        if  (!(t = mife_get(r->mife, 0))) {
            ifBLIN_QV1(exenv->options->flags) warnx("mife_get");
            ex = EX_IOERR;
            goto out;
        }
        MARK_IO_TEXT_GO(r);;
        ;;  r->length = l;
        ;;  r->text = t;
        ;;  r->flags |= PGOBLIN_BINPARM;
        ;;  r->flags &= ~PGOBLIN_FREETEXT;
        MARK_IO_TEXT_WENT(r);;
    }
    if  (price & Dl) {
        pgoblin_conn conn0;

        conn0.flags = (exenv->options->flags & BLIN_VERMASK) | PGOBLIN_DB_0;
        MARK_IO_TEXT_GO(r);;
        ;;  r->flags &= ~PGOBLIN_FREETEXT;
        MARK_IO_TEXT_WENT(r);;
        MARK_IO_PQ_GO(r);;
        ;;  pgoblin_db_0.execute(&conn0, &(r->pq), NULL, 1, (const char **)&(r->text), NULL, 0);
        ;;  r->flagc = (exenv->options->flags & BLIN_VERMASK) | PGOBLIN_DB_0;
        ;;  r->flags |= PGOBLIN_FREEPQRE;
        MARK_IO_PQ_WENT(r);;
    }
    if  (price & Dn) /* XXXX */;
    if  (price & Dw) /* XXXX */;
    if  (price & Dm) {
        mife_descriptor *m;

        if  (r->flags & (PGOBLIN_FREETEXT | PGOBLIN_BINPARM)) {
            m = mife_opes(PGOBLIN_MIFEFLAGS /* | MIFE_STRI */, r->text, r->length);
        } else {
            m = mife_opem(PGOBLIN_MIFEFLAGS /* | MIFE_STRI */, r->text, r->length);
        }
        if  (!m) {
            ifBLIN_QV1(exenv->options->flags) warnx("mife_ope{m|s}");
            ex = EX_IOERR;
            goto out;
        }
        MARK_IO_MIFE_GO(r);;
        ;;  r->mife = m;
        ;;  r->pid = 0;
        ;;  r->offset = 0;
        ;;  r->flags |= PGOBLIN_FREEMIFE;
        MARK_IO_MIFE_WENT(r);;
    }
    if  (price & Da) /* XXXX */;
    if  (price & Db) /* XXXX */;
out:
    ifBLIN_QV5(exenv->options->flags) fprintf(stderr, "-coercion %d\n", ex);
    return(ex);
}

static int
markproc(pgoblin_jobreg *g, int i, int nq, struct kevent *pkev) {
    int ex = EX_OK, exx = EX_OK, status;
    pgoblin_jobl *j;

    if  (nq == 0) {
    } else if ((nq > 0) && (pkev->filter == EVFILT_PROC) && (pkev->fflags & NOTE_EXIT)) {
        int i;

        for (i = 0; i < MULAR_NEXT(g->pids); i++) {
            j = mular_getix(g->pids, i);
            if  ((j->pid == pkev->ident) && (j->cmdn >= 0) && (j->status == PGOBLIN_NOSTATUS)) {
                if  (!(ex = waitpid(j->pid, &status, WNOHANG))) {
                    ifBLIN_QV1(g->flags) warnx("No status for pid %d at %d", j->pid, (int)j->cmdn);
                } else if (ex == j->pid) {
                    j->status = status;
                    g->dead++;
                    ifBLIN_QV4(g->flags)
                        fprintf( stderr
                               , "markproc st=%08X fl=%08X ex=%d exx=%d IFEX=%d EXST=%d\n"
                               , status, g->flags, ex, exx, WIFEXITED(status), WEXITSTATUS(status)
                               );
                    if  (  (g->flags & PGOBLIN_ERROR_SENSOR)
                        && WIFEXITED(status)
                        && WEXITSTATUS(status)
                        ) exx = WEXITSTATUS(status);
                    if  ((g->flags & PGOBLIN_ERROR_SENSIB) && exx) break;
                } else if (ex > 0) {
                    ifBLIN_QV1(g->flags) warn("Pid %d<>%d at %d", ex, j->pid, (int)j->cmdn);
                } else if (errno == ECHILD || errno == EDEADLK || errno == EAGAIN) {
                } else {
                    ifBLIN_QV1(g->flags) warn("Pid %d in %d", j->pid, (int)j->cmdn);
                }
                ex = EX_OK;
                goto out;
        }   }
        ifBLIN_QV1(g->flags) warnx("Pid %d not found", (int)pkev->ident);
    } else if ((errno == ESRCH) && (i >= 0)) {
        j = mular_getix(g->pids, i);
        j->status = PGOBLIN_LOSTSTAT;
        g->dead++;
    } else if (errno != EINTR) {
        ifBLIN_QV1(g->flags) warn("kevent for pid %d", (int)pkev->ident);
        ex = EX_OSERR;
    }
out:
    return(ex ? ex : exx);
}

static int
/**********************************************************************
 **********************************************************************
 **                                                                  **/
waitjob(pgoblin_jobreg *g) {                                        /**
 **                                                                  **
 **********************************************************************
 **********************************************************************/
    int ex = EX_OK, i, nq;
    struct timespec timeout;
    struct kevent kev;
    pgoblin_jobl *j;

    bzero(&timeout, sizeof(timeout));
    bzero(&kev, sizeof(kev));
    if  (!(g->flags & PGOBLIN_KQUEUED)) {
        if  ((g->kq = kqueue()) < 0) {
            ex = EX_OSERR;
            goto out;
        } else g->flags |= PGOBLIN_KQUEUED;
    }
    for (i = 0; i < MULAR_NEXT(g->pids); i++) {
        j = mular_getix(g->pids, i);
        if  (j->pid <= 0) {
            ifBLIN_QV1(g->flags) warnx("No pid in %d", (int)j->cmdn);
            errno = EINVAL;
            ex = EX_SOFTWARE;
        } else if ((j->cmdn >= 0) && (j->status == PGOBLIN_NOSTATUS)) {
            EV_SET(&kev, j->pid, EVFILT_PROC, EV_ADD | EV_ONESHOT | EV_CLEAR, NOTE_EXIT, 0, NULL);
            nq = kevent(g->kq, &kev, 1, &kev, 1, &timeout);
            ex = markproc(g, i, nq, &kev);
            if  (ex) goto out;
    }   }
    nq = 0;
    if  (MULAR_NEXT(g->pids) >= (g->concur + g->dead)) nq = kevent(g->kq, NULL, 0, &kev, 1, NULL);
    ex = markproc(g, -1, nq, &kev);
    while ((nq = kevent(g->kq, NULL, 0, &kev, 1, &timeout)) && !ex) {
        ex = markproc(g, -1, nq, &kev);
    }
out:
    return(ex);
}

static int
pgoblin_inx(pgoblin_main *options, pgoblin_io *r, int p[2], int c) {
    int ex = EX_OK; /* Errors must be < 0 */

    if  (c) close(p[1]);
    MARK_IO_MIFE_GO(r);;
    ;;  if  (!(r->mife = mife_opef(PGOBLIN_MIFEFLAGS, p[0]))) {
    ;;      ifBLIN_QV1(options->flags) warn("mife_opef inx");
    ;;      ex = -EX_NOINPUT;
    ;;  } else r->flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
    ;;  r->pid = 0;
    ;;  r->offset = 0;
    MARK_IO_MIFE_WENT(r);;
    return(ex);
}

static int
pgoblin_outx(pgoblin_main *options, pgoblin_io *r, int p[2], int c) {
    int ex = EX_OK; /* Errors must be < 0 */

    if  (c) close(p[0]);
    MARK_IO_OUT_GO(r);;
    ;;  r->onu = p[1];
    ;;  r->wri = (int(*)(int, const void *, size_t))mife_writ;
    ;;  r->clo = close;
    ;;  r->flags |= PGOBLIN_OUTSET | PGOBLIN_FREEOUTS;
    MARK_IO_OUT_WENT(r);;
    return(ex);
}

int
pgoblin_pipe(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;
    int pipa[2];

    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "+pgoblin_pipe %d %d\n", r[PGO_COUT].r, r[PGO_CIN].r);
    if  (pipe(pipa) < 0) {
        ifBLIN_QV1(exenv->options->flags) warn("pipe in pipe");
        close(pipa[0]);
        close(pipa[1]);
        ex = EX_OSERR;
    }
    if  (!(ex = pgoblin_inx(exenv->options, IO_IN, pipa, 0)))
        ex = pgoblin_outx(exenv->options, IO_OUT, pipa, 0);
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_pipe %d\n", ex);
    return(ex);
}

#define CICLEWARN(N,A) { int CICLEWARN_INTERNAL = N;                                                 \
    ifBLIN_QV2(options->flags)                                                                       \
        warnx( "cmd[%d]=[%03X(%s %c%c%c%c%c%c)].fl=%08X %s ch=%02X " A                               \
             , (int)exenv->ppoint, cmd, a_cmd->str                                                   \
             , pgoblin_regn[r[0].r], pgoblin_regn[r[1].r], pgoblin_regn[r[2].r]                      \
             , pgoblin_regn[r[3].r], pgoblin_regn[r[4].r], pgoblin_regn[r[5].r]                      \
             , a_cmd->flags, pgoblin.p[CICLEWARN_INTERNAL].name, r[CICLEWARN_INTERNAL].c             \
             );                                                                                      \
    continue;                                                                                        \
}
#define CICLEERR(A) {                                                                                \
    ifBLIN_QV1(options->flags)                                                                       \
        warn( "cmd[%d]=%03X(%s %c%c%c%c%c%c) %08X %02X %02X %02X %02X %02X %02X " A                  \
            , (int)exenv->ppoint, cmd, a_cmd->str                                                    \
            , pgoblin_regn[r[0].r], pgoblin_regn[r[1].r], pgoblin_regn[r[2].r]                       \
            , pgoblin_regn[r[3].r], pgoblin_regn[r[4].r], pgoblin_regn[r[5].r]                       \
            , a_cmd->flags, r[0].c, r[1].c, r[2].c, r[3].c, r[4].c, r[5].c                           \
            );                                                                                       \
}
#define DUMPIOREGS { int DUMPIOREGS_INTERNAL;                                                        \
    for (DUMPIOREGS_INTERNAL = 0; DUMPIOREGS_INTERNAL < PGOBLIN_REGSIZE; DUMPIOREGS_INTERNAL++) {    \
        if  (  (DUMPIOREGS_INTERNAL == r[PGO_COUT].r)                                                \
            || (DUMPIOREGS_INTERNAL == r[PGO_CCTL].r)                                                \
            || (DUMPIOREGS_INTERNAL == r[PGO_CIN].r)                                                 \
            ) {                                                                                      \
            dump_ioreg(options, DUMPIOREGS_INTERNAL);                                                \
}   }   }

int
/***********************************************
 ***********************************************
 **                                           **/
pgoblin_execute( pgoblin_main *options       /**/
/**/           , pgoblin_prog *pgm           /**/
/**/           , pgoblin_exenv *dexenv       /**/
/**/           , pgoblin_exenv *sexenv       /**/
/**/           , ssize_t pp                  /**/
/**/           ) {                           /**
 **                                           **
 ***********************************************
 ***********************************************/
    int ex = EX_OK, i, g;
    pgoblin_r r[PGO_MAXR];
    pgoblin_exenv nexenv;
    pgoblin_exenv *exenv = &nexenv;
    u_int32_t m;
    ifBLIN_QV3(pgm->flags)
        fprintf(stderr, "+pgoblin_execute pgm@%d:%d\n", (int)pgm->curr, (int)pgm->maxx);
    ifBLIN_QV5(pgm->flags) for (g = 0; g < PGOBLIN_REGSIZE; g++) dump_ioreg(options, g);
    if  (!pgm || !!strncmp(pgm->id, "#pGoblin-" VERS, PGOBLIN_STRING_ID_TST)) {
        ifBLIN_QV1(pgm->flags) warnx("Illegal pgoblin program %s", pgm->id);
        ERROUT(EX_DATAERR, EPROGMISMATCH);
    }
    bzero(exenv, sizeof(pgoblin_exenv));
    if  (dexenv) dexenv->next = exenv;
    exenv->dyna = dexenv;
    exenv->stat = sexenv;
    exenv->pgm = pgm;
    exenv->options = options;
    for (exenv->ppoint = pp; !(exenv->exeflags & PGOBLIN_END); exenv->ppoint++) {
        u_int32_t t, jobflags;
        pgoblin_command cmd;
        const struct pgoblin_syntax_a *a_cmd;
        char *lit;
        int ntyp, pqjump = 0;

    ;   exenv->exeflags &= PGOBLIN_EXTABLE;
    ;   if  (ex) {
            /*    ,    #trap */
            pgoblin_exenv *ev;
            int trapdone;

    ;       trapdone = 0;
    ;       for (ev = exenv; ev; ev = ev->stat) {
    ;           if  (ev->exeflags & PGOBLIN_TRAPDEF) {
    ;               ifBLIN_QV2(pgm->flags)
                        warnx("Trap from %d to %d", (int)exenv->ppoint, (int)ev->ctrap);
    ;               if  (!!(ex = pgoblin_execute(options, ev->pgm, exenv, ev->stat, ev->ctrap))) {
    ;                   ifBLIN_QV2(pgm->flags) warnx("Fail in trap PC %d", (int)exenv->ppoint);
    ;                   exenv->exeflags |= PGOBLIN_END | PGOBLIN_ERROR;
    ;               }
    ;               trapdone++;
    ;               break;
    ;       }   }
    ;       if  (!trapdone) {
    ;           ifBLIN_QV2(pgm->flags) warnx("Fail PC %d", (int)exenv->ppoint);
    ;           exenv->exeflags |= PGOBLIN_END | PGOBLIN_ERROR;
    ;   }   }
    ;   if  ((exenv->ppoint < exenv->pgm->curr) && !(exenv->exeflags & PGOBLIN_END)) {
    ;       t = exenv->pgm->code[exenv->ppoint].cmd;
    ;       if  ((cmd = t & PGOBLIN_COMMAND) == PGOBLIN_extended) {
    ;           cmd = (exenv->pgm->code[exenv->ppoint].e.cmd & PGOBLIN_COMMAND) | PGOBLIN_EXTENDED;
    ;           lit = NULL;
    ;       } else {
    ;           lit = exenv->pgm->code[exenv->ppoint].e.lit;
    ;       }
    ;       if  (cmd >= pgoblin.max || !(~pgoblin.a[cmd].flags & PGOBLIN_ILLEGAL)) {
    ;           ex = EX_DATAERR;
    ;           ifBLIN_QV1(pgm->flags) warnx("cmd[%d]=%03X unknown", (int)exenv->ppoint, cmd);
    ;           continue;
    ;       } else if (!pgoblin.a[cmd].flags) {
    ;           continue;
    ;       } else if (!pgoblin.a[cmd].car) {
    ;           ex = EX_DATAERR;
    ;           ifBLIN_QV2(pgm->flags)
                    warnx("cmd[%d]=%03X(%s) Undefined", (int)exenv->ppoint, cmd, pgoblin.a[cmd].str);
    ;           continue;
    ;       }
    ;       a_cmd = &(pgoblin.a[cmd]);
    ;       if  (exenv->lexlevel) {
    ;           if  (a_cmd->flags & PGOBLIN_LEXLVUP) exenv->lexlevel++;
    ;           if  (a_cmd->flags & PGOBLIN_LEXLDOWN) exenv->lexlevel--;
    ;           continue;
    ;       }
    ;   } else {
    ;       t = 0;
    ;       lit = NULL;
    ;       cmd = PGOBLIN_return;
    ;       a_cmd = &(pgoblin.a[cmd]);
    ;       exenv->exeflags |= PGOBLIN_END;
    ;   }
    ;   ifBLIN_QV3(pgm->flags) {
            int s, d;
            pgoblin_exenv *c;

    ;       for (s = 0, c = exenv; c; c = c->stat) s++;
    ;       for (d = 0, c = exenv; c; c = c->dyna) d++;
    ;       fprintf( stderr, "#### (%ds %dd) N%d e%06X f%08X c%03X %s"
                   , s, d, (int)exenv->ppoint, exenv->exeflags, a_cmd->flags, cmd, pgoblin.a[cmd].str
                   );
    ;       if  (lit) fprintf(stderr, "=%s~\n", lit); else fprintf(stderr, "\n");
    ;   }
    ;   for (i = 0; i < PGO_MAXR; i++) {
            int j;

    ;       if  (a_cmd->flags & pgoblin.p[i].sym) {
    ;           j = PREG(cmd, i);
    ;           r[i].c = a_cmd->ch[j];
    ;           r[i].r = (t >> pgoblin.binparams[j]) & PGOBLIN_ARGMASK;
    ;           ifBLIN_QV3(pgm->flags) fprintf(stderr, "%d->", j);
    ;       } else {
    ;           r[i].c = PGOBLIN_ILLEGAL;
    ;           r[i].r = 0;
    ;           ifBLIN_QV3(pgm->flags) fprintf(stderr, "    ");
    ;       }
    ;       if  (i == PGO_CSTY) {
    ;           r[i].g.s = &(options->style[r[i].c ? r[i].r : 0]);
    ;       } else if (i == PGO_CJOB) {
    ;           r[i].g.j = &(options->job[r[i].c ? r[i].r : 0]);
    ;       } else if (i == PGO_CCON) {
    ;           r[i].g.c = &(options->conn[r[i].c ? r[i].r : 0]);
    ;       } else {
    ;           r[i].g.io = &(options->io[r[i].c ? r[i].r : 0]);
    ;       }
    ;       ifBLIN_QV3(pgm->flags) {
    ;           fprintf(stderr, "%d[%d] %s", i, r[i].r, pgoblin.p[i].name);
    ;           if      (i == PGO_CSTY) fprintf(stderr, " %" BLIN_X, BLIN_I((r[i].g.s)));
                else if (i == PGO_CJOB) fprintf(stderr, " %" BLIN_X, BLIN_I((r[i].g.j)));
                else if (i == PGO_CCON) fprintf(stderr, " %" BLIN_X, BLIN_I((r[i].g.c)));
                else                    fprintf(stderr, " %" BLIN_X, BLIN_I((r[i].g.io)));
    ;           fprintf( stderr, " (%02X%s%s%s%s%s%s%s%s)"
                       , r[i].c
                       , (r[i].c & PGOBLIN_STYLE   ) ? " style": ""
                       , (r[i].c & PGOBLIN_JOB     ) ? " job"  : ""
                       , (r[i].c & PGOBLIN_CONNECT ) ? " conn" : ""
                       , (r[i].c & PGOBLIN_OUTSET  ) ? " out"  : ""
                       , (r[i].c & PGOBLIN_PQRESULT) ? " pq"   : ""
                       , (r[i].c & PGOBLIN_MIFEDES ) ? " mife" : ""
                       , (r[i].c & PGOBLIN_TEXTPARM) ? " text" : ""
                       , (r[i].c & PGOBLIN_PATHPARM) ? " path" : ""
                       );
    ;           if      (i == PGO_CSTY) {
                    fprintf(stderr, " %08X %s\n", r[i].g.s->flags, STYLS(r[i].g.s->flags)->name);
                } else if (i == PGO_CJOB) {
                    fprintf(stderr, " %08X %s\n", r[i].g.j->flags, JOBE(r[i].g.j->flags)->name);
                } else if (i == PGO_CCON) {
                    fprintf(stderr, " %08X %s\n", r[i].g.c->flags, DBASE(r[i].g.c->flags)->name);
                } else dump_ioreg(options, r[i].r);
    ;   }   }
    ;   ifBLIN_QV4(pgm->flags) DUMPIOREGS;
    ;   /**************************
    ;    *   OUT *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_OUTSET) {
    ;       if  (!(CH_OUT & PGOBLIN_OUTSET)) {
    ;           if  (r[PGO_COUT].r) {
    ;               if  ((ex = cleareg(options, IO_OUT, PGOBLIN_PATHPARM | PGOBLIN_OUTSET))) {
    ;                   CICLEWARN(0, "Not clear path|wri OUT");
    ;           }   }
    ;       } else if ((ex = propush(exenv, IO_OUT, CH_OUT))) {
    ;           CICLEWARN(0, "No propush");
    ;       } else if ((r[PGO_COUT].r == r[PGO_CCTL].r) || (r[PGO_COUT].r == r[PGO_CIN].r)) {
    ;               /* copy XXXX */
    ;   }   }
    ;   /**************************
    ;    *   CTL *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_CTL) {
    ;       if  (CH_CTL & PGOBLIN_OUTSET) {
    ;           ex = EX_SOFTWARE;
    ;           CICLEWARN(1, "CTL&out");
    ;       } else if (r[PGO_CCTL].r) {
    ;           if  (  (r[PGO_CCTL].r == r[PGO_COUT].r)
                    && (CH_CTL & CH_OUT & (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT))
                    ) {
    ;               ifBLIN_QV2(pgm->flags)
                        warnx( "cmd[%d]=[%03X(%s)]    \n"
                             , (int)exenv->ppoint, cmd, a_cmd->str
                             );
    ;           }
    ;           if  (!(IO_CTL->flags & PGOBLIN_ANYIVL)) {
    ;               if  (r[PGO_CCTL].r != r[PGO_CIN].r) exenv->exeflags |= PGOBLIN_FORKCTL;
    ;           } else if ((ex = coercion(exenv, IO_CTL, CH_CTL))) {
    ;               CICLEWARN(1, "No coercion CTL");
    ;           }
    ;       } else if ((CH_CTL & PGOBLIN_TEXTPARM)) {
    ;           if  ((ex = cleareg(options, IO_CTL, PGOBLIN_TEXTPARM))) {
    ;               CICLEWARN(1, "Not ready text CTL");
    ;           }
    ;           if  (!lit) {
    ;               MARK_IO_TEXT_GO(IO_CTL);;
    ;               ;;  IO_CTL->text = NULL;
    ;               ;;  IO_CTL->length = 0;
    ;               ;;  IO_CTL->flags &= ~(PGOBLIN_BINPARM | PGOBLIN_FREETEXT | PGOBLIN_TEXTPARM);
    ;               MARK_IO_TEXT_WENT(IO_CTL);;
    ;           } else {
    ;               MARK_IO_TEXT_GO(IO_CTL);;
    ;               ;;  IO_CTL->text = lit;
    ;               ;;  IO_CTL->length = strlen(lit);
    ;               ;;  IO_CTL->flags &= ~(PGOBLIN_BINPARM | PGOBLIN_FREETEXT);
    ;               MARK_IO_TEXT_WENT(IO_CTL);;
    ;           }
    ;       } else if ((CH_CTL & PGOBLIN_PQRESULT)) {
                pgoblin_conn conn0;
                const char **cell;
                int i, c;
    ;
    ;           if  ((ex = cleareg(options, IO_CTL, PGOBLIN_PQRESULT))) {
    ;               CICLEWARN(1, "Not ready pq CTL");
    ;           }
    ;           for (i = 0; ; i++) {
    ;               c = i;
    ;               if  (c && exenv->pgm->code[exenv->ppoint + c].cmd != PGOBLIN_cont) break;
    ;               if  (!exenv->pgm->code[exenv->ppoint + c].e.lit) break;
    ;           }
    ;           if  (c) {
    ;               if  (!(cell = malloc(c * sizeof(char**)))) { CICLEWARN(1, "No mem for Pq"); }
    ;               for (i = 0; i < c; i++) cell[i] = exenv->pgm->code[exenv->ppoint + i].e.lit;
    ;               conn0.flags = (pgm->flags & BLIN_VERMASK) | PGOBLIN_DB_0;
    ;               MARK_IO_PQ_GO(IO_CTL);;
    ;               ;;  pgoblin_db_0.execute(&conn0, &IO_CTL->pq, NULL, c, cell, NULL, 0);
    ;               ;;  IO_CTL->flagc = (pgm->flags & BLIN_VERMASK) | PGOBLIN_DB_0;
    ;               ;;  IO_CTL->flags |= PGOBLIN_FREEPQRE;
    ;               MARK_IO_PQ_WENT(IO_CTL);;
    ;           }
    ;           pqjump = DBASE(IO_CTL->flagc)->resinfo(PGOBLIN_Nfields, IO_CTL->pq) - 1;
    ;       } else if ((ex = coercomp(options, IO_CTL, CH_CTL))) {
    ;           CICLEWARN(1, "Not compatible CTL");
    ;   }   }
    ;   /**************************
    ;    *    IN *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_ISIN) {
    ;       if  (CH_IN & PGOBLIN_OUTSET) {
    ;           if  (r[PGO_CIN].r) {
                    if  ((ex = cleareg(options, IO_IN, PGOBLIN_PATHPARM | PGOBLIN_MIFEDES))) {
    ;                   CICLEWARN(2, "Not clear path|mife IN");
    ;           }   }
    ;       } else if (r[PGO_CIN].r) {
    ;           if  (  (r[PGO_CIN].r == r[PGO_COUT].r)
                    && (CH_IN & CH_OUT & (PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT))
                    ) {
    ;               ifBLIN_QV2(pgm->flags)
                        warnx( "cmd[%d]=[%03X(%s)]    \n"
                             , (int)exenv->ppoint, cmd, a_cmd->str
                             );
    ;           }
    ;           if  (!(IO_IN->flags & PGOBLIN_ANYIVL)) {
    ;               exenv->exeflags |= PGOBLIN_FORKIN;
    ;           } else if ((ex = coercion(exenv, IO_IN, CH_IN))) {
    ;               CICLEWARN(2, "No coercion IN");
    ;           }
    ;       } else if ((ex = coercomp(options, IO_IN, CH_IN & ~PGOBLIN_PQRESULT))) {
    ;           CICLEWARN(2, "Not compatible IN");
    ;   }   }
    ;   /***************************
    ;    *   CONN *
    ;    ***************************/
    ;   if  (a_cmd->flags & PGOBLIN_CONNECT) {
    ;       if  (CH_CON & PGOBLIN_OUTSET) {
    ;           if  (r[PGO_CCON].r) {
    ;               DBASE(R_CONN->flags)->finish(pgm->flags, PGOBLIN_Connect, &R_CONN->conn);
    ;               MARK_R_CONN_GO(R_CONN);;
    ;               ;;  if  (R_CONN->flags & PGOBLIN_PARMDBFREE) free(R_CONN->dbname);
    ;               ;;  R_CONN->conn = NULL;
    ;               ;;  R_CONN->flags = (pgm->flags & BLIN_VERMASK)
                /*  ;;  */            | (options->conn[0].flags & PGOBLIN_DB_TYPE);
    ;               ;;  R_CONN->dbname = NULL;
    ;               ;;  R_CONN->host = NULL;
    ;               ;;  R_CONN->port = NULL;
    ;               ;;  R_CONN->username = NULL;
    ;               ;;  R_CONN->intran = 0;
    ;               MARK_R_CONN_WENT(R_CONN);;
    ;           }
    ;       } else {
    ;           MARK_R_CONN_GO(R_CONN);;
    ;           ;;  R_CONN->flags = (pgm->flags & BLIN_VERMASK) | (R_CONN->flags & ~BLIN_VERMASK);
    ;           MARK_R_CONN_WENT(R_CONN);;
    ;           if  ((ex = DBASE(R_CONN->flags)->shurecon(R_CONN))) {
    ;               CICLEWARN(3, "Not connected");
    ;   }   }   }
    ;   /**************************
    ;    *   JOB *
    ;    **************************/
    ;   if  (a_cmd->flags & PGOBLIN_JOB) {
    ;       if  (CH_JOB & PGOBLIN_OUTSET) {
    ;           if  (r[PGO_CJOB].r) {
    ;               ex = JOBE(R_JOB->flags)->close(exenv, r);
    ;               MARK_R_JOB_GO(R_JOB);;
    ;               ;;  mular_destroy(R_JOB->pids);
    ;               ;;  R_JOB->pids = NULL;
    ;               ;;  R_JOB->host = NULL;
    ;               ;;  R_JOB->concur = 0;
    ;               ;;  R_JOB->dead = 0;
    ;               ;;  R_JOB->flags = pgm->flags & BLIN_VERMASK;
    ;               MARK_R_JOB_WENT(R_JOB);;
    ;               if  (ex) {
    ;                   CICLEERR("Close JOB");
    ;                   continue;
    ;           }   }
    ;       } else if (  !(R_JOB->pids)
                      && !(R_JOB->pids = mular_create(MULAR_ZERO, 3, sizeof(pgoblin_jobl), u12))
                      ) {
    ;           ex = EX_SOFTWARE;
    ;           CICLEERR("No JOB");
    ;           continue;
    ;   }   }
    ;   /****************************
    ;    *   STYLE *
    ;    ****************************/
    ;   if  (a_cmd->flags & PGOBLIN_STYLE) {
    ;       if  (CH_STY & PGOBLIN_OUTSET) {
    ;           if  (r[PGO_CSTY].r) {
    ;               MARK_R_STYLE_GO(R_STYLE);;
    ;               ;;  if  (R_STYLE->style) STYLS(R_STYLE->flags)->free(R_STYLE);
    ;               ;;  R_STYLE->style = NULL;
    ;               ;;  R_STYLE->path = NULL;
    ;               ;;  R_STYLE->flags = pgm->flags & BLIN_VERMASK;
    ;               MARK_R_STYLE_WENT(R_STYLE);;
    ;   }   }   }
    ;   /******************************
    ;    *     *
    ;    ******************************/
    ;   if  ((exenv->exeflags & PGOBLIN_FORKIN) && (ex = pipe(options->pip2))) {
    ;       CICLEERR("pipe #2");
    ;       close(options->pip2[0]);
    ;       close(options->pip2[1]);
    ;       continue;
    ;   }
    ;   if  ((exenv->exeflags & PGOBLIN_FORKCTL) && (ex = pipe(options->pip1))) {
    ;       CICLEERR("pipe #1");
    ;       close(options->pip1[0]);
    ;       close(options->pip1[1]);
    ;       continue;
    ;   }
    ;   if  ((exenv->exeflags & PGOBLIN_FORKOUT) && (ex = pipe(options->pip0))) {
    ;       CICLEERR("pipe #0");
    ;       close(options->pip0[0]);
    ;       close(options->pip0[1]);
    ;       continue;
    ;   }
    ;   ifBLIN_QV4(pgm->flags) {
    ;       DUMPIOREGS;
    ;       fprintf(stderr, "exeflags=%08X\n", exenv->exeflags);
    ;   }
    ;   /*******************************
    ;    *     *
    ;    *******************************/
    ;   ntyp = 1;
    ;   jobflags = PGOBLIN_TOEXIT;
    ;   if  ((cmd == PGOBLIN_exec) && (r[PGO_CCTL].r)) {
    ;       ntyp = (DBASE(IO_CTL->flagc))->resinfo(PGOBLIN_Ntuples, IO_CTL->pq);
    ;   }
    ;   if  (a_cmd->flags & PGOBLIN_FORKED)
            jobflags = JOBE(R_JOB->flags)->test(cmd);
    ;   if  (exenv->exeflags & (PGOBLIN_FORKIN | PGOBLIN_FORKCTL | PGOBLIN_FORKOUT))
            jobflags |= PGOBLIN_TOFORK;
    ;   for (exenv->sequen = 0; (exenv->sequen < ntyp) && !ex; exenv->sequen++) {
    ;       if  (!(jobflags & (PGOBLIN_TVFORK | PGOBLIN_TOFORK))) {
    ;           ifBLIN_QV3(pgm->flags)
                    fprintf( stderr, "e%06X DO x %d(%d) c%03X %s\n"
                           , exenv->exeflags, ntyp, exenv->sequen, cmd, a_cmd->str
                           );
    ;           ex = (*(a_cmd->car))(exenv, r);
    ;           ifBLIN_QV4(pgm->flags) fprintf(stderr, "DONE %d\n", ex);
    ;       } else {
    ;       ;   ifBLIN_QV3(pgm->flags)
                    fprintf( stderr, "e%06X FORK x %d(%d) c%03X %s\n"
                           , exenv->exeflags, ntyp, exenv->sequen, cmd, a_cmd->str
                           );
    ;       ;   if  (R_JOB->concur && (MULAR_NEXT(R_JOB->pids) >= (R_JOB->concur + R_JOB->dead))) {
    ;       ;       if  ((ex = waitjob(R_JOB))) {
    ;       ;           CICLEERR("waitjob");
    ;       ;           continue;
    ;       ;   }   }
    ;       ;   /*  if  ((ex = ((jobflags & PGOBLIN_TOFORK) ? fork() : vfork())) < 0) { */
    ;       ;   if  ((ex = fork()) < 0) {
    ;       ;       CICLEERR("fork #1");
    ;       ;       continue;
    ;       ;   } else if (ex == 0) {
    ;       ;       ifBLIN_QV4(pgm->flags) fprintf(stderr, "FORK CHILD\n");
    ;       ;       /*********************************
    ;       ;        * ,    *
    ;       ;   ;    *********************************/
    ;       ;   ;   if  ((ex = pgoblin_connown(options))) exit(ex);
    ;       ;   ;   exenv->exeflags |= PGOBLIN_FORKED | PGOBLIN_CHILD;
    ;       ;   ;   if  (exenv->exeflags & PGOBLIN_FORKCTL) {
    ;       ;   ;       ifBLIN_QV1(exenv->options->flags) warnx("fork with CTL");
    ;       ;   ;       ex = -EX_SOFTWARE;
    ;       ;   ;       exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->exeflags & PGOBLIN_FORKIN) {
    ;       ;   ;       if  ((ex = pgoblin_inx(options, IO_IN, options->pip2, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->exeflags & PGOBLIN_FORKCTL) {
    ;       ;   ;       if  ((ex = pgoblin_inx(options, IO_CTL, options->pip1, 1))) exit(ex);
    ;       ;   ;   }
    ;       ;   ;   if  (exenv->exeflags & PGOBLIN_FORKOUT) {
    ;       ;   ;       if  ((ex = pgoblin_outx(options, IO_OUT, options->pip0, 1))) exit(ex);
    ;       ;       }
    ;       ;       if  (exenv->options->flags & PGOBLIN_FORK_WAIT) {
    ;       ;           ifBLIN_QV3(exenv->options->flags)
                            fprintf( stderr, "sleep %us in fork\n"
                                   , exenv->options->flags & PGOBLIN_FORK_WAIT
                                   );
    ;       ;           sleep(exenv->options->flags & PGOBLIN_FORK_WAIT);
    ;       ;       }
    ;       ;       ex = (*(a_cmd->car))(exenv, r);
    ;       ;       ifBLIN_QV4(pgm->flags) fprintf(stderr, "CHILD DONE %d\n", ex);
    ;       ;       if  (jobflags & PGOBLIN_TOEXIT) exit(ex);
    ;       ;   } else {
                    pgoblin_jobl *j;

    ;       ;       ifBLIN_QV4(pgm->flags) fprintf(stderr, "FORK DONE %d\n", ex);
    ;       ;       j = mular_add(R_JOB->pids);
    ;       ;       j->cmdn = exenv->ppoint;
    ;       ;       j->pid = ex;
    ;       ;       j->status = PGOBLIN_NOSTATUS;
    ;       ;       if  (cmd == PGOBLIN_fork) exenv->lexlevel++;
    ;       ;       ex = 0;
    ;   }   }   }
    ;   if  (!(exenv->exeflags & PGOBLIN_CHILD)) {
    ;       if  (exenv->exeflags & PGOBLIN_FORKIN) {
    ;           if  ((ex = pgoblin_outx(options, IO_IN, options->pip2, 1))) continue;
    ;       }
    ;       if  (exenv->exeflags & PGOBLIN_FORKCTL) {
    ;           if  ((ex = pgoblin_outx(options, IO_CTL, options->pip1, 1))) continue;
    ;       }
    ;       if  (exenv->exeflags & PGOBLIN_FORKOUT) {
    ;           close(options->pip0[1]);
    ;           if  (pgm->flags & PGOBLIN_OLDSTYLE && r[PGO_COUT].r == 1) {
    ;               if  (IO_RG0.mife) mife_close(IO_RG0.mife);
    ;               MARK_IO_MIFE_GO(&IO_RG0);;
    ;               ;;  if  (!(IO_RG0.mife = mife_opef(MIFE_FULL, options->pip0[0]))) {
    ;               ;;      ex = EX_NOINPUT;
    ;               ;;      CICLEERR("Old style mife_opef");
    ;               ;;  } else {
    ;               ;;      IO_RG0.offset = 0;
    ;               ;;      IO_OUT->pid = 0; /* !!! */
    ;               ;;      IO_RG0.flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
    ;               ;;  }
    ;               MARK_IO_MIFE_WENT(&IO_RG0);;
    ;           } else {
    ;               MARK_IO_MIFE_GO(IO_OUT);;
    ;               ;;  if  (!(IO_OUT->mife = mife_opef(MIFE_FULL, options->pip0[0]))) {
    ;               ;;      ex = EX_NOINPUT;
    ;               ;;      CICLEERR("New style mife_opef");
    ;               ;;  } else {
    ;               ;;      IO_OUT->offset = 0;
    ;               ;;      IO_OUT->pid = 0;
    ;               ;;      IO_OUT->flags |= PGOBLIN_MIFEDES | PGOBLIN_FREEMIFE;
    ;               ;;  }
    ;               MARK_IO_MIFE_WENT(IO_OUT);;
    ;   }   }   }
    ;   if  (ex) continue;
    ;   /*****************************
    ;    *  IO_OUT  *
    ;    *****************************/
    ;   if  (a_cmd->flags & PGOBLIN_OUTSET) {
    ;       ifBLIN_QV4(pgm->flags) {
    ;           fprintf(stderr, " %08X ", exenv->exeflags);
    ;   ;       dump_ioreg(options, r[PGO_COUT].r);
    ;   ;   }
    ;   ;   if  (exenv->exeflags & PGOBLIN_FREEPATH) {
                off_t off;
                mife_descriptor *md;
                char *cont;
                ssize_t bl;

    ;   ;       if  (!(IO_OUT->path)) {
    ;   ;           CICLEWARN(0, "unload no path");
    ;   ;       }
    ;   ;       md = mife_open(kukMIFE_BUFL(PGOBLIN_RAWIOBUFL) | MIFE_BUFX, IO_OUT->path);
    ;   ;       if  (!md) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload mife open");
    ;   ;           continue;
    ;   ;       }
    ;   ;       for (off = 0; !(md->flag & MIFE_EOFL); off += bl) {
    ;   ;           if  ((bl = mife_read(md, 1 << (PGOBLIN_RAWIOBUFL + 16), off)) < 0) {
    ;   ;               ifBLIN_QV1(pgm->flags) warn("unload mife read %s:", IO_OUT->path);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;           }
    ;   ;           if  (!(cont = mife_get(md, off))) {
    ;   ;               ifBLIN_QV1(pgm->flags) warn("unload mife get %s:", IO_OUT->path);
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;           }
    ;   ;           if  (IO_OUT->wri(IO_OUT->onu, cont, bl) < 0) {
    ;   ;               ifBLIN_QV1(pgm->flags) warn("unload mife write");
    ;   ;               ex = EX_IOERR;
    ;   ;               break;
    ;   ;       }   }
    ;   ;       if  (ex) continue;
    ;   ;       if  (mife_close(md)) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload close");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(options, IO_OUT, PGOBLIN_PATHPARM);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->path not cleared");
    ;   ;   }
    ;   ;   if  (exenv->exeflags & PGOBLIN_FREETEXT) {
    ;   ;       if  (!(IO_OUT->text)) {
    ;   ;           CICLEWARN(0, "unload no text");
    ;   ;       }
    ;   ;       ex = IO_OUT->wri(IO_OUT->onu, IO_OUT->text, IO_OUT->length);
    ;   ;       if  (ex < 0) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload text write");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(options, IO_OUT, PGOBLIN_TEXTPARM);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->text not cleared");
    ;   ;   }
    ;   ;   if  (exenv->exeflags & PGOBLIN_FREEPQRE) {
    ;   ;       if  (!(IO_OUT->pq)) {
    ;   ;           CICLEWARN(0, "unload no pq");
    ;   ;       }
    ;   ;       ex = STYLS(0)->table(IO_OUT, &R_STY0, IO_OUT, 0, -2);
    ;   ;       if  (ex < 0) {
    ;   ;           ex = EX_IOERR;
    ;   ;           CICLEERR("unload pq");
    ;   ;           continue;
    ;   ;       }
    ;   ;       ex = cleareg(options, IO_OUT, PGOBLIN_PQRESULT);
    ;   ;       if  (ex) CICLEWARN(0, "IO_OUT->pq not cleared");
    ;   ;   }
    ;   ;   if  (r[PGO_COUT].r == 0) {
    ;   ;       if  (IO_OUT->path && !(IO_OUT->flags & PGOBLIN_PATHPARM)) {
    ;   ;           ex = cleareg(options, IO_OUT, PGOBLIN_PATHPARM);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->path not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->text && !(IO_OUT->flags & PGOBLIN_TEXTPARM)) {
    ;   ;           ex = cleareg(options, IO_OUT, PGOBLIN_TEXTPARM);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->text not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->pq && !(IO_OUT->flags & PGOBLIN_PQRESULT)) {
    ;   ;           ex = cleareg(options, IO_OUT, PGOBLIN_PQRESULT);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->pq not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->mife && !(IO_OUT->flags & PGOBLIN_MIFEDES)) {
    ;   ;           ifBLIN_QV1(pgm->flags) warnx("Clear mife in io[0]");
    ;   ;           ex = cleareg(options, IO_OUT, PGOBLIN_MIFEDES);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->mife not cleared");
    ;   ;       }
    ;   ;       if  (IO_OUT->wri && !(IO_OUT->flags & PGOBLIN_OUTSET)) {
    ;   ;           ifBLIN_QV1(pgm->flags) warnx("Clear wri in io[0]");
    ;   ;           ex = cleareg(options, IO_OUT, PGOBLIN_OUTSET);
    ;   ;           if  (ex) CICLEWARN(0, "0 IO_OUT->wri not cleared");
    ;   ;   }   }
    ;   ;   ifBLIN_QV4(pgm->flags) {
    ;           fprintf(stderr, "  ");
    ;           dump_ioreg(options, r[PGO_COUT].r);
    ;   }   }
    ;   if  ((a_cmd->flags & PGOBLIN_CTL) && !(r[PGO_CCTL].r) && (CH_CTL & PGOBLIN_TEXTPARM)) {
    ;       ex = cleareg(options, IO_CTL, PGOBLIN_TEXTPARM);
    ;       if  (ex) CICLEWARN(0, "0 IO_CTL->text not cleared");
        }
        if  (pqjump > 0) exenv->ppoint += pqjump;
        ifBLIN_QV1(pgm->flags) iorassert(exenv, cmd);
    }
    if  (!ex && (exenv->exeflags & PGOBLIN_ERROR)) ex = -1;
    if  (dexenv) {
        dexenv->next = NULL;
    } else if (pgm->flags & PGOBLIN_CLEAR_ONEXIT) {
        for (g = 0; g < PGOBLIN_REGSIZE; g++) {
            m = PGOBLIN_PATHPARM | PGOBLIN_TEXTPARM | PGOBLIN_PQRESULT;
            if  (g) m |= PGOBLIN_OUTSET | PGOBLIN_MIFEDES;
            cleareg(exenv->options, (&exenv->options->io[g]), m);

#           define O(G) (exenv->options->job[G])
            MARK_R_JOB_GO(&O(g));;
            ;;  mular_destroy(O(g).pids);
            ;;  O(g).pids = NULL;
            ;;  if  (O(g).flags & PGOBLIN_HOSTJFREE) free(O(g).host);
            ;;  O(g).host = NULL;
            ;;  O(g).concur = 0;
            ;;  O(g).dead = 0;
            ;;  O(g).flags = options->flags & BLIN_VERMASK;
            MARK_R_JOB_WENT(&O(g));;
#           undef O

#           define O(G) (exenv->options->style[G])
            MARK_R_STYLE_GO(&O(g));;
            ;;  STYLS(O(g).flags)->free(&O(g));
            ;;  O(g).style = NULL;
            ;;  O(g).path = NULL;
            ;;  O(g).flags &= ~PGOBLIN_STYLE_TYPE;
            MARK_R_STYLE_WENT(&O(g));;
#           undef O
    }   }
out:
    ifBLIN_QV3(options->flags) fprintf(stderr, "-pgoblin_execute %d\n", ex);
    return(ex);
};
