/*-
 * Copyright (C) @BABOLO  2007 Nov 20
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2007 Nov 20\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: descript.c,v 1.40 2009/11/17 07:04:23 babolo Exp $";
#endif /* not lint */

#define _PGOBLIN_CHAR_CLASSES_ 1
#include <sys/types.h>
#include <stdio.h>
#include <mife.h>
#include <babolo/parser.h>
#include "pgoblin.h"
#include "pgob.h"
#include "cmds.h"
#include "sqlkeywords.h"

#define Pf PGOBLIN_PATHPARM
#define Pt PGOBLIN_TEXTPARM
#define Pm PGOBLIN_MIFEDES
#define Pq PGOBLIN_PQRESULT
#define Po PGOBLIN_OUTSET
#define Ps PGOBLIN_STYLE
#define Pj PGOBLIN_JOB
#define Pc PGOBLIN_CONNECT

#define Fx PGOBLIN_ILLEGAL
#define Fi PGOBLIN_IGNORE
#define Fl PGOBLIN_NOLITER
#define Ff PGOBLIN_FORKED
#define Fe PGOBLIN_EXTENDED
#define Fu PGOBLIN_LEXLVUP
#define Fd PGOBLIN_LEXLDOWN
#define Io PGOBLIN_OUTSET
#define Id PGOBLIN_CTL
#define Ii PGOBLIN_ISIN
#define Ic PGOBLIN_CONNECT
#define Ij PGOBLIN_JOB
#define Is PGOBLIN_STYLE

static pgoblin_dbases *dbasetable[PGOBLIN_DBTABLESZ] =
{NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
};
static pgoblin_styles *styletable[PGOBLIN_STYLETBSZ] =
{NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
};
static pgoblin_jobs *jobtable[PGOBLIN_JOBTABSIZ] =
{NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL, NULL,NULL,NULL,NULL
};

static const char *clasnames[] =
{ "L0", "Ll", "Lb", "Ls", "Ld", "Lo", "Lx"};

static const char class[256] =
{ L0, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lb, Ll, Ll,  Lo, Ll, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lb, Lo, Lo, Ld,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, -1, -2, -3, -4,  -5, -6, -7, -8,  -9,-10, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo,-11,-12,-13, -14,-15,-16,-17, -18,-19,-20,-21, -22,-23,-24,-25
,-26,-27,-28,-29, -30,-31,-32,-33, -34,-35,-36, Lo,  Lo, Lo, Lo,-63
, Lo,-37,-38,-39, -40,-41,-42,-43, -44,-45,-46,-47, -48,-49,-50,-51
,-52,-53,-54,-55, -56,-57,-58,-59, -60,-61,-62, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo

, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
, Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo,  Lo, Lo, Lo, Lo
};

const pgoblin_syntax pgoblin =
{ PGOBLIN_DBTABLESZ
, PGOBLIN_JOBTABSIZ
, PGOBLIN_STYLETBSZ
, PGOBLIN_SYMREGS
, PGOBLIN_BINREGS
, PGOBLIN_max
, dbasetable
, jobtable
, styletable
, clasnames
, class
, &cmds
, &sqlkeywords
, {PGOBLIN_ARG1S, PGOBLIN_ARG2S, PGOBLIN_ARG3S, PGOBLIN_ARG4S}
, { { PGOBLIN_OUTSET , PGOBLIN_ANYIVL ,  0, 0, "out  "}
  , { PGOBLIN_CTL    , PGOBLIN_ANYIVL ,  1, 0, "ctl  "}
  , { PGOBLIN_ISIN   , PGOBLIN_ANYIVL ,  3, 0, "in   "}
  , { PGOBLIN_CONNECT, PGOBLIN_CONNECT,  2, 0, "conn "}
  , { PGOBLIN_JOB    , PGOBLIN_JOB    ,  2, 0, "job  "}
  , { PGOBLIN_STYLE  , PGOBLIN_STYLE  ,~12, 3, "style"}
  }
, { { Fe                      , {    0,     0,     0,    0}, NULL           , ""}          /* 000 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , {                        0, {    0,     0,     0,    0}, NULL           , ""}
//      Pq  CTL,      Pq.
//      , .
//     .
  , { Fi                      , {    0,     0,     0,    0}, NULL           , "!"}
//       
//e
// #!/usr/local/bin/pgoblin
//e
//      .
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , {       Id|   Ic          , {    0,    Pt, Po|Pc,    0}, pgoblin_connect, "connect"}   /* 010 */
//  ,   CTL   ,   CON.
// CTL     ,  
//      .
//         ,
//      ,    ..
  , {       Id|Ii|Ic          , {    0,    Pt,    Pc,   Pt}, pgoblin_listen , "listen"}    /* 011 */
//  notify  ,   CTL.    ,
//     IN.

// !      
//   64     
//   UNIX .   
//  :
//e
// #binpresel
// SELECT (( date_part('epoch', DateTimeWaitTo)
//         + date_part('second', DateTimeWaitTo)
//         - floor(date_part('second', DateTimeWaitTo))
//         ) * 1000000
//        )::int8
//e
// !     Pq,
//      .    
//    .
  , { Ff|Io|Id|Ii|   Ij       , {Po|Pm,    Pq,    Pj,   Pm}, pgoblin_exec   , "exec"}      /* 012 */
//     JOB ,   
// CTL,       Pq  CTL.
// stdin  stdout      IN  OUT.
//          JOB.
// ,       ,
//   - . NULL      
//      / ,    .
  , { Fu                      , {    0,     0,     0,    0}, pgoblin_trap   , "trap"}      /* 013 */
//  ,    ,
//    .
//     ,    
//     (#return  #exit)  ,   .
  , { Fx                      , {    0,     0,     0,    0}, pgoblin_call   , "call"}      /* 014 */
  , {       Id                , {    0,    Pt,     0,    0}, pgoblin_eval   , "eval"}      /* 015 */
// CTL     pgoblin.
//          ,
//     #trap.
//   #trap    ,
//        
// #trap   .
//   #trap  ,  
//          .
  , {       Id|Ii|   Is|0x2000, {    0,    Pt,    Ps,   Pt}, pgoblin_style  , "style"}     /* 016 */
//    STY  ,   CTL,
//   ,    IN.
//  0  STY   ,  
//      .
//  CTL     .
  , {       Id|      Ij       , {    0,    Pt,    Pj,    0}, pgoblin_job    , "job"}       /* 017 */
//   ,   CTL,    JOB.
// CTL     ,  
//     ,      ,
//       
//  .     JOB   
//   ,     
//         .
//   :
//u
// -z        1
// -Z      
//u
//   3  
//u
// 0 -      
// 1 -  #wait      ,       
// 2 -         
//u
//     0.
  , {    Io|Id|      Is|0x3000, {Po|Pt,    Pt,     0,   Ps}, pgoblin_echo   , "echo"}      /* 018 */
//   STY 0,   OUT    CTL,
//   OUT     STY,     CTL.
  , {    Io|Id|      Is|0x3000, {Po|Pf,    Pt,     0,   Ps}, pgoblin_file   , "file"}      /* 019 */
//   STY 0,   OUT  ,     CTL,
//  ,        STY,     CTL.
//           
//  ,       .
//          ,
//      ,    .
//     ,     .
  , {    Io|Id|      Is|0x3000, {Po|Pf,    Pt,     0,   Ps}, pgoblin_cat    , "cat"}       /* 01A */
//   STY 0,   OUT  ,     CTL,
//  ,        STY,     CTL.
//           
//  ,       .
//          ,
//        ,    .
//     ,     .
  , {    Fd|Id|   Ic          , {    0,    Pt, Po|Pc,    0}, pgoblin_exit   , "exit"}      /* 01B */
//   .
//         .
//       ,
//    .    ,
//       #return.
//    0  CON,
//       ,    ,
//      ,      
//     .
//  CTL  ,         -  .
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 01C */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , {       Id|Ii|Ic          , {    0, Pt|Pq,    Pc,   Pq}, pgoblin_perform, "perform"}   /* 020 */
//  ,  CONN,  ,  CTL.
//     .    IN,
//   Pq   ,    
//  .    CONN.
//    CTL  Pt,    CON  ,
//     Pq,      CTL Pq 
//  ,  0   .   
//  Pq  ,   IN Pq,   CTL Pq 
//         .    
//  ,      .
  , {    Io|Id|   Ic          , {Po|Pq,    Pt,    Pc,    0}, pgoblin_binpre , "binpresel"} /* 021 */
//   CTL     OUT.
  , {    Io|Id|Ii|Ic          , {Po|Pq,    Pt,    Pc,   Pq}, pgoblin_select , "select"}
//        OUT.
//    IN,     IN Pq  
//    .    CONN.
  , {    Io|Id|   Ic|Is|0x3000, {Po|Pm,    Pt,    Pc,   Ps}, pgoblin_binsel , "binselect"} /* 022 */
//   CTL      OUT   STY.
  , {    Io|Id|   Ic|Is|0x3000, {Po|Pm, Pt,    Pc,   Ps}, pgoblin_strsel , "strselect"} /* 023 */
//   CTL     OUT   STY.
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , {       Id|Ii|Ic          , {    0,    Pt,    Pc,   Pm}, pgoblin_copyin , "copyin"}    /* 024 */
//  IN     CTL  
//a
// COPY
  , {    Io|Id|   Ic          , {Po|Pm,    Pt,    Pc,    0}, pgoblin_copyout, "copyout"}   /* 025 */
//   CTL    OUT  
//a
// COPY
  , { Fl|Io|   Ii             , {Po|Pm,    Pt,     0,   Pm}, pgoblin_getstr , "getstr"}    /* 026 */
//  CTL ,   OUT    2   
//a
// COPY
//a
//n
//    ,   0
//  
//n
//      IN.
//    CTL   .
  , {    Io|Id|Ii|   Ij       , {Po|Pm,    Pt,    Pj,   Pm}, pgoblin_getdir , "getdir"}    /* 027 */
//  CTL     ,     .
//  IN 0,      1      ,
//     IN.  OUT    
//a
// COPY
//a
//  :
//u
// 0x01    ,   0
// 0x02  
// 0x04  
// 0x08 mode 
// 0x10 uid 
// 0x20 gid 
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 028 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 030 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 040 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 050 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}       /* 060 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 070 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 080 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 090 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 0A0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 0B0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 0C0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 0D0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 0E0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 0F0 */
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fl|         Ic          , {    0,     0,    Pc,    0}, pgoblin_begin  , "begin"}     /* 100 */
//      pgoblin  ,   .
//   BEGIN  ,   CON,     .
//      END   PostgreSQL,
//    .   #begin - #end  
//  BEGIN - END    .    
//       ,      PostgreSQL.
  , { Fl|         Ic          , {    0,     0,    Pc,    0}, pgoblin_end    , "end"}       /* 101 */
//       #begin,   ,
//     .
//     END  ,   CON.
//      END   PostgreSQL,
//    .
  , { Fl|Io|   Ii|   Ij    |Ff, {Po|Pm,     0,    Pj,   Pm}, pgoblin_fork   , "fork"}      /* 102 */
// pgoblin ,      #fork  #exit  #return,
//   ,     .
//         ,
//     .
//        ,
//           .
//         
//    ,     
//  .
//  OUT          ,
//   IN          ,
//   .
  , { Fl|            Ij       , {    0,     0,    Pj,    0}, pgoblin_wait   , "wait"}      /* 103 */
//    ,   JOB.
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}        /* 104 */
  , { Fl|Fd|      Ic          , {    0,     0, Po|Pc,    0}, pgoblin_return , "return"}    /* 105 */
//      #fork,     #exit  CTL.
//     #trap,       ,
//   CON  .
  , { Fl|Io|   Ii|   Is|0x2000, {Po|Pm,     0,    Ps,   Pq}, pgoblin_display, "display"}   /* 106 */
// IN   Pq   OUT      STY.
  , { Fl|Io|   Ii             , {   Pm,     0,     0,Po|Pm}, pgoblin_pipe   , "pipe"}      /* 107 */
//    OUT    IN.      
//     . 0  ,   .
  , { Fl|Io|   Ii|Ic|Is|0x1000, {   Pm, Po|Ps, Po|Pc,Po|Pm}, pgoblin_close  , "close"}     /* 108 */
//    OUT,   IN,  STY     CON.
//        IN  OUT .
//      0   .
//   CON,   0,  ,    
//      .
  , { Fl|Io|      Ij|Is|0x3000, {Po|Pt,     0, Po|Pj,Po|Ps}, pgoblin_clear  , "clear"}     /* 109 */
//  JOB  STY,   0. 0 JOB  STY  .
//     0 OUT,    Po|Pm.
  , { Fl                      , {    0,     0,     0,    0}, pgoblin_untrap , "untrap"}    /* 10A */
//    #trap.
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}
  , { Fx                      , {    0,     0,     0,    0}, NULL           , NULL}

  , { Fl|Io                   , {Po|Pm,     0,     0,    0}, pgoblin_getarg , "getarg"}    /* 110 */
//  OUT     COPY  2 :
//n
//  ,   0
//  
//n
//     ,     pgoblin,
//  ,     .
  , { Fl|Io                   , {Po|Pm,     0,     0,    0}, pgoblin_getenv , "getenv"}    /* 111 */
//  OUT     COPY  3 :
//n
//    ,   0
//   
//  
  , { Fl|Io                   , {Po|Pm,     0,     0,    0}, pgoblin_getget , "getget"}    /* 112 */
//  OUT     COPY  3 :
//n
//    ,   0
//    HTTP GET
//  
//n
//      CGI,  GET,    getCGIparm.
  , { Fl|Io|   Ii             , {Po|Pm,     0,     0,   Pm}, pgoblin_getpost, "getpost"}   /* 113 */
//  OUT     COPY  3 :
//n
//    ,   0
//    HTTP POST
//  
//n
//      IN.
//      CGI,  POST,    getCGIparm.
  , { Fl|Io                   , {Po|Pm,     0,     0,    0}, pgoblin_getproc, "getproc"}  /* 114 */
//  OUT     COPY  3 :
//n
// PID 
//  ,   0
//  
//n
//     .   /proc/.
  , { Io|            Ij       , {Po|Pm,     0,     0,    0}, pgoblin_getjob , "getjob"} /* !ch[2]  */
//  OUT     COPY  4 :
//n
//    ,   0
//  ,    
// PID 
//  
//n
//      JOB.  #getjob   JOB 0.
  , { Fx                      , {    0,     0,     0,    0}, pgoblin_getspq , "getspq"}   /* 116 */
} };
