/*-
 * Copyright (C) @BABOLO  2008 May 10
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2008 May 10\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: db_sqlite3.c,v 1.20 2009/11/04 19:09:23 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <sys/time.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <mife.h>
#include <err.h>
#include <sqlite3.h>
#include <multilar.h>
#include <getCGIparm.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include "pgoblin.h"
#include "pgob.h"

/* expansions to SQLite 3 */

#include <regex.h>

void pgoblin_sqlite3_regexp       __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void pgoblin_sqlite3_quote        __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void pgoblin_sqlite3_quote_html   __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));
void pgoblin_sqlite3_gettimeofday __P((sqlite3_context *ctx, int argc, sqlite3_value **argv));

#define PGOBLIN_SQLITE_E  0x000001 /*  E    */
#define PGOBLIN_SQLITE_SL 0x000002 /*  \                       */
#define PGOBLIN_SQLITE_SQ 0x000004 /*  '                       */
#define PGOBLIN_SQLITE_DQ 0x000008 /*  "                       */
#define PGOBLIN_SQLITE_SF 0x000010 /*  ,          */
#define PGOBLIN_SQLITE_EE 0x000020 /*   E             */
#define PGOBLIN_SQLITE_US 0x000040 /*                    */
#define PGOBLIN_SQLITE_KY 0x000080 /*             */
#define PGOBLIN_SQLITE_NL 0x000100 /*  \0                     */
#define PGOBLIN_SQLITE_SS 0x000200 /* \X                          */

void
_pgoblin_sqlite3_quote(sqlite3_context *ctx, int argc, sqlite3_value **argv) {
    int nquotes, i, j, keyword;
    u_int32_t flags;
    const char *cp;
    ssize_t len;
    char *res;

    flags = ~(PGOBLIN_SQLITE_EE | PGOBLIN_SQLITE_US) & (u_int32_t)BLIN_I(sqlite3_user_data(ctx));
    cp = (char*)sqlite3_value_text(argv[0]);
    if  (!cp) {
        sqlite3_result_null(ctx);
    } else {
        len = strlen(cp);
        for (i = 0, nquotes = 0; i < len; i++) {
            if  (cp[i] == '\\') {
                flags |= PGOBLIN_SQLITE_EE | PGOBLIN_SQLITE_US;
                if  (flags & PGOBLIN_SQLITE_SL) nquotes++;
            } else if (cp[i] == '\'') {
                flags |= PGOBLIN_SQLITE_US;
                if  (flags & PGOBLIN_SQLITE_SQ) nquotes++;
            } else if (cp[i] == '\"') {
                flags |= PGOBLIN_SQLITE_US;
                if  (flags & PGOBLIN_SQLITE_DQ) nquotes++;
            } else if (((cp[i] >= 'a') && (cp[i] <= 'z')) || (cp[i] == '_')) {
            } else if ((cp[i] >= '0') && (cp[i] <= '9')) {
                if  (i == 0) flags |= PGOBLIN_SQLITE_US;
            } else if (cp[i] == 0) {
                flags |= PGOBLIN_SQLITE_US | PGOBLIN_SQLITE_NL;
                if  (flags & PGOBLIN_SQLITE_SS) nquotes += 3;
            } else if ((cp[i] >= 0x08) && (cp[i] <= 0x0D)) {
                flags |= PGOBLIN_SQLITE_US;
                if  (flags & PGOBLIN_SQLITE_SS) nquotes++;
            } else {
                flags |= PGOBLIN_SQLITE_US;
        }   }
        if  (!(~flags & (PGOBLIN_SQLITE_E | PGOBLIN_SQLITE_EE))) nquotes++;
        keyword = 0;
        if  (flags & PGOBLIN_SQLITE_KY) {
            keyword = babolo_testword(pgoblin.sqlkeywords, (u_char*)cp);
            if  (keyword == UNRESERVED_KEYWORD) keyword = 0;
        }
        if  (nquotes || keyword || !(flags & PGOBLIN_SQLITE_SF) || (flags & PGOBLIN_SQLITE_US)) {
            if  (!(res = malloc(len + nquotes + 3))) {
                ifBLIN_QV1(flags) warnx("No mem pgoblin_sqlite3_quote");
                sqlite3_result_error_nomem(ctx);
            } else {
                j = 0;
                if  (!(~flags & (PGOBLIN_SQLITE_E | PGOBLIN_SQLITE_EE))) res[j++] = 'E';
                if  (flags & PGOBLIN_SQLITE_SQ) res[j++] = '\'';
                if  (flags & PGOBLIN_SQLITE_DQ) res[j++] = '\"';
                for (i = 0; i < len; i++) {
                    if  ((cp[i] == '\\') && (flags & PGOBLIN_SQLITE_SL)) res[j++] = '\\';
                    if  ((cp[i] == '\'') && (flags & PGOBLIN_SQLITE_SQ)) res[j++] = '\'';
                    if  ((cp[i] == '\"') && (flags & PGOBLIN_SQLITE_DQ)) res[j++] = '\"';
                    res[j++] = cp[i];
                }
                if  (flags & PGOBLIN_SQLITE_DQ) res[j++] = '\"';
                if  (flags & PGOBLIN_SQLITE_SQ) res[j++] = '\'';
                res[j] = '\0';
                sqlite3_result_text(ctx, res, j, free);
            }
        } else {
            sqlite3_result_text(ctx, cp, -1, SQLITE_TRANSIENT);
}   }   }

static const u_char subst_in[]    = {
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,5,0, 0,0,4,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 3,0,3,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 5,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};

static const char *subst_out[] = {
 "\000"  ,"\001"  ,"\002"  ,"\003"  , "\004"  ,"\005"  ,"\006"  ,"\007",
 "\010"  ,"\011"  ,"\012"  ,"\013"  , "\014"  ,"\015"  ,"\016"  ,"\017",
 "\020"  ,"\021"  ,"\022"  ,"\023"  , "\024"  ,"\025"  ,"\026"  ,"\027",
 "\030"  ,"\031"  ,"\032"  ,"\033"  , "\034"  ,"\035"  ,"\036"  ,"\037",
 "\040"  ,"\041"  ,"&quot;","\043"  , "\044"  ,"\045"  ,"&amp;" ,"\047",
 "\050"  ,"\051"  ,"\052"  ,"\053"  , "\054"  ,"\055"  ,"\056"  ,"\057",
 "\060"  ,"\061"  ,"\062"  ,"\063"  , "\064"  ,"\065"  ,"\066"  ,"\067",
 "\070"  ,"\071"  ,"\072"  ,"\073"  , "&lt;"  ,"\075"  ,"&gt;"  ,"\077",

 "\100"  ,"\101"  ,"\102"  ,"\103"  , "\104"  ,"\105"  ,"\106"  ,"\107",
 "\110"  ,"\111"  ,"\112"  ,"\113"  , "\114"  ,"\115"  ,"\116"  ,"\117",
 "\120"  ,"\121"  ,"\122"  ,"\123"  , "\124"  ,"\125"  ,"\126"  ,"\127",
 "\130"  ,"\131"  ,"\132"  ,"\133"  , "\134"  ,"\135"  ,"\136"  ,"\137",
 "\140"  ,"\141"  ,"\142"  ,"\143"  , "\144"  ,"\145"  ,"\146"  ,"\147",
 "\150"  ,"\151"  ,"\152"  ,"\153"  , "\154"  ,"\155"  ,"\156"  ,"\157",
 "\160"  ,"\161"  ,"\162"  ,"\163"  , "\164"  ,"\165"  ,"\166"  ,"\167",
 "\170"  ,"\171"  ,"\172"  ,"\173"  , "\174"  ,"\175"  ,"\176"  ,"\177",

 "\200"  ,"\201"  ,"\202"  ,"\203"  , "\204"  ,"\205"  ,"\206"  ,"\207",
 "\210"  ,"\211"  ,"\212"  ,"\213"  , "\214"  ,"\215"  ,"\216"  ,"\217",
 "\220"  ,"\221"  ,"\222"  ,"\223"  , "\224"  ,"\225"  ,"\226"  ,"\227",
 "&nbsp;","\231"  ,"\232"  ,"\233"  , "\234"  ,"\235"  ,"\236"  ,"\237",
 "\240"  ,"\241"  ,"\242"  ,"\243"  , "\244"  ,"\245"  ,"\246"  ,"\247",
 "\250"  ,"\251"  ,"\252"  ,"\253"  , "\254"  ,"\255"  ,"\256"  ,"\257",
 "\260"  ,"\261"  ,"\262"  ,"\263"  , "\264"  ,"\265"  ,"\266"  ,"\267",
 "\270"  ,"\271"  ,"\272"  ,"\273"  , "\274"  ,"\275"  ,"\276"  ,"\277",

 "\300"  ,"\301"  ,"\302"  ,"\303"  , "\304"  ,"\305"  ,"\306"  ,"\307",
 "\310"  ,"\311"  ,"\312"  ,"\313"  , "\314"  ,"\315"  ,"\316"  ,"\317",
 "\320"  ,"\321"  ,"\322"  ,"\323"  , "\324"  ,"\325"  ,"\326"  ,"\327",
 "\330"  ,"\331"  ,"\332"  ,"\333"  , "\334"  ,"\335"  ,"\336"  ,"\337",
 "\340"  ,"\341"  ,"\342"  ,"\343"  , "\344"  ,"\345"  ,"\346"  ,"\347",
 "\350"  ,"\351"  ,"\352"  ,"\353"  , "\354"  ,"\355"  ,"\356"  ,"\357",
 "\360"  ,"\361"  ,"\362"  ,"\363"  , "\364"  ,"\365"  ,"\366"  ,"\367",
 "\370"  ,"\371"  ,"\372"  ,"\373"  , "\374"  ,"\375"  ,"\376"  ,"\377"};

void
_pgoblin_sqlite3_quote_html(sqlite3_context *ctx, int argc, sqlite3_value **argv) {
    int nquotes, i, j;
    u_int32_t flags;
    const char *cp, *q;
    ssize_t len;
    char *res;

    flags = (u_int32_t)BLIN_I(sqlite3_user_data(ctx));
    cp = (char*)sqlite3_value_text(argv[0]);
    if  (!cp) {
        sqlite3_result_null(ctx);
    } else {
        len = strlen(cp);
        for (i = 0, nquotes = 0; i < len; i++) nquotes += (int)subst_in[((u_char*)cp)[i]];
        if  (nquotes) {
            if  (!(res = malloc(len + nquotes + 3))) {
                ifBLIN_QV1(flags) warnx("No mem pgoblin_sqlite3_quote_html");
                sqlite3_result_error_nomem(ctx);
             } else {
                for (j = 0, i = 0; i < len; i++) {
                    q = subst_out[((u_char*)cp)[i]];
                    do  {res[j++] = *q++;} while (*q);
                }
                res[j] = '\0';
                sqlite3_result_text(ctx, res, j, free);
            }
        } else {
            sqlite3_result_text(ctx, cp, -1, SQLITE_TRANSIENT);
}   }   }

void
__pgoblin_sqlite3_regexp(sqlite3_context *ctx, int argc, sqlite3_value **argv) {
    const char *re, *str;
    int exx = 0, ex = 0;
    regex_t *preg;
    size_t elen;
    char *err;

    re = (char*)sqlite3_value_text(argv[0]);
    str = (char*)sqlite3_value_text(argv[1]);
    if  (!re || !str) {
        sqlite3_result_null(ctx);
    } else {
        if  (!(preg = sqlite3_get_auxdata(ctx, 0))) {
            if  (!(preg = malloc(sizeof(preg)))) {
                sqlite3_result_error_nomem(ctx);
                exx = -2147203043;
            } else if ((ex = regcomp(preg, re, REG_EXTENDED | REG_NOSUB))) {
                exx = -2146484339;
            } else {
                sqlite3_set_auxdata(ctx, 0, preg, (void (*)(void*))regfree);
        }   }
        if  (!exx) {
            ex = regexec(preg, str, 0, NULL, 0);
        }
        switch (exx ? exx : ex) {
        case 0          : sqlite3_result_int(ctx, 1); break;
        case REG_NOMATCH: sqlite3_result_int(ctx, 0); break;
        case -2147203043:                             break;
        default         : if  (!(err = malloc((elen = regerror(ex, preg, NULL, 0))))) {
                        ;     sqlite3_result_error_nomem(ctx);
                        ; } else {
                        ;     regerror(ex, preg, err, elen);
                        ;     ifBLIN_QV1(BLIN_I(sqlite3_user_data(ctx))) warnx("regex %s",err);
                        ;     sqlite3_result_error(ctx, err, -1);
                        ;     free(err);
}   }   }               ; }

void
_pgoblin_sqlite3_gettimeofday(sqlite3_context *ctx, int argc, sqlite3_value **argv) {
    struct timeval tp;
    u_int32_t flags;

    flags = (u_int32_t)BLIN_I(sqlite3_user_data(ctx));

    if  (gettimeofday(&tp, NULL)) {
        ifBLIN_QV1(flags) warnx("sqlite3 gettimeofday");
        sqlite3_result_error(ctx, strerror(errno), -1);
    } else {
        sqlite3_result_double(ctx, 0.000001 * tp.tv_usec + tp.tv_sec);
}   }

__weak_reference(_pgoblin_sqlite3_gettimeofday, pgoblin_sqlite3_gettimeofday);
__weak_reference(__pgoblin_sqlite3_regexp, _pgoblin_sqlite3_regexp);
__weak_reference(__pgoblin_sqlite3_regexp, pgoblin_sqlite3_regexp);
__weak_reference(_pgoblin_sqlite3_quote_html, pgoblin_sqlite3_quote_html);
__weak_reference(_pgoblin_sqlite3_quote, pgoblin_sqlite3_quote);

/* SQLite 3 interface to pgoblin */

#define INDX(R, C) (R * res->ncol + C)

#define ERRMSG(W, X) {                                                                                \
    if  ((ex != SQLITE_OK) && (ex != SQLITE_ROW) && (ex != SQLITE_DONE)) {                            \
        ifBLIN_QV1(db->flags) {warnx(W " %d: %s", ex, sqlite3_errmsg(conn->odf));};                   \
        ERROUT((X), oxdecode(ex));                                                                    \
}   }

pgoblin_dbases pgoblin_db_sqlite3;

enum states
{ bg /*        */
, bq /* \      */
, bz /*  \0            */
, be /*  \             */
, b1 /*  \[0..7]       */
, b2 /*  \[0..7][0..7] */
, bb /*       */
, bd /* \     */
, bc /*             */
, bt /*        */
, bn /*  \N            */
, bx
};

static const char *statenames[] =
{ "bg", "bq", "bz", "be", "b1", "b2", "bb", "bd", "bc", "bt", "bn", "bx"
};

typedef struct pgoblin_db_conn {
    sqlite3     *odf;
    sqlite3_stmt*vm;
    const char  *query;
    u_int32_t    flags;
#   define       PGOBLIN_STREAMI 0x000001
#   define       PGOBLIN_STREAMT 0x000002
#   define       PGOBLIN_STREAME 0x000004
#   define       PGOBLIN_ALLOUT  (PGOBLIN_STREAMI | PGOBLIN_STREAMT | PGOBLIN_STREAME)
#   define       PGOBLIN_COPYIN  0x000010
#   define       PGOBLIN_COPYST  0x000020
#   define       PGOBLIN_COPYEN  0x000040
#   define       PGOBLIN_ALLIN   (PGOBLIN_COPYIN | PGOBLIN_COPYST | PGOBLIN_COPYEN)
    u_char      *semi;
    int          ncol;
    int          coln;
    u_char       reg;
    enum states  state;
} pgoblin_db_conn;

typedef struct pgoblin_db_data {
    u_int32_t         flags;
#   define PGOBLIN_TINIT 0x000001
#   define PGOBLIN_MULAR 0x000002
    int               nrow;
    int               ncol;
    union {
        mular_descriptor *m;
        u_char           *a[1];
    }                 cell;
} pgoblin_db_data;

static size_t mdp[] = {1024, 512, 512};

static u_char sqle[] =
{ 0            /* SQLITE_OK         Successful result                          */
, ENOTSUP      /* SQLITE_ERROR      SQL error or missing database              */
, ENOEXEC      /* SQLITE_INTERNAL   An internal logic error in SQLite          */
, EPERM        /* SQLITE_PERM       Access permission denied                   */
, ECANCELED    /* SQLITE_ABORT      Callback routine requested an abort        */
, ETXTBSY      /* SQLITE_BUSY       The database file is locked                */
, EDEADLK      /* SQLITE_LOCKED     A table in the database is locked          */
, ENOMEM       /* SQLITE_NOMEM      A malloc() failed                          */
, EROFS        /* SQLITE_READONLY   Attempt to write a readonly database       */
, EINTR        /* SQLITE_INTERRUPT  Operation terminated by sqlite3_interrupt()*/
, EIO          /* SQLITE_IOERR      Some kind of disk I/O error occurred       */
, EILSEQ       /* SQLITE_CORRUPT    The database disk image is malformed       */
, EFAULT       /* SQLITE_NOTFOUND   (Internal Only) Table or record not found  */
, EOVERFLOW    /* SQLITE_FULL       Insertion failed because database is full  */
, ENOATTR      /* SQLITE_CANTOPEN   Unable to open the database file           */
, ENOLCK       /* SQLITE_PROTOCOL   Database lock protocol error               */
, ENOENT       /* SQLITE_EMPTY      (Internal Only) Database table is empty    */
, EIDRM        /* SQLITE_SCHEMA     The database schema changed                */
, EMSGSIZE     /* SQLITE_TOOBIG     Too much data for one row of a table       */
, EEXIST       /* SQLITE_CONSTRAINT Abort due to contraint violation           */
, EPROCUNAVAIL /* SQLITE_MISMATCH   Data type mismatch                         */
, EINVAL       /* SQLITE_MISUSE     Library used incorrectly                   */
, ENOSYS       /* SQLITE_NOLFS      Uses OS features not supported on host     */
, EAUTH        /* SQLITE_AUTH       Authorization denied                       */
, EFTYPE       /* SQLITE_FORMAT     Auxiliary database format error            */
, EDOM         /* SQLITE_RANGE      2nd parameter to sqlite3_bind out of range */
, EBADF        /* SQLITE_NOTADB     File opened that is not a database file    */
};

static int
oxdecode(int i) {
    int e;
    if      (i == SQLITE_ROW)                e = EAGAIN;
/*  else if (i == SQLITE_DONE) */
    else if ((i < 0) || (i > SQLITE_NOTADB)) e = ENOMSG;
    else                                     e = sqle[i];
    return(e);
}

static const char *
exdecode(int ex) {
    const char *c;
    switch (ex) {
    case SQLITE_OK                     : c = "SQLITE_OK";                      break;
    case SQLITE_ERROR                  : c = "SQLITE_ERROR";                   break;
    case SQLITE_INTERNAL               : c = "SQLITE_INTERNAL";                break;
    case SQLITE_PERM                   : c = "SQLITE_PERM";                    break;
    case SQLITE_ABORT                  : c = "SQLITE_ABORT";                   break;
    case SQLITE_BUSY                   : c = "SQLITE_BUSY";                    break;
    case SQLITE_LOCKED                 : c = "SQLITE_LOCKED";                  break;
    case SQLITE_NOMEM                  : c = "SQLITE_NOMEM";                   break;
    case SQLITE_READONLY               : c = "SQLITE_READONLY";                break;
    case SQLITE_INTERRUPT              : c = "SQLITE_INTERRUPT";               break;
    case SQLITE_IOERR                  : c = "SQLITE_IOERR";                   break;
    case SQLITE_CORRUPT                : c = "SQLITE_CORRUPT";                 break;
    case SQLITE_NOTFOUND               : c = "SQLITE_NOTFOUND";                break;
    case SQLITE_FULL                   : c = "SQLITE_FULL";                    break;
    case SQLITE_CANTOPEN               : c = "SQLITE_CANTOPEN";                break;
    case SQLITE_PROTOCOL               : c = "SQLITE_PROTOCOL";                break;
    case SQLITE_EMPTY                  : c = "SQLITE_EMPTY";                   break;
    case SQLITE_SCHEMA                 : c = "SQLITE_SCHEMA";                  break;
    case SQLITE_TOOBIG                 : c = "SQLITE_TOOBIG";                  break;
    case SQLITE_CONSTRAINT             : c = "SQLITE_CONSTRAINT";              break;
    case SQLITE_MISMATCH               : c = "SQLITE_MISMATCH";                break;
    case SQLITE_MISUSE                 : c = "SQLITE_MISUSE";                  break;
    case SQLITE_NOLFS                  : c = "SQLITE_NOLFS";                   break;
    case SQLITE_AUTH                   : c = "SQLITE_AUTH";                    break;
    case SQLITE_FORMAT                 : c = "SQLITE_FORMAT";                  break;
    case SQLITE_RANGE                  : c = "SQLITE_RANGE";                   break;
    case SQLITE_NOTADB                 : c = "SQLITE_NOTADB";                  break;
    case SQLITE_ROW                    : c = "SQLITE_ROW";                     break;
    case SQLITE_DONE                   : c = "SQLITE_DONE";                    break;
    case SQLITE_IOERR_READ             : c = "SQLITE_IOERR_READ";              break;
    case SQLITE_IOERR_SHORT_READ       : c = "SQLITE_IOERR_SHORT_READ";        break;
    case SQLITE_IOERR_WRITE            : c = "SQLITE_IOERR_WRITE";             break;
    case SQLITE_IOERR_FSYNC            : c = "SQLITE_IOERR_FSYNC";             break;
    case SQLITE_IOERR_DIR_FSYNC        : c = "SQLITE_IOERR_DIR_FSYNC";         break;
    case SQLITE_IOERR_TRUNCATE         : c = "SQLITE_IOERR_TRUNCATE";          break;
    case SQLITE_IOERR_FSTAT            : c = "SQLITE_IOERR_FSTAT";             break;
    case SQLITE_IOERR_UNLOCK           : c = "SQLITE_IOERR_UNLOCK";            break;
    case SQLITE_IOERR_RDLOCK           : c = "SQLITE_IOERR_RDLOCK";            break;
    case SQLITE_IOERR_DELETE           : c = "SQLITE_IOERR_DELETE";            break;
    case SQLITE_IOERR_BLOCKED          : c = "SQLITE_IOERR_BLOCKED";           break;
    case SQLITE_IOERR_NOMEM            : c = "SQLITE_IOERR_NOMEM";             break;
#ifdef SQLITE_IOERR_ACCESS  /* SQLite 3.6.0 and up */
    case SQLITE_IOERR_ACCESS           : c = "SQLITE_IOERR_ACCESS";            break;
    case SQLITE_IOERR_CHECKRESERVEDLOCK: c = "SQLITE_IOERR_CHECKRESERVEDLOCK"; break;
    case SQLITE_IOERR_LOCK             : c = "SQLITE_IOERR_LOCK";              break;
    case SQLITE_IOERR_CLOSE            : c = "SQLITE_IOERR_CLOSE";             break;
    case SQLITE_IOERR_DIR_CLOSE        : c = "SQLITE_IOERR_DIR_CLOSE";         break;
#endif
#ifdef SQLITE_LOCKED_SHAREDCACHE
    case SQLITE_LOCKED_SHAREDCACHE     : c = "SQLITE_LOCKED_SHAREDCACHE";      break;
#endif
    default                            :
        if  (ex & ~0xFF) c = exdecode(ex & 0xFF); else c = "UNKNOWN";
    }
    return(c);
}

static int
initm(u_int32_t flags, pgoblin_dbases *this) {
    int ex = EX_OK;

#ifdef SQLITE_CONFIG_SINGLETHREAD
    if  (sqlite3_threadsafe()) {
        ex = sqlite3_config(SQLITE_CONFIG_SINGLETHREAD);
        if  (ex != SQLITE_OK) {
            ifBLIN_QV1(flags) warnx("sqlite3_config SINGLETHREAD %d: %s", ex, exdecode(ex));
            ERROUT(EX_UNAVAILABLE, oxdecode(ex));
    }   }
#endif
#ifdef SQLITE_CONFIG_MEMSTATUS
    ex = sqlite3_config(SQLITE_CONFIG_MEMSTATUS, 0);
    if  (ex != SQLITE_OK) {
        ifBLIN_QV1(flags) warnx("sqlite3_config MEMSTATUS %d: %s", ex, exdecode(ex));
        ERROUT(EX_UNAVAILABLE, oxdecode(ex));
    }
#endif
#if defined(SQLITE_VERSION_NUMBER) && (SQLITE_VERSION_NUMBER >= 3006000)
    ex = sqlite3_initialize();
    if  (ex != SQLITE_OK) {
        ifBLIN_QV1(flags) warnx("sqlite3_initialize %d: %s", ex, exdecode(ex));
        ERROUT(EX_UNAVAILABLE, oxdecode(ex));
    }
#endif
#if defined(SQLITE_CONFIG_SINGLETHREAD) || defined(SQLITE_CONFIG_MEMSTATUS) || (defined(SQLITE_VERSION_NUMBER) && (SQLITE_VERSION_NUMBER >= 3006000))
out:
#endif
    return(ex);
}

static int
finim(u_int32_t flags, pgoblin_dbases *this) {
    int ex = EX_OK;

#if defined(SQLITE_VERSION_NUMBER) && (SQLITE_VERSION_NUMBER >= 3006000)
    sqlite3_shutdown();
    if  (ex != SQLITE_OK) {
        ifBLIN_QV1(flags) warnx("sqlite3_shutdown %d: %s", ex, exdecode(ex));
        ERROUT(EX_UNAVAILABLE, oxdecode(ex));
    }
out:
#endif
    return(ex);
}

static int
shurecon(pgoblin_conn *db) {
    int ex = EX_OK;
    pgoblin_db_conn *conn;

    if  (db->conn != NULL) return(0);
    ifBLIN_QV5(db->flags) {
        fprintf(stderr, "lib version=%s\n", sqlite3_version);
    }
    if  (!(conn = malloc(sizeof(pgoblin_db_conn)))) {
        ifBLIN_QV1(db->flags) warnx("shurecon: no RAM");
        ERROUT(EX_OSERR, ENOMEM);
    }
    bzero(conn, sizeof(pgoblin_db_conn));
    ex = sqlite3_open_v2( db->dbname ? db->dbname : ":memory:"
                        , &conn->odf
                        , SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE
                        , NULL
                        );
    if  (!conn->odf) {
        ifBLIN_QV1(db->flags) warnx("shurecon aborted");
        ERROUT(EX_UNAVAILABLE, ENODEV);
    }
    ERRMSG("sqlite3_open", EX_UNAVAILABLE);
    MARK_R_CONN_GO(0);;
    ;;  db->conn = conn;
    ;;  db->flags |= PGOBLIN_CLOSECONN;
    MARK_R_CONN_WENT(0);;
    ex = sqlite3_extended_result_codes(conn->odf, 1);
    ERRMSG("sqlite3_extended_result_codes", EX_UNAVAILABLE);
    ex = sqlite3_create_function( conn->odf
                                , "regexp"
                                , 2
                                , SQLITE_ANY
                                , (void*)db->flags
                                , pgoblin_sqlite3_regexp
                                , NULL
                                , NULL
                                );
    ERRMSG("regexp creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "quote_literal"
                                , 1
                                , SQLITE_ANY
                                , (void*)((db->flags & BLIN_VERMASK) | PGOBLIN_SQLITE_SQ)
                                , pgoblin_sqlite3_quote
                                , NULL
                                , NULL
                                );
    ERRMSG("quote_literal creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "quote_ident"
                                , 1
                                , SQLITE_ANY
                                , (void*)( (db->flags & BLIN_VERMASK)
                                         | PGOBLIN_SQLITE_DQ | PGOBLIN_SQLITE_SF | PGOBLIN_SQLITE_KY
                                         )
                                , pgoblin_sqlite3_quote
                                , NULL
                                , NULL
                                );
    ERRMSG("quote_ident creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "quote_ident_always"
                                , 1
                                , SQLITE_ANY
                                , (void*)((db->flags & BLIN_VERMASK) | PGOBLIN_SQLITE_DQ)
                                , pgoblin_sqlite3_quote
                                , NULL
                                , NULL
                                );
    ERRMSG("quote_ident_always creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "quote_html"
                                , 1
                                , SQLITE_ANY
                                , (void*)(db->flags & BLIN_VERMASK)
                                , pgoblin_sqlite3_quote_html
                                , NULL
                                , NULL
                                );
    ERRMSG("quote_html creation", EX_DATAERR);
    ex = sqlite3_create_function( conn->odf
                                , "gettimeofday"
                                , 0
                                , SQLITE_ANY
                                , (void*)(db->flags & BLIN_VERMASK)
                                , pgoblin_sqlite3_gettimeofday
                                , NULL
                                , NULL
                                );
    ERRMSG("gettimeofday creation", EX_DATAERR);
    ifBLIN_QV5(db->flags) {

    }
out:
    return(ex);
}

/*      0x01..0x0F */
/*   ASCII    */
#define Lx         0x00
#define Lz         0x10
#define Lb ('\b' | 0x20)
#define Lf ('\f' | 0x20)
#define Ln ('\n' | 0x20)
#define Lr ('\r' | 0x20)
#define Lt ('\t' | 0x20)
#define Lv ('\v' | 0x20)
#define L0 ('0') /*0x30*/
#define L1 ('1') /*0x31*/
#define L2 ('2') /*0x32*/
#define L3 ('3') /*0x33*/
#define L4 ('4') /*0x34*/
#define L5 ('5') /*0x35*/
#define L6 ('6') /*0x36*/
#define L7 ('7') /*0x37*/
#define Lc         0x40  /* \t */
#define Ls ('\\')/*0x5C*/
#define Lw         0x60  /* \n */
#define Le         0x70  /*  * */
#define Lu         0x80  /* \N */
#define Ld         0x90  /* \. */
#define LX         0xA0

static const char *clasnames[] =
{ "Lx", "LX", "LX", "LX",  "LX", "LX", "LX", "LX",  "LX", "LX", "LX", "LX",  "LX", "LX", "LX", "LX"
, "Lz", "LZ", "LZ", "LZ",  "Lz", "LZ", "LZ", "LZ",  "Lz", "LZ", "LZ", "LZ",  "Lz", "LZ", "LZ", "LZ"
, "LL", "LL", "LL", "LL",  "LL", "LL", "LL", "LL",  "Lb", "Lt", "Ln", "Lv",  "Lf", "Lr", "LL", "LL"
, "L0", "L1", "L2", "L3",  "L4", "L5", "L6", "L7",  "LN", "LN", "LN", "LN",  "LN", "LN", "LN", "LN"
, "Lc", "LC", "LC", "LC",  "Lc", "LC", "LC", "LC",  "Lc", "LC", "LC", "LC",  "Lc", "LC", "LC", "LC"
, "LS", "LS", "LS", "LS",  "LS", "LS", "LS", "LS",  "LS", "LS", "LS", "LS",  "Ls", "LS", "LS", "LS"
, "Lw", "LW", "LW", "LW",  "LW", "LW", "LW", "LW",  "LW", "LW", "LW", "LW",  "LW", "LW", "LW", "LW"
, "Le", "LE", "LE", "LE",  "LE", "LE", "LE", "LE",  "LE", "LE", "LE", "LE",  "LE", "LE", "LE", "LE"
, "Lu", "LU", "LU", "LU",  "LU", "LU", "LU", "LU",  "LU", "LU", "LU", "LU",  "LU", "LU", "LU", "LU"
, "Ld", "LD", "LD", "LD",  "LD", "LD", "LD", "LD",  "LD", "LD", "LD", "LD",  "LD", "LD", "LD", "LD"
};

static const u_char class[256] =
{ Lz, Le, Le, Le,  Le, Le, Le, Le,  Le, Lc, Lw, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Ld, Le
, L0, L1, L2, L3,  L4, L5, L6, L7,  Le, Le, Le, Le,  Le, Le, Le, Le

, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Lu, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Ls, Le, Le, Le
, Le, Le, Lb, Le,  Le, Le, Lf, Le,  Le, Le, Le, Le,  Le, Le, Ln, Le
, Le, Le, Lr, Le,  Lt, Le, Lv, Le,  Le, Le, Le, Le,  Le, Le, Le, Le

, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le

, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
, Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le,  Le, Le, Le, Le
};

static const char *pn[] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "Co", "Cb", "Cr", "Cq", "Cg", "Cp", "Cn", "Cc"
, "Cl", "Cs", "Cx", "Ck", "Cu", "- ", "- ", "- "
};

#define Co 0x00800000 /*              */
#define Cb 0x00400000 /*             */
#define Cr 0x00200000 /*           */
#define Cq 0x00100000 /*                 */
#define Cg 0x00080000 /*   */
#define Cp 0x00040000 /*          */
#define Cn 0x00020000 /* NULL        */
#define Cc 0x00010000 /*             */
#define Cl 0x00008000 /*              */
#define Cs 0x00004000 /* COPY                 */          
#define Cx 0x00002000 /*                     */
#define Ck 0x00001000 /*             */
#define Cu 0x00000800 /*        */
#define C_state  0xFF /*         */

static u_int32_t automa[bx][LX >> 4] =
/* 0 Lx  1 \0 Lz     2 LL     3 LN  4 \t Lc 5  \ Ls     6 \n Lw  7  * Le  8  N Lu  9  . Ld  */
{{Cu|bg,Co|Cc|bz,Co|Cp|bc,Co|Cp|bc,Co|Cc|bb,Co|  bq,Co|Cc|Cl|bg,Co|Cp|bc,Co|Cp|bc,Co|Cp|bc}/* bg */
,{Cu|bq,      bz,   Cg|bc,Cb|   b1,   Cc|bb,     bb,   Cc|Cl|bg,   Cp|bc,   Cn|bt,      bx}/* bq */
,{Cu|bz,      bz,      bz,      bz,   Cc|bb,     bz,   Cc|Cl|bg,      bz,      bz,      bz}/* bz */
,{Ck|be,      bz,   Cg|bc,Cb|   b1,   Cc|bb,  Cp|bc,   Cc|Cl|bg,   Cp|bc,   Cp|bc,   Cp|bc}/* be */
,{Ck|b1,Cq|   bz,Cq|Cp|bc,Cr|   b2,Cq|Cc|bb,Cq|  be,Cq|Cc|Cl|bg,Cq|Cp|bc,Cq|Cp|bc,Cq|Cp|bc}/* b1 */
,{Ck|b2,Cq|   bz,Cq|Cp|bc,Cr|Cq|bc,Cq|Cc|bb,Cq|  be,Cq|Cc|Cl|bg,Cq|Cp|bc,Cq|Cp|bc,Cq|Cp|bc}/* b2 */
,{Cu|bb,Co|Cc|bz,Co|Cp|bc,Co|Cp|bc,Co|Cc|bb,Co|  bd,Co|Cc|Cl|bg,Co|Cp|bc,Co|Cp|bc,Co|Cp|bc}/* bb */
,{Cu|bb,      bz,   Cg|bc,Cb|   b1,   Cc|bb,  Cp|bc,   Cc|Cl|bg,   Cp|bc,   Cn|bn,   Cp|bc}/* bd */
,{Ck|bc,      bz,   Cp|bc,   Cp|bc,   Cc|bb,     be,   Cc|Cl|bg,   Cp|bc,   Cp|bc,   Cp|bc}/* bc */
,{Cu|bt,      bz,   Cx|bx,   Cx|bx,      bb,  Cx|bx,   Cc|Cl|bg,   Cx|bx,   Cx|bx,   Cx|bx}/* bt */
,{Cu|bt,      bz,   Cx|bx,   Cx|bx,      bb,  Cx|bx,      Cl|bg,   Cx|bx,   Cx|bx,   Cx|bx}/* bn */
};

static int
putcopy(pgoblin_conn *db, const void *buf, int nby) {
    /* sqlite3_bind_text() should not be used for any XXXX */
    pgoblin_db_conn *conn = db->conn;
    u_char *b, *q, *p, *c;
    u_int32_t control;
    int ex = 0, i;

    if  (!(conn->flags & (PGOBLIN_COPYIN | PGOBLIN_COPYEN))) { /* XXXX COPYEN   */
        ifBLIN_QV1(db->flags) warnx("putcopy sqlite3: not COPYin state");
        ERROUT(-EX_DATAERR, ENODEV);
    }
    if  (!(b = malloc(nby))) {
        ifBLIN_QV1(db->flags) warnx("putcopy sqlite3: no mem #0");
        ERROUT(-EX_OSERR, ENOMEM);
    }
    bcopy(buf, b, nby);
    c = p = q = b;
    ifBLIN_QV5(db->flags) BLIN_STATEHEADER(stderr, pn);
    for (; conn->state < bx; q++) {
        if  (q < b + nby) control = automa[conn->state][class[*q] >> 4];
          else control = automa[conn->state][Lx >> 4];
        ifBLIN_QV5(db->flags)
            BLIN_STATEBODY(stderr, pn, conn->reg, clasnames[class[*q]], q, (int)p - (int)c, BLIN_I(q), control, statenames, conn->state, C_state, (q[BLIN_STATEVAR_i]!='\n'))
        if  (control & Co) c = p = q;
        if  (control & Cb) conn->reg = class[*q] & 0x07;
        if  (control & Cr) conn->reg = (conn->reg << 3) | (class[*q] & 0x07);
        if  (control & Cq) *(p++) = conn->reg & 0xFF;
        if  (control & Cg) *(p++) = class[*q] & 0x0F;
        if  (control & Cp) {
            if  (p == q) p++; else *(p++) = *q;
        }
        if  ((control & (Cn | Cc | Cl)) && (conn->flags & PGOBLIN_COPYST)) {
            if  (!conn->vm) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 putcopy: no VM");
                ERROUT(-EX_SOFTWARE, ENOEXEC);
            }
            ex = sqlite3_reset(conn->vm);
            ERRMSG("sqlite3_reset", -EX_SOFTWARE);
            conn->flags &= ~PGOBLIN_COPYST;
        }
        if  (control & Cn) {
            free(conn->semi);
            conn->semi = NULL;
            ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_bind_text#1 [%d]NULL\n", conn->ncol);
            ex = sqlite3_bind_text(conn->vm, ++(conn->ncol), NULL, 0, NULL);
            ERRMSG("sqlite3_bind_text#1", -EX_SOFTWARE);
        }
        if  (control & Cc) { /*   */
            *p = '\0';
            if  (conn->semi) {
                if  (!(p = malloc(strlen((char*)conn->semi) + strlen((char*)c) + 1))) {
                    ifBLIN_QV1(db->flags) warnx("putcopy sqlite3: no mem #1");
                    ERROUT(-EX_OSERR, ENOMEM);
                }
                strcpy((char*)p, (char*)conn->semi);
                strcat((char*)p, (char*)c);
                ifBLIN_QV5(db->flags)
                    fprintf(stderr, "sqlite3_bind_text#2 [%d]%d=%s~\n", conn->ncol, -1, p);
                /* SQLITE_STATIC should be used in most cases instead SQLITE_TRANSIENT XXXX */
                ex = sqlite3_bind_text(conn->vm, ++(conn->ncol), (char*)p, -1, SQLITE_TRANSIENT);
                ERRMSG("sqlite3_bind_text#2", -EX_SOFTWARE);
                free(p);
                free(conn->semi);
                conn->semi = NULL;
            } else {
                ifBLIN_QV5(db->flags)
                    fprintf(stderr, "sqlite3_bind_text#3 [%d]%d=%s~\n", conn->ncol, -1, c);
                /* SQLITE_STATIC should be used in most cases instead SQLITE_TRANSIENT XXXX */
                ex = sqlite3_bind_text(conn->vm, ++(conn->ncol), (char*)c, -1, SQLITE_TRANSIENT);
                ERRMSG("sqlite3_bind_text#3", -EX_SOFTWARE);
        }   }
        if  (control & Cl) { /*   */
            conn->flags |= PGOBLIN_COPYST;
            ex = sqlite3_step(conn->vm);
            ERRMSG("sqlite3_step#1", -EX_SOFTWARE);
            conn->ncol = 0;
        }
        if  (control & Cs) {
            conn->flags |= PGOBLIN_COPYEN;
            conn->ncol = 0;
        }
        if  (control & Ck) {
            i = p - c;
            if  (!i) break;
            if  (conn->semi) {
                if  (!(p = malloc(strlen((char*)conn->semi) + i + 1))) {
                    ifBLIN_QV1(db->flags) warnx("putcopy sqlite3: no mem #2");
                    ERROUT(-EX_OSERR, ENOMEM);
                }
                strcpy((char*)p, (char*)conn->semi);
                bcopy(c, index((char*)p, '\0'), i);
                p[strlen((char*)conn->semi) + i] = '\0';
                free(conn->semi);
                conn->semi = p;
            } else {
                if  (!(conn->semi = malloc(i + 1))) {
                    ifBLIN_QV1(db->flags) warnx("putcopy sqlite3: no mem #3");
                    ERROUT(-EX_OSERR, ENOMEM);
                }
                bcopy(c, conn->semi, i);
                conn->semi[i] = '\0';
        }   }
        if  (control & (Ck | Cu)) break;
        conn->state = control & C_state;
    }
    free(b);
out:
    return(ex ? ex : 1);
}

static int
finish(u_int32_t flags, int kind, void **entity) {
    int ex = EX_OK;

    switch (kind) {
    case PGOBLIN_Connect: {
            pgoblin_db_conn **conn = (pgoblin_db_conn **)entity;

            if  (conn && *conn) {
                if  ((*conn)->odf) {
                    sqlite3_close((*conn)->odf);
                    (*conn)->odf = NULL;
                }
                free(*conn);
                *conn = NULL;
        }   }
        break;
    case PGOBLIN_PFormed: {
            sqlite3_stmt **vm = (sqlite3_stmt **)entity;

            if  (vm && *vm) {
                ex = sqlite3_finalize(*vm);
                if  ((ex != SQLITE_OK) && (ex != SQLITE_ROW) && (ex != SQLITE_DONE)) {
                    ifBLIN_QV1(flags) warnx("sqlite3_finalize %d: %s", ex, exdecode(ex));
                    ex = EX_SOFTWARE;
                    errno = oxdecode(ex);
                }
                *vm = NULL;
        }   }
        break;
    case PGOBLIN_FrCOPY:
        if  (entity && *entity) {
            free(*entity);
            *entity = NULL;
        }
        break;
    case PGOBLIN_CleaRes: {
            pgoblin_db_data **res = (pgoblin_db_data **)entity;

            if  (res && *res) {
                if  (((*res)->flags & PGOBLIN_MULAR) && (*res)->cell.m) mular_destroy((*res)->cell.m);
                free(*res);
                *res = NULL;
        }   }
        break;
    default:
        ex = EX_UNAVAILABLE;
        errno = ENOTSUP;
    }
    return(ex);
}

static int
doquery(pgoblin_conn *db, void **rsv, const char *query, u_char cond) {
    pgoblin_db_data **rs = (pgoblin_db_data **)rsv;
    pgoblin_db_conn *conn = db->conn;
    pgoblin_db_data *res;
    int n, ex = 0;
    const u_char *q;
    u_char *p;
    char *c;
    int i;
    static const babolo_lexor copy = {(u_char*)
    "\000..." "...."    "  | "    "  .."    "...."    "...."    "...."    "...."
    " .."    "..."    "...."    ".-.."    "IIII"    "IIII"    "II.."    "...."
    ".EEC"    "EEEE"    "EEEE"    "EEEO"    "PEEE"    "EEEE"    "EYE."    "...E"
    ".EEC"    "EEEE"    "EEEE"    "EEEO"    "PEEE"    "EEEE"    "EYE."    "...."
    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"
    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"
    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"
    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"    "EEEE"
    , NULL, Bpars_AABS | Bpars_CEND, 0x1C, 0x1C, 1
    ,{/*00*/ 3, ' ',0x00, '|',0x00, '-',0x05, 'C',0x09, 0xFF
     ,/*05*/ 0, '-',0x07, 0xFF
     ,/*07*/ 0, '|',0x00, 0x07
     ,/*09*/ 0, 'O',0x0B, 0xFF
     ,/*0B*/ 0, 'P',0x0D, 0xFF
     ,/*0D*/ 0, 'Y',0x0F, 0xFF
     ,/*0F*/ 8, '',0xFE, ' ',0x0F, '|',0x0F, '-',0x19, 'C',0xFD, 'O',0xFD, 'P',0xFD, 'Y',0xFD, 'E',0xFD, 0xFF
     ,/*19*/ 0, '-',0x1A, 0xFF
     ,/*1A*/ 0, '|',0x0F, 0x1A
    }};

    ifBLIN_QV5(db->flags) fprintf(stderr, "doquery sqlite3 %d=%s~\n", cond, query);
    if  (conn->flags) {
        ifBLIN_QV1(db->flags) warnx("doquery sqlite3: COPY state");
        ERROUT(EX_DATAERR, ENODEV);
    }
    res = NULL;
    if  (query && *query) conn->query = query; else goto out;
    q = (u_char*)conn->query;
    switch (cond) {
    case PGOBLIN_CR_IN:
        conn->coln = 0;
        conn->state = bg;
        conn->semi = NULL;
        switch (babolo_goword(&copy, &q)) {
        case 0:
            ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#1 %d=%s~\n", cond, conn->query);
            ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
            ERRMSG("sqlite3_prepare_v2#1", EX_SOFTWARE);
            conn->flags |= PGOBLIN_COPYIN;
            break;
        case 1:
            if  (!*q) ERROUT(EX_DATAERR, EINVAL);
            q--;
            if  (*q == '\'') {
                for (n = 1;;) {
                    if (q[n++] == '\'' && q[n] != '\'') break;
                    if (!q[n]) ERROUT(EX_DATAERR, EINVAL);
                }
            } else if (*q == '\"') {
                for (n = 1;;) {
                    if (q[n++] == '\"' && q[n] != '\"') break;
                    if (!q[n]) ERROUT(EX_DATAERR, EINVAL);
                }
            } else ERROUT(EX_DATAERR, EINVAL);
            n++;
            ifBLIN_QV5(db->flags) fprintf(stderr, "goword quoted %d\n", n);
            goto p2;
        case 2:
            q--;
            for (n = 1;;) if ((copy.retable[q[n++]] & 0xC0) != 0x40) break;
            ifBLIN_QV5(db->flags) fprintf(stderr, "goword direct %d\n", n);
        p2: if  (!(p = malloc(n-- * sizeof(char)))) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no mem #0");
                ERROUT(EX_OSERR, ENOMEM);
            }
            for (i = 0; i < n; i++) p[i] = q[i];
            p[n] = '\0';
            conn->query = (char*)p;
            if  (asprintf(&c, "SELECT * FROM %s", conn->query) < 0) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no mem #1");
                ERROUT(EX_OSERR, ENOMEM);
            }
            ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#2 %d=%s~\n", cond, c);
            ex = sqlite3_prepare_v2(conn->odf, c, -1, &conn->vm, NULL);
            free(c);
            ERRMSG("sqlite3_prepare_v2#2", EX_SOFTWARE);
            if  (!conn->vm) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no VM #0");
                ERROUT(EX_SOFTWARE, ENOEXEC);
            }
            ex = sqlite3_step(conn->vm);
            ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_step %d %s\n", ex, exdecode(ex));
            if  (ex == SQLITE_ROW || ex == SQLITE_DONE) ex = 0;
            if  (ex) {
                ifBLIN_QV1(db->flags) warnx("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
                if  (conn->vm) {
                    ex = sqlite3_finalize(conn->vm);
                    ERRMSG("sqlite3_finalize", EX_SOFTWARE);
                }
                ERROUT(EX_SOFTWARE, oxdecode(ex));
            }
            n = sqlite3_column_count(conn->vm);
            ex = sqlite3_finalize(conn->vm);
            ERRMSG("sqlite3_finalize", EX_SOFTWARE);
            conn->coln = n;
            if  (!(p = malloc(2 * n * sizeof(char)))) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no mem #2");
                ERROUT(EX_OSERR, ENOMEM);
            }
            for (i = 0; i < n; i++) {
                p[2 * i] = '?';
                p[2 * i + 1] = ',';
            }
            p[2 * n - 1] = '\0';
            if  (asprintf(&c, "INSERT INTO %s VALUES(%s)", conn->query, p) < 0) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no mem #3");
                ERROUT(EX_OSERR, ENOMEM);
            }
            free(p);
            ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#3 %d=%s~\n", cond, c);
            ex = sqlite3_prepare_v2(conn->odf, c, -1, &conn->vm, NULL);
            free(c);
            ERRMSG("sqlite3_prepare_v2#3", EX_SOFTWARE);
            if  (!conn->vm) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no VM #1");
                ERROUT(EX_SOFTWARE, ENOEXEC);
        }   }
        conn->ncol = 0;
        conn->flags |= PGOBLIN_COPYIN;
        break;
    case PGOBLIN_CR_OUT:
        switch (babolo_goword(&copy, &q)) {
        case 1:
            if  (!*q) ERROUT(EX_DATAERR, EINVAL);
            q--;
            if  (*q == '\'') {
                for (n = 1;;) {
                    if (q[n++] == '\'' && q[n] != '\'') break;
                    if (!q[n]) ERROUT(EX_DATAERR, EINVAL);
                }
            } else if (*q == '\"') {
                for (n = 1;;) {
                    if (q[n++] == '\"' && q[n] != '\"') break;
                    if (!q[n]) ERROUT(EX_DATAERR, EINVAL);
                }
            } else ERROUT(EX_DATAERR, EINVAL);
            n++;
            ifBLIN_QV5(db->flags) fprintf(stderr, "goword quoted %d\n", n);
            goto p3;
        case 2:
            q--;
            for (n = 1;;) if ((copy.retable[q[n++]] & 0xC0) != 0x40) break;
            ifBLIN_QV5(db->flags) fprintf(stderr, "goword direct %d\n", n);
        p3: if  (!(p = malloc(n-- * sizeof(char)))) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no mem #5");
                ERROUT(EX_OSERR, ENOMEM);
            }
            for (i = 0; i < n; i++) p[i] = q[i];
            p[n] = '\0';
            conn->query = (char*)p;
            if  (asprintf(&c, "SELECT * FROM %s", conn->query) < 0) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no mem #6");
                ERROUT(EX_OSERR, ENOMEM);
            }
            ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#8 %d=%s~\n", cond, c);
            ex = sqlite3_prepare_v2(conn->odf, c, -1, &conn->vm, NULL);
            free(c);
            ERRMSG("sqlite3_prepare_v2#8", EX_SOFTWARE);
            if  (!conn->vm) {
                ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no VM #2");
                ERROUT(EX_SOFTWARE, ENOEXEC);
            }
            conn->flags |= PGOBLIN_STREAMI;
            goto out;
        case 0:
            ;
        }   /* FALLTHRU */
    case PGOBLIN_CR_SSEL:
        ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#6 %d=%s~\n", cond, conn->query);
        ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
        ERRMSG("sqlite3_prepare_v2#6", EX_SOFTWARE);
        if  (!conn->vm) {
            ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no VM #3");
            ERROUT(EX_SOFTWARE, ENOEXEC);
        }
        conn->flags |= PGOBLIN_STREAMI;
        break;
    case PGOBLIN_CR_OK:
        while (!ex && conn->query && *conn->query) {
            ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#4 %d=%s~\n", cond, conn->query);
            ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
            ERRMSG("sqlite3_prepare_v2#4", EX_SOFTWARE);
            if  (!conn->vm) break;
            n = sqlite3_column_count(conn->vm);
            if  (n) {
                ifBLIN_QV2(db->flags) warnx("wait for PGOBLIN_CR_OK but received %d cols", n);
            }
            for (;;) {
                ex = sqlite3_step(conn->vm);
                if  (ex == SQLITE_ROW) continue;
                if  (ex == SQLITE_DONE) ex = 0;
                ERRMSG("sqlite3_step#2", EX_SOFTWARE);
                break;
            }
            if  (ex) {
                ifBLIN_QV1(db->flags) warnx("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
                if  (conn->vm) {
                    ex = sqlite3_finalize(conn->vm);
                    ERRMSG("sqlite3_finalize", EX_SOFTWARE);
                }
                ERROUT(EX_SOFTWARE, oxdecode(ex));
            }
            ex = sqlite3_finalize(conn->vm);
            ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        }
        break;
    case PGOBLIN_CR_TUPL:
        if  (!(res = malloc(sizeof(pgoblin_db_data)))) {
            ifBLIN_QV1(db->flags) warnx("doquery sqlite3: no RAM");
            ERROUT(EX_OSERR, ENOMEM);
        }
        bzero(res, sizeof(pgoblin_db_data));
        while (!ex && conn->query && *conn->query) {
            ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#5 %d=%s~\n", cond, conn->query);
            ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
            ERRMSG("sqlite3_prepare_v2#5", EX_SOFTWARE);
            if  (!conn->vm) break;
            res->ncol = sqlite3_column_count(conn->vm);
            for (;;) {
                ex = sqlite3_step(conn->vm);
                ERRMSG("sqlite3_step#3", EX_SOFTWARE);
                if  (!(res->flags & PGOBLIN_TINIT)) {
                    res->nrow = 0;
                    res->flags |= PGOBLIN_TINIT;
                }
                if  (ex == SQLITE_ROW) {
                    ex = 0;
                    if  (!(res->flags & PGOBLIN_MULAR)) {
                        res->cell.m = mular_create( MULAR_CHAR | MULAR_ZERO
                                                  | MULAR_PFRE | MULAR_STRI | MULAR_UPPE
                                                  , 3, sizeof(char*), mdp
                                                  );
                        res->cell.m->tofree = free;
                        res->flags |= PGOBLIN_MULAR;
                    }
                    for (n = 0; n < res->ncol; n++) {
                        const u_char *t;
                        char *tt;

                        if  (sqlite3_column_type(conn->vm, n) == SQLITE_NULL) {
                            *(char**)(mular_add(res->cell.m)) = NULL;
                        } else if ((t = sqlite3_column_text(conn->vm, n)) && (tt = strdup((char*)t))) {
                            *(char**)(mular_add(res->cell.m)) = tt;
                        } else {
                            ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no mem #7");
                            ERROUT(EX_OSERR, ENOMEM);
                    }   }
                    res->nrow++;
                    continue;
                }
                if  (ex == SQLITE_DONE) ex = 0;
                break;
            }
            if  (ex) {
                ifBLIN_QV1(db->flags) warnx("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
                if  (conn->vm) {
                    ex = sqlite3_finalize(conn->vm);
                    ERRMSG("sqlite3_finalize", EX_SOFTWARE);
                }
                ERROUT(EX_SOFTWARE, oxdecode(ex));
            }
            ex = sqlite3_finalize(conn->vm);
            ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        }
        if  (!res->ncol) {
            ifBLIN_QV1(db->flags)
                warnx("sqlite3_get_table waits for PGOBLIN_CR_TUPL but received no tuples");
            ERROUT(EX_SOFTWARE, ENODEV);
        }
        break;
    case PGOBLIN_CR_BSEL:
    default:
        ifBLIN_QV1(db->flags) warnx("doquery sqlite3 illegal cond=%d", cond);
        ex = -1;
    }
out:
    if  (rs) *rs = res; else if (res) finish(db->flags, PGOBLIN_CleaRes, (void **)&res);
    ifBLIN_QV5(db->flags) fprintf(stderr, "doquery sqlite3 %d\n", ex);
    return(ex);
}

static int
prepare(pgoblin_conn *db, void **rsv, const char *query) {
    pgoblin_db_conn *conn = db->conn;
    sqlite3_stmt *vm;
    int ex = 0;

    ifBLIN_QV5(db->flags) fprintf(stderr, "prepare sqlite3 =%s~\n", query);
    if  (conn->flags) {
        ifBLIN_QV1(db->flags) warnx("prepare sqlite3: COPY state");
        ERROUT(EX_DATAERR, ENODEV);
    }
    vm = NULL;
    if  (!query || !*query) goto out;
    ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#4 =%s~\n", query);
    ex = sqlite3_prepare_v2(conn->odf, query, -1, &vm, NULL);
    ERRMSG("sqlite3_prepare_v2#4", EX_SOFTWARE);
out:
    *rsv = vm;
    ifBLIN_QV5(db->flags) fprintf(stderr, "prepare sqlite3 %d\n", ex);
    return(ex);
}

static int
execute( pgoblin_conn *db
       , void **rsv
       , const void *qp, int cnt, const char * const *val, const int *len
       , u_char cond
       ) {
    pgoblin_db_conn *conn = db->conn;
    pgoblin_db_data *res;
    const char *query;
    sqlite3_stmt *vm;
    int n, ex = 0;
    int i;

    if  (conn->flags) {
        ifBLIN_QV1(db->flags) warnx("execute sqlite3: COPY state");
        ERROUT(EX_DATAERR, ENODEV);
    }
    if  (cond & PGOBLIN_ALTERQ) {
        ifBLIN_QV5(db->flags) fprintf(stderr, "execute sqlite3 %d\n", cond);
        vm = (sqlite3_stmt *)qp;
    } else {
        query = (char *)qp;
        if  (!query || !*query) goto out;
        ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#4 %d=%s~\n", cond, query);
        ex = sqlite3_prepare_v2(conn->odf, query, -1, &vm, NULL);
        ERRMSG("sqlite3_prepare_v2#4", EX_SOFTWARE);
    }
    if  (!vm) goto out;
    res = NULL;
    for (i = 0; i < cnt; i++) {
        ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_bind_text#3 [%d]%d=%s~\n", i, len[i], val[i]);
        /* SQLITE_STATIC should be used in most cases instead SQLITE_TRANSIENT XXXX */
        ex = sqlite3_bind_text(vm, i + 1, val[i], len[i], SQLITE_TRANSIENT);
        ERRMSG("sqlite3_bind_text#3", EX_SOFTWARE);
    }
    switch (cond & ~PGOBLIN_ALTERQ) {
    case PGOBLIN_CR_OK:
        n = sqlite3_column_count(vm);
        if  (n) {
            ifBLIN_QV2(db->flags) warnx("wait for PGOBLIN_CR_OK but received %d cols", n);
        }
        for (;;) {
            ex = sqlite3_step(vm);
            if  (ex == SQLITE_ROW) continue;
            if  (ex == SQLITE_DONE) ex = 0;
            ERRMSG("sqlite3_step#2", EX_SOFTWARE);
            break;
        }
        if  (ex) {
            ifBLIN_QV1(db->flags) warnx("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
            if  (vm) {
                ex = sqlite3_finalize(vm);
                ERRMSG("sqlite3_finalize", EX_SOFTWARE);
            }
            ERROUT(EX_SOFTWARE, oxdecode(ex));
        }
        if  (cond & PGOBLIN_ALTERQ) {
            ex = sqlite3_reset(vm);
            ERRMSG("sqlite3_reset", EX_SOFTWARE);
        } else {
            ex = sqlite3_finalize(vm);
            ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        }
        break;
    case PGOBLIN_CR_TUPL:
        if  (!(res = malloc(sizeof(pgoblin_db_data)))) {
            ifBLIN_QV1(db->flags) warnx("doquery sqlite3: no RAM");
            ERROUT(EX_OSERR, ENOMEM);
        }
        bzero(res, sizeof(pgoblin_db_data));
        res->ncol = sqlite3_column_count(vm);
        for (;;) {
            ex = sqlite3_step(vm);
            ERRMSG("sqlite3_step#3", EX_SOFTWARE);
            if  (!(res->flags & PGOBLIN_TINIT)) {
                res->nrow = 0;
                res->flags |= PGOBLIN_TINIT;
            }
            if  (ex == SQLITE_ROW) {
                ex = 0;
                if  (!(res->flags & PGOBLIN_MULAR)) {
                    res->cell.m = mular_create( MULAR_CHAR | MULAR_ZERO
                                              | MULAR_PFRE | MULAR_STRI | MULAR_UPPE
                                              , 3, sizeof(char*), mdp
                                              );
                    res->cell.m->tofree = free;
                    res->flags |= PGOBLIN_MULAR;
                }
                for (n = 0; n < res->ncol; n++) {
                    const u_char *t;
                    char *tt;

                    if  (sqlite3_column_type(vm, n) == SQLITE_NULL) {
                        *(char**)(mular_add(res->cell.m)) = NULL;
                    } else if ((t = sqlite3_column_text(vm, n)) && (tt = strdup((char*)t))) {
                        *(char**)(mular_add(res->cell.m)) = tt;
                    } else {
                        ifBLIN_QV1(db->flags) warnx("sqlite3 doquery: no mem #7");
                        ERROUT(EX_OSERR, ENOMEM);
                }   }
                res->nrow++;
                continue;
            }
            if  (ex == SQLITE_DONE) ex = 0;
            break;
        }
        if  (ex) {
            ifBLIN_QV1(db->flags) warnx("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
            if  (vm) {
                ex = sqlite3_finalize(vm);
                ERRMSG("sqlite3_finalize", EX_SOFTWARE);
            }
            ERROUT(EX_SOFTWARE, oxdecode(ex));
        }
        if  (cond & PGOBLIN_ALTERQ) {
            ex = sqlite3_reset(vm);
            ERRMSG("sqlite3_reset", EX_SOFTWARE);
        } else {
            ex = sqlite3_finalize(vm);
            ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        }
        if  (!res->ncol) {
            ifBLIN_QV1(db->flags)
                warnx("sqlite3_get_table waits for PGOBLIN_CR_TUPL but received no tuples");
            ERROUT(EX_SOFTWARE, ENODEV);
        }
        break;
    default:
        ifBLIN_QV1(db->flags) warnx("execute sqlite3 illegal cond=%d", cond);
        ex = -1;
    }
out:
    if  (rsv) *rsv = res; else if (res) finish(db->flags, PGOBLIN_CleaRes, (void **)&res);
    ifBLIN_QV5(db->flags) fprintf(stderr, "doquery sqlite3 %d\n", ex);
    return(ex);
}

static int
get(pgoblin_conn *db, u_char ***row, int *n) {
    pgoblin_db_conn *conn = db->conn;
    int ex = 0, i;

    if  (!(conn->flags & PGOBLIN_STREAMI)) {
        ifBLIN_QV1(db->flags) warnx("get sqlite3: not COPYout state");
        ERROUT(-EX_DATAERR, ENODEV);
    }
    for (*n = 0; !*n;) {
        if  (!conn->vm) {
            conn->flags |= PGOBLIN_STREAME;
            break;
        }
        while (!*n) {
            ex = sqlite3_step(conn->vm);
            ERRMSG("sqlite3_step#4", -EX_SOFTWARE);
            *n = sqlite3_column_count(conn->vm);
            if  (*n) conn->flags |= PGOBLIN_STREAMT;
            if  (ex == SQLITE_ROW) {
                ex = 0;
                if  (!(*row = malloc(sizeof(char**) * *n))) {
                    ifBLIN_QV1(db->flags) warnx("sqlite3: no mem #1");
                    ERROUT(EX_OSERR, ENOMEM);
                }
                for (i = 0; i < *n; i++) {
                    const u_char *t;

                    if  (sqlite3_column_type(conn->vm, i) == SQLITE_NULL) {
                        (*row)[i] = NULL;
                    } else if (  !(t = sqlite3_column_text(conn->vm, i))
                              || !((*row)[i] = (u_char*)strdup((char*)t))
                              ) {
                        ifBLIN_QV1(db->flags) warnx("sqlite3: no mem #2");
                        ERROUT(EX_OSERR, ENOMEM);
                }   }
                continue;
            }
            if  (ex == SQLITE_DONE) {
                if  (conn->flags & PGOBLIN_STREAMT) conn->flags |= PGOBLIN_STREAME;
                ex = 0;
            }
            break;
        }
        if  (conn->flags & PGOBLIN_STREAME) break;
        if  (ex) {
            ifBLIN_QV1(db->flags) warnx("sqlite3_step: %d: %s", ex, sqlite3_errmsg(conn->odf));
            if  (conn->vm) {
                ex = sqlite3_finalize(conn->vm);
                ERRMSG("sqlite3_finalize", -EX_SOFTWARE);
            }
            ERROUT(-EX_SOFTWARE, oxdecode(ex));
        }
        if  (!*n && conn->query && *(conn->query)) {
            ex = sqlite3_finalize(conn->vm);
            ERRMSG("sqlite3_finalize", -EX_SOFTWARE);
            ifBLIN_QV5(db->flags) fprintf(stderr, "sqlite3_prepare_v2#7 =%s~\n", conn->query);
            ex = sqlite3_prepare_v2(conn->odf, conn->query, -1, &conn->vm, &conn->query);
            ERRMSG("sqlite3_prepare_v2#7", -EX_SOFTWARE);
    }   }
    if  (!row) conn->flags |= PGOBLIN_STREAME;
out:
    return(ex);
}

static int
getstream(pgoblin_conn *db, void **resv, int quant, u_char cond) {
    pgoblin_db_data **res = (pgoblin_db_data **)resv;
    pgoblin_db_conn *conn = db->conn;
    u_char **row;
    int i, n, ex = EX_OK;

    if  ((ex = get(db, &row, &n))) goto out;
    if  (conn->flags & PGOBLIN_STREAME) {
        if  (!(*res = calloc(1, sizeof(pgoblin_db_data)))) {
            ifBLIN_QV1(db->flags) warnx("getstream sqlite3: no RAM");
            ERROUT(EX_OSERR, ENOMEM);
        }
        (*res)->ncol = n;
        ex = 0;
    } else {
        if  (!(*res = calloc(1, ((n > 0) ? (n - 1) : 0) * sizeof(char*) + sizeof(pgoblin_db_data)))) {
            ifBLIN_QV1(db->flags) warnx("getstream sqlite3: no RAM");
            ERROUT(EX_OSERR, ENOMEM);
        }
        for (i = 0; i < n; i++) if (row[i]) (*res)->cell.a[i] = row[i]; else (*res)->cell.a[i] = NULL;
        (*res)->nrow = 1;
        (*res)->ncol = n;
        free(row);
        row = NULL;
    }
out:
    return(ex);
}

static int
getcopy(pgoblin_conn *db, void **buf) {
    pgoblin_db_conn *conn = db->conn;
    u_char **row;
    int n, ex = 0;

    if  ((ex = get(db, &row, &n))) goto out;
    if  (conn->flags & PGOBLIN_STREAME) {
        *buf = NULL;
        ex = 0;
    } else {
        int i, l;
        u_char *c;

        for (i = 0, l = 0; i < n; i++) if (row[i]) l += strlen((char*)row[i]);
        *buf = malloc(l * 2 + 1);
        for (i = 0; i < n; i++) {
            if  ((c = row[i])) {
                if  (getCGIparmpass3(0, (u_char*)"copy", &c)) {
                    ifBLIN_QV1(db->flags) warnx("sqlite3_getcopy: getCGIparmpass3");
                    ex = -EX_SOFTWARE;
                    goto out;
                }
            } else c = (u_char*)"\\N";
            if  (i) strcat((char*)*buf, (char*)c); else strcpy((char*)*buf, (char*)c);
            if  (row[i] && (c != row[i])) free(c);
            free(row[i]);
            if  (i < n - 1) strcat((char*)*buf, "\t"); else strcat((char*)*buf, "\n");
        }
        free(row);
        ex = strlen(*buf);
    }
out:
    return(ex);
}

static int
endstream(pgoblin_conn *db, u_char cond) {
    pgoblin_db_conn *conn = db->conn;
    int ex = 0;

    switch (cond) {
    case PGOBLIN_CR_SSEL:
    case PGOBLIN_CR_OUT:
        if  (!(conn->flags & PGOBLIN_STREAMI)) {
            ifBLIN_QV1(db->flags) warnx("endstream sqlite3: not stream state");
            ERROUT(-EX_DATAERR, ENODEV);
        }
        ex = sqlite3_finalize(conn->vm);
        conn->flags &= ~PGOBLIN_ALLOUT;
        ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        break;
    case PGOBLIN_CR_IN:
        if  (!(conn->flags & PGOBLIN_COPYIN)) {
            ifBLIN_QV1(db->flags) warnx("endcopy sqlite3: not COPYin state");
            ERROUT(-EX_DATAERR, ENODEV);
        }
        ex = sqlite3_finalize(conn->vm);
        conn->flags &= ~PGOBLIN_ALLIN;
        ERRMSG("sqlite3_finalize", EX_SOFTWARE);
        break;
    default:
        ifBLIN_QV1(db->flags) warnx("endstream sqlite3 %d", cond);
        ex = EX_USAGE;
    }
out:
    conn->flags = 0;
    return(ex);
}

static int
p1info(int kind, void *resv) {
    pgoblin_db_data *res = (pgoblin_db_data *)resv;
    int ex;

    switch (kind) {
    case PGOBLIN_Ntuples: ex = res ? res->nrow : 0; break;
    case PGOBLIN_Nfields: ex = res ? res->ncol : 0; break;
    default             : ex = -1;
    }
    return(ex);
}

static char *
p2info(int kind, void *resv, int sub) {
//  pgoblin_db_data *res = (pgoblin_db_data *)resv;
    char *cx;

    switch (kind) {
    default: cx = NULL;
    }
    return(cx);
}

static int
p3info(int kind, void *resv, int row, int col) {
    pgoblin_db_data *res = (pgoblin_db_data *)resv;
    int ex;

    switch (kind) {
    case PGOBLIN_IsNull:
        if  (res) {
            if  (row >= 0 && row < res->nrow && col >= 0 && col < res->ncol) {
                if  (res->flags & PGOBLIN_MULAR)
                    ex = !*(char**)mular_getix(res->cell.m, INDX(row, col));
                  else ex = !res->cell.a[INDX(row, col)];
            } else {
                ifBLIN_QV2(res->flags)
                    warnx( "db sqlite2 : row %d %s in [0..%d], col %d %s in [0..%d]"
                         , row, (row >= 0 && row < res->nrow) ? "" : "NOT", res->nrow
                         , col, (col >= 0 && col < res->ncol) ? "" : "NOT", res->ncol
                         );
                ex = -1;
            }
        } else if (row == 0 && col == 0) {
            ex = 1;
        } else {
            ifBLIN_QV2(res->flags) warnx( "db sqlite2 : row %d col %d in emty", row, col);
            ex = -1;
        }
        break;
    case PGOBLIN_Length:
        switch (p3info(PGOBLIN_IsNull, res, row, col)) {
        case  1: ex = 0;                           break;
        case  0: if  (res->flags & PGOBLIN_MULAR)
                     ex = strlen(*(char**)mular_getix(res->cell.m, INDX(row, col)));
                   else ex = strlen((char*)res->cell.a[INDX(row, col)]);
                                                   break;
        default: ex = -1;                          break;
        }
        break;
    default: ex = -1;
    }
    return(ex);
}

static char *
value(void *resv, int row, int col) {
    pgoblin_db_data *res = (pgoblin_db_data *)resv;
    char *c = NULL;
    if  (!p3info(PGOBLIN_IsNull, res, row, col)) {
        if  (res->flags & PGOBLIN_MULAR) c = *(char**)mular_getix(res->cell.m, INDX(row, col));
          else c = (char*)res->cell.a[INDX(row, col)];
    }
    return(c);
}

static char *
p_none(pgoblin_conn *db) {
    return(NULL);
}

static int
p_no(pgoblin_conn *db, int timeout) {
    warnx("Unimplemented in sqlite3");
    return(-1);
}

pgoblin_dbases pgoblin_db_sqlite3 =
{ (PGOBLIN_DB_PREPARE | PGOBLIN_DB_COPYIN | PGOBLIN_DB_COPYOUT)
, "3pGoblin-" VERS
, "sqlite3\0" VERS
, initm       /* init      */
, finim       /* fini      */
, shurecon    /* shurecon  */
, doquery     /* query     */
, prepare     /* prepare   */
, execute     /* execute   */
, p1info      /* resinfo   */
, p2info      /* subinfo   */
, p3info      /* valinfo   */
, value       /* getvalue  */
, getstream   /* getstream */
, getcopy     /* getcopy   */
, putcopy     /* putcopy   */
, endstream   /* endstream */
, p_no        /* tarry     */
, p_none      /* notifies  */
, finish      /* finish    */
};
