/*-
 * Copyright (C) @BABOLO  2008 Apr 14
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2008 Apr 14\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: db_0.c,v 1.23 2009/11/04 19:09:23 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <mife.h>
#include <err.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include "pgoblin.h"
#include "pgob.h"

#define INDX(R, C) [R * res->ncol + C]  /*        */

                                                                          /* Pc  db_0  NULL */
typedef struct pgoblin_db_0_data {                                                   /*  Pq */
    char    **cell;                                 /*       */
    size_t   *llen;      /*                          *
                          *  ,      strlen() */
    u_int32_t flags;
#   define    PGOBLIN_DB_0FREEC 0x0001                           /*     free() */
#   define    PGOBLIN_DB_0FREEA 0x0002                                           /* cell  free() */
    int       nrow;                                                    /*     */
    int       ncol;                                                  /*     */
} pgoblin_db_0_data;

static int
finit(u_int32_t flags, pgoblin_dbases *this) {
    return(0);
}

static int
p_no() {
    warnx("Unimplemented in 0");
    errno = ENOTSUP;
    return(-1);
}

static int
shurecon(pgoblin_conn *db) {
    int ex = EX_OK;

    if  (!db) {
        ex = EX_DATAERR;
        errno = EINVAL;
    } else {
        MARK_R_CONN_GO(0);;
        ;;  db->conn = NULL;                                                              /* Pc  */
        MARK_R_CONN_WENT(0);;
    }
    ifBLIN_QV5(db->flags) fprintf( stderr, "db_0 shurecon %d\n", ex);
    return(ex);
}

static int  /*  #select      NULL,    query "rows cols" */
doquery(pgoblin_conn *db, void **res, const char *query, u_char cond) {
    pgoblin_db_0_data *db0;
    int ex = EX_OK;
    char *q;

    if  (!db) {
        errno = EFAULT;
        ex = EX_DATAERR;
    } else if (res) {
        if  (!(db0 = malloc(sizeof(pgoblin_db_0_data)))) {
            ifBLIN_QV1(*(u_int32_t*)(db->conn)) warnx("db_0 doquery: No mem");
            errno = ENOMEM;
            ex = EX_OSERR;
        } else {
            bzero(db0, sizeof(pgoblin_db_0_data));
            db0->flags = db->flags & BLIN_VERMASK;
            if  (query) {
                db0->nrow = strtoul(query, &q, 0);
                db0->ncol = strtoul(q, &q, 0);
            }
            *res = db0;
    }   }
    ifBLIN_QV5(db->flags) fprintf( stderr, "db_0 doquery %d\n", ex);
    return(ex);
}

static int
execute( pgoblin_conn *db
       , void **res
       , const void *qp, int cnt, const char * const *val, const int *len
       , u_char cond
       ) {
    pgoblin_db_0_data *db0 = NULL;
    int i, ex = EX_OK;

    if  (!res) {
        ifBLIN_QV1(db->flags) warnx("db_0 execute: No res");
        errno = EFAULT;
        ex = EX_DATAERR;
    } else if (!(db0 = calloc(1, sizeof(pgoblin_db_0_data)))) {
        ifBLIN_QV1(db->flags) warnx("db_0 execute #1: No mem");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else  if (!(db0->llen = malloc(cnt * sizeof(char**)))) {
        free(db0);
        ifBLIN_QV1(db->flags) warnx("db_0 execute #2: No mem");
        errno = ENOMEM;
        ex = EX_OSERR;
    } else {
        db0->flags = db->flags & BLIN_VERMASK;
        db0->nrow = 1;
        db0->ncol = cnt;
        db0->cell = (char **)val;
        for (i = 0; i < cnt; i++) if (!len || (len[i] < 0)) db0->llen[i] = strlen(val[i]);
    }
    *res = ex ? NULL : db0;
    return(ex);
}

static int
p1info(int kind, void *resv) {
    pgoblin_db_0_data *res = (pgoblin_db_0_data *)resv;
    int ex;

    switch (kind) {
    case PGOBLIN_Ntuples:
        if  (!res) {
            errno = EFAULT;
            ex = -1;
        } else {
            ex = res->nrow;
        }
        break;
    case PGOBLIN_Nfields:
        if  (!res) {
            errno = EFAULT;
            ex = -1;
        } else {
            ex = res->ncol;
        }
        break;
    default:
        ex = -1;
    }
    return(ex);
}

static char *
p2info(int kind, void *resv, int sub) {
//  pgoblin_db_0_data *res = (pgoblin_db_0_data *)resv;
    char *cx;

    switch (kind) {
    default: cx = NULL;
    }
    return(cx);
}

static int
p3info(int kind, void *resv, int row, int col) {
    pgoblin_db_0_data *res = (pgoblin_db_0_data *)resv;
    int ex;

    switch (kind) {
    case PGOBLIN_IsNull:
        if  (!res) {
            warnx("No res in local isnull\n");
            ex = (row || col) ? -1 : 0;
        } else if (!res->cell) {
            ex = 1;
        } else if (row >= 0 && row < res->nrow && col >= 0 && col < res->ncol) {
            ex = !res->cell INDX(row, col);
        } else {
            ifBLIN_QV2(res->flags) {
                warnx( "db 0: row %d%s in [0..%d], col %d%s in [0..%d]"
                     , row, (row >= 0 && row < res->nrow) ? "" : " NOT", res->nrow
                     , col, (col >= 0 && col < res->ncol) ? "" : " NOT", res->ncol
                     );
            }
            ex = -1;
        }
        break;
    case PGOBLIN_Length:
        if  ((ex = p3info(PGOBLIN_IsNull, res, row, col)) < 0) {
        } else if (ex) {
            ex = 0;
        } else if (res->llen) {
            ex = res->llen INDX(row, col);
        } else if (res->cell) {
            ex = strlen(res->cell INDX(row, col));
        }
        break;
    default: ex = -1;
    }
    return(ex);
}

static char *
value(void *resv, int row, int col) {
    pgoblin_db_0_data *res = (pgoblin_db_0_data *)resv;
    char *c = NULL;

    if  (!p3info(PGOBLIN_IsNull, res, row, col)) c = res->cell INDX(row, col);
    return(c);
}

static char*
p_none(pgoblin_conn *db) {
    return(NULL);
}

static int
finish(u_int32_t flags, int kind, void **entity) {
    int ex = EX_OK;

    switch (kind) {
    case PGOBLIN_Connect: {
            void **conn = entity;

            if  (conn) *conn = NULL;
        }
        break;
    case PGOBLIN_PFormed:
    case PGOBLIN_FrCOPY:
    case PGOBLIN_FrNote:
        break;
    case PGOBLIN_CleaRes: {
            pgoblin_db_0_data **res = (pgoblin_db_0_data **)entity;
            int i;

            if  (res && *res) {
                ifBLIN_QV5(flags) fprintf(stderr, "db_0 PGOBLIN_CleaRes\n");
                if  ((*res)->llen) {
                    free((*res)->llen);
                    (*res)->llen = NULL;
                }
                if  ((*res)->cell) {
                    if  ((*res)->flags & PGOBLIN_DB_0FREEC) {
                        for (i = 0; i < (*res)->nrow * (*res)->ncol; i++) {
                            free((*res)->cell[i]);
                            (*res)->cell[i] = NULL;
                    }   }
                    if  ((*res)->flags & PGOBLIN_DB_0FREEA) {
                        free((*res)->cell);
                        (*res)->cell = NULL;
                }   }
                free(*res);
                *res = NULL;
        }   }
        break;
    default:
        ex = EX_UNAVAILABLE;
        errno = ENOTSUP;
    }
    return(ex);
}

static int
tarry(pgoblin_conn *db, int timeout) {
    return(0);
}

pgoblin_dbases pgoblin_db_0 =
{ 0
, "3pGoblin-" VERS
, "0\0" VERS
,                                              finit     /* init      */
,                                              finit     /* fini      */
,                                              shurecon  /* shurecon  */
,                                              doquery   /* query     */
, (int  (*)(pgoblin_conn*,void**,const char*)) p_no      /* prepare   */
,                                              execute   /* execute   */
,                                              p1info    /* resinfo   */
,                                              p2info    /* subinfo   */
,                                              p3info    /* valinfo   */
,                                              value     /* getvalue  */
, (int  (*)(pgoblin_conn*,void**,int,u_char))  p_no      /* getstream */
, (int  (*)(pgoblin_conn*,void**))             p_no      /* getcopy   */
, (int  (*)(pgoblin_conn*,const void*,int))    p_no      /* putcopy   */
, (int  (*)(pgoblin_conn*,u_char))             p_no      /* endstream */
,                                              tarry     /* tarry     */
,                                              p_none    /* notifies  */
,                                              finish    /* finish    */
};
