/*-
 * Copyright (C) @BABOLO  2002 Dec 17
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 17\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_select.c,v 1.42 2009/11/17 07:04:23 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <mife.h>
#include <err.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include "pgoblin.h"
#include "pgob.h"

int
pgoblin_perform(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK, i, j, row, col, *len;
    const char **val;
    void *n, *res;

    ifBLIN_QV4(exenv->options->flags)
        fprintf( stderr, "+pgoblin_perform %d %d %d", r[PGO_CCTL].r, r[PGO_CIN].r, r[PGO_CCON].r);
    ifBLIN_QV4(exenv->options->flags) {
        if (IO_CTL->text) fprintf(stderr, " =%s\n", (char*)IO_CTL->text); else fprintf(stderr, "\n");
    }
    if  (r[PGO_CIN].r && IO_IN->pq) {
        if  (IO_CTL->text) {
        } else if (!IO_CTL->pq) {
            ifBLIN_QV1(exenv->options->flags) warnx("perform: No query #1");
            ERROUT(EX_NOINPUT, EINVAL);
        } else {
            /*
             *   IO_CTL Pq,  IO_IN Pq,       
             * ,    IO_CTL Pq Pt  q     IO_IN Pq.
             */
            if  ((ex = pgoblin_style_0.table(IO_CTL, exenv->options->style, IO_CTL, 0, -2)) < 0) {
                ifBLIN_QV1(exenv->options->flags) warn("perform: No STYLE 0 #1");
                goto out;
        }   }
        if  (  !(col = DBASE(IO_IN->flagc)->resinfo(PGOBLIN_Nfields, IO_IN->pq))
            || !(row = DBASE(IO_IN->flagc)->resinfo(PGOBLIN_Ntuples, IO_IN->pq))
            ) goto out;
        ifBLIN_QV5(exenv->options->flags) fprintf(stderr, "%d rows x %d cols\n", row, col);
        if  (!(val = malloc(sizeof(char *) * col))) {
            ifBLIN_QV1(exenv->options->flags) warnx("perform: No mem #1");
            ERROUT(EX_OSERR, ENOMEM);
        }
        if  (!(len = malloc(sizeof(int) * col))) {
            ifBLIN_QV1(exenv->options->flags) warnx("perform: No mem #2");
            ERROUT(EX_OSERR, ENOMEM);
        }
        if  (DBASE(R_CONN->flags)->flags & PGOBLIN_DB_PREPARE) {
            if  ((ex = DBASE(R_CONN->flags)->prepare(R_CONN, &n, IO_CTL->text))) {
                ifBLIN_QV1(exenv->options->flags) {
                    char *c = DBASE(R_CONN->flags)->subinfo(PGOBLIN_ResMess, res, R_CONN->flags);

                    warnx("perform: prepare\n%s", c);
                    DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_FrMess, (void**)&c);
                }
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            for (i = 0; i < row; i++) {
                for (j = 0; j < col; j++) {
                    val[j] = DBASE(IO_IN->flagc)->getvalue(IO_IN->pq, i, j);
                    len[j] = DBASE(IO_IN->flagc)->valinfo(PGOBLIN_Length, IO_IN->pq, i, j);
                }
                ex = DBASE(R_CONN->flags)->
                         execute(R_CONN, &res, n, col, val, len, PGOBLIN_CR_OK | PGOBLIN_ALTERQ);
                if  (ex) {
                    ifBLIN_QV1(exenv->options->flags) {
                        char *c = DBASE(R_CONN->flags)->subinfo(PGOBLIN_ResMess, res, R_CONN->flags);

                        warnx("perform: execute Q\n%s", c);
                        DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_FrMess, (void**)&c);
                    }
                    ERROUT(EX_SOFTWARE, EDOOFUS);
            }   }
            DBASE(R_CONN->flags)->finish(exenv->options->flags, PGOBLIN_PFormed, &n);
        } else {
            for (i = 0; i < row; i++) {
                for (j = 0; j < col; j++) {
                    val[j] = DBASE(IO_IN->flagc)->getvalue(IO_IN->pq, i, j);
                    len[j] = DBASE(IO_IN->flagc)->valinfo(PGOBLIN_Length, IO_IN->pq, i, j);
                }
                ex = DBASE(R_CONN->flags)->
                         execute(R_CONN, &res, IO_CTL->text, col, val, len, PGOBLIN_CR_OK);
                if  (ex) {
                    ifBLIN_QV1(exenv->options->flags) {
                        char *f = DBASE(R_CONN->flags)->subinfo( PGOBLIN_ResMess
                                                               , res
                                                               , exenv->options->flags
                                                               );
                        warnx("perform: execute: %s", f);
                        DBASE(R_CONN->flags)->finish( exenv->options->flags
                                                    , PGOBLIN_FrNote
                                                    , (void**)&f
                                                    );
                    }
                    ERROUT(EX_SOFTWARE, EDOOFUS);
        }   }   }
        free(val);
        free(len);
    } else if (IO_CTL->text) {
        if  ((ex = DBASE(R_CONN->flags)->query(R_CONN, &res, IO_CTL->text, PGOBLIN_CR_OK))) {
            ifBLIN_QV1(exenv->options->flags) {
                char *f = DBASE(R_CONN->flags)->subinfo( PGOBLIN_ResMess
                                                       , res
                                                       , exenv->options->flags
                                                       );
                warnx("perform: query #1: %s", f);
                DBASE(R_CONN->flags)->finish(exenv->options->flags, PGOBLIN_FrNote, (void**)&f);
            }
            ERROUT(EX_SOFTWARE, EDOOFUS);
        }
        DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &res);
    } else if (!IO_CTL->pq) {
        ifBLIN_QV1(exenv->options->flags) warnx("perform: No query #2");
        ERROUT(EX_NOINPUT, EINVAL);
    } else {
        ssize_t k;

        for (k = 0; k < DBASE(IO_CTL->flagc)->resinfo(PGOBLIN_Ntuples, IO_CTL->pq); k++) {
            if  ((ex = pgoblin_style_0.table(IO_CTL, exenv->options->style, IO_CTL, k, -3)) < 0) {
                ifBLIN_QV1(exenv->options->flags) warn("perform: No STYLE 0 #2");
                goto out;
            }
            if  ((ex = DBASE(R_CONN->flags)->query(R_CONN, &res, IO_CTL->text, PGOBLIN_CR_OK))) {
                ifBLIN_QV1(exenv->options->flags) {
                    char *f = DBASE(R_CONN->flags)->subinfo( PGOBLIN_ResMess
                                                           , res
                                                           , exenv->options->flags
                                                           );
                    warnx("perform: query #2: %s", f);
                    DBASE(R_CONN->flags)->finish(exenv->options->flags, PGOBLIN_FrNote, (void**)&f);
                }
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &res);
    }   }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_perform %d\n", ex);
    return(ex);
}

int
pgoblin_select(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK, i, j, row, col, *len;
    const char **val;
    void *n;

    ifBLIN_QV4(exenv->options->flags)
        fprintf( stderr, "+pgoblin_select %d %d %d %d =%s~\n"
               , r[PGO_COUT].r, r[PGO_CCTL].r, r[PGO_CIN].r, r[PGO_CCON].r
               , (char*)IO_CTL->text
               );
    if  (!IO_CTL->text) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_select: No query");
        ex = EX_NOINPUT;
        errno = EINVAL;
    } else if (r[PGO_CIN].r && IO_IN->pq) {
        if  (  !(col = DBASE(IO_IN->flagc)->resinfo(PGOBLIN_Nfields, IO_IN->pq))
            || !(row = DBASE(IO_IN->flagc)->resinfo(PGOBLIN_Ntuples, IO_IN->pq))
            ) goto out;
        if  (!(val = malloc(sizeof(char *) * col * row))) {
            ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_select #1: No mem");
            ERROUT(EX_OSERR, ENOMEM);
        }
        if  (!(len = malloc(sizeof(int) * col * row))) {
            ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_select #2: No mem");
            ERROUT(EX_OSERR, ENOMEM);
        }
        if  (DBASE(R_CONN->flags)->flags & PGOBLIN_DB_PREPARE) {
            if  ((ex = DBASE(R_CONN->flags)->prepare(R_CONN, (void**)&n, IO_CTL->text))) {
                ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_select: prepare");
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            for (i = 0; i < row; i++) {
                for (j = 0; j < col; j++) {
                    val[i * col + j] = DBASE(IO_IN->flagc)->getvalue(IO_IN->pq, i, j);
                    len[i * col + j] = DBASE(IO_IN->flagc)->valinfo(PGOBLIN_Length, IO_IN->pq, i, j);
            }   }
            MARK_IO_PQ_GO(IO_OUT);;
            ;;  ex = DBASE(R_CONN->flags)->execute( R_CONN
        /*  ;;  */                                , &IO_OUT->pq
        /*  ;;  */                                , n, col * row, val, len
        /*  ;;  */                                , PGOBLIN_CR_TUPL | PGOBLIN_ALTERQ
        /*  ;;  */                                );
            ;;  IO_OUT->flagc = IO_OUT->pq ? R_CONN->flags : 0;
            ;;  if  (IO_OUT->pq) IO_OUT->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
            MARK_IO_PQ_WENT(IO_OUT);;
            if  (ex) {
                ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_select: execute Q");
                ERROUT(EX_SOFTWARE, EDOOFUS);
            }
            DBASE(R_CONN->flags)->finish(exenv->options->flags, PGOBLIN_PFormed, &n);
        } else {
            for (i = 0; i < row; i++) {
                for (j = 0; j < col; j++) {
                    val[i * col + j] = DBASE(IO_IN->flagc)->getvalue(IO_IN->pq, i, j);
                    len[i * col + j] = DBASE(IO_IN->flagc)->valinfo(PGOBLIN_Length, IO_IN->pq, i, j);
            }   }
            MARK_IO_PQ_GO(IO_OUT);;
            ;;  ex = DBASE(R_CONN->flags)->execute( R_CONN
        /*  ;;  */                                , &IO_OUT->pq
        /*  ;;  */                                , IO_CTL->text
        /*  ;;  */                                , col * row, val, len
        /*  ;;  */                                , PGOBLIN_CR_TUPL
        /*  ;;  */                                );
            ;;  IO_OUT->flagc = IO_OUT->pq ? R_CONN->flags : 0;
            ;;  if  (IO_OUT->pq) IO_OUT->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
            MARK_IO_PQ_WENT(IO_OUT);;
            if  (ex) {
                ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_select: execute");
                ERROUT(EX_SOFTWARE, EDOOFUS);
        }   }
        free(val);
        free(len);
    } else {
        MARK_IO_PQ_GO(IO_OUT);;
        ;;  ex = DBASE(R_CONN->flags)->query(R_CONN, &IO_OUT->pq, IO_CTL->text, PGOBLIN_CR_TUPL);
        ;;  IO_OUT->flagc = IO_OUT->pq ? R_CONN->flags : 0;
        ;;  if  (IO_OUT->pq) IO_OUT->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
        MARK_IO_PQ_WENT(IO_OUT);;
        if  (ex) {
            ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_select: query");
            ERROUT(EX_SOFTWARE, EDOOFUS);
    }   }
out:
    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "-pgoblin_select %s\n", IO_OUT->pq ? "OK" : "NULL");
    return(ex);
}

int
pgoblin_display(pgoblin_exenv *exenv, pgoblin_r *r) {
    ssize_t ex;

    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "+pgoblin_display %d %d %d\n", r[PGO_COUT].r, r[PGO_CSTY].r, r[PGO_CIN].r);
    ex = STYLS(R_STYLE->flags)->table(IO_OUT, R_STYLE, IO_IN, 0, -2);
    if  (ex < 0) ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_display: write error");
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_display %d\n", (int)ex);
    return((ex < 0) ? ex : 0);
}

static int
sel(pgoblin_exenv *exenv, pgoblin_r *r, int cond) {
    ssize_t k, e = 0, ex = 0;
    pgoblin_io tr;
    size_t i;
#   define aim  (INT_MAX / 2)
#   define aid                                                                                        \
    ((PGOBLIN_BUFMULT * PGOBLIN_BUFSIZE > (aim / 4)) ? (aim / 4) : (PGOBLIN_BUFMULT * PGOBLIN_BUFSIZE))

    ifBLIN_QV4(exenv->options->flags)
        fprintf( stderr, "+%s %d %d %d %d =%s~\n"
               , (cond == PGOBLIN_CR_SSEL)
               ? "pgoblin_strsel"
               : (cond == PGOBLIN_CR_BSEL) ? "pgoblin_binsel" : "pgoblin_???sel"
               , r[PGO_COUT].r, r[PGO_CCTL].r, r[PGO_CCON].r, r[PGO_CSTY].r
               , (char*)IO_CTL->text
               );
    if  (!IO_CTL->text) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_strsel: No query");
        ERROUT(EX_DATAERR, EINVAL);
    }
    tr.flagc = R_CONN->flags;
    if  ((ex = DBASE(R_CONN->flags)->query(R_CONN, &tr.pq, (char*)IO_CTL->text, cond))) goto out;
    for (k = 0, i = 1; ; ) {
        int typn;

        if  ((ex = DBASE(R_CONN->flags)->getstream(R_CONN, &tr.pq, i, cond))) goto out;
        typn = DBASE(R_CONN->flags)->resinfo(PGOBLIN_Ntuples, tr.pq);
        e = STYLS(R_STYLE->flags)->table(IO_OUT, R_STYLE, &tr, k, typn ? -1 : -2);
        if  ((e < 0) || (typn <= 0)) break;
        k += typn;
        DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &tr.pq);
        ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "e=%d=>%d aim=%d i %d => ", typn, (int)e, aim, (int)i);
        if  (e < (aim * 2)) {
            if  (i < (aid / 2)) i = i * 2; else i = aid;
        } else if (e < aim) {
            if  (i < (aid / aim * e)) i = i / e * aim; else i = aid;
        } else if ((e / 2) > aim) {
            i = i / 4;
        } else if (e > aim) {
            i = i / e * aim;
        }
        ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "%d\n", (int)i);
    }
    DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &tr.pq);
    if  (e < 0) ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_strsel: write error");
out:
/* END      ? */
    ex = DBASE(R_CONN->flags)->endstream(R_CONN, cond);
    ifBLIN_QV4(exenv->options->flags)
        fprintf( stderr, "-%s %d\n"
               , (cond == PGOBLIN_CR_SSEL)
               ? "pgoblin_strsel"
               : (cond == PGOBLIN_CR_BSEL) ? "pgoblin_binsel" : "pgoblin_???sel"
               , (e < 0) ? e : ex
               );
    return((e < 0) ? e : ex);
}

int
pgoblin_strsel(pgoblin_exenv *exenv, pgoblin_r *r) {
    return(sel(exenv, r, PGOBLIN_CR_SSEL));
}

int
pgoblin_binsel(pgoblin_exenv *exenv, pgoblin_r *r) {
    return(sel(exenv, r, PGOBLIN_CR_BSEL));
}

int
pgoblin_binpre(pgoblin_exenv *exenv, pgoblin_r *r) {
    void *res;
    int ex = EX_OK;
    char *q;
#   define CMD1 "BEGIN"
#   define CMD2 "DECLARE pgoblin BINARY NO SCROLL CURSOR FOR %s"
#   define CMD3 "FETCH 2147483647 FROM pgoblin"
#   define CMD4 "CLOSE pgoblin"
#   define CMD5 "END"

    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "+pgoblin_binpre %d %d %d =%s~\n"
                                      , r[PGO_COUT].r, r[PGO_CCTL].r, r[PGO_CCON].r
                                      , (char*)IO_CTL->text
                                      );
    if  (!IO_CTL->text) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_binpre: No query");
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!R_CONN->intran && (ex = DBASE(R_CONN->flags)->query(R_CONN, &res, CMD1, PGOBLIN_CR_OK)))
        goto out;
    asprintf(&q, CMD2, (char*)IO_CTL->text);
    if  (q == NULL) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_binpre: No memory");
        ERROUT(EX_OSERR, ENOMEM);
    }
    ex = DBASE(R_CONN->flags)->query(R_CONN, &res, q, PGOBLIN_CR_OK);
    DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &res);
    free(q);
    if  (ex) goto out;
    MARK_IO_PQ_GO(IO_OUT);;
    ;;  ex = DBASE(R_CONN->flags)->query(R_CONN, &IO_OUT->pq, CMD3, PGOBLIN_CR_TUPL);
    ;;  IO_OUT->flagc = IO_OUT->pq ? R_CONN->flags : 0;
    ;;  if  (IO_OUT->pq) IO_OUT->flags |= PGOBLIN_PQRESULT | PGOBLIN_FREEPQRE;
    MARK_IO_PQ_WENT(IO_OUT);;
    ex = DBASE(R_CONN->flags)->query(R_CONN, &res, CMD4, PGOBLIN_CR_OK);
    DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &res);
out:
    if  (!R_CONN->intran) ex = DBASE(R_CONN->flags)->query(R_CONN, &res, CMD5, PGOBLIN_CR_OK);
    DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &res);
    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "-pgoblin_binpre %d\n", 0);
    return(ex);
}
