/*-
 * Copyright (C) @BABOLO  2004 Nov 18
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2004 Nov 18\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_file.c,v 1.41 2009/11/17 09:04:40 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <errno.h>
#include <stdio.h>
#include <getCGIparm.h>
#include <mife.h>
#include <fts.h>
#include <err.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include "pgoblin.h"
#include "pgob.h"

int
pgoblin_echo(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "+pgoblin_echo %d %d %d\n", r[PGO_COUT].r, r[PGO_CCTL].r, r[PGO_CSTY].r);
    if  (!IO_CTL->text) {
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (r[PGO_CSTY].r) {
        u_char *tmpc;
        char *tmpo;
        int tfree;

        if  (IO_CTL->flags & PGOBLIN_BINPARM) {
            if  (!(tmpc = malloc(IO_CTL->length + 1))) {
                ifBLIN_QV4(exenv->options->flags) warnx("No mem #echo #1");
                ERROUT(EX_OSERR, ENOMEM);
            }
            bcopy(IO_CTL->text, tmpc, IO_CTL->length);
            tmpc[IO_CTL->length] = '\0';
            tfree = 1;
        } else {
            tmpc = IO_CTL->text;
            tfree = 0;
        }
        tmpo = STYLS(R_STYLE->flags)->get(R_STYLE, tmpc);
        if  (tmpo) {
            MARK_IO_TEXT_GO(IO_OUT);;
            ;;  IO_OUT->text = tmpo;
            ;;  IO_OUT->length = strlen(IO_OUT->text);
            ;;  IO_OUT->flags &= ~PGOBLIN_BINPARM;
            ;;  IO_OUT->flags |= PGOBLIN_TEXTPARM | PGOBLIN_FREETEXT;
            MARK_IO_TEXT_WENT(IO_OUT);;
        } else {
            MARK_IO_TEXT_GO(IO_OUT);;
            ;;  IO_OUT->text = NULL;
            ;;  IO_OUT->length = 0;
            ;;  IO_OUT->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_BINPARM | PGOBLIN_TEXTPARM);
            MARK_IO_TEXT_WENT(IO_OUT);;
            ifBLIN_QV2(exenv->options->flags) warnx("No const %s", tmpc);
        }
        if  (tfree) free(tmpc);
    } else if (r[PGO_COUT].r != r[PGO_CCTL].r) {
        if  (!(IO_CTL->flags & PGOBLIN_FREETEXT)) {
            MARK_IO_TEXT_GO(IO_OUT);;
            ;;  IO_OUT->text = IO_CTL->text;
            ;;  IO_OUT->length = IO_CTL->length;
            ;;  IO_OUT->flags &= ~(PGOBLIN_FREETEXT | PGOBLIN_BINPARM);
            ;;  IO_OUT->flags |= PGOBLIN_TEXTPARM | (IO_CTL->flags & PGOBLIN_BINPARM);
            MARK_IO_TEXT_WENT(IO_OUT);;
        } else {
            MARK_IO_TEXT_GO(IO_OUT);;
            ;;  if  (!(IO_OUT->text = malloc(IO_CTL->length + 1))) {
            ;;      ifBLIN_QV1(exenv->options->flags) warnx("No mem #echo #2");
            ;;      ERROUT(EX_OSERR, ENOMEM);
            ;;  } else {
            ;;      IO_OUT->length = IO_CTL->length;
            ;;      bcopy(IO_CTL->text, IO_OUT->text, IO_CTL->length);
            ;;      ((u_char*)IO_OUT->text)[IO_OUT->length] = '\0'
            ;;      IO_OUT->flags &= ~PGOBLIN_BINPARM;
            ;;      IO_OUT->flags |= PGOBLIN_TEXTPARM | PGOBLIN_FREETEXT;
            ;;  }
            MARK_IO_TEXT_WENT(IO_OUT);;
    }   }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_echo %d\n", ex);
    return(ex);
}

int
pgoblin_file(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "+pgoblin_file %d %d %d\n", r[PGO_COUT].r, r[PGO_CCTL].r, r[PGO_CSTY].r);
    if  (!IO_CTL->text) {
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (r[PGO_CSTY].r) {
        if  (IO_CTL->flags & PGOBLIN_BINPARM) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        MARK_IO_PATH_GO(IO_OUT);;
        ;;  IO_OUT->path = STYLS(R_STYLE->flags)->get(R_STYLE, IO_CTL->text);
        ;;  if  (IO_OUT->path) {
        ;;      IO_OUT->flags |= PGOBLIN_FILEOVER | PGOBLIN_PATHPARM | PGOBLIN_FREEPATH;
        ;;  } else {
        ;;      IO_OUT->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        ;;      ERROUT(EX_DATAERR, EINVAL);
        ;;  }
        MARK_IO_PATH_WENT(IO_OUT);;
    } else if (IO_CTL->flags & PGOBLIN_FREETEXT) {
        MARK_IO_PATH_GO(IO_OUT);;
        ;;  if  (!(IO_OUT->path = strdup(IO_CTL->text))) {
        ;;      ifBLIN_QV1(exenv->options->flags) warnx("No mem #file");
        ;;      ERROUT(EX_OSERR, ENOMEM);
        ;;  } else {
        ;;      IO_OUT->flags |= PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM;
        ;;  }
        MARK_IO_PATH_WENT(IO_OUT);;
    } else {
        MARK_IO_PATH_GO(IO_OUT);;
        ;;  IO_OUT->path = IO_CTL->text;
        ;;  IO_OUT->flags &= ~PGOBLIN_FREEPATH;
        ;;  IO_OUT->flags |= PGOBLIN_FILEOVER | PGOBLIN_PATHPARM;
        MARK_IO_PATH_WENT(IO_OUT);;
    }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_file\n");
    return(ex);
}

int
pgoblin_cat(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "+pgoblin_cat %d %d %d\n", r[PGO_COUT].r, r[PGO_CCTL].r, r[PGO_CSTY].r);
    if  (!IO_CTL->text) {
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (r[PGO_CSTY].r) {
        if  (IO_CTL->flags & PGOBLIN_BINPARM) {
            ERROUT(EX_DATAERR, EINVAL);
        }
        MARK_IO_PATH_GO(IO_OUT);;
        ;;  IO_OUT->path = STYLS(R_STYLE->flags)->get(R_STYLE, IO_CTL->text);
        ;;  if  (IO_OUT->path) {
        ;;      IO_OUT->flags &= ~PGOBLIN_FILEOVER;
        ;;      IO_OUT->flags |= PGOBLIN_PATHPARM | PGOBLIN_FREEPATH;
        ;;  } else {
        ;;      IO_OUT->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER | PGOBLIN_PATHPARM);
        ;;      ERROUT(EX_DATAERR, EINVAL);
        ;;  }
        MARK_IO_PATH_WENT(IO_OUT);;
    } else if (IO_CTL->flags & PGOBLIN_FREETEXT) {
        MARK_IO_PATH_GO(IO_OUT);;
        ;;  if  (!(IO_OUT->path = strdup(IO_CTL->text))) {
        ;;      ifBLIN_QV1(exenv->options->flags) warnx("No mem #cat");
        ;;      ERROUT(EX_OSERR, ENOMEM);
        ;;  } else {
        ;;      IO_OUT->flags &= ~PGOBLIN_FILEOVER;
        ;;      IO_OUT->flags |= PGOBLIN_FREEPATH | PGOBLIN_PATHPARM;
        ;;  }
        MARK_IO_PATH_WENT(IO_OUT);;
    } else {
        MARK_IO_PATH_GO(IO_OUT);;
        ;;  IO_OUT->path = IO_CTL->text;
        ;;  IO_OUT->flags &= ~(PGOBLIN_FREEPATH | PGOBLIN_FILEOVER);
        ;;  IO_OUT->flags |= PGOBLIN_PATHPARM;
        MARK_IO_PATH_WENT(IO_OUT);;
    }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_cat\n");
    return(ex);
}

int
pgoblin_getarg(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_getarg %d\n", r[PGO_COUT].r);
    if  ((ex = getCGIparmarray( 0
                              , (u_char **)( (exenv->options->flags & PGOBLIN_ARGVSTACK)
                                           ? &exenv->options->stack[exenv->options->ap]
                                           : exenv->options->argv
                                           )
                              , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                              , IO_OUT->wri, IO_OUT->onu
        ))                    ) {
        ifBLIN_QV1(exenv->options->flags) warn("getCGIparmarray");
    }
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_getarg %d\n", ex);
    return(ex);
}

int
pgoblin_getenv(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_getenv %d\n", r[PGO_COUT].r);
    if  ((ex = getCGIparmenv( gCGI_RNUM, (const u_char **)exenv->options->envp
                            , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                            , IO_OUT->wri, IO_OUT->onu
        ))                  ) {
        ifBLIN_QV1(exenv->options->flags) warn("getCGIparmenv");
    }
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_getenv %d\n", ex);
    return(ex);
}

int
pgoblin_getget(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_getget %d\n", r[PGO_COUT].r);
    if  ((ex = getCGIparmcopy( gCGI_RNUM | gCGI_SEPR, (u_char*)getenv("QUERY_STRING")
                             , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                             , IO_OUT->wri, IO_OUT->onu
        ))                   ) {
        ifBLIN_QV1(exenv->options->flags) warn("getget getCGIparmcopy");
    }
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_getget %d\n", ex);
    return(ex);
}

int
pgoblin_getpost(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "+pgoblin_getpost %d in %s\n", r[PGO_COUT].r, IO_IN->mife ? "OK" : "NULL");
    if  (mife_read(IO_IN->mife, 0, IO_IN->offset) < 0) {
        ifBLIN_QV1(exenv->options->flags) warn("getpost 1");
        return(EX_OSERR);
    }
    if  ((ex = getCGIparmcopy( gCGI_RNUM | gCGI_SEPR
                             , mife_get(IO_IN->mife, IO_IN->offset)
                             , (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                             , IO_OUT->wri, IO_OUT->onu
        ))                   ) {
        ifBLIN_QV1(exenv->options->flags) warn("getpost getCGIparmcopy");
    }
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_getpost %d\n", ex);
    return(ex);
}

int
pgoblin_getproc(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK;

    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "+pgoblin_getproc %d\n", r[PGO_COUT].r);
    if  ((ex = getCGIparmproc( 0, (u_char*)"any", (u_char*)"\t", (u_char*)"\\N"
                             , IO_OUT->wri, IO_OUT->onu
        ))                   ) {
        ifBLIN_QV1(exenv->options->flags) warn("getCGIparmproc");
    }
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_getproc %d\n", ex);
    return(ex);
}

int
pgoblin_getspq(pgoblin_exenv *exenv, pgoblin_r *r) {
    return(EX_UNAVAILABLE);
}

int
pgoblin_getstr(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK, l, j;
    FILE *fi;
    char *cont;
    ssize_t bl;
    size_t i;

    ifBLIN_QV4(exenv->options->flags)
        fprintf(stderr, "+pgoblin_getstr %d in %s\n", r[PGO_COUT].r, IO_IN->mife ? "OK" : "NULL");
    if  (!(fi = funopen( (void*)(IO_OUT->onu)
                       , NULL, (int (*)(void*, const char*, int))mife_writ, NULL, NULL
        ) )            ) {
        ifBLIN_QV1(exenv->options->flags) warn("funopen #0 on %d", r[PGO_COUT].r);
        ex = EX_OSERR;
    } else {
        for (j = 0, l = 1; !(IO_IN->mife->flag & MIFE_EOFL); IO_IN->offset += bl) {
            if  ((bl = mife_read(IO_IN->mife, 1 << (PGOBLIN_RAWIOBUFL + 16), IO_IN->offset)) < 0) {
                ifBLIN_QV1(exenv->options->flags) warn("getstr mife_read");
                ex = EX_IOERR;
                break;
            }
            if  (!(cont = mife_get(IO_IN->mife, IO_IN->offset))) {
                ifBLIN_QV1(exenv->options->flags) warn("getstr mife_get");
                ex = EX_IOERR;
                break;
            }
            for (i = 0; i < bl; i++, cont++) {
                switch (*cont) {
                    case '\\': if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "\\\\");      break;
                    case '\0': if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "\\0");       break;
                    case '\t': if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "\\t");       break;
                    case '\n': if (l) fprintf(fi, "%d\t", j); l = 1; fprintf(fi, "\n"); j++;   break;
                    default:   if (l) fprintf(fi, "%d\t", j); l = 0; fprintf(fi, "%c", *cont); break;
        }   }   }
        if  (!l) fprintf(fi, "\n");
        fprintf(fi, "\\.\n");
    }
    if  (fclose(fi) < 0) {
        ifBLIN_QV1(exenv->options->flags) warn("fclose #0 on %d", r[PGO_COUT].r);
        ex = EX_OSERR;
    }
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_getstr %d\n", ex);
    return(ex);
}

int
pgoblin_getdir(pgoblin_exenv *exenv, pgoblin_r *r) {
    int ex = EX_OK, i = 0, max, n;
    pgoblin_dir *dir;
    FILE *fi = NULL;
    u_int32_t mode;
    char *q, *s;

    ifBLIN_QV4(exenv->options->flags) {
        fprintf( stderr, "+pgoblin_getdir %d %d %d %d"
               , r[PGO_COUT].r, r[PGO_CJOB].r, r[PGO_CCON].r, r[PGO_CIN].r
               );
        if  (IO_CTL->text) fprintf(stderr, " =%s~", (char*)(IO_CTL->text));
        fprintf(stderr, "\n");
    }
    if  (!IO_CTL->text) {
        ERROUT(EX_DATAERR, EINVAL);
    }
    if  (!(fi = funopen( (void*)(IO_OUT->onu)
                       , NULL, (int (*)(void*, const char*, int))mife_writ, NULL, NULL
        ) )            ) {
        ifBLIN_QV1(exenv->options->flags) warn("funopen #1 on %d", r[PGO_COUT].r);
        ex = EX_OSERR;
    } else {
        mode = strtoul(IO_CTL->text, &q, 0);
    in:
        if  (r[PGO_CIN].r) {
            int j, k, m;

            max = DBASE(IO_IN->flagc)->resinfo(PGOBLIN_Ntuples, IO_IN->pq);
            n = DBASE(IO_IN->flagc)->resinfo(PGOBLIN_Nfields, IO_IN->pq);
            ifBLIN_QV4(exenv->options->flags) fprintf(stderr, " %d @ %d : %d\n", i, max, n);
            switch (n) {
            case 0 : ifBLIN_QV2(exenv->options->flags) warnx("Null name in getdir %d", r[PGO_CCTL].r);
                   ; goto out;
            case 1 : q = DBASE(IO_IN->flagc)->getvalue(IO_IN->pq, i, 0);
                   ; ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "1Dir=%s~\n", q);
                   ; break;
            default: for (j = 0, k = 0; j < n; j++) {
                   ;     if  (!DBASE(IO_IN->flagc)->valinfo(PGOBLIN_IsNull, IO_IN->pq, i, j))
                             k += DBASE(IO_IN->flagc)->valinfo(PGOBLIN_Length, IO_IN->pq, i, j);
                   ; }
                   ; if  (!k) {
                   ;     ifBLIN_QV2(exenv->options->flags)
                             warnx("Empty name in getdir %d", r[PGO_CCTL].r);
                   ;     goto out;
                   ; }
                   ; if  (!(q = malloc(k + 1))) ERROUT(EX_OSERR, ENOMEM);
                   ; for (j = 0, k = 0; j < n; j++) {
                   ;     if  (!DBASE(IO_IN->flagc)->valinfo(PGOBLIN_IsNull, IO_IN->pq, i, j)) {
                   ;         m = DBASE(IO_IN->flagc)->valinfo(PGOBLIN_Length, IO_IN->pq, i, j);
                   ;         bcopy(DBASE(IO_IN->flagc)->getvalue(IO_IN->pq, i, j), &(q[k]), m);
                   ;         k += m;
                   ;         q[k] = '\0';
                   ; }   }
                   ; ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "NDir=%s~\n", q);
            }
        } else { /* MAJORDELETE */
            max = 0, n = 1;
            if  (*q) {
                if  (*q != ' ' && *q != '\t')
                    ifBLIN_QV2(exenv->options->flags)
                        warnx("No white space in getdir %d", r[PGO_CCTL].r);
                q++;
        }   }
        for (dir = NULL; (dir = JOBE(R_JOB->flags)->dir(exenv, dir, q));) {
            if  (q && n > 1) free(q);
            q = dir->ent;
            if  (getCGIparmpass3(0, (u_char*)"copy", (u_char**)&q)) {
                ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_getdir: getCGIparmpass3");
                ex = EX_SOFTWARE;
                goto out;
            }
            s = "";
            if  (mode & 0x01) {
                fprintf(fi, "%d", dir->i);
                s = "\t";
            }
            if  (mode & 0x02) {
                fprintf(fi, "%s%s", s, q);
                s = "\t";
            }
            if  (mode & 0x04) {
                if  (dir->sb) fprintf(fi, "%s%lld", s, (long long)dir->sb->st_size); else fprintf(fi, "%s\\N", s);
                s = "\t";
            }
            if  (mode & 0x08) {
                if  (dir->sb) fprintf(fi, "%s%u", s, dir->sb->st_mode); else fprintf(fi, "%s\\N", s);
                s = "\t";
            }
            if  (mode & 0x10) {
                if  (dir->sb) fprintf(fi, "%s%u", s, dir->sb->st_uid); else fprintf(fi, "%s\\N", s);
                s = "\t";
            }
            if  (mode & 0x20) {
                if  (dir->sb) fprintf(fi, "%s%u", s, dir->sb->st_gid); else fprintf(fi, "%s\\N", s);
                s = "\t";
            }
            fprintf(fi, "\n");
            if  (q != dir->ent) free(q);
            q = NULL;
        }
        if  (++i < max) goto in;
        fprintf(fi, "\\.\n");
    }
out:
    if  (fi && fclose(fi) < 0) {
        ifBLIN_QV1(exenv->options->flags) warn("fclose #1 on %d", r[PGO_COUT].r);
        ex = EX_OSERR;
    }
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_getdir %d\n", ex);
    return(ex);
}
