/*-
 * Copyright (C) @BABOLO  2002 Dec 17
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 17\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_copy.c,v 1.32 2009/10/27 02:01:14 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <mife.h>
#include <err.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include "pgoblin.h"
#include "pgob.h"

enum fich {fn, fs, fp, fo, fx};
enum finde {finde_beg, finde_eol, finde_bsl, finde_dot, finde_end}; /* "\n\\.\n" */
/* static const char *fichn[] = {"fn", "fs", "fp", "fo", "fx"};
 * static const char *finden[] = {"finde_beg", "finde_eol", "finde_bsl", "finde_dot", "finde_end"};
 */

int
pgoblin_copyout(pgoblin_exenv *exenv, pgoblin_r *r) {
    int f;
    void *res;
    void *buf;
    ssize_t e = 0;

    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "+pgoblin_copyout %08X %s out=%d\n"
                                             , R_CONN->flags
                                             , (char*)IO_CTL->text
                                             , r[PGO_COUT].r
                                             );
    if  (!e && !IO_CTL->text) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_copyout: No query");
        e = -1;
        goto out;
    }

    if  (!e) {
        if  ((e = DBASE(R_CONN->flags)->query(R_CONN, &res, IO_CTL->text, PGOBLIN_CR_OUT))) {
            e = -1;
            goto out;
        }
        for (; (f = DBASE(R_CONN->flags)->getcopy(R_CONN, &buf)) > 0 && e >= 0;) {
            ifBLIN_QV3(exenv->options->flags) fprintf(stderr, "%d buf=%s\n", f, (char*)buf);
            if  (strcmp("\\.", buf) == 0) {
                if  (exenv->options->flags & PGOBLIN_COPEND_PASS)
                    e = IO_OUT->wri(IO_OUT->onu, buf, f);
                DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_FrCOPY, &buf);
                break;
            }
            e = IO_OUT->wri(IO_OUT->onu, buf, f);
            DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_FrCOPY, &buf);
        }
        if  (e < 0) {
            ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_copyout: getcopy error");
        }
        DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &res);
        if  (DBASE(R_CONN->flags)->endstream(R_CONN, PGOBLIN_CR_OUT)) {
            e = -1;
            goto out;
    }   }
    if  (e < 0) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_copyout: write error");
    } else if (exenv->options->flags & PGOBLIN_COPEND_APND) {
        e = IO_OUT->wri(IO_OUT->onu, "\\.\n", 0);
    }
    if  (e < 0) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_copyout: write end error");
    }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_copyout %d\n", (int)e);
    return(e < 0 ? (int)e : 0);
}

int
pgoblin_copyin(pgoblin_exenv *exenv, pgoblin_r *r) {
    int e = 0, ee;                                                   /*   putcopy */
    ssize_t f = 0;
    void *res;
    char *q, *d;
    enum finde k;
                                                   /*    "\n\\.\n"    */
    const enum fich fich[256] =
    {fn,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fn,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fp,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fs,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    };
    const u_char automa[finde_end][fx] =
    /*      fn         fs         fp         fo */
    {{ finde_eol, finde_beg, finde_beg, finde_beg} /*finde_beg*/
    ,{ finde_beg, finde_bsl, finde_beg, finde_beg} /*finde_eol*/
    ,{ finde_beg, finde_beg, finde_dot, finde_beg} /*finde_bsl*/
    ,{ finde_end, finde_beg, finde_beg, finde_beg} /*finde_dot*/
    };

    ifBLIN_QV4(exenv->options->flags) fprintf( stderr, "+pgoblin_copyin query=%s\n"
                                             , (char*)IO_CTL->text
                                             );
    d = NULL;                                                                  /*   COPY */
    q = IO_CTL->text;
    if  (!e && !q) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_copyin: No query");
        e = -1;
    }
    if  (!IO_IN->mife) {
        ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_copyin: No input data");
        e = -1;
    }
    if  (!e) {
        if  ((e = DBASE(R_CONN->flags)->query(R_CONN, &res, q, PGOBLIN_CR_IN))) {
            e = -1;
            goto out;
        }
        ifBLIN_QV4(exenv->options->flags)
            fprintf(stderr, "Copy %d columns\n", DBASE(R_CONN->flags)->resinfo(PGOBLIN_Nfields, res));
        DBASE(R_CONN->flags)->finish(R_CONN->flags, PGOBLIN_CleaRes, &res);

        for (k = finde_eol, f = 1, e = 0; f > 0 && e == 0; IO_IN->offset += f) {
            char *ofbase;

            if  ((f = mife_read(IO_IN->mife, PGOBLIN_BUFSIZE, IO_IN->offset)) < 0) {
                ifBLIN_QV1(exenv->options->flags) warn("pgoblin_copyin: mife_read");
                e = -1;
            }
            ifBLIN_QV5(exenv->options->flags) fprintf(stderr, "mife_read=%d,", BLIN_I(f));
            ofbase = mife_get(IO_IN->mife, IO_IN->offset);
            if  (!e) {
                for (q = ofbase; q < (ofbase + f) && k != finde_end; k = automa[k][fich[(u_char)*q++]])
                    ifBLIN_QV5(exenv->options->flags) fprintf(stderr, "%c", *q);
                if  (q - ofbase) {
                    e = DBASE(R_CONN->flags)->putcopy(R_CONN, ofbase, q - ofbase) < 1;
                    ifBLIN_QV4(exenv->options->flags)
                        fprintf(stderr, "putcopy=%d %d (%d)\n", e, k, BLIN_I(q - ofbase));
                } else ifBLIN_QV4(exenv->options->flags) {
                    fprintf(stderr, "no putcopy %d (%d)\n", k, BLIN_I(q - ofbase));
        }   }   }
        if  (!e && k != finde_end) {                       /*  ()    */
            const char *enstin = "\n\\.\n";
            ifBLIN_QV3(exenv->options->flags) fprintf(stderr, "end=%s~%d\n", &enstin[k], finde_end - k);
            e = DBASE(R_CONN->flags)->putcopy(R_CONN, &enstin[k], finde_end - k) < 1;
            ifBLIN_QV4(exenv->options->flags)
                fprintf(stderr, "\nputcopy=%d %d (%d)\n", e, k, finde_end - k);
        }
        if  (e) {                                               /*       */
            ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_copyin: putcopy failed");
            e = -1;
        }
        ee = DBASE(R_CONN->flags)->endstream(R_CONN, PGOBLIN_CR_IN);
        if  (!e && (ee < 0)) {                                  /*       */
            e = -1;
            ifBLIN_QV1(exenv->options->flags) warnx("pgoblin_copyin: endcopy failed");
    }   }
out:
    ifBLIN_QV4(exenv->options->flags) fprintf(stderr, "-pgoblin_copyin %d\n", e);
    return(e);
}
