/*-
 * Copyright (C) @BABOLO  2002 Dec 23
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 23\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: vdump.c,v 1.1 2005/03/15 02:35:11 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include <libpq-fe.h>
#include "pgoblin.h"

extern const pgoblin_cmdc pgoblin_cmds[];

void
pgoblin_Vdump(pgoblin_con *options, pgoblin_p *pgm) {
    pnode p;

    ifBLIN_QV3(options->flag) {
        if  (pgm) fprintf(stderr, "+pgoblin_Vdump pgm=%d\n", pgm->maxx);
          else fprintf( stderr, "+pgoblin_Vdump pgm=NULL\n");
    }
    for (p = 0; p < pgm->maxx; p++) {
        ifBLIN_QV4(options->flag) printf("#!--V %d\n", p);
        printf("#%s\n", pgoblin_cmds[pgm->code[p].cmd].str);
        if  (pgoblin_cmds[pgm->code[p].cmd].kind & TEXTPARM) printf("%s\n", pgm->code[p].parm);
    }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_Vdump\n");
    return;
};
