#!/bin/sh

prog="`pwd`/pgoblin ${1}"
TF=`mktemp -t pgoblin` || exit 1
TP=`mktemp -t pgoblin` || exit 1
TR=`mktemp -t pgoblin` || exit 1
TI=`mktemp -t pgoblin` || exit 1
${prog} -D 'DROP TABLE pgoblin_test_table' || true
t=0
e=0

echo '= 0 ==='
EXFILE(dnl
#perform
CREATE TABLE pgoblin_test_table
     ( t text
     , i int
     ))

COPYIN(,dnl
#copyin
COPY pgoblin_test_table FROM stdin,dnl
test	0
test	1)

COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	2
')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	3
\.')
COPYIN(BC,'COPY pgoblin_test_table FROM stdin','test	4
\.
')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	5')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	6
')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	7
\')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	8
\.')
COPYIN(C,'COPY pgoblin_test_table FROM stdin','test	9
\.
')

echo '= 1 ==='
define(CONst1,dnl
|test|0|
|test|1|
|test|2|
|test|3|
|test|4|
|test|5|
|test|6|
|test|7|
|test|8|
|test|9|)dnl

SELECTEST(s,"SELECT '|', t, '|', i, '|
' FROM pgoblin_test_table",CONst1)

SELECTEST(,#select
SELECT '|', t, '|', i, '|
' FROM pgoblin_test_table,CONst1)

SELECTEST(,#strselect
SELECT '|', t, '|', i, '|
' FROM pgoblin_test_table,CONst1)

echo '= 2 ==='
define(CONst1,dnl
test	0
test	1
test	2
test	3
test	4
test	5
test	6
test	7
test	8
test	9)dnl

SELECTEST(c,'COPY pgoblin_test_table TO stdin',CONst1)

SELECTEST(,#copyout
COPY pgoblin_test_table TO stdin,CONst1)

SELECTBIN(S,'SELECT * FROM pgoblin_test_table',dnl
begin 644 test
M=&5S=`````!T97-T`````71E<W0````"=&5S=`````-T97-T````!'1E<W0`
C```%=&5S=`````9T97-T````!W1E<W0````(=&5S=`````D`
`
end)

SELECTBIN(,#binselect 
SELECT * FROM pgoblin_test_table,dnl
begin 644 test
M=&5S=`````!T97-T`````71E<W0````"=&5S=`````-T97-T````!'1E<W0`
C```%=&5S=`````9T97-T````!W1E<W0````(=&5S=`````D`
`
end)

echo '= 3 ==='
inTEXT(tset	10)
SELECTEST(,dnl
#copyin 
COPY pgoblin_test_table FROM stdin
#strselect 
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
#select 
SELECT t, ' ', i, i * i, '
' FROM pgoblin_test_table
#copyout 
COPY pgoblin_test_table TO stdout
#perform
DELETE FROM pgoblin_test_table WHERE i = 10

,test 00
test 11
test 24
test 39
test 416
test 525
test 636
test 749
test 864
test 981
tset 10100
test 00
test 11
test 24
test 39
test 416
test 525
test 636
test 749
test 864
test 981
tset 10100
test	0
test	1
test	2
test	3
test	4
test	5
test	6
test	7
test	8
test	9
tset	10)

SELECTEST(D,'DROP TABLE pgoblin_test_table')

echo '= 4 ==='
define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text)
#getpost
#copyin
COPY p FROM stdin
#copyout
COPY p TO stdin)dnl

inCONS('')
SELECTEST(,CONst1,0	\N	)

inCONS('nf95')
SELECTEST(,CONst1,0	\N	nf95)

inCONS('nfh95=')
SELECTEST(,CONst1,0	nfh95	)

inCONS('nfh95=lk')
SELECTEST(,CONst1,0	nfh95	lk)

inCONS('nfh95=lkjb&')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	)

inCONS('nfh95=lkjb&gjnh')
SELECTEST(,CONst1,0	nfh95	lkjb
1	\N	gjnh)

inCONS('nfh95=lkjb&kn=')
SELECTEST(,CONst1,0	nfh95	lkjb
1	kn	)

inTEXT(nfh9=kjb&knr=r&idfj=ns)
SELECTEST(,CONst1,0	nfh9	kjb
1	knr	r
2	idfj	ns)

echo '= 5 ==='
define(CONst1,#perform
CREATE TEMP TABLE a(n int, e text, c text)
#getget
#copyin
COPY a FROM stdin
#copyout
COPY a TO stdin)dnl

unset QUERY_STRING || true
SELECTEST(,CONst1)

export QUERY_STRING=''
SELECTEST(,CONst1,0	\N	)

export QUERY_STRING='kjn=er&kjb'
SELECTEST(,CONst1,0	kjn	er
1	\N	kjb)

echo '= 6 ==='
define(CONst1,#perform
CREATE TEMP TABLE p(n int, e text, c text);
CREATE TEMP TABLE a(n int, c text);
CREATE TEMP TABLE e(n int, e text, c text);
CREATE TEMP TABLE g(n int, e text, c text)
#getpost
#copyin
COPY p FROM stdin
#getarg
#copyin
COPY a FROM stdin
#getenv
#copyin
COPY e FROM stdin
#getget
#copyin
COPY g FROM stdin
#echo
  :

#select
SELECT COALESCE(e, '?') || ' = ' || COALESCE(c, '?') || '
' FROM e
 WHERE e IN('TEST_STRING1', 'TEST_STRING2', 'QUERY_STRING')
ORDER BY e
#select
SELECT COALESCE(text(n), '?') || '=' || COALESCE(c, '?') || '
' FROM a
#select
SELECT COALESCE(text(n), '?') || ': ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM g
#select
SELECT COALESCE(text(n), '?') || '! ' || COALESCE(e, '?') || '=' || COALESCE(c, '?') || '
' FROM p
#perform
DROP TABLE p;
DROP TABLE a;
DROP TABLE e;
DROP TABLE g;)dnl

export TEST_STRING1='lefn'
export TEST_STRING2='8r7wv'
inTEXT(bnu)
SELECTEST(=,CONst1,dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
EOF
cat << EOF >> ${TP}
0=${TF}
EOF
cat << "EOF" >> ${TP}
0: kjn=er
1: ?=kjb
0! ?=bnu)

inTEXT(bnu)
SELECTEST(f,${TF},dnl
  :
QUERY_STRING = kjn=er&kjb
TEST_STRING1 = lefn
TEST_STRING2 = 8r7wv
0: kjn=er
1: ?=kjb
0! ?=bnu)

echo '= 7 ==='
define(CONst1,dnl
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.)

SELECTEST(,#cat
tools/LICENSE,CONst1)

SELECTEST(,#cat
tools/LICENSE
#echo
=== Test Done ===

,CONst1
=== Test Done ===
)

dnl inTEXT()
dnl SELECTEST(,,)

rm -f ${TF} ${TP} ${TR} ${TI}
echo "${e} errors"
