/*-
 * Copyright (C) @BABOLO  2002 Dec 04
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 04\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: shurecon.c,v 1.6 2004/11/29 20:36:18 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

static void
NoticeProcessor(void *options, const char *message) {
    ifBLIN_QV1(((pgoblin_con *)options)->flag) fprintf(stderr, "%s", message);
}

int
pgoblin_shurecon(pgoblin_con *options) {
    if  (options->conn != NULL && PQstatus(options->conn) == CONNECTION_OK) return(0);
    options->conn = PQsetdbLogin( options->host
                                , options->port
                                , NULL, NULL
                                , options->dbname
                                , options->username
                                , NULL
                                );
    ifBLIN_QV3(options->flag) fprintf(stderr, "PQstatus %d\n", PQstatus(options->conn));
    PQsetNoticeProcessor(options->conn, NoticeProcessor, options);
    if  (PQstatus(options->conn) != CONNECTION_BAD) return(0);
    ifBLIN_QV1(options->flag)
        warnx("Connection to PostgreSQL failed: %s\n", PQerrorMessage(options->conn));
    return(1);
}
