/*-
 * Copyright (C) @BABOLO  2002 Dec 04
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: pgoblin.h,v 1.10 2005/10/24 14:24:25 babolo Exp $
 */

#define TEXTPARM 0x00001
typedef int pnode;

#define BUFSIZE 8192
#define BUFMULT 2
#define RAWIOBUFL 1

#define PQEXEC(RESULT, QUERY, CONDITION, CCODE) {                                                    \
    ifBLIN_QV3(options->flag) fprintf(stderr, "PQexec: %s\n", QUERY);                                \
    (RESULT) = PQexec(options->conn, (QUERY));                                                       \
    if  (!(RESULT)) {                                                                                \
        ifBLIN_QV1(options->flag) warnx("result is absent - fatal error.\n"); return(CCODE);         \
    }                                                                                                \
    ifBLIN_QV3(options->flag) fprintf(stderr, "PQresultStatus %d\n", PQresultStatus(res));           \
    if  (PQresultStatus(res) != (CONDITION)) {                                                       \
        if  (PQresultStatus(res) == PGRES_FATAL_ERROR) {                                             \
            ifBLIN_QV1(options->flag) warnx("PQexec failed: %s", PQresultErrorMessage(RESULT));      \
            return(CCODE);                                                                           \
        } else if ((CONDITION) == PGRES_COMMAND_OK && PQresultStatus(res) == PGRES_TUPLES_OK) {      \
            ifBLIN_QV2(options->flag) warnx("PQexec wait for COMMAND_OK but received TUPLES_OK");    \
        } else ifBLIN_QV1(options->flag) {                                                           \
            warnx("PQexec wait for %d but received %d", (CONDITION), PQresultStatus(res));           \
            return(CCODE);                                                                           \
}   }   }

typedef enum
{ pgob_null
, pgob_copyin
, pgob_copyout
, pgob_binselect
, pgob_strselect
, pgob_select
, pgob_perform
, pgob_getarg
, pgob_getenv
, pgob_getget
, pgob_getpost
, pgob_echo
, pgob_cat
, pgob_bang
, pgob_illegal
} pgoblin_cmd;

typedef struct {
    char     *str;
    u_int32_t kind;
} pgoblin_cmdc;

typedef struct {
    pgoblin_cmd cmd;
    char *parm;
} code_t;

typedef struct {
    pnode   maxx;
    code_t *code;
} pgoblin_p;

typedef struct {
    char *tbeg;
    char *tend;
    char *rbeg;
    char *rmed;
    char *rend;
    char *cbeg;
    char *cmed;
    char *cend;
} pgoblin_tab;

typedef struct {
    u_int32_t flag;
#   define   DUMP_PARSED  0x000001
    char     *dbname;
    char     *host;
    char     *port;
    char     *username;
    PGconn   *conn;
    pgoblin_tab *tdl;
    u_char    intran;
    char    **argv;
    char    **envp;
} pgoblin_con;

int      pgoblin_shurecon __P((pgoblin_con *));
pgoblin_p *pgoblin_parser __P((pgoblin_con *, struct mife_descriptor *));
void        pgoblin_Vdump __P((pgoblin_con *, pgoblin_p *));
int        pgoblin_copyin __P((pgoblin_con *, char *, struct mife_descriptor *));
int       pgoblin_copyout __P((pgoblin_con *, char *, int));
int        pgoblin_binsel __P((pgoblin_con *, char *, int));
int        pgoblin_strsel __P((pgoblin_con *, char *, int));
int       pgoblin_perform __P((pgoblin_con *, char *));
PGresult   *pgoblin_sel_q __P((pgoblin_con *, char *));
int         pgoblin_sel_p __P((pgoblin_con *, PGresult *, int));
int       pgoblin_execute __P((pgoblin_con *, pgoblin_p *, struct mife_descriptor *, int));
int        pgoblin_getarg __P((pgoblin_con *, int));
int        pgoblin_getenv __P((pgoblin_con *, int));
int        pgoblin_getget __P((pgoblin_con *, int));
int       pgoblin_getpost __P((pgoblin_con *, struct mife_descriptor *, int));
int          pgoblin_echo __P((pgoblin_con *, char *, int));
int           pgoblin_cat __P((pgoblin_con *, char *, int));

