/*-
 * Copyright (C) @BABOLO  2002 Dec 04
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 04\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pgoblin.c,v 1.11 2005/03/15 02:35:11 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

struct inin {
    int i;
    char *pgmconst;
    char *pgmfile;
    char *arg;
};
pgoblin_tab tdl = {NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL};

static void
usage(int ex) {
    fprintf(stderr, "pgoblin " VERS "  " DATE "
Usage:
pgoblin [-Bqv ][-D Query ][-s Query ][-S Query ][-c Query ][-C Query ][-d DataBase ][-h Hostname ][-p Port ][-U User ][-f QueryFile] args
    -f QueryFile
    -d DataBase name
    -h Hostname of backend server
    -p Port
____-U Username
    -c COPY out
    -C COPY in
    -D perform query without result
    -s SELECT
____-S SELECT BINARY emulation
    -q quiet
    -v verbose
");
    exit(ex);
}

static struct mife_descriptor *
pgmin(u_int32_t flag, struct inin *inin) {
    struct mife_descriptor *in = NULL;

    ifBLIN_QV3(flag) fprintf(stderr, "inin %d->", inin->i);
    if  (inin->i < 1 && inin->pgmconst) {
        ifBLIN_QV3(flag) fprintf(stderr, "0:%s~\n", inin->pgmconst);
        if  (!(in = mife_opem(MIFE_FULL, inin->pgmconst, strlen(inin->pgmconst) + 1))) {
            ifBLIN_QV1(flag) warn("Const pgm");
            exit(EX_NOINPUT);
        }
        inin->i = 1;
    } else if (inin->i < 2 && inin->pgmfile) {
        ifBLIN_QV3(flag) fprintf(stderr, "1:%s~\n", inin->pgmfile);
        if  (!(in = mife_open(MIFE_FULL, inin->pgmfile))) {
            ifBLIN_QV1(flag) warn("file %s", inin->pgmfile);
            exit(EX_NOINPUT);
        }
        inin->i = 2;
    } else if (inin->i < 3 && inin->arg) {
        ifBLIN_QV3(flag) fprintf(stderr, "2:%s~\n", inin->arg);
        if  (!(in = mife_open(MIFE_FULL, inin->arg))) {
            ifBLIN_QV1(flag) warn("file %s", inin->arg);
            exit(EX_NOINPUT);
        }
        inin->i = 3;
    } else if (inin->i < 4) {
        ifBLIN_QV3(flag) fprintf(stderr, "3: stdin\n");
        if  (!(in = mife_opef(MIFE_FULL, fileno(stdin)))) {
            ifBLIN_QV1(flag) warn("stdin");
            exit(EX_NOINPUT);
        }
        inin->i = 4;
    } else {
            ifBLIN_QV3(flag) fprintf(stderr,"big: %d\n", inin->i);
    }
    return(in);
}

static char *
rediropt(u_int32_t flag, char *optarg, int redirenv) {
    char *cr;
    if  (redirenv > 0) {
        if  (!(cr = getenv(optarg))) {
            ifBLIN_QV1(flag) warnx("No ENV %s", optarg);
            exit(EX_USAGE);
        }
    }else{
        cr = optarg;
    }
    return(cr);
}

static void
cmdin(u_int32_t flag, int redirenv, pgoblin_p *pgm, pgoblin_cmd cmd, char *optarg) {
    if  (pgm->maxx) usage(EX_USAGE);
    if  (!(pgm->code = malloc(sizeof(code_t)))) errx(EX_UNAVAILABLE, "Malloc failed #3\n");
    pgm->code->cmd = cmd;
    pgm->code->parm = rediropt(flag, optarg, redirenv);
    pgm->maxx++;
}

int
main(int argc, char *argv[], char **envp) {
    pgoblin_con *options = malloc(sizeof(pgoblin_con));
    pgoblin_p *pgm = malloc(sizeof(*pgm));
    int out = fileno(stdout);
    struct mife_descriptor *in;
    int c, redirenv, ex = EX_OK;
    struct inin inin;

    inin.i = 0;
    inin.pgmfile = NULL;
    inin.pgmconst = NULL;
    if  (options == NULL) errx(EX_UNAVAILABLE, "Malloc failed #1\n");
    bzero(options, sizeof(pgoblin_con));
    options->tdl = &tdl;
    options->flag = BLIN_VER1;
    options->envp = envp;
    if  (pgm == NULL) errx(EX_UNAVAILABLE, "Malloc failed #2\n");
    bzero(pgm, sizeof(*pgm));
    pgm->maxx = 0;
    for (redirenv = 0; (c = getopt(argc, argv, "Bc:C:d:D:e:Ef:h:p:qs:S:U:vV?")) != EOF; redirenv--) {
        if  (redirenv < 0) redirenv = 0;
        switch (c) {
        case 'B':                                                                                break;
        case 'c': cmdin(options->flag, redirenv, pgm, pgob_copyout, optarg);                     break;
        case 'C': cmdin(options->flag, redirenv, pgm, pgob_copyin, optarg);                      break;
        case 'd': options->dbname = rediropt(options->flag, optarg, redirenv);                   break;
        case 'D': cmdin(options->flag, redirenv, pgm, pgob_perform, optarg);                     break;
        case 'e': inin.pgmconst = rediropt(options->flag, optarg, redirenv);                     break;
        case 'E': redirenv = 2;                                                                  break;
        case 'f': inin.pgmfile = rediropt(options->flag, optarg, redirenv);                      break;
        case 'h': options->host = rediropt(options->flag, optarg, redirenv);                     break;
        case 'p': options->port = rediropt(options->flag, optarg, redirenv);                     break;
        case 'q': options->flag &= ~BLIN_VERMASK;                                                break;
        case 's': cmdin(options->flag, redirenv, pgm, pgob_strselect, optarg);                   break;
        case 'S': cmdin(options->flag, redirenv, pgm, pgob_binselect, optarg);                   break;
        case 'U': options->username = rediropt(options->flag, optarg, redirenv);                 break;
        case 'v': BLIN_VERBOSE(options->flag);                                                   break;
        case 'V': options->flag |= DUMP_PARSED;                                                  break;
        case '?': usage(EX_OK);
        default:  usage(EX_USAGE);
    }   }
    argc -= optind;
    argv += optind;
    options->argv = argv;
    inin.arg = (argc > 0 && argv && *argv) ? *argv : NULL;
    in = pgmin(options->flag, &inin);

    if  (pgm->maxx == 0) {
        free(pgm);
        if  ((pgm = pgoblin_parser(options, in)) == NULL) {
            ifBLIN_QV1(options->flag) warnx("Parser failed");
            exit(EX_DATAERR);
        }
        in = pgmin(options->flag, &inin);
    }

    if  (options->flag & DUMP_PARSED) pgoblin_Vdump(options, pgm);
    if  ((ex = pgoblin_execute(options, pgm, in, out)))
                                                     ifBLIN_QV1(options->flag) warnx("Execute failed");
    if  (options->conn) PQfinish(options->conn);
    exit(ex);
}
