/*-
 * Copyright (C) @BABOLO  2002 Dec 23
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 23\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: parser.c,v 1.8 2005/10/24 05:18:37 gd Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

const pgoblin_cmdc pgoblin_cmds[] =
{ {""         , 0}
, {"copyin"   , TEXTPARM}
, {"copyout"  , TEXTPARM}
, {"binselect", TEXTPARM}
, {"strselect", TEXTPARM}
, {"select"   , TEXTPARM}
, {"perform"  , TEXTPARM}
, {"getarg"   , 0}
, {"getenv"   , 0}
, {"getget"   , 0}
, {"getpost"  , 0}
, {"echo"     , TEXTPARM}
, {"cat"      , TEXTPARM}
, {"!"        , 0}
, {NULL       , 0}
};

static pgoblin_p *
pgoblin_init() {
    pgoblin_p *pgm;
    code_t *ppole;

    ppole = malloc(sizeof(code_t) * BUFSIZE);
    pgm = malloc(sizeof(pgoblin_p));
    pgm->maxx = 0;
    pgm->code = ppole;
    return(pgm);
}

static pnode
pgoblin_new(pgoblin_p *pgm) {
    if  (pgm->maxx >= BUFSIZE) errx(EX_SOFTWARE, "Programm too big");
    return(pgm->maxx++);
}

static pgoblin_cmd
pgoblin_seach(u_int32_t flag, char **q) {
    pgoblin_cmd cmd, i = pgob_null;
    size_t l = 0;

    ifBLIN_QV3(flag) {
        int j;
        fprintf(stderr, "+pgoblin_seach ~");
        for (j = 0; ((*q)[j] & 0xFF) >= ' '; j++) fputc((*q)[j], stderr);
        fprintf(stderr, "~...\n");
    }
    while (q && *q && **q == ' ') (*q)++;
    for (cmd = pgob_null; pgoblin_cmds[cmd].str; cmd++) {
        if  (l < strlen(pgoblin_cmds[cmd].str) && 0 == strncmp(*q, pgoblin_cmds[cmd].str, strlen(pgoblin_cmds[cmd].str))) {
            l = strlen(pgoblin_cmds[cmd].str);
            i = cmd;
    }   }
    if  (pgoblin_cmds[i].str) *q += strlen(pgoblin_cmds[i].str);
    ifBLIN_QV3(flag) {
        int j;
        fprintf(stderr, "-pgoblin_seach %d ~", i);
        for (j = 0; ((*q)[j] & 0xFF) >= ' '; j++) fputc((*q)[j], stderr);
        fprintf(stderr, "~...\n");
    }
    return(i);
}

pgoblin_p *
pgoblin_parser(pgoblin_con *options, struct mife_descriptor *in) {
    pgoblin_p *pgm;
    pgoblin_cmd cmd;
    char *delim, *q;
    pnode ci;

    ifBLIN_QV3(options->flag) fprintf(stderr, "+pgoblin_parser in=%s\n", in ? "OK" : "NULL");
    if  (pgoblin_shurecon(options)) return(NULL);
    if  (mife_read(in, 0, 0, NULL) <= 0 || !(q = mife_get(in, 0))) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_parser: No program");
        return(NULL);
    }

    delim = "#";
    pgm = pgoblin_init();
    while (*q) {
        ifBLIN_QV3(options->flag) {
            int i = 0;
            fprintf(stderr, "Next cmd ~");
            for (i = 0; (q[i] & 0xFF) >= ' '; i++) fputc(q[i], stderr);
            fprintf(stderr, "~\n");
        }
        if  (0 != strncmp(delim, q, strlen(delim))) {
            ifBLIN_QV1(options->flag) warnx("pgoblin_parser: No command");
            return(NULL);
        }
        q += strlen(delim);
        cmd = pgoblin_seach(options->flag, &q);
        if  (cmd == pgob_illegal) {
            ifBLIN_QV1(options->flag) errx(EX_DATAERR, "syntax");
            exit(EX_DATAERR);
        }
        ci = pgoblin_new(pgm);
        pgm->code[ci].cmd = cmd;
        while (*q && *q != '\n') q++;
        if  (*q) *q++ = '\0';
        ifBLIN_QV3(options->flag)
            fprintf(stderr, "cmd=%d(%s) %08X\n", cmd, pgoblin_cmds[cmd].str, pgoblin_cmds[cmd].kind);
        if  (pgoblin_cmds[cmd].kind & TEXTPARM) {
            int i = 0;
            pgm->code[ci].parm = q;
            while (*q && 0 != strncmp(delim, q, strlen(delim))) {
                ifBLIN_QV4(options->flag) fprintf(stderr, "Next line~%s~\n", q);
                while (*q && *q != '\n') q++;
                q++;
                i = 1;
            }
            if  (i) *(q - 1) = '\0';
              else pgm->code[ci].parm = "";
        } else {
            pgm->code[ci].parm = NULL;
        }
    }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_parser %s\n", pgm ? "OK" : "NULL");
    return(pgm);
}
